/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;

public final class Region
extends Resource {
    public long handle;

    public Region() {
        this(null);
    }

    public Region(Device device) {
        super(device);
        this.handle = OS.gdk_region_new();
        if (this.handle == 0L) {
            SWT.error(2);
        }
        this.init();
    }

    Region(Device device, long l) {
        super(device);
        this.handle = l;
    }

    static long gdk_region_polygon(int[] nArray, int n, int n2) {
        int n3;
        long l;
        int n4;
        int n5;
        if (!OS.GTK3) {
            return OS.gdk_region_polygon(nArray, n, n2);
        }
        int n6 = n5 = nArray[0];
        int n7 = n4 = nArray[1];
        int n8 = n * 2;
        for (int i = 2; i < n8; i += 2) {
            int n9 = nArray[i];
            int n10 = nArray[i + 1];
            if (n9 < n5) {
                n5 = n9;
            }
            if (n9 > n6) {
                n6 = n9;
            }
            if (n10 < n4) {
                n4 = n10;
            }
            if (n10 <= n7) continue;
            n7 = n10;
        }
        long l2 = Cairo.cairo_image_surface_create(0, n6 - n5, n7 - n4);
        if (l2 == 0L) {
            SWT.error(2);
        }
        if ((l = Cairo.cairo_create(l2)) == 0L) {
            SWT.error(2);
        }
        Cairo.cairo_move_to(l, nArray[0] - n5, nArray[1] - n4);
        for (n3 = 2; n3 < n8; n3 += 2) {
            Cairo.cairo_line_to(l, nArray[n3] - n5, nArray[n3 + 1] - n4);
        }
        Cairo.cairo_close_path(l);
        Cairo.cairo_set_source_rgb(l, 1.0, 1.0, 1.0);
        n3 = 0;
        if (n2 == 0) {
            n3 = 1;
        }
        Cairo.cairo_set_fill_rule(l, n3);
        Cairo.cairo_fill(l);
        Cairo.cairo_destroy(l);
        long l3 = OS.gdk_cairo_region_create_from_surface(l2);
        OS.gdk_region_offset(l3, n5, n4);
        Cairo.cairo_surface_destroy(l2);
        return l3;
    }

    static void gdk_region_get_rectangles(long l, long[] lArray, int[] nArray) {
        if (!OS.GTK3) {
            OS.gdk_region_get_rectangles(l, lArray, nArray);
            return;
        }
        int n = Cairo.cairo_region_num_rectangles(l);
        if (nArray != null) {
            nArray[0] = n;
        }
        lArray[0] = OS.g_malloc(GdkRectangle.sizeof * n);
        for (int i = 0; i < n; ++i) {
            Cairo.cairo_region_get_rectangle(l, i, lArray[0] + (long)(i * GdkRectangle.sizeof));
        }
    }

    public void add(int[] nArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        if (nArray.length < 6) {
            return;
        }
        long l = Region.gdk_region_polygon(nArray, nArray.length / 2, 0);
        OS.gdk_region_union(this.handle, l);
        OS.gdk_region_destroy(l);
    }

    public void add(Rectangle rectangle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.add(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void add(int n, int n2, int n3, int n4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (n3 < 0 || n4 < 0) {
            SWT.error(5);
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        gdkRectangle.x = n;
        gdkRectangle.y = n2;
        gdkRectangle.width = n3;
        gdkRectangle.height = n4;
        OS.gdk_region_union_with_rect(this.handle, gdkRectangle);
    }

    public void add(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.gdk_region_union(this.handle, region.handle);
    }

    public boolean contains(int n, int n2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return OS.gdk_region_point_in(this.handle, n, n2);
    }

    public boolean contains(Point point) {
        if (point == null) {
            SWT.error(4);
        }
        return this.contains(point.x, point.y);
    }

    void destroy() {
        OS.gdk_region_destroy(this.handle);
        this.handle = 0L;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Region)) {
            return false;
        }
        Region region = (Region)object;
        return this.handle == region.handle;
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.gdk_region_get_clipbox(this.handle, gdkRectangle);
        return new Rectangle(gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
    }

    public static Region gtk_new(Device device, long l) {
        return new Region(device, l);
    }

    public int hashCode() {
        return (int)this.handle;
    }

    public void intersect(Rectangle rectangle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.intersect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void intersect(int n, int n2, int n3, int n4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (n3 < 0 || n4 < 0) {
            SWT.error(5);
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        gdkRectangle.x = n;
        gdkRectangle.y = n2;
        gdkRectangle.width = n3;
        gdkRectangle.height = n4;
        long l = OS.gdk_region_rectangle(gdkRectangle);
        OS.gdk_region_intersect(this.handle, l);
        OS.gdk_region_destroy(l);
    }

    public void intersect(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.gdk_region_intersect(this.handle, region.handle);
    }

    public boolean intersects(int n, int n2, int n3, int n4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        gdkRectangle.x = n;
        gdkRectangle.y = n2;
        gdkRectangle.width = n3;
        gdkRectangle.height = n4;
        return OS.gdk_region_rect_in(this.handle, gdkRectangle) != 1L;
    }

    public boolean intersects(Rectangle rectangle) {
        if (rectangle == null) {
            SWT.error(4);
        }
        return this.intersects(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public boolean isDisposed() {
        return this.handle == 0L;
    }

    public boolean isEmpty() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return OS.gdk_region_empty(this.handle);
    }

    public void subtract(int[] nArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        if (nArray.length < 6) {
            return;
        }
        long l = Region.gdk_region_polygon(nArray, nArray.length / 2, 0);
        OS.gdk_region_subtract(this.handle, l);
        OS.gdk_region_destroy(l);
    }

    public void subtract(Rectangle rectangle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.subtract(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void subtract(int n, int n2, int n3, int n4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (n3 < 0 || n4 < 0) {
            SWT.error(5);
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        gdkRectangle.x = n;
        gdkRectangle.y = n2;
        gdkRectangle.width = n3;
        gdkRectangle.height = n4;
        long l = OS.gdk_region_rectangle(gdkRectangle);
        OS.gdk_region_subtract(this.handle, l);
        OS.gdk_region_destroy(l);
    }

    public void subtract(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.gdk_region_subtract(this.handle, region.handle);
    }

    public void translate(int n, int n2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.gdk_region_offset(this.handle, n, n2);
    }

    public void translate(Point point) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (point == null) {
            SWT.error(4);
        }
        this.translate(point.x, point.y);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Region {*DISPOSED*}";
        }
        return "Region {" + this.handle + "}";
    }
}

