/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSLayoutManager;
import org.eclipse.swt.internal.cocoa.NSMutableAttributedString;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTextAttachment;
import org.eclipse.swt.internal.cocoa.NSTextContainer;
import org.eclipse.swt.internal.cocoa.NSTextStorage;
import org.eclipse.swt.internal.cocoa.NSTextTab;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTTextAttachmentCell;
import org.eclipse.swt.internal.cocoa.id;

public final class TextLayout
extends Resource {
    NSTextStorage textStorage;
    NSLayoutManager layoutManager;
    NSTextContainer textContainer;
    Font font;
    String text = "";
    StyleItem[] styles = new StyleItem[2];
    int stylesCount;
    int spacing;
    int ascent = -1;
    int descent = -1;
    int indent;
    int wrapIndent;
    boolean justify;
    int alignment = 16384;
    int[] tabs;
    int[] segments;
    char[] segmentsChars;
    int wrapWidth = -1;
    int orientation = 0x2000000;
    int[] lineOffsets;
    NSRect[] lineBounds;
    static Callback textLayoutCallback2;
    static final byte[] SWT_OBJECT;
    static final int TAB_COUNT = 32;
    static final int UNDERLINE_THICK = 65536;
    static final RGB LINK_FOREGROUND;
    int[] invalidOffsets;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';

    public TextLayout(Device device) {
        super(device);
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.stylesCount = 2;
        this.init();
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    float[] computePolyline(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n4 - n2;
        int n7 = 2 * n6;
        int n8 = Compatibility.ceil(n3 - n, n7);
        if (n8 == 0 && n3 - n > 2) {
            n8 = 1;
        }
        if ((n5 = (2 * n8 + 1) * 2) < 0) {
            return new float[0];
        }
        float[] fArray = new float[n5];
        for (int i = 0; i < n8; ++i) {
            int n9 = 4 * i;
            fArray[n9] = n + n7 * i;
            fArray[n9 + 1] = n4;
            fArray[n9 + 2] = fArray[n9] + (float)(n7 / 2);
            fArray[n9 + 3] = n2;
        }
        fArray[n5 - 2] = n + n7 * n8;
        fArray[n5 - 1] = n4;
        return fArray;
    }

    void computeRuns() {
        Object object;
        Object object2;
        int n;
        if (this.lineBounds != null) {
            return;
        }
        String string = this.getSegmentsText();
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        NSString nSString = (NSString)new NSString().alloc();
        nSString = nSString.initWithCharacters(cArray, cArray.length);
        NSMutableAttributedString nSMutableAttributedString = (NSMutableAttributedString)new NSMutableAttributedString().alloc();
        nSMutableAttributedString.id = nSMutableAttributedString.initWithString((NSString)nSString).id;
        nSString.release();
        nSMutableAttributedString.beginEditing();
        Font font = this.font != null ? this.font : this.device.systemFont;
        NSRange nSRange = new NSRange();
        nSRange.length = nSMutableAttributedString.length();
        nSMutableAttributedString.addAttribute(OS.NSFontAttributeName, font.handle, nSRange);
        nSMutableAttributedString.addAttribute(OS.NSLigatureAttributeName, NSNumber.numberWithInt(0), nSRange);
        font.addTraits(nSMutableAttributedString, nSRange);
        NSMutableParagraphStyle nSMutableParagraphStyle = (NSMutableParagraphStyle)new NSMutableParagraphStyle().alloc().init();
        int n2 = 0;
        if (this.wrapWidth != -1) {
            if (this.justify) {
                n2 = 3;
            } else {
                switch (this.alignment) {
                    case 0x1000000: {
                        n2 = 2;
                        break;
                    }
                    case 131072: {
                        n2 = 1;
                    }
                }
            }
        }
        if ((this.orientation & 0x4000000) != 0) {
            nSMutableParagraphStyle.setBaseWritingDirection(1L);
        } else {
            nSMutableParagraphStyle.setBaseWritingDirection(0L);
        }
        nSMutableParagraphStyle.setAlignment(n2);
        nSMutableParagraphStyle.setLineSpacing(this.spacing);
        nSMutableParagraphStyle.setFirstLineHeadIndent(this.indent);
        nSMutableParagraphStyle.setHeadIndent(this.wrapIndent);
        nSMutableParagraphStyle.setLineBreakMode(this.wrapWidth != -1 ? 0L : 2L);
        nSMutableParagraphStyle.setTabStops(NSArray.array());
        if (this.tabs != null && this.tabs.length > 0) {
            int n3 = this.tabs.length;
            if (n3 == 1) {
                nSMutableParagraphStyle.setDefaultTabInterval(this.tabs[0]);
            } else {
                int n4;
                n = 0;
                for (n4 = 0; n4 < n3; ++n4) {
                    n = this.tabs[n4];
                    NSTextTab nSTextTab = (NSTextTab)new NSTextTab().alloc();
                    nSTextTab = nSTextTab.initWithType(0L, n);
                    nSMutableParagraphStyle.addTabStop(nSTextTab);
                    nSTextTab.release();
                }
                int n5 = this.tabs[n3 - 1] - this.tabs[n3 - 2];
                while (n4 < 32) {
                    object2 = (NSTextTab)new NSTextTab().alloc();
                    object2 = ((NSTextTab)object2).initWithType(0L, n += n5);
                    nSMutableParagraphStyle.addTabStop((NSTextTab)object2);
                    ((NSObject)object2).release();
                    ++n4;
                }
            }
        }
        nSMutableAttributedString.addAttribute(OS.NSParagraphStyleAttributeName, nSMutableParagraphStyle, nSRange);
        nSMutableParagraphStyle.release();
        long l = nSMutableAttributedString.length();
        for (n = 0; n < this.stylesCount - 1; ++n) {
            Object object3;
            Object object4;
            Object object5;
            Color color;
            StyleItem styleItem = this.styles[n];
            if (styleItem.style == null) continue;
            object2 = styleItem.style;
            nSRange.location = l != 0L ? (long)this.translateOffset(styleItem.start) : 0L;
            nSRange.length = (long)this.translateOffset(this.styles[n + 1].start) - nSRange.location;
            Font font2 = ((TextStyle)object2).font;
            if (font2 != null) {
                nSMutableAttributedString.addAttribute(OS.NSFontAttributeName, font2.handle, nSRange);
                font2.addTraits(nSMutableAttributedString, nSRange);
            }
            if ((color = ((TextStyle)object2).foreground) != null) {
                object5 = NSColor.colorWithDeviceRed(color.handle[0], color.handle[1], color.handle[2], 1.0);
                nSMutableAttributedString.addAttribute(OS.NSForegroundColorAttributeName, (id)object5, nSRange);
            }
            if ((object5 = ((TextStyle)object2).background) != null) {
                object4 = NSColor.colorWithDeviceRed(((Color)object5).handle[0], ((Color)object5).handle[1], ((Color)object5).handle[2], 1.0);
                nSMutableAttributedString.addAttribute(OS.NSBackgroundColorAttributeName, (id)object4, nSRange);
            }
            if (((TextStyle)object2).strikeout) {
                nSMutableAttributedString.addAttribute(OS.NSStrikethroughStyleAttributeName, NSNumber.numberWithInt(1), nSRange);
                object4 = ((TextStyle)object2).strikeoutColor;
                if (object4 != null) {
                    object3 = NSColor.colorWithDeviceRed(((Color)object4).handle[0], ((Color)object4).handle[1], ((Color)object4).handle[2], 1.0);
                    nSMutableAttributedString.addAttribute(OS.NSStrikethroughColorAttributeName, (id)object3, nSRange);
                }
            }
            if (this.isUnderlineSupported((TextStyle)object2)) {
                int n6 = 0;
                switch (((TextStyle)object2).underlineStyle) {
                    case 0: {
                        n6 = 1;
                        break;
                    }
                    case 1: {
                        n6 = 9;
                        break;
                    }
                    case 65536: {
                        n6 = 2;
                        break;
                    }
                    case 4: {
                        n6 = 1;
                        if (color != null) break;
                        object3 = NSColor.colorWithDeviceRed((float)TextLayout.LINK_FOREGROUND.red / 255.0f, (float)TextLayout.LINK_FOREGROUND.green / 255.0f, (float)TextLayout.LINK_FOREGROUND.blue / 255.0f, 1.0);
                        nSMutableAttributedString.addAttribute(OS.NSForegroundColorAttributeName, (id)object3, nSRange);
                    }
                }
                if (n6 != 0) {
                    nSMutableAttributedString.addAttribute(OS.NSUnderlineStyleAttributeName, NSNumber.numberWithInt(n6), nSRange);
                    object3 = ((TextStyle)object2).underlineColor;
                    if (object3 != null) {
                        object = NSColor.colorWithDeviceRed(((Color)object3).handle[0], ((Color)object3).handle[1], ((Color)object3).handle[2], 1.0);
                        nSMutableAttributedString.addAttribute(OS.NSUnderlineColorAttributeName, (id)object, nSRange);
                    }
                }
            }
            if (((TextStyle)object2).rise != 0) {
                nSMutableAttributedString.addAttribute(OS.NSBaselineOffsetAttributeName, NSNumber.numberWithInt(((TextStyle)object2).rise), nSRange);
            }
            if (((TextStyle)object2).metrics == null) continue;
            this.initClasses();
            char[] cArray2 = new char[(int)nSRange.length];
            for (int i = 0; i < cArray2.length; ++i) {
                cArray2[i] = 65532;
            }
            object3 = (NSString)new NSString().alloc();
            object3 = ((NSString)object3).initWithCharacters(cArray2, cArray2.length);
            nSMutableAttributedString.replaceCharactersInRange(nSRange, (NSString)object3);
            ((NSObject)object3).release();
            styleItem.jniRef = OS.NewGlobalRef(styleItem);
            if (styleItem.jniRef == 0L) {
                SWT.error(2);
            }
            styleItem.cell = (SWTTextAttachmentCell)new SWTTextAttachmentCell().alloc().init();
            OS.object_setInstanceVariable(styleItem.cell.id, SWT_OBJECT, styleItem.jniRef);
            object = ((NSTextAttachment)new NSTextAttachment().alloc()).initWithFileWrapper(null);
            ((NSTextAttachment)object).setAttachmentCell(styleItem.cell);
            nSMutableAttributedString.addAttribute(OS.NSAttachmentAttributeName, (id)object, nSRange);
            ((NSObject)object).release();
        }
        nSMutableAttributedString.endEditing();
        NSSize nSSize = new NSSize();
        nSSize.width = this.wrapWidth != -1 ? (double)this.wrapWidth : 5000000.0;
        nSSize.height = 5000000.0;
        if (this.textStorage == null) {
            this.textStorage = (NSTextStorage)new NSTextStorage().alloc().init();
            this.layoutManager = (NSLayoutManager)new NSLayoutManager().alloc().init();
            this.layoutManager.setBackgroundLayoutEnabled(NSThread.isMainThread());
            this.textContainer = (NSTextContainer)new NSTextContainer().alloc();
            this.textContainer = this.textContainer.initWithContainerSize(nSSize);
            this.textContainer.setLineFragmentPadding(0.0);
            this.textStorage.addLayoutManager(this.layoutManager);
            this.layoutManager.addTextContainer(this.textContainer);
            this.layoutManager.release();
            this.textContainer.release();
        } else {
            this.textContainer.setContainerSize(nSSize);
        }
        this.textStorage.setAttributedString(nSMutableAttributedString);
        nSMutableAttributedString.release();
        this.layoutManager.glyphRangeForTextContainer(this.textContainer);
        long l2 = this.layoutManager.numberOfGlyphs();
        long l3 = OS.malloc(NSRange.sizeof);
        object = new NSRange();
        int n7 = 0;
        long l4 = 0L;
        while (l4 < l2) {
            this.layoutManager.lineFragmentUsedRectForGlyphAtIndex(l4, l3, true);
            OS.memmove((NSRange)object, l3, (long)NSRange.sizeof);
            l4 = ((NSRange)object).location + ((NSRange)object).length;
            ++n7;
        }
        if (n7 == 0) {
            ++n7;
        }
        int[] nArray = new int[n7 + 1];
        NSRect[] nSRectArray = new NSRect[n7];
        n7 = 0;
        l4 = 0L;
        while (l4 < l2) {
            nSRectArray[n7] = this.layoutManager.lineFragmentUsedRectForGlyphAtIndex(l4, l3, true);
            if (n7 < nSRectArray.length - 1) {
                nSRectArray[n7].height -= (double)this.spacing;
            }
            OS.memmove((NSRange)object, l3, (long)NSRange.sizeof);
            nArray[n7] = (int)((NSRange)object).location;
            l4 = ((NSRange)object).location + ((NSRange)object).length;
            ++n7;
        }
        if (n7 == 0) {
            Font font3 = this.font != null ? this.font : this.device.systemFont;
            NSFont nSFont = font3.handle;
            nSRectArray[0] = new NSRect();
            nSRectArray[0].height = Math.max(this.layoutManager.defaultLineHeightForFont(nSFont), (double)(this.ascent + this.descent));
        }
        OS.free(l3);
        nArray[n7] = (int)this.textStorage.length();
        this.lineOffsets = nArray;
        this.lineBounds = nSRectArray;
    }

    void destroy() {
        this.freeRuns();
        if (this.textStorage != null) {
            this.textStorage.release();
        }
        this.textStorage = null;
        this.layoutManager = null;
        this.textContainer = null;
        this.font = null;
        this.text = null;
        this.styles = null;
        this.segments = null;
        this.segmentsChars = null;
    }

    public void draw(GC gC, int n, int n2) {
        this.draw(gC, n, n2, -1, -1, null, null);
    }

    public void draw(GC gC, int n, int n2, int n3, int n4, Color color, Color color2) {
        this.draw(gC, n, n2, n3, n4, color, color2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(GC gC, int n, int n2, int n3, int n4, Color color, Color color2, int n5) {
        this.checkLayout();
        if (gC == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (color2 != null && color2.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = gC.checkGC(3073);
        try {
            int n6;
            Object object;
            Object object2;
            Object object3;
            boolean bl;
            this.computeRuns();
            int n7 = this.translateOffset(this.text.length());
            if (n7 == 0 && n5 == 0) {
                Object var51_11 = null;
                gC.uncheckGC(nSAutoreleasePool);
                return;
            }
            gC.handle.saveGraphicsState();
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = n;
            nSPoint.y = n2;
            NSRange nSRange = new NSRange();
            long l = this.layoutManager.numberOfGlyphs();
            if (l > 0L) {
                nSRange.location = 0L;
                nSRange.length = l;
                this.layoutManager.drawBackgroundForGlyphRange(nSRange, nSPoint);
            }
            boolean bl2 = bl = n3 <= n4 && n3 != -1 && n4 != -1;
            if (bl || (n5 & 0x100000) != 0 && (n5 & 0x30000) != 0) {
                if (color2 == null) {
                    color2 = this.device.getSystemColor(26);
                }
                object3 = NSColor.colorWithDeviceRed(color2.handle[0], color2.handle[1], color2.handle[2], color2.handle[3]);
                NSBezierPath nSBezierPath = NSBezierPath.bezierPath();
                object2 = new NSRect();
                if (bl) {
                    nSRange.location = this.translateOffset(n3);
                    nSRange.length = this.translateOffset(n4 - n3 + 1);
                    object = new long[1];
                    long l2 = this.layoutManager.rectArrayForCharacterRange(nSRange, nSRange, this.textContainer, (long[])object);
                    n6 = 0;
                    while ((long)n6 < object[0]) {
                        OS.memmove((NSRect)object2, l2, (long)NSRect.sizeof);
                        this.fixRect((NSRect)object2);
                        ((NSRect)object2).x += nSPoint.x;
                        ((NSRect)object2).y += nSPoint.y;
                        ((NSRect)object2).height = Math.max(((NSRect)object2).height, (double)(this.ascent + this.descent));
                        nSBezierPath.appendBezierPathWithRect((NSRect)object2);
                        ++n6;
                        l2 += (long)NSRect.sizeof;
                    }
                }
                if ((n5 & 0x30000) != 0 && (n5 & 0x100000) != 0) {
                    object = this.lineBounds[this.lineBounds.length - 1];
                    ((NSRect)object2).x = nSPoint.x + ((NSRect)object).x + ((NSRect)object).width;
                    ((NSRect)object2).y = (double)n2 + ((NSRect)object).y;
                    ((NSRect)object2).width = (n5 & 0x10000) != 0 ? 2.147483647E9 : ((NSRect)object).height / 3.0;
                    ((NSRect)object2).height = Math.max(((NSRect)object).height, (double)(this.ascent + this.descent));
                    nSBezierPath.appendBezierPathWithRect((NSRect)object2);
                }
                object3.setFill();
                nSBezierPath.fill();
            }
            if (l > 0L) {
                boolean bl3;
                nSRange.location = 0L;
                nSRange.length = l;
                object3 = gC.data.foreground;
                boolean bl4 = bl3 = object3[0] == 0.0 && object3[1] == 0.0 && object3[2] == 0.0 && object3[3] == 1.0 && gC.data.alpha == 255;
                if (!bl3) {
                    for (int i = 0; i < this.stylesCount - 1; ++i) {
                        object = this.styles[i];
                        if (((StyleItem)object).style != null && ((StyleItem)object).style.foreground != null || ((StyleItem)object).style != null && ((StyleItem)object).style.underline && ((StyleItem)object).style.underlineStyle == 4) continue;
                        nSRange.location = n7 != 0 ? (long)this.translateOffset(((StyleItem)object).start) : 0L;
                        nSRange.length = (long)this.translateOffset(this.styles[i + 1].start) - nSRange.location;
                        this.layoutManager.addTemporaryAttribute(OS.NSForegroundColorAttributeName, gC.data.fg, nSRange);
                    }
                }
                nSRange.location = 0L;
                nSRange.length = l;
                this.layoutManager.drawGlyphsForGlyphRange(nSRange, nSPoint);
                if (!bl3) {
                    nSRange.location = 0L;
                    nSRange.length = n7;
                    this.layoutManager.removeTemporaryAttribute(OS.NSForegroundColorAttributeName, nSRange);
                }
                object2 = new NSPoint();
                for (int i = 0; i < this.stylesCount; ++i) {
                    StyleItem styleItem = this.styles[i];
                    TextStyle textStyle = styleItem.style;
                    if (textStyle == null) continue;
                    n6 = textStyle.underline && !this.isUnderlineSupported(textStyle) ? 1 : 0;
                    n6 = n6 != 0 && (i + 1 == this.stylesCount || !textStyle.isAdherentUnderline(this.styles[i + 1].style)) ? 1 : 0;
                    boolean bl5 = textStyle.borderStyle != 0;
                    boolean bl6 = bl5 = bl5 && (i + 1 == this.stylesCount || !textStyle.isAdherentBorder(this.styles[i + 1].style));
                    if (n6 == 0 && !bl5) continue;
                    int n8 = i + 1 < this.stylesCount ? this.translateOffset(this.styles[i + 1].start - 1) : n7;
                    for (int j = 0; j < this.lineOffsets.length - 1; ++j) {
                        Object[] objectArray;
                        NSRect nSRect;
                        long l3;
                        int n9;
                        int n10;
                        int n11 = this.untranslateOffset(this.lineOffsets[j]);
                        int n12 = this.untranslateOffset(this.lineOffsets[j + 1] - 1);
                        if (n6 != 0) {
                            n10 = styleItem.start;
                            for (n9 = i; n9 > 0 && textStyle.isAdherentUnderline(this.styles[n9 - 1].style); --n9) {
                                n10 = this.styles[n9 - 1].start;
                            }
                            if ((n10 = this.translateOffset(n10)) <= n12 && n8 >= n11) {
                                nSRange.location = Math.max(n11, n10);
                                nSRange.length = (long)(Math.min(n12, n8) + 1) - nSRange.location;
                                if (nSRange.length > 0L) {
                                    long[] lArray = new long[1];
                                    l3 = this.layoutManager.rectArrayForCharacterRange(nSRange, nSRange, this.textContainer, lArray);
                                    nSRect = new NSRect();
                                    gC.handle.saveGraphicsState();
                                    double d = this.layoutManager.typesetter().baselineOffsetInLayoutManager(this.layoutManager, n11);
                                    objectArray = null;
                                    if (textStyle.underlineColor != null) {
                                        objectArray = textStyle.underlineColor.handle;
                                    }
                                    if (objectArray == null && textStyle.foreground != null) {
                                        objectArray = textStyle.foreground.handle;
                                    }
                                    if (objectArray != null) {
                                        NSColor.colorWithDeviceRed(objectArray[0], objectArray[1], objectArray[2], objectArray[3]).setStroke();
                                    }
                                    int n13 = 0;
                                    while ((long)n13 < lArray[0]) {
                                        OS.memmove(nSRect, l3, (long)NSRect.sizeof);
                                        this.fixRect(nSRect);
                                        double d2 = nSPoint.x + nSRect.x;
                                        double d3 = nSPoint.y + nSRect.y + nSRect.height - d + 1.0;
                                        NSBezierPath nSBezierPath = NSBezierPath.bezierPath();
                                        switch (textStyle.underlineStyle) {
                                            case 2: {
                                                nSBezierPath.setLineWidth(2.0);
                                                nSBezierPath.setLineCapStyle(1L);
                                                nSBezierPath.setLineJoinStyle(1L);
                                                nSBezierPath.setLineDash(new double[]{1.0, 3.0}, 2L, 0.0);
                                                ((NSPoint)object2).x = d2;
                                                ((NSPoint)object2).y = d3 + 0.5;
                                                nSBezierPath.moveToPoint((NSPoint)object2);
                                                ((NSPoint)object2).x = d2 + nSRect.width;
                                                ((NSPoint)object2).y = d3 + 0.5;
                                                nSBezierPath.lineToPoint((NSPoint)object2);
                                                break;
                                            }
                                            case 3: {
                                                gC.handle.setShouldAntialias(false);
                                                nSBezierPath.setLineWidth(1.0);
                                                nSBezierPath.setLineCapStyle(0L);
                                                nSBezierPath.setLineJoinStyle(0L);
                                                double d4 = nSPoint.y + nSRect.y + nSRect.height;
                                                float f = 1.0f;
                                                float f2 = 2.0f * f;
                                                double d5 = Math.min(d3 - (double)(f2 / 2.0f), d4 - (double)f2 - 1.0);
                                                float[] fArray = this.computePolyline((int)d2, (int)d5, (int)(d2 + nSRect.width), (int)(d5 + (double)f2));
                                                ((NSPoint)object2).x = fArray[0] + 0.5f;
                                                ((NSPoint)object2).y = fArray[1] + 0.5f;
                                                nSBezierPath.moveToPoint((NSPoint)object2);
                                                for (int k = 2; k < fArray.length; k += 2) {
                                                    ((NSPoint)object2).x = fArray[k] + 0.5f;
                                                    ((NSPoint)object2).y = fArray[k + 1] + 0.5f;
                                                    nSBezierPath.lineToPoint((NSPoint)object2);
                                                }
                                                break;
                                            }
                                        }
                                        nSBezierPath.stroke();
                                        ++n13;
                                        l3 += (long)NSRect.sizeof;
                                    }
                                    gC.handle.restoreGraphicsState();
                                }
                            }
                        }
                        if (!bl5) continue;
                        n10 = styleItem.start;
                        for (n9 = i; n9 > 0 && textStyle.isAdherentBorder(this.styles[n9 - 1].style); --n9) {
                            n10 = this.styles[n9 - 1].start;
                        }
                        if ((n10 = this.translateOffset(n10)) > n12 || n8 < n11) continue;
                        nSRange.location = Math.max(n11, n10);
                        nSRange.length = (long)(Math.min(n12, n8) + 1) - nSRange.location;
                        if (nSRange.length <= 0L) continue;
                        long[] lArray = new long[1];
                        l3 = this.layoutManager.rectArrayForCharacterRange(nSRange, nSRange, this.textContainer, lArray);
                        nSRect = new NSRect();
                        gC.handle.saveGraphicsState();
                        double[] dArray = null;
                        if (textStyle.borderColor != null) {
                            dArray = textStyle.borderColor.handle;
                        }
                        if (dArray == null && textStyle.foreground != null) {
                            dArray = textStyle.foreground.handle;
                        }
                        if (dArray != null) {
                            NSColor.colorWithDeviceRed(dArray[0], dArray[1], dArray[2], dArray[3]).setStroke();
                        }
                        boolean bl7 = true;
                        objectArray = null;
                        switch (textStyle.borderStyle) {
                            case 1: {
                                break;
                            }
                            case 2: {
                                objectArray = bl7 ? GC.LINE_DASH : GC.LINE_DASH_ZERO;
                                break;
                            }
                            case 4: {
                                objectArray = bl7 ? GC.LINE_DOT : GC.LINE_DOT_ZERO;
                            }
                        }
                        double[] dArray2 = null;
                        if (objectArray != null) {
                            dArray2 = new double[objectArray.length];
                            for (int k = 0; k < dArray2.length; ++k) {
                                dArray2[k] = !bl7 ? (double)objectArray[k] : (double)(objectArray[k] * (float)bl7);
                            }
                        }
                        int n14 = 0;
                        while ((long)n14 < lArray[0]) {
                            OS.memmove(nSRect, l3, (long)NSRect.sizeof);
                            this.fixRect(nSRect);
                            nSRect.x += nSPoint.x + 0.5;
                            nSRect.y += nSPoint.y + 0.5;
                            nSRect.width -= 0.5;
                            nSRect.height -= 0.5;
                            NSBezierPath nSBezierPath = NSBezierPath.bezierPath();
                            nSBezierPath.setLineDash(dArray2, dArray2 != null ? (long)dArray2.length : 0L, 0.0);
                            nSBezierPath.appendBezierPathWithRect(nSRect);
                            nSBezierPath.stroke();
                            ++n14;
                            l3 += (long)NSRect.sizeof;
                        }
                        gC.handle.restoreGraphicsState();
                    }
                }
            }
            gC.handle.restoreGraphicsState();
        }
        catch (Throwable throwable) {
            Object var51_13 = null;
            gC.uncheckGC(nSAutoreleasePool);
            throw throwable;
        }
        Object var51_12 = null;
        gC.uncheckGC(nSAutoreleasePool);
    }

    void fixRect(NSRect nSRect) {
        double d = -1.0;
        for (int i = 0; i < this.lineBounds.length; ++i) {
            NSRect nSRect2 = this.lineBounds[i];
            if (!(nSRect.y <= nSRect2.y) || !(nSRect2.y <= nSRect.y + nSRect.height)) continue;
            d = Math.max(d, nSRect2.x + nSRect2.width);
        }
        if (d != -1.0 && nSRect.x + nSRect.width > d) {
            nSRect.width = d - nSRect.x;
        }
    }

    void freeRuns() {
        this.lineBounds = null;
        this.lineOffsets = null;
        for (int i = 0; i < this.stylesCount - 1; ++i) {
            StyleItem styleItem = this.styles[i];
            if (styleItem.cell == null) continue;
            OS.object_setInstanceVariable(styleItem.cell.id, SWT_OBJECT, 0L);
            styleItem.cell.release();
            styleItem.cell = null;
            OS.DeleteGlobalRef(styleItem.jniRef);
            styleItem.jniRef = 0L;
        }
    }

    public int getAlignment() {
        this.checkLayout();
        return this.alignment;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getBounds() {
        Object object;
        block5: {
            this.checkLayout();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                NSRect nSRect = this.layoutManager.usedRectForTextContainer(this.textContainer);
                if (this.wrapWidth != -1) {
                    nSRect.width = this.wrapWidth;
                }
                if (this.text.length() == 0) {
                    object = this.font != null ? this.font : this.device.systemFont;
                    NSFont nSFont = ((Font)object).handle;
                    nSRect.height = this.layoutManager.defaultLineHeightForFont(nSFont);
                }
                nSRect.height = Math.max(nSRect.height, (double)(this.ascent + this.descent)) + (double)this.spacing;
                object = new Rectangle(0, 0, (int)Math.ceil(nSRect.width), (int)Math.ceil(nSRect.height));
                Object var6_5 = null;
                if (nSAutoreleasePool == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var6_6 = null;
                    if (nSAutoreleasePool == null) break block6;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getBounds(int n, int n2) {
        Rectangle rectangle;
        block10: {
            int n3;
            NSAutoreleasePool nSAutoreleasePool;
            block8: {
                Rectangle rectangle2;
                block9: {
                    block6: {
                        Rectangle rectangle3;
                        block7: {
                            this.checkLayout();
                            nSAutoreleasePool = null;
                            if (!NSThread.isMainThread()) {
                                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                            }
                            this.computeRuns();
                            n3 = this.text.length();
                            if (n3 != 0) break block6;
                            rectangle3 = new Rectangle(0, 0, 0, 0);
                            Object var16_8 = null;
                            if (nSAutoreleasePool == null) break block7;
                            nSAutoreleasePool.release();
                        }
                        return rectangle3;
                    }
                    if (n <= n2) break block8;
                    rectangle2 = new Rectangle(0, 0, 0, 0);
                    Object var16_9 = null;
                    if (nSAutoreleasePool == null) break block9;
                    nSAutoreleasePool.release();
                }
                return rectangle2;
            }
            try {
                n = Math.min(Math.max(0, n), n3 - 1);
                n2 = Math.min(Math.max(0, n2), n3 - 1);
                n = this.translateOffset(n);
                n2 = this.translateOffset(n2);
                NSRange nSRange = new NSRange();
                nSRange.location = n;
                nSRange.length = n2 - n + 1;
                long[] lArray = new long[1];
                long l = this.layoutManager.rectArrayForCharacterRange(nSRange, nSRange, this.textContainer, lArray);
                NSRect nSRect = new NSRect();
                int n4 = Integer.MAX_VALUE;
                int n5 = 0;
                int n6 = Integer.MAX_VALUE;
                int n7 = 0;
                int n8 = 0;
                while ((long)n8 < lArray[0]) {
                    OS.memmove(nSRect, l, (long)NSRect.sizeof);
                    this.fixRect(nSRect);
                    n4 = Math.min(n4, (int)nSRect.x);
                    n5 = Math.max(n5, (int)Math.ceil(nSRect.x + nSRect.width));
                    n6 = Math.min(n6, (int)nSRect.y);
                    n7 = Math.max(n7, (int)Math.ceil(nSRect.y + nSRect.height));
                    ++n8;
                    l += (long)NSRect.sizeof;
                }
                rectangle = new Rectangle(n4, n6, n5 - n4, n7 - n6);
                Object var16_10 = null;
                if (nSAutoreleasePool == null) break block10;
            }
            catch (Throwable throwable) {
                block11: {
                    Object var16_11 = null;
                    if (nSAutoreleasePool == null) break block11;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return rectangle;
    }

    public int getDescent() {
        this.checkLayout();
        return this.descent;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    public int getIndent() {
        this.checkLayout();
        return this.indent;
    }

    public boolean getJustify() {
        this.checkLayout();
        return this.justify;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLevel(int n) {
        byte by;
        block4: {
            this.checkLayout();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                int n2 = this.text.length();
                if (0 > n || n > n2) {
                    SWT.error(6);
                }
                n = this.translateOffset(n);
                long l = this.layoutManager.glyphIndexForCharacterAtIndex(n);
                NSRange nSRange = new NSRange();
                nSRange.location = l;
                nSRange.length = 1L;
                byte[] byArray = new byte[1];
                this.layoutManager.getGlyphsInRange(nSRange, 0L, 0L, 0L, 0L, byArray);
                by = byArray[0];
                Object var10_8 = null;
                if (nSAutoreleasePool == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var10_9 = null;
                    if (nSAutoreleasePool == null) break block5;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return by;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getLineOffsets() {
        int[] nArray;
        block4: {
            this.checkLayout();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                int[] nArray2 = new int[this.lineOffsets.length];
                for (int i = 0; i < nArray2.length; ++i) {
                    nArray2[i] = this.untranslateOffset(this.lineOffsets[i]);
                }
                nArray = nArray2;
                Object var5_5 = null;
                if (nSAutoreleasePool == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var5_6 = null;
                    if (nSAutoreleasePool == null) break block5;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getLineIndex(int n) {
        int n2;
        NSAutoreleasePool nSAutoreleasePool;
        block6: {
            int n3;
            block5: {
                this.checkLayout();
                nSAutoreleasePool = null;
                if (!NSThread.isMainThread()) {
                    nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                }
                try {
                    this.computeRuns();
                    int n4 = this.text.length();
                    if (0 > n || n > n4) {
                        SWT.error(6);
                    }
                    n = this.translateOffset(n);
                    for (n2 = 0; n2 < this.lineOffsets.length - 1; ++n2) {
                        if (this.lineOffsets[n2 + 1] <= n) continue;
                        n3 = n2;
                        Object var7_6 = null;
                        if (nSAutoreleasePool == null) return n3;
                        break block5;
                    }
                    n2 = this.lineBounds.length - 1;
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    if (nSAutoreleasePool == null) throw throwable;
                    nSAutoreleasePool.release();
                    throw throwable;
                }
            }
            nSAutoreleasePool.release();
            return n3;
        }
        Object var7_7 = null;
        if (nSAutoreleasePool == null) return n2;
        nSAutoreleasePool.release();
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getLineBounds(int n) {
        Rectangle rectangle;
        block4: {
            this.checkLayout();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                if (0 > n || n >= this.lineBounds.length) {
                    SWT.error(6);
                }
                NSRect nSRect = this.lineBounds[n];
                int n2 = Math.max((int)Math.ceil(nSRect.height), this.ascent + this.descent);
                rectangle = new Rectangle((int)nSRect.x, (int)nSRect.y, (int)Math.ceil(nSRect.width), n2);
                Object var7_6 = null;
                if (nSAutoreleasePool == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var7_7 = null;
                    if (nSAutoreleasePool == null) break block5;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return rectangle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineCount() {
        int n;
        block3: {
            this.checkLayout();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                n = this.lineOffsets.length - 1;
                Object var4_3 = null;
                if (nSAutoreleasePool == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var4_4 = null;
                    if (nSAutoreleasePool == null) break block4;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FontMetrics getLineMetrics(int n) {
        FontMetrics fontMetrics;
        block7: {
            NSAutoreleasePool nSAutoreleasePool;
            block5: {
                FontMetrics fontMetrics2;
                block6: {
                    this.checkLayout();
                    nSAutoreleasePool = null;
                    if (!NSThread.isMainThread()) {
                        nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                    }
                    try {
                        int n2;
                        this.computeRuns();
                        int n3 = this.getLineCount();
                        if (0 > n || n >= n3) {
                            SWT.error(6);
                        }
                        if ((n2 = this.text.length()) != 0) break block5;
                        Font font = this.font != null ? this.font : this.device.systemFont;
                        int n4 = (int)this.layoutManager.defaultBaselineOffsetForFont(font.handle);
                        int n5 = (int)this.layoutManager.defaultLineHeightForFont(font.handle) - n4;
                        n4 = Math.max(n4, this.ascent);
                        n5 = Math.max(n5, this.descent);
                        fontMetrics2 = FontMetrics.cocoa_new(n4, n5, 0, 0, n4 + n5);
                        Object var10_12 = null;
                        if (nSAutoreleasePool == null) break block6;
                    }
                    catch (Throwable throwable) {
                        block8: {
                            Object var10_14 = null;
                            if (nSAutoreleasePool == null) break block8;
                            nSAutoreleasePool.release();
                        }
                        throw throwable;
                    }
                    nSAutoreleasePool.release();
                }
                return fontMetrics2;
            }
            Rectangle rectangle = this.getLineBounds(n);
            int n6 = (int)this.layoutManager.typesetter().baselineOffsetInLayoutManager(this.layoutManager, this.getLineOffsets()[n]);
            fontMetrics = FontMetrics.cocoa_new(rectangle.height - n6, n6, 0, 0, rectangle.height);
            Object var10_13 = null;
            if (nSAutoreleasePool == null) break block7;
            nSAutoreleasePool.release();
        }
        return fontMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getLocation(int n, boolean bl) {
        Object object;
        block13: {
            NSAutoreleasePool nSAutoreleasePool;
            block11: {
                Point point;
                block12: {
                    int n2;
                    block9: {
                        Point point2;
                        block10: {
                            this.checkLayout();
                            nSAutoreleasePool = null;
                            if (!NSThread.isMainThread()) {
                                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                            }
                            try {
                                this.computeRuns();
                                n2 = this.text.length();
                                if (0 > n || n > n2) {
                                    SWT.error(6);
                                }
                                if (n2 != 0) break block9;
                                point2 = new Point(0, 0);
                                Object var19_8 = null;
                                if (nSAutoreleasePool == null) break block10;
                            }
                            catch (Throwable throwable) {
                                block14: {
                                    Object var19_11 = null;
                                    if (nSAutoreleasePool == null) break block14;
                                    nSAutoreleasePool.release();
                                }
                                throw throwable;
                            }
                            nSAutoreleasePool.release();
                        }
                        return point2;
                    }
                    if (n != n2) break block11;
                    NSRect nSRect = this.lineBounds[this.lineBounds.length - 1];
                    point = new Point((int)(nSRect.x + nSRect.width), (int)nSRect.y);
                    Object var19_9 = null;
                    if (nSAutoreleasePool == null) break block12;
                    nSAutoreleasePool.release();
                }
                return point;
            }
            n = this.translateOffset(n);
            long l = this.layoutManager.glyphIndexForCharacterAtIndex(n);
            NSRect nSRect = this.layoutManager.lineFragmentUsedRectForGlyphAtIndex(l, 0L);
            NSPoint nSPoint = this.layoutManager.locationForGlyphAtIndex(l);
            boolean bl2 = false;
            NSRange nSRange = new NSRange();
            nSRange.location = l;
            nSRange.length = 1L;
            byte[] byArray = new byte[1];
            long l2 = this.layoutManager.getGlyphsInRange(nSRange, 0L, 0L, 0L, 0L, byArray);
            if (l2 > 0L) {
                boolean bl3 = bl2 = (byArray[0] & 1) != 0;
            }
            if (bl != bl2) {
                object = new long[1];
                long l3 = this.layoutManager.rectArrayForGlyphRange(nSRange, nSRange, this.textContainer, (long[])object);
                if (object[0] > 0L) {
                    NSRect nSRect2 = new NSRect();
                    OS.memmove(nSRect2, l3, (long)NSRect.sizeof);
                    this.fixRect(nSRect2);
                    nSPoint.x += nSRect2.width;
                }
            }
            object = new Point((int)nSPoint.x, (int)nSRect.y);
            Object var19_10 = null;
            if (nSAutoreleasePool == null) break block13;
            nSAutoreleasePool.release();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextOffset(int n, int n2) {
        int n3;
        block3: {
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                n3 = this._getOffset(n, n2, true);
                Object var6_5 = null;
                if (nSAutoreleasePool == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var6_6 = null;
                    if (nSAutoreleasePool == null) break block4;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int _getOffset(int n, int n2, boolean bl) {
        int n3;
        this.checkLayout();
        this.computeRuns();
        int n4 = this.text.length();
        if (0 > n || n > n4) {
            SWT.error(6);
        }
        if (bl && n == n4) {
            return n4;
        }
        if (!bl && n == 0) {
            return 0;
        }
        int n5 = n3 = bl ? 1 : -1;
        if ((n2 & 1) != 0) {
            return n + n3;
        }
        switch (n2) {
            case 2: {
                char c;
                if (0 > (n += n3) || n >= n4 || '\udc00' > (c = this.text.charAt(n)) || c > '\udfff' || n <= 0 || '\ud800' > (c = this.text.charAt(n - 1)) || c > '\udbff') return n;
                n += n3;
                return n;
            }
            case 4: {
                n = this.translateOffset(n);
                n = (int)this.textStorage.nextWordFromIndex(n, bl);
                return this.untranslateOffset(n);
            }
            case 8: {
                n = this.translateOffset(n);
                if (bl) {
                    n = (int)this.textStorage.nextWordFromIndex(n, true);
                    return this.untranslateOffset(n);
                } else {
                    n4 = this.translateOffset(n4);
                    int n6 = 0;
                    while (n6 < n4) {
                        int n7 = (int)this.textStorage.nextWordFromIndex(n6, true);
                        if (n7 >= n) {
                            n = n6;
                            return this.untranslateOffset(n);
                        }
                        n6 = n7;
                    }
                }
                return this.untranslateOffset(n);
            }
            case 16: {
                n = this.translateOffset(n);
                if (bl) {
                    int n8 = this.translateOffset(n4);
                    while (n8 > 0) {
                        int n9 = (int)this.textStorage.nextWordFromIndex(n8, false);
                        if (n9 <= n) {
                            n = n8;
                            return this.untranslateOffset(n);
                        }
                        n8 = n9;
                    }
                    return this.untranslateOffset(n);
                }
                n = (int)this.textStorage.nextWordFromIndex(n, false);
                return this.untranslateOffset(n);
            }
        }
        return n;
    }

    public int getOffset(Point point, int[] nArray) {
        this.checkLayout();
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffset(point.x, point.y, nArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOffset(int n, int n2, int[] nArray) {
        int n3;
        block9: {
            int n4;
            NSAutoreleasePool nSAutoreleasePool;
            block7: {
                int n5;
                block8: {
                    this.checkLayout();
                    nSAutoreleasePool = null;
                    if (!NSThread.isMainThread()) {
                        nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                    }
                    try {
                        this.computeRuns();
                        if (nArray != null && nArray.length < 1) {
                            SWT.error(5);
                        }
                        if ((n4 = this.text.length()) != 0) break block7;
                        n5 = 0;
                        Object var13_8 = null;
                        if (nSAutoreleasePool == null) break block8;
                    }
                    catch (Throwable throwable) {
                        block10: {
                            Object var13_10 = null;
                            if (nSAutoreleasePool == null) break block10;
                            nSAutoreleasePool.release();
                        }
                        throw throwable;
                    }
                    nSAutoreleasePool.release();
                }
                return n5;
            }
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = n;
            nSPoint.y = n2;
            double[] dArray = new double[1];
            long l = this.layoutManager.glyphIndexForPoint(nSPoint, this.textContainer, dArray);
            int n6 = (int)this.layoutManager.characterIndexForGlyphAtIndex(l);
            n6 = Math.min(this.untranslateOffset(n6), n4 - 1);
            if (nArray != null) {
                nArray[0] = Math.round((float)dArray[0]);
                if (dArray[0] >= 0.5 && 55296 <= (n3 = (int)this.text.charAt(n6)) && n3 <= 56319 && n6 + 1 < n4 && 56320 <= (n3 = (int)this.text.charAt(n6 + 1)) && n3 <= 57343) {
                    nArray[0] = nArray[0] + 1;
                }
            }
            n3 = n6;
            Object var13_9 = null;
            if (nSAutoreleasePool == null) break block9;
            nSAutoreleasePool.release();
        }
        return n3;
    }

    public int getOrientation() {
        this.checkLayout();
        return this.orientation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPreviousOffset(int n, int n2) {
        int n3;
        block3: {
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                n3 = this._getOffset(n, n2, false);
                Object var6_5 = null;
                if (nSAutoreleasePool == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var6_6 = null;
                    if (nSAutoreleasePool == null) break block4;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return n3;
    }

    public int[] getRanges() {
        this.checkLayout();
        int[] nArray = new int[this.stylesCount * 2];
        int n = 0;
        for (int i = 0; i < this.stylesCount - 1; ++i) {
            if (this.styles[i].style == null) continue;
            nArray[n++] = this.styles[i].start;
            nArray[n++] = this.styles[i + 1].start - 1;
        }
        if (n != nArray.length) {
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            nArray = nArray2;
        }
        return nArray;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    public char[] getSegmentsChars() {
        this.checkLayout();
        return this.segmentsChars;
    }

    String getSegmentsText() {
        int n;
        int n2;
        int n3 = this.text.length();
        if (n3 == 0) {
            return this.text;
        }
        if (this.segments == null) {
            return this.text;
        }
        int n4 = this.segments.length;
        if (n4 == 0) {
            return this.text;
        }
        if (this.segmentsChars == null) {
            if (n4 == 1) {
                return this.text;
            }
            if (n4 == 2 && this.segments[0] == 0 && this.segments[1] == n3) {
                return this.text;
            }
        }
        char[] cArray = new char[n3];
        this.text.getChars(0, n3, cArray, 0);
        char[] cArray2 = new char[n3 + n4];
        int n5 = 0;
        int n6 = 0;
        int n7 = n2 = this.orientation == 0x4000000 ? 8207 : 8206;
        while (n5 < n3) {
            if (n6 < n4 && n5 == this.segments[n6]) {
                n = this.segmentsChars != null && this.segmentsChars.length > n6 ? this.segmentsChars[n6] : n2;
                cArray2[n5 + n6++] = n;
                continue;
            }
            cArray2[n5 + n6] = cArray[n5++];
        }
        while (n6 < n4) {
            this.segments[n6] = n5;
            n = this.segmentsChars != null && this.segmentsChars.length > n6 ? this.segmentsChars[n6] : n2;
            cArray2[n5 + n6++] = n;
        }
        return new String(cArray2, 0, cArray2.length);
    }

    public int getSpacing() {
        this.checkLayout();
        return this.spacing;
    }

    public TextStyle getStyle(int n) {
        this.checkLayout();
        int n2 = this.text.length();
        if (0 > n || n >= n2) {
            SWT.error(6);
        }
        for (int i = 1; i < this.stylesCount; ++i) {
            StyleItem styleItem = this.styles[i];
            if (styleItem.start <= n) continue;
            return this.styles[i - 1].style;
        }
        return null;
    }

    public TextStyle[] getStyles() {
        this.checkLayout();
        TextStyle[] textStyleArray = new TextStyle[this.stylesCount];
        int n = 0;
        for (int i = 0; i < this.stylesCount; ++i) {
            if (this.styles[i].style == null) continue;
            textStyleArray[n++] = this.styles[i].style;
        }
        if (n != textStyleArray.length) {
            TextStyle[] textStyleArray2 = new TextStyle[n];
            System.arraycopy(textStyleArray, 0, textStyleArray2, 0, n);
            textStyleArray = textStyleArray2;
        }
        return textStyleArray;
    }

    public int[] getTabs() {
        this.checkLayout();
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getTextDirection() {
        this.checkLayout();
        return this.orientation;
    }

    public int getWidth() {
        this.checkLayout();
        return this.wrapWidth;
    }

    public int getWrapIndent() {
        this.checkLayout();
        return this.wrapIndent;
    }

    void initClasses() {
        String string = "SWTTextAttachmentCell";
        if (OS.objc_lookUpClass(string) != 0L) {
            return;
        }
        textLayoutCallback2 = new Callback(this.getClass(), "textLayoutProc", 2);
        long l = textLayoutCallback2.getAddress();
        if (l == 0L) {
            SWT.error(3);
        }
        long l2 = OS.CALLBACK_cellBaselineOffset(l);
        long l3 = OS.CALLBACK_NSTextAttachmentCell_cellSize(l);
        byte[] byArray = new byte[]{42, 0};
        int n = C.PTR_SIZEOF;
        int n2 = C.PTR_SIZEOF == 4 ? 2 : 3;
        long l4 = OS.objc_allocateClassPair(OS.class_NSCell, string, 0L);
        OS.class_addIvar(l4, SWT_OBJECT, n, (byte)n2, byArray);
        OS.class_addProtocol(l4, OS.protocol_NSTextAttachmentCell);
        OS.class_addMethod(l4, OS.sel_cellSize, l3, "@:");
        OS.class_addMethod(l4, OS.sel_cellBaselineOffset, l2, "@:");
        OS.objc_registerClassPair(l4);
    }

    public boolean isDisposed() {
        return this.device == null;
    }

    boolean isUnderlineSupported(TextStyle textStyle) {
        if (textStyle != null && textStyle.underline) {
            int n = textStyle.underlineStyle;
            return n == 0 || n == 1 || n == 4 || n == 65536;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAlignment(int n) {
        this.checkLayout();
        int n2 = 16924672;
        if ((n &= n2) == 0) {
            return;
        }
        if ((n & 0x4000) != 0) {
            n = 16384;
        }
        if ((n & 0x20000) != 0) {
            n = 131072;
        }
        if (this.alignment == n) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.alignment = n;
            Object var5_4 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAscent(int n) {
        this.checkLayout();
        if (n < -1) {
            SWT.error(5);
        }
        if (this.ascent == n) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.ascent = n;
            Object var4_3 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDescent(int n) {
        this.checkLayout();
        if (n < -1) {
            SWT.error(5);
        }
        if (this.descent == n) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.descent = n;
            Object var4_3 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFont(Font font) {
        Font font2;
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if ((font2 = this.font) == font) {
            return;
        }
        this.font = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            Object var5_4 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setIndent(int n) {
        this.checkLayout();
        if (n < 0) {
            return;
        }
        if (this.indent == n) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.indent = n;
            Object var4_3 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setWrapIndent(int n) {
        this.checkLayout();
        if (n < 0) {
            return;
        }
        if (this.wrapIndent == n) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.wrapIndent = n;
            Object var4_3 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setJustify(boolean bl) {
        this.checkLayout();
        if (bl == this.justify) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.justify = bl;
            Object var4_3 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setOrientation(int n) {
        this.checkLayout();
        int n2 = 0x6000000;
        if ((n &= n2) == 0) {
            return;
        }
        if ((n & 0x2000000) != 0) {
            n = 0x2000000;
        }
        if (this.orientation == n) {
            return;
        }
        this.orientation = n;
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            Object var5_4 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSegments(int[] nArray) {
        this.checkLayout();
        if (this.segments == null && nArray == null) {
            return;
        }
        if (this.segments != null && nArray != null && this.segments.length == nArray.length) {
            int n;
            for (n = 0; n < nArray.length && this.segments[n] == nArray[n]; ++n) {
            }
            if (n == nArray.length) {
                return;
            }
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.segments = nArray;
            Object var4_4 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSegmentsChars(char[] cArray) {
        this.checkLayout();
        if (this.segmentsChars == null && cArray == null) {
            return;
        }
        if (this.segmentsChars != null && cArray != null && this.segmentsChars.length == cArray.length) {
            int n;
            for (n = 0; n < cArray.length && this.segmentsChars[n] == cArray[n]; ++n) {
            }
            if (n == cArray.length) {
                return;
            }
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.segmentsChars = cArray;
            Object var4_4 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSpacing(int n) {
        this.checkLayout();
        if (n < 0) {
            SWT.error(5);
        }
        if (this.spacing == n) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.spacing = n;
            Object var4_3 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setStyle(TextStyle textStyle, int n, int n2) {
        NSAutoreleasePool nSAutoreleasePool;
        block27: {
            block26: {
                block25: {
                    block24: {
                        block23: {
                            block22: {
                                block21: {
                                    this.checkLayout();
                                    nSAutoreleasePool = null;
                                    if (!NSThread.isMainThread()) {
                                        nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                                    }
                                    try {
                                        int n3;
                                        int n4;
                                        int n5;
                                        int n6;
                                        int n7 = this.text.length();
                                        if (n7 == 0) {
                                            Object var16_6 = null;
                                            if (nSAutoreleasePool == null) return;
                                            break block21;
                                        }
                                        if (n > n2) {
                                            break block22;
                                        }
                                        n = Math.min(Math.max(0, n), n7 - 1);
                                        n2 = Math.min(Math.max(0, n2), n7 - 1);
                                        int n8 = -1;
                                        int n9 = this.stylesCount;
                                        while (n9 - n8 > 1) {
                                            int n10 = (n9 + n8) / 2;
                                            if (this.styles[n10 + 1].start > n) {
                                                n9 = n10;
                                                continue;
                                            }
                                            n8 = n10;
                                        }
                                        if (0 <= n9 && n9 < this.stylesCount) {
                                            StyleItem styleItem = this.styles[n9];
                                            if (styleItem.start == n && this.styles[n9 + 1].start - 1 == n2) {
                                                if (textStyle == null) {
                                                    if (styleItem.style == null) {
                                                        break block23;
                                                    }
                                                } else if (textStyle.equals(styleItem.style)) {
                                                    break block24;
                                                }
                                            }
                                        }
                                        this.freeRuns();
                                        for (n6 = n5 = n9; n6 < this.stylesCount && this.styles[n6 + 1].start <= n2; ++n6) {
                                        }
                                        if (n5 == n6) {
                                            n4 = this.styles[n5].start;
                                            n3 = this.styles[n6 + 1].start - 1;
                                            if (n4 == n && n3 == n2) {
                                                this.styles[n5].style = textStyle;
                                                break block25;
                                            }
                                            if (n4 != n && n3 != n2) {
                                                int n11 = this.stylesCount + 2;
                                                if (n11 > this.styles.length) {
                                                    int n12 = Math.min(n11 + 1024, Math.max(64, n11 * 2));
                                                    StyleItem[] styleItemArray = new StyleItem[n12];
                                                    System.arraycopy(this.styles, 0, styleItemArray, 0, this.stylesCount);
                                                    this.styles = styleItemArray;
                                                }
                                                System.arraycopy(this.styles, n6 + 1, this.styles, n6 + 3, this.stylesCount - n6 - 1);
                                                StyleItem styleItem = new StyleItem();
                                                styleItem.start = n;
                                                styleItem.style = textStyle;
                                                this.styles[n5 + 1] = styleItem;
                                                styleItem = new StyleItem();
                                                styleItem.start = n2 + 1;
                                                styleItem.style = this.styles[n5].style;
                                                this.styles[n5 + 2] = styleItem;
                                                this.stylesCount = n11;
                                                break block26;
                                            }
                                        }
                                        if (n == this.styles[n5].start) {
                                            --n5;
                                        }
                                        if (n2 == this.styles[n6 + 1].start - 1) {
                                            ++n6;
                                        }
                                        if ((n4 = this.stylesCount + 1 - (n6 - n5 - 1)) > this.styles.length) {
                                            n3 = Math.min(n4 + 1024, Math.max(64, n4 * 2));
                                            StyleItem[] styleItemArray = new StyleItem[n3];
                                            System.arraycopy(this.styles, 0, styleItemArray, 0, this.stylesCount);
                                            this.styles = styleItemArray;
                                        }
                                        System.arraycopy(this.styles, n6, this.styles, n5 + 2, this.stylesCount - n6);
                                        StyleItem styleItem = new StyleItem();
                                        styleItem.start = n;
                                        styleItem.style = textStyle;
                                        this.styles[n5 + 1] = styleItem;
                                        this.styles[n5 + 2].start = n2 + 1;
                                        this.stylesCount = n4;
                                        break block27;
                                    }
                                    catch (Throwable throwable) {
                                        Object var16_13 = null;
                                        if (nSAutoreleasePool == null) throw throwable;
                                        nSAutoreleasePool.release();
                                        throw throwable;
                                    }
                                }
                                nSAutoreleasePool.release();
                                return;
                            }
                            Object var16_7 = null;
                            if (nSAutoreleasePool == null) return;
                            nSAutoreleasePool.release();
                            return;
                        }
                        Object var16_8 = null;
                        if (nSAutoreleasePool == null) return;
                        nSAutoreleasePool.release();
                        return;
                    }
                    Object var16_9 = null;
                    if (nSAutoreleasePool == null) return;
                    nSAutoreleasePool.release();
                    return;
                }
                Object var16_10 = null;
                if (nSAutoreleasePool == null) return;
                nSAutoreleasePool.release();
                return;
            }
            Object var16_11 = null;
            if (nSAutoreleasePool == null) return;
            nSAutoreleasePool.release();
            return;
        }
        Object var16_12 = null;
        if (nSAutoreleasePool == null) return;
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTabs(int[] nArray) {
        this.checkLayout();
        if (this.tabs == null && nArray == null) {
            return;
        }
        if (this.tabs != null && nArray != null && this.tabs.length == nArray.length) {
            int n;
            for (n = 0; n < nArray.length && this.tabs[n] == nArray[n]; ++n) {
            }
            if (n == nArray.length) {
                return;
            }
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.tabs = nArray;
            Object var4_4 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setText(String string) {
        this.checkLayout();
        if (string == null) {
            SWT.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.text = string;
            this.styles = new StyleItem[2];
            this.styles[0] = new StyleItem();
            this.styles[1] = new StyleItem();
            this.styles[1].start = string.length();
            this.stylesCount = 2;
            Object var4_3 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    public void setTextDirection(int n) {
        this.checkLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setWidth(int n) {
        this.checkLayout();
        if (n < -1 || n == 0) {
            SWT.error(5);
        }
        if (this.wrapWidth == n) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.wrapWidth = n;
            Object var4_3 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {" + this.text + "}";
    }

    static long textLayoutProc(long l, long l2) {
        long[] lArray = new long[1];
        OS.object_getInstanceVariable(l, SWT_OBJECT, lArray);
        if (lArray[0] == 0L) {
            return 0L;
        }
        StyleItem styleItem = (StyleItem)OS.JNIGetObject(lArray[0]);
        if (styleItem == null) {
            return 0L;
        }
        TextStyle textStyle = styleItem.style;
        if (textStyle == null) {
            return 0L;
        }
        GlyphMetrics glyphMetrics = textStyle.metrics;
        if (glyphMetrics == null) {
            return 0L;
        }
        if (l2 == OS.sel_cellSize) {
            NSSize nSSize = new NSSize();
            nSSize.width = glyphMetrics.width;
            nSSize.height = glyphMetrics.ascent + glyphMetrics.descent;
            long l3 = OS.malloc(NSSize.sizeof);
            OS.memmove(l3, nSSize, (long)NSSize.sizeof);
            return l3;
        }
        if (l2 == OS.sel_cellBaselineOffset) {
            NSPoint nSPoint = new NSPoint();
            nSPoint.y = -glyphMetrics.descent;
            long l4 = OS.malloc(NSPoint.sizeof);
            OS.memmove(l4, nSPoint, (long)NSPoint.sizeof);
            return l4;
        }
        return 0L;
    }

    int translateOffset(int n) {
        int n2 = this.text.length();
        if (n2 == 0) {
            return n;
        }
        if (this.segments == null) {
            return n;
        }
        int n3 = this.segments.length;
        if (n3 == 0) {
            return n;
        }
        if (this.segmentsChars == null) {
            if (n3 == 1) {
                return n;
            }
            if (n3 == 2 && this.segments[0] == 0 && this.segments[1] == n2) {
                return n;
            }
        }
        for (int i = 0; i < n3 && n - i >= this.segments[i]; ++i) {
            ++n;
        }
        return n;
    }

    int untranslateOffset(int n) {
        int n2 = this.text.length();
        if (n2 == 0) {
            return n;
        }
        if (this.segments == null) {
            return n;
        }
        int n3 = this.segments.length;
        if (n3 == 0) {
            return n;
        }
        if (this.segmentsChars == null) {
            if (n3 == 1) {
                return n;
            }
            if (n3 == 2 && this.segments[0] == 0 && this.segments[1] == n2) {
                return n;
            }
        }
        for (int i = 0; i < n3 && n > this.segments[i]; --n, ++i) {
        }
        return n;
    }

    static {
        SWT_OBJECT = new byte[]{83, 87, 84, 95, 79, 66, 74, 69, 67, 84, 0};
        LINK_FOREGROUND = new RGB(0, 51, 153);
    }

    static class StyleItem {
        TextStyle style;
        int start;
        long jniRef;
        NSCell cell;

        StyleItem() {
        }

        public String toString() {
            return "StyleItem {" + this.start + ", " + this.style + "}";
        }
    }
}

