/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SegmentListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSComboBox;
import org.eclipse.swt.internal.cocoa.NSComboBoxCell;
import org.eclipse.swt.internal.cocoa.NSControl;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSLayoutManager;
import org.eclipse.swt.internal.cocoa.NSMenu;
import org.eclipse.swt.internal.cocoa.NSMenuItem;
import org.eclipse.swt.internal.cocoa.NSMutableString;
import org.eclipse.swt.internal.cocoa.NSNotification;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSPopUpButton;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSText;
import org.eclipse.swt.internal.cocoa.NSTextContainer;
import org.eclipse.swt.internal.cocoa.NSTextField;
import org.eclipse.swt.internal.cocoa.NSTextFieldCell;
import org.eclipse.swt.internal.cocoa.NSTextView;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTComboBox;
import org.eclipse.swt.internal.cocoa.SWTPopUpButton;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Combo
extends Composite {
    String text;
    int textLimit = LIMIT;
    boolean receivingFocus;
    boolean ignoreSetObject;
    boolean ignoreSelection;
    NSRange selectionRange;
    boolean listVisible;
    static final int VISIBLE_COUNT = 5;
    public static final int LIMIT = Integer.MAX_VALUE;

    public Combo(Composite composite, int n) {
        super(composite, Combo.checkStyle(n));
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        NSAttributedString nSAttributedString = this.createString(string);
        if ((this.style & 8) != 0) {
            NSPopUpButton nSPopUpButton = (NSPopUpButton)this.view;
            long l = nSPopUpButton.indexOfSelectedItem();
            NSMenu nSMenu = nSPopUpButton.menu();
            NSMenuItem nSMenuItem = (NSMenuItem)new NSMenuItem().alloc();
            NSString nSString = NSString.string();
            nSMenuItem.initWithTitle(nSString, 0L, nSString);
            nSMenuItem.setAttributedTitle(nSAttributedString);
            nSMenu.addItem(nSMenuItem);
            nSMenuItem.release();
            if (l == -1L) {
                nSPopUpButton.selectItemAtIndex(-1L);
            }
        } else {
            ((NSComboBox)this.view).addItemWithObjectValue(nSAttributedString);
        }
    }

    public void add(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n2 = this.getItemCount();
        if (0 > n || n > n2) {
            this.error(6);
        }
        NSAttributedString nSAttributedString = this.createString(string);
        if ((this.style & 8) != 0) {
            NSPopUpButton nSPopUpButton = (NSPopUpButton)this.view;
            long l = nSPopUpButton.indexOfSelectedItem();
            NSMenu nSMenu = nSPopUpButton.menu();
            NSMenuItem nSMenuItem = (NSMenuItem)new NSMenuItem().alloc();
            NSString nSString = NSString.string();
            nSMenuItem.initWithTitle(nSString, 0L, nSString);
            nSMenuItem.setAttributedTitle(nSAttributedString);
            nSMenu.insertItem(nSMenuItem, n);
            nSMenuItem.release();
            if (l == -1L) {
                nSPopUpButton.selectItemAtIndex(-1L);
            }
        } else {
            ((NSComboBox)this.view).insertItemWithObjectValue(nSAttributedString, n);
        }
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSegmentListener(SegmentListener segmentListener) {
        this.checkWidget();
        if (segmentListener == null) {
            this.error(4);
        }
        this.addListener(49, new TypedListener(segmentListener));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    boolean becomeFirstResponder(long l, long l2) {
        this.receivingFocus = true;
        boolean bl = super.becomeFirstResponder(l, l2);
        this.receivingFocus = false;
        return bl;
    }

    static int checkStyle(int n) {
        n &= 0xFFFFF7FF;
        n &= 0xFFFFFCFF;
        if (((n = Combo.checkBits(n, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return n & 0xFFFFFFF7;
        }
        return n;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clearSelection() {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            Point point = this.getSelection();
            point.y = point.x;
            this.setSelection(point);
        }
    }

    void setObjectValue(long l, long l2, long l3) {
        super.setObjectValue(l, l2, this.ignoreSetObject ? l3 : this.createString((String)this.text).id);
    }

    void comboBoxSelectionDidChange(long l, long l2, long l3) {
        NSComboBox nSComboBox = (NSComboBox)this.view;
        long l4 = nSComboBox.indexOfSelectedItem();
        nSComboBox.selectItemAtIndex(l4);
        NSAttributedString nSAttributedString = new NSAttributedString(nSComboBox.itemObjectValueAtIndex(l4));
        NSString nSString = nSAttributedString.string();
        if (nSString != null) {
            this.setText(nSString.getString(), true);
        }
        if (!this.ignoreSelection) {
            this.sendSelectionEvent(13, null, this.display.trackingControl != this);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        NSControl nSControl = (NSControl)this.view;
        NSCell nSCell = nSControl.cell();
        NSSize nSSize = nSCell.cellSize();
        n3 = (int)Math.ceil(nSSize.width);
        n4 = (int)Math.ceil(nSSize.height);
        if ((this.style & 8) == 0) {
            int n5;
            Object object;
            this.ignoreSetObject = true;
            NSComboBoxCell nSComboBoxCell = new NSComboBoxCell(nSCell.id);
            NSArray nSArray = nSComboBoxCell.objectValues();
            int n6 = (int)nSArray.count();
            if (n6 > 0) {
                nSComboBoxCell = new NSComboBoxCell(nSComboBoxCell.copy());
                for (int i = 0; i < n6; ++i) {
                    object = new NSAttributedString(nSArray.objectAtIndex(i));
                    nSComboBoxCell.setAttributedStringValue((NSAttributedString)object);
                    nSSize = nSComboBoxCell.cellSize();
                    n3 = Math.max(n3, (int)Math.ceil(nSSize.width));
                }
                nSComboBoxCell.release();
            }
            this.ignoreSetObject = false;
            NSString nSString = nSControl.stringValue();
            if (nSString != null && (object = nSString.getString()) != null && (((String)object).indexOf(10) >= 0 || ((String)object).indexOf(13) >= 0) && (n5 = (int)this.view.frame().height) > 0) {
                n4 = n5;
            }
        } else {
            NSPopUpButton nSPopUpButton = (NSPopUpButton)this.view;
            if (nSPopUpButton.numberOfItems() == 1L && nSPopUpButton.indexOfSelectedItem() == -1L) {
                nSPopUpButton.selectItemAtIndex(0L);
                nSSize = nSCell.cellSize();
                n3 = Math.max(n3, (int)Math.ceil(nSSize.width));
                nSPopUpButton.selectItemAtIndex(-1L);
            }
        }
        if (n2 != -1 && ((this.style & 8) != 0 || n2 < n4)) {
            n4 = n2;
        }
        if (n != -1) {
            n3 = n;
        }
        return new Point(n3, n4);
    }

    public void copy() {
        this.checkWidget();
        Point point = this.getSelection();
        if (point.x == point.y) {
            return;
        }
        this.copyToClipboard(this.getText(point.x, point.y));
    }

    void createHandle() {
        if ((this.style & 8) != 0) {
            NSPopUpButton nSPopUpButton = (NSPopUpButton)new SWTPopUpButton().alloc();
            nSPopUpButton.initWithFrame(new NSRect(), false);
            nSPopUpButton.menu().setAutoenablesItems(false);
            nSPopUpButton.setTarget(nSPopUpButton);
            nSPopUpButton.setAction(OS.sel_sendSelection);
            nSPopUpButton.menu().setDelegate(nSPopUpButton);
            this.view = nSPopUpButton;
        } else {
            NSComboBox nSComboBox = (NSComboBox)new SWTComboBox().alloc();
            nSComboBox.init();
            nSComboBox.setDelegate(nSComboBox);
            NSCell nSCell = nSComboBox.cell();
            if (OS.VERSION >= 4192 && nSCell != null) {
                nSCell.setUsesSingleLineMode(true);
            }
            this.view = nSComboBox;
        }
    }

    NSAttributedString createString(String string) {
        NSAttributedString nSAttributedString = this.createString(string, null, this.foreground, 16384, false, true, false);
        nSAttributedString.autorelease();
        return nSAttributedString;
    }

    void createWidget() {
        this.text = "";
        super.createWidget();
        if ((this.style & 8) == 0) {
            NSComboBox nSComboBox = (NSComboBox)this.view;
            NSScreen nSScreen = nSComboBox.window().screen();
            NSRect nSRect = nSScreen != null ? nSScreen.frame() : NSScreen.mainScreen().frame();
            int n = Math.max(5, (int)(nSRect.height / 3.0 / nSComboBox.itemHeight()));
            nSComboBox.setNumberOfVisibleItems(n);
        }
    }

    void comboBoxWillDismiss(long l, long l2, long l3) {
        this.display.currentCombo = null;
        this.listVisible = false;
    }

    void comboBoxWillPopUp(long l, long l2, long l3) {
        this.display.currentCombo = this;
        this.listVisible = true;
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        Point point = this.getSelection();
        if (point.x == point.y) {
            return;
        }
        int n = point.x;
        int n2 = point.y;
        String string = this.getText();
        String string2 = string.substring(0, n);
        String string3 = string.substring(n2, string.length());
        String string4 = string.substring(n, n2);
        String string5 = "";
        if ((this.hooks(25) || this.filters(25)) && (string5 = this.verifyText(string5, n, n2, null)) == null) {
            return;
        }
        char[] cArray = new char[string4.length()];
        string4.getChars(0, cArray.length, cArray, 0);
        this.copyToClipboard(cArray);
        this.setText(string2 + string5 + string3, false);
        this.setSelection(new Point(n += string5.length(), n));
        this.sendEvent(24);
    }

    Color defaultBackground() {
        return this.display.getWidgetColor(25);
    }

    NSFont defaultNSFont() {
        if ((this.style & 8) != 0) {
            return this.display.popUpButtonFont;
        }
        return this.display.comboBoxFont;
    }

    Color defaultForeground() {
        return this.display.getWidgetColor(24);
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(((NSControl)this.view).cell());
    }

    public void deselect(int n) {
        this.checkWidget();
        if (n == -1) {
            return;
        }
        if (n == this.getSelectionIndex()) {
            if ((this.style & 8) != 0) {
                ((NSPopUpButton)this.view).selectItem(null);
                this.sendEvent(24);
            } else {
                ((NSComboBox)this.view).deselectItemAtIndex(n);
            }
        }
    }

    public void deselectAll() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            ((NSPopUpButton)this.view).selectItem(null);
            this.sendEvent(24);
        } else {
            NSComboBox nSComboBox = (NSComboBox)this.view;
            long l = nSComboBox.indexOfSelectedItem();
            if (l != -1L) {
                nSComboBox.deselectItemAtIndex(l);
            }
        }
    }

    boolean dragDetect(int n, int n2, boolean bl, boolean[] blArray) {
        if ((this.style & 8) == 0) {
            NSText nSText = ((NSControl)this.view).currentEditor();
            if (nSText != null) {
                NSRange nSRange = nSText.selectedRange();
                if (nSRange.length > 0L) {
                    NSTextView nSTextView = new NSTextView(nSText);
                    NSPoint nSPoint = new NSPoint();
                    nSPoint.x = n;
                    nSPoint.y = n2;
                    long l = nSTextView.characterIndexForInsertionAtPoint(nSPoint);
                    if (l != Integer.MAX_VALUE && l >= nSRange.location && l < nSRange.location + nSRange.length && super.dragDetect(n, n2, bl, blArray)) {
                        if (blArray != null) {
                            blArray[0] = true;
                        }
                        return true;
                    }
                }
            }
            return false;
        }
        return super.dragDetect(n, n2, bl, blArray);
    }

    Cursor findCursor() {
        Cursor cursor = super.findCursor();
        return cursor != null || (this.style & 8) != 0 ? cursor : this.display.getSystemCursor(19);
    }

    public int getCaretPosition() {
        this.checkWidget();
        return this.selectionRange != null ? (int)this.selectionRange.location : 0;
    }

    public Point getCaretLocation() {
        this.checkWidget();
        NSTextView nSTextView = null;
        if (this.hasFocus()) {
            nSTextView = new NSTextView(this.view.window().fieldEditor(true, this.view));
        }
        if (nSTextView == null) {
            return new Point(0, 0);
        }
        NSLayoutManager nSLayoutManager = nSTextView.layoutManager();
        NSTextContainer nSTextContainer = nSTextView.textContainer();
        NSRange nSRange = nSTextView.selectedRange();
        long[] lArray = new long[1];
        long l = nSLayoutManager.rectArrayForCharacterRange(nSRange, nSRange, nSTextContainer, lArray);
        NSRect nSRect = new NSRect();
        if (lArray[0] > 0L) {
            OS.memmove(nSRect, l, (long)NSRect.sizeof);
        }
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = (int)nSRect.x;
        nSPoint.y = (int)nSRect.y;
        nSPoint = nSTextView.convertPoint_toView_(nSPoint, this.view);
        return new Point((int)nSPoint.x, (int)nSPoint.y);
    }

    int getCharCount() {
        NSString nSString = (this.style & 8) != 0 ? ((NSPopUpButton)this.view).titleOfSelectedItem() : new NSCell(((NSComboBox)this.view).cell()).title();
        if (nSString == null) {
            return 0;
        }
        return (int)nSString.length();
    }

    public String getItem(int n) {
        this.checkWidget();
        int n2 = this.getItemCount();
        if (0 > n || n >= n2) {
            this.error(6);
        }
        NSString nSString = null;
        if ((this.style & 8) != 0) {
            nSString = ((NSPopUpButton)this.view).itemTitleAtIndex(n);
        } else {
            NSAttributedString nSAttributedString = new NSAttributedString(((NSComboBox)this.view).itemObjectValueAtIndex(n));
            if (nSAttributedString != null) {
                nSString = nSAttributedString.string();
            }
        }
        if (nSString == null) {
            this.error(8);
        }
        return nSString.getString();
    }

    public int getItemCount() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return (int)((NSPopUpButton)this.view).numberOfItems();
        }
        return (int)((NSComboBox)this.view).numberOfItems();
    }

    public int getItemHeight() {
        this.checkWidget();
        return 26;
    }

    public String[] getItems() {
        this.checkWidget();
        int n = this.getItemCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.getItem(i);
        }
        return stringArray;
    }

    public boolean getListVisible() {
        this.checkWidget();
        return this.listVisible;
    }

    String getNameText() {
        return this.getText();
    }

    int getMininumHeight() {
        return this.getTextHeight();
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return new Point(0, this.getCharCount());
        }
        if (this.selectionRange == null) {
            NSString nSString = new NSTextFieldCell(((NSTextField)this.view).cell()).title();
            return new Point((int)nSString.length(), (int)nSString.length());
        }
        return new Point((int)this.selectionRange.location, (int)(this.selectionRange.location + this.selectionRange.length));
    }

    public int getSelectionIndex() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return (int)((NSPopUpButton)this.view).indexOfSelectedItem();
        }
        return (int)((NSComboBox)this.view).indexOfSelectedItem();
    }

    public String getText() {
        this.checkWidget();
        return new String(this.getText(0, -1));
    }

    char[] getText(int n, int n2) {
        NSString nSString = (this.style & 8) != 0 ? ((NSPopUpButton)this.view).titleOfSelectedItem() : new NSCell(((NSComboBox)this.view).cell()).title();
        if (nSString == null) {
            return new char[0];
        }
        NSRange nSRange = new NSRange();
        nSRange.location = n;
        if (n2 == -1) {
            long l = nSString.length();
            nSRange.length = l - (long)n;
        } else {
            nSRange.length = n2 - n;
        }
        char[] cArray = new char[(int)nSRange.length];
        nSString.getCharacters(cArray, nSRange);
        return cArray;
    }

    public int getTextHeight() {
        this.checkWidget();
        NSCell nSCell = (this.style & 8) != 0 ? ((NSPopUpButton)this.view).cell() : ((NSComboBox)this.view).cell();
        return (int)nSCell.cellSize().height;
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return this.getItemCount();
        }
        return (int)((NSComboBox)this.view).numberOfVisibleItems();
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n2 = this.getItemCount();
        if (0 > n || n >= n2) {
            return -1;
        }
        for (int i = n; i < n2; ++i) {
            if (!string.equals(this.getItem(i))) continue;
            return i;
        }
        return -1;
    }

    boolean isEventView(long l) {
        return true;
    }

    void menuWillOpen(long l, long l2, long l3) {
        this.listVisible = true;
    }

    void menuDidClose(long l, long l2, long l3) {
        this.listVisible = false;
    }

    void mouseDown(long l, long l2, long l3) {
        NSView nSView = this.view;
        nSView.retain();
        super.mouseDown(l, l2, l3);
        nSView.release();
    }

    public void paste() {
        int n;
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        Point point = this.getSelection();
        int n2 = point.x;
        int n3 = point.y;
        String string = this.getText();
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n3, string.length());
        String string4 = this.getClipboardText();
        if (string4 == null) {
            return;
        }
        if ((this.hooks(25) || this.filters(25)) && (string4 = this.verifyText(string4, n2, n3, null)) == null) {
            return;
        }
        if (this.textLimit != LIMIT && (n = string.length()) - (n3 - n2) + string4.length() > this.textLimit) {
            string4 = string4.substring(0, this.textLimit - n + (n3 - n2));
        }
        this.setText(string2 + string4 + string3, false);
        this.setSelection(new Point(n2 += string4.length(), n2));
        this.sendEvent(24);
    }

    void register() {
        super.register();
        this.display.addWidget(((NSControl)this.view).cell(), this);
    }

    void releaseWidget() {
        if (this.display.currentCombo == this) {
            this.display.currentCombo = null;
        }
        super.releaseWidget();
        if ((this.style & 8) == 0) {
            ((NSControl)this.view).abortEditing();
        }
        this.text = null;
        this.selectionRange = null;
    }

    public void remove(int n) {
        this.checkWidget();
        if (n == -1) {
            this.error(6);
        }
        int n2 = this.getItemCount();
        if (0 > n || n >= n2) {
            this.error(6);
        }
        if ((this.style & 8) != 0) {
            ((NSPopUpButton)this.view).removeItemAtIndex(n);
        } else {
            ((NSComboBox)this.view).removeItemAtIndex(n);
        }
    }

    public void remove(int n, int n2) {
        int n3;
        this.checkWidget();
        if (n > n2) {
            return;
        }
        int n4 = this.getItemCount();
        if (0 > n || n > n2 || n2 >= n4) {
            this.error(6);
        }
        for (int i = n3 = Math.min(n2, n4 - 1); i >= n; --i) {
            this.remove(i);
        }
    }

    public void remove(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(n);
    }

    public void removeAll() {
        this.checkWidget();
        this.ignoreSelection = true;
        if ((this.style & 8) != 0) {
            ((NSPopUpButton)this.view).removeAllItems();
        } else {
            this.setText("", true);
            ((NSComboBox)this.view).removeAllItems();
        }
        this.ignoreSelection = false;
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSegmentListener(SegmentListener segmentListener) {
        this.checkWidget();
        if (segmentListener == null) {
            this.error(4);
        }
        this.eventTable.unhook(49, segmentListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    public void select(int n) {
        this.checkWidget();
        int n2 = this.getItemCount();
        if (0 <= n && n < n2) {
            if (n == this.getSelectionIndex()) {
                return;
            }
            this.ignoreSelection = true;
            if ((this.style & 8) != 0) {
                ((NSPopUpButton)this.view).selectItemAtIndex(n);
                this.sendEvent(24);
            } else {
                NSComboBox nSComboBox = (NSComboBox)this.view;
                nSComboBox.deselectItemAtIndex(n);
                nSComboBox.selectItemAtIndex(n);
            }
            this.ignoreSelection = false;
        }
    }

    void sendSelection() {
        this.sendEvent(24);
        if (!this.ignoreSelection) {
            this.sendSelectionEvent(13);
        }
    }

    boolean sendKeyEvent(NSEvent nSEvent, int n) {
        boolean bl = super.sendKeyEvent(nSEvent, n);
        if (!bl) {
            return bl;
        }
        int n2 = 0;
        long l = nSEvent.modifierFlags();
        if ((l & 0x80000L) != 0L) {
            n2 |= 0x10000;
        }
        if ((l & 0x20000L) != 0L) {
            n2 |= 0x20000;
        }
        if ((l & 0x40000L) != 0L) {
            n2 |= 0x40000;
        }
        if ((l & 0x100000L) != 0L) {
            n2 |= 0x400000;
        }
        if (n != 1) {
            return bl;
        }
        short s = nSEvent.keyCode();
        if (n2 == 0x400000) {
            switch (s) {
                case 7: {
                    this.cut();
                    return false;
                }
                case 8: {
                    this.copy();
                    return false;
                }
                case 9: {
                    this.paste();
                    return false;
                }
                case 0: {
                    if ((this.style & 8) != 0) break;
                    ((NSComboBox)this.view).selectText(null);
                    return false;
                }
            }
        }
        switch (s) {
            case 36: 
            case 76: {
                this.sendSelectionEvent(14);
            }
        }
        return bl;
    }

    boolean sendTrackingKeyEvent(NSEvent nSEvent, int n) {
        long l = nSEvent.modifierFlags();
        if ((l & 0x20000L) == 0L) {
            short s = nSEvent.keyCode();
            switch (s) {
                case 125: 
                case 126: {
                    this.sendKeyEvent(nSEvent, n);
                    return true;
                }
            }
        }
        return false;
    }

    void setBackgroundColor(NSColor nSColor) {
        if ((this.style & 8) == 0) {
            ((NSTextField)this.view).setBackgroundColor(nSColor);
        }
    }

    void setBackgroundImage(NSImage nSImage) {
    }

    void setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        if ((this.style & 8) == 0) {
            int n5;
            Object object;
            NSControl nSControl = (NSControl)this.view;
            int n6 = 0;
            NSString nSString = nSControl.stringValue();
            if (nSString != null && (object = nSString.getString()) != null && (((String)object).indexOf(10) >= 0 || ((String)object).indexOf(13) >= 0) && (n5 = (int)this.view.frame().height) > 0) {
                n6 = n5;
            }
            if (n6 == 0) {
                object = nSControl.cell().cellSize();
                n6 = (int)Math.ceil(((NSSize)object).height);
            }
            n4 = Math.min(n4, n6);
        }
        super.setBounds(n, n2, n3, n4, bl, bl2);
    }

    void setFont(NSFont nSFont) {
        super.setFont(nSFont);
        this.updateItems();
    }

    void setForeground(double[] dArray) {
        super.setForeground(dArray);
        this.updateItems();
        if ((this.style & 8) == 0) {
            NSColor nSColor = dArray == null ? NSColor.textColor() : NSColor.colorWithDeviceRed(dArray[0], dArray[1], dArray[2], 1.0);
            ((NSTextField)this.view).setTextColor(nSColor);
        }
    }

    public void setItem(int n, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n2 = this.getItemCount();
        if (0 > n || n >= n2) {
            this.error(6);
        }
        int n3 = this.getSelectionIndex();
        NSAttributedString nSAttributedString = this.createString(string);
        this.ignoreSelection = true;
        if ((this.style & 8) != 0) {
            NSMenuItem nSMenuItem = ((NSPopUpButton)this.view).itemAtIndex(n);
            nSMenuItem.setAttributedTitle(nSAttributedString);
            if (string.length() == 0) {
                nSMenuItem.setTitle(NSString.string());
            }
        } else {
            NSComboBox nSComboBox = (NSComboBox)this.view;
            nSComboBox.insertItemWithObjectValue(nSAttributedString, n);
            nSComboBox.removeItemAtIndex(n + 1);
        }
        if (n3 != -1) {
            this.select(n3);
        }
        this.ignoreSelection = false;
    }

    public void setItems(String[] stringArray) {
        int n;
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] != null) continue;
            this.error(5);
        }
        this.removeAll();
        if (stringArray.length == 0) {
            return;
        }
        this.ignoreSelection = true;
        for (n = 0; n < stringArray.length; ++n) {
            NSAttributedString nSAttributedString = this.createString(stringArray[n]);
            if ((this.style & 8) != 0) {
                NSMenu nSMenu = ((NSPopUpButton)this.view).menu();
                NSMenuItem nSMenuItem = (NSMenuItem)new NSMenuItem().alloc();
                NSString nSString = NSString.string();
                nSMenuItem.initWithTitle(nSString, 0L, nSString);
                nSMenuItem.setAttributedTitle(nSAttributedString);
                nSMenu.addItem(nSMenuItem);
                nSMenuItem.release();
                ((NSPopUpButton)this.view).selectItemAtIndex(-1L);
                continue;
            }
            ((NSComboBox)this.view).addItemWithObjectValue(nSAttributedString);
        }
        this.ignoreSelection = false;
    }

    public void setListVisible(boolean bl) {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            ((NSPopUpButton)this.view).setPullsDown(bl);
        }
    }

    public void setOrientation(int n) {
        this.checkWidget();
    }

    void setOrientation() {
        int n = (this.style & 0x4000000) != 0 ? 1 : 0;
        ((NSControl)this.view).setBaseWritingDirection(n);
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        if ((this.style & 8) == 0) {
            NSComboBox nSComboBox = (NSComboBox)this.view;
            NSString nSString = new NSCell(nSComboBox.cell()).title();
            int n = (int)nSString.length();
            int n2 = Math.min(Math.max(Math.min(point.x, point.y), 0), n);
            int n3 = Math.min(Math.max(Math.max(point.x, point.y), 0), n);
            this.selectionRange = new NSRange();
            this.selectionRange.location = n2;
            this.selectionRange.length = n3 - n2;
            NSText nSText = nSComboBox.currentEditor();
            if (nSText != null) {
                nSText.setSelectedRange(this.selectionRange);
            }
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.setText(string, true);
    }

    void setText(String string, boolean bl) {
        if (bl && (this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, this.getCharCount(), null)) == null) {
            return;
        }
        if ((this.style & 8) != 0) {
            int n = this.indexOf(string);
            if (n != -1) {
                this.select(n);
            }
        } else {
            char[] cArray = new char[Math.min(string.length(), this.textLimit)];
            string.getChars(0, cArray.length, cArray, 0);
            this.text = new String(cArray, 0, cArray.length);
            ((NSComboBox)this.view).cell().setAttributedStringValue(this.createString(this.text));
            if (bl) {
                this.sendEvent(24);
            }
        }
        this.selectionRange = null;
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            this.error(7);
        }
        this.textLimit = n;
    }

    public void setVisibleItemCount(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        if ((this.style & 8) == 0) {
            ((NSComboBox)this.view).setNumberOfVisibleItems(n);
        }
    }

    boolean shouldChangeTextInRange_replacementString(long l, long l2, long l3, long l4) {
        NSObject nSObject;
        Object object;
        NSRange nSRange = new NSRange();
        OS.memmove(nSRange, l3, (long)NSRange.sizeof);
        boolean bl = this.callSuperBoolean(l, l2, nSRange, l4);
        if (this.hooks(25)) {
            String string;
            object = new NSString(l4).getString();
            nSObject = this.display.application.currentEvent();
            long l5 = ((NSEvent)nSObject).type();
            if (l5 != 10L && l5 != 11L) {
                nSObject = null;
            }
            if ((string = this.verifyText((String)object, (int)nSRange.location, (int)(nSRange.location + nSRange.length), (NSEvent)nSObject)) == null) {
                return false;
            }
            if (!((String)object).equals(string)) {
                int n;
                int n2 = string.length();
                Point point = this.getSelection();
                if (this.textLimit != LIMIT && (n = this.getCharCount()) - (point.y - point.x) + n2 > this.textLimit) {
                    n2 = this.textLimit - n + (point.y - point.x);
                }
                char[] cArray = new char[n2];
                string.getChars(0, cArray.length, cArray, 0);
                NSString nSString = NSString.stringWithCharacters(cArray, cArray.length);
                NSText nSText = ((NSTextField)this.view).currentEditor();
                nSText.replaceCharactersInRange(nSText.selectedRange(), nSString);
                this.text = nSText.string().getString();
                this.sendEvent(24);
                bl = false;
            }
        }
        if (bl) {
            object = new char[this.text.length()];
            this.text.getChars(0, ((Object)object).length, (char[])object, 0);
            nSObject = (NSMutableString)NSMutableString.stringWithCharacters((char[])object, ((Object)object).length);
            ((NSMutableString)nSObject).replaceCharactersInRange(nSRange, new NSString(l4));
            this.text = ((NSString)nSObject).getString();
            this.selectionRange = null;
        }
        return bl;
    }

    void textViewDidChangeSelection(long l, long l2, long l3) {
        NSNotification nSNotification = new NSNotification(l3);
        NSText nSText = new NSText(nSNotification.object().id);
        this.selectionRange = nSText.selectedRange();
    }

    void textDidChange(long l, long l2, long l3) {
        super.textDidChange(l, l2, l3);
        this.postEvent(24);
    }

    NSRange textView_willChangeSelectionFromCharacterRange_toCharacterRange(long l, long l2, long l3, long l4, long l5) {
        if (this.receivingFocus && this.selectionRange != null) {
            return this.selectionRange;
        }
        NSRange nSRange = new NSRange();
        OS.memmove(nSRange, l5, (long)NSRange.sizeof);
        return nSRange;
    }

    void updateItems() {
        if ((this.style & 8) != 0) {
            NSPopUpButton nSPopUpButton = (NSPopUpButton)this.view;
            int n = (int)nSPopUpButton.numberOfItems();
            for (int i = 0; i < n; ++i) {
                NSMenuItem nSMenuItem = new NSMenuItem(nSPopUpButton.itemAtIndex(i));
                NSAttributedString nSAttributedString = nSMenuItem.attributedTitle();
                String string = nSAttributedString.string().getString();
                nSMenuItem.setAttributedTitle(this.createString(string));
            }
        } else {
            NSComboBox nSComboBox = (NSComboBox)this.view;
            int n = (int)nSComboBox.numberOfItems();
            for (int i = 0; i < n; ++i) {
                NSAttributedString nSAttributedString = new NSAttributedString(nSComboBox.itemObjectValueAtIndex(i));
                String string = nSAttributedString.string().getString();
                nSComboBox.insertItemWithObjectValue(this.createString(string), i);
                nSComboBox.removeItemAtIndex(i + 1);
            }
            nSComboBox.cell().setAttributedStringValue(this.createString(this.text));
        }
    }

    String verifyText(String string, int n, int n2, NSEvent nSEvent) {
        Event event = new Event();
        if (nSEvent != null) {
            this.setKeyState(event, 3, nSEvent);
        }
        event.text = string;
        event.start = n;
        event.end = n2;
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

