PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;
CREATE TABLE meta (  name  TEXT UNIQUE,   value TEXT );
INSERT INTO meta VALUES('version','7');
INSERT INTO meta VALUES('datetime','2022-08-07 08:14:50');
CREATE TABLE uuids (  id      INTEGER PRIMARY KEY,   jobUUID TEXT UNIQUE NOT NULL );
INSERT INTO uuids VALUES(1,'929bbafb-9fcb-42d6-b302-5cc89354e39b');
CREATE TABLE entities (  id                        INTEGER PRIMARY KEY,   jobUUID                   TEXT NOT NULL,   scheduleUUID              TEXT NOT NULL DEFAULT '',   hostName                  TEXT,   userName                  TEXT,   created                   INTEGER,   type                      INTEGER,   parentJobUUID             INTEGER,   bidFlag                   INTEGER DEFAULT 0,   lockedCount               INTEGER DEFAULT 0,   deletedFlag               INTEGER DEFAULT 0,   totalEntryCount           INTEGER DEFAULT 0,   totalEntrySize            INTEGER DEFAULT 0,   totalFileCount            INTEGER DEFAULT 0,   totalFileSize             INTEGER DEFAULT 0,   totalImageCount           INTEGER DEFAULT 0,   totalImageSize            INTEGER DEFAULT 0,   totalDirectoryCount       INTEGER DEFAULT 0,   totalLinkCount            INTEGER DEFAULT 0,   totalHardlinkCount        INTEGER DEFAULT 0,   totalHardlinkSize         INTEGER DEFAULT 0,   totalSpecialCount         INTEGER DEFAULT 0,   totalEntryCountNewest     INTEGER DEFAULT 0,   totalEntrySizeNewest      INTEGER DEFAULT 0,   totalFileCountNewest      INTEGER DEFAULT 0,   totalFileSizeNewest       INTEGER DEFAULT 0,   totalImageCountNewest     INTEGER DEFAULT 0,   totalImageSizeNewest      INTEGER DEFAULT 0,   totalDirectoryCountNewest INTEGER DEFAULT 0,   totalLinkCountNewest      INTEGER DEFAULT 0,   totalHardlinkCountNewest  INTEGER DEFAULT 0,   totalHardlinkSizeNewest   INTEGER DEFAULT 0,   totalSpecialCountNewest   INTEGER DEFAULT 0,   uuidId                    INTEGER DEFAULT 0 );
INSERT INTO entities VALUES(0,'','',NULL,NULL,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
INSERT INTO entities VALUES(1,'929bbafb-9fcb-42d6-b302-5cc89354e39b','','tooku','torsten',1659859979,1,NULL,0,1,0,54,8597227,32,3876587,0,0,6,3,11,4720640,2,54,7545439,32,2826847,0,0,6,3,11,4718592,2,1);
CREATE TABLE storages (  id                        INTEGER PRIMARY KEY,   entityId                  INTEGER REFERENCES entities(id) ON DELETE CASCADE,   name                      TEXT,   created                   INTEGER,   size                      INTEGER DEFAULT 0,   hostName                  TEXT,   userName                  TEXT,   comment                   TEXT,   state                     INTEGER DEFAULT 2,   mode                      INTEGER DEFAULT 0,   lastChecked               INTEGER DEFAULT 0,   errorMessage              TEXT,   deletedFlag               INTEGER DEFAULT 0,   totalEntryCount           INTEGER DEFAULT 0,   totalEntrySize            INTEGER DEFAULT 0,   totalFileCount            INTEGER DEFAULT 0,   totalFileSize             INTEGER DEFAULT 0,   totalImageCount           INTEGER DEFAULT 0,   totalImageSize            INTEGER DEFAULT 0,   totalDirectoryCount       INTEGER DEFAULT 0,   totalLinkCount            INTEGER DEFAULT 0,   totalHardlinkCount        INTEGER DEFAULT 0,   totalHardlinkSize         INTEGER DEFAULT 0,   totalSpecialCount         INTEGER DEFAULT 0,   totalEntryCountNewest     INTEGER DEFAULT 0,   totalEntrySizeNewest      INTEGER DEFAULT 0,   totalFileCountNewest      INTEGER DEFAULT 0,   totalFileSizeNewest       INTEGER DEFAULT 0,   totalImageCountNewest     INTEGER DEFAULT 0,   totalImageSizeNewest      INTEGER DEFAULT 0,   totalDirectoryCountNewest INTEGER DEFAULT 0,   totalLinkCountNewest      INTEGER DEFAULT 0,   totalHardlinkCountNewest  INTEGER DEFAULT 0,   totalHardlinkSizeNewest   INTEGER DEFAULT 0,   totalSpecialCountNewest   INTEGER DEFAULT 0,   uuidId                    INTEGER DEFAULT 0 );
INSERT INTO storages VALUES(1,1,'/tmp/test.bar',1659859979,5457390,'tooku','torsten','',1,0,1659860124,'',0,54,8597227,32,3876587,0,0,6,3,11,4720640,2,54,8597227,32,3876587,0,0,6,3,11,4720640,2,1);
PRAGMA writable_schema=ON;
INSERT INTO sqlite_master(type,name,tbl_name,rootpage,sql)VALUES('table','FTS_storages','FTS_storages',0,'CREATE VIRTUAL TABLE FTS_storages USING FTS5(  storageId,   name,   tokenize=unicode61 )');
CREATE TABLE IF NOT EXISTS 'FTS_storages_data'(id INTEGER PRIMARY KEY, block BLOB);
INSERT INTO FTS_storages_data VALUES(1,X'010103');
INSERT INTO FTS_storages_data VALUES(10,X'000000000101010001010101');
INSERT INTO FTS_storages_data VALUES(137438953473,X'0000002802303101020201036261720106010104010474657374010601010302026d70010601010204060a0b');
CREATE TABLE IF NOT EXISTS 'FTS_storages_idx'(segid, term, pgno, PRIMARY KEY(segid, term)) WITHOUT ROWID;
INSERT INTO FTS_storages_idx VALUES(1,X'',2);
CREATE TABLE IF NOT EXISTS 'FTS_storages_content'(id INTEGER PRIMARY KEY, c0, c1);
INSERT INTO FTS_storages_content VALUES(1,1,'/tmp/test.bar');
CREATE TABLE IF NOT EXISTS 'FTS_storages_docsize'(id INTEGER PRIMARY KEY, sz BLOB);
INSERT INTO FTS_storages_docsize VALUES(1,X'0103');
CREATE TABLE IF NOT EXISTS 'FTS_storages_config'(k PRIMARY KEY, v) WITHOUT ROWID;
INSERT INTO FTS_storages_config VALUES('version',4);
CREATE TABLE entries (  id              INTEGER PRIMARY KEY,   entityId        INTEGER REFERENCES entities(id) ON DELETE CASCADE,   type            INTEGER,   name            TEXT NOT NULL,   timeLastAccess  INTEGER,   timeModified    INTEGER,   timeLastChanged INTEGER,   userId          INTEGER,   groupId         INTEGER,   permission      INTEGER,   deletedFlag     INTEGER DEFAULT 0,   archiveOffset   INTEGER,   uuidId          INTEGER DEFAULT 0,   size            INTEGER DEFAULT 0 );
INSERT INTO entries VALUES(1,1,7,'test/data',1659800246,1659098680,1659098680,1000,1000,16877,0,NULL,0,0);
INSERT INTO entries VALUES(2,1,10,'test/data/fifo.ext',1659098679,1659098679,1659098679,1000,1000,4532,0,NULL,0,0);
INSERT INTO entries VALUES(3,1,5,'test/data/file400.dat',1659098682,1659098679,1659098679,1000,1000,33024,0,NULL,0,1024);
INSERT INTO entries VALUES(4,1,5,'test/data/file664.dat',1659098682,1659098679,1659098679,1000,1000,33204,0,NULL,0,1024);
INSERT INTO entries VALUES(5,1,5,'test/data/zero128.dat',1659858927,1659858927,1659858927,1000,1000,33204,0,NULL,0,128);
INSERT INTO entries VALUES(6,1,5,'test/data/extended_attribute.dat',1659098682,1659098679,1659098679,1000,1000,33204,0,NULL,0,1024);
INSERT INTO entries VALUES(7,1,9,'test/data/hardlink_extended_attribute.dat',1659098682,1659098679,1659098679,1000,1000,33204,0,NULL,0,1024);
INSERT INTO entries VALUES(8,1,9,'test/data/hardlinkdata_extended_attribute.dat',1659098682,1659098679,1659098679,1000,1000,33204,0,NULL,0,1024);
INSERT INTO entries VALUES(9,1,5,'test/data/name".dat',1659098682,1659098680,1659098680,1000,1000,33204,0,NULL,0,12);
INSERT INTO entries VALUES(10,1,5,'test/data/immutable.dat',1659098682,1659098679,1659098680,1000,1000,33204,0,NULL,0,18);
INSERT INTO entries VALUES(11,1,10,'test/data/fifo',1659098679,1659098679,1659098679,1000,1000,4532,0,NULL,0,0);
INSERT INTO entries VALUES(12,1,5,'test/data/sparse.dat',1659098682,1659098679,1659098679,1000,1000,33204,0,NULL,0,196608);
INSERT INTO entries VALUES(13,1,5,'test/data/readonly.dat',1659098682,1659098679,1659098679,1000,1000,33056,0,NULL,0,12);
INSERT INTO entries VALUES(14,1,5,'test/data/random128.dat',1659858927,1659858927,1659858927,1000,1000,33204,0,NULL,0,128);
INSERT INTO entries VALUES(15,1,5,'test/data/circular_link.dat.marker',1659098679,1659098679,1659098679,1000,1000,33204,0,NULL,0,0);
INSERT INTO entries VALUES(16,1,8,'test/data/link_not_existing_file.dat',1659855741,1659098679,1659098679,1000,1000,41471,0,NULL,0,0);
INSERT INTO entries VALUES(17,1,5,'test/data/file666.dat',1659098682,1659098679,1659098679,1000,1000,33206,0,NULL,0,1024);
INSERT INTO entries VALUES(18,1,8,'test/data/circular_link.dat',1659859844,1659098679,1659098679,1000,1000,41471,0,NULL,0,0);
INSERT INTO entries VALUES(19,1,5,'test/data/file_big_group_id.dat',1659098682,1659098679,1659098679,1000,1000,33204,0,NULL,0,1024);
INSERT INTO entries VALUES(20,1,5,'test/data/zero.dat',1659098682,1659098679,1659098679,1000,1000,33204,0,NULL,0,0);
INSERT INTO entries VALUES(21,1,5,'test/data/readonly512k.dat',1659098682,1659098679,1659098679,1000,1000,33056,0,NULL,0,524288);
INSERT INTO entries VALUES(22,1,5,'test/data/file640.dat',1659098682,1659098679,1659098679,1000,1000,33184,0,NULL,0,1024);
INSERT INTO entries VALUES(23,1,5,'test/data/zero512k.dat',1659098682,1659098679,1659098679,1000,1000,33204,0,NULL,0,524288);
INSERT INTO entries VALUES(24,1,5,'test/data/file644.dat',1659098682,1659098679,1659098679,1000,1000,33188,0,NULL,0,1024);
INSERT INTO entries VALUES(25,1,5,'test/data/name\.dat',1659098682,1659098680,1659098680,1000,1000,33204,0,NULL,0,12);
INSERT INTO entries VALUES(26,1,5,'test/data/append-only.dat',1659098682,1659098680,1659098680,1000,1000,33204,0,NULL,0,17);
INSERT INTO entries VALUES(27,1,5,'test/data/name''.dat',1659098682,1659098680,1659098680,1000,1000,33204,0,NULL,0,12);
INSERT INTO entries VALUES(28,1,5,'test/data/linkdata.dat',1659098682,1659098679,1659098679,1000,1000,33204,0,NULL,0,524288);
INSERT INTO entries VALUES(29,1,5,replace('test/data/name\n.dat','\n',char(10)),1659098682,1659098680,1659098680,1000,1000,33204,0,NULL,0,12);
INSERT INTO entries VALUES(30,1,5,'test/data/zero1024.dat',1659098682,1659098679,1659098679,1000,1000,33204,0,NULL,0,1024);
INSERT INTO entries VALUES(31,1,5,'test/data/zero-random512k.dat',1659098682,1659098679,1659098679,1000,1000,33204,0,NULL,0,524288);
INSERT INTO entries VALUES(32,1,8,'test/data/link.dat',1659855741,1659098679,1659098679,1000,1000,41471,0,NULL,0,0);
INSERT INTO entries VALUES(33,1,5,'test/data/random1024.dat',1659098682,1659098679,1659098679,1000,1000,33204,0,NULL,0,1024);
INSERT INTO entries VALUES(34,1,7,'test/data/sub_dir_extended_attribute',1659728250,1659098679,1659098679,1000,1000,16877,0,NULL,0,0);
INSERT INTO entries VALUES(35,1,7,'test/data/sub_dir.ext',1659728250,1659098679,1659098679,1000,1000,16877,0,NULL,0,0);
INSERT INTO entries VALUES(36,1,7,'test/data/delta1',1659728250,1659098679,1659098679,1000,1000,16877,0,NULL,0,0);
INSERT INTO entries VALUES(37,1,5,'test/data/smallfile.dat',1659098682,1659098679,1659098679,1000,1000,33204,0,NULL,0,128);
INSERT INTO entries VALUES(38,1,7,'test/data/delta2',1659728250,1659098679,1659098679,1000,1000,16877,0,NULL,0,0);
INSERT INTO entries VALUES(39,1,5,'test/data/name%d%f%s%p.dat',1659098682,1659098680,1659098680,1000,1000,33204,0,NULL,0,12);
INSERT INTO entries VALUES(40,1,7,'test/data/sub_dir',1659728250,1659098679,1659098679,1000,1000,16877,0,NULL,0,0);
INSERT INTO entries VALUES(41,1,5,'test/data/sub_dir.ext/test.dat',1659098682,1659098679,1659098679,1000,1000,33204,0,NULL,0,128);
INSERT INTO entries VALUES(42,1,5,'test/data/random512k.dat',1659098682,1659098679,1659098679,1000,1000,33204,0,NULL,0,524288);
INSERT INTO entries VALUES(43,1,5,'test/data/sub_dir/test.dat',1659098682,1659098679,1659098679,1000,1000,33204,0,NULL,0,128);
INSERT INTO entries VALUES(44,1,9,'test/data/hardlink2.dat',1659098682,1659098679,1659098679,1000,1000,33204,0,NULL,0,524288);
INSERT INTO entries VALUES(45,1,9,'test/data/hardlink.dat',1659098682,1659098679,1659098679,1000,1000,33204,0,NULL,0,524288);
INSERT INTO entries VALUES(46,1,9,'test/data/hardlink1.dat',1659098682,1659098679,1659098679,1000,1000,33204,0,NULL,0,524288);
INSERT INTO entries VALUES(47,1,9,'test/data/delta1/hardlink2.dat',1659098679,1659098679,1659098679,1000,1000,33204,0,NULL,0,524288);
INSERT INTO entries VALUES(48,1,9,'test/data/delta1/hardlink.dat',1659098679,1659098679,1659098679,1000,1000,33204,0,NULL,0,524288);
INSERT INTO entries VALUES(49,1,9,'test/data/delta1/hardlink1.dat',1659098679,1659098679,1659098679,1000,1000,33204,0,NULL,0,524288);
INSERT INTO entries VALUES(50,1,5,'test/data/delta1/random512k.dat',1659098679,1659098679,1659098679,1000,1000,33204,0,NULL,0,524288);
INSERT INTO entries VALUES(51,1,5,'test/data/delta2/random512k.dat',1659098682,1659098679,1659098679,1000,1000,33204,0,NULL,0,524288);
INSERT INTO entries VALUES(52,1,9,'test/data/delta2/hardlink2.dat',1659098682,1659098679,1659098679,1000,1000,33204,0,NULL,0,524288);
INSERT INTO entries VALUES(53,1,9,'test/data/delta2/hardlink.dat',1659098682,1659098679,1659098679,1000,1000,33204,0,NULL,0,524288);
INSERT INTO entries VALUES(54,1,9,'test/data/delta2/hardlink1.dat',1659098682,1659098679,1659098679,1000,1000,33204,0,NULL,0,524288);
CREATE TABLE entriesNewest (  id              INTEGER PRIMARY KEY,   entryId         INTEGER REFERENCES entries(id) ON DELETE CASCADE,   uuidId          INTEGER DEFAULT 0,   entityId        INTEGER DEFAULT 0,   type            INTEGER DEFAULT 0,   name            TEXT NOT NULL,   timeLastChanged INTEGER DEFAULT 0,   userId          INTEGER DEFAULT 0,   groupId         INTEGER DEFAULT 0,   permission      INTEGER DEFAULT 0,   size            INTEGER DEFAULT 0,   CONSTRAINT entriesNewest UNIQUE (name) );
INSERT INTO entriesNewest VALUES(1,5,0,1,5,'test/data/zero128.dat',1659858927,1000,1000,33204,128);
INSERT INTO entriesNewest VALUES(2,14,0,1,5,'test/data/random128.dat',1659858927,1000,1000,33204,128);
INSERT INTO entriesNewest VALUES(3,1,0,1,7,'test/data',1659098680,1000,1000,16877,0);
INSERT INTO entriesNewest VALUES(4,9,0,1,5,'test/data/name".dat',1659098680,1000,1000,33204,12);
INSERT INTO entriesNewest VALUES(5,10,0,1,5,'test/data/immutable.dat',1659098680,1000,1000,33204,18);
INSERT INTO entriesNewest VALUES(6,25,0,1,5,'test/data/name\.dat',1659098680,1000,1000,33204,12);
INSERT INTO entriesNewest VALUES(7,26,0,1,5,'test/data/append-only.dat',1659098680,1000,1000,33204,17);
INSERT INTO entriesNewest VALUES(8,27,0,1,5,'test/data/name''.dat',1659098680,1000,1000,33204,12);
INSERT INTO entriesNewest VALUES(9,29,0,1,5,replace('test/data/name\n.dat','\n',char(10)),1659098680,1000,1000,33204,12);
INSERT INTO entriesNewest VALUES(10,39,0,1,5,'test/data/name%d%f%s%p.dat',1659098680,1000,1000,33204,12);
INSERT INTO entriesNewest VALUES(11,2,0,1,10,'test/data/fifo.ext',1659098679,1000,1000,4532,0);
INSERT INTO entriesNewest VALUES(12,3,0,1,5,'test/data/file400.dat',1659098679,1000,1000,33024,1024);
INSERT INTO entriesNewest VALUES(13,4,0,1,5,'test/data/file664.dat',1659098679,1000,1000,33204,1024);
INSERT INTO entriesNewest VALUES(14,6,0,1,5,'test/data/extended_attribute.dat',1659098679,1000,1000,33204,1024);
INSERT INTO entriesNewest VALUES(15,7,0,1,9,'test/data/hardlink_extended_attribute.dat',1659098679,1000,1000,33204,1024);
INSERT INTO entriesNewest VALUES(16,8,0,1,9,'test/data/hardlinkdata_extended_attribute.dat',1659098679,1000,1000,33204,1024);
INSERT INTO entriesNewest VALUES(17,11,0,1,10,'test/data/fifo',1659098679,1000,1000,4532,0);
INSERT INTO entriesNewest VALUES(18,12,0,1,5,'test/data/sparse.dat',1659098679,1000,1000,33204,196608);
INSERT INTO entriesNewest VALUES(19,13,0,1,5,'test/data/readonly.dat',1659098679,1000,1000,33056,12);
INSERT INTO entriesNewest VALUES(20,15,0,1,5,'test/data/circular_link.dat.marker',1659098679,1000,1000,33204,0);
INSERT INTO entriesNewest VALUES(21,16,0,1,8,'test/data/link_not_existing_file.dat',1659098679,1000,1000,41471,0);
INSERT INTO entriesNewest VALUES(22,17,0,1,5,'test/data/file666.dat',1659098679,1000,1000,33206,1024);
INSERT INTO entriesNewest VALUES(23,18,0,1,8,'test/data/circular_link.dat',1659098679,1000,1000,41471,0);
INSERT INTO entriesNewest VALUES(24,19,0,1,5,'test/data/file_big_group_id.dat',1659098679,1000,1000,33204,1024);
INSERT INTO entriesNewest VALUES(25,20,0,1,5,'test/data/zero.dat',1659098679,1000,1000,33204,0);
INSERT INTO entriesNewest VALUES(26,21,0,1,5,'test/data/readonly512k.dat',1659098679,1000,1000,33056,524288);
INSERT INTO entriesNewest VALUES(27,22,0,1,5,'test/data/file640.dat',1659098679,1000,1000,33184,1024);
INSERT INTO entriesNewest VALUES(28,23,0,1,5,'test/data/zero512k.dat',1659098679,1000,1000,33204,524288);
INSERT INTO entriesNewest VALUES(29,24,0,1,5,'test/data/file644.dat',1659098679,1000,1000,33188,1024);
INSERT INTO entriesNewest VALUES(30,28,0,1,5,'test/data/linkdata.dat',1659098679,1000,1000,33204,524288);
INSERT INTO entriesNewest VALUES(31,30,0,1,5,'test/data/zero1024.dat',1659098679,1000,1000,33204,1024);
INSERT INTO entriesNewest VALUES(32,31,0,1,5,'test/data/zero-random512k.dat',1659098679,1000,1000,33204,524288);
INSERT INTO entriesNewest VALUES(33,32,0,1,8,'test/data/link.dat',1659098679,1000,1000,41471,0);
INSERT INTO entriesNewest VALUES(34,33,0,1,5,'test/data/random1024.dat',1659098679,1000,1000,33204,1024);
INSERT INTO entriesNewest VALUES(35,34,0,1,7,'test/data/sub_dir_extended_attribute',1659098679,1000,1000,16877,0);
INSERT INTO entriesNewest VALUES(36,35,0,1,7,'test/data/sub_dir.ext',1659098679,1000,1000,16877,0);
INSERT INTO entriesNewest VALUES(37,36,0,1,7,'test/data/delta1',1659098679,1000,1000,16877,0);
INSERT INTO entriesNewest VALUES(38,37,0,1,5,'test/data/smallfile.dat',1659098679,1000,1000,33204,128);
INSERT INTO entriesNewest VALUES(39,38,0,1,7,'test/data/delta2',1659098679,1000,1000,16877,0);
INSERT INTO entriesNewest VALUES(40,40,0,1,7,'test/data/sub_dir',1659098679,1000,1000,16877,0);
INSERT INTO entriesNewest VALUES(41,41,0,1,5,'test/data/sub_dir.ext/test.dat',1659098679,1000,1000,33204,128);
INSERT INTO entriesNewest VALUES(42,42,0,1,5,'test/data/random512k.dat',1659098679,1000,1000,33204,524288);
INSERT INTO entriesNewest VALUES(43,43,0,1,5,'test/data/sub_dir/test.dat',1659098679,1000,1000,33204,128);
INSERT INTO entriesNewest VALUES(44,44,0,1,9,'test/data/hardlink2.dat',1659098679,1000,1000,33204,524288);
INSERT INTO entriesNewest VALUES(45,45,0,1,9,'test/data/hardlink.dat',1659098679,1000,1000,33204,524288);
INSERT INTO entriesNewest VALUES(46,46,0,1,9,'test/data/hardlink1.dat',1659098679,1000,1000,33204,524288);
INSERT INTO entriesNewest VALUES(47,47,0,1,9,'test/data/delta1/hardlink2.dat',1659098679,1000,1000,33204,524288);
INSERT INTO entriesNewest VALUES(48,48,0,1,9,'test/data/delta1/hardlink.dat',1659098679,1000,1000,33204,524288);
INSERT INTO entriesNewest VALUES(49,49,0,1,9,'test/data/delta1/hardlink1.dat',1659098679,1000,1000,33204,524288);
INSERT INTO entriesNewest VALUES(50,50,0,1,5,'test/data/delta1/random512k.dat',1659098679,1000,1000,33204,524288);
INSERT INTO entriesNewest VALUES(51,51,0,1,5,'test/data/delta2/random512k.dat',1659098679,1000,1000,33204,524288);
INSERT INTO entriesNewest VALUES(52,52,0,1,9,'test/data/delta2/hardlink2.dat',1659098679,1000,1000,33204,524288);
INSERT INTO entriesNewest VALUES(53,53,0,1,9,'test/data/delta2/hardlink.dat',1659098679,1000,1000,33204,524288);
INSERT INTO entriesNewest VALUES(54,54,0,1,9,'test/data/delta2/hardlink1.dat',1659098679,1000,1000,33204,524288);
INSERT INTO sqlite_master(type,name,tbl_name,rootpage,sql)VALUES('table','FTS_entries','FTS_entries',0,'CREATE VIRTUAL TABLE FTS_entries USING FTS5(  entryId,   name,   tokenize=unicode61 )');
CREATE TABLE IF NOT EXISTS 'FTS_entries_data'(id INTEGER PRIMARY KEY, block BLOB);
INSERT INTO FTS_entries_data VALUES(1,X'36368177');
INSERT INTO FTS_entries_data VALUES(10,X'000000000101010001010101');
INSERT INTO FTS_entries_data VALUES(137438953473,X'0000072b0230310102020201300a02020201310b02020201320c02020201330d02020201340e02020201350f02020201361002020201371102020201381202020201391302020101320202020201301402020201311502020201321602020201331702020201341802020201351902020201361a02020201371b02020201381c02020201391d02020101330302020201301e02020201311f02020201322002020201332102020201342202020201352302020201362402020201372502020201382602020201392702020101340402020201302802020201312902020201322a02020201332b02020201342c02020201352d02020201362e02020201372f02020201383002020201393102020101350502020201303202020201313302020201323402020201333502020201343602020101360602020101370702020101380802020101390902020106617070656e641a06010104020874747269627574650606010105010601010601060101061a0601010701036269671306010105010863697263756c61720f06010104030601010401016427060101050202617403060101050106010105010601010501060101060106010107010601010701060101050106010105020601010501060101050106010105010601010601060101080106010105010601010601060101080106010105010601010501060101050106010105010601010501060101050106010106010601010501060101050106010105010601010501060101060106010105010601010504060101050206010109020601010801060101050106010107010601010501060101050106010105010601010601060101060106010106010601010601060101060106010106010601010601060101060401610106010103010601010301060101030106010103010601010301060101030106010103010601010301060101030106010103010601010301060101030106010103010601010301060101030106010103010601010301060101030106010103010601010301060101030106010103010601010301060101030106010103010601010301060101030106010103010601010301060101030106010103010601010301060101030106010103010601010301060101030106010103010601010301060101030106010103010601010301060101030106010103010601010301060101030106010103010601010301060101030106010103010601010301060101030106010103010601010301060101030205656c74613124060101040b0601010401060101040106010104010601010406013226060101040d06010104010601010401060101040106010104020269722206010105010601010505060101050106010105020601010501086578697374696e6710060101060301740206010105210601010606060101060405656e6465640606010104010601010501060101051a060101060101662706010106020369666f0206010104090601010403026c6510060101070306010104050334303003060101040503363430160601010407013418060101040602363404060101040701361106010104010567726f757013060101060108686172646c696e6b07060101042606010104030601010505060101050901312e06010104030601010505060101050901322c0601010403060101050506010105090464617461080601010401026964130601010702086d6d757461626c650a0601010401046c696e6b0f06010105010601010402060101050e060101040504646174611c0601010401066d61726b65720f0601010701046e616d6509060101041006010104020601010402060101040a0601010402026f74100601010501046f6e6c791a060101050101702706010108010a72616e646f6d313032342106010104080232380e0601010407043531326b1f060101050b060101040806010105010601010502076561646f6e6c790d0601010409043531326b1506010104010173270601010702086d616c6c66696c652506010104020570617273650c060101040202756222060101040106010104050601010401060101040206010104010474657374010601010201060101020106010102010601010201060101020106010102010601010201060101020106010102010601010201060101020106010102010601010201060101020106010102010601010201060101020106010102010601010201060101020106010102010601010201060101020106010102010601010201060101020106010102010601010201060101020106010102010601010201060101020106010102010601010201060101020106010102010601010201060101020106010102010601010201080101020701060101020108010102060106010102010601010201060101020106010102010601010201060101020106010102010601010201060101020106010102010601010201047a65726f14060101040b060101040504313032341e0601010406023238050601010405043531326b1706010104040606060606060606060606060606060606060606060606060606060606060606060606060606060606060606060606060606060606060d1e0a1408816a8211201c1d0f121b080f0e0a0a0809080c1e12120b090f1a0b0d1f090b0811091a0e0b080f0c1d8216100b09');
CREATE TABLE IF NOT EXISTS 'FTS_entries_idx'(segid, term, pgno, PRIMARY KEY(segid, term)) WITHOUT ROWID;
INSERT INTO FTS_entries_idx VALUES(1,X'',2);
CREATE TABLE IF NOT EXISTS 'FTS_entries_content'(id INTEGER PRIMARY KEY, c0, c1);
INSERT INTO FTS_entries_content VALUES(1,1,'test/data');
INSERT INTO FTS_entries_content VALUES(2,2,'test/data/fifo.ext');
INSERT INTO FTS_entries_content VALUES(3,3,'test/data/file400.dat');
INSERT INTO FTS_entries_content VALUES(4,4,'test/data/file664.dat');
INSERT INTO FTS_entries_content VALUES(5,5,'test/data/zero128.dat');
INSERT INTO FTS_entries_content VALUES(6,6,'test/data/extended_attribute.dat');
INSERT INTO FTS_entries_content VALUES(7,7,'test/data/hardlink_extended_attribute.dat');
INSERT INTO FTS_entries_content VALUES(8,8,'test/data/hardlinkdata_extended_attribute.dat');
INSERT INTO FTS_entries_content VALUES(9,9,'test/data/name".dat');
INSERT INTO FTS_entries_content VALUES(10,10,'test/data/immutable.dat');
INSERT INTO FTS_entries_content VALUES(11,11,'test/data/fifo');
INSERT INTO FTS_entries_content VALUES(12,12,'test/data/sparse.dat');
INSERT INTO FTS_entries_content VALUES(13,13,'test/data/readonly.dat');
INSERT INTO FTS_entries_content VALUES(14,14,'test/data/random128.dat');
INSERT INTO FTS_entries_content VALUES(15,15,'test/data/circular_link.dat.marker');
INSERT INTO FTS_entries_content VALUES(16,16,'test/data/link_not_existing_file.dat');
INSERT INTO FTS_entries_content VALUES(17,17,'test/data/file666.dat');
INSERT INTO FTS_entries_content VALUES(18,18,'test/data/circular_link.dat');
INSERT INTO FTS_entries_content VALUES(19,19,'test/data/file_big_group_id.dat');
INSERT INTO FTS_entries_content VALUES(20,20,'test/data/zero.dat');
INSERT INTO FTS_entries_content VALUES(21,21,'test/data/readonly512k.dat');
INSERT INTO FTS_entries_content VALUES(22,22,'test/data/file640.dat');
INSERT INTO FTS_entries_content VALUES(23,23,'test/data/zero512k.dat');
INSERT INTO FTS_entries_content VALUES(24,24,'test/data/file644.dat');
INSERT INTO FTS_entries_content VALUES(25,25,'test/data/name\.dat');
INSERT INTO FTS_entries_content VALUES(26,26,'test/data/append-only.dat');
INSERT INTO FTS_entries_content VALUES(27,27,'test/data/name''.dat');
INSERT INTO FTS_entries_content VALUES(28,28,'test/data/linkdata.dat');
INSERT INTO FTS_entries_content VALUES(29,29,replace('test/data/name\n.dat','\n',char(10)));
INSERT INTO FTS_entries_content VALUES(30,30,'test/data/zero1024.dat');
INSERT INTO FTS_entries_content VALUES(31,31,'test/data/zero-random512k.dat');
INSERT INTO FTS_entries_content VALUES(32,32,'test/data/link.dat');
INSERT INTO FTS_entries_content VALUES(33,33,'test/data/random1024.dat');
INSERT INTO FTS_entries_content VALUES(34,34,'test/data/sub_dir_extended_attribute');
INSERT INTO FTS_entries_content VALUES(35,35,'test/data/sub_dir.ext');
INSERT INTO FTS_entries_content VALUES(36,36,'test/data/delta1');
INSERT INTO FTS_entries_content VALUES(37,37,'test/data/smallfile.dat');
INSERT INTO FTS_entries_content VALUES(38,38,'test/data/delta2');
INSERT INTO FTS_entries_content VALUES(39,39,'test/data/name%d%f%s%p.dat');
INSERT INTO FTS_entries_content VALUES(40,40,'test/data/sub_dir');
INSERT INTO FTS_entries_content VALUES(41,41,'test/data/sub_dir.ext/test.dat');
INSERT INTO FTS_entries_content VALUES(42,42,'test/data/random512k.dat');
INSERT INTO FTS_entries_content VALUES(43,43,'test/data/sub_dir/test.dat');
INSERT INTO FTS_entries_content VALUES(44,44,'test/data/hardlink2.dat');
INSERT INTO FTS_entries_content VALUES(45,45,'test/data/hardlink.dat');
INSERT INTO FTS_entries_content VALUES(46,46,'test/data/hardlink1.dat');
INSERT INTO FTS_entries_content VALUES(47,47,'test/data/delta1/hardlink2.dat');
INSERT INTO FTS_entries_content VALUES(48,48,'test/data/delta1/hardlink.dat');
INSERT INTO FTS_entries_content VALUES(49,49,'test/data/delta1/hardlink1.dat');
INSERT INTO FTS_entries_content VALUES(50,50,'test/data/delta1/random512k.dat');
INSERT INTO FTS_entries_content VALUES(51,51,'test/data/delta2/random512k.dat');
INSERT INTO FTS_entries_content VALUES(52,52,'test/data/delta2/hardlink2.dat');
INSERT INTO FTS_entries_content VALUES(53,53,'test/data/delta2/hardlink.dat');
INSERT INTO FTS_entries_content VALUES(54,54,'test/data/delta2/hardlink1.dat');
CREATE TABLE IF NOT EXISTS 'FTS_entries_docsize'(id INTEGER PRIMARY KEY, sz BLOB);
INSERT INTO FTS_entries_docsize VALUES(1,X'0102');
INSERT INTO FTS_entries_docsize VALUES(2,X'0104');
INSERT INTO FTS_entries_docsize VALUES(3,X'0104');
INSERT INTO FTS_entries_docsize VALUES(4,X'0104');
INSERT INTO FTS_entries_docsize VALUES(5,X'0104');
INSERT INTO FTS_entries_docsize VALUES(6,X'0105');
INSERT INTO FTS_entries_docsize VALUES(7,X'0106');
INSERT INTO FTS_entries_docsize VALUES(8,X'0106');
INSERT INTO FTS_entries_docsize VALUES(9,X'0104');
INSERT INTO FTS_entries_docsize VALUES(10,X'0104');
INSERT INTO FTS_entries_docsize VALUES(11,X'0103');
INSERT INTO FTS_entries_docsize VALUES(12,X'0104');
INSERT INTO FTS_entries_docsize VALUES(13,X'0104');
INSERT INTO FTS_entries_docsize VALUES(14,X'0104');
INSERT INTO FTS_entries_docsize VALUES(15,X'0106');
INSERT INTO FTS_entries_docsize VALUES(16,X'0107');
INSERT INTO FTS_entries_docsize VALUES(17,X'0104');
INSERT INTO FTS_entries_docsize VALUES(18,X'0105');
INSERT INTO FTS_entries_docsize VALUES(19,X'0107');
INSERT INTO FTS_entries_docsize VALUES(20,X'0104');
INSERT INTO FTS_entries_docsize VALUES(21,X'0104');
INSERT INTO FTS_entries_docsize VALUES(22,X'0104');
INSERT INTO FTS_entries_docsize VALUES(23,X'0104');
INSERT INTO FTS_entries_docsize VALUES(24,X'0104');
INSERT INTO FTS_entries_docsize VALUES(25,X'0104');
INSERT INTO FTS_entries_docsize VALUES(26,X'0105');
INSERT INTO FTS_entries_docsize VALUES(27,X'0104');
INSERT INTO FTS_entries_docsize VALUES(28,X'0104');
INSERT INTO FTS_entries_docsize VALUES(29,X'0104');
INSERT INTO FTS_entries_docsize VALUES(30,X'0104');
INSERT INTO FTS_entries_docsize VALUES(31,X'0105');
INSERT INTO FTS_entries_docsize VALUES(32,X'0104');
INSERT INTO FTS_entries_docsize VALUES(33,X'0104');
INSERT INTO FTS_entries_docsize VALUES(34,X'0106');
INSERT INTO FTS_entries_docsize VALUES(35,X'0105');
INSERT INTO FTS_entries_docsize VALUES(36,X'0103');
INSERT INTO FTS_entries_docsize VALUES(37,X'0104');
INSERT INTO FTS_entries_docsize VALUES(38,X'0103');
INSERT INTO FTS_entries_docsize VALUES(39,X'0108');
INSERT INTO FTS_entries_docsize VALUES(40,X'0104');
INSERT INTO FTS_entries_docsize VALUES(41,X'0107');
INSERT INTO FTS_entries_docsize VALUES(42,X'0104');
INSERT INTO FTS_entries_docsize VALUES(43,X'0106');
INSERT INTO FTS_entries_docsize VALUES(44,X'0104');
INSERT INTO FTS_entries_docsize VALUES(45,X'0104');
INSERT INTO FTS_entries_docsize VALUES(46,X'0104');
INSERT INTO FTS_entries_docsize VALUES(47,X'0105');
INSERT INTO FTS_entries_docsize VALUES(48,X'0105');
INSERT INTO FTS_entries_docsize VALUES(49,X'0105');
INSERT INTO FTS_entries_docsize VALUES(50,X'0105');
INSERT INTO FTS_entries_docsize VALUES(51,X'0105');
INSERT INTO FTS_entries_docsize VALUES(52,X'0105');
INSERT INTO FTS_entries_docsize VALUES(53,X'0105');
INSERT INTO FTS_entries_docsize VALUES(54,X'0105');
CREATE TABLE IF NOT EXISTS 'FTS_entries_config'(k PRIMARY KEY, v) WITHOUT ROWID;
INSERT INTO FTS_entries_config VALUES('version',4);
CREATE TABLE skippedEntries (  id          INTEGER PRIMARY KEY,   entityId    INTEGER NOT NULL REFERENCES entities(id),   name        TEXT NOT NULL,   type        INTEGER,   deletedFlag INTEGER DEFAULT 0 );
CREATE TABLE entryFragments (  id        INTEGER PRIMARY KEY,   entryId   INTEGER NOT NULL REFERENCES entries(id) ON DELETE CASCADE,   storageId INTEGER NOT NULL REFERENCES storages(id) ON DELETE CASCADE,   offset    INTEGER,   size      INTEGER );
INSERT INTO entryFragments VALUES(1,3,1,0,1024);
INSERT INTO entryFragments VALUES(2,4,1,0,1024);
INSERT INTO entryFragments VALUES(3,5,1,0,128);
INSERT INTO entryFragments VALUES(4,6,1,0,1024);
INSERT INTO entryFragments VALUES(5,7,1,0,1024);
INSERT INTO entryFragments VALUES(6,8,1,0,1024);
INSERT INTO entryFragments VALUES(7,9,1,0,12);
INSERT INTO entryFragments VALUES(8,10,1,0,18);
INSERT INTO entryFragments VALUES(9,12,1,0,196608);
INSERT INTO entryFragments VALUES(10,13,1,0,12);
INSERT INTO entryFragments VALUES(11,14,1,0,128);
INSERT INTO entryFragments VALUES(12,15,1,0,0);
INSERT INTO entryFragments VALUES(13,17,1,0,1024);
INSERT INTO entryFragments VALUES(14,19,1,0,1024);
INSERT INTO entryFragments VALUES(15,20,1,0,0);
INSERT INTO entryFragments VALUES(16,21,1,0,524288);
INSERT INTO entryFragments VALUES(17,22,1,0,1024);
INSERT INTO entryFragments VALUES(18,23,1,0,524288);
INSERT INTO entryFragments VALUES(19,24,1,0,1024);
INSERT INTO entryFragments VALUES(20,25,1,0,12);
INSERT INTO entryFragments VALUES(21,26,1,0,17);
INSERT INTO entryFragments VALUES(22,27,1,0,12);
INSERT INTO entryFragments VALUES(23,28,1,0,524288);
INSERT INTO entryFragments VALUES(24,29,1,0,12);
INSERT INTO entryFragments VALUES(25,30,1,0,1024);
INSERT INTO entryFragments VALUES(26,31,1,0,524288);
INSERT INTO entryFragments VALUES(27,33,1,0,1024);
INSERT INTO entryFragments VALUES(28,37,1,0,128);
INSERT INTO entryFragments VALUES(29,39,1,0,12);
INSERT INTO entryFragments VALUES(30,41,1,0,128);
INSERT INTO entryFragments VALUES(31,42,1,0,524288);
INSERT INTO entryFragments VALUES(32,43,1,0,128);
INSERT INTO entryFragments VALUES(33,44,1,0,524288);
INSERT INTO entryFragments VALUES(34,45,1,0,524288);
INSERT INTO entryFragments VALUES(35,46,1,0,524288);
INSERT INTO entryFragments VALUES(36,47,1,0,524288);
INSERT INTO entryFragments VALUES(37,48,1,0,524288);
INSERT INTO entryFragments VALUES(38,49,1,0,524288);
INSERT INTO entryFragments VALUES(39,50,1,0,524288);
INSERT INTO entryFragments VALUES(40,51,1,0,524288);
INSERT INTO entryFragments VALUES(41,52,1,0,524288);
INSERT INTO entryFragments VALUES(42,53,1,0,524288);
INSERT INTO entryFragments VALUES(43,54,1,0,524288);
CREATE TABLE fileEntries (  id              INTEGER PRIMARY KEY,   entryId         INTEGER NOT NULL REFERENCES entries(id) ON DELETE CASCADE,   size            INTEGER,   CONSTRAINT fileEntries UNIQUE (entryId) );
INSERT INTO fileEntries VALUES(1,3,1024);
INSERT INTO fileEntries VALUES(2,4,1024);
INSERT INTO fileEntries VALUES(3,5,128);
INSERT INTO fileEntries VALUES(4,6,1024);
INSERT INTO fileEntries VALUES(5,9,12);
INSERT INTO fileEntries VALUES(6,10,18);
INSERT INTO fileEntries VALUES(7,12,196608);
INSERT INTO fileEntries VALUES(8,13,12);
INSERT INTO fileEntries VALUES(9,14,128);
INSERT INTO fileEntries VALUES(10,15,0);
INSERT INTO fileEntries VALUES(11,17,1024);
INSERT INTO fileEntries VALUES(12,19,1024);
INSERT INTO fileEntries VALUES(13,20,0);
INSERT INTO fileEntries VALUES(14,21,524288);
INSERT INTO fileEntries VALUES(15,22,1024);
INSERT INTO fileEntries VALUES(16,23,524288);
INSERT INTO fileEntries VALUES(17,24,1024);
INSERT INTO fileEntries VALUES(18,25,12);
INSERT INTO fileEntries VALUES(19,26,17);
INSERT INTO fileEntries VALUES(20,27,12);
INSERT INTO fileEntries VALUES(21,28,524288);
INSERT INTO fileEntries VALUES(22,29,12);
INSERT INTO fileEntries VALUES(23,30,1024);
INSERT INTO fileEntries VALUES(24,31,524288);
INSERT INTO fileEntries VALUES(25,33,1024);
INSERT INTO fileEntries VALUES(26,37,128);
INSERT INTO fileEntries VALUES(27,39,12);
INSERT INTO fileEntries VALUES(28,41,128);
INSERT INTO fileEntries VALUES(29,42,524288);
INSERT INTO fileEntries VALUES(30,43,128);
INSERT INTO fileEntries VALUES(31,50,524288);
INSERT INTO fileEntries VALUES(32,51,524288);
CREATE TABLE imageEntries (  id             INTEGER PRIMARY KEY,   entryId        INTEGER NOT NULL REFERENCES entries(id) ON DELETE CASCADE,   size           INTEGER,   fileSystemType INTEGER,   blockSize      INTEGER,   CONSTRAINT imageEntries UNIQUE (entryId) );
CREATE TABLE directoryEntries (  id                    INTEGER PRIMARY KEY,   entryId               INTEGER NOT NULL REFERENCES entries(id) ON DELETE CASCADE,   storageId             INTEGER NOT NULL REFERENCES storages(id) ON DELETE CASCADE,   name                  TEXT,   totalEntryCount       INTEGER DEFAULT 0,   totalEntrySize        INTEGER DEFAULT 0,   totalEntryCountNewest INTEGER DEFAULT 0,   totalEntrySizeNewest  INTEGER DEFAULT 0,   CONSTRAINT directoryEntries UNIQUE (entryId) );
INSERT INTO directoryEntries VALUES(1,1,1,'test/data',0,0,0,0);
INSERT INTO directoryEntries VALUES(2,34,1,'test/data/sub_dir_extended_attribute',0,0,0,0);
INSERT INTO directoryEntries VALUES(3,35,1,'test/data/sub_dir.ext',0,0,0,0);
INSERT INTO directoryEntries VALUES(4,36,1,'test/data/delta1',0,0,0,0);
INSERT INTO directoryEntries VALUES(5,38,1,'test/data/delta2',0,0,0,0);
INSERT INTO directoryEntries VALUES(6,40,1,'test/data/sub_dir',0,0,0,0);
CREATE TABLE linkEntries (  id              INTEGER PRIMARY KEY,   entryId         INTEGER NOT NULL REFERENCES entries(id) ON DELETE CASCADE,   storageId       INTEGER NOT NULL REFERENCES storages(id) ON DELETE CASCADE,   destinationName TEXT,   CONSTRAINT linkEntries UNIQUE (entryId) );
INSERT INTO linkEntries VALUES(1,16,1,'not-existing-file');
INSERT INTO linkEntries VALUES(2,18,1,'circular_link.dat');
INSERT INTO linkEntries VALUES(3,32,1,'linkdata.dat');
CREATE TABLE hardlinkEntries (  id      INTEGER PRIMARY KEY,   entryId INTEGER NOT NULL REFERENCES entries(id) ON DELETE CASCADE,   size    INTEGER,   CONSTRAINT hardlinkEntries UNIQUE (entryId) );
INSERT INTO hardlinkEntries VALUES(1,7,1024);
INSERT INTO hardlinkEntries VALUES(2,8,1024);
INSERT INTO hardlinkEntries VALUES(3,44,524288);
INSERT INTO hardlinkEntries VALUES(4,45,524288);
INSERT INTO hardlinkEntries VALUES(5,46,524288);
INSERT INTO hardlinkEntries VALUES(6,47,524288);
INSERT INTO hardlinkEntries VALUES(7,48,524288);
INSERT INTO hardlinkEntries VALUES(8,49,524288);
INSERT INTO hardlinkEntries VALUES(9,52,524288);
INSERT INTO hardlinkEntries VALUES(10,53,524288);
INSERT INTO hardlinkEntries VALUES(11,54,524288);
CREATE TABLE specialEntries (  id          INTEGER PRIMARY KEY,   entryId     INTEGER NOT NULL REFERENCES entries(id) ON DELETE CASCADE,   storageId   INTEGER NOT NULL REFERENCES storages(id) ON DELETE CASCADE,   specialType INTEGER,   major       INTEGER,   minor       INTEGER,   CONSTRAINT specialEntries UNIQUE (entryId) );
INSERT INTO specialEntries VALUES(1,2,1,5,0,0);
INSERT INTO specialEntries VALUES(2,11,1,5,0,0);
CREATE TABLE history (  id                INTEGER PRIMARY KEY,   jobUUID           TEXT NOT NULL,   scheduleUUID      TEXT,   hostName          TEXT,   userName          TEXT,   type              INTEGER,   created           INTEGER,   errorMessage      TEXT,   duration          INTEGER,   totalEntryCount   INTEGER,   totalEntrySize    INTEGER,   skippedEntryCount INTEGER,   skippedEntrySize  INTEGER,   errorEntryCount   INTEGER,   errorEntrySize    INTEGER );
CREATE TABLE log (  text TEXT );
CREATE INDEX bar_index4 ON uuids (jobUUID);
CREATE INDEX bar_index5 ON entities (jobUUID,created,type);
CREATE INDEX bar_index6 ON entities (hostName);
CREATE INDEX bar_index7 ON entities (deletedFlag);
CREATE TRIGGER bar_trigger9 INSERT ON entities   BEGIN     INSERT OR IGNORE INTO uuids       (jobUUID) VALUES (NEW.jobUUID); END;
CREATE INDEX bar_index10 ON storages (uuidId,entityId,name,created,state);
CREATE INDEX bar_index11 ON storages (entityId,name,created,state);
CREATE INDEX bar_index12 ON storages (name,totalEntryCount,created,state);
CREATE INDEX bar_index13 ON storages (created,name,totalEntryCount,state);
CREATE INDEX bar_index14 ON storages (userName);
CREATE INDEX bar_index15 ON storages (state,name,totalEntryCount,created);
CREATE INDEX bar_index16 ON storages (deletedFlag);
CREATE INDEX bar_index17 ON entries (uuidId,entityId,type,name);
CREATE INDEX bar_index18 ON entries (entityId,type,name);
CREATE INDEX bar_index19 ON entries (name,size,type,timeLastChanged);
CREATE INDEX bar_index20 ON entries (type,size,name,timeLastChanged);
CREATE INDEX bar_index21 ON entries (size,type,name,timeLastChanged);
CREATE INDEX bar_index22 ON entries (timeLastChanged,name,size,type);
CREATE INDEX bar_index23 ON entriesNewest (entryId,name,size,timeLastChanged);
CREATE INDEX bar_index24 ON entriesNewest (name,size,type,timeLastChanged);
CREATE INDEX bar_index25 ON entriesNewest (type,entryId,name,size,timeLastChanged);
CREATE INDEX bar_index26 ON entriesNewest (type,size,name,timeLastChanged);
CREATE INDEX bar_index27 ON entriesNewest (size,type,name,timeLastChanged);
CREATE INDEX bar_index28 ON entriesNewest (timeLastChanged,name,size,type);
CREATE INDEX bar_index29 ON entriesNewest (entityId,type,entryId,name,size,timeLastChanged);
CREATE INDEX bar_index30 ON skippedEntries (entityId,type,name);
CREATE INDEX bar_index31 ON skippedEntries (name);
CREATE INDEX bar_index32 ON skippedEntries (type,name);
CREATE INDEX bar_index33 ON entryFragments (entryId);
CREATE INDEX bar_index34 ON entryFragments (storageId);
CREATE INDEX bar_index35 ON fileEntries (entryId);
CREATE INDEX bar_index36 ON imageEntries (entryId);
CREATE INDEX bar_index37 ON directoryEntries (entryId);
CREATE INDEX bar_index38 ON directoryEntries (storageId,name);
CREATE INDEX bar_index39 ON directoryEntries (name);
CREATE INDEX bar_index40 ON linkEntries (entryId);
CREATE INDEX bar_index41 ON linkEntries (storageId);
CREATE INDEX bar_index42 ON hardlinkEntries (entryId);
CREATE INDEX bar_index43 ON specialEntries (entryId);
CREATE INDEX bar_index44 ON specialEntries (storageId);
CREATE INDEX bar_index45 ON history (jobUUID,created,type);
CREATE INDEX bar_index46 ON history (created);
CREATE INDEX bar_index47 ON history (errorMessage);
PRAGMA writable_schema=OFF;
COMMIT;
