/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.spec.RSAPublicKeySpec;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NullCipher;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMParser;
import org.eclipse.swt.widgets.Display;

public class BARServer {
    public static final int PROTOCOL_VERSION_MAJOR = 9;
    public static final int PROTOCOL_VERSION_MINOR = 0;
    public static final String PROTOCOL_VERSION = "9.0";
    public static final String DEFAULT_CA_FILE_NAME = "bar-ca.pem";
    public static final String DEFAULT_CERTIFICATE_FILE_NAME = "bar-server-cert.pem";
    public static final String DEFAULT_KEY_FILE_NAME = "bar-key.pem";
    public static final String DEFAULT_KEYSTORE_FILE_NAME = "bar.jks";
    public static char filePathSeparator = (char)47;
    private static final int SOCKET_READ_TIMEOUT = 60000;
    private static final int TIMEOUT = 120000;
    private static final SimpleDateFormat LOG_TIME_FORMAT = new SimpleDateFormat("HH:mm:ss:SSS");
    private static Date logTime0 = new Date();
    private static byte[] RANDOM_DATA = new byte[64];
    private static Object lock = new Object();
    private static JcaX509CertificateConverter certificateConverter;
    private static Display display;
    private static String name;
    private static int port;
    private static byte[] sessionId;
    private static String passwordEncryptType;
    private static Cipher passwordCipher;
    private static Key passwordKey;
    private static Modes mode;
    private static X509Certificate[] serverCertificateChain;
    private static Socket socket;
    private static boolean expiredCertificate;
    private static boolean matchCommonName;
    private static boolean insecureTLS;
    private static BufferedWriter output;
    private static BufferedReader input;
    private static ReadThread readThread;
    private static CommandThread commandThread;
    private static int setLockCounter;
    public static RemoteListDirectory remoteListDirectory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void connect(Display display, String string, int n, int n2, String string2, String string3, TLSModes tLSModes, boolean bl, String string4) throws ConnectionError {
        Object object;
        Object object2;
        Object object3;
        Object object6 = null;
        BufferedWriter bufferedWriter = null;
        BufferedReader bufferedReader = null;
        assert (string != null);
        assert (n != 0 || n2 != 0);
        class KeyData {
            String caFileName;
            String keystoreFileName;

            KeyData(String string, String string2) {
                this.caFileName = string != null ? string : BARServer.DEFAULT_CA_FILE_NAME;
                this.keystoreFileName = string2 != null ? string2 : BARServer.DEFAULT_KEYSTORE_FILE_NAME;
            }
        }
        KeyData[] keyDataArray = new KeyData[]{new KeyData(string2, string3), new KeyData(DEFAULT_CA_FILE_NAME, DEFAULT_KEYSTORE_FILE_NAME), new KeyData(System.getProperty("user.home") + File.separator + ".bar" + File.separator + DEFAULT_CA_FILE_NAME, System.getProperty("user.home") + File.separator + ".bar" + File.separator + DEFAULT_KEYSTORE_FILE_NAME), new KeyData("/etc" + File.separator + DEFAULT_CA_FILE_NAME, "/etc" + File.separator + DEFAULT_KEYSTORE_FILE_NAME), new KeyData("/etc/ssl" + File.separator + "private" + File.separator + DEFAULT_CA_FILE_NAME, "/etc/ssl" + File.separator + "private" + File.separator + DEFAULT_KEYSTORE_FILE_NAME)};
        ConnectionError connectionError = null;
        if (object6 == null && n != 0 && (tLSModes == TLSModes.TRY || tLSModes == TLSModes.FORCE)) {
            for (KeyData object7 : keyDataArray) {
                if (object7.caFileName == null) continue;
                File file = new File(object7.caFileName);
                Object object4 = object3 = object7.keystoreFileName != null ? new File(object7.keystoreFileName) : null;
                if (!file.exists() || !file.isFile() || !file.canRead()) continue;
                Object iOException = null;
                iOException = null;
                try {
                    object2 = BARServer.getSSLSocketFactory(file, ((File)object3).exists() && ((File)object3).isFile() && ((File)object3).canRead() ? object3 : null, bl, "");
                    iOException = new Socket(string, n);
                    ((Socket)iOException).setSoTimeout(60000);
                    ((Socket)iOException).setTcpNoDelay(true);
                    bufferedReader = new BufferedReader(new InputStreamReader(((Socket)iOException).getInputStream(), "UTF-8"));
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter(((Socket)iOException).getOutputStream(), "UTF-8"));
                    BARServer.initSession(display, bufferedReader, bufferedWriter);
                    BARServer.syncExecuteCommand(bufferedReader, bufferedWriter, StringParser.format("START_TLS", new Object[0]), 2);
                    iOException = (SSLSocket)((SSLSocketFactory)object2).createSocket((Socket)iOException, string, n2, false);
                    BARServer.sslHandshake(display, (SSLSocket)iOException, 60000);
                    bufferedReader = new BufferedReader(new InputStreamReader(((Socket)iOException).getInputStream(), "UTF-8"));
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter(((Socket)iOException).getOutputStream(), "UTF-8"));
                    object6 = iOException;
                    if (Settings.debugLevel <= 0) break;
                    System.err.println("Network: TLS socket with PEM certificate+startSSL (CA: " + file.getPath() + ")");
                    break;
                }
                catch (BARException connectException) {
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(BARControl.tr("Connection to host ''{0}:{1}'' failed (error: {2})", string, Integer.toString(n), connectException.getMessage()));
                }
                catch (ConnectionError noRouteToHostException) {
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(BARControl.tr("Connection to host ''{0}:{1}'' failed (error: {2})", string, Integer.toString(n), noRouteToHostException.getMessage()));
                }
                catch (SSLHandshakeException unknownHostException) {
                    if (connectionError != null) continue;
                    if (expiredCertificate) {
                        connectionError = new ConnectionError(BARControl.tr("TLS/SSL failure: expired certificate", new Object[0]));
                        continue;
                    }
                    connectionError = new ConnectionError(BARControl.tr("TLS/SSL failure: {0}", BARControl.reniceSSLException(unknownHostException).getMessage()), serverCertificateChain != null ? serverCertificateChain[0].toString() : null);
                }
                catch (SSLException iOException2) {
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(BARControl.tr("TLS/SSL failure: {0}", BARControl.reniceSSLException(iOException2).getMessage()));
                }
                catch (SocketTimeoutException exception) {
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(BARControl.tr("Host ''{0}:{1}'' unreachable (error: {2})", string, Integer.toString(n), exception.getMessage()));
                }
                catch (ConnectException connectException) {
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(BARControl.tr("Connection to host ''{0}:{1}'' refused", string, Integer.toString(n)));
                }
                catch (NoRouteToHostException noRouteToHostException) {
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(BARControl.tr("Host ''{0}:{1}'' unreachable (error: no route to host)", string, Integer.toString(n)));
                }
                catch (UnknownHostException unknownHostException) {
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(BARControl.tr("Unknown host ''{0}:{1}''", string, Integer.toString(n)));
                }
                catch (IOException iOException2) {
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(BARControl.reniceIOException(iOException2).getMessage());
                }
                catch (Exception exception) {
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(exception.getMessage());
                }
                finally {
                    if (object6 == null) {
                        if (iOException != null) {
                            try {
                                ((Socket)iOException).close();
                            }
                            catch (IOException iOException3) {}
                        }
                        if (iOException != null) {
                            try {
                                ((Socket)iOException).close();
                            }
                            catch (IOException iOException4) {}
                        }
                    }
                }
            }
        }
        if (object6 == null && n2 != 0 && (tLSModes == TLSModes.TRY || tLSModes == TLSModes.FORCE)) {
            for (KeyData keyData : keyDataArray) {
                if (keyData.caFileName == null) continue;
                File file = new File(keyData.caFileName);
                Object object5 = object3 = keyData.keystoreFileName != null ? new File(keyData.keystoreFileName) : null;
                if (!file.exists() || !file.isFile() || !file.canRead()) continue;
                iOException = null;
                try {
                    iOException = BARServer.getSSLSocketFactory(file, ((File)object3).exists() && ((File)object3).isFile() && ((File)object3).canRead() ? object3 : null, bl, "");
                    iOException = (SSLSocket)((SocketFactory)iOException).createSocket(string, n2);
                    BARServer.sslHandshake(display, (SSLSocket)iOException, 60000);
                    bufferedReader = new BufferedReader(new InputStreamReader(((Socket)iOException).getInputStream(), "UTF-8"));
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter(((Socket)iOException).getOutputStream(), "UTF-8"));
                    BARServer.initSession(display, bufferedReader, bufferedWriter);
                    object6 = iOException;
                    if (Settings.debugLevel <= 0) break;
                    System.err.println("Network: TLS socket with PEM certificate (CA: " + file.getPath() + ")");
                    break;
                }
                catch (ConnectionError connectionError2) {
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(BARControl.tr("Connection to host ''{0}:{1}'' failed (error: {2})", string, Integer.toString(n), connectionError2.getMessage()));
                }
                catch (SSLHandshakeException sSLHandshakeException) {
                    Dprintf.dprintf("_");
                    if (connectionError != null) continue;
                    if (expiredCertificate) {
                        connectionError = new ConnectionError(BARControl.tr("TLS/SSL failure: expired certificate", new Object[0]));
                        continue;
                    }
                    connectionError = new ConnectionError(BARControl.tr("TLS/SSL failure: {0}", BARControl.reniceSSLException(sSLHandshakeException).getMessage()), serverCertificateChain != null ? serverCertificateChain[0].toString() : null);
                }
                catch (SSLException iOException3) {
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(BARControl.tr("TLS/SSL failure: {0}", BARControl.reniceSSLException(iOException3).getMessage()));
                }
                catch (SocketTimeoutException connectionError4) {
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(BARControl.tr("Host ''{0}:{1}'' unreachable (error: {2})", string, Integer.toString(n2), connectionError4.getMessage()));
                }
                catch (ConnectException connectException) {
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(BARControl.tr("Connection to host ''{0}:{1}''refused", string, Integer.toString(n2)));
                }
                catch (NoRouteToHostException noRouteToHostException) {
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(BARControl.tr("Host ''{0}:{1}'' unreachable (error: {2})", string, Integer.toString(n2), noRouteToHostException.getMessage()));
                }
                catch (UnknownHostException sSLException) {
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(BARControl.tr("Unknown host ''{0}:{1}''", string, Integer.toString(n2)));
                }
                catch (IOException iOException) {
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(BARControl.reniceIOException(iOException).getMessage());
                }
                catch (Exception exception) {
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(exception.getMessage());
                }
                finally {
                    if (object6 == null && iOException != null) {
                        try {
                            ((Socket)iOException).close();
                        }
                        catch (IOException exception) {}
                    }
                }
            }
        }
        if (object6 == null && n != 0 && (tLSModes == TLSModes.TRY || tLSModes == TLSModes.FORCE)) {
            for (KeyData keyData : keyDataArray) {
                File file;
                if (keyData.keystoreFileName == null || (file = new File(keyData.keystoreFileName)) == null || !file.exists() || !file.isFile() || !file.canRead()) continue;
                object3 = null;
                iOException = null;
                try {
                    iOException = KeyStore.getInstance(KeyStore.getDefaultType());
                    ((KeyStore)iOException).load(new FileInputStream(file), null);
                    System.setProperty("javax.net.ssl.trustStore", file.getAbsolutePath());
                    object2 = (SSLSocketFactory)SSLSocketFactory.getDefault();
                    object3 = new Socket(string, n);
                    ((Socket)object3).setSoTimeout(60000);
                    bufferedReader = new BufferedReader(new InputStreamReader(((Socket)object3).getInputStream(), "UTF-8"));
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter(((Socket)object3).getOutputStream(), "UTF-8"));
                    BARServer.initSession(display, bufferedReader, bufferedWriter);
                    BARServer.syncExecuteCommand(bufferedReader, bufferedWriter, StringParser.format("START_TLS", new Object[0]), 2);
                    iOException = (SSLSocket)((SSLSocketFactory)object2).createSocket((Socket)object3, string, n2, false);
                    BARServer.sslHandshake(display, (SSLSocket)iOException, 60000);
                    bufferedReader = new BufferedReader(new InputStreamReader(((Socket)iOException).getInputStream(), "UTF-8"));
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter(((Socket)iOException).getOutputStream(), "UTF-8"));
                    object6 = iOException;
                    if (Settings.debugLevel <= 0) break;
                    System.err.println("Network: TLS socket with JKS key store+startSSL (key store: " + file.getPath() + ")");
                    break;
                }
                catch (BARException connectException) {
                    try {
                        ((Socket)object3).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(BARControl.tr("Connection to host ''{0}:{1}'' failed (error: {2})", string, Integer.toString(n), connectException.getMessage()));
                }
                catch (ConnectionError noRouteToHostException) {
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(BARControl.tr("Connection to host ''{0}:{1}'' failed (error: {2})", string, Integer.toString(n), noRouteToHostException.getMessage()));
                }
                catch (SSLHandshakeException unknownHostException) {
                    if (connectionError != null) continue;
                    if (expiredCertificate) {
                        connectionError = new ConnectionError(BARControl.tr("TLS/SSL failure: expired certificate", new Object[0]));
                        continue;
                    }
                    connectionError = new ConnectionError(BARControl.tr("TLS/SSL failure: {0}", BARControl.reniceSSLException(unknownHostException).getMessage()), serverCertificateChain != null ? serverCertificateChain[0].toString() : null);
                }
                catch (SSLException iOException4) {
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(BARControl.tr("TLS/SSL failure: {0}", BARControl.reniceSSLException(iOException4).getMessage()));
                }
                catch (SocketTimeoutException exception) {
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(BARControl.tr("Host ''{0}:{1}'' unreachable (error: {2})", string, Integer.toString(n), exception.getMessage()));
                }
                catch (ConnectException throwable) {
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(BARControl.tr("Connection to host ''{0}:{1}'' refused", string, Integer.toString(n)));
                }
                catch (NoRouteToHostException noRouteToHostException) {
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(BARControl.tr("Host ''{0}:{1}'' unreachable (error: no route to host)", string, Integer.toString(n)));
                }
                catch (UnknownHostException unknownHostException) {
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(BARControl.tr("Unknown host ''{0}:{1}''", string, Integer.toString(n)));
                }
                catch (IOException iOException) {
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(BARControl.reniceIOException(iOException).getMessage());
                }
                catch (Exception exception) {
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(exception.getMessage());
                }
                finally {
                    if (object6 == null) {
                        if (iOException != null) {
                            try {
                                ((Socket)iOException).close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (object3 != null) {
                            try {
                                ((Socket)object3).close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
        }
        if (object6 == null && n2 != 0 && (tLSModes == TLSModes.TRY || tLSModes == TLSModes.FORCE)) {
            for (KeyData keyData : keyDataArray) {
                File file;
                if (keyData.keystoreFileName == null || (file = new File(keyData.keystoreFileName)) == null || !file.exists() || !file.isFile() || !file.canRead()) continue;
                object3 = null;
                try {
                    iOException = KeyStore.getInstance(KeyStore.getDefaultType());
                    ((KeyStore)iOException).load(new FileInputStream(file), null);
                    System.setProperty("javax.net.ssl.trustStore", file.getAbsolutePath());
                    iOException = (SSLSocketFactory)SSLSocketFactory.getDefault();
                    object3 = (SSLSocket)((SocketFactory)iOException).createSocket(string, n2);
                    BARServer.sslHandshake(display, (SSLSocket)object3, 60000);
                    bufferedReader = new BufferedReader(new InputStreamReader(((Socket)object3).getInputStream(), "UTF-8"));
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter(((Socket)object3).getOutputStream(), "UTF-8"));
                    BARServer.initSession(display, bufferedReader, bufferedWriter);
                    object6 = object3;
                    if (Settings.debugLevel <= 0) break;
                    System.err.println("Network: TLS socket with JKS key store (key store: " + file.getPath() + ")");
                    break;
                }
                catch (ConnectionError connectionError3) {
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(BARControl.tr("Connection to host ''{0}:{1}'' failed (error: {2})", string, Integer.toString(n), connectionError3.getMessage()));
                }
                catch (SSLHandshakeException sSLHandshakeException) {
                    Dprintf.dprintf("_");
                    if (connectionError != null) continue;
                    if (expiredCertificate) {
                        connectionError = new ConnectionError(BARControl.tr("TLS/SSL failure: expired certificate", new Object[0]));
                        continue;
                    }
                    connectionError = new ConnectionError(BARControl.tr("TLS/SSL failure: {0}", BARControl.reniceSSLException(sSLHandshakeException).getMessage()), serverCertificateChain != null ? serverCertificateChain[0].toString() : null);
                }
                catch (SSLException sSLException) {
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(BARControl.tr("TLS/SSL failure: {0}", BARControl.reniceSSLException(sSLException).getMessage()));
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(BARControl.tr("Host ''{0}:{1}'' unreachable (error: {2})", string, Integer.toString(n2), socketTimeoutException.getMessage()));
                }
                catch (ConnectException connectException) {
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(BARControl.tr("Connection to host ''{0}:{1}'' refused", string, Integer.toString(n2)));
                }
                catch (NoRouteToHostException noRouteToHostException) {
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(BARControl.tr("Host ''{0}:{1}'' unreachable (error: no route to host)", string, Integer.toString(n2)));
                }
                catch (UnknownHostException unknownHostException) {
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(BARControl.tr("Unknown host ''{0}:{1}''", string, Integer.toString(n2)));
                }
                catch (IOException iOException) {
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(BARControl.reniceIOException(iOException).getMessage());
                }
                catch (Exception exception) {
                    if (connectionError != null) continue;
                    connectionError = new ConnectionError(exception.getMessage());
                }
                finally {
                    if (object6 == null && object3 != null) {
                        try {
                            ((Socket)object3).close();
                        }
                        catch (IOException exception) {}
                    }
                }
            }
        }
        if (object6 != null) {
            object = ((SSLSocket)object6).getSession();
            try {
                void var17_41;
                Certificate[] certificateArray = object.getPeerCertificates();
                int n3 = certificateArray.length;
                boolean bl2 = false;
                while (var17_41 < n3) {
                    Certificate certificate = certificateArray[var17_41];
                    if (certificate instanceof X509Certificate) {
                        object3 = (X509Certificate)certificate;
                        iOException = ((X509Certificate)object3).getSubjectX500Principal().getName();
                        try {
                            iOException = new LdapName((String)iOException);
                            for (Rdn rdn : ((LdapName)iOException).getRdns()) {
                                if (!rdn.getType().equalsIgnoreCase("CN") || !rdn.getValue().toString().equals(string)) continue;
                                matchCommonName = true;
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    ++var17_41;
                }
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                // empty catch block
            }
            if (!matchCommonName) {
                insecureTLS = true;
            }
        }
        if (object6 == null && n != 0 && (tLSModes == TLSModes.NONE || tLSModes == TLSModes.TRY)) {
            object = null;
            try {
                object = new Socket(string, n);
                ((Socket)object).setSoTimeout(60000);
                bufferedReader = new BufferedReader(new InputStreamReader(((Socket)object).getInputStream(), "UTF-8"));
                bufferedWriter = new BufferedWriter(new OutputStreamWriter(((Socket)object).getOutputStream(), "UTF-8"));
                BARServer.initSession(display, bufferedReader, bufferedWriter);
                object6 = object;
                if (Settings.debugLevel > 0) {
                    System.err.println("Network: plain socket");
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                if (connectionError == null) {
                    connectionError = new ConnectionError(socketTimeoutException.getMessage());
                }
            }
            catch (ConnectException connectException) {
                if (connectionError == null) {
                    connectionError = new ConnectionError(BARControl.tr("Connection to host ''{0}:{1}'' refused", string, Integer.toString(n)));
                }
            }
            catch (NoRouteToHostException noRouteToHostException) {
                if (connectionError == null) {
                    connectionError = new ConnectionError(BARControl.tr("Host ''{0}:{1}'' unreachable (error: no route to host)", string, Integer.toString(n)));
                }
            }
            catch (UnknownHostException unknownHostException) {
                if (connectionError == null) {
                    connectionError = new ConnectionError(BARControl.tr("Unknown host ''{0}:{1}''", string, Integer.toString(n)));
                }
            }
            catch (Exception exception) {
                if (connectionError == null) {
                    connectionError = new ConnectionError(exception.getMessage());
                }
            }
            finally {
                if (object6 == null && object != null) {
                    try {
                        ((Socket)object).close();
                    }
                    catch (IOException iOException5) {}
                }
            }
        }
        if (object6 == null) {
            if (n2 != 0 || n != 0) {
                throw connectionError;
            }
            throw new ConnectionError(BARControl.tr("No server ports specified", new Object[0]));
        }
        try {
            object = new String[1];
            ValueMap valueMap = new ValueMap();
            BARServer.syncExecuteCommand(bufferedReader, bufferedWriter, StringParser.format("AUTHORIZE encryptType=%s encryptedPassword=%s", passwordEncryptType, BARServer.encryptPassword(string4)), 2);
            BARServer.syncExecuteCommand(bufferedReader, bufferedWriter, "VERSION", 2, valueMap);
            if (valueMap.getInt("major") != 9 && !Settings.debugIgnoreProtocolVersion) {
                throw new CommunicationError(BARControl.tr("Incompatible protocol version for ''{0}:{1}'': : expected {2}, got {3}", string, Integer.toString(((Socket)object6).getPort()), Integer.toString(9), Integer.toString(valueMap.getInt("major"))));
            }
            if (valueMap.getInt("minor") != 0) {
                BARControl.printWarning("incompatible minor protocol version for " + string + ":" + ((Socket)object6).getPort() + ": expected " + 0 + ", got " + valueMap.getInt("minor"), new Object[0]);
            }
            mode = valueMap.getEnum("mode", Modes.class, Modes.MASTER);
            BARServer.syncExecuteCommand(bufferedReader, bufferedWriter, "GET name=PATH_SEPARATOR", 2, valueMap);
            filePathSeparator = valueMap.getChar("value", Character.valueOf('/'));
        }
        catch (BARException bARException) {
            throw new CommunicationError(BARControl.tr("''{0}:{1}'': {2}", string, Integer.toString(((Socket)object6).getPort()), bARException.getMessage()));
        }
        catch (IOException iOException) {
            throw new CommunicationError(BARControl.tr("''{0}:{1}'': {2}", ((Socket)object6).getInetAddress(), Integer.toString(((Socket)object6).getPort()), iOException.getMessage()));
        }
        object = lock;
        synchronized (object) {
            if (socket != null) {
                BARServer.disconnect();
            }
            BARServer.display = display;
            name = string;
            port = ((Socket)object6).getPort();
            socket = object6;
            input = bufferedReader;
            output = bufferedWriter;
        }
        readThread = new ReadThread(display, string, bufferedReader);
        readThread.start();
        commandThread = new CommandThread(display, bufferedWriter);
        commandThread.start();
    }

    public static void connect(String string, int n, int n2, String string2, String string3, TLSModes tLSModes, boolean bl, String string4) {
        BARServer.connect(null, string, n, n2, string2, string3, tLSModes, bl, string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disconnect() {
        block14: {
            try {
                BARServer.executeCommand("JOB_FLUSH", 0);
            }
            catch (BARException bARException) {
            }
            catch (CommunicationError communicationError) {
            }
            catch (ConnectionError connectionError) {
            }
            catch (Throwable throwable) {
                if (Settings.debugLevel <= 0) break block14;
                BARControl.internalError(throwable);
            }
        }
        Object object = lock;
        synchronized (object) {
            block15: {
                if (readThread == null) {
                    return;
                }
                try {
                    readThread.quit();
                    socket.close();
                    socket = null;
                    try {
                        readThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    readThread = null;
                    input.close();
                    input = null;
                    output.close();
                    output = null;
                }
                catch (IOException iOException) {
                }
                catch (Throwable throwable) {
                    if (Settings.debugLevel <= 0) break block15;
                    BARControl.internalError(throwable);
                }
            }
        }
    }

    public static boolean isTLSConnection() {
        return socket instanceof SSLSocket || Settings.debugFakeTLSFlag;
    }

    public static boolean isExpiredCertificate() {
        return expiredCertificate;
    }

    public static boolean isMatchCommonName() {
        return socket instanceof SSLSocket && matchCommonName;
    }

    public static boolean isInsecureTLSConnection() {
        return socket instanceof SSLSocket && (!matchCommonName || insecureTLS);
    }

    public static boolean isMaster() {
        return mode == Modes.MASTER;
    }

    public static boolean isSlave() {
        return mode == Modes.SLAVE;
    }

    public static Modes getMode() {
        return mode;
    }

    public static boolean quit() {
        try {
            try {
                BARServer.executeCommand("JOB_FLUSH", 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                BARServer.executeCommand("QUIT", 0);
            }
            catch (Exception exception) {
                return false;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            commandThread.quit();
            readThread.quit();
            socket.close();
            try {
                readThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            input.close();
            output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public static String getName() {
        return name;
    }

    public static int getPort() {
        return port;
    }

    public static String getInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(name);
        stringBuilder.append(':');
        stringBuilder.append(port);
        if (BARServer.isTLSConnection()) {
            stringBuilder.append(" (TLS");
            if (BARServer.isInsecureTLSConnection()) {
                stringBuilder.append(" insecure");
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Command runCommand(String string, int n, Command.ResultHandler resultHandler, Command.Handler handler) {
        Command command = null;
        Object object = lock;
        synchronized (object) {
            if (readThread == null) {
                return null;
            }
            try {
                command = readThread.commandAdd(string, n, 120000, resultHandler, handler);
                String string2 = String.format("%d %s", command.id, string);
                output.write(string2);
                output.write(10);
                output.flush();
                BARServer.logSent(n, "%s", string2);
            }
            catch (IOException iOException) {
                if (command != null) {
                    readThread.commandRemove(command);
                }
                throw new CommunicationError(BARControl.tr("input/output error: {0}", iOException.getMessage()));
            }
        }
        return command;
    }

    public static Command runCommand(String string, int n) {
        return BARServer.runCommand(string, n, null, null);
    }

    static void abortCommand(Command command) {
        try {
            BARServer.executeCommand(StringParser.format("ABORT commandId=%d", command.id), 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        BARServer.removeCommand(command);
        command.setErrorCode(0);
        command.resultList.clear();
        command.setAborted();
    }

    static void timeoutCommand(Command command) {
        try {
            BARServer.executeCommand(StringParser.format("ABORT commandId=%d", command.id), 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        BARServer.removeCommand(command);
        command.setError(32, "timeout");
        command.resultList.clear();
        command.setAborted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Command asyncExecuteCommand(String string, int n, Command.ResultHandler resultHandler, Command.Handler handler, BusyIndicator busyIndicator) throws BARException, IOException {
        if (busyIndicator != null) {
            busyIndicator.busy(0L);
            if (busyIndicator.isAborted()) {
                throw new BARException(6);
            }
        }
        Command command = null;
        Object object = lock;
        synchronized (object) {
            if (readThread == null) {
                throw new BARException(6);
            }
            try {
                command = readThread.commandAdd(string, n, 120000, resultHandler, handler);
                String string2 = String.format("%d %s", command.id, command.string);
                output.write(string2);
                output.write(10);
                output.flush();
                BARServer.logSent(n, "%s", string2);
            }
            catch (IOException iOException) {
                if (command != null) {
                    readThread.commandRemove(command);
                }
                if (Settings.debugLevel > 0) {
                    BARControl.printStackTrace(iOException);
                }
                throw BARControl.reniceIOException(iOException);
            }
        }
        if (busyIndicator != null) {
            busyIndicator.busy(0L);
            if (busyIndicator.isAborted()) {
                BARServer.abortCommand(command);
                throw new BARException(6);
            }
        }
        return command;
    }

    public static Command asyncExecuteCommand(String string, int n, Command.ResultHandler resultHandler, Command.Handler handler) throws BARException, IOException {
        return BARServer.asyncExecuteCommand(string, n, resultHandler, handler, null);
    }

    public static Command asyncExecuteCommand(String string, int n, Command.ResultHandler resultHandler) throws BARException, IOException {
        return BARServer.asyncExecuteCommand(string, n, resultHandler, null);
    }

    public static Command asyncExecuteCommand(String string, int n) throws BARException, IOException {
        return BARServer.asyncExecuteCommand(string, n, null);
    }

    public static void asyncCommandWait(Command command, BusyIndicator busyIndicator) throws BARException {
        if (display != null && Thread.currentThread() == display.getThread()) {
            display.update();
        }
        while (!(busyIndicator != null && busyIndicator.isAborted() || command.isCompleted() || command.isAborted())) {
            if (display != null && Thread.currentThread() == display.getThread()) {
                final boolean[] blArray = new boolean[]{false};
                display.timerExec(250, new Runnable(){

                    @Override
                    public void run() {
                        blArray[0] = true;
                        display.wake();
                    }
                });
                while (!(blArray[0] || display.isDisposed() || display.readAndDispatch())) {
                    display.sleep();
                }
            } else {
                command.waitCompleted(250L);
            }
            if (busyIndicator == null) continue;
            busyIndicator.busy(0L);
        }
        if (command.isAborted()) {
            BARServer.abortCommand(command);
        }
        if (busyIndicator != null) {
            busyIndicator.busy(0L);
            if (busyIndicator.isAborted()) {
                BARServer.abortCommand(command);
            }
        }
        BARServer.removeCommand(command);
        if (command.getErrorCode() != 0) {
            throw new BARException(command.getErrorCode(), command.getErrorData());
        }
    }

    public static void asyncCommandWait(Command command) throws BARException {
        BARServer.asyncCommandWait(command, null);
    }

    public static void executeCommand(String string, int n, Command.ResultHandler resultHandler, Command.Handler handler, BusyIndicator busyIndicator) throws BARException, IOException {
        Command command = BARServer.asyncExecuteCommand(string, n, resultHandler, handler, busyIndicator);
        if (command == null) {
            throw new BARException(6);
        }
        if (busyIndicator != null) {
            busyIndicator.busy(0L);
            if (busyIndicator.isAborted()) {
                BARServer.abortCommand(command);
                throw new BARException(6);
            }
        }
        BARServer.asyncCommandWait(command, busyIndicator);
        if (busyIndicator != null) {
            busyIndicator.busy(0L);
            if (busyIndicator.isAborted()) {
                throw new BARException(6);
            }
        }
    }

    public static void executeCommand(String string, int n, Command.ResultHandler resultHandler, Command.Handler handler) throws BARException, IOException {
        BARServer.executeCommand(string, n, resultHandler, handler, null);
    }

    public static void executeCommand(String string, int n, Command.ResultHandler resultHandler, BusyIndicator busyIndicator) throws BARException, IOException {
        BARServer.executeCommand(string, n, resultHandler, null, busyIndicator);
    }

    public static void executeCommand(String string, int n, Command.Handler handler, BusyIndicator busyIndicator) throws BARException, IOException {
        BARServer.executeCommand(string, n, null, handler, busyIndicator);
    }

    public static void executeCommand(String string, int n, Command.ResultHandler resultHandler) throws BARException, IOException {
        BARServer.executeCommand(string, n, resultHandler, (Command.Handler)null);
    }

    public static void executeCommand(String string, int n, Command.Handler handler) throws BARException, IOException {
        BARServer.executeCommand(string, n, (Command.ResultHandler)null, handler);
    }

    public static void executeCommand(String string, int n, final ValueMap valueMap, BusyIndicator busyIndicator) throws BARException, IOException {
        if (valueMap != null) {
            valueMap.clear();
        }
        BARServer.executeCommand(string, n, null, new Command.Handler(){

            @Override
            public void handle(Command command) {
                command.getResult(valueMap);
            }
        }, busyIndicator);
    }

    public static void executeCommand(String string, int n, ValueMap valueMap) throws BARException, IOException {
        BARServer.executeCommand(string, n, valueMap, (BusyIndicator)null);
    }

    public static void executeCommand(String string, int n) throws BARException, IOException {
        BARServer.executeCommand(string, n, (ValueMap)null);
    }

    public static int getInt(String string, int n, final String string2) throws BARException, IOException {
        final int[] nArray = new int[]{0};
        BARServer.executeCommand(string, n, new Command.ResultHandler(){

            @Override
            public void handle(int n, ValueMap valueMap) {
                nArray[0] = valueMap.getInt(string2);
            }
        });
        return nArray[0];
    }

    public static long getLong(String string, int n, final String string2) throws BARException, IOException {
        final long[] lArray = new long[]{0L};
        BARServer.executeCommand(string, n, new Command.ResultHandler(){

            @Override
            public void handle(int n, ValueMap valueMap) {
                lArray[0] = valueMap.getLong(string2, 0L);
            }
        });
        return lArray[0];
    }

    public static String getString(String string, int n, final String string2) throws BARException, IOException {
        final String[] stringArray = new String[]{""};
        BARServer.executeCommand(string, n, new Command.ResultHandler(){

            @Override
            public void handle(int n, ValueMap valueMap) {
                stringArray[0] = valueMap.getString(string2);
            }
        });
        return stringArray[0];
    }

    public static <T extends Enum<T>> T getEnum(String string, int n, final String string2, final Class<T> clazz, T t) throws BARException, IOException {
        final Object[] objectArray = new Object[]{t};
        BARServer.executeCommand(string, n, new Command.ResultHandler(){

            @Override
            public void handle(int n, ValueMap valueMap) {
                objectArray[0] = valueMap.getEnum(string2, clazz);
            }
        });
        return (T)((Enum)objectArray[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendResult(long l, int n, boolean bl, int n2, String string, Object ... objectArray) {
        Object object = lock;
        synchronized (object) {
            if (readThread == null) {
                return;
            }
            try {
                String string2;
                if (string != null) {
                    String string3 = StringParser.format(string, objectArray);
                    string2 = String.format("%d %d %d %s", l, bl ? 1 : 0, n2, string3);
                } else {
                    string2 = String.format("%d %d %d", l, bl ? 1 : 0, n2);
                }
                output.write(string2);
                output.write(10);
                output.flush();
                BARServer.logSent(n, "%s", string2);
            }
            catch (IOException iOException) {
                throw new CommunicationError(BARControl.tr("input/output error: {0}", iOException.getMessage()));
            }
        }
    }

    public static void sendResult(long l, int n, boolean bl, int n2) {
        BARServer.sendResult(l, n, bl, n2, null, new Object[0]);
    }

    public static synchronized void lockSet() {
        ++setLockCounter;
    }

    public static synchronized void unlockSet() {
        assert (setLockCounter > 0);
        --setLockCounter;
    }

    public static synchronized boolean isLockedSet() {
        return setLockCounter > 0;
    }

    public static void set(String string, boolean bl) throws BARException, IOException {
        if (!BARServer.isLockedSet()) {
            BARServer.executeCommand(StringParser.format("SET name=%s value=%s", string, bl ? "yes" : "no"), 0);
        }
    }

    static void set(String string, long l) throws BARException, IOException {
        if (!BARServer.isLockedSet()) {
            BARServer.executeCommand(StringParser.format("SET name=%s value=%d", string, l), 0);
        }
    }

    public static void set(String string, String string2) throws BARException, IOException {
        if (!BARServer.isLockedSet()) {
            BARServer.executeCommand(StringParser.format("SET name=% value=%S", string, string2), 0);
        }
    }

    public static <T> T getJobOption(String string, String string2, Class clazz) throws BARException, IOException {
        Object object;
        block13: {
            object = null;
            try {
                ValueMap valueMap = new ValueMap();
                BARServer.executeCommand(StringParser.format("JOB_OPTION_GET jobUUID=%s name=%S", string, string2), 0, valueMap);
                assert (valueMap.size() > 0);
                if (clazz == Boolean.class) {
                    object = valueMap.getBoolean("value", false);
                } else if (clazz == Integer.class) {
                    object = valueMap.getInt("value", 0);
                } else if (clazz == Long.class) {
                    object = valueMap.getLong("value", 0L);
                } else if (clazz == String.class) {
                    object = valueMap.getString("value", "");
                }
            }
            catch (BARException bARException) {
                if (clazz == Boolean.class) {
                    object = false;
                }
                if (clazz == Integer.class) {
                    object = 0;
                }
                if (clazz == Long.class) {
                    object = 0L;
                }
                if (clazz != String.class) break block13;
                object = new String("");
            }
        }
        return (T)object;
    }

    public static boolean getBooleanJobOption(String string, String string2) throws BARException, IOException {
        return (Boolean)BARServer.getJobOption(string, string2, Boolean.class);
    }

    public static long getLongJobOption(String string, String string2) throws BARException, IOException {
        return (Long)BARServer.getJobOption(string, string2, Long.class);
    }

    public static String getStringJobOption(String string, String string2) throws BARException, IOException {
        return (String)BARServer.getJobOption(string, string2, String.class);
    }

    public static void setJobOption(String string, String string2, boolean bl) throws BARException, IOException {
        if (!BARServer.isLockedSet()) {
            BARServer.executeCommand(StringParser.format("JOB_OPTION_SET jobUUID=%s name=%S value=%s", string, string2, bl ? "yes" : "no"), 0);
        }
    }

    public static void setJobOption(String string, String string2, long l) throws BARException, IOException {
        if (!BARServer.isLockedSet()) {
            BARServer.executeCommand(StringParser.format("JOB_OPTION_SET jobUUID=%s name=%S value=%d", string, string2, l), 0);
        }
    }

    public static void setJobOption(String string, String string2, String string3) throws BARException, IOException {
        if (!BARServer.isLockedSet()) {
            BARServer.executeCommand(StringParser.format("JOB_OPTION_SET jobUUID=%s name=%S value=%S", string, string2, string3), 0);
        }
    }

    public static void getJobOption(String string, WidgetVariable widgetVariable) throws BARException, IOException {
        ValueMap valueMap = new ValueMap();
        BARServer.executeCommand(StringParser.format("JOB_OPTION_GET jobUUID=%s name=%S", string, widgetVariable.getName()), 0, valueMap);
        assert (valueMap.size() > 0);
        if (widgetVariable.getType() == Boolean.class) {
            widgetVariable.set(valueMap.getBoolean("value", false));
        } else if (widgetVariable.getType() == Integer.class) {
            widgetVariable.set(valueMap.getInt("value", 0));
        } else if (widgetVariable.getType() == Long.class) {
            widgetVariable.set(valueMap.getLong("value", 0L));
        } else if (widgetVariable.getType() == Double.class) {
            widgetVariable.set(valueMap.getDouble("value", 0.0));
        } else if (widgetVariable.getType() == String.class) {
            widgetVariable.set(valueMap.getString("value", ""));
        } else {
            if (widgetVariable.getType() == Enum.class) {
                throw new Error("NYI");
            }
            throw new Error("Type not supported");
        }
    }

    public static void setJobOption(String string, WidgetVariable widgetVariable) throws BARException, IOException {
        if (!BARServer.isLockedSet()) {
            if (widgetVariable.getType() == Boolean.class) {
                BARServer.executeCommand(StringParser.format("JOB_OPTION_SET jobUUID=%s name=%S value=%s", string, widgetVariable.getName(), widgetVariable.getBoolean() ? "yes" : "no"), 0);
            } else if (widgetVariable.getType() == Integer.class) {
                BARServer.executeCommand(StringParser.format("JOB_OPTION_SET jobUUID=%s name=%S value=%d", string, widgetVariable.getName(), widgetVariable.getInteger()), 0);
            } else if (widgetVariable.getType() == Long.class) {
                BARServer.executeCommand(StringParser.format("JOB_OPTION_SET jobUUID=%s name=%S value=%ld", string, widgetVariable.getName(), widgetVariable.getLong()), 0);
            } else if (widgetVariable.getType() == Double.class) {
                BARServer.executeCommand(StringParser.format("JOB_OPTION_SET jobUUID=%s name=%S value=%f", string, widgetVariable.getName(), widgetVariable.getDouble()), 0);
            } else if (widgetVariable.getType() == String.class) {
                BARServer.executeCommand(StringParser.format("JOB_OPTION_SET jobUUID=%s name=%S value=%'S", string, widgetVariable.getName(), widgetVariable.getString()), 0);
            } else {
                if (widgetVariable.getType() == Enum.class) {
                    throw new Error("NYI");
                }
                throw new Error("Type not supported");
            }
        }
    }

    public static <T> T getScheduleOption(String string, String string2, String string3, Class clazz) throws BARException, IOException {
        Comparable<Boolean> comparable = null;
        ValueMap valueMap = new ValueMap();
        BARServer.executeCommand(StringParser.format("SCHEDULE_OPTION_GET jobUUID=%s scheduleUUID=%s name=%S", string, string2, string3), 0, valueMap);
        assert (valueMap.size() > 0);
        if (clazz == Boolean.class) {
            comparable = valueMap.getBoolean("value");
        } else if (clazz == Integer.class) {
            comparable = valueMap.getInt("value");
        } else if (clazz == Long.class) {
            comparable = valueMap.getLong("value");
        } else if (clazz == String.class) {
            comparable = valueMap.get("value");
        }
        return (T)comparable;
    }

    public static void setScheduleOption(String string, String string2, String string3, boolean bl) throws BARException, IOException {
        BARServer.executeCommand(StringParser.format("SCHEDULE_OPTION_SET jobUUID=%s scheduleUUID=%s name=%S value=%s", string, string2, string3, bl ? "yes" : "no"), 0);
    }

    public static void setScheduleOption(String string, String string2, String string3, long l) throws BARException, IOException {
        BARServer.executeCommand(StringParser.format("SCHEDULE_OPTION_SET jobUUID=%s scheduleUUID=%s name=%S value=%d", string, string2, string3, l), 0);
    }

    public static void setScheduleOption(String string, String string2, String string3, String string4) throws BARException, IOException {
        BARServer.executeCommand(StringParser.format("SCHEDULE_OPTION_SET jobUUID=%s scheduleUUID=%s name=%S value=%S", string, string2, string3, string4), 0);
    }

    public static <T> T getServerOption(String string, Class clazz) throws BARException, IOException {
        Comparable<Boolean> comparable = null;
        ValueMap valueMap = new ValueMap();
        BARServer.executeCommand(StringParser.format("SERVER_OPTION_GET name=%S", string), 0, valueMap);
        assert (valueMap.size() > 0);
        if (clazz == Boolean.class) {
            comparable = valueMap.getBoolean("value");
        } else if (clazz == Integer.class) {
            comparable = valueMap.getInt("value");
        } else if (clazz == Long.class) {
            comparable = valueMap.getLong("value");
        } else if (clazz == String.class) {
            comparable = valueMap.get("value");
        }
        return (T)comparable;
    }

    public static <T> T getServerOption(WidgetVariable widgetVariable, Class clazz) throws BARException, IOException {
        return BARServer.getServerOption(widgetVariable.getName(), clazz);
    }

    public static boolean getBooleanServerOption(String string) throws BARException, IOException {
        return (Boolean)BARServer.getServerOption(string, Boolean.class);
    }

    public static long getLongServerOption(String string) throws BARException, IOException {
        return (Long)BARServer.getServerOption(string, Long.class);
    }

    public static String getStringServerOption(String string) throws BARException, IOException {
        return (String)BARServer.getServerOption(string, String.class);
    }

    public static void setServerOption(String string, boolean bl) throws BARException, IOException {
        BARServer.executeCommand(StringParser.format("SERVER_OPTION_SET name=%S value=%s", string, bl ? "yes" : "no"), 0);
    }

    public static void setServerOption(String string, long l) throws BARException, IOException {
        BARServer.executeCommand(StringParser.format("SERVER_OPTION_SET name=%S value=%d", string, l), 0);
    }

    public static void setServerOption(String string, String string2) throws BARException, IOException {
        BARServer.executeCommand(StringParser.format("SERVER_OPTION_SET name=%S value=%S", string, string2), 0);
    }

    public static void getServerOption(WidgetVariable widgetVariable) {
        block8: {
            try {
                ValueMap valueMap = new ValueMap();
                BARServer.executeCommand(StringParser.format("SERVER_OPTION_GET name=%S", widgetVariable.getName()), 0, valueMap);
                if (widgetVariable.getType() == Boolean.class) {
                    widgetVariable.set(valueMap.getBoolean("value"));
                    break block8;
                }
                if (widgetVariable.getType() == Integer.class) {
                    widgetVariable.set(valueMap.getInt("value"));
                    break block8;
                }
                if (widgetVariable.getType() == Long.class) {
                    widgetVariable.set(valueMap.getLong("value"));
                    break block8;
                }
                if (widgetVariable.getType() == Double.class) {
                    widgetVariable.set(valueMap.getDouble("value"));
                    break block8;
                }
                if (widgetVariable.getType() == String.class) {
                    widgetVariable.set(valueMap.getString("value"));
                    break block8;
                }
                if (widgetVariable.getType() == Enum.class) {
                    throw new Error("NYI");
                }
                throw new Error("Type not supported");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setServerOption(WidgetVariable widgetVariable) {
        block8: {
            try {
                if (widgetVariable.getType() == Boolean.class) {
                    BARServer.executeCommand(StringParser.format("SERVER_OPTION_SET name=%S value=%s", widgetVariable.getName(), widgetVariable.getBoolean() ? "yes" : "no"), 0);
                    break block8;
                }
                if (widgetVariable.getType() == Integer.class) {
                    BARServer.executeCommand(StringParser.format("SERVER_OPTION_SET name=%S value=%d", widgetVariable.getName(), widgetVariable.getInteger()), 0);
                    break block8;
                }
                if (widgetVariable.getType() == Long.class) {
                    BARServer.executeCommand(StringParser.format("SERVER_OPTION_SET name=%S value=%ld", widgetVariable.getName(), widgetVariable.getLong()), 0);
                    break block8;
                }
                if (widgetVariable.getType() == Double.class) {
                    BARServer.executeCommand(StringParser.format("SERVER_OPTION_SET name=%S value=%f", widgetVariable.getName(), widgetVariable.getDouble()), 0);
                    break block8;
                }
                if (widgetVariable.getType() == String.class) {
                    BARServer.executeCommand(StringParser.format("SERVER_OPTION_SET name=%S value=%'S", widgetVariable.getName(), widgetVariable.getString()), 0);
                    break block8;
                }
                if (widgetVariable.getType() == Enum.class) {
                    throw new Error("NYI");
                }
                throw new Error("Type not supported");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void flushServerOption() throws BARException, IOException {
        BARServer.executeCommand(StringParser.format("SERVER_OPTION_FLUSH", new Object[0]), 0);
    }

    public static String getPasswordEncryptType() {
        return passwordEncryptType;
    }

    public static String encryptPassword(String string) throws CommunicationError {
        byte[] byArray = new byte[]{};
        if (string != null) {
            byte[] byArray2 = new byte[sessionId.length];
            try {
                byte[] byArray3 = string.getBytes("UTF-8");
                for (int i = 0; i < sessionId.length; ++i) {
                    byArray2[i] = i < byArray3.length ? (byte)(byArray3[i] ^ sessionId[i]) : sessionId[i];
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new CommunicationError(BARControl.tr("Password encryption fail", new Object[0]));
            }
            try {
                passwordCipher.init(1, passwordKey);
                byArray = passwordCipher.doFinal(byArray2);
            }
            catch (InvalidKeyException invalidKeyException) {
                BARControl.logThrowable(invalidKeyException);
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                BARControl.logThrowable(illegalBlockSizeException);
            }
            catch (BadPaddingException badPaddingException) {
                BARControl.logThrowable(badPaddingException);
            }
            if (byArray == null) {
                throw new CommunicationError(BARControl.tr("Password encryption fail", new Object[0]));
            }
        }
        return "base64:" + BARServer.base64Encode(byArray);
    }

    public static RemoteListDirectory remoteListDirectory(String string) {
        return new RemoteListDirectory(string);
    }

    private static boolean isValidCertificate(KeyStore keyStore, X509Certificate x509Certificate) {
        try {
            x509Certificate.checkValidity();
            for (String string : Collections.list(keyStore.aliases())) {
                try {
                    if (!keyStore.isCertificateEntry(string)) continue;
                    Certificate certificate = keyStore.getCertificate(string);
                    x509Certificate.verify(certificate.getPublicKey());
                    return true;
                }
                catch (Exception exception) {
                }
            }
        }
        catch (KeyStoreException keyStoreException) {
        }
        catch (CertificateExpiredException certificateExpiredException) {
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            // empty catch block
        }
        return false;
    }

    private static boolean isCertificateExpired(KeyStore keyStore, X509Certificate x509Certificate) {
        try {
            x509Certificate.checkValidity();
            return false;
        }
        catch (CertificateExpiredException certificateExpiredException) {
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            // empty catch block
        }
        return true;
    }

    private static SSLSocketFactory getSSLSocketFactory(File file, File file2, final boolean bl, String string) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, IOException, CertificateException {
        Object object;
        char[] cArray = string != null ? string.toCharArray() : new char[]{};
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(new FileInputStream(file2 != null ? file2 : new File(System.getProperty("java.home"), "lib/security/cacerts".replace('/', File.separatorChar))), null);
        if (file != null) {
            PEMParser pEMParser = new PEMParser(new FileReader(file));
            X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)pEMParser.readObject();
            pEMParser.close();
            object = certificateConverter.getCertificate(x509CertificateHolder);
            if (BARServer.isCertificateExpired(keyStore, (X509Certificate)object)) {
                expiredCertificate = true;
            }
            keyStore.setEntry("ca-certificate", new KeyStore.TrustedCertificateEntry((Certificate)object), null);
        }
        object = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        ((KeyManagerFactory)object).init(keyStore, cArray);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        final X509TrustManager[] x509TrustManagerArray = new X509TrustManager[]{null};
        serverCertificateChain = null;
        X509TrustManager x509TrustManager = new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                if (!bl) {
                    return x509TrustManagerArray[0].getAcceptedIssuers();
                }
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                if (!bl) {
                    x509TrustManagerArray[0].checkClientTrusted(x509CertificateArray, string);
                }
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                BARServer.access$202(x509CertificateArray);
                if (!bl) {
                    x509TrustManagerArray[0].checkServerTrusted(x509CertificateArray, string);
                }
            }
        };
        for (int i = 0; i < trustManagerArray.length; ++i) {
            if (!(trustManagerArray[i] instanceof X509TrustManager)) continue;
            x509TrustManagerArray[0] = (X509TrustManager)trustManagerArray[i];
            trustManagerArray[i] = x509TrustManager;
            break;
        }
        SSLContext sSLContext = SSLContext.getInstance("TLSv1.2");
        sSLContext.init(((KeyManagerFactory)object).getKeyManagers(), trustManagerArray, null);
        return sSLContext.getSocketFactory();
    }

    private static boolean validBase64Char(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '+' || c == '/';
    }

    private static byte[] base64Decode(String string) {
        byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 0, 0, 0, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 0, 0, 0, 0, 0, 0, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int n = string.length();
        byte[] byArray2 = new byte[n * 3 / 4];
        int n2 = 0;
        char c = '\u0000';
        char c2 = '\u0000';
        char c3 = '\u0000';
        char c4 = '\u0000';
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        int n3 = 0;
        while (n3 + 4 < n) {
            byte by5;
            byte by6;
            c = string.charAt(n3 + 0);
            c2 = string.charAt(n3 + 1);
            c3 = string.charAt(n3 + 2);
            c4 = string.charAt(n3 + 3);
            if (!BARServer.validBase64Char(c)) {
                return null;
            }
            if (!BARServer.validBase64Char(c2)) {
                return null;
            }
            if (c3 == '=' && c4 == '=') {
                by = byArray[(byte)c];
                by2 = byArray[(byte)c2];
                byArray2[n2] = by6 = (byte)(by << 2 | (by2 & 0x30) >> 4);
                ++n2;
            } else if (c4 == '=') {
                if (!BARServer.validBase64Char(c3)) {
                    return null;
                }
                by = byArray[(byte)c];
                by2 = byArray[(byte)c2];
                by3 = byArray[(byte)c3];
                by6 = (byte)(by << 2 | (by2 & 0x30) >> 4);
                by5 = (byte)((by2 & 0xF) << 4 | (by3 & 0x3C) >> 2);
                byArray2[n2] = by6;
                byArray2[++n2] = by5;
                ++n2;
            } else {
                if (!BARServer.validBase64Char(c3)) {
                    return null;
                }
                if (!BARServer.validBase64Char(c4)) {
                    return null;
                }
                by = byArray[(byte)c];
                by2 = byArray[(byte)c2];
                by3 = byArray[(byte)c3];
                by4 = byArray[(byte)c4];
                by6 = (byte)(by << 2 | (by2 & 0x30) >> 4);
                by5 = (byte)((by2 & 0xF) << 4 | (by3 & 0x3C) >> 2);
                byte by7 = (byte)((by3 & 3) << 6 | by4);
                byArray2[n2] = by6;
                byArray2[++n2] = by5;
                byArray2[++n2] = by7;
                ++n2;
            }
            n3 += 4;
        }
        return byArray2;
    }

    private static String base64Encode(byte[] byArray) {
        char[] cArray = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        if (byArray.length > 0) {
            int n;
            int n2;
            int n3;
            byte by;
            byte by2;
            int n4 = 0;
            while (n4 + 2 < byArray.length) {
                by2 = byArray[n4 + 0];
                by = byArray[n4 + 1];
                byte by3 = byArray[n4 + 2];
                n3 = (by2 & 0xFC) >> 2;
                assert (n3 < 64);
                n2 = (by2 & 3) << 4 | (by & 0xF0) >> 4;
                assert (n2 < 64);
                n = (by & 0xF) << 2 | (by3 & 0xC0) >> 6;
                assert (n < 64);
                int n5 = by3 & 0x3F;
                assert (n5 < 64);
                stringBuilder.append(cArray[n3]);
                stringBuilder.append(cArray[n2]);
                stringBuilder.append(cArray[n]);
                stringBuilder.append(cArray[n5]);
                n4 += 3;
            }
            if (n4 + 2 >= byArray.length) {
                by2 = byArray[n4 + 0];
                by = byArray[n4 + 1];
                n3 = (by2 & 0xFC) >> 2;
                assert (n3 < 64);
                n2 = (by2 & 3) << 4 | (by & 0xF0) >> 4;
                assert (n2 < 64);
                n = (by & 0xF) << 2;
                assert (n < 64);
                stringBuilder.append(cArray[n3]);
                stringBuilder.append(cArray[n2]);
                stringBuilder.append(cArray[n]);
                stringBuilder.append('=');
            } else if (n4 + 1 >= byArray.length) {
                by2 = byArray[n4 + 0];
                n3 = (by2 & 0xFC) >> 2;
                assert (n3 < 64);
                n2 = (by2 & 3) << 4;
                assert (n2 < 64);
                stringBuilder.append(cArray[n3]);
                stringBuilder.append(cArray[n2]);
                stringBuilder.append('=');
                stringBuilder.append('=');
            }
        }
        return stringBuilder.toString();
    }

    private static byte[] hexDecode(String string) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < string.length() / 2; ++i) {
            byArray[i] = (byte)Integer.parseInt(string.substring(i * 2, i * 2 + 2), 16);
        }
        return byArray;
    }

    private static String hexEncode(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append(String.format("%02x", byArray[i] & 0xFF));
        }
        return stringBuilder.toString();
    }

    private static void sslHandshake(Display display, final SSLSocket sSLSocket, int n) throws IOException {
        final IOException[] iOExceptionArray = new IOException[]{null};
        sSLSocket.setSoTimeout(n);
        sSLSocket.setTcpNoDelay(true);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    sSLSocket.startHandshake();
                }
                catch (IOException iOException) {
                    iOExceptionArray[0] = iOException;
                }
            }
        });
        thread.start();
        while (thread.getState() != Thread.State.TERMINATED) {
            if (display != null) {
                while (!display.isDisposed() && display.readAndDispatch()) {
                }
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (iOExceptionArray[0] != null) {
            throw iOExceptionArray[0];
        }
    }

    private static void initSession(Display display, final BufferedReader bufferedReader, BufferedWriter bufferedWriter) throws IOException {
        sessionId = null;
        passwordEncryptType = null;
        passwordCipher = null;
        mode = Modes.MASTER;
        final IOException[] iOExceptionArray = new IOException[]{null};
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String[] stringArray = new String[1];
                    ValueMap valueMap = new ValueMap();
                    String string = bufferedReader.readLine();
                    if (string == null) {
                        throw new CommunicationError(BARControl.tr("No result from server", new Object[0]));
                    }
                    BARServer.logReceived(1, "%s", string);
                    String[] stringArray2 = string.split(" ", 2);
                    if (stringArray2.length < 2 || !stringArray2[0].equals("SESSION")) {
                        throw new CommunicationError(BARControl.tr("Invalid response from server: expected SESSION", new Object[0]));
                    }
                    if (!StringParser.parse(stringArray2[1], valueMap)) {
                        throw new CommunicationError(BARControl.tr("Invalid response from server: expected parameters", new Object[0]));
                    }
                    BARServer.access$302(BARServer.hexDecode(valueMap.getString("id")));
                    if (sessionId == null) {
                        throw new CommunicationError(BARControl.tr("No session id", new Object[0]));
                    }
                    String[] stringArray3 = valueMap.getString("encryptTypes").split(",");
                    for (int i = 0; i < stringArray3.length && passwordCipher == null; ++i) {
                        if (stringArray3[i].equalsIgnoreCase("RSA")) {
                            try {
                                BigInteger bigInteger = valueMap.containsKey("n") ? new BigInteger(valueMap.getString("n"), 16) : null;
                                BigInteger bigInteger2 = valueMap.containsKey("e") ? new BigInteger(valueMap.getString("e"), 16) : null;
                                RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(bigInteger, bigInteger2);
                                PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(rSAPublicKeySpec);
                                passwordEncryptType = "RSA";
                                passwordCipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
                                passwordKey = publicKey;
                            }
                            catch (Exception exception) {
                                if (Settings.debugLevel <= 0) continue;
                                BARControl.printStackTrace(exception);
                            }
                            continue;
                        }
                        if (!stringArray3[i].equalsIgnoreCase("NONE")) continue;
                        passwordEncryptType = "NONE";
                        passwordCipher = new NullCipher();
                        passwordKey = null;
                    }
                }
                catch (IOException iOException) {
                    iOExceptionArray[0] = iOException;
                }
            }
        });
        thread.start();
        while (thread.getState() != Thread.State.TERMINATED) {
            if (display != null) {
                while (!display.isDisposed() && display.readAndDispatch()) {
                }
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (iOExceptionArray[0] != null) {
            throw iOExceptionArray[0];
        }
        if (passwordCipher == null) {
            throw new CommunicationError(BARControl.tr("Init password cipher fail", new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncExecuteCommand(BufferedReader bufferedReader, BufferedWriter bufferedWriter, String string, int n, ValueMap valueMap) throws IOException, BARException {
        Object object = lock;
        synchronized (object) {
            String[] stringArray;
            Command command = new Command(string, 0);
            String string2 = String.format("%d %s", command.id, command.string);
            bufferedWriter.write(string2);
            bufferedWriter.write(10);
            bufferedWriter.flush();
            BARServer.logSent(n, "%s", string2);
            do {
                if ((string2 = bufferedReader.readLine()) == null) {
                    throw new CommunicationError(BARControl.tr("No result from server", new Object[0]));
                }
                BARServer.logReceived(n, "%s", string2);
                stringArray = string2.split(" ", 4);
                if (stringArray.length >= 3) continue;
                throw new CommunicationError(BARControl.tr("Invalid response from server: incomplete response ''{0}''", string2));
            } while ((long)Integer.parseInt(stringArray[0]) != command.id);
            if (Integer.parseInt(stringArray[1]) != 1) {
                throw new CommunicationError(BARControl.tr("Invalid response from server: no command id", new Object[0]));
            }
            int n2 = Integer.parseInt(stringArray[2]);
            if (n2 == 0) {
                if (valueMap != null) {
                    valueMap.clear();
                    if (stringArray.length < 4 || !StringParser.parse(stringArray[3], valueMap)) {
                        throw new CommunicationError(BARControl.tr("Invalid response from server: parameters", new Object[0]));
                    }
                }
            } else {
                if (stringArray.length >= 4) {
                    throw new BARException(n2, stringArray[3]);
                }
                throw new CommunicationError(BARControl.tr("Invalid response from server: parameters", new Object[0]));
            }
        }
    }

    public static void syncExecuteCommand(String string, int n, ValueMap valueMap) throws IOException, BARException {
        BARServer.syncExecuteCommand(input, output, string, n, valueMap);
    }

    public static void syncExecuteCommand(BufferedReader bufferedReader, BufferedWriter bufferedWriter, String string, int n) throws IOException, BARException {
        BARServer.syncExecuteCommand(bufferedReader, bufferedWriter, string, n, null);
    }

    public static void syncExecuteCommand(String string, int n) throws IOException, BARException {
        BARServer.syncExecuteCommand(string, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCommand(Command command) {
        Object object = lock;
        synchronized (object) {
            if (readThread != null) {
                readThread.commandRemove(command);
            }
        }
    }

    public static void process(long l, String string, ValueMap valueMap) {
        commandThread.process(l, string, valueMap);
    }

    public static void logSent(int n, String string, Object ... objectArray) {
        logTime0 = new Date();
        if (Settings.debugLevel > n) {
            String string2 = String.format("%s       ", LOG_TIME_FORMAT.format(logTime0));
            System.err.println("Network sent     " + string2 + ": '" + String.format(string, objectArray) + "'");
        }
    }

    public static void logReceived(int n, String string, Object ... objectArray) {
        if (Settings.debugLevel > n) {
            Date date = new Date();
            long l = date.getTime() - logTime0.getTime();
            String string2 = String.format("%s %4dms", LOG_TIME_FORMAT.format(date), l);
            System.err.println("Network received " + string2 + ": '" + String.format(string, objectArray) + "'");
            if (l > 250L) {
                System.err.println("                              ^^^^^^  WARNING: long duration!");
            }
        }
    }

    static /* synthetic */ X509Certificate[] access$202(X509Certificate[] x509CertificateArray) {
        serverCertificateChain = x509CertificateArray;
        return x509CertificateArray;
    }

    static /* synthetic */ byte[] access$302(byte[] byArray) {
        sessionId = byArray;
        return byArray;
    }

    static {
        display = null;
        serverCertificateChain = null;
        socket = null;
        expiredCertificate = false;
        matchCommonName = false;
        insecureTLS = false;
        Security.addProvider(new BouncyCastleProvider());
        certificateConverter = new JcaX509CertificateConverter().setProvider("BC");
        Random random = new Random(System.currentTimeMillis());
        random.nextBytes(RANDOM_DATA);
        setLockCounter = 0;
        remoteListDirectory = new RemoteListDirectory();
    }

    static class RemoteListDirectory
    extends ListDirectory<RemoteFile> {
        private String jobUUID;
        private ArrayList<RemoteFile> fileList = new ArrayList();
        private Iterator<RemoteFile> iterator;

        RemoteListDirectory(String string) {
            this.jobUUID = string;
        }

        RemoteListDirectory() {
            this(null);
        }

        @Override
        public RemoteFile newFileInstance(String string, String string2) {
            FileTypes fileTypes = FileTypes.FILE;
            long l = 0L;
            long l2 = 0L;
            boolean bl = false;
            if (string != null) {
                if (string.isEmpty() || string.charAt(string.length() - 1) != filePathSeparator) {
                    string = string + filePathSeparator;
                }
                string2 = string + string2;
            }
            try {
                ValueMap valueMap = new ValueMap();
                BARServer.executeCommand(StringParser.format("FILE_INFO jobUUID=%s name=%'S", this.jobUUID != null ? this.jobUUID : "", string2), 1, valueMap);
                fileTypes = valueMap.getEnum("fileType", FileTypes.class);
                string2 = valueMap.getString("name");
                switch (fileTypes) {
                    case FILE: 
                    case HARDLINK: {
                        l = valueMap.getLong("size", 0L);
                        break;
                    }
                    case DIRECTORY: 
                    case LINK: 
                    case SPECIAL: {
                        break;
                    }
                }
                l2 = valueMap.getLong("dateTime", 0L);
                bl = valueMap.getBoolean("hidden", false);
            }
            catch (IOException iOException) {
            }
            catch (BARException bARException) {
                // empty catch block
            }
            if (string2.isEmpty() || string2.charAt(0) != filePathSeparator) {
                string2 = filePathSeparator + string2;
            }
            return new RemoteFile(string2, fileTypes, l, l2, bl);
        }

        @Override
        public RemoteFile getParentFile(RemoteFile remoteFile) {
            return remoteFile.getParentFile();
        }

        @Override
        public String getAbsolutePath(RemoteFile remoteFile) {
            return remoteFile.getAbsolutePath();
        }

        @Override
        public void getShortcuts(List<RemoteFile> list) {
            final HashMap<String, RemoteFile> hashMap = new HashMap<String, RemoteFile>();
            for (String object : Settings.shortcuts) {
                hashMap.put(object, new RemoteFile(object, FileTypes.DIRECTORY, false));
            }
            Command.ResultHandler resultHandler = new Command.ResultHandler(){

                @Override
                public void handle(int n, ValueMap valueMap) {
                    String string = valueMap.getString("name");
                    hashMap.put(string, new RemoteFile(string, false));
                }
            };
            try {
                BARServer.executeCommand(StringParser.format("ROOT_LIST jobUUID=%s allMounts=yes", this.jobUUID != null ? this.jobUUID : ""), 1, resultHandler);
            }
            catch (Exception exception) {
                try {
                    BARServer.executeCommand(StringParser.format("ROOT_LIST allMounts=yes", new Object[0]), 1, resultHandler);
                }
                catch (IOException remoteFile) {
                }
                catch (BARException bARException) {
                    // empty catch block
                }
            }
            list.clear();
            for (RemoteFile remoteFile : hashMap.values()) {
                list.add(remoteFile);
            }
            Collections.sort(list, this);
        }

        @Override
        public void addShortcut(RemoteFile remoteFile) {
            Settings.shortcuts.add(remoteFile.getAbsolutePath());
        }

        @Override
        public void removeShortcut(RemoteFile remoteFile) {
            Settings.shortcuts.remove(remoteFile.getAbsolutePath());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean open(RemoteFile remoteFile) {
            ArrayList<RemoteFile> arrayList = this.fileList;
            synchronized (arrayList) {
                Command.ResultHandler resultHandler = new Command.ResultHandler(){

                    @Override
                    public void handle(int n, ValueMap valueMap) {
                        RemoteFile remoteFile;
                        block10: {
                            remoteFile = null;
                            try {
                                FileTypes fileTypes = valueMap.getEnum("fileType", FileTypes.class);
                                String string = valueMap.getString("name");
                                long l = valueMap.getLong("dateTime", 0L);
                                boolean bl = valueMap.getBoolean("hidden", false);
                                boolean bl2 = valueMap.getBoolean("noDump", false);
                                switch (fileTypes) {
                                    case FILE: {
                                        long l2 = valueMap.getLong("size", 0L);
                                        remoteFile = new RemoteFile(string, FileTypes.FILE, l2, l, bl);
                                        break;
                                    }
                                    case DIRECTORY: {
                                        boolean bl3 = valueMap.getBoolean("noBackup", false);
                                        remoteFile = new RemoteFile(string, FileTypes.DIRECTORY, l, bl);
                                        break;
                                    }
                                    case LINK: {
                                        FileTypes fileTypes2 = valueMap.getEnum("destinationFileType", FileTypes.class);
                                        remoteFile = new RemoteFile(string, fileTypes2, l, bl);
                                        break;
                                    }
                                    case HARDLINK: {
                                        long l3 = valueMap.getLong("size", 0L);
                                        remoteFile = new RemoteFile(string, FileTypes.HARDLINK, l3, l, bl);
                                        break;
                                    }
                                    case SPECIAL: {
                                        remoteFile = new RemoteFile(string, FileTypes.SPECIAL, l, bl);
                                        break;
                                    }
                                    case UNKNOWN: {
                                        remoteFile = new RemoteFile(string, FileTypes.UNKNOWN);
                                    }
                                }
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                if (Settings.debugLevel <= 0) break block10;
                                BARControl.printInternalError(illegalArgumentException);
                            }
                        }
                        RemoteListDirectory.this.fileList.add(remoteFile);
                    }
                };
                this.fileList.clear();
                try {
                    BARServer.executeCommand(StringParser.format("FILE_LIST jobUUID=%s directory=%'S", this.jobUUID != null ? this.jobUUID : "", remoteFile.getAbsolutePath()), 1, resultHandler);
                    this.iterator = this.fileList.listIterator();
                    return true;
                }
                catch (Exception exception) {
                    try {
                        BARServer.executeCommand(StringParser.format("FILE_LIST directory=%'S", remoteFile.getAbsolutePath()), 1, resultHandler);
                        this.iterator = this.fileList.listIterator();
                        return true;
                    }
                    catch (IOException iOException) {
                        this.iterator = null;
                        return false;
                    }
                    catch (BARException bARException) {
                        this.iterator = null;
                        return false;
                    }
                }
            }
        }

        @Override
        public void close() {
            this.iterator = null;
        }

        @Override
        public RemoteFile getNext() {
            return this.iterator.hasNext() ? this.iterator.next() : null;
        }

        @Override
        public boolean isRoot(RemoteFile remoteFile) {
            String string = remoteFile.getAbsolutePath();
            return string.length() == 1 && string.charAt(0) == filePathSeparator;
        }

        @Override
        public boolean isDirectory(RemoteFile remoteFile) {
            return remoteFile.isDirectory();
        }

        @Override
        public boolean isFile(RemoteFile remoteFile) {
            return remoteFile.isFile();
        }

        @Override
        public boolean isHidden(RemoteFile remoteFile) {
            return remoteFile.isHidden();
        }

        @Override
        public boolean exists(RemoteFile remoteFile) {
            return remoteFile.exists();
        }

        @Override
        public void mkdir(RemoteFile remoteFile) throws IOException {
            try {
                BARServer.executeCommand(StringParser.format("FILE_MKDIR name=%'S", remoteFile.getAbsolutePath()), 0);
            }
            catch (BARException bARException) {
                throw new IOException(bARException);
            }
        }

        @Override
        public void delete(RemoteFile remoteFile) throws IOException {
            for (RemoteFile remoteFile2 : this.getRoots()) {
                if (remoteFile2.compareTo(remoteFile) != 0) continue;
                return;
            }
            try {
                BARServer.executeCommand(StringParser.format("FILE_DELETE name=%'S", remoteFile.getAbsolutePath()), 0);
            }
            catch (BARException bARException) {
                throw new IOException(bARException);
            }
        }
    }

    static class RemoteFile
    extends File {
        private File absoluteFile;
        private FileTypes fileType;
        private long size;
        private long dateTime;
        private boolean hiddenFlag;

        public RemoteFile(String string, FileTypes fileTypes, long l, long l2, boolean bl) {
            super(string);
            assert (string.matches("^(?s)/.*") || string.matches("^(?s)[A-Za-z]:.*")) : "'" + string + "' is not absolute";
            this.absoluteFile = new File(string);
            this.fileType = fileTypes;
            this.size = l;
            this.dateTime = l2;
            this.hiddenFlag = bl;
        }

        public RemoteFile(String string, FileTypes fileTypes, long l, boolean bl) {
            this(string, fileTypes, 0L, l, bl);
        }

        public RemoteFile(String string, FileTypes fileTypes, boolean bl) {
            this(string, fileTypes, 0L, bl);
        }

        public RemoteFile(String string, FileTypes fileTypes) {
            this(string, fileTypes, 0L, false);
        }

        public RemoteFile(String string, long l, boolean bl) {
            this(string, FileTypes.DIRECTORY, 0L, l, bl);
        }

        public RemoteFile(String string, boolean bl) {
            this(string, 0L, bl);
        }

        @Override
        public String getPath() {
            return this.absoluteFile.getPath().replace(File.separatorChar, filePathSeparator);
        }

        @Override
        public RemoteFile getAbsoluteFile() {
            return new RemoteFile(this.absoluteFile.getPath(), this.hiddenFlag);
        }

        @Override
        public String getAbsolutePath() {
            return this.absoluteFile.getPath().replace(File.separatorChar, filePathSeparator);
        }

        @Override
        public RemoteFile getParentFile() {
            String string = this.getAbsolutePath();
            int n = string.lastIndexOf(filePathSeparator);
            if (n >= 1) {
                return new RemoteFile(string.substring(0, n), false);
            }
            if (n == 0) {
                return new RemoteFile(Character.toString(filePathSeparator), false);
            }
            return null;
        }

        @Override
        public long length() {
            return this.size;
        }

        @Override
        public long lastModified() {
            return this.dateTime * 1000L;
        }

        @Override
        public boolean isFile() {
            return this.fileType == FileTypes.FILE;
        }

        @Override
        public boolean isDirectory() {
            return this.fileType == FileTypes.DIRECTORY;
        }

        @Override
        public boolean isHidden() {
            return this.hiddenFlag;
        }

        @Override
        public String toString() {
            return "RemoteFile {" + this.absoluteFile + ", " + (Object)((Object)this.fileType) + ", " + this.size + ", " + this.dateTime + "}";
        }
    }

    static enum SpecialTypes {
        NONE,
        DEVICE_CHARACTER,
        DEVICE_BLOCK,
        FIFO,
        SOCKET,
        OTHER;

    }

    static enum FileTypes {
        NONE,
        FILE,
        DIRECTORY,
        LINK,
        HARDLINK,
        SPECIAL,
        UNKNOWN;

    }

    static enum PauseModes {
        NONE,
        CREATE,
        RESTORE,
        UPDATE_INDEX,
        NETWORK;


        public String getText() {
            String string = null;
            switch (this) {
                case NONE: {
                    string = BARControl.tr("none", new Object[0]);
                    break;
                }
                case CREATE: {
                    string = BARControl.tr("create", new Object[0]);
                    break;
                }
                case RESTORE: {
                    string = BARControl.tr("restore", new Object[0]);
                    break;
                }
                case UPDATE_INDEX: {
                    string = BARControl.tr("update index", new Object[0]);
                    break;
                }
                case NETWORK: {
                    string = BARControl.tr("network", new Object[0]);
                }
            }
            return string;
        }
    }

    static enum States {
        RUNNING,
        PAUSED,
        SUSPENDED;


        public String getText() {
            String string = null;
            switch (this) {
                case RUNNING: {
                    string = BARControl.tr("running", new Object[0]);
                    break;
                }
                case PAUSED: {
                    string = BARControl.tr("paused", new Object[0]);
                    break;
                }
                case SUSPENDED: {
                    string = BARControl.tr("suspended", new Object[0]);
                    break;
                }
                default: {
                    string = "";
                }
            }
            return string;
        }
    }

    static enum TLSModes {
        NONE,
        TRY,
        FORCE;


        public String toString() {
            switch (this) {
                default: {
                    return "none";
                }
                case TRY: {
                    return "try";
                }
                case FORCE: 
            }
            return "force";
        }
    }

    static enum Modes {
        MASTER,
        SLAVE;


        public String getText() {
            String string = null;
            switch (this) {
                case MASTER: {
                    string = BARControl.tr("Master", new Object[0]);
                    break;
                }
                case SLAVE: {
                    string = BARControl.tr("Slave", new Object[0]);
                }
            }
            return string;
        }
    }
}

