/*
 * Decompiled with CFR 0.152.
 */
import java.util.Comparator;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

class JobDataComparator
implements Comparator<JobData> {
    private SortModes sortMode;

    JobDataComparator(Table table, TableColumn tableColumn) {
        this.sortMode = table.getColumn(0) == tableColumn ? SortModes.NAME : (table.getColumn(1) == tableColumn ? SortModes.STATE : (table.getColumn(2) == tableColumn ? SortModes.SLAVE : (table.getColumn(3) == tableColumn ? SortModes.TYPE : (table.getColumn(4) == tableColumn ? SortModes.PARTSIZE : (table.getColumn(5) == tableColumn ? SortModes.COMPRESS : (table.getColumn(6) == tableColumn ? SortModes.CRYPT : (table.getColumn(7) == tableColumn ? SortModes.LAST_EXECUTED_DATETIME : (table.getColumn(8) == tableColumn ? SortModes.ESTIMATED_TIME : SortModes.NAME))))))));
    }

    JobDataComparator(Table table) {
        TableColumn tableColumn = table.getSortColumn();
        this.sortMode = table.getColumn(0) == tableColumn ? SortModes.NAME : (table.getColumn(1) == tableColumn ? SortModes.STATE : (table.getColumn(2) == tableColumn ? SortModes.SLAVE : (table.getColumn(3) == tableColumn ? SortModes.TYPE : (table.getColumn(4) == tableColumn ? SortModes.PARTSIZE : (table.getColumn(5) == tableColumn ? SortModes.COMPRESS : (table.getColumn(6) == tableColumn ? SortModes.CRYPT : (table.getColumn(7) == tableColumn ? SortModes.LAST_EXECUTED_DATETIME : (table.getColumn(8) == tableColumn ? SortModes.ESTIMATED_TIME : SortModes.NAME))))))));
    }

    @Override
    public int compare(JobData jobData, JobData jobData2) {
        switch (this.sortMode) {
            case NAME: {
                return jobData.name.compareTo(jobData2.name);
            }
            case STATE: {
                return jobData.state.compareTo(jobData2.state);
            }
            case SLAVE: {
                return jobData.slaveHostName.compareTo(jobData2.slaveHostName);
            }
            case TYPE: {
                return jobData.archiveType.compareTo(jobData2.archiveType);
            }
            case PARTSIZE: {
                if (jobData.archivePartSize < jobData2.archivePartSize) {
                    return -1;
                }
                if (jobData.archivePartSize > jobData2.archivePartSize) {
                    return 1;
                }
                return 0;
            }
            case COMPRESS: {
                int n = jobData.deltaCompressAlgorithm.compareTo(jobData2.deltaCompressAlgorithm);
                if (n == 0) {
                    n = jobData.byteCompressAlgorithm.compareTo(jobData2.byteCompressAlgorithm);
                }
                return n;
            }
            case CRYPT: {
                String string = jobData.cryptAlgorithm + (jobData.cryptType.equals("ASYMMETRIC") ? "*" : "");
                String string2 = jobData2.cryptAlgorithm + (jobData2.cryptType.equals("ASYMMETRIC") ? "*" : "");
                return string.compareTo(string2);
            }
            case LAST_EXECUTED_DATETIME: {
                if (jobData.lastExecutedDateTime < jobData2.lastExecutedDateTime) {
                    return -1;
                }
                if (jobData.lastExecutedDateTime > jobData2.lastExecutedDateTime) {
                    return 1;
                }
                return 0;
            }
            case ESTIMATED_TIME: {
                if (jobData.estimatedRestTime < jobData2.estimatedRestTime) {
                    return -1;
                }
                if (jobData.estimatedRestTime > jobData2.estimatedRestTime) {
                    return 1;
                }
                return 0;
            }
        }
        return 0;
    }

    static enum SortModes {
        NAME,
        STATE,
        SLAVE,
        TYPE,
        PARTSIZE,
        COMPRESS,
        CRYPT,
        LAST_EXECUTED_DATETIME,
        ESTIMATED_TIME;

    }
}

