/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

class Separator
extends Canvas {
    private Point textSize;
    private String text;
    private Color colorBlack = this.getDisplay().getSystemColor(2);
    private Color colorNormalShadow = this.getDisplay().getSystemColor(18);
    private Color colorHighlightShadow = this.getDisplay().getSystemColor(20);

    Separator(Composite composite, String string, int n) {
        super(composite, n);
        this.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent disposeEvent) {
                Separator.this.widgetDisposed(disposeEvent);
            }
        });
        this.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent paintEvent) {
                Separator.this.paint(paintEvent);
            }
        });
        this.setText(string);
    }

    Separator(Composite composite, String string) {
        this(composite, string, 0);
    }

    Separator(Composite composite) {
        this(composite, "");
    }

    @Override
    public Point computeSize(int n, int n2, boolean bl) {
        int n3;
        int n4;
        if (this.text != null) {
            n4 = 2 + this.textSize.x + 2;
            n3 = 2 + this.textSize.y + 2;
        } else {
            n4 = 4;
            n3 = 4;
        }
        if (n != -1) {
            n4 = n;
        }
        if (n2 != -1) {
            n3 = n2;
        }
        return new Point(n4, n3);
    }

    public void setText(String string) {
        if (!this.isDisposed()) {
            this.text = string;
            if (string != null) {
                GC gC = new GC(this);
                this.textSize = gC.stringExtent(string);
                gC.dispose();
            } else {
                this.textSize = null;
            }
            this.redraw();
        }
    }

    private void widgetDisposed(DisposeEvent disposeEvent) {
    }

    private void paint(PaintEvent paintEvent) {
        GC gC = paintEvent.gc;
        Rectangle rectangle = this.getBounds();
        int n = 0;
        int n2 = 0;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        if (this.text != null) {
            gC.setForeground(this.colorNormalShadow);
            gC.drawLine(n + 0, n2 + n4 / 2, n + (n3 - this.textSize.x) / 2 - 4, n2 + n4 / 2);
            gC.drawLine(n + (n3 + this.textSize.x) / 2 + 4, n2 + n4 / 2, n + n3, n2 + n4 / 2);
            gC.setForeground(this.colorHighlightShadow);
            gC.drawLine(n + 1, n2 + n4 / 2 + 1, n + (n3 - this.textSize.x) / 2 - 5, n2 + n4 / 2 + 1);
            gC.drawLine(n + (n3 + this.textSize.x) / 2 + 5, n2 + n4 / 2 + 1, n + n3 - 1, n2 + n4 / 2 + 1);
            gC.setForeground(this.colorBlack);
            gC.drawString(this.text, (n3 - this.textSize.x) / 2, (n4 - this.textSize.y) / 2, true);
        } else {
            gC.setForeground(this.colorNormalShadow);
            gC.drawLine(n + 0, n2 + n4 / 2, n + n3, n2 + n4 / 2);
            gC.setForeground(this.colorHighlightShadow);
            gC.drawLine(n + 1, n2 + n4 / 2 + 1, n + n3 - 1, n2 + n4 / 2 + 1);
        }
    }
}

