/*
 * Decompiled with CFR 0.152.
 */
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class StringParser {
    public static String QUOTE_CHARS = "'\"";
    private static String[] trueStrings = new String[]{"1", "true", "yes", "on"};
    private static String[] falseStrings = new String[]{"0", "false", "no", "off"};

    private static int getNextFormatToken(String string, int n, FormatToken formatToken) {
        formatToken.token = new StringBuilder();
        formatToken.length = 0;
        formatToken.alternateFlag = false;
        formatToken.zeroPaddingFlag = false;
        formatToken.leftAdjustedFlag = false;
        formatToken.blankFlag = false;
        formatToken.greedyFlag = false;
        formatToken.width = 0;
        formatToken.precision = 0;
        formatToken.lengthType = LengthTypes.INTEGER;
        formatToken.quoteChar = '\u0000';
        formatToken.enumClassName = null;
        formatToken.conversionChar = '\u0000';
        assert (string.charAt(n) == '%');
        formatToken.token.append('%');
        if (++n >= string.length()) {
            return -1;
        }
        while (n < string.length() && (string.charAt(n) == '#' || string.charAt(n) == '0' || string.charAt(n) == '-' || string.charAt(n) == ' ' || string.charAt(n) == '+' || string.charAt(n) == '*')) {
            formatToken.token.append(string.charAt(n));
            switch (string.charAt(n)) {
                case '#': {
                    formatToken.alternateFlag = true;
                    break;
                }
                case '0': {
                    formatToken.zeroPaddingFlag = true;
                    break;
                }
                case '-': {
                    formatToken.leftAdjustedFlag = true;
                    break;
                }
                case ' ': {
                    formatToken.blankFlag = true;
                    break;
                }
                case '+': {
                    formatToken.blankFlag = true;
                    break;
                }
                case '*': {
                    formatToken.greedyFlag = true;
                    break;
                }
                default: {
                    return -1;
                }
            }
            ++n;
        }
        if (n >= string.length()) {
            return -1;
        }
        while (n < string.length() && Character.isDigit(string.charAt(n))) {
            formatToken.token.append(string.charAt(n));
            formatToken.width = formatToken.width * 10 + (string.charAt(n) - 48);
            ++n;
        }
        if (n >= string.length()) {
            return -1;
        }
        if (string.charAt(n) == '.') {
            formatToken.token.append(string.charAt(n));
            ++n;
            while (n < string.length() && Character.isDigit(string.charAt(n))) {
                formatToken.token.append(string.charAt(n));
                formatToken.precision = formatToken.precision * 10 + (string.charAt(n) - 48);
                ++n;
            }
        }
        if (n + 1 < string.length() && string.charAt(n) != '{' && (string.charAt(n + 1) == 's' || string.charAt(n + 1) == 'S')) {
            formatToken.quoteChar = string.charAt(n);
            ++n;
        }
        if (n + 1 < string.length() && string.charAt(n) == 'h' && string.charAt(n + 1) == 'h') {
            formatToken.token.append(string.charAt(n + 0));
            formatToken.token.append(string.charAt(n + 1));
            formatToken.lengthType = LengthTypes.INTEGER;
            n += 2;
        } else if (n < string.length() && string.charAt(n) == 'h') {
            formatToken.token.append(string.charAt(n));
            formatToken.lengthType = LengthTypes.INTEGER;
            ++n;
        } else if (n + 1 < string.length() && string.charAt(n) == 'l' && string.charAt(n + 1) == 'l') {
            formatToken.token.append(string.charAt(n + 0));
            formatToken.token.append(string.charAt(n + 1));
            formatToken.lengthType = LengthTypes.LONG;
            n += 2;
        } else if (n < string.length() && string.charAt(n) == 'l') {
            formatToken.token.append(string.charAt(n));
            formatToken.lengthType = LengthTypes.LONG;
            ++n;
        } else if (n < string.length() && string.charAt(n) == 'j') {
            formatToken.token.append(string.charAt(n));
            formatToken.lengthType = LengthTypes.INTEGER;
            ++n;
        } else if (n < string.length() && string.charAt(n) == 'z') {
            formatToken.token.append(string.charAt(n));
            formatToken.lengthType = LengthTypes.INTEGER;
            ++n;
        } else if (n < string.length() && string.charAt(n) == 't') {
            formatToken.token.append(string.charAt(n));
            formatToken.lengthType = LengthTypes.INTEGER;
            ++n;
        }
        if (n < string.length() && string.charAt(n) == '{') {
            formatToken.token.append(string.charAt(n));
            ++n;
            StringBuilder stringBuilder = new StringBuilder();
            while (n < string.length() && string.charAt(n) != '}') {
                char c = string.charAt(n);
                formatToken.token.append(c);
                stringBuilder.append(c != '.' ? c : (char)'$');
                ++n;
            }
            ++n;
            formatToken.enumClassName = stringBuilder.toString();
        }
        if (n >= string.length()) {
            return -1;
        }
        switch (string.charAt(n)) {
            case 'S': {
                formatToken.token.append('s');
                formatToken.conversionChar = (char)83;
                break;
            }
            default: {
                formatToken.token.append(string.charAt(n));
                formatToken.conversionChar = string.charAt(n);
            }
        }
        return ++n;
    }

    private static char getQuoteChar(String string, int n, FormatToken formatToken, String string2) {
        char c = '\u0000';
        if (!formatToken.blankFlag && !formatToken.greedyFlag && n < string.length()) {
            if (formatToken.quoteChar != '\u0000' && formatToken.quoteChar == string.charAt(n)) {
                c = formatToken.quoteChar;
            }
            if (c == '\u0000' && string2 != null && string2.indexOf(string.charAt(n)) >= 0) {
                c = string2.charAt(string2.indexOf(string.charAt(n)));
            }
        }
        return c;
    }

    public static int parse(String string, int n, String string2, Object[] objectArray, String string3) {
        FormatToken formatToken = new FormatToken();
        int n2 = 0;
        int n3 = 0;
        block40: while (n2 < string2.length()) {
            if (string2.charAt(n2) == '%') {
                if ((n2 = StringParser.getNextFormatToken(string2, n2, formatToken)) < 0) {
                    return -1;
                }
                while (n < string.length() && Character.isSpaceChar(string.charAt(n))) {
                    ++n;
                }
                switch (formatToken.conversionChar) {
                    case 'd': 
                    case 'i': 
                    case 'u': {
                        StringBuilder stringBuilder = new StringBuilder();
                        if (n < string.length() && (string.charAt(n) == '+' || string.charAt(n) == '-')) {
                            stringBuilder.append(string.charAt(n));
                            ++n;
                        }
                        while (n < string.length() && Character.isDigit(string.charAt(n))) {
                            stringBuilder.append(string.charAt(n));
                            ++n;
                        }
                        if (stringBuilder.length() <= 0) {
                            return -1;
                        }
                        try {
                            switch (formatToken.lengthType) {
                                case INTEGER: {
                                    objectArray[n3] = Integer.parseInt(stringBuilder.toString(), 10);
                                    break;
                                }
                                case LONG: {
                                    objectArray[n3] = Long.parseLong(stringBuilder.toString(), 10);
                                    break;
                                }
                                case DOUBLE: {
                                    try {
                                        objectArray[n3] = NumberFormat.getInstance(Locale.ENGLISH).parse(stringBuilder.toString()).doubleValue();
                                        break;
                                    }
                                    catch (ParseException parseException) {
                                        return -1;
                                    }
                                }
                            }
                            ++n3;
                            continue block40;
                        }
                        catch (NumberFormatException numberFormatException) {
                            return -1;
                        }
                    }
                    case 'c': {
                        char c;
                        if (n < string.length()) {
                            c = string.charAt(n);
                            ++n;
                        } else {
                            return -1;
                        }
                        objectArray[n3] = Character.valueOf(c);
                        ++n3;
                        continue block40;
                    }
                    case 'o': {
                        StringBuilder stringBuilder = new StringBuilder();
                        while (n < string.length() && string.charAt(n) >= '0' && string.charAt(n) <= '7') {
                            stringBuilder.append(string.charAt(n));
                            ++n;
                        }
                        if (stringBuilder.length() <= 0) {
                            return -1;
                        }
                        try {
                            switch (formatToken.lengthType) {
                                case INTEGER: {
                                    objectArray[n3] = Integer.parseInt(stringBuilder.toString(), 8);
                                    break;
                                }
                                case LONG: {
                                    objectArray[n3] = Long.parseLong(stringBuilder.toString(), 8);
                                    break;
                                }
                            }
                            ++n3;
                            continue block40;
                        }
                        catch (NumberFormatException numberFormatException) {
                            return -1;
                        }
                    }
                    case 'X': 
                    case 'x': {
                        StringBuilder stringBuilder = new StringBuilder();
                        if (n + 1 < string.length() && string.charAt(n + 0) == '0' && string.charAt(n + 0) == 'x') {
                            n += 2;
                        }
                        while (n < string.length() && Character.isDigit(string.charAt(n))) {
                            stringBuilder.append(string.charAt(n));
                            ++n;
                        }
                        if (stringBuilder.length() <= 0) {
                            return -1;
                        }
                        try {
                            switch (formatToken.lengthType) {
                                case INTEGER: {
                                    objectArray[n3] = Integer.parseInt(stringBuilder.toString(), 16);
                                    break;
                                }
                                case LONG: {
                                    objectArray[n3] = Long.parseLong(stringBuilder.toString(), 16);
                                    break;
                                }
                            }
                            ++n3;
                            continue block40;
                        }
                        catch (NumberFormatException numberFormatException) {
                            return -1;
                        }
                    }
                    case 'A': 
                    case 'E': 
                    case 'F': 
                    case 'G': 
                    case 'a': 
                    case 'e': 
                    case 'f': 
                    case 'g': {
                        StringBuilder stringBuilder = new StringBuilder();
                        if (n < string.length() && (string.charAt(n) == '+' || string.charAt(n) == '-')) {
                            stringBuilder.append(string.charAt(n));
                            ++n;
                        }
                        while (n < string.length() && Character.isDigit(string.charAt(n))) {
                            stringBuilder.append(string.charAt(n));
                            ++n;
                        }
                        if (n < string.length() && string.charAt(n) == '.') {
                            stringBuilder.append(string.charAt(n));
                            ++n;
                            while (n < string.length() && Character.isDigit(string.charAt(n))) {
                                stringBuilder.append(string.charAt(n));
                                ++n;
                            }
                        }
                        if (stringBuilder.length() <= 0) {
                            return -1;
                        }
                        try {
                            try {
                                objectArray[n3] = NumberFormat.getInstance(Locale.ENGLISH).parse(stringBuilder.toString()).doubleValue();
                            }
                            catch (ParseException parseException) {
                                return -1;
                            }
                            ++n3;
                            continue block40;
                        }
                        catch (NumberFormatException numberFormatException) {
                            return -1;
                        }
                    }
                    case 's': {
                        StringBuilder stringBuilder = new StringBuilder();
                        while (n < string.length() && (formatToken.blankFlag || n2 >= string2.length() && formatToken.greedyFlag || !Character.isSpaceChar(string.charAt(n))) && (n2 >= string2.length() || string.charAt(n) != string2.charAt(n2))) {
                            if (!formatToken.greedyFlag && n + 1 < string.length() && string.charAt(n) == '\\' && string3 != null && string3.indexOf(string.charAt(n + 1)) >= 0) {
                                if (formatToken.width == 0 || stringBuilder.length() < formatToken.width - 1) {
                                    stringBuilder.append(string.charAt(n + 1));
                                }
                                n += 2;
                                continue;
                            }
                            if (formatToken.width == 0 || stringBuilder.length() < formatToken.width - 1) {
                                stringBuilder.append(string.charAt(n));
                            }
                            ++n;
                        }
                        if (formatToken.enumClassName != null) {
                            try {
                                Class<?> clazz = Class.forName(formatToken.enumClassName);
                                if (!clazz.isEnum()) {
                                    return -1;
                                }
                                objectArray[n3] = Enum.valueOf(clazz, stringBuilder.toString());
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new Error("Enumeration class '" + formatToken.enumClassName + "' not found", classNotFoundException);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                return -1;
                            }
                        } else {
                            objectArray[n3] = stringBuilder.toString();
                        }
                        ++n3;
                        continue block40;
                    }
                    case 'n': 
                    case 'p': {
                        continue block40;
                    }
                    case 'S': {
                        StringBuilder stringBuilder = new StringBuilder();
                        while (n < string.length() && (formatToken.blankFlag || n2 >= string2.length() && formatToken.greedyFlag || !Character.isSpaceChar(string.charAt(n))) && (n2 >= string2.length() || string.charAt(n) != string2.charAt(n2))) {
                            if (n + 1 < string.length() && string.charAt(n) == '\\' && string3 != null && string3.indexOf(string.charAt(n + 1)) >= 0) {
                                if (formatToken.width == 0 || stringBuilder.length() < formatToken.width - 1) {
                                    stringBuilder.append(string.charAt(n + 1));
                                }
                                n += 2;
                                continue;
                            }
                            char c = StringParser.getQuoteChar(string, n, formatToken, string3);
                            if (c != '\u0000') {
                                do {
                                    ++n;
                                    while (n < string.length() && string.charAt(n) != c) {
                                        if (n + 1 < string.length() && string.charAt(n) == '\\' && string3 != null && string3.indexOf(string.charAt(n + 1)) >= 0) {
                                            if (formatToken.width == 0 || stringBuilder.length() < formatToken.width - 1) {
                                                stringBuilder.append(string.charAt(n + 1));
                                            }
                                            n += 2;
                                            continue;
                                        }
                                        if (formatToken.width == 0 || stringBuilder.length() < formatToken.width - 1) {
                                            stringBuilder.append(string.charAt(n));
                                        }
                                        ++n;
                                    }
                                    if (n >= string.length()) continue;
                                    ++n;
                                } while ((c = StringParser.getQuoteChar(string, n, formatToken, string3)) != '\u0000');
                                continue;
                            }
                            if (formatToken.width == 0 || stringBuilder.length() < formatToken.width - 1) {
                                stringBuilder.append(string.charAt(n));
                            }
                            ++n;
                        }
                        objectArray[n3] = stringBuilder.toString();
                        ++n3;
                        continue block40;
                    }
                    case 'y': {
                        int n4;
                        StringBuilder stringBuilder = new StringBuilder();
                        while (n < string.length() && !Character.isSpaceChar(string.charAt(n))) {
                            stringBuilder.append(string.charAt(n));
                            ++n;
                        }
                        boolean bl = false;
                        for (n4 = 0; !bl && n4 < trueStrings.length; ++n4) {
                            if (!trueStrings[n4].contentEquals(stringBuilder)) continue;
                            objectArray[n3] = true;
                            bl = true;
                        }
                        for (n4 = 0; !bl && n4 < falseStrings.length; ++n4) {
                            if (!falseStrings[n4].contentEquals(stringBuilder)) continue;
                            objectArray[n3] = false;
                            bl = true;
                        }
                        if (!bl) {
                            return -1;
                        }
                        ++n3;
                        continue block40;
                    }
                    case '%': {
                        if (n >= string.length() || string.charAt(n) != '%') {
                            return -1;
                        }
                        ++n;
                        continue block40;
                    }
                }
                return -1;
            }
            if (Character.isSpaceChar(string2.charAt(n2))) {
                if (n >= string.length() || !Character.isSpaceChar(string.charAt(n))) {
                    return -1;
                }
                ++n;
                ++n2;
                while (n < string.length() && Character.isSpaceChar(string.charAt(n))) {
                    ++n;
                }
                while (n2 < string2.length() && Character.isSpaceChar(string2.charAt(n2))) {
                    ++n2;
                }
                continue;
            }
            while (n < string.length() && Character.isSpaceChar(string.charAt(n))) {
                ++n;
            }
            if (n >= string.length() || string.charAt(n) != string2.charAt(n2)) {
                return -1;
            }
            ++n;
            ++n2;
        }
        while (n < string.length() && Character.isSpaceChar(string.charAt(n))) {
            ++n;
        }
        return n;
    }

    public static int parse(String string, int n, String string2, Object[] objectArray) {
        return StringParser.parse(string, n, string2, objectArray, (String)null);
    }

    public static boolean parse(String string, String string2, Object[] objectArray, String string3) {
        return StringParser.parse(string, 0, string2, objectArray, string3) >= string.length();
    }

    public static boolean parse(String string, String string2, Object[] objectArray) {
        return StringParser.parse(string, string2, objectArray, (String)null);
    }

    private static char getQuoteChar(String string, int n, String string2) {
        char c = '\u0000';
        if (n < string.length() && c == '\u0000' && string2 != null && string2.indexOf(string.charAt(n)) >= 0) {
            c = string2.charAt(string2.indexOf(string.charAt(n)));
        }
        return c;
    }

    public static int parse(String string, int n, TypeMap typeMap, ValueMap valueMap, ValueMap valueMap2, String string2) throws NumberFormatException {
        char[] cArray = new char[]{'\u0000', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u001b'};
        while (n < string.length()) {
            while (n < string.length() && Character.isSpaceChar(string.charAt(n))) {
                ++n;
            }
            if (n >= string.length()) continue;
            StringBuilder stringBuilder = new StringBuilder();
            if (!Character.isLetter(string.charAt(n)) && string.charAt(n) != '_') {
                return n;
            }
            do {
                stringBuilder.append(string.charAt(n));
            } while (++n < string.length() && (Character.isLetterOrDigit(string.charAt(n)) || string.charAt(n) == '_'));
            String string3 = stringBuilder.toString();
            if (n >= string.length() || string.charAt(n) != '=') {
                return n;
            }
            ++n;
            stringBuilder = new StringBuilder();
            while (n < string.length() && !Character.isSpaceChar(string.charAt(n))) {
                if (n + 1 < string.length() && string.charAt(n) == '\\' && string2 != null && string2.indexOf(string.charAt(n + 1)) >= 0) {
                    stringBuilder.append(string.charAt(n + 1));
                    n += 2;
                    continue;
                }
                char c = StringParser.getQuoteChar(string, n, string2);
                if (c != '\u0000') {
                    do {
                        ++n;
                        while (n < string.length() && string.charAt(n) != c) {
                            if (n + 1 < string.length() && string.charAt(n) == '\\') {
                                if (string2 != null && string2.indexOf(string.charAt(++n)) >= 0) {
                                    stringBuilder.append(string.charAt(n));
                                } else if ("0abtnvfre".indexOf(string.charAt(n)) >= 0) {
                                    stringBuilder.append(cArray["0abtnvfre".indexOf(string.charAt(n))]);
                                } else {
                                    stringBuilder.append(string.charAt(n));
                                }
                            } else {
                                stringBuilder.append(string.charAt(n));
                            }
                            ++n;
                        }
                        if (n >= string.length()) continue;
                        ++n;
                    } while ((c = StringParser.getQuoteChar(string, n, string2)) != '\u0000');
                    continue;
                }
                stringBuilder.append(string.charAt(n));
                ++n;
            }
            String string4 = stringBuilder.toString();
            if (typeMap != null) {
                Class clazz = (Class)typeMap.get(string3);
                if (clazz == Integer.TYPE || clazz == Integer.class) {
                    valueMap.put(string3, Integer.parseInt(string4));
                    continue;
                }
                if (clazz == Long.TYPE || clazz == Long.class) {
                    valueMap.put(string3, Long.parseLong(string4));
                    continue;
                }
                if (clazz == Float.TYPE || clazz == Float.class) {
                    valueMap.put(string3, Float.valueOf(Float.parseFloat(string4)));
                    continue;
                }
                if (clazz == Double.TYPE || clazz == Double.class) {
                    try {
                        valueMap.put(string3, NumberFormat.getInstance(Locale.ENGLISH).parse(string4).doubleValue());
                        continue;
                    }
                    catch (ParseException parseException) {
                        throw new IllegalArgumentException(string4, parseException);
                    }
                }
                if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                    valueMap.put(string3, string4.equalsIgnoreCase("yes") || string4.equalsIgnoreCase("on") || string4.equalsIgnoreCase("true") || string4.equals("1"));
                    continue;
                }
                if (clazz == Character.class) {
                    valueMap.put(string3, Character.valueOf(string4.charAt(0)));
                    continue;
                }
                if (clazz == String.class) {
                    valueMap.put(string3, string4);
                    continue;
                }
                if (clazz != null && clazz.isEnum()) {
                    int n2;
                    Enum[] enumArray = (Enum[])clazz.getEnumConstants();
                    try {
                        n2 = Integer.parseInt(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n2 = -1;
                    }
                    boolean bl = false;
                    for (Enum enum_ : enumArray) {
                        if (!string4.equalsIgnoreCase(enum_.name()) && enum_.ordinal() != n2 && !string4.equalsIgnoreCase(enum_.toString())) continue;
                        valueMap.put(string3, enum_);
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    throw new IllegalArgumentException("unknown enum value '" + string4 + "' for " + string3);
                }
                if (valueMap2 != null) {
                    valueMap2.put(string3, string4);
                    continue;
                }
                valueMap.put(string3, string4);
                continue;
            }
            valueMap.put(string3, string4);
        }
        return n;
    }

    public static boolean parse(String string, TypeMap typeMap, ValueMap valueMap, ValueMap valueMap2, String string2) {
        return StringParser.parse(string, 0, typeMap, valueMap, valueMap2, string2) >= string.length();
    }

    public static boolean parse(String string, TypeMap typeMap, ValueMap valueMap, ValueMap valueMap2) {
        return StringParser.parse(string, typeMap, valueMap, valueMap2, QUOTE_CHARS);
    }

    public static boolean parse(String string, ValueMap valueMap, ValueMap valueMap2) {
        return StringParser.parse(string, (TypeMap)null, valueMap, valueMap2);
    }

    public static boolean parse(String string, TypeMap typeMap, ValueMap valueMap) {
        return StringParser.parse(string, typeMap, valueMap, (ValueMap)null);
    }

    public static boolean parse(String string, ValueMap valueMap) {
        return StringParser.parse(string, (TypeMap)null, valueMap);
    }

    public static String format(String string, char c, Object ... objectArray) {
        char[] cArray = new char[]{'0', 'a', 'b', 't', 'n', 'v', 'f', 'r', 'e'};
        FormatToken formatToken = new FormatToken();
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = 0;
        block5: while (n < string.length()) {
            while (n < string.length() && string.charAt(n) != '%') {
                if (n + 1 < string.length() && string.charAt(n) == '\\') {
                    stringBuilder.append(string.charAt(++n));
                } else {
                    stringBuilder.append(string.charAt(n));
                }
                ++n;
            }
            if (n >= string.length()) continue;
            if (string.charAt(n) == '%') {
                if ((n = StringParser.getNextFormatToken(string, n, formatToken)) < 0) {
                    return null;
                }
                switch (formatToken.conversionChar) {
                    case 'y': {
                        stringBuilder.append((Boolean)objectArray[n2] != false ? "yes" : "no");
                        ++n2;
                        continue block5;
                    }
                    case 'S': {
                        stringBuilder.append(c);
                        String string2 = String.format("%s", objectArray[n2]);
                        for (int i = 0; i < string2.length(); ++i) {
                            char c2 = string2.charAt(i);
                            if (c2 == c) {
                                stringBuilder.append('\\');
                                stringBuilder.append(c2);
                                continue;
                            }
                            if (c2 == '\\') {
                                stringBuilder.append("\\\\");
                                continue;
                            }
                            if ("\u0000\u0007\b\t\n\u000b\f\r\u001b".indexOf(c2) >= 0) {
                                stringBuilder.append('\\');
                                stringBuilder.append(cArray["\u0000\u0007\b\t\n\u000b\f\r\u001b".indexOf(c2)]);
                                continue;
                            }
                            stringBuilder.append(c2);
                        }
                        stringBuilder.append(c);
                        ++n2;
                        continue block5;
                    }
                    case '%': {
                        stringBuilder.append('%');
                        continue block5;
                    }
                }
                stringBuilder.append(String.format("%" + formatToken.conversionChar, objectArray[n2]));
                ++n2;
                continue;
            }
            stringBuilder.append(string.charAt(n));
            ++n;
        }
        while (n < string.length()) {
            stringBuilder.append(string.charAt(n));
            ++n;
        }
        return stringBuilder.toString();
    }

    public static String format(String string, Object ... objectArray) {
        return StringParser.format(string, '\"', objectArray);
    }

    public static int parseInt(String string, int n) throws NumberFormatException {
        if (string.startsWith("0x") || string.startsWith("0X")) {
            return Integer.parseInt(string.substring(2), 16);
        }
        return Integer.parseInt(string, n);
    }

    public static int parseInt(String string) throws NumberFormatException {
        return StringParser.parseInt(string, 10);
    }

    public static long parseLong(String string, int n) throws NumberFormatException {
        if (string.startsWith("0x") || string.startsWith("0X")) {
            return Long.parseLong(string.substring(2), 16);
        }
        return Long.parseLong(string, n);
    }

    public static long parseLong(String string) throws NumberFormatException {
        return StringParser.parseLong(string, 10);
    }

    private static class FormatToken {
        StringBuilder token;
        int length;
        boolean alternateFlag;
        boolean zeroPaddingFlag;
        boolean leftAdjustedFlag;
        boolean blankFlag;
        boolean greedyFlag;
        int width;
        int precision;
        LengthTypes lengthType;
        char quoteChar;
        String enumClassName;
        char conversionChar;

        private FormatToken() {
        }
    }

    private static enum LengthTypes {
        INTEGER,
        LONG,
        DOUBLE;

    }
}

