/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TabRestore {
    final int MAX_SHOWN_ENTRIES = 32000;
    final IndexStateSet INDEX_STATE_SET_ALL = new IndexStateSet(IndexStates.OK, IndexStates.CREATE, IndexStates.UPDATE_REQUESTED, IndexStates.UPDATE, IndexStates.ERROR);
    private final Color COLOR_MODIFIED;
    private final Color COLOR_INFO_FOREGROUND;
    private final Color COLOR_WARNING_FOREGROUND;
    private final Color COLOR_INFO_BACKGROUND;
    private final Color COLOR_NO_JOB_INFO;
    private final Image IMAGE_DIRECTORY;
    private final Image IMAGE_CLEAR;
    private final Image IMAGE_MARK_ALL;
    private final Image IMAGE_UNMARK_ALL;
    private final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd EEE HH:mm:ss");
    private final SimpleDateFormat SIMPLE_DATE_FORMAT1 = new SimpleDateFormat("yyyy-MM-dd");
    private final SimpleDateFormat SIMPLE_DATE_FORMAT2 = new SimpleDateFormat("EEE");
    private final SimpleDateFormat SIMPLE_DATE_FORMAT3 = new SimpleDateFormat("HH:mm:ss");
    final Comparator<IndexData> indexIdComparator = new Comparator<IndexData>(){

        @Override
        public int compare(IndexData indexData, IndexData indexData2) {
            return indexData.id == indexData2.id ? 0 : 1;
        }
    };
    private final int STORAGE_TREE_MENU_START_INDEX = 0;
    private final int STORAGE_LIST_MENU_START_INDEX = 6;
    private Shell shell;
    private Display display;
    private Clipboard clipboard;
    private TabStatus tabStatus;
    public Composite widgetTab;
    private TabFolder widgetTabFolder;
    private TabFolder widgetStorageTabFolderTitle;
    private TabFolder widgetStorageTabFolder;
    private Tree widgetStorageTree;
    private Shell widgetStorageTreeToolTip = null;
    private Table widgetStorageTable;
    private Shell widgetStorageTableToolTip = null;
    private Text widgetStorageFilter;
    private Combo widgetStorageStateFilter;
    private Menu widgetStorageAssignToMenu;
    private final IndexIdSet checkedIndexIdSet = new IndexIdSet();
    private WidgetEvent enableMarkIndexEvent = new WidgetEvent();
    private WidgetEvent checkedIndexEvent = new WidgetEvent();
    private Label widgetEntryTableTitle;
    private Table widgetEntryTable;
    private Shell widgetEntryTableToolTip = null;
    private Text widgetEntryFilter;
    private Combo widgetEntryTypeFilter;
    private Button widgetEntryNewestOnly;
    private final IndexIdSet checkedEntryIdSet = new IndexIdSet();
    private WidgetEvent enableMarkEntriesEvent = new WidgetEvent();
    private WidgetEvent checkedEntryEvent = new WidgetEvent();
    private UpdateStorageTreeTableThread updateStorageTreeTableThread = new UpdateStorageTreeTableThread();
    private TabJobs tabJobs;
    private HashSet<IndexData> selectedIndexDataHashSet = null;
    private Timer updateAssignToTimer = new Timer(true);
    private TimerTask updateAssignToTimerTask = null;
    private Object assignToLock = new Object();
    private List<UUIDIndexData> assignToUUIDIndexDataList = null;
    private Map<String, List<EntityIndexData>> assignToEntityIndexDataMap = null;
    private UpdateEntryTableThread updateEntryTableThread = new UpdateEntryTableThread();

    private int findStorageTreeIndex(IndexData indexData, IndexDataComparator indexDataComparator) {
        int n;
        TreeItem[] treeItemArray = this.widgetStorageTree.getItems();
        for (n = 0; n < treeItemArray.length && indexDataComparator.compare(indexData, (IndexData)treeItemArray[n].getData()) > 0; ++n) {
        }
        return n;
    }

    private int findStorageTreeIndex(IndexData indexData) {
        return this.findStorageTreeIndex(indexData, new IndexDataComparator(this.widgetStorageTree));
    }

    private int findStorageTreeIndex(TreeItem treeItem, IndexData indexData, IndexDataComparator indexDataComparator) {
        TreeItem[] treeItemArray = treeItem.getItems();
        int n = 0;
        if (treeItemArray.length > 0) {
            int n2 = 0;
            int n3 = 0;
            int n4 = treeItemArray.length - 1;
            int n5 = -1;
            while (n3 < n4) {
                n2 = (n4 + n3) / 2;
                n5 = indexDataComparator.compare(indexData, (IndexData)treeItemArray[n2].getData());
                if (n5 < 0) {
                    n4 = n2 - 1;
                    continue;
                }
                if (n5 > 0) {
                    n3 = n2 + 1;
                    continue;
                }
                n3 = n4 = n2;
            }
            n = indexDataComparator.compare(indexData, (IndexData)treeItemArray[n3].getData()) < 0 ? n3 : n3 + 1;
        }
        return n;
    }

    private int findStorageTreeIndex(TreeItem treeItem, IndexData indexData) {
        return this.findStorageTreeIndex(treeItem, indexData, new IndexDataComparator(this.widgetStorageTree));
    }

    private int findStorageMenuIndex(Menu menu, UUIDIndexData uUIDIndexData) {
        int n;
        MenuItem[] menuItemArray = menu.getItems();
        IndexDataComparator<UUIDIndexData> indexDataComparator = new IndexDataComparator<UUIDIndexData>(this.widgetStorageTree);
        for (n = 0; n < menuItemArray.length && indexDataComparator.compare(uUIDIndexData, (UUIDIndexData)menuItemArray[n].getData()) > 0; ++n) {
        }
        return n;
    }

    private void showUUIDIndexToolTip(UUIDIndexData uUIDIndexData, int n, int n2) {
        if (this.widgetStorageTreeToolTip != null) {
            this.widgetStorageTreeToolTip.dispose();
        }
        if (!this.shell.isDisposed() && uUIDIndexData != null) {
            this.widgetStorageTreeToolTip = new Shell(this.shell, 540676);
            this.widgetStorageTreeToolTip.setBackground(this.COLOR_INFO_BACKGROUND);
            this.widgetStorageTreeToolTip.setLayout(new TableLayout(0.0, new double[]{0.0, 1.0}, 2));
            Widgets.layout(this.widgetStorageTreeToolTip, 0, 0, 15);
            int n3 = 0;
            Label label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, BARControl.tr("Name", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, uUIDIndexData.name);
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 1, 12);
            ++n3;
            if (Settings.debugLevel > 0) {
                assert (uUIDIndexData.id == 0L || (uUIDIndexData.id & 0xFL) == 1L) : uUIDIndexData;
                label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, BARControl.tr("UUID id", new Object[0]) + ":");
                label.setForeground(this.COLOR_INFO_FOREGROUND);
                label.setBackground(this.COLOR_INFO_BACKGROUND);
                Widgets.layout(label, n3, 0, 4);
                label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, Long.toString(uUIDIndexData.id >> 4));
                label.setForeground(this.COLOR_INFO_FOREGROUND);
                label.setBackground(this.COLOR_INFO_BACKGROUND);
                Widgets.layout(label, n3, 1, 12);
                label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, BARControl.tr("Job UUID", new Object[0]) + ":");
                label.setForeground(this.COLOR_INFO_FOREGROUND);
                label.setBackground(this.COLOR_INFO_BACKGROUND);
                Widgets.layout(label, ++n3, 0, 4);
                label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, uUIDIndexData.jobUUID);
                label.setForeground(this.COLOR_INFO_FOREGROUND);
                label.setBackground(this.COLOR_INFO_BACKGROUND);
                Widgets.layout(label, n3, 1, 12);
                ++n3;
            }
            label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, BARControl.tr("Last executed", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, uUIDIndexData.lastExecutedDateTime > 0L ? this.SIMPLE_DATE_FORMAT.format(new Date(uUIDIndexData.lastExecutedDateTime * 1000L)) : "-");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 1, 12);
            label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, BARControl.tr("Last error", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, ++n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, uUIDIndexData.lastErrorData);
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 1, 12);
            label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, BARControl.tr("Total size", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, ++n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, String.format(BARControl.tr("{0} ({1} {1,choice,0#bytes|1#byte|1<bytes})", Units.formatByteSize(uUIDIndexData.getTotalSize()), uUIDIndexData.getTotalSize()), new Object[0]));
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 1, 12);
            label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, BARControl.tr("Total entries", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, ++n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, BARControl.tr("{0}", uUIDIndexData.getTotalEntryCount()));
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 1, 12);
            label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, BARControl.tr("Total entries size", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, ++n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, String.format(BARControl.tr("{0} ({1} {1,choice,0#bytes|1#byte|1<bytes})", Units.formatByteSize(uUIDIndexData.getTotalEntrySize()), uUIDIndexData.getTotalEntrySize()), new Object[0]));
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 1, 12);
            ++n3;
            Widgets.showToolTip(this.widgetStorageTreeToolTip, n, n2);
        }
    }

    private void showEntityIndexToolTip(EntityIndexData entityIndexData, int n, int n2) {
        if (this.widgetStorageTreeToolTip != null) {
            this.widgetStorageTreeToolTip.dispose();
        }
        if (!this.shell.isDisposed() && entityIndexData != null) {
            Label label;
            this.widgetStorageTreeToolTip = new Shell(this.shell, 540676);
            this.widgetStorageTreeToolTip.setBackground(this.COLOR_INFO_BACKGROUND);
            this.widgetStorageTreeToolTip.setLayout(new TableLayout(0.0, new double[]{0.0, 1.0}, 2));
            Widgets.layout(this.widgetStorageTreeToolTip, 0, 0, 15);
            int n3 = 0;
            if (Settings.debugLevel > 0) {
                assert ((entityIndexData.id & 0xFL) == 2L) : entityIndexData;
                label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, BARControl.tr("Entity id", new Object[0]) + ":");
                label.setForeground(this.COLOR_INFO_FOREGROUND);
                label.setBackground(this.COLOR_INFO_BACKGROUND);
                Widgets.layout(label, n3, 0, 4);
                label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, Long.toString(entityIndexData.id >> 4));
                label.setForeground(this.COLOR_INFO_FOREGROUND);
                label.setBackground(this.COLOR_INFO_BACKGROUND);
                Widgets.layout(label, n3, 1, 12);
                label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, BARControl.tr("Job UUID", new Object[0]) + ":");
                label.setForeground(this.COLOR_INFO_FOREGROUND);
                label.setBackground(this.COLOR_INFO_BACKGROUND);
                Widgets.layout(label, ++n3, 0, 4);
                label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, entityIndexData.jobUUID);
                label.setForeground(this.COLOR_INFO_FOREGROUND);
                label.setBackground(this.COLOR_INFO_BACKGROUND);
                Widgets.layout(label, n3, 1, 12);
                label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, BARControl.tr("Schedule UUID", new Object[0]) + ":");
                label.setForeground(this.COLOR_INFO_FOREGROUND);
                label.setBackground(this.COLOR_INFO_BACKGROUND);
                Widgets.layout(label, ++n3, 0, 4);
                label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, entityIndexData.scheduleUUID);
                label.setForeground(this.COLOR_INFO_FOREGROUND);
                label.setBackground(this.COLOR_INFO_BACKGROUND);
                Widgets.layout(label, n3, 1, 12);
                ++n3;
            }
            label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, BARControl.tr("Created", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, entityIndexData.createdDateTime > 0L ? this.SIMPLE_DATE_FORMAT.format(new Date(entityIndexData.createdDateTime * 1000L)) : "-");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 1, 12);
            label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, BARControl.tr("Last error", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, ++n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, entityIndexData.lastErrorData);
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 1, 12);
            label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, BARControl.tr("Total size", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, ++n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, String.format(BARControl.tr("{0} ({1} {1,choice,0#bytes|1#byte|1<bytes})", Units.formatByteSize(entityIndexData.getTotalSize()), entityIndexData.getTotalSize()), new Object[0]));
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 1, 12);
            label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, BARControl.tr("Total entries", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, ++n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, BARControl.tr("{0}", entityIndexData.getTotalEntryCount()));
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 1, 12);
            label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, BARControl.tr("Total entries size", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, ++n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, String.format(BARControl.tr("{0} ({1} {1,choice,0#bytes|1#byte|1<bytes})", Units.formatByteSize(entityIndexData.getTotalEntrySize()), entityIndexData.getTotalEntrySize()), new Object[0]));
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 1, 12);
            label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, BARControl.tr("Expire at", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, ++n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, entityIndexData.expireDateTime > 0L ? this.SIMPLE_DATE_FORMAT.format(new Date(entityIndexData.expireDateTime * 1000L)) : "-");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 1, 12);
            ++n3;
            if (entityIndexData.jobUUID.isEmpty() || entityIndexData.scheduleUUID.isEmpty()) {
                Separator separator = Widgets.newSeparator(this.widgetStorageTreeToolTip);
                separator.setForeground(this.COLOR_WARNING_FOREGROUND);
                separator.setBackground(this.COLOR_INFO_BACKGROUND);
                Widgets.layout(separator, n3, 0, 12, 0, 2);
                label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, BARControl.tr("Warnings", new Object[0]) + ":");
                label.setForeground(this.COLOR_WARNING_FOREGROUND);
                label.setBackground(this.COLOR_INFO_BACKGROUND);
                Widgets.layout(label, ++n3, 0, 4);
                if (entityIndexData.jobUUID.isEmpty()) {
                    label = Widgets.newLabel((Composite)this.widgetStorageTreeToolTip, BARControl.tr("no job info", new Object[0]));
                    label.setForeground(this.COLOR_WARNING_FOREGROUND);
                    label.setBackground(this.COLOR_INFO_BACKGROUND);
                    Widgets.layout(label, n3, 1, 12);
                    ++n3;
                }
            }
            Widgets.showToolTip(this.widgetStorageTreeToolTip, n, n2);
        }
    }

    private void showStorageIndexToolTip(final StorageIndexData storageIndexData, int n, int n2) {
        Image image = Widgets.loadImage(this.shell.getDisplay(), "clipboard.png");
        if (this.widgetStorageTableToolTip != null) {
            this.widgetStorageTableToolTip.dispose();
        }
        if (!this.shell.isDisposed() && storageIndexData != null) {
            double[] dArray;
            this.widgetStorageTableToolTip = new Shell(this.shell, 540676);
            this.widgetStorageTableToolTip.setBackground(this.COLOR_INFO_BACKGROUND);
            if (Settings.debugLevel > 0) {
                double[] dArray2 = new double[10];
                dArray2[0] = 0.0;
                dArray2[1] = 0.0;
                dArray2[2] = 0.0;
                dArray2[3] = 0.0;
                dArray2[4] = 1.0;
                dArray2[5] = 0.0;
                dArray2[6] = 0.0;
                dArray2[7] = 0.0;
                dArray2[8] = 0.0;
                dArray = dArray2;
                dArray2[9] = 0.0;
            } else {
                double[] dArray3 = new double[9];
                dArray3[0] = 0.0;
                dArray3[1] = 0.0;
                dArray3[2] = 0.0;
                dArray3[3] = 1.0;
                dArray3[4] = 0.0;
                dArray3[5] = 0.0;
                dArray3[6] = 0.0;
                dArray3[7] = 0.0;
                dArray = dArray3;
                dArray3[8] = 0.0;
            }
            this.widgetStorageTableToolTip.setLayout(new TableLayout(dArray, new double[]{0.0, 1.0}, 2));
            Widgets.layout(this.widgetStorageTableToolTip, 0, 0, 15);
            int n3 = 0;
            Label label = Widgets.newLabel((Composite)this.widgetStorageTableToolTip, BARControl.tr("Job", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetStorageTableToolTip, storageIndexData.jobName);
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 1, 12);
            label = Widgets.newLabel((Composite)this.widgetStorageTableToolTip, BARControl.tr("Entity", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, ++n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetStorageTableToolTip, (Object)((Object)storageIndexData.archiveType) + (storageIndexData.createdDateTime > 0L ? ", " + this.SIMPLE_DATE_FORMAT.format(new Date(storageIndexData.createdDateTime * 1000L)) : ""));
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 1, 12);
            ++n3;
            if (Settings.debugLevel > 0) {
                assert ((storageIndexData.entityId & 0xFL) == 2L) : storageIndexData;
                label = Widgets.newLabel((Composite)this.widgetStorageTableToolTip, BARControl.tr("Entity id", new Object[0]) + ":");
                label.setForeground(this.COLOR_INFO_FOREGROUND);
                label.setBackground(this.COLOR_INFO_BACKGROUND);
                Widgets.layout(label, n3, 0, 4);
                label = Widgets.newLabel((Composite)this.widgetStorageTableToolTip, Long.toString(storageIndexData.entityId >> 4));
                label.setForeground(this.COLOR_INFO_FOREGROUND);
                label.setBackground(this.COLOR_INFO_BACKGROUND);
                Widgets.layout(label, n3, 1, 12);
                ++n3;
            }
            label = Widgets.newLabel((Composite)this.widgetStorageTableToolTip, BARControl.tr("Hostname", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetStorageTableToolTip, storageIndexData.hostName);
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 1, 12);
            label = Widgets.newLabel((Composite)this.widgetStorageTableToolTip, BARControl.tr("Storage", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, ++n3, 0, 5);
            Composite composite = Widgets.newComposite(this.widgetStorageTableToolTip);
            composite.setBackground(this.COLOR_INFO_BACKGROUND);
            composite.setLayout(new TableLayout(1.0, new double[]{1.0, 0.0}));
            Widgets.layout(composite, n3, 1, 15);
            Text text = Widgets.newStringView(composite, storageIndexData.name, 578);
            text.setForeground(this.COLOR_INFO_FOREGROUND);
            text.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(text, 0, 0, 15, 0, 0, 0, 0, 200, -1);
            Button button = new Button(composite, 0x1000000);
            button.setToolTipText(BARControl.tr("Copy name to clipboard.", new Object[0]));
            button.setImage(image);
            Widgets.layout(button, 0, 1, 11);
            button.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    Widgets.setClipboard(TabRestore.this.clipboard, storageIndexData.name);
                }

                @Override
                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }
            });
            ++n3;
            if (Settings.debugLevel > 0) {
                assert ((storageIndexData.id & 0xFL) == 3L) : storageIndexData;
                label = Widgets.newLabel((Composite)this.widgetStorageTableToolTip, BARControl.tr("Storage id", new Object[0]) + ":");
                label.setForeground(this.COLOR_INFO_FOREGROUND);
                label.setBackground(this.COLOR_INFO_BACKGROUND);
                Widgets.layout(label, n3, 0, 4);
                label = Widgets.newLabel((Composite)this.widgetStorageTableToolTip, Long.toString(storageIndexData.id >> 4));
                label.setForeground(this.COLOR_INFO_FOREGROUND);
                label.setBackground(this.COLOR_INFO_BACKGROUND);
                Widgets.layout(label, n3, 1, 12);
                ++n3;
            }
            label = Widgets.newLabel((Composite)this.widgetStorageTableToolTip, BARControl.tr("Entries", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetStorageTableToolTip, BARControl.tr("{0}", storageIndexData.getTotalEntryCount()));
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 1, 12);
            label = Widgets.newLabel((Composite)this.widgetStorageTableToolTip, BARControl.tr("Size", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, ++n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetStorageTableToolTip, String.format(BARControl.tr("{0} ({1} {1,choice,0#bytes|1#byte|1<bytes})", Units.formatByteSize(storageIndexData.getTotalSize()), storageIndexData.getTotalSize()), new Object[0]));
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 1, 12);
            label = Widgets.newLabel((Composite)this.widgetStorageTableToolTip, BARControl.tr("State", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, ++n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetStorageTableToolTip, storageIndexData.indexState.toString());
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 1, 12);
            label = Widgets.newLabel((Composite)this.widgetStorageTableToolTip, BARControl.tr("Last checked", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, ++n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetStorageTableToolTip, storageIndexData.lastCheckedDateTime > 0L ? this.SIMPLE_DATE_FORMAT.format(new Date(storageIndexData.lastCheckedDateTime * 1000L)) : "-");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 1, 12);
            label = Widgets.newLabel((Composite)this.widgetStorageTableToolTip, BARControl.tr("Error", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, ++n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetStorageTableToolTip, storageIndexData.errorMessage);
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 1, 12);
            ++n3;
            if (storageIndexData.jobUUID.isEmpty()) {
                Separator separator = Widgets.newSeparator(this.widgetStorageTableToolTip);
                separator.setForeground(this.COLOR_WARNING_FOREGROUND);
                separator.setBackground(this.COLOR_INFO_BACKGROUND);
                Widgets.layout(separator, n3, 0, 12, 0, 2);
                label = Widgets.newLabel((Composite)this.widgetStorageTableToolTip, BARControl.tr("Warnings", new Object[0]) + ":");
                label.setForeground(this.COLOR_WARNING_FOREGROUND);
                label.setBackground(this.COLOR_INFO_BACKGROUND);
                Widgets.layout(label, ++n3, 0, 4);
                if (storageIndexData.jobUUID.isEmpty()) {
                    label = Widgets.newLabel((Composite)this.widgetStorageTableToolTip, BARControl.tr("no job info", new Object[0]));
                    label.setForeground(this.COLOR_WARNING_FOREGROUND);
                    label.setBackground(this.COLOR_INFO_BACKGROUND);
                    Widgets.layout(label, n3, 1, 12);
                    ++n3;
                }
            }
            this.widgetStorageTableToolTip.layout();
            Widgets.showToolTip(this.widgetStorageTableToolTip, n, n2);
        }
    }

    private void showEntryToolTip(final EntryIndexData entryIndexData, int n, int n2) {
        Image image = Widgets.loadImage(this.shell.getDisplay(), "clipboard.png");
        final ArrayList arrayList = new ArrayList();
        if (entryIndexData != null) {
            try {
                BARServer.executeCommand(StringParser.format("INDEX_ENTRY_FRAGMENT_LIST entryId=%lld", entryIndexData.id), 2, new Command.ResultHandler(){

                    @Override
                    public void handle(int n, ValueMap valueMap) {
                        long l = valueMap.getLong("storageId");
                        String string = valueMap.getString("storageName");
                        long l2 = valueMap.getLong("fragmentOffset");
                        long l3 = valueMap.getLong("fragmentSize");
                        class FragmentData {
                            public long storageId;
                            public String storageName;
                            public long fragmentOffset;
                            public long fragmentSize;

                            public FragmentData(long l, String string, long l2, long l3) {
                                this.storageId = l;
                                this.storageName = string;
                                this.fragmentOffset = l2;
                                this.fragmentSize = l3;
                            }
                        }
                        arrayList.add(new FragmentData(l, string, l2, l3));
                    }
                });
            }
            catch (BARException bARException) {
                if (Settings.debugLevel > 0) {
                    BARControl.printStackTrace(bARException);
                }
            }
            catch (Exception exception) {
                BARControl.logThrowable(exception);
            }
        }
        if (this.widgetEntryTableToolTip != null) {
            this.widgetEntryTableToolTip.dispose();
        }
        if (!this.shell.isDisposed() && entryIndexData != null) {
            Label label;
            double[] dArray;
            this.widgetEntryTableToolTip = new Shell(this.shell, 540676);
            this.widgetEntryTableToolTip.setBackground(this.COLOR_INFO_BACKGROUND);
            if (Settings.debugLevel > 0) {
                double[] dArray2 = new double[12];
                dArray2[0] = 0.0;
                dArray2[1] = 0.0;
                dArray2[2] = 0.0;
                dArray2[3] = 0.0;
                dArray2[4] = 0.0;
                dArray2[5] = 0.0;
                dArray2[6] = 1.0;
                dArray2[7] = 0.0;
                dArray2[8] = 0.0;
                dArray2[9] = 0.0;
                dArray2[10] = 0.0;
                dArray = dArray2;
                dArray2[11] = 0.0;
            } else {
                double[] dArray3 = new double[11];
                dArray3[0] = 0.0;
                dArray3[1] = 0.0;
                dArray3[2] = 0.0;
                dArray3[3] = 0.0;
                dArray3[4] = 0.0;
                dArray3[5] = 1.0;
                dArray3[6] = 0.0;
                dArray3[7] = 0.0;
                dArray3[8] = 0.0;
                dArray3[9] = 0.0;
                dArray = dArray3;
                dArray3[10] = 0.0;
            }
            this.widgetEntryTableToolTip.setLayout(new TableLayout(dArray, new double[]{0.0, 1.0}, 2));
            Widgets.layout(this.widgetEntryTableToolTip, 0, 0, 15);
            int n3 = 0;
            if (Settings.debugLevel > 0) {
                assert ((entryIndexData.id & 0xFL) >= 5L && (entryIndexData.id & 0xFL) <= 10L) : entryIndexData;
                label = Widgets.newLabel((Composite)this.widgetEntryTableToolTip, BARControl.tr("Entry id", new Object[0]) + ":");
                label.setForeground(this.COLOR_INFO_FOREGROUND);
                label.setBackground(this.COLOR_INFO_BACKGROUND);
                Widgets.layout(label, n3, 0, 4);
                label = Widgets.newLabel((Composite)this.widgetEntryTableToolTip, Long.toString(entryIndexData.id >> 4));
                label.setForeground(this.COLOR_INFO_FOREGROUND);
                label.setBackground(this.COLOR_INFO_BACKGROUND);
                Widgets.layout(label, n3, 1, 12);
                ++n3;
            }
            label = Widgets.newLabel((Composite)this.widgetEntryTableToolTip, BARControl.tr("Job", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetEntryTableToolTip, entryIndexData.jobName);
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 1, 12);
            label = Widgets.newLabel((Composite)this.widgetEntryTableToolTip, BARControl.tr("Type", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, ++n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetEntryTableToolTip, entryIndexData.archiveType.getText());
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 1, 12);
            label = Widgets.newLabel((Composite)this.widgetEntryTableToolTip, BARControl.tr("Hostname", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, ++n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetEntryTableToolTip, entryIndexData.hostName);
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 1, 12);
            label = Widgets.newLabel((Composite)this.widgetEntryTableToolTip, BARControl.tr("Created", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, ++n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetEntryTableToolTip, entryIndexData.dateTime > 0L ? this.SIMPLE_DATE_FORMAT.format(new Date(entryIndexData.dateTime * 1000L)) : "-");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 1, 12);
            Control control = Widgets.newSpacer(this.widgetEntryTableToolTip);
            Widgets.layout(control, ++n3, 0, 12, 0, 2, 0, 0, -1, 1, -1, 1, -1, 1);
            label = Widgets.newLabel((Composite)this.widgetEntryTableToolTip, BARControl.tr("Name", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, ++n3, 0, 5);
            Composite composite = Widgets.newComposite(this.widgetEntryTableToolTip);
            composite.setBackground(this.COLOR_INFO_BACKGROUND);
            composite.setLayout(new TableLayout(1.0, new double[]{1.0, 0.0}));
            Widgets.layout(composite, n3, 1, 15);
            Text text = Widgets.newStringView(composite, entryIndexData.name, 578);
            text.setForeground(this.COLOR_INFO_FOREGROUND);
            text.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(text, 0, 0, 15, 0, 0, 0, 0, 200, -1);
            Button button = new Button(composite, 0x1000000);
            button.setToolTipText(BARControl.tr("Copy name to clipboard.", new Object[0]));
            button.setImage(image);
            Widgets.layout(button, 0, 1, 8);
            button.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    Widgets.setClipboard(TabRestore.this.clipboard, entryIndexData.name);
                }

                @Override
                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }
            });
            label = Widgets.newLabel((Composite)this.widgetEntryTableToolTip, BARControl.tr("Type", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, ++n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetEntryTableToolTip, entryIndexData.entryType.getText());
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 1, 12);
            label = Widgets.newLabel((Composite)this.widgetEntryTableToolTip, BARControl.tr("Size", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, ++n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetEntryTableToolTip, String.format(BARControl.tr("{0} ({1} {1,choice,0#bytes|1#byte|1<bytes})", Units.formatByteSize(entryIndexData.size), entryIndexData.size), new Object[0]));
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 1, 12);
            label = Widgets.newLabel((Composite)this.widgetEntryTableToolTip, BARControl.tr("Date/Time", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, ++n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetEntryTableToolTip, entryIndexData.dateTime > 0L ? this.SIMPLE_DATE_FORMAT.format(new Date(entryIndexData.dateTime * 1000L)) : "-");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 1, 12);
            label = Widgets.newLabel((Composite)this.widgetEntryTableToolTip, BARControl.tr("Fragments", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, ++n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetEntryTableToolTip, arrayList.size() > 0 ? String.format("%d", arrayList.size()) : "-");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 1, 12);
            Table table = Widgets.newTable(this.widgetEntryTableToolTip, 768);
            table.setForeground(this.COLOR_INFO_FOREGROUND);
            table.setBackground(this.COLOR_INFO_BACKGROUND);
            table.setHeaderVisible(false);
            Widgets.layout(table, ++n3, 1, 15, 0, 0, 0, 0, 400, 200);
            Widgets.addTableColumn(table, 0, 131072, 80, true);
            Widgets.addTableColumn(table, 1, 131072, 80, true);
            Widgets.addTableColumn(table, 2, 16384, 800, true);
            for (FragmentData fragmentData : arrayList) {
                TableItem tableItem = new TableItem(table, 0);
                tableItem.setText(0, Long.toString(fragmentData.fragmentOffset));
                tableItem.setText(1, Long.toString(fragmentData.fragmentSize));
                tableItem.setText(2, fragmentData.storageName);
            }
            ++n3;
            Widgets.showToolTip(this.widgetEntryTableToolTip, n, n2);
        }
    }

    TabRestore(final TabFolder tabFolder, int n) {
        this.shell = tabFolder.getShell();
        this.display = this.shell.getDisplay();
        this.clipboard = new Clipboard(this.display);
        this.COLOR_MODIFIED = this.display.getSystemColor(15);
        this.COLOR_INFO_FOREGROUND = this.display.getSystemColor(28);
        this.COLOR_WARNING_FOREGROUND = this.display.getSystemColor(3);
        this.COLOR_INFO_BACKGROUND = this.display.getSystemColor(29);
        this.COLOR_NO_JOB_INFO = new Color(null, 255, 192, 160);
        this.IMAGE_DIRECTORY = Widgets.loadImage(this.display, "directory.png");
        this.IMAGE_CLEAR = Widgets.loadImage(this.display, "clear.png");
        this.IMAGE_MARK_ALL = Widgets.loadImage(this.display, "mark.png");
        this.IMAGE_UNMARK_ALL = Widgets.loadImage(this.display, "unmark.png");
        this.widgetTab = Widgets.addTab(tabFolder, BARControl.tr("Restore", new Object[0]) + (n != 0 ? " (" + Widgets.acceleratorToText(n) + ")" : ""), !BARServer.isSlave());
        this.widgetTab.setLayout(new TableLayout(new double[]{1.0, 0.0}, 1.0, 2));
        Widgets.layout(this.widgetTab, 0, 0, 15);
        tabFolder.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabItem tabItem = (TabItem)selectionEvent.item;
                TabItem[] tabItemArray = tabFolder.getItems();
                if (tabItemArray.length >= 3 && tabItemArray[2] == tabItem) {
                    if (TabRestore.this.updateEntryTableThread.getTotalEntryCount() >= 32000L) {
                        Dialogs.warning(TabRestore.this.shell, Dialogs.booleanFieldUpdater(Settings.class, "showEntriesExceededInfo"), BARControl.tr("There are {0} entries. Only the first {1} are shown in the list.", TabRestore.this.updateEntryTableThread.getTotalEntryCount(), 32000), new Object[0]);
                    }
                    TabRestore.this.updateAssignToTimerTask = new TimerTask(){

                        @Override
                        public void run() {
                            TabRestore.this.updateAssignTo();
                        }
                    };
                    TabRestore.this.updateAssignToTimer.schedule(TabRestore.this.updateAssignToTimerTask, 0L, 30000L);
                } else if (TabRestore.this.updateAssignToTimerTask != null) {
                    TabRestore.this.updateAssignToTimerTask.cancel();
                    TabRestore.this.updateAssignToTimerTask = null;
                }
            }
        });
        Pane pane = Widgets.newPane(this.widgetTab, 2, 256);
        Widgets.layout(pane, 0, 0, 15);
        pane.addListener(11, new Listener(){

            @Override
            public void handleEvent(Event event) {
                Pane pane = (Pane)event.widget;
                Settings.restorePaneSizes = new Settings.PaneSizes(pane.getSizes());
            }
        });
        pane.setSizes(Settings.restorePaneSizes.sizes);
        Composite composite = pane.getComposite(0);
        composite.setLayout(new TableLayout(1.0, 1.0));
        Widgets.layout(composite, 0, 0, 15);
        Composite composite2 = Widgets.newComposite(composite);
        composite2.setLayout(new TableLayout(new double[]{1.0, 0.0}, 1.0, 4));
        Widgets.layout(composite2, 0, 0, 15);
        this.widgetStorageTabFolder = Widgets.newTabFolder(composite2);
        Widgets.layout(this.widgetStorageTabFolder, 0, 0, 15);
        this.widgetStorageTabFolderTitle = this.widgetStorageTabFolder;
        this.widgetStorageTabFolderTitle.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent paintEvent) {
                TabFolder tabFolder = (TabFolder)paintEvent.widget;
                GC gC = paintEvent.gc;
                Rectangle rectangle = tabFolder.getBounds();
                Color color = tabFolder.getForeground();
                String string = BARControl.tr("Storages", new Object[0]);
                Point point = Widgets.getTextSize(gC, string);
                gC.setForeground(TabRestore.this.display.getSystemColor(2));
                gC.drawText(string, (rectangle.width - point.x) / 2, 8, true);
                string = BARControl.tr("Count: {0} / Size: {1}", TabRestore.this.updateStorageTreeTableThread.getTotalStorageCount(), Units.formatByteSize(TabRestore.this.updateStorageTreeTableThread.getTotalStorageSize()));
                point = Widgets.getTextSize(gC, string);
                gC.setForeground(color);
                gC.drawText(string, rectangle.width - point.x - 8, 8, true);
            }
        });
        Composite composite3 = Widgets.addTab(this.widgetStorageTabFolder, BARControl.tr("Jobs", new Object[0]));
        composite3.setLayout(new TableLayout(new double[]{0.0, 1.0, 0.0}, 1.0, 2));
        Widgets.layout(composite3, 0, 0, 15);
        this.widgetStorageTree = Widgets.newTree(composite3, 34, new Widgets.TreeItemRenderer(){

            @Override
            public boolean render(TreeItem treeItem, int n, GC gC, int n2, int n3, int n4, int n5) {
                if (n == 2) {
                    IndexData indexData = (IndexData)treeItem.getData();
                    long l = indexData.getDateTime();
                    if (l > 0L) {
                        String string = TabRestore.this.SIMPLE_DATE_FORMAT1.format(new Date(l * 1000L));
                        String string2 = TabRestore.this.SIMPLE_DATE_FORMAT2.format(new Date(l * 1000L));
                        String string3 = TabRestore.this.SIMPLE_DATE_FORMAT3.format(new Date(l * 1000L));
                        Point point = gC.textExtent(string);
                        Point point2 = gC.textExtent("MMM");
                        Point point3 = gC.textExtent(string3);
                        gC.drawText(string, n2 + 0, n3, true);
                        gC.drawText(string2, n2 + point.x + 2, n3, true);
                        gC.drawText(string3, n2 + point.x + 2 + point2.x + 2, n3, true);
                    } else {
                        gC.drawText("-", n2 + 0, n3, true);
                    }
                    return true;
                }
                return false;
            }
        });
        this.widgetStorageTree.setLayout(new TableLayout(null, new double[]{1.0, 0.0, 0.0, 0.0}));
        Widgets.layout(this.widgetStorageTree, 1, 0, 15);
        SelectionListener selectionListener = new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TreeColumn treeColumn = (TreeColumn)selectionEvent.widget;
                IndexDataComparator indexDataComparator = new IndexDataComparator(TabRestore.this.widgetStorageTree, treeColumn);
                Tree tree = TabRestore.this.widgetStorageTree;
                synchronized (tree) {
                    Widgets.sortTreeColumn(TabRestore.this.widgetStorageTree, treeColumn, indexDataComparator);
                }
            }
        };
        Listener listener = new Listener(){

            @Override
            public void handleEvent(Event event) {
                Settings.storageTreeColumns = new Settings.ColumnWidth(Widgets.getTreeColumnWidth(TabRestore.this.widgetStorageTree));
            }
        };
        TreeColumn treeColumn = Widgets.addTreeColumn(this.widgetStorageTree, BARControl.tr("Name", new Object[0]), 16384, 400, true);
        treeColumn.setToolTipText(BARControl.tr("Click to sort for name.", new Object[0]));
        treeColumn.addSelectionListener(selectionListener);
        treeColumn.addListener(11, listener);
        treeColumn = Widgets.addTreeColumn(this.widgetStorageTree, BARControl.tr("Hostname", new Object[0]), 16384, 150, true);
        treeColumn.setToolTipText(BARControl.tr("Click to sort for name.", new Object[0]));
        treeColumn.addSelectionListener(selectionListener);
        treeColumn.addListener(11, listener);
        treeColumn = Widgets.addTreeColumn(this.widgetStorageTree, BARControl.tr("Created", new Object[0]), 16384, 170, true);
        treeColumn.setToolTipText(BARControl.tr("Click to sort for created date/time.", new Object[0]));
        treeColumn.addSelectionListener(selectionListener);
        treeColumn.addListener(11, listener);
        treeColumn = Widgets.addTreeColumn(this.widgetStorageTree, BARControl.tr("Size", new Object[0]), 131072, 100, true);
        treeColumn.setToolTipText(BARControl.tr("Click to sort for size.", new Object[0]));
        treeColumn.addSelectionListener(selectionListener);
        treeColumn.addListener(11, listener);
        treeColumn = Widgets.addTreeColumn(this.widgetStorageTree, BARControl.tr("State", new Object[0]), 16384, 60, true);
        treeColumn.setToolTipText(BARControl.tr("Click to sort for state.", new Object[0]));
        treeColumn.addSelectionListener(selectionListener);
        treeColumn.addListener(11, listener);
        Widgets.setTreeColumnWidth(this.widgetStorageTree, Settings.storageTreeColumns.width);
        this.widgetStorageTree.addListener(40, new Listener(){

            @Override
            public void handleEvent(Event event) {
                TreeItem treeItem = (TreeItem)event.item;
                if (event.index == 2) {
                    event.detail &= 0xFFFFFFEF;
                }
            }
        });
        this.widgetStorageTree.addListener(42, new Listener(){

            @Override
            public void handleEvent(Event event) {
                IndexData indexData;
                TreeItem treeItem = (TreeItem)event.item;
                if (event.index == 2 && (indexData = (IndexData)treeItem.getData()) != null) {
                    long l = indexData.getDateTime();
                    if (l > 0L) {
                        String string = TabRestore.this.SIMPLE_DATE_FORMAT1.format(new Date(l * 1000L));
                        String string2 = TabRestore.this.SIMPLE_DATE_FORMAT2.format(new Date(l * 1000L));
                        String string3 = TabRestore.this.SIMPLE_DATE_FORMAT3.format(new Date(l * 1000L));
                        Point point = event.gc.textExtent(string);
                        Point point2 = event.gc.textExtent("MMM");
                        Point point3 = event.gc.textExtent(string3);
                        event.gc.drawText(string, event.x + 0, event.y + (event.height - point.y) / 2, true);
                        event.gc.drawText(string2, event.x + point.x + 2, event.y + (event.height - point2.y) / 2, true);
                        event.gc.drawText(string3, event.x + point.x + 2 + point2.x + 2, event.y + (event.height - point3.y) / 2, true);
                    } else {
                        String string = "-";
                        Point point = event.gc.textExtent(string);
                        event.gc.drawText(string, event.x + 0, event.y + (event.height - point.y) / 2, true);
                    }
                }
            }
        });
        this.widgetStorageTree.addListener(17, new Listener(){

            @Override
            public void handleEvent(Event event) {
                TreeItem treeItem = (TreeItem)event.item;
                if (!treeItem.isDisposed()) {
                    treeItem.removeAll();
                    TabRestore.this.updateStorageTreeTableThread.updateTreeItem(treeItem);
                }
                if (!treeItem.isDisposed()) {
                    treeItem.setExpanded(true);
                }
            }
        });
        this.widgetStorageTree.addListener(18, new Listener(){

            @Override
            public void handleEvent(Event event) {
                TreeItem treeItem = (TreeItem)event.item;
                if (!treeItem.isDisposed()) {
                    Widgets.removeAllTreeItems(treeItem);
                    treeItem.setExpanded(false);
                    new TreeItem(treeItem, 0);
                }
            }
        });
        this.widgetStorageTree.addListener(8, new Listener(){

            @Override
            public void handleEvent(Event event) {
                TreeItem treeItem = TabRestore.this.widgetStorageTree.getItem(new Point(event.x, event.y));
                if (treeItem != null && !treeItem.isDisposed()) {
                    if (treeItem.getData() instanceof UUIDIndexData || treeItem.getData() instanceof EntityIndexData) {
                        Event event2 = new Event();
                        event2.item = treeItem;
                        if (treeItem.getExpanded()) {
                            TabRestore.this.widgetStorageTree.notifyListeners(18, event2);
                        } else {
                            TabRestore.this.widgetStorageTree.notifyListeners(17, event2);
                        }
                    } else if (treeItem.getData() instanceof StorageIndexData) {
                        // empty if block
                    }
                }
            }
        });
        this.widgetStorageTree.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                IndexData indexData;
                TreeItem treeItem = (TreeItem)selectionEvent.item;
                if (treeItem != null && !treeItem.isDisposed() && (indexData = (IndexData)treeItem.getData()) != null) {
                    if (indexData instanceof UUIDIndexData) {
                        Widgets.notify((Widget)TabRestore.this.shell, 65539, ((UUIDIndexData)indexData).jobUUID);
                        if (selectionEvent.detail == 32) {
                            boolean bl = Widgets.getTreeItemChecked(treeItem);
                            TabRestore.this.setStorageList(indexData.id, bl);
                            if (bl) {
                                for (TreeItem treeItem2 : ((TreeItem)selectionEvent.item).getItems()) {
                                    IndexData indexData2;
                                    if (treeItem2 == null || treeItem2.isDisposed() || (indexData2 = (IndexData)treeItem2.getData()) == null || !(indexData2 instanceof EntityIndexData)) continue;
                                    treeItem2.setChecked(false);
                                    TabRestore.this.setStorageList(indexData2.id, false);
                                    for (TreeItem treeItem3 : treeItem2.getItems()) {
                                        IndexData indexData3;
                                        if (treeItem3 == null || treeItem3.isDisposed() || (indexData3 = (IndexData)treeItem3.getData()) == null || !(indexData3 instanceof StorageIndexData)) continue;
                                        treeItem3.setChecked(false);
                                    }
                                }
                            }
                            TabRestore.this.checkedIndexEvent.trigger();
                            TabRestore.this.updateStorageTreeTableThread.triggerUpdate();
                        }
                    } else if (indexData instanceof EntityIndexData) {
                        if (selectionEvent.detail == 32) {
                            IndexData indexData4;
                            TreeItem treeItem4;
                            boolean bl = Widgets.getTreeItemChecked(treeItem);
                            TabRestore.this.setStorageList(indexData.id, bl);
                            if (bl && (treeItem4 = ((TreeItem)selectionEvent.item).getParentItem()) != null && !treeItem4.isDisposed() && (indexData4 = (IndexData)treeItem4.getData()) != null && indexData4 instanceof UUIDIndexData) {
                                treeItem4.setChecked(false);
                                TabRestore.this.setStorageList(indexData4.id, false);
                            }
                            TabRestore.this.checkedIndexEvent.trigger();
                            TabRestore.this.updateStorageTreeTableThread.triggerUpdate();
                        }
                    } else if (indexData instanceof StorageIndexData) {
                        // empty if block
                    }
                }
            }
        });
        this.widgetStorageTree.addMouseTrackListener(new MouseTrackListener(){

            @Override
            public void mouseEnter(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExit(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseHover(MouseEvent mouseEvent) {
                Tree tree = (Tree)mouseEvent.widget;
                TreeItem treeItem = tree.getItem(new Point(mouseEvent.x, mouseEvent.y));
                if (TabRestore.this.widgetStorageTreeToolTip != null) {
                    TabRestore.this.widgetStorageTreeToolTip.dispose();
                    TabRestore.this.widgetStorageTreeToolTip = null;
                }
                if (treeItem != null && mouseEvent.x > tree.getBounds().width / 2) {
                    Point point = TabRestore.this.display.getCursorLocation();
                    if (point.x > 16) {
                        point.x -= 16;
                    }
                    if (point.y > 16) {
                        point.y -= 16;
                    }
                    if (treeItem.getData() instanceof UUIDIndexData) {
                        TabRestore.this.showUUIDIndexToolTip((UUIDIndexData)treeItem.getData(), point.x, point.y);
                    } else if (treeItem.getData() instanceof EntityIndexData) {
                        TabRestore.this.showEntityIndexToolTip((EntityIndexData)treeItem.getData(), point.x, point.y);
                    } else if (treeItem.getData() instanceof StorageIndexData) {
                        TabRestore.this.showStorageIndexToolTip((StorageIndexData)treeItem.getData(), point.x, point.y);
                    }
                }
            }
        });
        this.widgetStorageTree.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                block4: {
                    block6: {
                        block5: {
                            block3: {
                                if (!Widgets.isAccelerator(keyEvent, 0x1000009)) break block3;
                                TabRestore.this.refreshStorageIndex();
                                break block4;
                            }
                            if (!Widgets.isAccelerator(keyEvent, 127)) break block5;
                            TabRestore.this.removeStoragesFromIndex();
                            break block4;
                        }
                        if (!Widgets.isAccelerator(keyEvent, 13) && !Widgets.isAccelerator(keyEvent, 0x1000050)) break block6;
                        for (TreeItem treeItem : TabRestore.this.widgetStorageTree.getSelection()) {
                            Event event = new Event();
                            event.item = treeItem;
                            if (treeItem.getExpanded()) {
                                TabRestore.this.widgetStorageTree.notifyListeners(18, event);
                                continue;
                            }
                            TabRestore.this.widgetStorageTree.notifyListeners(17, event);
                        }
                        break block4;
                    }
                    if (!Widgets.isAccelerator(keyEvent, 32)) break block4;
                    for (TreeItem treeItem : TabRestore.this.widgetStorageTree.getSelection()) {
                        IndexData indexData = (IndexData)treeItem.getData();
                        Widgets.setTreeItemChecked(treeItem, !Widgets.getTreeItemChecked(treeItem));
                        Event event = new Event();
                        event.item = treeItem;
                        event.detail = 32;
                        TabRestore.this.widgetStorageTree.notifyListeners(13, event);
                    }
                }
            }
        });
        DragSource dragSource = new DragSource(this.widgetStorageTree, 2);
        dragSource.setTransfer(new Transfer[]{IndexDataTransfer.getInstance()});
        dragSource.addDragListener(new DragSourceListener(){

            @Override
            public void dragStart(DragSourceEvent dragSourceEvent) {
                Point point = new Point(dragSourceEvent.x, dragSourceEvent.y);
                TabRestore.this.selectedIndexDataHashSet = TabRestore.this.getSelectedIndexData();
            }

            @Override
            public void dragSetData(DragSourceEvent dragSourceEvent) {
                dragSourceEvent.data = TabRestore.this.selectedIndexDataHashSet;
            }

            @Override
            public void dragFinished(DragSourceEvent dragSourceEvent) {
                TabRestore.this.selectedIndexDataHashSet = null;
            }
        });
        DropTarget dropTarget = new DropTarget(this.widgetStorageTree, 2);
        dropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance(), IndexDataTransfer.getInstance()});
        dropTarget.addDropListener(new DropTargetAdapter(){

            @Override
            public void dragLeave(DropTargetEvent dropTargetEvent) {
            }

            @Override
            public void dragOver(DropTargetEvent dropTargetEvent) {
            }

            @Override
            public void drop(DropTargetEvent dropTargetEvent) {
                if (dropTargetEvent.data != null) {
                    Point point = TabRestore.this.display.map(null, TabRestore.this.widgetStorageTree, dropTargetEvent.x, dropTargetEvent.y);
                    TreeItem treeItem = TabRestore.this.widgetStorageTree.getItem(point);
                    if (treeItem != null) {
                        HashSet hashSet = (HashSet)dropTargetEvent.data;
                        IndexData indexData = (IndexData)treeItem.getData();
                        if (indexData instanceof UUIDIndexData) {
                            UUIDIndexData uUIDIndexData = (UUIDIndexData)indexData;
                            TabRestore.this.assignStorages((HashSet<IndexData>)hashSet, uUIDIndexData);
                        } else if (indexData instanceof EntityIndexData) {
                            EntityIndexData entityIndexData = (EntityIndexData)indexData;
                            TabRestore.this.assignStorages((HashSet<IndexData>)hashSet, entityIndexData);
                        } else if (indexData instanceof StorageIndexData) {
                            EntityIndexData entityIndexData;
                            StorageIndexData storageIndexData = (StorageIndexData)indexData;
                            if (treeItem != null && (entityIndexData = (EntityIndexData)treeItem.getParentItem().getData()) != null) {
                                TabRestore.this.assignStorages((HashSet<IndexData>)hashSet, entityIndexData);
                            }
                        }
                    }
                } else {
                    dropTargetEvent.detail = 0;
                }
            }
        });
        composite3 = Widgets.addTab(this.widgetStorageTabFolder, BARControl.tr("Archives", new Object[0]), Settings.hasExpertRole());
        composite3.setLayout(new TableLayout(new double[]{0.0, 1.0, 0.0}, 1.0, 2));
        Widgets.layout(composite3, 0, 0, 15);
        this.widgetStorageTable = Widgets.newTable(composite3, 0x10000020, new Widgets.TableItemRenderer(){

            @Override
            public boolean render(TableItem tableItem, int n, GC gC, int n2, int n3, int n4, int n5) {
                if (n == 2) {
                    IndexData indexData = (IndexData)tableItem.getData();
                    long l = indexData.getDateTime();
                    if (l > 0L) {
                        String string = TabRestore.this.SIMPLE_DATE_FORMAT1.format(new Date(l * 1000L));
                        String string2 = TabRestore.this.SIMPLE_DATE_FORMAT2.format(new Date(l * 1000L));
                        String string3 = TabRestore.this.SIMPLE_DATE_FORMAT3.format(new Date(l * 1000L));
                        Point point = gC.textExtent(string);
                        Point point2 = gC.textExtent("MMM");
                        Point point3 = gC.textExtent(string3);
                        gC.drawText(string, n2 + 0, n3, true);
                        gC.drawText(string2, n2 + point.x + 2, n3, true);
                        gC.drawText(string3, n2 + point.x + 2 + point2.x + 2, n3, true);
                    } else {
                        gC.drawText("-", n2 + 0, n3, true);
                    }
                    return true;
                }
                return false;
            }
        });
        this.widgetStorageTable.setLayout(new TableLayout(null, new double[]{1.0, 0.0, 0.0, 0.0}));
        Widgets.layout(this.widgetStorageTable, 1, 0, 15);
        SelectionListener selectionListener2 = new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TableColumn tableColumn = (TableColumn)selectionEvent.widget;
                Table table = tableColumn.getParent();
                IndexDataComparator indexDataComparator = new IndexDataComparator(table, tableColumn);
                Table table2 = table;
                synchronized (table2) {
                    BARControl.waitCursor();
                    try {
                        Widgets.sortTableColumn(table, tableColumn, indexDataComparator);
                    }
                    finally {
                        BARControl.resetCursor();
                    }
                }
            }
        };
        Listener listener2 = new Listener(){

            @Override
            public void handleEvent(Event event) {
                Settings.storageTableColumns = new Settings.ColumnWidth(Widgets.getTableColumnWidth(TabRestore.this.widgetStorageTable));
            }
        };
        TableColumn tableColumn = Widgets.addTableColumn(this.widgetStorageTable, 0, BARControl.tr("Name", new Object[0]), 16384, 450, true);
        tableColumn.setToolTipText(BARControl.tr("Click to sort for name.", new Object[0]));
        tableColumn.addSelectionListener(selectionListener2);
        tableColumn.addListener(11, listener2);
        tableColumn = Widgets.addTableColumn(this.widgetStorageTable, 1, BARControl.tr("Hostname", new Object[0]), 16384, 150, true);
        tableColumn.setToolTipText(BARControl.tr("Click to sort for hostname.", new Object[0]));
        tableColumn.addSelectionListener(selectionListener2);
        tableColumn.addListener(11, listener2);
        tableColumn = Widgets.addTableColumn(this.widgetStorageTable, 2, BARControl.tr("Size", new Object[0]), 131072, 60, true);
        tableColumn.setToolTipText(BARControl.tr("Click to sort for size.", new Object[0]));
        tableColumn.addSelectionListener(selectionListener2);
        tableColumn.addListener(11, listener2);
        tableColumn = Widgets.addTableColumn(this.widgetStorageTable, 3, BARControl.tr("Modified", new Object[0]), 16384, 150, true);
        tableColumn.setToolTipText(BARControl.tr("Click to sort for modification date/time.", new Object[0]));
        tableColumn.addSelectionListener(selectionListener2);
        tableColumn.addListener(11, listener2);
        tableColumn = Widgets.addTableColumn(this.widgetStorageTable, 4, BARControl.tr("State", new Object[0]), 16384, 60, true);
        tableColumn.setToolTipText(BARControl.tr("Click to sort for state.", new Object[0]));
        tableColumn.addSelectionListener(selectionListener2);
        tableColumn.addListener(11, listener2);
        Widgets.setTableColumnWidth(this.widgetStorageTable, Settings.storageTableColumns.width);
        Widgets.sortTable(this.widgetStorageTable, 0, 128);
        this.widgetStorageTable.addListener(40, new Listener(){

            @Override
            public void handleEvent(Event event) {
                TableItem tableItem = (TableItem)event.item;
                if (event.index == 3) {
                    event.detail &= 0xFFFFFFEF;
                }
            }
        });
        this.widgetStorageTable.addListener(42, new Listener(){

            @Override
            public void handleEvent(Event event) {
                IndexData indexData;
                TableItem tableItem = (TableItem)event.item;
                if (event.index == 3 && (indexData = (IndexData)tableItem.getData()) != null) {
                    long l = indexData.getDateTime();
                    if (l > 0L) {
                        String string = TabRestore.this.SIMPLE_DATE_FORMAT1.format(new Date(l * 1000L));
                        String string2 = TabRestore.this.SIMPLE_DATE_FORMAT2.format(new Date(l * 1000L));
                        String string3 = TabRestore.this.SIMPLE_DATE_FORMAT3.format(new Date(l * 1000L));
                        Point point = event.gc.textExtent(string);
                        Point point2 = event.gc.textExtent("MMM");
                        Point point3 = event.gc.textExtent(string3);
                        event.gc.drawText(string, event.x + 0, event.y + (event.height - point.y) / 2, true);
                        event.gc.drawText(string2, event.x + point.x + 2, event.y + (event.height - point2.y) / 2, true);
                        event.gc.drawText(string3, event.x + point.x + 2 + point2.x + 2, event.y + (event.height - point3.y) / 2, true);
                    } else {
                        String string = "-";
                        Point point = event.gc.textExtent(string);
                        event.gc.drawText(string, event.x + 0, event.y + (event.height - point.y) / 2, true);
                    }
                }
            }
        });
        this.widgetStorageTable.addListener(36, new Listener(){

            @Override
            public void handleEvent(Event event) {
                TableItem tableItem = (TableItem)event.item;
                int n = TabRestore.this.widgetStorageTable.indexOf(tableItem);
                if (n >= 0) {
                    TabRestore.this.updateStorageTreeTableThread.triggerUpdate(n);
                }
            }
        });
        this.widgetStorageTable.addListener(8, new Listener(){

            @Override
            public void handleEvent(Event event) {
                StorageIndexData storageIndexData;
                TableItem tableItem;
                if (event.detail == 32 && (tableItem = TabRestore.this.widgetStorageTable.getItem(new Point(event.x, event.y))) != null && (storageIndexData = (StorageIndexData)tableItem.getData()) != null) {
                    boolean bl = tableItem.getChecked();
                    tableItem.setChecked(!bl);
                    TabRestore.this.setStorageList(storageIndexData.id, !bl);
                    TabRestore.this.checkedIndexEvent.trigger();
                    TabRestore.this.updateStorageTreeTableThread.triggerUpdate();
                }
            }
        });
        this.widgetStorageTable.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                StorageIndexData storageIndexData;
                TableItem tableItem;
                if (selectionEvent.detail == 32 && (tableItem = (TableItem)selectionEvent.item) != null && (storageIndexData = (StorageIndexData)tableItem.getData()) != null) {
                    boolean bl = tableItem.getChecked();
                    TabRestore.this.setStorageList(storageIndexData.id, bl);
                    TabRestore.this.checkedIndexEvent.trigger();
                    TabRestore.this.updateStorageTreeTableThread.triggerUpdate();
                }
            }
        });
        this.widgetStorageTable.addMouseTrackListener(new MouseTrackListener(){

            @Override
            public void mouseEnter(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExit(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseHover(MouseEvent mouseEvent) {
                StorageIndexData storageIndexData;
                Table table = (Table)mouseEvent.widget;
                TableItem tableItem = table.getItem(new Point(mouseEvent.x, mouseEvent.y));
                if (TabRestore.this.widgetStorageTableToolTip != null) {
                    TabRestore.this.widgetStorageTableToolTip.dispose();
                    TabRestore.this.widgetStorageTableToolTip = null;
                }
                if (tableItem != null && mouseEvent.x > table.getBounds().width / 2 && (storageIndexData = (StorageIndexData)tableItem.getData()) != null) {
                    Point point = TabRestore.this.display.getCursorLocation();
                    if (point.x > 16) {
                        point.x -= 16;
                    }
                    if (point.y > 16) {
                        point.y -= 16;
                    }
                    TabRestore.this.showStorageIndexToolTip(storageIndexData, point.x, point.y);
                }
            }
        });
        this.widgetStorageTable.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (Widgets.isAccelerator(keyEvent, 0x1000009)) {
                    TabRestore.this.refreshStorageIndex();
                } else if (Widgets.isAccelerator(keyEvent, 127)) {
                    TabRestore.this.removeStoragesFromIndex();
                } else if (Widgets.isAccelerator(keyEvent, 32)) {
                    for (TableItem tableItem : TabRestore.this.widgetStorageTable.getSelection()) {
                        IndexData indexData = (IndexData)tableItem.getData();
                        tableItem.setChecked(!tableItem.getChecked());
                        Event event = new Event();
                        event.item = tableItem;
                        event.detail = 32;
                        TabRestore.this.widgetStorageTable.notifyListeners(13, event);
                    }
                }
            }
        });
        Menu menu = Widgets.newPopupMenu(this.shell);
        MenuItem menuItem = Widgets.addMenuItem(menu, BARControl.tr("Test", new Object[0]) + "\u2026");
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabRestore.this.testStorages();
            }
        });
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Refresh index", new Object[0]) + "\u2026");
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabRestore.this.refreshStorageIndex();
            }
        });
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Refresh all indices with error", new Object[0]) + "\u2026", Settings.hasNormalRole());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabRestore.this.refreshAllWithErrorStorageIndex();
            }
        });
        this.widgetStorageAssignToMenu = Widgets.addMenu(menu, BARControl.tr("Assign to job", new Object[0]) + "\u2026", Settings.hasExpertRole());
        this.widgetStorageAssignToMenu.addListener(22, new Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleEvent(Event event) {
                Object object = TabRestore.this.assignToLock;
                synchronized (object) {
                    TabRestore.this.updateAssignToMenu(TabRestore.this.widgetStorageAssignToMenu, TabRestore.this.assignToUUIDIndexDataList, TabRestore.this.assignToEntityIndexDataMap);
                }
            }
        });
        Menu menu2 = Widgets.addMenu(menu, BARControl.tr("Set job type", new Object[0]) + "\u2026", Settings.hasExpertRole());
        menuItem = Widgets.addMenuItem(menu2, null, BARControl.tr("normal", new Object[0]));
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabRestore.this.setEntityType(ArchiveTypes.NORMAL);
            }
        });
        menuItem = Widgets.addMenuItem(menu2, null, BARControl.tr("full", new Object[0]));
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabRestore.this.setEntityType(ArchiveTypes.FULL);
            }
        });
        menuItem = Widgets.addMenuItem(menu2, null, BARControl.tr("incremental", new Object[0]));
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabRestore.this.setEntityType(ArchiveTypes.INCREMENTAL);
            }
        });
        menuItem = Widgets.addMenuItem(menu2, null, BARControl.tr("differential", new Object[0]));
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabRestore.this.setEntityType(ArchiveTypes.DIFFERENTIAL);
            }
        });
        menuItem = Widgets.addMenuItem(menu2, null, BARControl.tr("continuous", new Object[0]));
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabRestore.this.setEntityType(ArchiveTypes.CONTINUOUS);
            }
        });
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Move to", new Object[0]) + "\u2026", Settings.hasExpertRole());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabRestore.this.moveEntityTo();
            }
        });
        Widgets.addMenuItemSeparator(menu);
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Add to index", new Object[0]) + "\u2026");
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabRestore.this.addStoragesToIndex();
            }
        });
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Remove from index", new Object[0]) + "\u2026");
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabRestore.this.removeStoragesFromIndex();
            }
        });
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Remove all indices with error", new Object[0]) + "\u2026", Settings.hasNormalRole());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabRestore.this.removeAllWithErrorStorageIndex();
            }
        });
        Widgets.addMenuItemSeparator(menu);
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Mark all", new Object[0]));
        Widgets.addEventListener(new WidgetEventListener<Boolean>((Widget)menuItem, this.enableMarkIndexEvent){

            @Override
            public void trigger(MenuItem menuItem, Boolean bl) {
                menuItem.setEnabled(bl);
            }
        });
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabRestore.this.enableMarkIndexEvent.trigger(false);
                TabRestore.this.setAllCheckedStorage(true);
                Widgets.refreshVirtualTable(TabRestore.this.widgetStorageTable);
                TabRestore.this.checkedIndexEvent.trigger();
                TabRestore.this.enableMarkIndexEvent.trigger(true);
            }
        });
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Unmark all", new Object[0]));
        Widgets.addEventListener(new WidgetEventListener<Boolean>((Widget)menuItem, this.enableMarkIndexEvent){

            @Override
            public void trigger(MenuItem menuItem, Boolean bl) {
                menuItem.setEnabled(bl);
            }
        });
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabRestore.this.enableMarkIndexEvent.trigger(false);
                TabRestore.this.setAllCheckedStorage(false);
                Widgets.refreshVirtualTable(TabRestore.this.widgetStorageTable);
                TabRestore.this.checkedIndexEvent.trigger();
                TabRestore.this.enableMarkIndexEvent.trigger(true);
            }
        });
        Widgets.addMenuItemSeparator(menu);
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Restore", new Object[0]) + "\u2026");
        Widgets.addEventListener(new WidgetEventListener(menuItem, this.checkedIndexEvent){

            @Override
            public void trigger(MenuItem menuItem) {
                menuItem.setEnabled(!TabRestore.this.checkedIndexIdSet.isEmpty());
            }
        });
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabRestore.this.restore(RestoreTypes.ARCHIVES, TabRestore.this.checkedIndexIdSet);
            }
        });
        Widgets.addMenuItemSeparator(menu);
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Delete", new Object[0]) + "\u2026");
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabRestore.this.deleteStorages();
            }
        });
        Widgets.addMenuItemSeparator(menu);
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Info", new Object[0]) + "\u2026");
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                switch (TabRestore.this.widgetStorageTabFolder.getSelectionIndex()) {
                    case 0: {
                        TreeItem[] treeItemArray = TabRestore.this.widgetStorageTree.getSelection();
                        if (treeItemArray.length <= 0) break;
                        if (TabRestore.this.widgetStorageTreeToolTip != null) {
                            TabRestore.this.widgetStorageTreeToolTip.dispose();
                            TabRestore.this.widgetStorageTreeToolTip = null;
                        }
                        if (treeItemArray[0] == null) break;
                        Point point = TabRestore.this.display.getCursorLocation();
                        if (point.x > 16) {
                            point.x -= 16;
                        }
                        if (point.y > 16) {
                            point.y -= 16;
                        }
                        if (treeItemArray[0].getData() instanceof UUIDIndexData) {
                            TabRestore.this.showUUIDIndexToolTip((UUIDIndexData)treeItemArray[0].getData(), point.x, point.y);
                            break;
                        }
                        if (treeItemArray[0].getData() instanceof EntityIndexData) {
                            TabRestore.this.showEntityIndexToolTip((EntityIndexData)treeItemArray[0].getData(), point.x, point.y);
                            break;
                        }
                        if (!(treeItemArray[0].getData() instanceof StorageIndexData)) break;
                        TabRestore.this.showStorageIndexToolTip((StorageIndexData)treeItemArray[0].getData(), point.x, point.y);
                        break;
                    }
                    case 1: {
                        TableItem[] tableItemArray = TabRestore.this.widgetStorageTable.getSelection();
                        if (tableItemArray.length <= 0) break;
                        if (TabRestore.this.widgetStorageTreeToolTip != null) {
                            TabRestore.this.widgetStorageTreeToolTip.dispose();
                            TabRestore.this.widgetStorageTreeToolTip = null;
                        }
                        if (tableItemArray[0] == null) break;
                        Point point = TabRestore.this.display.getCursorLocation();
                        if (point.x > 16) {
                            point.x -= 16;
                        }
                        if (point.y > 16) {
                            point.y -= 16;
                        }
                        TabRestore.this.showStorageIndexToolTip((StorageIndexData)tableItemArray[0].getData(), point.x, point.y);
                    }
                }
            }
        });
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuShown(MenuEvent menuEvent) {
                if (TabRestore.this.widgetStorageTreeToolTip != null) {
                    TabRestore.this.widgetStorageTreeToolTip.dispose();
                    TabRestore.this.widgetStorageTreeToolTip = null;
                }
                if (TabRestore.this.widgetStorageTableToolTip != null) {
                    TabRestore.this.widgetStorageTableToolTip.dispose();
                    TabRestore.this.widgetStorageTableToolTip = null;
                }
            }

            @Override
            public void menuHidden(MenuEvent menuEvent) {
            }
        });
        this.widgetStorageTree.setMenu(menu);
        this.widgetStorageTable.setMenu(menu);
        Composite composite4 = Widgets.newComposite(composite2);
        composite4.setLayout(new TableLayout(null, new double[]{0.0, 0.0, 1.0, 0.0, 0.0, 0.0}));
        Widgets.layout(composite4, 1, 0, 12);
        Button button = Widgets.newButton(composite4, this.IMAGE_MARK_ALL);
        Widgets.layout(button, 0, 0, 4);
        Widgets.addEventListener(new WidgetEventListener<Boolean>((Widget)button, this.enableMarkIndexEvent){

            @Override
            public void trigger(Control control, Boolean bl) {
                control.setEnabled(bl);
            }
        });
        Widgets.addEventListener(new WidgetEventListener(button, this.checkedIndexEvent){

            @Override
            public void trigger(Control control) {
                Button button = (Button)control;
                if (!TabRestore.this.checkedIndexIdSet.isEmpty()) {
                    button.setImage(TabRestore.this.IMAGE_UNMARK_ALL);
                    button.setToolTipText(BARControl.tr("Unmark all entries in list.", new Object[0]));
                } else {
                    button.setImage(TabRestore.this.IMAGE_MARK_ALL);
                    button.setToolTipText(BARControl.tr("Mark all entries in list.", new Object[0]));
                }
            }
        });
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                TabRestore.this.enableMarkIndexEvent.trigger(false);
                if (!TabRestore.this.checkedIndexIdSet.isEmpty()) {
                    TabRestore.this.setAllCheckedStorage(false);
                    Widgets.refreshVirtualTable(TabRestore.this.widgetStorageTable);
                    TabRestore.this.checkedIndexEvent.trigger();
                    button.setImage(TabRestore.this.IMAGE_MARK_ALL);
                    button.setToolTipText(BARControl.tr("Mark all entries in list.", new Object[0]));
                } else {
                    TabRestore.this.setAllCheckedStorage(true);
                    Widgets.refreshVirtualTable(TabRestore.this.widgetStorageTable);
                    TabRestore.this.checkedIndexEvent.trigger();
                    button.setImage(TabRestore.this.IMAGE_UNMARK_ALL);
                    button.setToolTipText(BARControl.tr("Unmark all entries in list.", new Object[0]));
                }
                TabRestore.this.enableMarkIndexEvent.trigger(true);
            }
        });
        Label label = Widgets.newLabel(composite4, BARControl.tr("Filter", new Object[0]) + ":");
        Widgets.layout(label, 0, 1, 4);
        this.widgetStorageFilter = Widgets.newText(composite4, 896);
        this.widgetStorageFilter.setToolTipText(BARControl.tr("Enter filter key words for storage list.", new Object[0]));
        this.widgetStorageFilter.setMessage(BARControl.tr("Enter text to filter storage list", new Object[0]));
        Widgets.layout(this.widgetStorageFilter, 0, 2, 12);
        this.widgetStorageFilter.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                Text text = (Text)selectionEvent.widget;
                TabRestore.this.updateStorageTreeTableThread.triggerUpdateStorageName(text.getText());
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Text text = (Text)selectionEvent.widget;
                TabRestore.this.updateStorageTreeTableThread.triggerUpdateStorageName(text.getText());
            }
        });
        this.widgetStorageFilter.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                Text text = (Text)keyEvent.widget;
                TabRestore.this.updateStorageTreeTableThread.triggerUpdateStorageName(text.getText());
            }
        });
        Composite composite5 = Widgets.newComposite(composite4, Settings.hasNormalRole());
        composite5.setLayout(new TableLayout(null, 0.0));
        Widgets.layout(composite5, 0, 3, 0);
        label = Widgets.newLabel(composite5, BARControl.tr("State", new Object[0]) + ":");
        Widgets.layout(label, 0, 0, 4);
        this.widgetStorageStateFilter = Widgets.newOptionMenu(composite5);
        this.widgetStorageStateFilter.setToolTipText(BARControl.tr("Storage states filter.", new Object[0]));
        this.widgetStorageStateFilter.setItems(new String[]{"*", BARControl.tr("ok", new Object[0]), BARControl.tr("error", new Object[0]), BARControl.tr("update", new Object[0]), BARControl.tr("update requested", new Object[0]), BARControl.tr("update/update requested", new Object[0]), BARControl.tr("error/update/update requested", new Object[0]), BARControl.tr("not assigned", new Object[0]), BARControl.tr("no job info", new Object[0])});
        this.widgetStorageStateFilter.setText("*");
        Widgets.layout(this.widgetStorageStateFilter, 0, 1, 4);
        this.widgetStorageStateFilter.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                EntityStates entityStates;
                IndexStateSet indexStateSet;
                String string;
                Combo combo = (Combo)selectionEvent.widget;
                switch (combo.getSelectionIndex()) {
                    case 0: {
                        string = null;
                        indexStateSet = TabRestore.this.INDEX_STATE_SET_ALL;
                        entityStates = EntityStates.ANY;
                        break;
                    }
                    case 1: {
                        string = null;
                        indexStateSet = new IndexStateSet(IndexStates.OK);
                        entityStates = EntityStates.ANY;
                        break;
                    }
                    case 2: {
                        string = null;
                        indexStateSet = new IndexStateSet(IndexStates.ERROR);
                        entityStates = EntityStates.ANY;
                        break;
                    }
                    case 3: {
                        string = null;
                        indexStateSet = new IndexStateSet(IndexStates.UPDATE);
                        entityStates = EntityStates.ANY;
                        break;
                    }
                    case 4: {
                        string = null;
                        indexStateSet = new IndexStateSet(IndexStates.UPDATE_REQUESTED);
                        entityStates = EntityStates.ANY;
                        break;
                    }
                    case 5: {
                        string = null;
                        indexStateSet = new IndexStateSet(IndexStates.UPDATE, IndexStates.UPDATE_REQUESTED);
                        entityStates = EntityStates.ANY;
                        break;
                    }
                    case 6: {
                        string = null;
                        indexStateSet = new IndexStateSet(IndexStates.ERROR, IndexStates.UPDATE, IndexStates.UPDATE_REQUESTED);
                        entityStates = EntityStates.ANY;
                        break;
                    }
                    case 7: {
                        string = null;
                        indexStateSet = TabRestore.this.INDEX_STATE_SET_ALL;
                        entityStates = EntityStates.NONE;
                        break;
                    }
                    case 8: {
                        string = "";
                        indexStateSet = TabRestore.this.INDEX_STATE_SET_ALL;
                        entityStates = EntityStates.ANY;
                        break;
                    }
                    default: {
                        string = null;
                        indexStateSet = new IndexStateSet(IndexStates.UNKNOWN);
                        entityStates = EntityStates.ANY;
                    }
                }
                TabRestore.this.updateStorageTreeTableThread.triggerUpdateStorageState(string, indexStateSet, entityStates);
            }
        });
        this.updateStorageTreeTableThread.triggerUpdateStorageState(null, this.INDEX_STATE_SET_ALL, EntityStates.ANY);
        button = Widgets.newButton(composite4, BARControl.tr("Restore", new Object[0]) + "\u2026");
        button.setToolTipText(BARControl.tr("Start restoring selected archives.", new Object[0]));
        button.setEnabled(false);
        Widgets.layout(button, 0, 4, 0, 0, 0, 0, 0, 160, -1);
        Widgets.addEventListener(new WidgetEventListener(button, this.checkedIndexEvent){

            @Override
            public void trigger(Control control) {
                control.setEnabled(!TabRestore.this.checkedIndexIdSet.isEmpty());
            }
        });
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabRestore.this.restore(RestoreTypes.ARCHIVES, TabRestore.this.checkedIndexIdSet);
            }
        });
        composite = pane.getComposite(1);
        composite.setLayout(new TableLayout(1.0, 1.0));
        Widgets.layout(composite, 0, 0, 15);
        composite2 = Widgets.newComposite(composite);
        composite2.setLayout(new TableLayout(new double[]{0.0, 1.0, 0.0}, 1.0, 4));
        Widgets.layout(composite2, 0, 0, 15);
        this.widgetEntryTableTitle = Widgets.newLabel(composite2);
        Widgets.layout(this.widgetEntryTableTitle, 0, 0, 12);
        this.widgetEntryTableTitle.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent paintEvent) {
                Label label = (Label)paintEvent.widget;
                GC gC = paintEvent.gc;
                Rectangle rectangle = label.getBounds();
                Color color = label.getForeground();
                String string = BARControl.tr("Entries", new Object[0]);
                Point point = Widgets.getTextSize(gC, string);
                gC.setForeground(TabRestore.this.display.getSystemColor(2));
                gC.drawText(string, (rectangle.width - point.x) / 2, (rectangle.height - point.y) / 2, true);
                string = BARControl.tr("Count: {0} / Size: {1}", TabRestore.this.updateEntryTableThread.getTotalEntryCount(), Units.formatByteSize(TabRestore.this.updateEntryTableThread.getTotalEntrySize()));
                point = Widgets.getTextSize(gC, string);
                gC.setForeground(color);
                gC.drawText(string, rectangle.width - point.x - 8, (rectangle.height - point.y) / 2, true);
            }
        });
        this.widgetEntryTable = Widgets.newTable(composite2, 0x10000020);
        this.widgetEntryTable.setLayout(new TableLayout(null, new double[]{1.0, 0.0, 0.0, 0.0}));
        Widgets.layout(this.widgetEntryTable, 1, 0, 15);
        selectionListener = new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TableColumn tableColumn = (TableColumn)selectionEvent.widget;
                Table table = tableColumn.getParent();
                Table table2 = TabRestore.this.widgetEntryTable;
                synchronized (table2) {
                    BARControl.waitCursor();
                    try {
                        Widgets.setSortTableColumn(table, tableColumn);
                        Widgets.refreshVirtualTable(table);
                    }
                    finally {
                        BARControl.resetCursor();
                    }
                }
            }
        };
        tableColumn = Widgets.addTableColumn(this.widgetEntryTable, 0, BARControl.tr("Name", new Object[0]), 16384, 270, true);
        tableColumn.setToolTipText(BARControl.tr("Click to sort for name.", new Object[0]));
        tableColumn.addSelectionListener(selectionListener);
        tableColumn = Widgets.addTableColumn(this.widgetEntryTable, 1, BARControl.tr("Type", new Object[0]), 16384, 90, true);
        tableColumn.setToolTipText(BARControl.tr("Click to sort for type.", new Object[0]));
        tableColumn.addSelectionListener(selectionListener);
        tableColumn = Widgets.addTableColumn(this.widgetEntryTable, 2, BARControl.tr("Size", new Object[0]), 131072, 60, true);
        tableColumn.setToolTipText(BARControl.tr("Click to sort for size.", new Object[0]));
        tableColumn.addSelectionListener(selectionListener);
        tableColumn = Widgets.addTableColumn(this.widgetEntryTable, 3, BARControl.tr("Date/Time", new Object[0]), 16384, 140, true);
        tableColumn.setToolTipText(BARControl.tr("Click to sort for date.", new Object[0]));
        tableColumn.addSelectionListener(selectionListener);
        this.widgetEntryTable.addListener(36, new Listener(){

            @Override
            public void handleEvent(Event event) {
                TableItem tableItem = (TableItem)event.item;
                int n = TabRestore.this.widgetEntryTable.indexOf(tableItem);
                if (n >= 0) {
                    TabRestore.this.updateEntryTableThread.triggerUpdateTableItem(n);
                }
            }
        });
        this.widgetEntryTable.addListener(8, new Listener(){

            @Override
            public void handleEvent(Event event) {
                EntryIndexData entryIndexData;
                TableItem tableItem;
                if (event.detail == 32 && (tableItem = TabRestore.this.widgetEntryTable.getItem(new Point(event.x, event.y))) != null && (entryIndexData = (EntryIndexData)tableItem.getData()) != null) {
                    boolean bl = tableItem.getChecked();
                    tableItem.setChecked(!bl);
                    TabRestore.this.setEntryList(entryIndexData.id, !bl);
                    TabRestore.this.checkedEntryEvent.trigger();
                }
            }
        });
        this.widgetEntryTable.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                EntryIndexData entryIndexData;
                TableItem tableItem;
                if (selectionEvent.detail == 32 && (tableItem = (TableItem)selectionEvent.item) != null && (entryIndexData = (EntryIndexData)tableItem.getData()) != null) {
                    boolean bl = tableItem.getChecked();
                    TabRestore.this.setEntryList(entryIndexData.id, bl);
                    TabRestore.this.checkedEntryEvent.trigger();
                }
            }
        });
        this.widgetEntryTable.addMouseTrackListener(new MouseTrackListener(){

            @Override
            public void mouseEnter(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExit(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseHover(MouseEvent mouseEvent) {
                EntryIndexData entryIndexData;
                Table table = (Table)mouseEvent.widget;
                TableItem tableItem = table.getItem(new Point(mouseEvent.x, mouseEvent.y));
                if (TabRestore.this.widgetEntryTableToolTip != null) {
                    TabRestore.this.widgetEntryTableToolTip.dispose();
                    TabRestore.this.widgetEntryTableToolTip = null;
                }
                if (tableItem != null && mouseEvent.x > table.getBounds().width / 2 && (entryIndexData = (EntryIndexData)tableItem.getData()) != null) {
                    Point point = TabRestore.this.display.getCursorLocation();
                    if (point.x > 16) {
                        point.x -= 16;
                    }
                    if (point.y > 16) {
                        point.y -= 16;
                    }
                    TabRestore.this.showEntryToolTip(entryIndexData, point.x, point.y);
                }
            }
        });
        Widgets.addEventListener(new WidgetEventListener(this.widgetEntryTable, this.checkedIndexEvent){

            @Override
            public void trigger(Control control) {
                TabRestore.this.updateEntryTableThread.triggerUpdate();
            }
        });
        menu = Widgets.newPopupMenu(this.shell);
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Mark all", new Object[0]));
        Widgets.addEventListener(new WidgetEventListener<Boolean>((Widget)menuItem, this.enableMarkEntriesEvent){

            @Override
            public void trigger(MenuItem menuItem, Boolean bl) {
                menuItem.setEnabled(bl);
            }
        });
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabRestore.this.enableMarkEntriesEvent.trigger(false);
                TabRestore.this.setAllCheckedEntries(true);
                Widgets.refreshVirtualTable(TabRestore.this.widgetEntryTable);
                TabRestore.this.checkedEntryEvent.trigger();
                TabRestore.this.enableMarkEntriesEvent.trigger(true);
            }
        });
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Unmark all", new Object[0]));
        Widgets.addEventListener(new WidgetEventListener<Boolean>((Widget)menuItem, this.enableMarkEntriesEvent){

            @Override
            public void trigger(MenuItem menuItem, Boolean bl) {
                menuItem.setEnabled(bl);
            }
        });
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabRestore.this.enableMarkEntriesEvent.trigger(false);
                TabRestore.this.setAllCheckedEntries(false);
                Widgets.refreshVirtualTable(TabRestore.this.widgetEntryTable);
                TabRestore.this.checkedEntryEvent.trigger();
                TabRestore.this.enableMarkEntriesEvent.trigger(true);
            }
        });
        Widgets.addMenuItemSeparator(menu);
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Restore", new Object[0]) + "\u2026");
        menuItem.setEnabled(false);
        Widgets.addEventListener(new WidgetEventListener(menuItem, this.checkedEntryEvent){

            @Override
            public void trigger(MenuItem menuItem) {
                menuItem.setEnabled(!TabRestore.this.checkedEntryIdSet.isEmpty());
            }
        });
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabRestore.this.restore(RestoreTypes.ENTRIES, TabRestore.this.checkedEntryIdSet);
            }
        });
        Widgets.addMenuItemSeparator(menu);
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Info", new Object[0]) + "\u2026");
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem[] tableItemArray = TabRestore.this.widgetEntryTable.getSelection();
                if (tableItemArray.length > 0) {
                    EntryIndexData entryIndexData;
                    if (TabRestore.this.widgetEntryTableToolTip != null) {
                        TabRestore.this.widgetEntryTableToolTip.dispose();
                        TabRestore.this.widgetEntryTableToolTip = null;
                    }
                    if (tableItemArray[0] != null && (entryIndexData = (EntryIndexData)tableItemArray[0].getData()) != null) {
                        Point point = TabRestore.this.display.getCursorLocation();
                        if (point.x > 16) {
                            point.x -= 16;
                        }
                        if (point.y > 16) {
                            point.y -= 16;
                        }
                        TabRestore.this.showEntryToolTip(entryIndexData, point.x, point.y);
                    }
                }
            }
        });
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuShown(MenuEvent menuEvent) {
                if (TabRestore.this.widgetStorageTreeToolTip != null) {
                    TabRestore.this.widgetStorageTreeToolTip.dispose();
                    TabRestore.this.widgetStorageTreeToolTip = null;
                }
                if (TabRestore.this.widgetEntryTableToolTip != null) {
                    TabRestore.this.widgetEntryTableToolTip.dispose();
                    TabRestore.this.widgetEntryTableToolTip = null;
                }
            }

            @Override
            public void menuHidden(MenuEvent menuEvent) {
            }
        });
        this.widgetEntryTable.setMenu(menu);
        composite4 = Widgets.newComposite(composite2);
        composite4.setLayout(new TableLayout(null, new double[]{0.0, 0.0, 1.0, 0.0, 0.0, 0.0}));
        Widgets.layout(composite4, 2, 0, 12);
        button = Widgets.newButton(composite4, this.IMAGE_MARK_ALL);
        Widgets.layout(button, 0, 0, 8);
        Widgets.addEventListener(new WidgetEventListener<Boolean>((Widget)button, this.enableMarkEntriesEvent){

            @Override
            public void trigger(Control control, Boolean bl) {
                control.setEnabled(bl);
            }
        });
        Widgets.addEventListener(new WidgetEventListener(button, this.checkedEntryEvent){

            @Override
            public void trigger(Control control) {
                Button button = (Button)control;
                if (!TabRestore.this.checkedEntryIdSet.isEmpty()) {
                    button.setImage(TabRestore.this.IMAGE_UNMARK_ALL);
                    button.setToolTipText(BARControl.tr("Unmark all entries in list.", new Object[0]));
                } else {
                    button.setImage(TabRestore.this.IMAGE_MARK_ALL);
                    button.setToolTipText(BARControl.tr("Mark all entries in list.", new Object[0]));
                }
            }
        });
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                TabRestore.this.enableMarkEntriesEvent.trigger(false);
                TabRestore.this.setAllCheckedEntries(TabRestore.this.checkedEntryIdSet.isEmpty());
                Widgets.refreshVirtualTable(TabRestore.this.widgetEntryTable);
                TabRestore.this.checkedEntryEvent.trigger();
                if (!TabRestore.this.checkedEntryIdSet.isEmpty()) {
                    button.setImage(TabRestore.this.IMAGE_UNMARK_ALL);
                    button.setToolTipText(BARControl.tr("Unmark all entries in list.", new Object[0]));
                } else {
                    button.setImage(TabRestore.this.IMAGE_MARK_ALL);
                    button.setToolTipText(BARControl.tr("Mark all entries in list.", new Object[0]));
                }
                TabRestore.this.enableMarkEntriesEvent.trigger(true);
            }
        });
        label = Widgets.newLabel(composite4, BARControl.tr("Filter", new Object[0]) + ":");
        Widgets.layout(label, 0, 1, 4);
        this.widgetEntryFilter = Widgets.newText(composite4, 896);
        this.widgetEntryFilter.setToolTipText(BARControl.tr("Enter filter key words for entry list.", new Object[0]));
        this.widgetEntryFilter.setMessage(BARControl.tr("Enter text to filter entry list", new Object[0]));
        Widgets.layout(this.widgetEntryFilter, 0, 2, 12);
        this.widgetEntryFilter.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                Text text = (Text)selectionEvent.widget;
                TabRestore.this.updateEntryTableThread.triggerUpdateEntryName(text.getText());
                text.setBackground(TabRestore.this.COLOR_MODIFIED);
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Text text = (Text)selectionEvent.widget;
                TabRestore.this.updateEntryTableThread.triggerUpdateEntryName(text.getText());
                text.setBackground(TabRestore.this.COLOR_MODIFIED);
            }
        });
        this.widgetEntryFilter.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                Text text = (Text)keyEvent.widget;
                TabRestore.this.updateEntryTableThread.triggerUpdateEntryName(text.getText());
                text.setBackground(TabRestore.this.COLOR_MODIFIED);
            }
        });
        composite5 = Widgets.newComposite(composite4, Settings.hasNormalRole());
        composite5.setLayout(new TableLayout(null, 0.0));
        Widgets.layout(composite5, 0, 3, 0);
        this.widgetEntryTypeFilter = Widgets.newOptionMenu(composite5);
        this.widgetEntryTypeFilter.setToolTipText(BARControl.tr("Entry type.", new Object[0]));
        Widgets.setOptionMenuItems(this.widgetEntryTypeFilter, new Object[]{"*", EntryTypes.ANY, BARControl.tr("files", new Object[0]), EntryTypes.FILE, BARControl.tr("images", new Object[0]), EntryTypes.IMAGE, BARControl.tr("directories", new Object[0]), EntryTypes.DIRECTORY, BARControl.tr("links", new Object[0]), EntryTypes.LINK, BARControl.tr("hardlinks", new Object[0]), EntryTypes.HARDLINK, BARControl.tr("special", new Object[0]), EntryTypes.SPECIAL});
        Widgets.setSelectedOptionMenuItem(this.widgetEntryTypeFilter, EntryTypes.ANY);
        Widgets.layout(this.widgetEntryTypeFilter, 0, 0, 4);
        this.widgetEntryTypeFilter.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Combo combo = (Combo)selectionEvent.widget;
                EntryTypes entryTypes = Widgets.getSelectedOptionMenuItem(combo, EntryTypes.ANY);
                TabRestore.this.clearEntryList();
                TabRestore.this.checkedEntryEvent.trigger();
                TabRestore.this.updateEntryTableThread.triggerUpdateEntryType(entryTypes);
            }
        });
        this.widgetEntryNewestOnly = Widgets.newCheckbox(composite5, BARControl.tr("newest only", new Object[0]));
        this.widgetEntryNewestOnly.setToolTipText(BARControl.tr("When this checkbox is enabled, only show newest entry instances and hide all older entry instances.", new Object[0]));
        Widgets.layout(this.widgetEntryNewestOnly, 0, 1, 4);
        this.widgetEntryNewestOnly.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                boolean bl = button.getSelection();
                TabRestore.this.clearEntryList();
                TabRestore.this.checkedEntryEvent.trigger();
                TabRestore.this.updateEntryTableThread.triggerUpdateNewestOnly(bl);
            }
        });
        button = Widgets.newButton(composite4, BARControl.tr("Restore", new Object[0]) + "\u2026");
        button.setToolTipText(BARControl.tr("Start restoring selected entries.", new Object[0]));
        button.setEnabled(false);
        Widgets.layout(button, 0, 5, 0, 0, 0, 0, 0, 160, -1);
        Widgets.addEventListener(new WidgetEventListener(button, this.checkedEntryEvent){

            @Override
            public void trigger(Control control) {
                control.setEnabled(!TabRestore.this.checkedEntryIdSet.isEmpty());
            }
        });
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                TabRestore.this.restore(RestoreTypes.ENTRIES, TabRestore.this.checkedEntryIdSet);
            }
        });
        this.shell.addListener(65535, new Listener(){

            @Override
            public void handleEvent(Event event) {
                if (!TabRestore.this.widgetStorageFilter.isDisposed()) {
                    TabRestore.this.widgetStorageFilter.setText("");
                }
                if (!TabRestore.this.widgetStorageStateFilter.isDisposed()) {
                    TabRestore.this.widgetStorageStateFilter.select(0);
                }
                TabRestore.this.setAllCheckedStorage(false);
                Widgets.refreshVirtualTable(TabRestore.this.widgetStorageTable);
                TabRestore.this.updateStorageTreeTableThread.triggerUpdate("", TabRestore.this.INDEX_STATE_SET_ALL, EntityStates.ANY, true);
                if (!TabRestore.this.widgetEntryFilter.isDisposed()) {
                    TabRestore.this.widgetEntryFilter.setText("");
                }
                Widgets.setSelectedOptionMenuItem(TabRestore.this.widgetEntryTypeFilter, EntryTypes.ANY);
                if (!TabRestore.this.widgetEntryNewestOnly.isDisposed()) {
                    TabRestore.this.widgetEntryNewestOnly.setSelection(false);
                }
                TabRestore.this.setAllCheckedEntries(false);
                Widgets.refreshVirtualTable(TabRestore.this.widgetEntryTable);
                TabRestore.this.updateEntryTableThread.triggerUpdate("", "*", false, true);
            }
        });
        this.updateStorageTreeTableThread.start();
        this.updateEntryTableThread.start();
    }

    public void setTabStatus(TabStatus tabStatus) {
        this.tabStatus = tabStatus;
    }

    void setTabJobs(TabJobs tabJobs) {
        this.tabJobs = tabJobs;
    }

    private void setStorageList(long l, boolean bl) {
        if (l != 0L) {
            try {
                if (bl) {
                    BARServer.executeCommand(StringParser.format("INDEX_STORAGE_LIST_ADD storageIds=%ld", l), 2);
                } else {
                    BARServer.executeCommand(StringParser.format("INDEX_STORAGE_LIST_REMOVE storageIds=%ld", l), 2);
                }
            }
            catch (Exception exception) {
                throw new CommunicationError(exception);
            }
            this.checkedIndexIdSet.set(l, bl);
        }
    }

    private void clearStorageList() {
        try {
            BARServer.executeCommand(StringParser.format("INDEX_STORAGE_LIST_CLEAR", new Object[0]), 2);
        }
        catch (Exception exception) {
            throw new CommunicationError(exception);
        }
        this.checkedIndexIdSet.clear();
    }

    private void setStorageList(IndexIdSet indexIdSet) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            BARServer.executeCommand(StringParser.format("INDEX_STORAGE_LIST_CLEAR", new Object[0]), 2);
        }
        catch (Exception exception) {
            throw new CommunicationError(exception);
        }
        Object[] objectArray = indexIdSet.toArray(new Long[indexIdSet.size()]);
        for (int i = 0; i < objectArray.length; i += n) {
            n = objectArray.length - i;
            if (n > 1024) {
                n = 1024;
            }
            try {
                BARServer.executeCommand(StringParser.format("INDEX_STORAGE_LIST_ADD storageIds=%s", StringUtils.join(objectArray, i, n, ',')), 1);
                continue;
            }
            catch (Exception exception) {
                throw new CommunicationError(exception);
            }
        }
        for (Long l : indexIdSet) {
            this.checkedIndexIdSet.add(l);
        }
    }

    private void setStorageList(HashSet<IndexData> hashSet) {
        this.clearStorageList();
        for (IndexData indexData : hashSet) {
            this.setStorageList(indexData.id, true);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void setAllCheckedStorage(final boolean var1_1) {
        block13: {
            var3_2 = new ValueMap();
            if (this.widgetStorageTabFolder.isDisposed()) break block13;
            switch (this.widgetStorageTabFolder.getSelectionIndex()) {
                case 0: {
                    var4_3 = new IndexIdSet();
                    for (TreeItem var8_14 : this.widgetStorageTree.getItems()) {
                        var9_16 = (UUIDIndexData)var8_14.getData();
                        Widgets.setTreeItemChecked(var8_14, var1_1);
                        this.checkedIndexIdSet.set(var9_16.id, var1_1);
                        if (!var8_14.getExpanded()) continue;
                        for (TreeItem var13_20 : var8_14.getItems()) {
                            var14_21 = (EntityIndexData)var13_20.getData();
                            Widgets.setTreeItemChecked(var13_20, var1_1);
                            this.checkedIndexIdSet.set(var14_21.id, var1_1);
                            if (!var13_20.getExpanded()) continue;
                            for (TreeItem var18_25 : var13_20.getItems()) {
                                var19_26 = (StorageIndexData)var18_25.getData();
                                var4_3.set(var19_26.id, var1_1);
                            }
                        }
                    }
                    this.setStorageList(var4_3);
                    break;
                }
                case 1: {
                    var4_4 = new int[]{0};
                    var5_6 = new boolean[]{false};
                    if (!var1_1) ** GOTO lbl38
                    try {
                        var4_4[0] = BARServer.getInt(StringParser.format("INDEX_STORAGES_LIST_INFO indexStateSet=%s indexModeSet=* name=%'S", new Object[]{UpdateStorageTreeTableThread.access$8800(this.updateStorageTreeTableThread).nameList("|"), UpdateStorageTreeTableThread.access$8900(this.updateStorageTreeTableThread)}), 1, "storageCount");
                        if (var4_4[0] <= 1000) ** GOTO lbl33
                        this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                var5_6[0] = Dialogs.confirm(TabRestore.this.shell, Dialogs.booleanFieldUpdater(Settings.class, "showEntriesMarkInfo"), BARControl.tr("There are {0} entries. Really mark all entries?", var4_4[0]), true);
                            }
                        });
                        ** GOTO lbl39
lbl33:
                        // 1 sources

                        var5_6[0] = true;
                    }
                    catch (Exception var6_8) {
                        BARControl.logThrowable(var6_8);
                    }
                    ** GOTO lbl39
lbl38:
                    // 1 sources

                    var5_6[0] = true;
lbl39:
                    // 4 sources

                    if (var1_1) {
                        if (!var5_6[0]) break;
                        this.clearStorageList();
                        var6_9 = new BusyDialog(this.shell, BARControl.tr("Mark entries", new Object[0]), 500, 100, null, 392);
                        try {
                            var7_11 = new IndexIdSet();
                            var8_15 = new int[]{0};
                            var6_9.setMaximum(var4_4[0]);
                            BARServer.executeCommand(StringParser.format("INDEX_STORAGE_LIST entityId=* indexStateSet=%s indexModeSet=* name=%'S", new Object[]{UpdateStorageTreeTableThread.access$8800(this.updateStorageTreeTableThread).nameList("|"), UpdateStorageTreeTableThread.access$8900(this.updateStorageTreeTableThread)}), 2, new Command.ResultHandler(){

                                @Override
                                public void handle(int n, ValueMap valueMap) {
                                    long l = valueMap.getLong("storageId");
                                    var7_11.set(l, var1_1);
                                    var8_15[0] = var8_15[0] + 1;
                                    var6_9.updateProgressBar(var8_15[0]);
                                    if (var6_9.isAborted()) {
                                        this.abort();
                                    }
                                }
                            });
                            this.setStorageList(var7_11);
                            var6_9.close();
                        }
                        catch (BARException var7_12) {
                            var6_9.close();
                            if (var7_12.code == 6) break;
                            Dialogs.error(this.shell, BARControl.tr("Cannot mark all storages!\n\n(error: {0})", new Object[]{var7_12.getMessage()}));
                        }
                        catch (Exception var7_13) {
                            var6_9.close();
                            Dialogs.error(this.shell, BARControl.tr("Cannot mark all storages!\n\n(error: {0})", new Object[]{var7_13.getMessage()}));
                            BARControl.logThrowable(var7_13);
                        }
                        break;
                    }
                    this.clearStorageList();
                }
            }
            UpdateStorageTreeTableThread.access$3600(this.updateStorageTreeTableThread);
        }
    }

    private HashSet<IndexData> getSelectedIndexData() {
        HashSet<IndexData> hashSet = new HashSet<IndexData>();
        switch (this.widgetStorageTabFolder.getSelectionIndex()) {
            case 0: {
                IndexData indexData;
                for (TreeItem treeItem : Widgets.getAllTreeItems(this.widgetStorageTree)) {
                    if (!treeItem.getChecked() || (indexData = (IndexData)treeItem.getData()) == null) continue;
                    hashSet.add(indexData);
                }
                if (!hashSet.isEmpty()) break;
                for (TreeItem treeItem : this.widgetStorageTree.getSelection()) {
                    indexData = (IndexData)treeItem.getData();
                    if (indexData == null) continue;
                    hashSet.add(indexData);
                }
                break;
            }
            case 1: {
                IndexData indexData;
                for (TableItem tableItem : this.widgetStorageTable.getItems()) {
                    if (!tableItem.getChecked() || (indexData = (IndexData)tableItem.getData()) == null || tableItem.getGrayed()) continue;
                    hashSet.add(indexData);
                }
                if (!hashSet.isEmpty()) break;
                for (TableItem tableItem : this.widgetStorageTable.getSelection()) {
                    indexData = (IndexData)tableItem.getData();
                    if (indexData == null || tableItem.getGrayed()) continue;
                    hashSet.add(indexData);
                }
                break;
            }
        }
        return hashSet;
    }

    private void clearSelectedIndexData() {
        this.widgetStorageTree.deselectAll();
        this.widgetStorageTable.deselectAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAssignTo() {
        block5: {
            try {
                final ArrayList<UUIDIndexData> arrayList = new ArrayList<UUIDIndexData>();
                BARServer.executeCommand(StringParser.format("INDEX_UUID_LIST indexStateSet=* indexModeSet=*", new Object[0]), 2, new Command.ResultHandler(){

                    @Override
                    public void handle(int n, ValueMap valueMap) {
                        long l = valueMap.getLong("uuidId");
                        String string = valueMap.getString("jobUUID");
                        String string2 = valueMap.getString("name");
                        long l2 = valueMap.getLong("lastExecutedDateTime");
                        int n2 = valueMap.getInt("lastErrorCode");
                        String string3 = valueMap.getString("lastErrorData");
                        long l3 = valueMap.getLong("totalSize");
                        long l4 = valueMap.getLong("totalEntryCount");
                        long l5 = valueMap.getLong("totalEntrySize", Long.MAX_VALUE);
                        IndexStates indexStates = valueMap.getEnum("maxIndexState", IndexStates.class);
                        IndexModes indexModes = valueMap.getEnum("maxIndexMode", IndexModes.class);
                        arrayList.add(new UUIDIndexData(l, string, string2, l2, n2, string3, l3, l4, l5, indexStates, indexModes));
                    }
                });
                final HashMap<String, List<EntityIndexData>> hashMap = new HashMap<String, List<EntityIndexData>>();
                BARServer.executeCommand(StringParser.format("INDEX_ENTITY_LIST indexStateSet=* indexModeSet=*", new Object[0]), 2, new Command.ResultHandler(){

                    @Override
                    public void handle(int n, ValueMap valueMap) {
                        long l = valueMap.getLong("entityId");
                        String string = valueMap.getString("jobUUID");
                        String string2 = valueMap.getString("scheduleUUID");
                        ArchiveTypes archiveTypes = valueMap.getEnum("archiveType", ArchiveTypes.class);
                        long l2 = valueMap.getLong("createdDateTime");
                        int n2 = valueMap.getInt("lastErrorCode");
                        String string3 = valueMap.getString("lastErrorData");
                        long l3 = valueMap.getLong("totalSize");
                        long l4 = valueMap.getLong("totalEntryCount");
                        long l5 = valueMap.getLong("totalEntrySize", Long.MAX_VALUE);
                        IndexStates indexStates = valueMap.getEnum("maxIndexState", IndexStates.class);
                        IndexModes indexModes = valueMap.getEnum("maxIndexMode", IndexModes.class);
                        long l6 = valueMap.getLong("expireDateTime");
                        ArrayList<EntityIndexData> arrayList = (ArrayList<EntityIndexData>)hashMap.get(string);
                        if (arrayList == null) {
                            arrayList = new ArrayList<EntityIndexData>();
                            hashMap.put(string, arrayList);
                        }
                        arrayList.add(new EntityIndexData(l, string, string2, archiveTypes, l2, n2, string3, l3, l4, l5, indexStates, indexModes, l6));
                    }
                });
                Object object = this.assignToLock;
                synchronized (object) {
                    this.assignToUUIDIndexDataList = arrayList;
                    this.assignToEntityIndexDataMap = hashMap;
                }
            }
            catch (Throwable throwable) {
                if (Settings.debugLevel <= 0) break block5;
                BARServer.disconnect();
                BARControl.internalError(throwable);
            }
        }
    }

    private synchronized void updateAssignToMenu(Menu menu, List<UUIDIndexData> list, Map<String, List<EntityIndexData>> map) {
        for (MenuItem menuItem : menu.getItems()) {
            menuItem.dispose();
        }
        if (list != null) {
            Collections.sort(this.assignToUUIDIndexDataList, new Comparator<UUIDIndexData>(){

                @Override
                public int compare(UUIDIndexData uUIDIndexData, UUIDIndexData uUIDIndexData2) {
                    return uUIDIndexData.name.compareTo(uUIDIndexData2.name);
                }
            });
            for (UUIDIndexData uUIDIndexData : list) {
                Menu menu2 = Widgets.insertMenu(menu, this.findStorageMenuIndex(menu, uUIDIndexData), uUIDIndexData, uUIDIndexData.name.replaceAll("&", "&&"));
                uUIDIndexData.setSubMenu(menu2);
                this.updateAssignToMenu(menu2, uUIDIndexData.jobUUID, map.get(uUIDIndexData.jobUUID));
            }
        }
    }

    private void updateAssignToMenu(Menu menu, String string, List<EntityIndexData> list) {
        for (MenuItem menuItem : menu.getItems()) {
            menuItem.dispose();
        }
        Menu menu2 = Widgets.addMenu(menu, null, BARControl.tr("normal", new Object[0]));
        this.updateAssignToMenu(menu2, string, ArchiveTypes.NORMAL, list);
        Menu menu3 = Widgets.addMenu(menu, null, BARControl.tr("full", new Object[0]));
        this.updateAssignToMenu(menu3, string, ArchiveTypes.FULL, list);
        Menu menu4 = Widgets.addMenu(menu, null, BARControl.tr("incremental", new Object[0]));
        this.updateAssignToMenu(menu4, string, ArchiveTypes.INCREMENTAL, list);
        Menu menu5 = Widgets.addMenu(menu, null, BARControl.tr("differential", new Object[0]));
        this.updateAssignToMenu(menu5, string, ArchiveTypes.DIFFERENTIAL, list);
        Menu menu6 = Widgets.addMenu(menu, null, BARControl.tr("continuous", new Object[0]));
        this.updateAssignToMenu(menu6, string, ArchiveTypes.CONTINUOUS, list);
    }

    private void updateAssignToMenu(Menu menu, final String string, final ArchiveTypes archiveTypes, List<EntityIndexData> list) {
        MenuItem menuItem = Widgets.addMenuItem(menu, null, BARControl.tr("new", new Object[0]) + "\u2026");
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabRestore.this.assignStorages(string, archiveTypes);
            }
        });
        Widgets.addMenuItemSeparator(menu);
        if (list != null) {
            Collections.sort(list, new Comparator<EntityIndexData>(){

                @Override
                public int compare(EntityIndexData entityIndexData, EntityIndexData entityIndexData2) {
                    if (entityIndexData.createdDateTime < entityIndexData2.createdDateTime) {
                        return -1;
                    }
                    if (entityIndexData.createdDateTime > entityIndexData2.createdDateTime) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (EntityIndexData entityIndexData : list) {
                if (entityIndexData.archiveType != archiveTypes) continue;
                menuItem = Widgets.addMenuItem(menu, entityIndexData, entityIndexData.createdDateTime > 0L ? this.SIMPLE_DATE_FORMAT.format(new Date(entityIndexData.createdDateTime * 1000L)) : "-");
                menuItem.addSelectionListener(new SelectionListener(){

                    @Override
                    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    }

                    @Override
                    public void widgetSelected(SelectionEvent selectionEvent) {
                        MenuItem menuItem = (MenuItem)selectionEvent.widget;
                        EntityIndexData entityIndexData = (EntityIndexData)menuItem.getData();
                        Widgets.removeAllMenuItems(TabRestore.this.widgetStorageAssignToMenu);
                        TabRestore.this.assignStorages(entityIndexData);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean assignStorages(HashSet<IndexData> hashSet, String string, String string2, ArchiveTypes archiveTypes) {
        SimpleDateFormat[] simpleDateFormatArray = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd")};
        if (!hashSet.isEmpty()) {
            block25: {
                Long l = 0L;
                if (archiveTypes != ArchiveTypes.UNKNOWN) {
                    for (IndexData indexData : hashSet) {
                        String[] stringArray;
                        for (String string3 : stringArray = StringUtils.splitArray(indexData.getName(), BARServer.filePathSeparator)) {
                            for (SimpleDateFormat simpleDateFormat : simpleDateFormatArray) {
                                try {
                                    Date date = simpleDateFormat.parse(string3);
                                    if (date != null) {
                                        l = date.getTime() / 1000L;
                                    }
                                }
                                catch (ParseException parseException) {
                                    // empty catch block
                                }
                                if (l != 0L) break;
                            }
                            if (l != 0L) break;
                        }
                        if (l == 0L) continue;
                        break;
                    }
                    if ((l = Dialogs.date(this.shell, BARControl.tr("Assign entity date", new Object[0]), null, l, BARControl.tr("Assign", new Object[0]))) == null) {
                        return false;
                    }
                }
                BARControl.waitCursor();
                BusyDialog busyDialog = new BusyDialog(this.shell, BARControl.tr("Assign storages", new Object[0]), 500, 100, null, 0x1000188);
                busyDialog.setMaximum(1 + hashSet.size());
                try {
                    int n = 0;
                    long l2 = 0L;
                    try {
                        ValueMap valueMap = new ValueMap();
                        BARServer.executeCommand(StringParser.format("INDEX_ENTITY_ADD jobUUID=%'S scheduleUUID=%'S archiveType=%s createdDateTime=%ld", string, string2 != null ? string2 : "", archiveTypes.toString(), (long)l), 0, valueMap);
                        l2 = valueMap.getLong("entityId", 0L);
                        busyDialog.updateProgressBar(++n);
                    }
                    catch (Exception exception) {
                        Dialogs.error(this.shell, BARControl.tr("Cannot create entity for\n\n''{0}''!\n\n(error: {1})", string, exception.getMessage()));
                        BARControl.logThrowable(exception);
                        int n2 = 0;
                        busyDialog.close();
                        BARControl.resetCursor();
                        return n2 != 0;
                    }
                    if (busyDialog.isAborted()) break block25;
                    for (IndexData indexData : hashSet) {
                        String string3;
                        string3 = indexData.getInfo();
                        try {
                            ValueMap valueMap = new ValueMap();
                            if (indexData instanceof UUIDIndexData) {
                                BARServer.executeCommand(StringParser.format("INDEX_ASSIGN toEntityId=%lld archiveType=%s jobUUID=%'S", l2, archiveTypes.toString(), ((UUIDIndexData)indexData).jobUUID), 0);
                            } else if (indexData instanceof EntityIndexData) {
                                BARServer.executeCommand(StringParser.format("INDEX_ASSIGN toEntityId=%lld archiveType=%s entityId=%lld", l2, archiveTypes.toString(), indexData.id), 0);
                            } else if (indexData instanceof StorageIndexData) {
                                BARServer.executeCommand(StringParser.format("INDEX_ASSIGN toEntityId=%lld archiveType=%s storageId=%lld", l2, archiveTypes.toString(), indexData.id), 0);
                            }
                        }
                        catch (Exception exception) {
                            Dialogs.error(this.shell, BARControl.tr("Cannot assign index for\n\n{0}!\n\n(error: {1})", string3, exception.getMessage()));
                            BARControl.logThrowable(exception);
                            int n2 = 0;
                            busyDialog.close();
                            BARControl.resetCursor();
                            return n2 != 0;
                        }
                        if (busyDialog.isAborted()) {
                            break;
                        }
                        busyDialog.updateProgressBar(++n);
                    }
                }
                finally {
                    busyDialog.close();
                    BARControl.resetCursor();
                }
            }
            this.updateStorageTreeTableThread.triggerUpdate();
            this.updateAssignTo();
        }
        return true;
    }

    private void assignStorages(IndexData indexData, String string, String string2, ArchiveTypes archiveTypes) {
        HashSet<IndexData> hashSet = new HashSet<IndexData>();
        hashSet.add(indexData);
        this.assignStorages(hashSet, string, string2, archiveTypes);
    }

    private void assignStorages(String string, String string2, ArchiveTypes archiveTypes) {
        HashSet<IndexData> hashSet = this.getSelectedIndexData();
        if (this.assignStorages(hashSet, string, string2, archiveTypes)) {
            this.clearSelectedIndexData();
        }
    }

    private void assignStorages(String string, ArchiveTypes archiveTypes) {
        this.assignStorages(string, null, archiveTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignStorages(HashSet<IndexData> hashSet, UUIDIndexData uUIDIndexData) {
        if (!hashSet.isEmpty()) {
            BARControl.waitCursor();
            BusyDialog busyDialog = new BusyDialog(this.shell, BARControl.tr("Assign storages", new Object[0]), 500, 100, null, 0x1000188);
            busyDialog.setMaximum(hashSet.size());
            try {
                int n = 0;
                for (IndexData indexData : hashSet) {
                    String string = indexData.getInfo();
                    try {
                        if (indexData instanceof UUIDIndexData) {
                            BARServer.executeCommand(StringParser.format("INDEX_ASSIGN toJobUUID=%'S jobUUID=%'S", uUIDIndexData.jobUUID, ((UUIDIndexData)indexData).jobUUID), 0);
                        } else if (indexData instanceof EntityIndexData) {
                            BARServer.executeCommand(StringParser.format("INDEX_ASSIGN toJobUUID=%'S entityId=%lld", uUIDIndexData.jobUUID, indexData.id), 0);
                        } else if (indexData instanceof StorageIndexData) {
                            // empty if block
                        }
                        indexData.setState(IndexStates.UPDATE_REQUESTED);
                    }
                    catch (Exception exception) {
                        Dialogs.error(this.shell, BARControl.tr("Cannot assign index for\n\n{0}!\n\n(error: {1})", string, exception.getMessage()));
                        BARControl.logThrowable(exception);
                        break;
                    }
                    if (busyDialog.isAborted()) {
                        break;
                    }
                    busyDialog.updateProgressBar(++n);
                }
            }
            catch (CommunicationError communicationError) {
                Dialogs.error(this.shell, BARControl.tr("Communication error while assigning index database\n\n(error: {0})", communicationError.toString()));
            }
            finally {
                busyDialog.close();
                BARControl.resetCursor();
            }
            this.updateStorageTreeTableThread.triggerUpdate();
            this.updateAssignTo();
        }
    }

    private void assignStorages(IndexData indexData, UUIDIndexData uUIDIndexData) {
        HashSet<IndexData> hashSet = new HashSet<IndexData>();
        hashSet.add(indexData);
        this.assignStorages(hashSet, uUIDIndexData);
    }

    private void assignStorages(UUIDIndexData uUIDIndexData) {
        HashSet<IndexData> hashSet = this.getSelectedIndexData();
        this.assignStorages(hashSet, uUIDIndexData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignStorages(HashSet<IndexData> hashSet, EntityIndexData entityIndexData) {
        if (!hashSet.isEmpty()) {
            BARControl.waitCursor();
            BusyDialog busyDialog = new BusyDialog(this.shell, BARControl.tr("Assign storages", new Object[0]), 500, 100, null, 0x1000188);
            busyDialog.setMaximum(hashSet.size());
            try {
                int n = 0;
                for (IndexData indexData : hashSet) {
                    String string = indexData.getInfo();
                    try {
                        if (indexData instanceof UUIDIndexData) {
                            BARServer.executeCommand(StringParser.format("INDEX_ASSIGN toEntityId=%lld jobUUID=%'S", entityIndexData.id, ((UUIDIndexData)indexData).jobUUID), 0);
                        } else if (indexData instanceof EntityIndexData) {
                            BARServer.executeCommand(StringParser.format("INDEX_ASSIGN toEntityId=%lld entityId=%lld", entityIndexData.id, indexData.id), 0);
                        } else if (indexData instanceof StorageIndexData) {
                            BARServer.executeCommand(StringParser.format("INDEX_ASSIGN toEntityId=%lld storageId=%lld", entityIndexData.id, indexData.id), 0);
                        }
                        indexData.setState(IndexStates.UPDATE_REQUESTED);
                    }
                    catch (Exception exception) {
                        Dialogs.error(this.shell, BARControl.tr("Cannot assign index for\n\n{0}!\n\n(error: {1})", string, exception.getMessage()));
                        BARControl.logThrowable(exception);
                        break;
                    }
                    if (busyDialog.isAborted()) {
                        break;
                    }
                    busyDialog.updateProgressBar(++n);
                }
            }
            catch (CommunicationError communicationError) {
                Dialogs.error(this.shell, BARControl.tr("Communication error while assigning index database\n\n(error: {0})", communicationError.toString()));
            }
            finally {
                busyDialog.close();
                BARControl.resetCursor();
            }
            this.updateEntryTableThread.triggerUpdate();
        }
    }

    private void assignStorages(IndexData indexData, EntityIndexData entityIndexData) {
        HashSet<IndexData> hashSet = new HashSet<IndexData>();
        hashSet.add(indexData);
        this.assignStorages(hashSet, entityIndexData);
    }

    private void assignStorages(EntityIndexData entityIndexData) {
        HashSet<IndexData> hashSet = this.getSelectedIndexData();
        this.assignStorages(hashSet, entityIndexData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEntityType(HashSet<IndexData> hashSet, ArchiveTypes archiveTypes) {
        if (!hashSet.isEmpty()) {
            BARControl.waitCursor();
            BusyDialog busyDialog = new BusyDialog(this.shell, BARControl.tr("Set archive type", new Object[0]), 500, 100, null, 0x1000188);
            busyDialog.setMaximum(hashSet.size());
            try {
                int n = 0;
                for (IndexData indexData : hashSet) {
                    String string = indexData.getInfo();
                    try {
                        IndexData indexData2;
                        if (indexData instanceof UUIDIndexData) {
                            indexData2 = (UUIDIndexData)indexData;
                            BARServer.executeCommand(StringParser.format("INDEX_ASSIGN toJobUUID=%'S archiveType=%s jobUUID=%'S", indexData2.jobUUID, archiveTypes.toString(), indexData2.jobUUID), 0);
                        } else if (indexData instanceof EntityIndexData) {
                            indexData2 = (EntityIndexData)indexData;
                            BARServer.executeCommand(StringParser.format("INDEX_ASSIGN toEntityId=%lld archiveType=%s entityId=%lld", ((EntityIndexData)indexData2).id, archiveTypes.toString(), ((EntityIndexData)indexData2).id), 0);
                        } else if (indexData instanceof StorageIndexData) {
                            // empty if block
                        }
                        indexData.setState(IndexStates.UPDATE_REQUESTED);
                    }
                    catch (Exception exception) {
                        Dialogs.error(this.shell, BARControl.tr("Cannot set entity type for\n\n{0}!\n\n(error: {1})", string, exception.getMessage()));
                        BARControl.logThrowable(exception);
                        break;
                    }
                    if (busyDialog.isAborted()) {
                        break;
                    }
                    busyDialog.updateProgressBar(++n);
                }
            }
            catch (CommunicationError communicationError) {
                Dialogs.error(this.shell, BARControl.tr("Communication error while set entity type in index database\n\n(error: {0})", communicationError.toString()));
            }
            finally {
                busyDialog.close();
                BARControl.resetCursor();
            }
            this.updateStorageTreeTableThread.triggerUpdate();
            this.updateAssignTo();
        }
    }

    private void setEntityType(EntityIndexData entityIndexData, ArchiveTypes archiveTypes) {
        HashSet<IndexData> hashSet = new HashSet<IndexData>();
        hashSet.add(entityIndexData);
        this.setEntityType(hashSet, archiveTypes);
    }

    private void setEntityType(ArchiveTypes archiveTypes) {
        HashSet<IndexData> hashSet = this.getSelectedIndexData();
        this.setEntityType(hashSet, archiveTypes);
    }

    private void testStorages() {
        HashSet<IndexData> hashSet = this.getSelectedIndexData();
        if (!hashSet.isEmpty()) {
            BusyDialog busyDialog = new BusyDialog(this.shell, BARControl.tr("Test archives", new Object[0]), 500, 300, null, 16777726, 250);
            busyDialog.updateText(3, "%s", BARControl.tr("Failed", new Object[0]) + ":");
            busyDialog.setMaximum(0, hashSet.size());
            Background.run(new BackgroundRunnable(new Object[]{busyDialog, hashSet}){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(final BusyDialog busyDialog, HashSet<IndexData> hashSet) {
                    TabRestore.this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            BARControl.waitCursor();
                        }
                    });
                    try {
                        for (IndexData indexData : hashSet) {
                            String string = indexData.getInfo();
                            String string2 = null;
                            if (indexData instanceof UUIDIndexData) {
                                string2 = StringParser.format("STORAGE_TEST jobUUID=%'S", ((UUIDIndexData)indexData).jobUUID);
                            } else if (indexData instanceof EntityIndexData) {
                                string2 = StringParser.format("STORAGE_TEST entityId=%lld", indexData.id);
                            } else if (indexData instanceof StorageIndexData) {
                                string2 = StringParser.format("STORAGE_TEST storageId=%lld", indexData.id);
                            }
                            try {
                                BARServer.executeCommand(string2, 2, new Command.ResultHandler(){

                                    @Override
                                    public void handle(int n, ValueMap valueMap) {
                                        long l = valueMap.getLong("doneCount");
                                        long l2 = valueMap.getLong("totalCount");
                                        long l3 = valueMap.getLong("storageDoneSize");
                                        long l4 = valueMap.getLong("storageTotalSize");
                                        long l5 = valueMap.getLong("entryDoneSize");
                                        long l6 = valueMap.getLong("entryTotalSize");
                                        busyDialog.updateProgressBar(0, l2 > 0L ? (double)l / (double)l2 : 100.0);
                                        busyDialog.updateText(1, "%s", valueMap.getString("storageName"));
                                        busyDialog.updateProgressBar(1, l4 > 0L ? (double)l3 / (double)l4 : 100.0);
                                        busyDialog.updateText(2, "%s", valueMap.getString("entryName"));
                                        busyDialog.updateProgressBar(2, l6 > 0L ? (double)l6 / (double)l6 : 100.0);
                                        if (busyDialog.isAborted()) {
                                            busyDialog.updateText(1, "%s", BARControl.tr("Aborting", new Object[0]) + "\u2026");
                                            busyDialog.updateText(2, "%s", BARControl.tr("Aborting", new Object[0]) + "\u2026");
                                            this.abort();
                                        }
                                    }
                                });
                            }
                            catch (Exception exception) {
                                busyDialog.updateList(string + ": " + exception.getMessage());
                            }
                        }
                        busyDialog.done();
                        TabRestore.this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                BARControl.resetCursor();
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        TabRestore.this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshStorageIndex() {
        block22: {
            try {
                HashSet<IndexData> hashSet = this.getSelectedIndexData();
                if (hashSet.isEmpty()) break block22;
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                for (IndexData indexData : hashSet) {
                    if (indexData instanceof UUIDIndexData) {
                        ++n;
                        continue;
                    }
                    if (indexData instanceof EntityIndexData) {
                        ++n2;
                        continue;
                    }
                    if (!(indexData instanceof StorageIndexData)) continue;
                    ++n3;
                }
                if (!Dialogs.confirm(this.shell, BARControl.tr("Refresh index for {0} {0,choice,0#jobs|1#job|1<jobs}/{1} {1,choice,0#entities|1#entity|1<entities}/{2} {2,choice,0#archives|1#archive|1<archives}?", n, n2, n3))) break block22;
                BARControl.waitCursor();
                try {
                    for (IndexData indexData : hashSet) {
                        String string = indexData.getInfo();
                        try {
                            if (indexData instanceof UUIDIndexData) {
                                BARServer.executeCommand(StringParser.format("INDEX_REFRESH state=* jobUUID=%'S", ((UUIDIndexData)indexData).jobUUID), 0);
                            } else if (indexData instanceof EntityIndexData) {
                                BARServer.executeCommand(StringParser.format("INDEX_REFRESH state=* entityId=%lld", indexData.id), 0);
                            } else if (indexData instanceof StorageIndexData) {
                                BARServer.executeCommand(StringParser.format("INDEX_REFRESH state=* storageId=%lld", indexData.id), 0);
                            }
                            indexData.setState(IndexStates.UPDATE_REQUESTED);
                        }
                        catch (Exception exception) {
                            Dialogs.error(this.shell, BARControl.tr("Cannot refresh index for\n\n{0}!\n\n(error: {1})", string, exception.getMessage()));
                            BARControl.logThrowable(exception);
                        }
                    }
                }
                finally {
                    BARControl.resetCursor();
                }
                if (this.widgetStorageTabFolder.isDisposed()) break block22;
                switch (this.widgetStorageTabFolder.getSelectionIndex()) {
                    case 0: {
                        for (Item item : this.widgetStorageTree.getSelection()) {
                            this.updateStorageTreeTableThread.triggerUpdate((TreeItem)item);
                        }
                        break;
                    }
                    case 1: {
                        for (Item item : this.widgetStorageTable.getSelection()) {
                            this.updateStorageTreeTableThread.triggerUpdate((TableItem)item);
                        }
                        break;
                    }
                }
            }
            catch (CommunicationError communicationError) {
                Dialogs.error(this.shell, BARControl.tr("Communication error while refreshing index database\n\n(error: {0})", communicationError.toString()));
            }
        }
    }

    private void refreshAllWithErrorStorageIndex() {
        block7: {
            try {
                if (!Dialogs.confirm(this.shell, BARControl.tr("Refresh all indices with error state?", new Object[0]))) break block7;
                BARControl.waitCursor();
                try {
                    BARServer.executeCommand(StringParser.format("INDEX_REFRESH state=%s storageId=%lld", "ERROR", 0), 0);
                }
                catch (Exception exception) {
                    Dialogs.error(this.shell, BARControl.tr("Cannot refresh database indices with error state!\n\n(error: {0})", exception.getMessage()));
                    BARControl.logThrowable(exception);
                }
                finally {
                    BARControl.resetCursor();
                }
            }
            catch (CommunicationError communicationError) {
                Dialogs.error(this.shell, BARControl.tr("Communication error while refreshing database indices\n\n(error: {0})", communicationError.toString()));
            }
        }
        this.updateStorageTreeTableThread.triggerUpdate();
    }

    private void moveEntityTo() {
        block6: {
            try {
                TreeItem treeItem;
                TreeItem[] treeItemArray = this.widgetStorageTree.getSelection();
                if (treeItemArray.length <= 0 || (treeItem = treeItemArray[0]).isDisposed() || !(treeItem.getData() instanceof EntityIndexData)) break block6;
                EntityIndexData entityIndexData = (EntityIndexData)treeItem.getData();
                String string = Dialogs.file(this.shell, Dialogs.FileDialogTypes.DIRECTORY, BARControl.tr("Select move-to path", new Object[0]), "", new String[]{BARControl.tr("All files", new Object[0]), BARControl.ALL_FILE_EXTENSION}, "*", 0, BARServer.remoteListDirectory(entityIndexData.jobUUID));
                if (string == null) break block6;
                final BusyDialog busyDialog = new BusyDialog(this.shell, BARControl.tr("Move storages", new Object[0]), 500, 100, null, 0x1000199);
                try {
                    BARServer.executeCommand(StringParser.format("ENTITY_MOVE_TO entityId=%lld moveTo=%s", entityIndexData.id, string), 0, new Command.ResultHandler(){

                        @Override
                        public void handle(int n, ValueMap valueMap) {
                            long l = valueMap.getLong("storageId");
                            String string = valueMap.getString("name");
                            long l2 = valueMap.getLong("n");
                            long l3 = valueMap.getLong("size");
                            long l4 = valueMap.getLong("doneSize");
                            long l5 = valueMap.getLong("totalSize");
                            busyDialog.updateText(0, string, new Object[0]);
                            busyDialog.updateProgressBar(0, l2);
                            busyDialog.updateProgressBar(1, l4);
                            busyDialog.setMaximum(0, l3);
                            busyDialog.setMaximum(1, l5);
                            if (busyDialog.isAborted()) {
                                this.abort();
                            }
                        }
                    });
                    busyDialog.close();
                }
                catch (BARException bARException) {
                    busyDialog.close();
                    if (bARException.code != 6) {
                        Dialogs.error(this.shell, BARControl.tr("Cannot move entity!\n\n(error: {0})", bARException.getMessage()));
                    }
                }
                catch (Exception exception) {
                    Dialogs.error(this.shell, BARControl.tr("Cannot move entity!\n\n(error: {0})", exception.getMessage()));
                    BARControl.logThrowable(exception);
                }
            }
            catch (CommunicationError communicationError) {
                Dialogs.error(this.shell, BARControl.tr("Communication error while moving entity\n\n(error: {0})", communicationError.toString()));
            }
        }
        this.updateStorageTreeTableThread.triggerUpdate();
    }

    private void addStoragesToIndex() {
        class Data {
            StorageTypes storageType = StorageTypes.FILESYSTEM;
            String hostName = "";
            int hostPort = 0;
            String loginName = "";
            String loginPassword = "";
            String shareName = "";
            String deviceName = "";
            String archiveName = "";

            Data() {
            }
        }
        final Data data = new Data();
        final Shell shell = Dialogs.openModal(this.shell, BARControl.tr("Add storage to index database", new Object[0]), 400, -1, new double[]{1.0, 0.0}, 1.0);
        Composite composite = Widgets.newComposite(shell);
        composite.setLayout(new TableLayout(new double[]{0.0, 0.0, 1.0}, new double[]{0.0, 1.0}));
        Widgets.layout((Control)composite, 0, 0, 12, 0, 0, 2);
        Label label = Widgets.newLabel(composite, BARControl.tr("Archive name", new Object[0]) + ":");
        Widgets.layout(label, 0, 0, 4);
        final Text text = Widgets.newText(composite);
        text.setToolTipText(BARControl.tr("Enter local or remote storage path.", new Object[0]));
        Widgets.layout(text, 0, 1, 12, 0, 0, 0, 0, 300, -1);
        Button button = Widgets.newButton(composite, this.IMAGE_DIRECTORY);
        button.setToolTipText(BARControl.tr("Select local storage file.", new Object[0]));
        Widgets.layout(button, 0, 2, 0);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                String string = Dialogs.file(TabRestore.this.shell, Dialogs.FileDialogTypes.ENTRY, BARControl.tr("Select storage", new Object[0]), text.getText(), (selectionEvent.stateMask & 0x40000) == 0 ? BARServer.remoteListDirectory(text.getText()) : BARControl.listDirectory);
                if (string != null && !text.isDisposed()) {
                    text.setText(string);
                }
            }
        });
        label = Widgets.newLabel(composite, BARControl.tr("Source", new Object[0]) + ":");
        Widgets.layout(label, 1, 0, 5);
        final Combo combo = Widgets.newOptionMenu(composite);
        combo.setToolTipText(BARControl.tr("Storage type:\n  into file system\n  on FTP server\n  on SSH server with sftp (secure FTP)\n  on WebDAV server\n  on WebDAV secure server\n  on CD\n  on DVD\n  on BD\n  on generic device\n", new Object[0]));
        Widgets.setComboItems(combo, new Object[]{BARControl.tr("file system", new Object[0]), StorageTypes.FILESYSTEM, "ftp", StorageTypes.FTP, "sftp", StorageTypes.SFTP, "webdav", StorageTypes.WEBDAV, "webdavs", StorageTypes.WEBDAVS, "CD", StorageTypes.CD, "DVD", StorageTypes.DVD, "BD", StorageTypes.BD, BARControl.tr("device", new Object[0]), StorageTypes.DEVICE});
        Widgets.setSelectedComboItem(combo, 0);
        Widgets.layout(combo, 1, 1, 4, 0, 2);
        final BARWidgets.File file = new BARWidgets.File(composite);
        Widgets.layout(file, 2, 1, 13, 0, 3);
        Widgets.setVisible(file, true);
        final BARWidgets.FTP fTP = new BARWidgets.FTP(composite);
        Widgets.layout(fTP, 2, 1, 13, 0, 3);
        Widgets.setVisible(fTP, false);
        final BARWidgets.SFTP sFTP = new BARWidgets.SFTP(composite);
        Widgets.layout(sFTP, 2, 1, 13, 0, 3);
        Widgets.setVisible(sFTP, false);
        final BARWidgets.WebDAV webDAV = new BARWidgets.WebDAV(composite);
        Widgets.layout(webDAV, 2, 1, 13, 0, 3);
        Widgets.setVisible(webDAV, false);
        final BARWidgets.Optical optical = new BARWidgets.Optical(composite);
        Widgets.layout(optical, 2, 1, 13, 0, 3);
        Widgets.setVisible(optical, false);
        final BARWidgets.Device device = new BARWidgets.Device(composite);
        Widgets.layout(device, 2, 1, 13, 0, 3);
        Widgets.setVisible(device, false);
        composite = Widgets.newComposite(shell);
        composite.setLayout(new TableLayout(0.0, 1.0));
        Widgets.layout((Control)composite, 2, 0, 12, 0, 0, 2);
        final Button button2 = Widgets.newButton(composite, BARControl.tr("Add", new Object[0]));
        button2.setEnabled(false);
        Widgets.layout(button2, 0, 0, 4, 0, 0, 0, 0, 100, -1);
        button = Widgets.newButton(composite, BARControl.tr("Cancel", new Object[0]));
        Widgets.layout(button, 0, 1, 8, 0, 0, 0, 0, 100, -1);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                Dialogs.close(shell, false);
            }
        });
        text.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                Text text = (Text)modifyEvent.widget;
                String string = text.getText().trim();
                button2.setEnabled(!string.isEmpty());
            }
        });
        combo.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Combo combo = (Combo)selectionEvent.widget;
                StorageTypes storageTypes = (StorageTypes)((Object)Widgets.getSelectedComboItem(combo));
                Widgets.setVisible(file, storageTypes == StorageTypes.FILESYSTEM);
                Widgets.setVisible(fTP, storageTypes == StorageTypes.FTP);
                Widgets.setVisible(sFTP, storageTypes == StorageTypes.SFTP);
                Widgets.setVisible(webDAV, storageTypes == StorageTypes.WEBDAV || storageTypes == StorageTypes.WEBDAVS);
                Widgets.setVisible(optical, storageTypes == StorageTypes.CD || storageTypes == StorageTypes.DVD || storageTypes == StorageTypes.BD);
                Widgets.setVisible(device, storageTypes == StorageTypes.DEVICE);
                shell.pack();
            }
        });
        button2.addSelectionListener(new SelectionListener(){
            {
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                data.storageType = (StorageTypes)((Object)Widgets.getSelectedComboItem(combo));
                switch (data.storageType) {
                    case FILESYSTEM: {
                        data.archiveName = text.getText().trim();
                        break;
                    }
                    case FTP: {
                        data.hostName = fTP.hostName.getText().trim();
                        data.loginName = fTP.loginName.getText();
                        data.loginPassword = fTP.loginPassword.getText();
                        data.archiveName = text.getText().trim();
                        break;
                    }
                    case SFTP: {
                        data.hostName = sFTP.hostName.getText().trim();
                        data.hostPort = sFTP.hostPort.getSelection();
                        data.loginName = sFTP.loginName.getText();
                        data.loginPassword = sFTP.loginPassword.getText();
                        data.archiveName = text.getText().trim();
                        break;
                    }
                    case WEBDAV: 
                    case WEBDAVS: {
                        data.hostName = webDAV.hostName.getText().trim();
                        data.hostPort = webDAV.hostPort.getSelection();
                        data.loginName = webDAV.loginName.getText();
                        data.loginPassword = webDAV.loginPassword.getText();
                        data.archiveName = text.getText().trim();
                        break;
                    }
                    case CD: 
                    case DVD: 
                    case BD: {
                        data.deviceName = optical.deviceName.getText().trim();
                        data.archiveName = text.getText().trim();
                        break;
                    }
                    case DEVICE: {
                        data.deviceName = device.deviceName.getText().trim();
                        data.archiveName = text.getText().trim();
                    }
                }
                Dialogs.close(shell, true);
            }
        });
        Widgets.setNextFocus(text, combo, button2);
        text.forceFocus();
        shell.pack();
        if (((Boolean)Dialogs.run(shell, null)).booleanValue() && !data.archiveName.isEmpty()) {
            BusyDialog busyDialog = new BusyDialog(this.shell, BARControl.tr("Add indices", new Object[0]), 500, 200, null, 16777673);
            URIParts uRIParts = new URIParts(data.storageType, data.hostName, data.hostPort, data.loginName, data.loginPassword, data.shareName, data.deviceName, data.archiveName);
            Background.run(new BackgroundRunnable(new Object[]{busyDialog, uRIParts}){
                {
                    super(objectArray);
                }

                public void run(final BusyDialog busyDialog, URIParts uRIParts) {
                    block2: {
                        final int[] nArray = new int[]{0};
                        busyDialog.updateText(BARControl.tr("Found archives: {0}", nArray[0]));
                        try {
                            BARServer.executeCommand(StringParser.format("INDEX_STORAGE_ADD name=%'S patternType=GLOB progressSteps=1000", uRIParts.getURI()), 0, new Command.ResultHandler(){

                                @Override
                                public void handle(int n, ValueMap valueMap) {
                                    long l = valueMap.getLong("storageId", 0L);
                                    String string = valueMap.getString("name");
                                    long l2 = valueMap.getLong("doneCount", 0L);
                                    long l3 = valueMap.getLong("totalCount", 0L);
                                    if (l != 0L && !string.isEmpty()) {
                                        nArray[0] = nArray[0] + 1;
                                        busyDialog.updateText(BARControl.tr("Found archives: {0}", nArray[0]));
                                        busyDialog.updateList(string);
                                    } else if (l3 > 0L) {
                                        busyDialog.updateProgressBar(0, (double)l2 * 100.0 / (double)l3);
                                    }
                                }
                            }, new BusyIndicator(){

                                @Override
                                public boolean isAborted() {
                                    return busyDialog.isAborted();
                                }
                            });
                            busyDialog.done();
                        }
                        catch (Exception exception) {
                            busyDialog.close();
                            if (busyDialog.isAborted()) break block2;
                            TabRestore.this.display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    Dialogs.error(TabRestore.this.shell, BARControl.tr("Cannot add index to database for storage path\n\n''{0}''\n\n(error: {1})", data.archiveName, exception.getMessage()));
                                }
                            });
                        }
                    }
                    TabRestore.this.updateStorageTreeTableThread.triggerUpdate();
                }
            });
        }
    }

    private void removeStoragesFromIndex() {
        HashSet<IndexData> hashSet = this.getSelectedIndexData();
        if (!hashSet.isEmpty()) {
            long l;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            for (IndexData indexData : hashSet) {
                if (indexData instanceof UUIDIndexData) {
                    ++n;
                    continue;
                }
                if (indexData instanceof EntityIndexData) {
                    ++n2;
                    continue;
                }
                if (!(indexData instanceof StorageIndexData)) continue;
                ++n3;
            }
            try {
                l = BARServer.getLong(StringParser.format("INDEX_STORAGE_LIST_INFO", new Object[0]), 2, "totalEntryCount");
                assert (l >= 0L);
            }
            catch (Exception exception) {
                this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Dialogs.error(TabRestore.this.shell, BARControl.tr("Cannot get total entries from database!\n\n(error: {0})", exception.getMessage()));
                    }
                });
                return;
            }
            if (Dialogs.confirm(this.shell, BARControl.tr("Remove {0} {0,choice,0#jobs|1#job|1<jobs}/{1} {1,choice,0#entities|1#entity|1<entities}/{2} {2,choice,0#archives|1#archive|1<archives} from index with {3} {3,choice,0#entries|1#entry|1<entries}?", n, n2, n3, l))) {
                BusyDialog busyDialog = new BusyDialog(this.shell, BARControl.tr("Remove indices", new Object[0]), 500, 100, null, 16777609);
                busyDialog.setMaximum(hashSet.size());
                Background.run(new BackgroundRunnable(new Object[]{busyDialog, hashSet}){

                    public void run(final BusyDialog busyDialog, HashSet<IndexData> hashSet) {
                        block12: {
                            try {
                                long l = 0L;
                                for (IndexData indexData : hashSet) {
                                    final String string = indexData.getInfo();
                                    busyDialog.updateText(0, "%s", string);
                                    try {
                                        if (indexData instanceof UUIDIndexData) {
                                            BARServer.executeCommand(StringParser.format("INDEX_REMOVE state=* uuidId=%lld", indexData.id), 0);
                                            Widgets.removeTreeItem(TabRestore.this.widgetStorageTree, indexData);
                                        } else if (indexData instanceof EntityIndexData) {
                                            BARServer.executeCommand(StringParser.format("INDEX_REMOVE state=* entityId=%lld", indexData.id), 0);
                                            Widgets.removeTreeItem(TabRestore.this.widgetStorageTree, indexData);
                                        } else if (indexData instanceof StorageIndexData) {
                                            BARServer.executeCommand(StringParser.format("INDEX_REMOVE state=* storageId=%lld", indexData.id), 0);
                                        }
                                        TabRestore.this.checkedIndexIdSet.remove(indexData.id);
                                    }
                                    catch (Exception exception) {
                                        TabRestore.this.display.syncExec(new Runnable(){

                                            @Override
                                            public void run() {
                                                Dialogs.error(TabRestore.this.shell, BARControl.tr("Cannot remove index for\n\n{0}!\n\n(error: {1})", string, exception.getMessage()));
                                            }
                                        });
                                    }
                                    busyDialog.updateProgressBar(++l);
                                    if (!busyDialog.isAborted()) continue;
                                    break;
                                }
                                TabRestore.this.display.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        busyDialog.close();
                                    }
                                });
                            }
                            catch (CommunicationError communicationError) {
                                TabRestore.this.display.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        busyDialog.close();
                                        Dialogs.error(TabRestore.this.shell, BARControl.tr("Communication error while removing database indices\n\n(error: {0})", communicationError.getMessage()));
                                    }
                                });
                            }
                            catch (ConnectionError connectionError) {
                                TabRestore.this.display.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        busyDialog.close();
                                        Dialogs.error(TabRestore.this.shell, BARControl.tr("Connection error while removing database indices\n\n(error: {0})", connectionError.getMessage()));
                                    }
                                });
                            }
                            catch (Throwable throwable) {
                                if (Settings.debugLevel <= 0) break block12;
                                BARServer.disconnect();
                                BARControl.internalError(throwable);
                            }
                        }
                        TabRestore.this.updateStorageTreeTableThread.triggerUpdate();
                        TabRestore.this.updateEntryTableThread.triggerUpdate();
                        TabRestore.this.updateAssignTo();
                    }
                });
                this.clearSelectedIndexData();
            }
        }
    }

    private void removeAllWithErrorStorageIndex() {
        try {
            long l;
            try {
                l = BARServer.getLong("INDEX_STORAGE_LIST_INFO entityId=* indexStateSet=ERROR indexModeSet=* name=*", 1, "totalStorageCount");
            }
            catch (Exception exception) {
                this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Dialogs.error(TabRestore.this.shell, BARControl.tr("Cannot get database indices with error state!\n\n(error: {0})", exception.getMessage()));
                    }
                });
                return;
            }
            if (l > 0L && Dialogs.confirm(this.shell, BARControl.tr("Remove {0} {0,choice,0#storages|1#storage|1<storages} with error state?", l))) {
                BusyDialog busyDialog = new BusyDialog(this.shell, "Remove storages with error", 500, 100, null, 16777609);
                busyDialog.setMaximum(l);
                Background.run(new BackgroundRunnable(new Object[]{busyDialog}){

                    public void run(final BusyDialog busyDialog) {
                        block9: {
                            try {
                                final String[] stringArray = new String[1];
                                ValueMap valueMap = new ValueMap();
                                Command command = BARServer.runCommand("INDEX_REMOVE state=ERROR", 0);
                                long l = 0L;
                                while (!command.endOfData() && !busyDialog.isAborted() && command.getNextResult(stringArray, valueMap, 60000) == 0) {
                                    try {
                                        long l2 = valueMap.getLong("storageId");
                                        String string = valueMap.getString("name");
                                        busyDialog.updateText(0, "%d: %s", l2, string);
                                        busyDialog.updateProgressBar(++l);
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        if (Settings.debugLevel <= 0) continue;
                                        BARServer.disconnect();
                                        BARControl.internalError(illegalArgumentException);
                                    }
                                }
                                if (busyDialog.isAborted()) {
                                    command.abort();
                                }
                                TabRestore.this.display.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        busyDialog.close();
                                    }
                                });
                                if (command.getErrorCode() != 0) {
                                    TabRestore.this.display.syncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            Dialogs.error(TabRestore.this.shell, BARControl.tr("Cannot remove database indices with error state!\n\n(error: {0})", stringArray[0]));
                                        }
                                    });
                                }
                            }
                            catch (CommunicationError communicationError) {
                                TabRestore.this.display.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        busyDialog.close();
                                        Dialogs.error(TabRestore.this.shell, BARControl.tr("Communication error while removing database indices\n\n(error: {0})", communicationError.getMessage()));
                                    }
                                });
                            }
                            catch (ConnectionError connectionError) {
                                TabRestore.this.display.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        busyDialog.close();
                                        Dialogs.error(TabRestore.this.shell, BARControl.tr("Connection error while removing database indices\n\n(error: {0})", connectionError.getMessage()));
                                    }
                                });
                            }
                            catch (Throwable throwable) {
                                if (Settings.debugLevel <= 0) break block9;
                                BARServer.disconnect();
                                BARControl.internalError(throwable);
                            }
                        }
                        TabRestore.this.updateStorageTreeTableThread.triggerUpdate();
                        TabRestore.this.updateAssignTo();
                    }
                });
            }
        }
        catch (CommunicationError communicationError) {
            Dialogs.error(this.shell, BARControl.tr("Communication error while removing database indices\n\n(error: {0})", communicationError.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteStorages() {
        IndexIdSet indexIdSet = (IndexIdSet)this.checkedIndexIdSet.clone();
        switch (this.widgetStorageTabFolder.getSelectionIndex()) {
            case 0: {
                for (Item item : this.widgetStorageTree.getSelection()) {
                    IndexData indexData;
                    if (item.getData() instanceof UUIDIndexData) {
                        indexData = (UUIDIndexData)item.getData();
                        if (indexData == null) continue;
                        indexIdSet.add(indexData.id);
                        continue;
                    }
                    if (item.getData() instanceof EntityIndexData) {
                        indexData = (EntityIndexData)item.getData();
                        if (indexData == null) continue;
                        indexIdSet.add(((EntityIndexData)indexData).id);
                        continue;
                    }
                    if (!(item.getData() instanceof StorageIndexData) || (indexData = (StorageIndexData)item.getData()) == null) continue;
                    indexIdSet.add(((StorageIndexData)indexData).id);
                }
                this.widgetStorageTree.deselectAll();
                break;
            }
            case 1: {
                for (Item l2 : this.widgetStorageTable.getSelection()) {
                    StorageIndexData storageIndexData = (StorageIndexData)l2.getData();
                    if (storageIndexData == null) continue;
                    indexIdSet.add(storageIndexData.id);
                }
                this.widgetStorageTable.deselectAll();
            }
        }
        if (!indexIdSet.isEmpty()) {
            Object object;
            final HashMap hashMap = new HashMap();
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            BARControl.waitCursor();
            try {
                this.setStorageList(indexIdSet);
                try {
                    BARServer.executeCommand("INDEX_STORAGE_LIST", 1, new Command.ResultHandler(){

                        @Override
                        public void handle(int n, ValueMap valueMap) {
                            long l = valueMap.getLong("storageId");
                            String string = valueMap.getString("name");
                            long l2 = valueMap.getLong("totalEntryCount");
                            long l3 = valueMap.getLong("totalEntrySize", Long.MAX_VALUE);
                            hashMap.put(l, BARControl.tr("#{0}: {1}, {2} {2,choice,0#entries|1#entry|1<entries}, {3} ({4} {4,choice,0#bytes|1#byte|1<bytes})", l, string, l2, Units.formatByteSize(l3), l3));
                        }
                    });
                }
                catch (Exception exception) {
                    Dialogs.error(this.shell, BARControl.tr("Cannot get storages list!\n\n(error: {0})", exception.getMessage()));
                    BARControl.logThrowable(exception);
                    BARControl.resetCursor();
                    return;
                }
                try {
                    object = new ValueMap();
                    BARServer.executeCommand(StringParser.format("INDEX_STORAGE_LIST_INFO", new Object[0]), 2, (ValueMap)object);
                    l = ((ValueMap)object).getLong("totalStorageCount");
                    l2 = ((ValueMap)object).getLong("totalStorageSize", Long.MAX_VALUE);
                    l3 = ((ValueMap)object).getLong("totalEntryCount");
                    l4 = ((ValueMap)object).getLong("totalEntrySize", Long.MAX_VALUE);
                    assert (l >= 0L);
                    assert (l2 >= 0L);
                    assert (l3 >= 0L);
                    assert (l4 >= 0L);
                }
                catch (Exception exception) {
                    BARControl.logThrowable(exception);
                }
            }
            finally {
                BARControl.resetCursor();
            }
            if (Dialogs.confirm(this.shell, BARControl.tr("Delete {0} {0,choice,0#storage files|1#storage file|1<storage files} with {1} ({2} {2,choice,0#bytes|1#byte|1<bytes})?", hashMap.size(), Units.formatByteSize(l2), l2))) {
                object = new BusyDialog(this.shell, BARControl.tr("Delete storage indices and archives", new Object[0]), 500, 150, null, 16777609);
                ((BusyDialog)object).setMaximum(hashMap.size());
                Background.run(new BackgroundRunnable(new Object[]{object, hashMap}){

                    public void run(final BusyDialog busyDialog, HashMap<Long, String> hashMap) {
                        block15: {
                            try {
                                boolean bl = false;
                                boolean bl2 = false;
                                long l = 0L;
                                for (Long l2 : hashMap.keySet()) {
                                    final String string = hashMap.get(l2);
                                    busyDialog.updateText(0, "%s", string);
                                    try {
                                        BARServer.executeCommand(StringParser.format("STORAGE_DELETE storageId=%lld", l2), 0);
                                    }
                                    catch (Exception exception) {
                                        if (!bl) {
                                            final int[] nArray = new int[1];
                                            if ((long)hashMap.size() > l + 1L) {
                                                TabRestore.this.display.syncExec(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        nArray[0] = Dialogs.select(TabRestore.this.shell, BARControl.tr("Confirmation", new Object[0]), BARControl.tr("Cannot delete storage\n\n''{0}''\n\n(error: {1})", string, exception.getMessage()), new String[]{BARControl.tr("Continue", new Object[0]), BARControl.tr("Continue with all", new Object[0]), BARControl.tr("Abort", new Object[0])}, 0);
                                                    }
                                                });
                                            }
                                            switch (nArray[0]) {
                                                case 0: {
                                                    break;
                                                }
                                                case 1: {
                                                    bl = true;
                                                    break;
                                                }
                                                case 2: {
                                                    bl2 = true;
                                                    break;
                                                }
                                            }
                                        }
                                    }
                                    catch (ConnectionError connectionError) {
                                        bl2 = true;
                                    }
                                    busyDialog.updateProgressBar(++l);
                                    if (!bl2 && !busyDialog.isAborted()) continue;
                                    break;
                                }
                                TabRestore.this.display.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        busyDialog.close();
                                    }
                                });
                                TabRestore.this.updateStorageTreeTableThread.triggerUpdate();
                                TabRestore.this.updateAssignTo();
                                Widgets.notify(TabRestore.this.shell, 65537);
                            }
                            catch (CommunicationError communicationError) {
                                TabRestore.this.display.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        busyDialog.close();
                                        Dialogs.error(TabRestore.this.shell, BARControl.tr("Communication error while deleting storage\n\n(error: {0})", communicationError.getMessage()));
                                    }
                                });
                            }
                            catch (ConnectionError connectionError) {
                                TabRestore.this.display.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        busyDialog.close();
                                        Dialogs.error(TabRestore.this.shell, BARControl.tr("Connection error while removing database indices\n\n(error: {0})", connectionError.getMessage()));
                                    }
                                });
                            }
                            catch (Throwable throwable) {
                                if (Settings.debugLevel <= 0) break block15;
                                BARServer.disconnect();
                                BARControl.internalError(throwable);
                            }
                        }
                    }
                });
                this.setAllCheckedStorage(false);
            }
        }
    }

    private void setEntryList(long l, boolean bl) {
        try {
            if (bl) {
                BARServer.executeCommand(StringParser.format("INDEX_ENTRY_LIST_ADD entryIds=%ld", l), 1);
            } else {
                BARServer.executeCommand(StringParser.format("INDEX_ENTRY_LIST_REMOVE entryIds=%ld", l), 1);
            }
        }
        catch (Exception exception) {
            throw new CommunicationError(exception);
        }
        this.checkedEntryIdSet.set(l, bl);
    }

    private void clearEntryList() {
        try {
            BARServer.executeCommand(StringParser.format("INDEX_ENTRY_LIST_CLEAR", new Object[0]), 1);
        }
        catch (Exception exception) {
            throw new CommunicationError(exception);
        }
        this.checkedEntryIdSet.clear();
    }

    private void setEntryList(IndexIdSet indexIdSet) {
        int n;
        try {
            BARServer.executeCommand(StringParser.format("INDEX_ENTRY_LIST_CLEAR", new Object[0]), 1);
        }
        catch (Exception exception) {
            throw new CommunicationError(exception);
        }
        Object[] objectArray = indexIdSet.toArray(new Long[indexIdSet.size()]);
        for (int i = 0; i < objectArray.length; i += n) {
            n = objectArray.length - i;
            if (n > 1024) {
                n = 1024;
            }
            try {
                BARServer.executeCommand(StringParser.format("INDEX_ENTRY_LIST_ADD entryIds=%s", StringUtils.join(objectArray, i, n, ',')), 1);
                continue;
            }
            catch (Exception exception) {
                throw new CommunicationError(exception);
            }
        }
        for (Long l : objectArray) {
            this.checkedEntryIdSet.set(l, true);
        }
    }

    private void setAllCheckedEntries(final boolean bl) {
        final int[] nArray = new int[]{0};
        final boolean[] blArray = new boolean[]{false};
        if (bl) {
            try {
                nArray[0] = BARServer.getInt(StringParser.format("INDEX_ENTRY_LIST_INFO entryType=%s name=%'S newestOnly=%y selectedOnly=no", this.updateEntryTableThread.getEntryType().toString(), this.updateEntryTableThread.getName_(), this.updateEntryTableThread.getNewestOnly()), 0, "totalEntryCount");
                if (nArray[0] > 1000) {
                    this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            blArray[0] = Dialogs.confirm(TabRestore.this.shell, Dialogs.booleanFieldUpdater(Settings.class, "showEntriesMarkInfo"), BARControl.tr("There are {0} entries. Really mark all entries?", nArray[0]), true);
                        }
                    });
                }
                blArray[0] = true;
            }
            catch (Exception exception) {
                throw new CommunicationError(exception);
            }
        } else {
            blArray[0] = true;
        }
        if (bl) {
            if (blArray[0]) {
                this.clearEntryList();
                final BusyDialog busyDialog = new BusyDialog(this.shell, BARControl.tr("Mark entries", new Object[0]), 500, 100, null, 392);
                try {
                    final IndexIdSet indexIdSet = new IndexIdSet();
                    final int[] nArray2 = new int[]{0};
                    busyDialog.setMaximum(nArray[0]);
                    BARServer.executeCommand(StringParser.format("INDEX_ENTRY_LIST entryType=%s name=%'S newestOnly=%y selectedOnly=no fragmentsCount=no", this.updateEntryTableThread.getEntryType().toString(), this.updateEntryTableThread.getName_(), this.updateEntryTableThread.getNewestOnly()), 2, new Command.ResultHandler(){

                        @Override
                        public void handle(int n, ValueMap valueMap) {
                            long l = valueMap.getLong("entryId", 0L);
                            indexIdSet.set(l, bl);
                            nArray2[0] = nArray2[0] + 1;
                            busyDialog.updateProgressBar(nArray2[0]);
                            if (busyDialog.isAborted()) {
                                this.abort();
                            }
                        }
                    });
                    this.clearEntryList();
                    this.setEntryList(indexIdSet);
                    busyDialog.close();
                }
                catch (BARException bARException) {
                    busyDialog.close();
                    if (bARException.code != 6) {
                        Dialogs.error(this.shell, BARControl.tr("Cannot mark all index entries!\n\n(error: {0})", bARException.getMessage()));
                    }
                }
                catch (Exception exception) {
                    busyDialog.close();
                    Dialogs.error(this.shell, BARControl.tr("Cannot mark all index entries!\n\n(error: {0})", exception.getMessage()));
                    BARControl.logThrowable(exception);
                }
            }
        } else {
            this.clearEntryList();
        }
    }

    private EntryIndexData[] getCheckedEntries() {
        ArrayList<EntryIndexData> arrayList = new ArrayList<EntryIndexData>();
        for (TableItem tableItem : this.widgetEntryTable.getItems()) {
            if (!tableItem.getChecked()) continue;
            arrayList.add((EntryIndexData)tableItem.getData());
        }
        return arrayList.toArray(new EntryIndexData[arrayList.size()]);
    }

    private void restore(final RestoreTypes restoreTypes, IndexIdSet indexIdSet) {
        class Data {
            long totalStorageCount = 0L;
            long totalStorageSize = 0L;
            long totalEntryCount = 0L;
            long totalEntrySize = 0L;
            String restoreToDirectory = null;
            boolean directoryContent = false;
            boolean sparse = false;
            boolean skipVerifySignatures = false;
            RestoreEntryModes restoreEntryMode = RestoreEntryModes.STOP;

            Data() {
            }
        }
        final Data data = new Data();
        String string = null;
        switch (restoreTypes) {
            case ARCHIVES: {
                string = BARControl.tr("Restore archives", new Object[0]);
                break;
            }
            case ENTRIES: {
                string = BARControl.tr("Restore entries", new Object[0]);
            }
        }
        final Shell shell = Dialogs.openModal(this.shell, string, 800, 400, new double[]{1.0, 0.0}, 1.0);
        final WidgetEvent widgetEvent = new WidgetEvent();
        Composite composite = Widgets.newComposite(shell);
        composite.setLayout(new TableLayout(new double[]{0.0, 1.0, 0.0, 0.0, 0.0}, new double[]{0.0, 1.0}));
        Widgets.layout((Control)composite, 0, 0, 15, 0, 0, 2);
        switch (restoreTypes) {
            case ARCHIVES: {
                string = BARControl.tr("Archives", new Object[0]);
                break;
            }
            case ENTRIES: {
                string = BARControl.tr("Entries", new Object[0]);
            }
        }
        Label label = Widgets.newLabel(composite, string + ":");
        Widgets.layout(label, 0, 0, 5, 0, 2);
        final Table table = Widgets.newTable(composite);
        Widgets.layout((Control)table, 1, 0, 15, 0, 2, 0, 4);
        switch (restoreTypes) {
            case ARCHIVES: {
                Widgets.addTableColumn(table, 0, BARControl.tr("Name", new Object[0]), 16384, 530, true);
                Widgets.addTableColumn(table, 1, BARControl.tr("Entries", new Object[0]), 131072, 80, true);
                Widgets.addTableColumn(table, 2, BARControl.tr("Size", new Object[0]), 131072, 60, true);
                break;
            }
            case ENTRIES: {
                Widgets.addTableColumn(table, 0, BARControl.tr("Name", new Object[0]), 16384, 360, true);
                Widgets.addTableColumn(table, 1, BARControl.tr("Type", new Object[0]), 16384, 100, true);
                Widgets.addTableColumn(table, 2, BARControl.tr("Size", new Object[0]), 131072, 60, true);
                Widgets.addTableColumn(table, 3, BARControl.tr("Date/Time", new Object[0]), 16384, 180, true);
                Widgets.addTableColumn(table, 3, BARControl.tr("Fragments", new Object[0]), 131072, 80, true);
            }
        }
        label = Widgets.newLabel(composite, BARControl.tr("Total", new Object[0]) + ":");
        Widgets.layout(label, 2, 0, 4);
        final Label label2 = Widgets.newLabel(composite, "-");
        Widgets.layout(label2, 2, 1, 4);
        Composite composite2 = Widgets.newComposite(composite, Settings.hasNormalRole());
        composite2.setLayout(new TableLayout(null, new double[]{0.0, 1.0, 0.0}));
        Widgets.layout(composite2, 3, 0, 12, 0, 2);
        final Button button = Widgets.newCheckbox(composite2, BARControl.tr("to", new Object[0]));
        button.setToolTipText(BARControl.tr("Enable this checkbox and select a directory to restore entries to different location.", new Object[0]));
        Widgets.layout(button, 0, 0, 4);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button2 = (Button)selectionEvent.widget;
                boolean bl = button2.getSelection();
                button.setSelection(bl);
                widgetEvent.trigger();
            }
        });
        final Text text = Widgets.newText(composite2);
        text.setEnabled(false);
        Widgets.layout(text, 0, 1, 12);
        Widgets.addEventListener(new WidgetEventListener(text, widgetEvent){

            @Override
            public void trigger(Control control) {
                control.setEnabled(button.getSelection());
            }
        });
        composite2.addMouseListener(new MouseListener(){

            @Override
            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseDown(MouseEvent mouseEvent) {
                Rectangle rectangle = text.getBounds();
                if (rectangle.contains(mouseEvent.x, mouseEvent.y)) {
                    button.setSelection(true);
                    widgetEvent.trigger();
                    Widgets.setFocus(text);
                }
            }

            @Override
            public void mouseUp(MouseEvent mouseEvent) {
            }
        });
        Button button2 = Widgets.newButton(composite2, this.IMAGE_DIRECTORY);
        Widgets.layout(button2, 0, 2, 0);
        button2.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = (selectionEvent.stateMask & 0x40000) == 0 ? Dialogs.file(TabRestore.this.shell, Dialogs.FileDialogTypes.DIRECTORY, BARControl.tr("Select path", new Object[0]), text.getText(), BARServer.remoteListDirectory) : Dialogs.directory(TabRestore.this.shell, BARControl.tr("Select path", new Object[0]), text.getText());
                if (string != null) {
                    button.setSelection(true);
                    widgetEvent.trigger();
                    text.setText(string);
                }
            }
        });
        final Button button3 = Widgets.newCheckbox(composite, BARControl.tr("Directory content", new Object[0]), Settings.hasNormalRole());
        button3.setToolTipText(BARControl.tr("Restore content of selected directories, too.", new Object[0]));
        button3.setEnabled(restoreTypes == RestoreTypes.ENTRIES);
        Widgets.layout(button3, 4, 0, 4, 0, 2);
        button3.addSelectionListener(new SelectionListener(){
            {
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                data.directoryContent = button.getSelection();
                label2.setText(BARControl.tr("{0} {0,choice,0#entries|1#entry|1<entries}/{1} ({2} {2,choice,0#bytes|1#byte|1<bytes})", data.totalEntryCount, Units.formatByteSize(data.totalEntrySize), data.totalEntrySize));
                label2.pack();
            }
        });
        final Button button4 = Widgets.newCheckbox(composite, BARControl.tr("Sparse files/hardlinks", new Object[0]), Settings.hasNormalRole());
        button4.setToolTipText(BARControl.tr("Restore as sparse files/hardlinks.", new Object[0]));
        Widgets.layout(button4, 5, 0, 4, 0, 2);
        final Button button5 = Widgets.newCheckbox(composite, BARControl.tr("Skip verify signatures", new Object[0]), Settings.hasExpertRole());
        button5.setToolTipText(BARControl.tr("Enable this checkbox when verification of signatures should be skipped.", new Object[0]));
        Widgets.layout(button5, 6, 0, 4, 0, 2);
        composite2 = Widgets.newComposite(composite, Settings.hasNormalRole());
        composite2.setLayout(new TableLayout(null, new double[]{0.0, 1.0}));
        Widgets.layout(composite2, 7, 0, 12, 0, 2);
        label = Widgets.newLabel(composite2, BARControl.tr("Entry mode", new Object[0]) + ":");
        Widgets.layout(label, 0, 0, 4);
        final Combo combo = Widgets.newOptionMenu(composite2);
        combo.setToolTipText(BARControl.tr("If set to 'rename' then the new entry is renamed if entry already exists.\nIf set to 'overwrite' then existing entries are overwritten.\nOtherwise stop with an error if entry exists.", new Object[0]));
        Widgets.setComboItems(combo, new Object[]{BARControl.tr("stop if exists", new Object[0]), RestoreEntryModes.STOP, BARControl.tr("rename if exists", new Object[0]), RestoreEntryModes.RENAME, BARControl.tr("overwrite", new Object[0]), RestoreEntryModes.OVERWRITE, BARControl.tr("skip existing", new Object[0]), RestoreEntryModes.SKIP_EXISTING});
        Widgets.setSelectedComboItem(combo, RestoreEntryModes.STOP);
        Widgets.layout(combo, 0, 1, 4);
        composite = Widgets.newComposite(shell);
        composite.setLayout(new TableLayout(0.0, 1.0));
        Widgets.layout((Control)composite, 1, 0, 12, 0, 0, 2);
        final Button button6 = Widgets.newButton(composite, BARControl.tr("Start restore", new Object[0]));
        button6.setEnabled(false);
        Widgets.layout(button6, 0, 0, 4, 0, 0, 0, 0, 160, -1);
        button6.addSelectionListener(new SelectionListener(){
            {
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button2 = (Button)selectionEvent.widget;
                data.restoreToDirectory = button.getSelection() ? text.getText() : null;
                data.directoryContent = button3.getSelection();
                data.sparse = button4.getSelection();
                data.skipVerifySignatures = button5.getSelection();
                data.restoreEntryMode = Widgets.getSelectedComboItem(combo, RestoreEntryModes.STOP);
                Dialogs.close(shell, true);
            }
        });
        button2 = Widgets.newButton(composite, BARControl.tr("Cancel", new Object[0]));
        Widgets.layout(button2, 0, 1, 8, 0, 0, 0, 0, 120, -1);
        button2.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                Dialogs.close(shell, null);
            }
        });
        Dialogs.show(shell);
        Background.run(new BackgroundRunnable(new Object[]{indexIdSet}){
            {
                super(objectArray);
            }

            public void run(final IndexIdSet indexIdSet) {
                TabRestore.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        BARControl.waitCursor(shell);
                    }
                });
                try {
                    switch (restoreTypes) {
                        case ARCHIVES: {
                            try {
                                BARServer.executeCommand(StringParser.format("INDEX_STORAGE_LIST_INFO", new Object[0]), 2, new Command.ResultHandler(){

                                    @Override
                                    public void handle(int n, ValueMap valueMap) {
                                        data.totalStorageCount = valueMap.getLong("totalStorageCount");
                                        data.totalStorageSize = valueMap.getLong("totalStorageSize");
                                        data.totalEntryCount = valueMap.getLong("totalEntryCount");
                                        data.totalEntrySize = valueMap.getLong("totalEntrySize", Long.MAX_VALUE);
                                    }
                                });
                                assert (data.totalStorageCount >= 0L);
                                assert (data.totalStorageSize >= 0L);
                                assert (data.totalEntryCount >= 0L);
                                assert (data.totalEntrySize >= 0L);
                                TabRestore.this.display.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (!label2.isDisposed()) {
                                            label2.setText(BARControl.tr("{0} {0,choice,0#entries|1#entry|1<entries}/{1} ({2} {2,choice,0#bytes|1#byte|1<bytes})", data.totalEntryCount, Units.formatByteSize(data.totalEntrySize), data.totalEntrySize));
                                            label2.pack();
                                        }
                                    }
                                });
                                BARServer.executeCommand(StringParser.format("INDEX_STORAGE_LIST sortMode=NAME ordering=ASCENDING", new Object[0]), 1, new Command.ResultHandler(){

                                    @Override
                                    public void handle(int n, ValueMap valueMap) {
                                        final long l = valueMap.getLong("storageId");
                                        final String string = valueMap.getString("name");
                                        final long l2 = valueMap.getLong("totalEntryCount");
                                        final long l3 = valueMap.getLong("totalEntrySize", Long.MAX_VALUE);
                                        TabRestore.this.display.syncExec(new Runnable(){

                                            @Override
                                            public void run() {
                                                if (!table.isDisposed()) {
                                                    Widgets.addTableItem(table, (Object)l, string, Long.toString(l2), Units.formatByteSize(l3));
                                                }
                                            }
                                        });
                                    }
                                });
                                break;
                            }
                            catch (Exception exception) {
                                throw new CommunicationError(exception);
                            }
                        }
                        case ENTRIES: {
                            try {
                                BARServer.executeCommand(StringParser.format("INDEX_ENTRY_LIST_INFO name='' entryType=* newestOnly=no selectedOnly=yes", new Object[0]), 1, new Command.ResultHandler(){

                                    @Override
                                    public void handle(int n, ValueMap valueMap) {
                                        data.totalStorageCount = valueMap.getLong("totalStorageCount");
                                        data.totalStorageSize = valueMap.getLong("totalStorageSize", Long.MAX_VALUE);
                                        data.totalEntryCount = valueMap.getLong("totalEntryCount");
                                        data.totalEntrySize = valueMap.getLong("totalEntrySize", Long.MAX_VALUE);
                                    }
                                });
                                assert (data.totalStorageCount >= 0L);
                                assert (data.totalStorageSize >= 0L);
                                assert (data.totalEntryCount >= 0L);
                                assert (data.totalEntrySize >= 0L);
                                TabRestore.this.display.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (!label2.isDisposed()) {
                                            label2.setText(BARControl.tr("{0} {0,choice,0#entries|1#entry|1<entries}/{1} ({2} {2,choice,0#bytes|1#byte|1<bytes})", data.totalEntryCount, Units.formatByteSize(data.totalEntrySize), data.totalEntrySize));
                                            label2.pack();
                                        }
                                    }
                                });
                                BARServer.executeCommand(StringParser.format("INDEX_ENTRY_LIST newestOnly=no selectedOnly=yes fragmentsCount=yes", new Object[0]), 1, new Command.ResultHandler(){

                                    @Override
                                    public void handle(int n, ValueMap valueMap) {
                                        final long l = valueMap.getLong("entryId");
                                        final EntryTypes entryTypes = valueMap.getEnum("entryType", EntryTypes.class);
                                        switch (entryTypes) {
                                            case FILE: {
                                                final String string = valueMap.getString("name");
                                                final long l2 = valueMap.getLong("dateTime");
                                                final long l3 = valueMap.getLong("size");
                                                final int n2 = valueMap.getInt("fragmentCount");
                                                TabRestore.this.display.syncExec(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        if (!table.isDisposed()) {
                                                            Widgets.addTableItem(table, (Object)l, string, entryTypes.getText(), Units.formatByteSize(l3), TabRestore.this.SIMPLE_DATE_FORMAT.format(new Date(l2 * 1000L)), String.format("%d", n2));
                                                        }
                                                    }
                                                });
                                                break;
                                            }
                                            case IMAGE: {
                                                final String string = valueMap.getString("name");
                                                final long l4 = valueMap.getLong("size");
                                                final int n3 = valueMap.getInt("fragmentCount");
                                                TabRestore.this.display.syncExec(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        if (!table.isDisposed()) {
                                                            Widgets.addTableItem(table, (Object)l, string, entryTypes.getText(), Units.formatByteSize(l4), "", String.format("%d", n3));
                                                        }
                                                    }
                                                });
                                                break;
                                            }
                                            case DIRECTORY: {
                                                final String string = valueMap.getString("name");
                                                final long l5 = valueMap.getLong("dateTime");
                                                long l6 = valueMap.getLong("size");
                                                TabRestore.this.display.syncExec(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        if (!table.isDisposed()) {
                                                            Widgets.addTableItem(table, (Object)l, string, entryTypes.getText(), "", TabRestore.this.SIMPLE_DATE_FORMAT.format(new Date(l5 * 1000L)), "");
                                                        }
                                                    }
                                                });
                                                break;
                                            }
                                            case LINK: {
                                                final String string = valueMap.getString("name");
                                                String string2 = valueMap.getString("destinationName");
                                                final long l7 = valueMap.getLong("dateTime");
                                                TabRestore.this.display.syncExec(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        if (!table.isDisposed()) {
                                                            Widgets.addTableItem(table, (Object)l, string, entryTypes.getText(), "", TabRestore.this.SIMPLE_DATE_FORMAT.format(new Date(l7 * 1000L)), "");
                                                        }
                                                    }
                                                });
                                                break;
                                            }
                                            case HARDLINK: {
                                                final String string = valueMap.getString("name");
                                                final long l8 = valueMap.getLong("dateTime");
                                                final long l9 = valueMap.getLong("size");
                                                final int n4 = valueMap.getInt("fragmentCount");
                                                TabRestore.this.display.syncExec(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        if (!table.isDisposed()) {
                                                            Widgets.addTableItem(table, (Object)l, string, entryTypes.getText(), Units.formatByteSize(l9), TabRestore.this.SIMPLE_DATE_FORMAT.format(new Date(l8 * 1000L)), String.format("%d", n4));
                                                        }
                                                    }
                                                });
                                                break;
                                            }
                                            case SPECIAL: {
                                                final String string = valueMap.getString("name");
                                                final long l10 = valueMap.getLong("dateTime");
                                                TabRestore.this.display.syncExec(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        if (!table.isDisposed()) {
                                                            Widgets.addTableItem(table, (Object)l, string, entryTypes.getText(), "", TabRestore.this.SIMPLE_DATE_FORMAT.format(new Date(l10 * 1000L)), "");
                                                        }
                                                    }
                                                });
                                            }
                                        }
                                    }
                                });
                                break;
                            }
                            catch (Exception exception) {
                                throw new CommunicationError(exception);
                            }
                        }
                    }
                    TabRestore.this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!button6.isDisposed()) {
                                button6.setEnabled(!indexIdSet.isEmpty());
                            }
                        }
                    });
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    try {
                        if (Settings.debugLevel > 0) {
                            BARControl.printStackTrace(illegalArgumentException);
                        }
                        TabRestore.this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                BARControl.resetCursor(shell);
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        TabRestore.this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                }
                TabRestore.this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
            }
        });
        if (((Boolean)Dialogs.run(shell, false)).booleanValue()) {
            switch (restoreTypes) {
                case ARCHIVES: {
                    string = data.restoreToDirectory != null ? BARControl.tr("Restore archives to: {0}", data.restoreToDirectory) : BARControl.tr("Restore archives", new Object[0]);
                    break;
                }
                case ENTRIES: {
                    string = data.restoreToDirectory != null ? BARControl.tr("Restore entries to: {0}", data.restoreToDirectory) : BARControl.tr("Restore entries", new Object[0]);
                }
            }
            BusyDialog busyDialog = new BusyDialog(this.shell, string, 500, 300, null, 0x10001FF, 250);
            busyDialog.updateText(0, "%s", BARControl.tr("Storages", new Object[0]));
            busyDialog.updateText(3, "%s", BARControl.tr("Failed entries", new Object[0]) + ":");
            Background.run(new BackgroundRunnable(new Object[]{busyDialog, indexIdSet, data.restoreToDirectory, data.directoryContent, data.sparse, data.skipVerifySignatures, data.restoreEntryMode}){
                {
                    super(objectArray);
                }

                /*
                 * Exception decompiling
                 */
                public void run(BusyDialog var1_1, IndexIdSet var2_2, String var3_3, Boolean var4_4, Boolean var5_5, Boolean var6_6, RestoreEntryModes var7_7) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
        }
    }

    static /* synthetic */ void access$9700(TabRestore tabRestore, IndexIdSet indexIdSet) {
        tabRestore.setStorageList(indexIdSet);
    }

    static /* synthetic */ void access$9800(TabRestore tabRestore, IndexIdSet indexIdSet) {
        tabRestore.setEntryList(indexIdSet);
    }

    class UpdateEntryTableThread
    extends Thread {
        private final int PAGE_SIZE = 32;
        private Object trigger = new Object();
        private boolean requestUpdateTotalEntryCount = false;
        private HashSet<Integer> requestUpdateOffsets = new HashSet();
        private Command totalEntryCountCommand = null;
        private long totalEntryCount = 0L;
        private long totalEntrySize = 0L;
        private Command entryTableCommand = null;
        private EntryTypes entryType = EntryTypes.ANY;
        private String name = "";
        private boolean newestOnly = false;
        private boolean requestSetUpdateIndicator = false;

        UpdateEntryTableThread() {
            this.setDaemon(true);
            this.setName("BARControl Update Entry List");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            boolean bl = true;
            final HashSet<Integer> hashSet = new HashSet<Integer>();
            boolean bl2 = true;
            try {
                while (true) {
                    boolean bl3 = false;
                    if (bl2) {
                        TabRestore.this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                BARControl.waitCursor();
                                if (!TabRestore.this.widgetEntryTable.isDisposed()) {
                                    TabRestore.this.widgetEntryTable.setForeground(TabRestore.this.COLOR_MODIFIED);
                                }
                            }
                        });
                        bl3 = true;
                    }
                    TabRestore.this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!TabRestore.this.widgetEntryFilter.isDisposed()) {
                                TabRestore.this.widgetEntryFilter.setBackground(null);
                            }
                        }
                    });
                    try {
                        if (bl) {
                            this.updateEntryTableTotalEntryCount();
                        }
                        if (!hashSet.isEmpty()) {
                            this.updateEntryTableItems(hashSet);
                        }
                        if (bl3) {
                            TabRestore.this.display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!TabRestore.this.widgetEntryTable.isDisposed()) {
                                        TabRestore.this.widgetEntryTable.setForeground((Color)null);
                                    }
                                    BARControl.resetCursor();
                                }
                            });
                        }
                    }
                    catch (CommunicationError communicationError) {
                        if (bl3) {
                            TabRestore.this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
                        }
                        catch (ConnectionError connectionError) {
                            if (bl3) {
                                TabRestore.this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (Settings.debugLevel > 0) {
                                        BARServer.disconnect();
                                        BARControl.internalError(throwable);
                                    }
                                    if (bl3) {
                                        TabRestore.this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
                                    }
                                }
                                catch (Throwable throwable2) {
                                    if (bl3) {
                                        TabRestore.this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
                                    }
                                    throw throwable2;
                                }
                            }
                        }
                    }
                    Object object = this.trigger;
                    synchronized (object) {
                        if (!this.requestUpdateTotalEntryCount && this.requestUpdateOffsets.isEmpty()) {
                            try {
                                this.trigger.wait(300000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        bl = this.requestUpdateTotalEntryCount;
                        hashSet.addAll(this.requestUpdateOffsets);
                        bl2 = this.requestSetUpdateIndicator;
                        if (!this.requestUpdateTotalEntryCount && this.requestUpdateOffsets.isEmpty()) {
                            bl = true;
                            bl2 = false;
                        }
                        do {
                            this.requestUpdateTotalEntryCount = false;
                            this.requestUpdateOffsets.clear();
                            this.requestSetUpdateIndicator = false;
                            try {
                                this.trigger.wait(2000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            bl |= this.requestUpdateTotalEntryCount;
                            hashSet.addAll(this.requestUpdateOffsets);
                            bl2 |= this.requestSetUpdateIndicator;
                        } while (this.requestUpdateTotalEntryCount || !this.requestUpdateOffsets.isEmpty());
                        if (!hashSet.isEmpty()) continue;
                    }
                    TabRestore.this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!TabRestore.this.widgetEntryTable.isDisposed()) {
                                hashSet.add(TabRestore.this.widgetEntryTable.getTopIndex());
                            }
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                if (Settings.debugLevel > 0) {
                    BARServer.disconnect();
                    BARControl.internalError(throwable);
                }
                return;
            }
        }

        private long getTotalEntryCount() {
            return this.totalEntryCount;
        }

        private long getTotalEntrySize() {
            return this.totalEntrySize;
        }

        private EntryTypes getEntryType() {
            return this.entryType;
        }

        private String getName_() {
            return this.name;
        }

        private boolean getNewestOnly() {
            return this.newestOnly;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void triggerUpdate(String string, String string2, boolean bl, boolean bl2) {
            Object object = this.trigger;
            synchronized (object) {
                if (this.name == null || string == null || !this.name.equals(string) || this.entryType != this.entryType || this.newestOnly != bl || bl2) {
                    this.name = string;
                    this.entryType = this.entryType;
                    this.newestOnly = bl;
                    this.requestUpdateTotalEntryCount = true;
                    this.requestSetUpdateIndicator = true;
                    this.restart();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void triggerUpdateEntryName(String string) {
            assert (string != null);
            Object object = this.trigger;
            synchronized (object) {
                if (this.name == null || string == null || (string.length() == 0 || string.length() >= 3) && !this.name.equals(string)) {
                    this.name = string;
                    this.requestUpdateTotalEntryCount = true;
                    this.requestSetUpdateIndicator = true;
                    this.restart();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void triggerUpdateEntryType(EntryTypes entryTypes) {
            Object object = this.trigger;
            synchronized (object) {
                if (entryTypes != this.entryType) {
                    this.entryType = entryTypes;
                    this.requestUpdateTotalEntryCount = true;
                    this.requestSetUpdateIndicator = true;
                    this.restart();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void triggerUpdateNewestOnly(boolean bl) {
            Object object = this.trigger;
            synchronized (object) {
                if (this.newestOnly != bl) {
                    this.newestOnly = bl;
                    this.requestUpdateTotalEntryCount = true;
                    this.requestSetUpdateIndicator = true;
                    this.restart();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void triggerUpdateTableItem(int n) {
            Object object = this.trigger;
            synchronized (object) {
                int n2 = n / 32 * 32;
                if (!this.requestUpdateOffsets.contains(n2)) {
                    this.requestUpdateOffsets.add(n2);
                    this.restart();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void triggerUpdate() {
            Object object = this.trigger;
            synchronized (object) {
                this.requestUpdateTotalEntryCount = true;
                this.restart();
            }
        }

        private boolean isRequestUpdate() {
            return this.requestUpdateTotalEntryCount || !this.requestUpdateOffsets.isEmpty();
        }

        private void restart() {
            if (this.requestUpdateTotalEntryCount) {
                if (this.totalEntryCountCommand != null) {
                    this.totalEntryCountCommand.abort();
                }
                if (this.entryTableCommand != null) {
                    this.entryTableCommand.abort();
                }
            }
            this.trigger.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateEntryTableTotalEntryCount() {
            assert (this.name != null);
            long l = this.totalEntryCount;
            TabRestore.this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!TabRestore.this.widgetEntryTableTitle.isDisposed()) {
                        TabRestore.this.widgetEntryTableTitle.setForeground(TabRestore.this.COLOR_MODIFIED);
                        TabRestore.this.widgetEntryTableTitle.redraw();
                    }
                }
            });
            try {
                try {
                    ValueMap valueMap = new ValueMap();
                    BARServer.executeCommand(StringParser.format("INDEX_ENTRY_LIST_INFO entryType=%s name=%'S newestOnly=%y selectedOnly=no fragmentsCount=no", this.entryType.toString(), this.name, this.newestOnly), 1, valueMap);
                    this.totalEntryCount = valueMap.getLong("totalEntryCount");
                    this.totalEntrySize = valueMap.getLong("totalEntrySize", Long.MAX_VALUE);
                    assert (this.totalEntryCount >= 0L);
                    assert (this.totalEntrySize >= 0L);
                }
                catch (Exception exception) {
                    this.totalEntryCount = 0L;
                    this.totalEntrySize = 0L;
                    BARControl.logThrowable(exception);
                }
                if (l > 0L && l <= 32000L && this.totalEntryCount > 32000L) {
                    TabRestore.this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Dialogs.warning(TabRestore.this.shell, Dialogs.booleanFieldUpdater(Settings.class, "showEntriesExceededInfo"), BARControl.tr("There are {0} entries. Only the first {1} are shown in the list.", TabRestore.this.updateEntryTableThread.getTotalEntryCount(), 32000), new Object[0]);
                        }
                    });
                }
                if (l != this.totalEntryCount) {
                    TabRestore.this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!TabRestore.this.widgetEntryTable.isDisposed()) {
                                TabRestore.this.widgetEntryTable.setRedraw(false);
                                TabRestore.this.widgetEntryTable.clearAll();
                                TabRestore.this.widgetEntryTable.setItemCount((int)Math.min(UpdateEntryTableThread.this.totalEntryCount, 32000L));
                                TabRestore.this.widgetEntryTable.setRedraw(true);
                            }
                        }
                    });
                }
                TabRestore.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!TabRestore.this.widgetEntryTableTitle.isDisposed()) {
                            TabRestore.this.widgetEntryTableTitle.setForeground((Color)null);
                            TabRestore.this.widgetEntryTableTitle.redraw();
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                TabRestore.this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean updateEntryTableItems(final int n) {
            assert (this.name != null);
            assert (n >= 0);
            assert (this.totalEntryCount >= 0L);
            final int n2 = (long)(n + 32) < this.totalEntryCount ? 32 : (int)(this.totalEntryCount - (long)n);
            final String[] stringArray = new String[]{"NAME"};
            final String[] stringArray2 = new String[]{"NONE"};
            TabRestore.this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    TableColumn tableColumn;
                    if (!TabRestore.this.widgetEntryTable.isDisposed() && (tableColumn = TabRestore.this.widgetEntryTable.getSortColumn()) != null) {
                        switch (TabRestore.this.widgetEntryTable.indexOf(tableColumn)) {
                            case 0: {
                                stringArray[0] = "NAME";
                                break;
                            }
                            case 1: {
                                stringArray[0] = "TYPE";
                                break;
                            }
                            case 2: {
                                stringArray[0] = "SIZE";
                                break;
                            }
                            case 3: {
                                stringArray[0] = "LAST_CHANGED";
                                break;
                            }
                            case 4: {
                                stringArray[0] = "FRAGMENT";
                                break;
                            }
                            default: {
                                stringArray[0] = "NAME";
                            }
                        }
                        switch (TabRestore.this.widgetEntryTable.getSortDirection()) {
                            case 128: {
                                stringArray2[0] = "ASCENDING";
                                break;
                            }
                            case 1024: {
                                stringArray2[0] = "DESCENDING";
                                break;
                            }
                            case 0: {
                                stringArray2[0] = "NONE";
                            }
                        }
                    }
                }
            });
            final int[] nArray = new int[]{0};
            TabRestore.this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!TabRestore.this.widgetEntryTable.isDisposed()) {
                        TabRestore.this.widgetEntryTable.setRedraw(false);
                    }
                }
            });
            try {
                final ArrayList arrayList = new ArrayList();
                try {
                    this.entryTableCommand = BARServer.asyncExecuteCommand(StringParser.format("INDEX_ENTRY_LIST entryType=%s name=%'S newestOnly=%y selectedOnly=no fragmentsCount=no offset=%d limit=%d sortMode=%s ordering=%s", this.entryType.toString(), this.name, this.newestOnly, n, n2, stringArray[0], stringArray2[0]), 2, new Command.ResultHandler(){

                        @Override
                        public void handle(int n6, ValueMap valueMap) {
                            int n22 = n + n6;
                            String string = valueMap.getString("jobName");
                            ArchiveTypes archiveTypes = valueMap.getEnum("archiveType", ArchiveTypes.class);
                            String string2 = valueMap.getString("hostName");
                            long l = valueMap.getLong("entryId");
                            EntryTypes entryTypes = valueMap.getEnum("entryType", EntryTypes.class);
                            switch (entryTypes) {
                                case FILE: {
                                    String string3 = valueMap.getString("name");
                                    long l2 = valueMap.getLong("dateTime");
                                    long l3 = valueMap.getLong("size");
                                    int n3 = valueMap.getInt("fragmentCount");
                                    arrayList.add(new EntryIndexData(l, string, archiveTypes, string2, EntryTypes.FILE, string3, l2, l3, n3));
                                    break;
                                }
                                case IMAGE: {
                                    String string4 = valueMap.getString("name");
                                    long l4 = valueMap.getLong("size");
                                    int n4 = valueMap.getInt("fragmentCount");
                                    arrayList.add(new EntryIndexData(l, string, archiveTypes, string2, EntryTypes.IMAGE, string4, 0L, l4, n4));
                                    break;
                                }
                                case DIRECTORY: {
                                    String string5 = valueMap.getString("name");
                                    long l5 = valueMap.getLong("dateTime");
                                    long l6 = valueMap.getLong("size");
                                    arrayList.add(new EntryIndexData(l, string, archiveTypes, string2, EntryTypes.DIRECTORY, string5, l5, l6));
                                    break;
                                }
                                case LINK: {
                                    String string6 = valueMap.getString("name");
                                    String string7 = valueMap.getString("destinationName");
                                    long l7 = valueMap.getLong("dateTime");
                                    arrayList.add(new EntryIndexData(l, string, archiveTypes, string2, EntryTypes.LINK, string6, l7));
                                    break;
                                }
                                case HARDLINK: {
                                    String string8 = valueMap.getString("name");
                                    long l8 = valueMap.getLong("dateTime");
                                    long l9 = valueMap.getLong("size");
                                    int n5 = valueMap.getInt("fragmentCount");
                                    arrayList.add(new EntryIndexData(l, string, archiveTypes, string2, EntryTypes.HARDLINK, string8, l8, l9, n5));
                                    break;
                                }
                                case SPECIAL: {
                                    String string9 = valueMap.getString("name");
                                    long l10 = valueMap.getLong("dateTime");
                                    arrayList.add(new EntryIndexData(l, string, archiveTypes, string2, EntryTypes.SPECIAL, string9, l10));
                                }
                            }
                            nArray[0] = n6 + 1;
                            if (UpdateEntryTableThread.this.isRequestUpdate() || nArray[0] > n2) {
                                this.abort();
                            }
                        }
                    });
                    BARServer.asyncCommandWait(this.entryTableCommand);
                }
                catch (Exception exception) {
                    BARControl.logThrowable(exception);
                }
                TabRestore.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!TabRestore.this.widgetEntryTable.isDisposed()) {
                            int n3 = 0;
                            int n2 = TabRestore.this.widgetEntryTable.getItemCount();
                            for (EntryIndexData entryIndexData : arrayList) {
                                TableItem tableItem;
                                if (n + n3 < n2 && !(tableItem = TabRestore.this.widgetEntryTable.getItem(n + n3)).isDisposed()) {
                                    switch (entryIndexData.entryType) {
                                        case FILE: {
                                            Widgets.updateTableItem(tableItem, entryIndexData, entryIndexData.name, entryIndexData.entryType.getText(), Units.formatByteSize(entryIndexData.size), TabRestore.this.SIMPLE_DATE_FORMAT.format(new Date(entryIndexData.dateTime * 1000L)));
                                            break;
                                        }
                                        case IMAGE: {
                                            Widgets.updateTableItem(tableItem, entryIndexData, entryIndexData.name, entryIndexData.entryType.getText(), Units.formatByteSize(entryIndexData.size), TabRestore.this.SIMPLE_DATE_FORMAT.format(new Date(entryIndexData.dateTime * 1000L)));
                                            break;
                                        }
                                        case DIRECTORY: {
                                            Widgets.updateTableItem(tableItem, entryIndexData, entryIndexData.name, entryIndexData.entryType.getText(), entryIndexData.size > 0L ? Units.formatByteSize(entryIndexData.size) : "", TabRestore.this.SIMPLE_DATE_FORMAT.format(new Date(entryIndexData.dateTime * 1000L)));
                                            break;
                                        }
                                        case LINK: {
                                            Widgets.updateTableItem(tableItem, entryIndexData, entryIndexData.name, entryIndexData.entryType.getText(), "", TabRestore.this.SIMPLE_DATE_FORMAT.format(new Date(entryIndexData.dateTime * 1000L)));
                                            break;
                                        }
                                        case HARDLINK: {
                                            Widgets.updateTableItem(tableItem, entryIndexData, entryIndexData.name, entryIndexData.entryType.getText(), Units.formatByteSize(entryIndexData.size), TabRestore.this.SIMPLE_DATE_FORMAT.format(new Date(entryIndexData.dateTime * 1000L)));
                                            break;
                                        }
                                        case SPECIAL: {
                                            Widgets.updateTableItem(tableItem, entryIndexData, entryIndexData.name, entryIndexData.entryType.getText(), Units.formatByteSize(entryIndexData.size), TabRestore.this.SIMPLE_DATE_FORMAT.format(new Date(entryIndexData.dateTime * 1000L)));
                                        }
                                    }
                                    tableItem.setChecked(TabRestore.this.checkedEntryIdSet.contains(entryIndexData.id));
                                }
                                ++n3;
                            }
                        }
                    }
                });
                TabRestore.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!TabRestore.this.widgetEntryTable.isDisposed()) {
                            TabRestore.this.widgetEntryTable.setRedraw(true);
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                TabRestore.this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            return nArray[0] >= n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateEntryTableItems(HashSet<Integer> hashSet) {
            TabRestore.this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!TabRestore.this.widgetEntryTable.isDisposed()) {
                        TabRestore.this.widgetEntryTable.setRedraw(false);
                    }
                }
            });
            try {
                Integer[] integerArray;
                for (Integer n : integerArray = hashSet.toArray(new Integer[hashSet.size()])) {
                    if (!this.updateEntryTableItems(n)) break;
                    hashSet.remove(n);
                }
                TabRestore.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!TabRestore.this.widgetEntryTable.isDisposed()) {
                            TabRestore.this.widgetEntryTable.setRedraw(true);
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                TabRestore.this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }
    }

    class EntryIndexData
    extends IndexData {
        String jobName;
        ArchiveTypes archiveType;
        String hostName;
        EntryTypes entryType;
        String name;
        long dateTime;
        long size;
        int fragmentCount;

        EntryIndexData(long l, String string, ArchiveTypes archiveTypes, String string2, EntryTypes entryTypes, String string3, long l2, long l3, int n) {
            super(l);
            assert ((l & 0xFL) >= 4L && (l & 0xFL) <= 10L) : l;
            assert (l3 >= 0L);
            assert (n >= 0);
            this.jobName = string;
            this.archiveType = archiveTypes;
            this.hostName = string2;
            this.entryType = entryTypes;
            this.name = string3;
            this.dateTime = l2;
            this.size = l3;
            this.fragmentCount = n;
        }

        EntryIndexData(long l, String string, ArchiveTypes archiveTypes, String string2, EntryTypes entryTypes, String string3, long l2, long l3) {
            this(l, string, archiveTypes, string2, entryTypes, string3, l2, l3, 0);
        }

        EntryIndexData(long l, String string, ArchiveTypes archiveTypes, String string2, EntryTypes entryTypes, String string3, long l2) {
            this(l, string, archiveTypes, string2, entryTypes, string3, l2, 0L);
        }

        @Override
        public int compareTo(EntryIndexData entryIndexData) {
            int n = this.name.compareTo(entryIndexData.name);
            if (n == 0) {
                if (this.dateTime < entryIndexData.dateTime) {
                    n = -1;
                } else if (this.dateTime > entryIndexData.dateTime) {
                    n = 1;
                }
                if (n == 0) {
                    if (this.size < entryIndexData.size) {
                        n = -1;
                    } else if (this.size > entryIndexData.size) {
                        n = 1;
                    }
                }
            }
            return n;
        }

        @Override
        public long getTotalSize() {
            return this.size;
        }

        @Override
        public long getTotalEntryCount() {
            return 1L;
        }

        @Override
        public long getTotalEntrySize() {
            return this.size;
        }

        @Override
        public String toString() {
            return "Entry {" + this.id + ", jobName=" + this.jobName + ", hostName=" + this.hostName + ", name=" + this.name + ", entryType=" + (Object)((Object)this.entryType) + ", dateTime=" + this.dateTime + ", size=" + this.size + "}";
        }
    }

    static enum RestoreStates {
        NONE,
        RUNNING,
        RESTORED,
        FAILED;

    }

    static enum EntryTypes {
        FILE,
        IMAGE,
        DIRECTORY,
        LINK,
        HARDLINK,
        SPECIAL,
        DEVICE,
        SOCKET,
        ANY;


        public boolean hasSize() {
            return this == FILE || this == IMAGE || this == HARDLINK;
        }

        public String getText() {
            switch (this) {
                case FILE: {
                    return BARControl.tr("file", new Object[0]);
                }
                case IMAGE: {
                    return BARControl.tr("image", new Object[0]);
                }
                case DIRECTORY: {
                    return BARControl.tr("directory", new Object[0]);
                }
                case LINK: {
                    return BARControl.tr("link", new Object[0]);
                }
                case HARDLINK: {
                    return BARControl.tr("hardlink", new Object[0]);
                }
                case SPECIAL: {
                    return BARControl.tr("special", new Object[0]);
                }
            }
            return "*";
        }

        public String toString() {
            switch (this) {
                case FILE: {
                    return "FILE";
                }
                case IMAGE: {
                    return "IMAGE";
                }
                case DIRECTORY: {
                    return "DIRECTORY";
                }
                case LINK: {
                    return "LINK";
                }
                case HARDLINK: {
                    return "HARDLINK";
                }
                case SPECIAL: {
                    return "SPECIAL";
                }
            }
            return "*";
        }
    }

    class UpdateStorageTreeTableThread
    extends Thread {
        private final int PAGE_SIZE = 32;
        private Object trigger = new Object();
        private boolean requestUpdateStorageCount = false;
        private HashSet<Integer> requestUpdateOffsets = new HashSet();
        private int totalStorageCount = 0;
        private long totalStorageSize = 0L;
        private Command storageTableCommand = null;
        private String storageName = "";
        private String jobUUID = null;
        private IndexStateSet storageIndexStateSet;
        private EntityStates storageEntityState;
        private boolean requestSetUpdateIndicator;

        UpdateStorageTreeTableThread() {
            this.storageIndexStateSet = TabRestore.this.INDEX_STATE_SET_ALL;
            this.storageEntityState = EntityStates.ANY;
            this.requestSetUpdateIndicator = false;
            this.setDaemon(true);
            this.setName("BARControl Update Storage");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl = true;
            final HashSet<Integer> hashSet = new HashSet<Integer>();
            boolean bl2 = true;
            try {
                while (true) {
                    Object object;
                    boolean bl3 = false;
                    if (bl2) {
                        TabRestore.this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                BARControl.waitCursor();
                                if (!TabRestore.this.widgetStorageTree.isDisposed()) {
                                    TabRestore.this.widgetStorageTree.setForeground(TabRestore.this.COLOR_MODIFIED);
                                }
                                if (!TabRestore.this.widgetStorageTable.isDisposed()) {
                                    TabRestore.this.widgetStorageTable.setForeground(TabRestore.this.COLOR_MODIFIED);
                                }
                            }
                        });
                        bl3 = true;
                    }
                    try {
                        block28: {
                            try {
                                if (bl) {
                                    this.updateStorageTableCount();
                                }
                                object = new HashSet();
                                if (!this.requestUpdateStorageCount) {
                                    this.updateUUIDTreeItems((HashSet<TreeItem>)object);
                                }
                                HashSet<TreeItem> hashSet2 = new HashSet<TreeItem>();
                                if (!this.requestUpdateStorageCount) {
                                    this.updateEntityTreeItems((HashSet<TreeItem>)object, hashSet2);
                                }
                                if (!this.requestUpdateStorageCount) {
                                    this.updateStorageTreeItems(hashSet2);
                                }
                                if (!this.requestUpdateStorageCount && !hashSet.isEmpty()) {
                                    this.updateStorageTableItems(hashSet);
                                }
                            }
                            catch (CommunicationError communicationError) {
                            }
                            catch (ConnectionError connectionError) {
                            }
                            catch (Throwable throwable) {
                                if (Settings.debugLevel <= 0) break block28;
                                BARServer.disconnect();
                                BARControl.internalError(throwable);
                            }
                        }
                        if (bl3) {
                            TabRestore.this.display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!TabRestore.this.widgetStorageTree.isDisposed()) {
                                        TabRestore.this.widgetStorageTree.setForeground((Color)null);
                                    }
                                    if (!TabRestore.this.widgetStorageTable.isDisposed()) {
                                        TabRestore.this.widgetStorageTable.setForeground((Color)null);
                                    }
                                    BARControl.resetCursor();
                                }
                            });
                        }
                    }
                    catch (Throwable throwable) {
                        if (bl3) {
                            TabRestore.this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
                        }
                        throw throwable;
                    }
                    object = this.trigger;
                    synchronized (object) {
                        if (!this.requestUpdateStorageCount && this.requestUpdateOffsets.isEmpty()) {
                            try {
                                this.trigger.wait(30000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        bl = this.requestUpdateStorageCount;
                        hashSet.addAll(this.requestUpdateOffsets);
                        bl2 = this.requestSetUpdateIndicator;
                        if (!this.requestUpdateStorageCount && this.requestUpdateOffsets.isEmpty()) {
                            bl = true;
                            bl2 = false;
                        }
                        do {
                            this.requestUpdateStorageCount = false;
                            this.requestUpdateOffsets.clear();
                            this.requestSetUpdateIndicator = false;
                            try {
                                this.trigger.wait(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            bl |= this.requestUpdateStorageCount;
                            hashSet.addAll(this.requestUpdateOffsets);
                            bl2 |= this.requestSetUpdateIndicator;
                        } while (this.requestUpdateStorageCount || !this.requestUpdateOffsets.isEmpty());
                    }
                    if (!hashSet.isEmpty()) continue;
                    TabRestore.this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!TabRestore.this.widgetStorageTable.isDisposed()) {
                                hashSet.add(TabRestore.this.widgetStorageTable.getTopIndex());
                            }
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                if (Settings.debugLevel > 0) {
                    BARServer.disconnect();
                    BARControl.internalError(throwable);
                }
                return;
            }
        }

        private int getTotalStorageCount() {
            return this.totalStorageCount;
        }

        private long getTotalStorageSize() {
            return this.totalStorageSize;
        }

        private String getStorageName() {
            return this.storageName;
        }

        private IndexStateSet getStorageIndexStateSet() {
            return this.storageIndexStateSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void triggerUpdate(String string, IndexStateSet indexStateSet, EntityStates entityStates, boolean bl) {
            assert (string != null);
            Object object = this.trigger;
            synchronized (object) {
                if (!this.storageName.equals(string) || this.storageIndexStateSet != indexStateSet || this.storageEntityState != entityStates || bl) {
                    this.storageName = string;
                    this.storageIndexStateSet = indexStateSet;
                    this.storageEntityState = entityStates;
                    this.requestUpdateStorageCount = true;
                    this.requestSetUpdateIndicator = true;
                    this.restart();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void triggerUpdateStorageName(String string) {
            assert (string != null);
            Object object = this.trigger;
            synchronized (object) {
                if (this.storageName == null || string == null || (string.length() == 0 || string.length() >= 3) && !this.storageName.equals(string)) {
                    this.storageName = string;
                    this.requestUpdateStorageCount = true;
                    this.requestSetUpdateIndicator = true;
                    this.restart();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void triggerUpdateStorageState(String string, IndexStateSet indexStateSet, EntityStates entityStates) {
            Object object = this.trigger;
            synchronized (object) {
                if (this.jobUUID != string || this.storageIndexStateSet != indexStateSet || this.storageEntityState != entityStates) {
                    this.jobUUID = string;
                    this.storageIndexStateSet = indexStateSet;
                    this.storageEntityState = entityStates;
                    this.requestUpdateStorageCount = true;
                    this.requestSetUpdateIndicator = true;
                    this.restart();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void triggerUpdate(TreeItem treeItem) {
            Object object = this.trigger;
            synchronized (object) {
                int n = treeItem.getParent().indexOf(treeItem) / 32 * 32;
                if (!this.requestUpdateOffsets.contains(n)) {
                    this.requestUpdateOffsets.add(n);
                    this.restart();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void triggerUpdate(TableItem tableItem) {
            Object object = this.trigger;
            synchronized (object) {
                int n = tableItem.getParent().indexOf(tableItem) / 32 * 32;
                if (!this.requestUpdateOffsets.contains(n)) {
                    this.requestUpdateOffsets.add(n);
                    this.restart();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void triggerUpdate(int n) {
            Object object = this.trigger;
            synchronized (object) {
                int n2 = n / 32 * 32;
                if (!this.requestUpdateOffsets.contains(n2)) {
                    this.requestUpdateOffsets.add(n2);
                    this.restart();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void triggerUpdate() {
            Object object = this.trigger;
            synchronized (object) {
                this.requestUpdateStorageCount = true;
                this.restart();
            }
        }

        private boolean isRequestUpdate() {
            return this.requestUpdateStorageCount || !this.requestUpdateOffsets.isEmpty();
        }

        private void restart() {
            if (this.requestUpdateStorageCount && this.storageTableCommand != null) {
                this.storageTableCommand.abort();
                this.storageTableCommand = null;
            }
            this.trigger.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateUUIDTreeItems(final HashSet<TreeItem> hashSet) {
            HashSet hashSet2;
            block9: {
                ArrayList arrayList;
                block8: {
                    block7: {
                        if (hashSet != null) {
                            hashSet.clear();
                        }
                        TabRestore.this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!TabRestore.this.widgetStorageTree.isDisposed()) {
                                    TabRestore.this.widgetStorageTree.setRedraw(false);
                                }
                            }
                        });
                        hashSet2 = new HashSet();
                        TabRestore.this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!TabRestore.this.widgetStorageTree.isDisposed()) {
                                    for (TreeItem treeItem : TabRestore.this.widgetStorageTree.getItems()) {
                                        assert (treeItem.getData() instanceof UUIDIndexData) : treeItem.getData();
                                        hashSet2.add(treeItem);
                                    }
                                }
                            }
                        });
                        if (!this.isRequestUpdate()) break block7;
                        TabRestore.this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!TabRestore.this.widgetStorageTree.isDisposed()) {
                                    TabRestore.this.widgetStorageTree.setRedraw(true);
                                }
                            }
                        });
                        return;
                    }
                    arrayList = new ArrayList();
                    BARServer.executeCommand(StringParser.format("INDEX_UUID_LIST indexStateSet=%s indexModeSet=* name=%'S", this.storageIndexStateSet.nameList("|"), this.storageName), 2, new Command.ResultHandler(){

                        @Override
                        public void handle(int n, ValueMap valueMap) {
                            long l = valueMap.getLong("uuidId");
                            String string = valueMap.getString("jobUUID");
                            String string2 = valueMap.getString("name");
                            long l2 = valueMap.getLong("lastExecutedDateTime");
                            int n2 = valueMap.getInt("lastErrorCode");
                            String string3 = valueMap.getString("lastErrorData");
                            long l3 = valueMap.getLong("totalSize");
                            long l4 = valueMap.getLong("totalEntryCount");
                            long l5 = valueMap.getLong("totalEntrySize", Long.MAX_VALUE);
                            IndexStates indexStates = valueMap.getEnum("maxIndexState", IndexStates.class);
                            IndexModes indexModes = valueMap.getEnum("maxIndexMode", IndexModes.class);
                            UUIDIndexData uUIDIndexData = new UUIDIndexData(l, string, string2, l2, n2, string3, l3, l4, l5, indexStates, indexModes);
                            arrayList.add(uUIDIndexData);
                            if (UpdateStorageTreeTableThread.this.isRequestUpdate()) {
                                this.abort();
                            }
                        }
                    });
                    if (!this.isRequestUpdate()) break block8;
                    TabRestore.this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
                    return;
                }
                TabRestore.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!TabRestore.this.widgetStorageTree.isDisposed()) {
                            IndexDataComparator indexDataComparator = IndexDataComparator.getInstance(TabRestore.this.widgetStorageTree);
                            for (UUIDIndexData uUIDIndexData : arrayList) {
                                TreeItem treeItem = Widgets.updateInsertTreeItem(TabRestore.this.widgetStorageTree, indexDataComparator, uUIDIndexData, 2, uUIDIndexData.name, "", "", Units.formatByteSize(uUIDIndexData.totalSize), uUIDIndexData.maxIndexState.toString());
                                Widgets.setTreeItemChecked(treeItem, TabRestore.this.checkedIndexIdSet.contains(uUIDIndexData.id));
                                if (hashSet != null && treeItem.getExpanded()) {
                                    hashSet.add(treeItem);
                                }
                                hashSet2.remove(treeItem);
                            }
                        }
                    }
                });
                if (!this.isRequestUpdate()) break block9;
                TabRestore.this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
                return;
            }
            try {
                TabRestore.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        for (TreeItem treeItem : hashSet2) {
                            if (treeItem.isDisposed()) continue;
                            Widgets.removeTreeItem(treeItem);
                        }
                    }
                });
                TabRestore.this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
            }
            catch (Exception exception) {
                TabRestore.this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
            }
            catch (Throwable throwable) {
                TabRestore.this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }

        private void updateEntityTreeItem(final TreeItem treeItem, final HashSet<TreeItem> hashSet) {
            try {
                final UUIDIndexData[] uUIDIndexDataArray = new UUIDIndexData[]{null};
                final HashSet hashSet2 = new HashSet();
                TabRestore.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!treeItem.isDisposed()) {
                            assert (treeItem.getData() instanceof UUIDIndexData) : treeItem.getData();
                            uUIDIndexDataArray[0] = (UUIDIndexData)treeItem.getData();
                            if (treeItem.getExpanded()) {
                                for (TreeItem treeItem2 : treeItem.getItems()) {
                                    assert (treeItem2.getData() instanceof EntityIndexData) : treeItem2.getData();
                                    hashSet2.add(treeItem2);
                                }
                            }
                        }
                    }
                });
                if (this.isRequestUpdate()) {
                    return;
                }
                final ArrayList arrayList = new ArrayList();
                BARServer.executeCommand(StringParser.format("INDEX_ENTITY_LIST jobUUID=%'S indexStateSet=%s indexModeSet=* name=%'S", uUIDIndexDataArray[0].jobUUID, this.storageIndexStateSet.nameList("|"), this.storageName), 2, new Command.ResultHandler(){

                    @Override
                    public void handle(int n, ValueMap valueMap) {
                        long l = valueMap.getLong("entityId");
                        String string = valueMap.getString("jobUUID");
                        String string2 = valueMap.getString("scheduleUUID");
                        ArchiveTypes archiveTypes = valueMap.getEnum("archiveType", ArchiveTypes.class);
                        long l2 = valueMap.getLong("createdDateTime");
                        int n2 = valueMap.getInt("lastErrorCode");
                        String string3 = valueMap.getString("lastErrorData");
                        long l3 = valueMap.getLong("totalSize", 0L);
                        long l4 = valueMap.getLong("totalEntryCount", 0L);
                        long l5 = valueMap.getLong("totalEntrySize", 0L);
                        IndexStates indexStates = valueMap.getEnum("maxIndexState", IndexStates.class);
                        IndexModes indexModes = valueMap.getEnum("maxIndexMode", IndexModes.class);
                        long l6 = valueMap.getLong("expireDateTime");
                        EntityIndexData entityIndexData = new EntityIndexData(l, string, string2, archiveTypes, l2, n2, string3, l3, l4, l5, indexStates, indexModes, l6);
                        arrayList.add(entityIndexData);
                        if (UpdateStorageTreeTableThread.this.isRequestUpdate()) {
                            this.abort();
                        }
                    }
                });
                if (this.isRequestUpdate()) {
                    return;
                }
                TabRestore.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!treeItem.isDisposed()) {
                            IndexDataComparator indexDataComparator = IndexDataComparator.getInstance(IndexDataComparator.SortModes.CREATED_DATETIME);
                            for (EntityIndexData entityIndexData : arrayList) {
                                assert (entityIndexData != null);
                                TreeItem treeItem2 = Widgets.updateInsertTreeItem(treeItem, indexDataComparator, entityIndexData, 2, entityIndexData.archiveType.toString(), "", "", Units.formatByteSize(entityIndexData.totalSize), entityIndexData.maxIndexState.toString());
                                Widgets.setTreeItemChecked(treeItem2, TabRestore.this.checkedIndexIdSet.contains(entityIndexData.id));
                                if (hashSet != null && treeItem2.getExpanded()) {
                                    hashSet.add(treeItem2);
                                }
                                hashSet2.remove(treeItem2);
                            }
                        }
                    }
                });
                if (this.isRequestUpdate()) {
                    return;
                }
                TabRestore.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        for (TreeItem treeItem : hashSet2) {
                            if (treeItem.isDisposed()) continue;
                            IndexData indexData = (IndexData)treeItem.getData();
                            Widgets.removeTreeItem(treeItem);
                            if (indexData == null) continue;
                            TabRestore.this.setStorageList(indexData.id, false);
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void updateEntityTreeItem(TreeItem treeItem) {
            TabRestore.this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    BARControl.waitCursor();
                    if (!TabRestore.this.widgetStorageTree.isDisposed()) {
                        TabRestore.this.widgetStorageTree.setRedraw(false);
                    }
                }
            });
            try {
                this.updateEntityTreeItem(treeItem, null);
                TabRestore.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!TabRestore.this.widgetStorageTree.isDisposed()) {
                            TabRestore.this.widgetStorageTree.setRedraw(true);
                        }
                        BARControl.resetCursor();
                    }
                });
            }
            catch (Throwable throwable) {
                TabRestore.this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateEntityTreeItems(HashSet<TreeItem> hashSet, HashSet<TreeItem> hashSet2) {
            hashSet2.clear();
            TabRestore.this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    BARControl.waitCursor();
                    if (!TabRestore.this.widgetStorageTree.isDisposed()) {
                        TabRestore.this.widgetStorageTree.setRedraw(false);
                    }
                }
            });
            try {
                for (TreeItem treeItem : hashSet) {
                    this.updateEntityTreeItem(treeItem, hashSet2);
                }
                TabRestore.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!TabRestore.this.widgetStorageTree.isDisposed()) {
                            TabRestore.this.widgetStorageTree.setRedraw(true);
                        }
                        BARControl.resetCursor();
                    }
                });
            }
            catch (Throwable throwable) {
                TabRestore.this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }

        private void updateStorageTreeItem(final TreeItem treeItem) {
            block5: {
                try {
                    final EntityIndexData[] entityIndexDataArray = new EntityIndexData[1];
                    final HashSet hashSet = new HashSet();
                    TabRestore.this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!treeItem.isDisposed()) {
                                assert (treeItem.getData() instanceof EntityIndexData) : treeItem.getData();
                                entityIndexDataArray[0] = (EntityIndexData)treeItem.getData();
                                if (treeItem.getExpanded()) {
                                    for (TreeItem treeItem2 : treeItem.getItems()) {
                                        assert (treeItem2.getData() instanceof StorageIndexData) : treeItem2.getData();
                                        hashSet.add(treeItem2);
                                    }
                                }
                            }
                        }
                    });
                    if (this.isRequestUpdate()) {
                        return;
                    }
                    final ArrayList arrayList = new ArrayList();
                    BARServer.executeCommand(StringParser.format("INDEX_STORAGE_LIST entityId=%ld jobUUID=%'S indexStateSet=%s indexModeSet=* name=%'S", entityIndexDataArray[0].id, this.jobUUID != null ? this.jobUUID : "*", this.storageIndexStateSet.nameList("|"), this.storageName), 2, new Command.ResultHandler(){

                        @Override
                        public void handle(int n, ValueMap valueMap) {
                            long l = valueMap.getLong("storageId");
                            String string = valueMap.getString("jobUUID");
                            String string2 = valueMap.getString("jobName");
                            long l2 = valueMap.getLong("entityId");
                            String string3 = valueMap.getString("scheduleUUID");
                            String string4 = valueMap.getString("hostName");
                            long l3 = valueMap.getLong("createdDateTime");
                            ArchiveTypes archiveTypes = valueMap.getEnum("archiveType", ArchiveTypes.class);
                            String string5 = valueMap.getString("name");
                            long l4 = valueMap.getLong("dateTime");
                            long l5 = valueMap.getLong("size");
                            IndexStates indexStates = valueMap.getEnum("indexState", IndexStates.class);
                            IndexModes indexModes = valueMap.getEnum("indexMode", IndexModes.class);
                            long l6 = valueMap.getLong("lastCheckedDateTime");
                            String string6 = valueMap.getString("errorMessage");
                            long l7 = valueMap.getLong("totalEntryCount");
                            long l8 = valueMap.getLong("totalEntrySize", Long.MAX_VALUE);
                            arrayList.add(new StorageIndexData(l, string, string2, l2, string4, l3, archiveTypes, string5, l4, l5, indexStates, indexModes, l6, string6, l7, l8));
                            if (UpdateStorageTreeTableThread.this.isRequestUpdate()) {
                                this.abort();
                            }
                        }
                    });
                    if (this.isRequestUpdate()) {
                        return;
                    }
                    TabRestore.this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!TabRestore.this.widgetStorageTree.isDisposed()) {
                                IndexDataComparator indexDataComparator = IndexDataComparator.getInstance(TabRestore.this.widgetStorageTree);
                                for (StorageIndexData storageIndexData : arrayList) {
                                    if (treeItem.isDisposed()) continue;
                                    TreeItem treeItem2 = Widgets.updateInsertTreeItem(treeItem, indexDataComparator, storageIndexData, 0, storageIndexData.name, storageIndexData.hostName, "", Units.formatByteSize(storageIndexData.size), storageIndexData.indexState.toString());
                                    hashSet.remove(treeItem2);
                                }
                            }
                        }
                    });
                    if (this.isRequestUpdate()) {
                        return;
                    }
                    TabRestore.this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            for (TreeItem treeItem : hashSet) {
                                if (treeItem.isDisposed()) continue;
                                IndexData indexData = (IndexData)treeItem.getData();
                                Widgets.removeTreeItem(treeItem);
                                if (indexData == null) continue;
                                TabRestore.this.setStorageList(indexData.id, false);
                            }
                        }
                    });
                }
                catch (Throwable throwable) {
                    if (Settings.debugLevel <= 0) break block5;
                    BARServer.disconnect();
                    BARControl.internalError(throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateStorageTreeItems(HashSet<TreeItem> hashSet) {
            TabRestore.this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    BARControl.waitCursor();
                    if (!TabRestore.this.widgetStorageTree.isDisposed()) {
                        TabRestore.this.widgetStorageTree.setRedraw(false);
                    }
                }
            });
            try {
                for (TreeItem treeItem : hashSet) {
                    this.updateStorageTreeItem(treeItem);
                }
                TabRestore.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!TabRestore.this.widgetStorageTree.isDisposed()) {
                            TabRestore.this.widgetStorageTree.setRedraw(true);
                        }
                        BARControl.resetCursor();
                    }
                });
            }
            catch (Throwable throwable) {
                TabRestore.this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }

        private void updateTreeItem(TreeItem treeItem) {
            TabRestore.this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    BARControl.waitCursor();
                    if (!TabRestore.this.widgetStorageTree.isDisposed()) {
                        TabRestore.this.widgetStorageTree.setRedraw(false);
                    }
                }
            });
            try {
                if (treeItem.getData() instanceof UUIDIndexData) {
                    this.updateEntityTreeItem(treeItem, null);
                } else if (treeItem.getData() instanceof EntityIndexData) {
                    this.updateStorageTreeItem(treeItem);
                }
                TabRestore.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!TabRestore.this.widgetStorageTree.isDisposed()) {
                            TabRestore.this.widgetStorageTree.setRedraw(true);
                        }
                        BARControl.resetCursor();
                    }
                });
            }
            catch (Throwable throwable) {
                TabRestore.this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }

        private void updateStorageTableCount() {
            assert (this.storageName != null);
            int n = this.totalStorageCount;
            TabRestore.this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!TabRestore.this.widgetStorageTabFolderTitle.isDisposed()) {
                        TabRestore.this.widgetStorageTabFolderTitle.setForeground(TabRestore.this.COLOR_MODIFIED);
                        TabRestore.this.widgetStorageTabFolderTitle.redraw();
                    }
                }
            });
            try {
                ValueMap valueMap = new ValueMap();
                BARServer.executeCommand(StringParser.format("INDEX_STORAGE_LIST_INFO entityId=%s jobUUID=%'S indexTypeSet=UUID|ENTITY indexStateSet=%s indexModeSet=* name=%'S", this.storageEntityState != EntityStates.NONE ? "*" : "NONE", this.jobUUID != null ? this.jobUUID : "*", this.storageIndexStateSet.nameList("|"), this.storageName), 2, valueMap);
                this.totalStorageCount = valueMap.getInt("totalStorageCount", 0);
                this.totalStorageSize = valueMap.getLong("totalStorageSize", 0L);
                assert (this.totalStorageCount >= 0);
                assert (this.totalStorageSize >= 0L);
                TabRestore.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!TabRestore.this.widgetStorageTabFolderTitle.isDisposed()) {
                            TabRestore.this.widgetStorageTabFolderTitle.setForeground((Color)null);
                            TabRestore.this.widgetStorageTabFolderTitle.redraw();
                        }
                        if (!TabRestore.this.widgetStorageTable.isDisposed()) {
                            TabRestore.this.widgetStorageTable.setRedraw(false);
                            TabRestore.this.widgetStorageTable.clearAll();
                            TabRestore.this.widgetStorageTable.setItemCount(UpdateStorageTreeTableThread.this.totalStorageCount);
                            TabRestore.this.widgetStorageTable.setRedraw(true);
                        }
                    }
                });
            }
            catch (Exception exception) {
                try {
                    this.totalStorageCount = 0;
                    this.totalStorageSize = 0L;
                    TabRestore.this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
                }
                catch (Throwable throwable) {
                    TabRestore.this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean updateStorageTableItems(final int n) {
            assert (this.storageName != null);
            assert (n >= 0);
            assert (this.totalStorageCount >= 0);
            final int n2 = n + 32 < this.totalStorageCount ? 32 : this.totalStorageCount - n;
            final String[] stringArray = new String[]{"NAME"};
            final String[] stringArray2 = new String[]{"NONE"};
            TabRestore.this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    TableColumn tableColumn;
                    if (!TabRestore.this.widgetStorageTable.isDisposed() && (tableColumn = TabRestore.this.widgetStorageTable.getSortColumn()) != null) {
                        switch (TabRestore.this.widgetStorageTable.indexOf(tableColumn)) {
                            case 0: {
                                stringArray[0] = "NAME";
                                break;
                            }
                            case 1: {
                                stringArray[0] = "HOSTNAME";
                                break;
                            }
                            case 2: {
                                stringArray[0] = "SIZE";
                                break;
                            }
                            case 3: {
                                stringArray[0] = "MODIFIED";
                                break;
                            }
                            case 4: {
                                stringArray[0] = "STATE";
                                break;
                            }
                            default: {
                                stringArray[0] = "NAME";
                            }
                        }
                        switch (TabRestore.this.widgetStorageTable.getSortDirection()) {
                            case 128: {
                                stringArray2[0] = "ASCENDING";
                                break;
                            }
                            case 1024: {
                                stringArray2[0] = "DESCENDING";
                                break;
                            }
                            case 0: {
                                stringArray2[0] = "NONE";
                            }
                        }
                    }
                }
            });
            final int[] nArray = new int[]{0};
            TabRestore.this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!TabRestore.this.widgetStorageTable.isDisposed()) {
                        TabRestore.this.widgetStorageTable.setRedraw(false);
                    }
                }
            });
            try {
                final ArrayList arrayList = new ArrayList();
                try {
                    this.storageTableCommand = BARServer.asyncExecuteCommand(StringParser.format("INDEX_STORAGE_LIST entityId=%s jobUUID=%'S indexTypeSet=UUID|ENTITY indexStateSet=%s indexModeSet=* name=%'S offset=%d limit=%d sortMode=%s ordering=%s", this.storageEntityState != EntityStates.NONE ? "*" : "NONE", this.jobUUID != null ? this.jobUUID : "*", this.storageIndexStateSet.nameList("|"), this.storageName, n, n2, stringArray[0], stringArray2[0]), 2, new Command.ResultHandler(){

                        @Override
                        public void handle(int n, ValueMap valueMap) {
                            long l = valueMap.getLong("storageId");
                            String string = valueMap.getString("jobUUID");
                            String string2 = valueMap.getString("jobName");
                            long l2 = valueMap.getLong("entityId");
                            String string3 = valueMap.getString("hostName");
                            long l3 = valueMap.getLong("createdDateTime");
                            ArchiveTypes archiveTypes = valueMap.getEnum("archiveType", ArchiveTypes.class, ArchiveTypes.NORMAL);
                            String string4 = valueMap.getString("name");
                            long l4 = valueMap.getLong("dateTime");
                            long l5 = valueMap.getLong("size");
                            IndexStates indexStates = valueMap.getEnum("indexState", IndexStates.class);
                            IndexModes indexModes = valueMap.getEnum("indexMode", IndexModes.class);
                            long l6 = valueMap.getLong("lastCheckedDateTime");
                            String string5 = valueMap.getString("errorMessage");
                            long l7 = valueMap.getLong("totalEntryCount");
                            long l8 = valueMap.getLong("totalEntrySize", Long.MAX_VALUE);
                            arrayList.add(new StorageIndexData(l, string, string2, l2, string3, l3, archiveTypes, string4, l4, l5, indexStates, indexModes, l6, string5, l7, l8));
                            nArray[0] = n + 1;
                            if (UpdateStorageTreeTableThread.this.isRequestUpdate() || nArray[0] > n2) {
                                this.abort();
                            }
                        }
                    });
                    BARServer.asyncCommandWait(this.storageTableCommand);
                    this.storageTableCommand = null;
                }
                catch (Exception exception) {
                    BARControl.logThrowable(exception);
                }
                TabRestore.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!TabRestore.this.widgetStorageTable.isDisposed()) {
                            int n3 = 0;
                            int n2 = TabRestore.this.widgetStorageTable.getItemCount();
                            for (StorageIndexData storageIndexData : arrayList) {
                                TableItem tableItem;
                                if (n + n3 < n2 && !(tableItem = TabRestore.this.widgetStorageTable.getItem(n + n3)).isDisposed()) {
                                    Widgets.updateTableItem(tableItem, storageIndexData, storageIndexData.name, storageIndexData.hostName, Units.formatByteSize(storageIndexData.totalEntrySize), "", storageIndexData.indexState.toString());
                                    tableItem.setChecked(TabRestore.this.checkedIndexIdSet.contains(storageIndexData.id));
                                    tableItem.setBackground(storageIndexData.jobUUID.isEmpty() ? TabRestore.this.COLOR_NO_JOB_INFO : null);
                                }
                                ++n3;
                            }
                        }
                    }
                });
                TabRestore.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!TabRestore.this.widgetStorageTable.isDisposed()) {
                            TabRestore.this.widgetStorageTable.setRedraw(true);
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                TabRestore.this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            return nArray[0] >= n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateStorageTableItems(HashSet<Integer> hashSet) {
            try {
                Integer[] integerArray;
                TabRestore.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!TabRestore.this.widgetStorageTable.isDisposed()) {
                            TabRestore.this.widgetStorageTable.setRedraw(false);
                        }
                    }
                });
                for (Integer n : integerArray = hashSet.toArray(new Integer[hashSet.size()])) {
                    if (!this.updateStorageTableItems(n)) break;
                    hashSet.remove(n);
                }
                TabRestore.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!TabRestore.this.widgetStorageTable.isDisposed()) {
                            TabRestore.this.widgetStorageTable.setRedraw(true);
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                TabRestore.this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }

        static /* synthetic */ IndexStateSet access$8800(UpdateStorageTreeTableThread updateStorageTreeTableThread) {
            return updateStorageTreeTableThread.getStorageIndexStateSet();
        }

        static /* synthetic */ String access$8900(UpdateStorageTreeTableThread updateStorageTreeTableThread) {
            return updateStorageTreeTableThread.getStorageName();
        }
    }

    static enum RestoreEntryModes {
        STOP,
        RENAME,
        OVERWRITE,
        SKIP_EXISTING;

    }

    static enum RestoreTypes {
        ARCHIVES,
        ENTRIES;

    }

    class AssignToData {
        public String jobUUID;
        public String scheduleUUID;
        public String date;
        public String weekDays;
        public String time;
        public String customText;
        public boolean enabled;

        public AssignToData(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
            this.jobUUID = string;
            this.scheduleUUID = string2;
            this.date = string3;
            this.weekDays = string4;
            this.time = string5;
            this.customText = string6;
            this.enabled = bl;
        }

        public AssignToData(String string) {
            this(string, null, null, null, null, null, false);
        }
    }

    class StorageIndexData
    extends IndexData
    implements Serializable {
        public String jobUUID;
        public String jobName;
        public long entityId;
        public String hostName;
        public long createdDateTime;
        public ArchiveTypes archiveType;
        public String name;
        public long dateTime;
        private long size;
        public IndexStates indexState;
        public IndexModes indexMode;
        public long lastCheckedDateTime;
        public String errorMessage;
        private long totalEntryCount;
        private long totalEntrySize;
        private final IndexData.TreeItemUpdateRunnable treeItemUpdateRunnable;
        private final IndexData.TableItemUpdateRunnable tableItemUpdateRunnable;

        StorageIndexData(long l, String string, String string2, long l2, String string3, long l3, ArchiveTypes archiveTypes, String string4, long l4, long l5, IndexStates indexStates, IndexModes indexModes, long l6, String string5, long l7, long l8) {
            super(l);
            this.treeItemUpdateRunnable = new IndexData.TreeItemUpdateRunnable(){

                @Override
                protected void update(TreeItem treeItem, IndexData indexData) {
                    StorageIndexData storageIndexData = (StorageIndexData)indexData;
                    Widgets.updateTreeItem(treeItem, storageIndexData, storageIndexData.name, "", Units.formatByteSize(storageIndexData.size), storageIndexData.indexState.toString());
                }
            };
            this.tableItemUpdateRunnable = new IndexData.TableItemUpdateRunnable(){

                @Override
                protected void update(TableItem tableItem, IndexData indexData) {
                    StorageIndexData storageIndexData = (StorageIndexData)indexData;
                    Widgets.updateTableItem(tableItem, storageIndexData, storageIndexData.name, "", Units.formatByteSize(storageIndexData.totalEntrySize), storageIndexData.indexState.toString());
                }
            };
            assert ((l & 0xFL) == 3L) : l;
            assert ((l2 & 0xFL) == 2L) : l2;
            assert (l7 >= 0L);
            assert (l8 >= 0L);
            this.jobUUID = string;
            this.jobName = string2;
            this.entityId = l2;
            this.hostName = string3;
            this.createdDateTime = l3;
            this.archiveType = archiveTypes;
            this.name = string4;
            this.dateTime = l4;
            this.size = l5;
            this.indexState = indexStates;
            this.indexMode = indexModes;
            this.lastCheckedDateTime = l6;
            this.errorMessage = string5;
            this.totalEntryCount = l7;
            this.totalEntrySize = l8;
        }

        StorageIndexData(long l, String string, String string2, String string3, ArchiveTypes archiveTypes, String string4, long l2, long l3) {
            this(l, string, string2, 0L, string3, 0L, archiveTypes, string4, l2, 0L, IndexStates.OK, IndexModes.MANUAL, l3, null, 0L, 0L);
        }

        StorageIndexData(long l, String string, String string2, String string3, ArchiveTypes archiveTypes, String string4) {
            this(l, string, string2, string3, archiveTypes, string4, 0L, 0L);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public long getDateTime() {
            return this.createdDateTime;
        }

        @Override
        public long getTotalSize() {
            return this.size;
        }

        @Override
        public long getTotalEntryCount() {
            return this.totalEntryCount;
        }

        @Override
        public long getTotalEntrySize() {
            return this.totalEntrySize;
        }

        @Override
        public IndexStates getState() {
            return this.indexState;
        }

        @Override
        public String getInfo() {
            return String.format("#%d '%s', '%s'", this.id, !this.jobName.isEmpty() ? this.jobName : "unknown", this.name);
        }

        @Override
        public void setState(IndexStates indexStates) {
            this.indexState = indexStates;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            ((IndexData)this).writeObject(objectOutputStream);
            objectOutputStream.writeObject(this.jobName);
            objectOutputStream.writeObject((Object)this.archiveType);
            objectOutputStream.writeObject(this.hostName);
            objectOutputStream.writeObject(this.name);
            objectOutputStream.writeObject(this.createdDateTime);
            objectOutputStream.writeObject(this.size);
            objectOutputStream.writeObject((Object)this.indexState);
            objectOutputStream.writeObject((Object)this.indexMode);
            objectOutputStream.writeObject(this.lastCheckedDateTime);
            objectOutputStream.writeObject(this.totalEntryCount);
            objectOutputStream.writeObject(this.totalEntrySize);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            ((IndexData)this).readObject(objectInputStream);
            this.jobName = (String)objectInputStream.readObject();
            this.archiveType = (ArchiveTypes)((Object)objectInputStream.readObject());
            this.hostName = (String)objectInputStream.readObject();
            this.name = (String)objectInputStream.readObject();
            this.createdDateTime = (Long)objectInputStream.readObject();
            this.size = (Long)objectInputStream.readObject();
            this.indexState = (IndexStates)((Object)objectInputStream.readObject());
            this.indexMode = (IndexModes)((Object)objectInputStream.readObject());
            this.lastCheckedDateTime = (Long)objectInputStream.readObject();
            this.totalEntryCount = (Long)objectInputStream.readObject();
            this.totalEntrySize = (Long)objectInputStream.readObject();
        }

        @Override
        public String toString() {
            return "StorageIndexData {" + this.id + ", hostName=" + this.hostName + ", name=" + this.name + ", createdDateTime=" + this.createdDateTime + ", size=" + this.size + " bytes, state=" + (Object)((Object)this.indexState) + ", last checked=" + this.lastCheckedDateTime + ", totalEntryCount=" + this.totalEntryCount + " bytes, totalEntrySize=" + this.totalEntrySize + " bytes}";
        }
    }

    class EntityIndexData
    extends IndexData {
        public String jobUUID;
        public String scheduleUUID;
        public ArchiveTypes archiveType;
        public long createdDateTime;
        public int lastErrorCode;
        public String lastErrorData;
        public long totalSize;
        public long totalEntryCount;
        public long totalEntrySize;
        public IndexStates maxIndexState;
        public IndexModes maxIndexMode;
        public long expireDateTime;
        private final IndexData.TreeItemUpdateRunnable treeItemUpdateRunnable;
        private final IndexData.MenuItemUpdateRunnable menuItemUpdateRunnable;

        EntityIndexData(long l, String string, String string2, ArchiveTypes archiveTypes, long l2, int n, String string3, long l3, long l4, long l5, IndexStates indexStates, IndexModes indexModes, long l6) {
            super(l);
            this.treeItemUpdateRunnable = new IndexData.TreeItemUpdateRunnable(){

                @Override
                protected void update(TreeItem treeItem, IndexData indexData) {
                    EntityIndexData entityIndexData = (EntityIndexData)indexData;
                    Widgets.updateTreeItem(treeItem, entityIndexData, entityIndexData.archiveType.toString(), "", Units.formatByteSize(entityIndexData.totalSize), entityIndexData.maxIndexState.toString());
                }
            };
            this.menuItemUpdateRunnable = new IndexData.MenuItemUpdateRunnable(){

                @Override
                protected void update(MenuItem menuItem, IndexData indexData) {
                    EntityIndexData entityIndexData = (EntityIndexData)indexData;
                    Dprintf.dprintf("");
                }
            };
            assert ((l & 0xFL) == 2L) : l;
            assert (l4 >= 0L);
            assert (l5 >= 0L);
            this.jobUUID = string;
            this.scheduleUUID = string2;
            this.archiveType = archiveTypes;
            this.createdDateTime = l2;
            this.lastErrorCode = n;
            this.lastErrorData = string3;
            this.totalSize = l3;
            this.totalEntryCount = l4;
            this.totalEntrySize = l5;
            this.maxIndexState = indexStates;
            this.maxIndexMode = indexModes;
            this.expireDateTime = l6;
        }

        @Override
        public int compareTo(EntityIndexData entityIndexData) {
            int n = this.jobUUID.compareTo(entityIndexData.jobUUID);
            if (n == 0) {
                n = this.scheduleUUID.compareTo(entityIndexData.scheduleUUID);
            }
            return n;
        }

        @Override
        public String getName() {
            return this.archiveType.toString();
        }

        @Override
        public long getDateTime() {
            return this.createdDateTime;
        }

        @Override
        public long getTotalSize() {
            return this.totalSize;
        }

        @Override
        public long getTotalEntryCount() {
            return this.totalEntryCount;
        }

        @Override
        public long getTotalEntrySize() {
            return this.totalEntrySize;
        }

        public void setMenuItem(MenuItem menuItem) {
            this.setMenuItem(menuItem, this.menuItemUpdateRunnable);
        }

        @Override
        public String getInfo() {
            return String.format("#%d %s", this.id, this.archiveType.toString());
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            ((IndexData)this).writeObject(objectOutputStream);
            objectOutputStream.writeObject(this.jobUUID);
            objectOutputStream.writeObject(this.scheduleUUID);
            objectOutputStream.writeObject((Object)this.archiveType);
            objectOutputStream.writeObject(this.createdDateTime);
            objectOutputStream.writeObject(this.lastErrorCode);
            objectOutputStream.writeObject(this.lastErrorData);
            objectOutputStream.writeObject(this.totalSize);
            objectOutputStream.writeObject(this.totalEntryCount);
            objectOutputStream.writeObject(this.totalEntrySize);
            objectOutputStream.writeObject((Object)this.maxIndexState);
            objectOutputStream.writeObject((Object)this.maxIndexMode);
            objectOutputStream.writeObject(this.expireDateTime);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            ((IndexData)this).readObject(objectInputStream);
            this.jobUUID = (String)objectInputStream.readObject();
            this.scheduleUUID = (String)objectInputStream.readObject();
            this.archiveType = (ArchiveTypes)((Object)objectInputStream.readObject());
            this.createdDateTime = (Long)objectInputStream.readObject();
            this.lastErrorCode = (Integer)objectInputStream.readObject();
            this.lastErrorData = (String)objectInputStream.readObject();
            this.totalSize = (Long)objectInputStream.readObject();
            this.totalEntryCount = (Long)objectInputStream.readObject();
            this.totalEntrySize = (Long)objectInputStream.readObject();
            this.maxIndexState = (IndexStates)((Object)objectInputStream.readObject());
            this.maxIndexMode = (IndexModes)((Object)objectInputStream.readObject());
            this.expireDateTime = (Long)objectInputStream.readObject();
        }

        @Override
        public String toString() {
            return "EntityIndexData {" + this.id + ", archiveType=" + this.archiveType.toString() + ", jobUUID=" + this.jobUUID + ", scheduleUUID=" + this.scheduleUUID + ", createdDateTime=" + this.createdDateTime + ", totalSize=" + this.totalSize + " bytes, totalEntrySize=" + this.totalEntrySize + " bytes, max. state=" + (Object)((Object)this.maxIndexState) + ",expireDateTime=" + this.expireDateTime + "}";
        }
    }

    class UUIDIndexData
    extends IndexData {
        public String jobUUID;
        public String scheduleUUID;
        public String name;
        public long lastExecutedDateTime;
        public int lastErrorCode;
        public String lastErrorData;
        public long totalSize;
        public long totalEntryCount;
        public long totalEntrySize;
        public IndexStates maxIndexState;
        public IndexModes maxIndexMode;
        private final IndexData.TreeItemUpdateRunnable treeItemUpdateRunnable;
        private final IndexData.MenuItemUpdateRunnable menuItemUpdateRunnable;

        UUIDIndexData(long l, String string, String string2, String string3, long l2, int n, String string4, long l3, long l4, long l5, IndexStates indexStates, IndexModes indexModes) {
            super(l);
            this.treeItemUpdateRunnable = new IndexData.TreeItemUpdateRunnable(){

                @Override
                protected void update(TreeItem treeItem, IndexData indexData) {
                    UUIDIndexData uUIDIndexData = (UUIDIndexData)indexData;
                    Widgets.updateTreeItem(treeItem, uUIDIndexData, uUIDIndexData.name, "", Units.formatByteSize(uUIDIndexData.totalSize), uUIDIndexData.maxIndexState.toString());
                }
            };
            this.menuItemUpdateRunnable = new IndexData.MenuItemUpdateRunnable(){

                @Override
                protected void update(MenuItem menuItem, IndexData indexData) {
                    UUIDIndexData uUIDIndexData = (UUIDIndexData)indexData;
                    menuItem.setText(uUIDIndexData.name);
                }
            };
            assert (l == 0L || (l & 0xFL) == 1L) : l;
            assert (l3 >= 0L);
            assert (l4 >= 0L);
            assert (l5 >= 0L);
            this.jobUUID = string;
            this.scheduleUUID = string2;
            this.name = string3;
            this.lastExecutedDateTime = l2;
            this.lastErrorCode = n;
            this.lastErrorData = string4;
            this.totalSize = l3;
            this.totalEntryCount = l4;
            this.totalEntrySize = l5;
            this.maxIndexState = indexStates;
            this.maxIndexMode = indexModes;
        }

        UUIDIndexData(long l, String string, String string2, long l2, int n, String string3, long l3, long l4, long l5, IndexStates indexStates, IndexModes indexModes) {
            this(l, string, null, string2, l2, n, string3, l3, l4, l5, indexStates, indexModes);
        }

        protected void update(UUIDIndexData uUIDIndexData) {
            super.update(uUIDIndexData);
            this.jobUUID = uUIDIndexData.jobUUID;
            this.scheduleUUID = uUIDIndexData.scheduleUUID;
            this.name = uUIDIndexData.name;
            this.lastExecutedDateTime = uUIDIndexData.lastExecutedDateTime;
            this.lastErrorCode = uUIDIndexData.lastErrorCode;
            this.lastErrorData = uUIDIndexData.lastErrorData;
            this.totalSize = uUIDIndexData.totalSize;
            this.totalEntryCount = uUIDIndexData.totalEntryCount;
            this.totalEntrySize = uUIDIndexData.totalEntrySize;
            this.maxIndexState = uUIDIndexData.maxIndexState;
            this.maxIndexMode = uUIDIndexData.maxIndexMode;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public long getDateTime() {
            return this.lastExecutedDateTime;
        }

        @Override
        public long getTotalSize() {
            return this.totalSize;
        }

        @Override
        public long getTotalEntryCount() {
            return this.totalEntryCount;
        }

        @Override
        public long getTotalEntrySize() {
            return this.totalEntrySize;
        }

        public void setMenuItem(MenuItem menuItem) {
            this.setMenuItem(menuItem, this.menuItemUpdateRunnable);
        }

        @Override
        public String getInfo() {
            return String.format("#%d '%s'", this.id, !this.name.isEmpty() ? this.name : "unknown");
        }

        @Override
        public int compareTo(UUIDIndexData uUIDIndexData) {
            int n = this.name.compareTo(uUIDIndexData.name);
            if (n == 0 && (n = this.jobUUID.compareTo(uUIDIndexData.jobUUID)) == 0) {
                n = this.scheduleUUID.compareTo(uUIDIndexData.scheduleUUID);
            }
            return n;
        }

        @Override
        public String toString() {
            return "UUIDIndexData {" + this.id + ", jobUUID=" + this.jobUUID + ", scheduleUUID=" + this.scheduleUUID + ", name=" + this.name + ", lastExecutedDateTime=" + this.lastExecutedDateTime + ", totalEntryCount=" + this.totalEntryCount + ", totalEntrySize=" + this.totalEntrySize + " bytes, state=" + (Object)((Object)this.maxIndexState) + "}";
        }
    }

    static class IndexDataTransfer
    extends ByteArrayTransfer {
        private static final String NAME = "IndexData";
        private static final int ID = IndexDataTransfer.registerType("IndexData");
        private static IndexDataTransfer instance = new IndexDataTransfer();

        IndexDataTransfer() {
        }

        public static IndexDataTransfer getInstance() {
            return instance;
        }

        @Override
        public void javaToNative(Object object, TransferData transferData) {
            block3: {
                if (!this.validate(object) || !this.isSupportedType(transferData)) {
                    DND.error(2003);
                }
                HashSet hashSet = (HashSet)object;
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                    objectOutputStream.writeObject(hashSet);
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    objectOutputStream.close();
                    super.javaToNative(byArray, transferData);
                }
                catch (IOException iOException) {
                    if (Settings.debugLevel <= 0) break block3;
                    BARControl.printStackTrace(iOException);
                }
            }
        }

        @Override
        public Object nativeToJava(TransferData transferData) {
            if (this.isSupportedType(transferData)) {
                byte[] byArray = (byte[])super.nativeToJava(transferData);
                if (byArray == null) {
                    return null;
                }
                Object var3_3 = null;
                HashSet hashSet = new HashSet();
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                    hashSet = (HashSet)objectInputStream.readObject();
                    objectInputStream.close();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (Settings.debugLevel > 0) {
                        BARControl.printStackTrace(classNotFoundException);
                    }
                    return null;
                }
                catch (IOException iOException) {
                    if (Settings.debugLevel > 0) {
                        BARControl.printStackTrace(iOException);
                    }
                    return null;
                }
                return hashSet;
            }
            return null;
        }

        @Override
        protected String[] getTypeNames() {
            return new String[]{NAME};
        }

        @Override
        protected int[] getTypeIds() {
            return new int[]{ID};
        }

        @Override
        protected boolean validate(Object object) {
            return object != null && object instanceof HashSet;
        }
    }

    class IndexIdSet
    extends HashSet<Long> {
        IndexIdSet() {
        }

        public void set(long l, boolean bl) {
            if (bl) {
                this.add(l);
            } else {
                this.remove(l);
            }
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (Long l : this) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(l);
            }
            return "IndexIdSet {" + stringBuilder.toString() + "}";
        }
    }

    static class IndexDataComparator<T extends IndexData>
    implements Comparator<T> {
        protected SortModes sortMode;

        IndexDataComparator(SortModes sortModes) {
            this.sortMode = sortModes;
        }

        IndexDataComparator(Tree tree, TreeColumn treeColumn) {
            this.sortMode = tree.getColumn(0) == treeColumn ? SortModes.NAME : (tree.getColumn(1) == treeColumn ? SortModes.HOSTNAME : (tree.getColumn(2) == treeColumn ? SortModes.CREATED_DATETIME : (tree.getColumn(3) == treeColumn ? SortModes.SIZE : (tree.getColumn(4) == treeColumn ? SortModes.STATE : SortModes.NAME))));
        }

        IndexDataComparator(Tree tree) {
            this(tree, tree.getSortColumn());
        }

        IndexDataComparator(Table table, TableColumn tableColumn) {
            this.sortMode = table.getColumn(0) == tableColumn ? SortModes.NAME : (table.getColumn(1) == tableColumn ? SortModes.HOSTNAME : (table.getColumn(2) == tableColumn ? SortModes.CREATED_DATETIME : (table.getColumn(3) == tableColumn ? SortModes.SIZE : (table.getColumn(4) == tableColumn ? SortModes.STATE : SortModes.NAME))));
        }

        IndexDataComparator(Table table) {
            this(table, table.getSortColumn());
        }

        IndexDataComparator() {
            this.sortMode = SortModes.NAME;
        }

        static IndexDataComparator getInstance(SortModes sortModes) {
            return new IndexDataComparator(sortModes);
        }

        static <T extends IndexData> IndexDataComparator<T> getInstance(final Tree tree) {
            final IndexDataComparator[] indexDataComparatorArray = new IndexDataComparator[1];
            tree.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!tree.isDisposed()) {
                        indexDataComparatorArray[0] = new IndexDataComparator(tree);
                    }
                }
            });
            return indexDataComparatorArray[0];
        }

        static <T extends IndexData> IndexDataComparator<T> getInstance(final Table table) {
            final IndexDataComparator[] indexDataComparatorArray = new IndexDataComparator[1];
            table.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    indexDataComparatorArray[0] = new IndexDataComparator(table);
                }
            });
            return indexDataComparatorArray[0];
        }

        static <T extends IndexData> IndexDataComparator<T> getInstance() {
            return new IndexDataComparator<T>();
        }

        @Override
        public int compare(T t, T t2) {
            SortModes sortModes = this.sortMode;
            int n = 0;
            if (t == null && t2 == null) {
                n = 0;
            } else if (t == null) {
                n = 1;
            } else if (t2 == null) {
                n = -1;
            } else {
                n = Long.valueOf(((IndexData)t).id).compareTo(((IndexData)t2).id);
                if (n != 0) {
                    boolean bl = false;
                    do {
                        switch (sortModes) {
                            case NAME: {
                                String string = ((IndexData)t).getName();
                                String string2 = ((IndexData)t2).getName();
                                n = string.compareTo(string2);
                                sortModes = SortModes.SIZE;
                                break;
                            }
                            case CREATED_DATETIME: {
                                long l = ((IndexData)t).getDateTime();
                                long l2 = ((IndexData)t2).getDateTime();
                                n = Long.valueOf(l).compareTo(l2);
                                sortModes = SortModes.STATE;
                                break;
                            }
                            case SIZE: {
                                long l = ((IndexData)t).getTotalSize();
                                long l3 = ((IndexData)t2).getTotalSize();
                                n = Long.valueOf(l).compareTo(l3);
                                sortModes = SortModes.CREATED_DATETIME;
                                break;
                            }
                            case STATE: {
                                IndexStates indexStates = ((IndexData)t).getState();
                                IndexStates indexStates2 = ((IndexData)t2).getState();
                                n = indexStates.compareTo(indexStates2);
                                bl = true;
                                break;
                            }
                            default: {
                                bl = true;
                            }
                        }
                    } while (n == 0 && !bl);
                }
            }
            return n;
        }

        public String toString() {
            return "IndexDataComparator {" + (Object)((Object)this.sortMode) + "}";
        }

        static enum SortModes {
            NAME,
            HOSTNAME,
            CREATED_DATETIME,
            SIZE,
            STATE;

        }
    }

    class IndexData
    implements Serializable,
    Comparable<IndexData> {
        public long id;
        private TreeItemUpdateRunnable treeItemUpdateRunnable;
        private TableItemUpdateRunnable tableItemUpdateRunnable;
        private Menu subMenu;
        private MenuItem menuItem;
        private MenuItemUpdateRunnable menuItemUpdateRunnable;

        IndexData(long l) {
            this.id = l;
            this.subMenu = null;
            this.menuItem = null;
        }

        public boolean equals(Object object) {
            IndexData indexData = (IndexData)object;
            return indexData != null && this.id == indexData.id;
        }

        @Override
        public int compareTo(IndexData indexData) {
            if (this.id < indexData.id) {
                return -1;
            }
            if (this.id > indexData.id) {
                return 1;
            }
            return 0;
        }

        protected Menu getSubMenu() {
            return this.subMenu;
        }

        protected void setSubMenu(Menu menu) {
            this.subMenu = menu;
        }

        protected void clearSubMenu() {
            this.subMenu = null;
        }

        protected void setMenuItem(MenuItem menuItem, MenuItemUpdateRunnable menuItemUpdateRunnable) {
            this.menuItem = menuItem;
            this.menuItemUpdateRunnable = menuItemUpdateRunnable;
        }

        protected void clearMenuItem() {
            this.menuItem = null;
        }

        protected void update(IndexData indexData) {
            this.id = indexData.id;
        }

        protected String getName() {
            return "";
        }

        protected long getDateTime() {
            return 0L;
        }

        protected long getTotalSize() {
            return 0L;
        }

        protected long getTotalEntryCount() {
            return 0L;
        }

        protected long getTotalEntrySize() {
            return 0L;
        }

        protected IndexStates getState() {
            return IndexStates.OK;
        }

        protected void setState(IndexStates indexStates) {
        }

        protected String getInfo() {
            return "";
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeObject(this.id);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.id = (Long)objectInputStream.readObject();
        }

        public String toString() {
            return "Index {" + this.id + "}";
        }

        abstract class MenuItemUpdateRunnable {
            MenuItemUpdateRunnable() {
            }

            protected abstract void update(MenuItem var1, IndexData var2);
        }

        abstract class TableItemUpdateRunnable {
            TableItemUpdateRunnable() {
            }

            protected abstract void update(TableItem var1, IndexData var2);
        }

        abstract class TreeItemUpdateRunnable {
            TreeItemUpdateRunnable() {
            }

            protected abstract void update(TreeItem var1, IndexData var2);
        }
    }

    static enum IndexModes {
        NONE,
        MANUAL,
        AUTO,
        ALL,
        UNKNOWN;


        public String toString() {
            switch (this) {
                case MANUAL: {
                    return "manual";
                }
                case AUTO: {
                    return "auto";
                }
            }
            return "manual";
        }
    }

    class IndexStateSet {
        private EnumSet<IndexStates> indexStateSet = EnumSet.noneOf(IndexStates.class);

        public IndexStateSet(IndexStates ... indexStatesArray) {
            for (IndexStates indexStates : indexStatesArray) {
                this.indexStateSet.add(indexStates);
            }
        }

        public void add(IndexStates indexStates) {
            this.indexStateSet.add(indexStates);
        }

        public boolean contains(IndexStates indexStates) {
            return this.indexStateSet.contains((Object)indexStates);
        }

        public String nameList(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Enum enum_ : this.indexStateSet) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(enum_.name());
            }
            return stringBuilder.toString();
        }

        public String toString() {
            return StringUtils.join(this.indexStateSet, ",");
        }
    }

    static enum EntityStates {
        NONE,
        OK,
        ANY;

    }

    static enum IndexStates {
        NONE,
        OK,
        CREATE,
        UPDATE_REQUESTED,
        UPDATE,
        ERROR,
        UNKNOWN;


        public static EnumSet<IndexStates> ALL() {
            return EnumSet.of(OK, ERROR);
        }

        public String toString() {
            switch (this) {
                case OK: {
                    return "ok";
                }
                case CREATE: {
                    return "creating";
                }
                case UPDATE_REQUESTED: {
                    return "update requested";
                }
                case UPDATE: {
                    return "update";
                }
                case ERROR: {
                    return "error";
                }
            }
            return "ok";
        }
    }
}

