/*
 * Decompiled with CFR 0.152.
 */
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;

class ValueMap
extends HashMap<String, Object> {
    ValueMap(String string, String string2) {
        this.put(string, string2);
    }

    ValueMap() {
    }

    public int getInt(String string, Integer n) throws IllegalArgumentException {
        Object v = this.get(string);
        if (v != null) {
            if (v instanceof String) {
                String string2 = (String)v;
                try {
                    if (string2.startsWith("0x") || string2.startsWith("0X")) {
                        return Integer.parseInt(string2.substring(2), 16);
                    }
                    return Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    if (n != null) {
                        return n;
                    }
                    throw new IllegalArgumentException(string2, numberFormatException);
                }
            }
            return (Integer)v;
        }
        if (n != null) {
            return n;
        }
        throw new IllegalArgumentException("unknown entry '" + string + "'");
    }

    public int getInt(String string) throws IllegalArgumentException {
        return this.getInt(string, null);
    }

    public long getLong(String string, Long l) throws IllegalArgumentException {
        Object v = this.get(string);
        if (v != null) {
            if (v instanceof String) {
                String string2 = (String)v;
                try {
                    if (string2.startsWith("0x") || string2.startsWith("0X")) {
                        return Long.parseLong(string2.substring(2), 16);
                    }
                    return Long.parseLong(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    if (l != null) {
                        return l;
                    }
                    throw new IllegalArgumentException(string2, numberFormatException);
                }
            }
            return (Long)v;
        }
        if (l != null) {
            return l;
        }
        throw new IllegalArgumentException("unknown entry '" + string + "'");
    }

    public long getLong(String string) throws IllegalArgumentException {
        return this.getLong(string, null);
    }

    public double getDouble(String string, Double d) throws IllegalArgumentException {
        Object v = this.get(string);
        if (v != null) {
            if (v instanceof String) {
                String string2 = (String)v;
                try {
                    return NumberFormat.getInstance(Locale.ENGLISH).parse(string2).doubleValue();
                }
                catch (ParseException parseException) {
                    if (d != null) {
                        return d;
                    }
                    throw new IllegalArgumentException(string2, parseException);
                }
            }
            return (Double)v;
        }
        if (d != null) {
            return d;
        }
        throw new IllegalArgumentException("unknown entry '" + string + "'");
    }

    public double getDouble(String string) throws IllegalArgumentException {
        return this.getDouble(string, null);
    }

    public boolean getBoolean(String string, Boolean bl) throws IllegalArgumentException {
        Object v = this.get(string);
        if (v != null) {
            if (v instanceof String) {
                String string2 = (String)v;
                return string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("on") || string2.equalsIgnoreCase("true") || string2.equals("1");
            }
            return (Boolean)v;
        }
        if (bl != null) {
            return bl;
        }
        throw new IllegalArgumentException("unknown entry '" + string + "'");
    }

    public boolean getBoolean(String string) throws IllegalArgumentException {
        return this.getBoolean(string, null);
    }

    public char getChar(String string, Character c) throws IllegalArgumentException {
        Object v = this.get(string);
        if (v != null) {
            if (v instanceof String) {
                return ((String)v).charAt(0);
            }
            return ((Character)this.get(string)).charValue();
        }
        if (c != null) {
            return c.charValue();
        }
        throw new IllegalArgumentException("unknown entry '" + string + "'");
    }

    public char getChar(String string) throws IllegalArgumentException {
        return this.getChar(string, null);
    }

    public String getString(String string, String string2) throws IllegalArgumentException {
        Object v = this.get(string);
        if (v != null) {
            return (String)v;
        }
        if (string2 != null) {
            return string2;
        }
        throw new IllegalArgumentException("unknown entry '" + string + "'");
    }

    public String getString(String string) throws IllegalArgumentException {
        return this.getString(string, null);
    }

    public <T extends Enum<T>> T getEnum(String string, Class<T> clazz, T t) throws IllegalArgumentException {
        Object v = this.get(string);
        if (v != null) {
            if (v instanceof String) {
                int n;
                String string2 = (String)v;
                if (EnumParser.class.isAssignableFrom(clazz)) {
                    try {
                        Method method = EnumParser.class.getDeclaredMethod("parse", String.class);
                        Enum enum_ = ((Enum[])clazz.getEnumConstants())[0];
                        return (T)((Enum)method.invoke((Object)enum_, string2));
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                Enum[] enumArray = (Enum[])clazz.getEnumConstants();
                try {
                    n = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    n = -1;
                }
                boolean bl = false;
                for (Enum enum_ : enumArray) {
                    if (!string2.equalsIgnoreCase(enum_.name()) && enum_.ordinal() != n && !string2.equalsIgnoreCase(enum_.toString())) continue;
                    return (T)enum_;
                }
                if (t != null) {
                    return t;
                }
                throw new IllegalArgumentException("unknown enum value '" + string2 + "' for " + string);
            }
            return (T)((Enum)v);
        }
        if (t != null) {
            return t;
        }
        throw new IllegalArgumentException("unknown entry '" + string + "'");
    }

    public <T extends Enum<T>> T getEnum(String string, Class<T> clazz) throws IllegalArgumentException {
        return (T)this.getEnum(string, clazz, null);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        for (String string : this.keySet()) {
            if (stringBuilder.length() > 1) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
            stringBuilder.append('=');
            stringBuilder.append(this.get(string));
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

