/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSAffineTransformStruct;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSThread;

public class Transform
extends Resource {
    public NSAffineTransform handle;

    public Transform(Device device) {
        this(device, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    }

    public Transform(Device device, float[] fArray) {
        this(device, Transform.checkTransform(fArray)[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Transform(Device device, float f, float f2, float f3, float f4, float f5, float f6) {
        super(device);
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.handle = NSAffineTransform.transform();
            if (this.handle == null) {
                SWT.error(2);
            }
            this.handle.retain();
            this.setElements(f, f2, f3, f4, f5, f6);
            this.init();
            Object var10_9 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    static float[] checkTransform(float[] fArray) {
        if (fArray == null) {
            SWT.error(4);
        }
        if (fArray.length < 6) {
            SWT.error(5);
        }
        return fArray;
    }

    void destroy() {
        this.handle.release();
        this.handle = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getElements(float[] fArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (fArray == null) {
            SWT.error(4);
        }
        if (fArray.length < 6) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSAffineTransformStruct nSAffineTransformStruct = this.handle.transformStruct();
            fArray[0] = (float)nSAffineTransformStruct.m11;
            fArray[1] = (float)nSAffineTransformStruct.m12;
            fArray[2] = (float)nSAffineTransformStruct.m21;
            fArray[3] = (float)nSAffineTransformStruct.m22;
            fArray[4] = (float)nSAffineTransformStruct.tX;
            fArray[5] = (float)nSAffineTransformStruct.tY;
            Object var5_4 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void identity() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSAffineTransformStruct nSAffineTransformStruct = new NSAffineTransformStruct();
            nSAffineTransformStruct.m11 = 1.0;
            nSAffineTransformStruct.m22 = 1.0;
            this.handle.setTransformStruct(nSAffineTransformStruct);
            Object var4_3 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invert() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSAffineTransformStruct nSAffineTransformStruct = this.handle.transformStruct();
            if (nSAffineTransformStruct.m11 * nSAffineTransformStruct.m22 - nSAffineTransformStruct.m12 * nSAffineTransformStruct.m21 == 0.0) {
                SWT.error(10);
            }
            this.handle.invert();
            Object var4_3 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIdentity() {
        boolean bl;
        block4: {
            if (this.isDisposed()) {
                SWT.error(44);
            }
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                NSAffineTransformStruct nSAffineTransformStruct = this.handle.transformStruct();
                bl = nSAffineTransformStruct.m11 == 1.0 && nSAffineTransformStruct.m12 == 0.0 && nSAffineTransformStruct.m21 == 0.0 && nSAffineTransformStruct.m22 == 1.0 && nSAffineTransformStruct.tX == 0.0 && nSAffineTransformStruct.tY == 0.0;
                Object var5_4 = null;
                if (nSAutoreleasePool == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var5_5 = null;
                    if (nSAutoreleasePool == null) break block5;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void multiply(Transform transform) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (transform == null) {
            SWT.error(4);
        }
        if (transform.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.handle.prependTransform(transform.handle);
            Object var4_3 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rotate(float f) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.handle.rotateByDegrees(f);
            Object var4_3 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void scale(float f, float f2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.handle.scaleXBy(f, f2);
            Object var5_4 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setElements(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSAffineTransformStruct nSAffineTransformStruct = new NSAffineTransformStruct();
            nSAffineTransformStruct.m11 = f;
            nSAffineTransformStruct.m12 = f2;
            nSAffineTransformStruct.m21 = f3;
            nSAffineTransformStruct.m22 = f4;
            nSAffineTransformStruct.tX = f5;
            nSAffineTransformStruct.tY = f6;
            this.handle.setTransformStruct(nSAffineTransformStruct);
            Object var10_9 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void shear(float f, float f2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSAffineTransformStruct nSAffineTransformStruct = new NSAffineTransformStruct();
            nSAffineTransformStruct.m11 = 1.0;
            nSAffineTransformStruct.m12 = f;
            nSAffineTransformStruct.m21 = f2;
            nSAffineTransformStruct.m22 = 1.0;
            NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
            nSAffineTransform.setTransformStruct(nSAffineTransformStruct);
            this.handle.prependTransform(nSAffineTransform);
            Object var7_6 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void transform(float[] fArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (fArray == null) {
            SWT.error(4);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSPoint nSPoint = new NSPoint();
            int n = fArray.length / 2;
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                nSPoint.x = fArray[n3];
                nSPoint.y = fArray[n3 + 1];
                nSPoint = this.handle.transformPoint(nSPoint);
                fArray[n3] = (float)nSPoint.x;
                fArray[n3 + 1] = (float)nSPoint.y;
                ++n2;
                n3 += 2;
            }
            Object var8_7 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void translate(float f, float f2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.handle.translateXBy(f, f2);
            Object var5_4 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Transform {*DISPOSED*}";
        }
        float[] fArray = new float[6];
        this.getElements(fArray);
        return "Transform {" + fArray[0] + ", " + fArray[1] + ", " + fArray[2] + ", " + fArray[3] + ", " + fArray[4] + ", " + fArray[5] + "}";
    }
}

