/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.i18n;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18n {
    private static final String CONTEXT_GLUE = "\u0004";
    private volatile ResourceBundle bundle;
    private volatile Locale sourceCodeLocale = Locale.ENGLISH;
    private String baseName;
    private ClassLoader loader;
    private volatile Locale locale;
    static /* synthetic */ Class class$0;

    public I18n(ResourceBundle bundle) {
        this.setResources(bundle);
    }

    public I18n(String baseName, Locale locale, ClassLoader loader) {
        this.setResources(baseName, locale, loader);
    }

    public ResourceBundle getResources() {
        return this.bundle;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public synchronized void setResources(ResourceBundle bundle) {
        if (bundle == null) {
            throw new NullPointerException();
        }
        this.bundle = bundle;
        this.baseName = null;
        this.locale = bundle.getLocale();
        this.loader = null;
    }

    public synchronized void setResources(String baseName, Locale locale, ClassLoader loader) {
        this.bundle = ResourceBundle.getBundle(baseName, locale, loader);
        this.baseName = baseName;
        this.locale = locale;
        this.loader = loader;
    }

    public static final String marktr(String text) {
        return text;
    }

    public synchronized boolean setLocale(Locale locale) {
        if (this.baseName != null && this.loader != null) {
            this.setResources(this.baseName, locale, this.loader);
            return true;
        }
        this.locale = locale;
        return false;
    }

    public void setSourceCodeLocale(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("locale must not be null");
        }
        this.sourceCodeLocale = locale;
    }

    public final String tr(String text) {
        try {
            return this.bundle.getString(text);
        }
        catch (MissingResourceException e) {
            return text;
        }
    }

    public final String tr(String text, Object[] objects) {
        return MessageFormat.format(this.tr(text), objects);
    }

    public final String tr(String text, Object o1) {
        return this.tr(text, new Object[]{o1});
    }

    public final String tr(String text, Object o1, Object o2) {
        return this.tr(text, new Object[]{o1, o2});
    }

    public final String tr(String text, Object o1, Object o2, Object o3) {
        return this.tr(text, new Object[]{o1, o2, o3});
    }

    public final String tr(String text, Object o1, Object o2, Object o3, Object o4) {
        return this.tr(text, new Object[]{o1, o2, o3, o4});
    }

    public final String trn(String text, String pluralText, long n) {
        try {
            return I18n.trnInternal(this.bundle, text, pluralText, n);
        }
        catch (MissingResourceException e) {
            return n == 1L ? text : pluralText;
        }
    }

    public final String trn(String text, String pluralText, long n, Object[] objects) {
        return MessageFormat.format(this.trn(text, pluralText, n), objects);
    }

    public final String trn(String text, String pluralText, long n, Object o1) {
        return this.trn(text, pluralText, n, new Object[]{o1});
    }

    public final String trn(String text, String pluralText, long n, Object o1, Object o2) {
        return this.trn(text, pluralText, n, new Object[]{o1, o2});
    }

    public final String trn(String text, String pluralText, long n, Object o1, Object o2, Object o3) {
        return this.trn(text, pluralText, n, new Object[]{o1, o2, o3});
    }

    public final String trn(String text, String pluralText, long n, Object o1, Object o2, Object o3, Object o4) {
        return this.trn(text, pluralText, n, new Object[]{o1, o2, o3, o4});
    }

    private static String trnInternal(ResourceBundle orgBundle, String text, String pluralText, long n) {
        ResourceBundle bundle = orgBundle;
        do {
            boolean isGetTextBundle = false;
            boolean hasPluralHandling = false;
            Method handleGetObjectMethod = null;
            Method getParentMethod = null;
            Method lookupMethod = null;
            Method pluralEvalMethod = null;
            try {
                Class<?> clazz = bundle.getClass();
                Class[] classArray = new Class[1];
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                handleGetObjectMethod = clazz.getMethod("handleGetObject", classArray);
                getParentMethod = bundle.getClass().getMethod("getParent", new Class[0]);
                isGetTextBundle = Modifier.isPublic(handleGetObjectMethod.getModifiers());
                Class<?> clazz3 = bundle.getClass();
                Class[] classArray2 = new Class[1];
                Class<?> clazz4 = class$0;
                if (clazz4 == null) {
                    try {
                        clazz4 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray2[0] = clazz4;
                lookupMethod = clazz3.getMethod("lookup", classArray2);
                pluralEvalMethod = bundle.getClass().getMethod("pluralEval", Long.TYPE);
                hasPluralHandling = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (isGetTextBundle) {
                Object localValue2;
                if (hasPluralHandling) {
                    try {
                        localValue2 = lookupMethod.invoke((Object)bundle, text);
                        if (localValue2.getClass().isArray()) {
                            String[] pluralforms = (String[])localValue2;
                            long index = 0L;
                            try {
                                index = (Long)pluralEvalMethod.invoke((Object)bundle, new Long(n));
                                if (index < 0L || index >= (long)pluralforms.length) {
                                    index = 0L;
                                }
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                // empty catch block
                            }
                            return pluralforms[(int)index];
                        }
                        return (String)localValue2;
                    }
                    catch (Exception localValue2) {}
                } else {
                    try {
                        localValue2 = handleGetObjectMethod.invoke((Object)bundle, text);
                        if (localValue2 != null) {
                            return (String)localValue2;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                bundle = null;
                try {
                    bundle = (ResourceBundle)getParentMethod.invoke((Object)bundle, new Object[0]);
                }
                catch (Exception exception) {}
                continue;
            }
            return bundle.getString(text);
        } while (bundle != null);
        throw new MissingResourceException("Can not find resource for key " + text + " in bundle " + orgBundle.getClass().getName(), orgBundle.getClass().getName(), text);
    }

    public final String trc(String context, String text) {
        if (this.sourceCodeLocale.equals(this.getResources().getLocale())) {
            return text;
        }
        String key = String.valueOf(context) + CONTEXT_GLUE + text;
        String translated = this.tr(key);
        return translated == key ? text : translated;
    }

    public final String trnc(String context, String singularText, String pluralText, long n) {
        try {
            return I18n.trnInternal(this.bundle, String.valueOf(context) + CONTEXT_GLUE + singularText, pluralText, n);
        }
        catch (MissingResourceException e) {
            return n == 1L ? singularText : pluralText;
        }
    }

    public final String trnc(String context, String singularText, String pluralText, long n, Object[] objects) {
        return MessageFormat.format(this.trnc(context, singularText, pluralText, n), objects);
    }

    public final String trnc(String comment, String singularText, String pluralText, long n, Object obj) {
        return MessageFormat.format(this.trnc(comment, singularText, pluralText, n), obj);
    }

    public final String trnc(String comment, String singularText, String pluralText, long n, Object obj1, Object obj2) {
        return MessageFormat.format(this.trnc(comment, singularText, pluralText, n), obj1, obj2);
    }

    public final String trnc(String comment, String singularText, String pluralText, long n, Object obj1, Object obj2, Object obj3) {
        return MessageFormat.format(this.trnc(comment, singularText, pluralText, n), obj1, obj2, obj3);
    }

    public final String trnc(String comment, String singularText, String pluralText, long n, Object obj1, Object obj2, Object obj3, Object obj4) {
        return MessageFormat.format(this.trnc(comment, singularText, pluralText, n), obj1, obj2, obj3, obj4);
    }
}

