/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class Pane
extends Canvas {
    public static final int SIZE = 12;
    private static final int SLIDER_SIZE = 8;
    private static final int SLIDER_OFFSET = 8;
    private static final int OFFSET_X = 2;
    private static final int OFFSET_Y = 2;
    private final Color COLOR_GRAY;
    private final Color COLOR_WHITE;
    private final Color COLOR_NORMAL_SHADOW;
    private final Color COLOR_HIGHLIGHT_SHADOW;
    private final Cursor CURSOR;
    private boolean initFlag;
    private Composite[] composites;
    private double[] weights;
    private int count;
    private int style;
    private int dragIndex;
    private int dragStart;
    private int dragDelta;
    private HashSet<Listener> resizeListenerSet = new HashSet();

    Pane(Composite composite, int n, int n2) {
        super(composite, 0);
        if (n < 2) {
            throw new IllegalArgumentException();
        }
        this.COLOR_WHITE = this.getDisplay().getSystemColor(1);
        this.COLOR_GRAY = this.getDisplay().getSystemColor(15);
        this.COLOR_NORMAL_SHADOW = this.getDisplay().getSystemColor(18);
        this.COLOR_HIGHLIGHT_SHADOW = this.getDisplay().getSystemColor(20);
        if ((n2 & 0x200) == 512) {
            this.CURSOR = new Cursor(this.getDisplay(), 9);
        } else if ((n2 & 0x100) == 256) {
            this.CURSOR = new Cursor(this.getDisplay(), 7);
        } else {
            throw new IllegalArgumentException("invalid style");
        }
        this.initFlag = false;
        this.composites = new Composite[n];
        this.weights = new double[n];
        this.count = n;
        this.style = n2;
        this.dragIndex = -1;
        this.initWeights();
        for (int i = 0; i < n; ++i) {
            this.composites[i] = new Composite(this, 0);
        }
        this.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent paintEvent) {
                if (!Pane.this.initFlag) {
                    Pane.this.updateCompositeSizes();
                    Pane.this.initFlag = true;
                }
                Pane.this.paint(paintEvent);
            }
        });
        super.addListener(11, new Listener(){

            @Override
            public void handleEvent(Event event) {
                Pane.this.updateCompositeSizes();
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseDown(MouseEvent mouseEvent) {
                Pane pane = Pane.this;
                pane.dragIndex = Pane.this.getSashAt(mouseEvent.x, mouseEvent.y);
                if (pane.dragIndex >= 0) {
                    pane.dragStart = (pane.style & 0x200) == 512 ? mouseEvent.x : mouseEvent.y;
                    pane.dragDelta = 0;
                }
            }

            @Override
            public void mouseUp(MouseEvent mouseEvent) {
                Pane pane = Pane.this;
                if (pane.dragIndex >= 0) {
                    Rectangle rectangle = Pane.this.composites[pane.dragIndex].getBounds();
                    if ((pane.style & 0x200) == 512) {
                        Pane.this.notifyResize(pane.dragIndex, rectangle.width);
                    } else if ((pane.style & 0x100) == 256) {
                        Pane.this.notifyResize(pane.dragIndex, rectangle.height);
                    }
                }
                pane.dragIndex = -1;
                pane.dragDelta = 0;
                Pane.this.updateWeights();
            }
        });
        this.addMouseTrackListener(new MouseTrackListener(){

            @Override
            public void mouseEnter(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExit(MouseEvent mouseEvent) {
                Pane pane = Pane.this;
                Pane.this.setCursor(null);
            }

            @Override
            public void mouseHover(MouseEvent mouseEvent) {
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            @Override
            public void mouseMove(MouseEvent mouseEvent) {
                Composite composite = (Composite)mouseEvent.widget;
                Pane pane = Pane.this;
                Pane.this.setCursor(Pane.this.isInsideSash(mouseEvent.x, mouseEvent.y) ? Pane.this.CURSOR : null);
                if (pane.dragIndex >= 0) {
                    int n;
                    Rectangle rectangle = pane.getBounds();
                    Rectangle rectangle2 = Pane.this.composites[pane.dragIndex + 0].getBounds();
                    Rectangle rectangle3 = Pane.this.composites[pane.dragIndex + 1].getBounds();
                    if ((pane.style & 0x200) == 512) {
                        int n2 = mouseEvent.x - pane.dragStart;
                        if (n2 != 0) {
                            if (rectangle2.width + n2 < 0) {
                                n2 = -rectangle2.width;
                            }
                            if (rectangle3.width - n2 < 0) {
                                n2 = rectangle3.width;
                            }
                            rectangle2.width += n2;
                            rectangle3.x += n2;
                            rectangle3.width -= n2;
                            Pane.this.composites[pane.dragIndex + 0].setBounds(rectangle2);
                            Pane.this.composites[pane.dragIndex + 1].setBounds(rectangle3);
                            Pane.this.redraw();
                            pane.dragStart = mouseEvent.x;
                            Pane.this.notifyResize(pane.dragIndex + 0, rectangle2.width);
                        }
                    } else if ((pane.style & 0x100) == 256 && (n = mouseEvent.y - pane.dragStart) != 0) {
                        if (rectangle2.height + n < 0) {
                            n = -rectangle2.height;
                        }
                        if (rectangle3.height - n < 0) {
                            n = rectangle3.height;
                        }
                        rectangle2.height += n;
                        rectangle3.y += n;
                        rectangle3.height -= n;
                        Pane.this.composites[pane.dragIndex + 0].setBounds(rectangle2);
                        Pane.this.composites[pane.dragIndex + 1].setBounds(rectangle3);
                        Pane.this.redraw();
                        pane.dragStart = mouseEvent.y;
                        Pane.this.notifyResize(pane.dragIndex + 0, rectangle2.height);
                    }
                }
            }
        });
    }

    public Composite getComposite(int n) {
        return this.composites[n];
    }

    public double[] getSizes() {
        double[] dArray;
        block3: {
            Rectangle rectangle;
            block2: {
                dArray = new double[this.count];
                rectangle = this.getBounds();
                if ((this.style & 0x200) != 512) break block2;
                int n = rectangle.width - (this.count - 1) * 12;
                for (int i = 0; i < this.count; ++i) {
                    dArray[i] = (double)this.composites[i].getBounds().width / (double)n;
                }
                break block3;
            }
            if ((this.style & 0x100) != 256) break block3;
            int n = rectangle.height - (this.count - 1) * 12;
            for (int i = 0; i < this.count; ++i) {
                dArray[i] = (double)this.composites[i].getBounds().height / (double)n;
            }
        }
        return dArray;
    }

    public void setSizes(double[] dArray) {
        int n;
        if (dArray.length != this.count) {
            double[] dArray2 = Arrays.copyOf(dArray, this.count);
            if (dArray2.length > dArray.length) {
                for (int i = dArray.length; i < dArray2.length; ++i) {
                    dArray2[i] = 1.0;
                }
            }
            dArray = dArray2;
        }
        double d = 0.0;
        for (n = 0; n < this.count; ++n) {
            d += dArray[n];
        }
        if (d < 0.0) {
            d = 1.0 / (double)(this.count - 1);
        }
        for (n = 0; n < this.count; ++n) {
            this.weights[n] = dArray[n] / d;
        }
        this.initFlag = true;
        this.updateCompositeSizes();
    }

    @Override
    public void setLayout(Layout layout) {
        throw new UnsupportedOperationException("Pane cannot have a layout");
    }

    @Override
    public void addListener(int n, Listener listener) {
        super.addListener(n, listener);
        if (n == 11) {
            this.resizeListenerSet.add(listener);
        }
    }

    @Override
    public void removeListener(int n, Listener listener) {
        super.removeListener(n, listener);
        if (n == 11) {
            this.resizeListenerSet.remove(listener);
        }
    }

    @Override
    public String toString() {
        return "Pane@" + this.hashCode() + " {" + this.count + ", " + ((this.style & 0x200) == 512 ? "vertical" : "horizontal") + "}";
    }

    private void initWeights() {
        for (int i = 0; i < this.count; ++i) {
            this.weights[i] = 1.0 / (double)this.count;
        }
    }

    private void updateWeights() {
        block5: {
            int n;
            Rectangle rectangle;
            block4: {
                for (int i = 0; i < this.count; ++i) {
                    this.weights[i] = 0.0;
                }
                rectangle = this.getBounds();
                if ((this.style & 0x200) != 512) break block4;
                int n2 = rectangle.width - (this.count - 1) * 12;
                if (n2 <= 0) break block5;
                for (int i = 0; i < this.count; ++i) {
                    this.weights[i] = (double)this.composites[i].getBounds().width / (double)n2;
                }
                break block5;
            }
            if ((this.style & 0x100) == 256 && (n = rectangle.height - (this.count - 1) * 12) > 0) {
                for (int i = 0; i < this.count; ++i) {
                    this.weights[i] = (double)this.composites[i].getBounds().height / (double)n;
                }
            }
        }
    }

    private void updateCompositeSizes() {
        block5: {
            Rectangle rectangle;
            Pane pane;
            block4: {
                pane = this;
                rectangle = pane.getClientArea();
                if ((pane.style & 0x200) != 512) break block4;
                int n = rectangle.width - (pane.count - 1) * 12;
                if (n < 0) {
                    n = 0;
                }
                int n2 = 0;
                for (int i = 0; i < pane.count; ++i) {
                    int n3 = (int)((double)n * this.weights[i]);
                    pane.composites[i].setBounds(n2, 0, n3, rectangle.height);
                    n2 += n3 + 12;
                }
                break block5;
            }
            if ((pane.style & 0x100) != 256) break block5;
            int n = rectangle.height - (pane.count - 1) * 12;
            if (n < 0) {
                n = 0;
            }
            int n4 = 0;
            for (int i = 0; i < pane.count; ++i) {
                int n5 = (int)((double)n * this.weights[i]);
                pane.composites[i].setBounds(0, n4, rectangle.width, n5);
                n4 += n5 + 12;
            }
        }
    }

    private void paint(PaintEvent paintEvent) {
        if (!this.isDisposed()) {
            GC gC = paintEvent.gc;
            Rectangle rectangle = this.getBounds();
            int n = rectangle.x;
            int n2 = rectangle.y;
            int n3 = rectangle.width;
            int n4 = rectangle.height;
            for (int i = 0; i < this.count - 1; ++i) {
                int n5;
                int n6;
                rectangle = this.composites[i].getBounds();
                if ((this.style & 0x200) == 512) {
                    n6 = rectangle.x + rectangle.width + 2;
                    n5 = n4 - 2 - 8 - 8;
                    gC.setForeground(this.COLOR_HIGHLIGHT_SHADOW);
                    gC.drawLine(n6 + 4 - 1, 0, n6 + 4 - 1, n4 - 1);
                    gC.drawLine(n6 + 4, 0, n6 + 4, 0);
                    gC.setForeground(this.COLOR_NORMAL_SHADOW);
                    gC.drawLine(n6 + 4, 1, n6 + 4, n4 - 1);
                } else if ((this.style & 0x100) == 256) {
                    n6 = n3 - 2 - 8 - 8;
                    n5 = rectangle.y + rectangle.height + 2;
                    gC.setForeground(this.COLOR_HIGHLIGHT_SHADOW);
                    gC.drawLine(0, n5 + 4 - 1, n3 - 1, n5 + 4 - 1);
                    gC.drawLine(0, n5 + 4, 1, n5 + 4);
                    gC.setForeground(this.COLOR_NORMAL_SHADOW);
                    gC.drawLine(1, n5 + 4, n3 - 1, n5 + 4);
                } else {
                    throw new IllegalArgumentException("invalid style");
                }
                gC.setForeground(this.COLOR_WHITE);
                gC.drawLine(n6, n5, n6 + 8 - 1, n5);
                gC.drawLine(n6, n5 + 1, n6, n5 + 8 - 1);
                gC.setForeground(this.COLOR_GRAY);
                gC.fillRectangle(n6 + 1, n5 + 1, 6, 6);
                gC.setForeground(this.COLOR_NORMAL_SHADOW);
                gC.drawLine(n6 + 8 - 1, n5 + 1, n6 + 8 - 1, n5 + 8 - 1);
                gC.drawLine(n6 + 1, n5 + 8 - 1, n6 + 8 - 2, n5 + 8 - 1);
            }
        }
    }

    private Rectangle getSashBounds(int n) {
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = this.composites[n + 0].getBounds();
        Rectangle rectangle3 = this.composites[n + 1].getBounds();
        if ((this.style & 0x200) == 512) {
            rectangle.x = rectangle2.x + rectangle2.width;
            rectangle.y = rectangle2.y;
            rectangle.width = 12;
            rectangle.height = rectangle2.height;
        } else if ((this.style & 0x100) == 256) {
            rectangle.x = rectangle2.x;
            rectangle.y = rectangle2.y + rectangle2.height;
            rectangle.width = rectangle2.width;
            rectangle.height = 12;
        }
        return rectangle;
    }

    private boolean isInsideSash(int n, int n2, int n3) {
        return this.getSashBounds(n).contains(n2, n3);
    }

    private boolean isInsideSash(int n, int n2) {
        for (int i = 0; i < this.count - 1; ++i) {
            if (!this.isInsideSash(i, n, n2)) continue;
            return true;
        }
        return false;
    }

    private int getSashAt(int n, int n2) {
        for (int i = 0; i < this.count - 1; ++i) {
            if (!this.isInsideSash(i, n, n2)) continue;
            return i;
        }
        return -1;
    }

    private void notifyResize(int n, int n2) {
        Event event = new Event();
        event.type = 11;
        event.widget = this;
        event.detail = n2;
        event.doit = true;
        for (Listener listener : this.resizeListenerSet) {
            listener.handleEvent(event);
            if (event.doit) continue;
            break;
        }
    }
}

