/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;

class ReadThread
extends Thread {
    private Display display;
    private String serverName;
    private BufferedReader input;
    private boolean quitFlag = false;
    private HashMap<Long, Command> commandHashMap = new HashMap();

    ReadThread(Display display, String string, BufferedReader bufferedReader) {
        this.display = display;
        this.serverName = string;
        this.input = bufferedReader;
        this.setDaemon(true);
        this.setName("BARControl Server Read");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object[] objectArray = new Object[4];
        while (!this.quitFlag) {
            Object object;
            try {
                try {
                    long l;
                    String string = this.input.readLine();
                    if (string == null) {
                        if (!this.quitFlag) {
                            throw new IOException("disconnected");
                        }
                        break;
                    }
                    if (StringParser.parse(string, "%lu %y %u % S", objectArray)) {
                        l = (Long)objectArray[0];
                        boolean bl = (Boolean)objectArray[1];
                        int n = (Integer)objectArray[2];
                        object = ((String)objectArray[3]).trim();
                        Command command = this.commandHashMap.get(l);
                        if (command != null) {
                            Command command2 = command;
                            synchronized (command2) {
                                BARServer.logReceived(command.debugLevel, "%s", string);
                                if (n == 0) {
                                    command.valueMap.clear();
                                    if (!((String)object).isEmpty()) {
                                        if (StringParser.parse((String)object, command.valueMap)) {
                                            if (command.resultHandler != null) {
                                                command.resultHandler.handle(command.resultCount, (ValueMap)command.valueMap.clone());
                                            } else {
                                                command.resultList.add((String)object);
                                                if (command.resultList.size() > 4096) {
                                                    BARServer.logReceived(command.debugLevel, "Stored huge number of results: %d %s", command.resultList.size(), string);
                                                }
                                                command.notifyAll();
                                            }
                                            ++command.resultCount;
                                        } else {
                                            throw new BARException(204, (String)object);
                                        }
                                    }
                                    command.setErrorCode(0);
                                    if (bl) {
                                        command.setCompleted();
                                        if (command.handler != null) {
                                            try {
                                                command.handler.handle(command);
                                            }
                                            catch (Throwable throwable) {
                                                BARControl.logThrowable(throwable);
                                            }
                                        }
                                        command.notifyAll();
                                    }
                                } else {
                                    command.setError(n, (String)object);
                                    command.setCompleted();
                                    command.notifyAll();
                                }
                                continue;
                            }
                        }
                        BARServer.logReceived(1, "unknown command result %s", string);
                        continue;
                    }
                    if (StringParser.parse(string, "%lu %S % S", objectArray)) {
                        l = (Long)objectArray[0];
                        String string2 = (String)objectArray[1];
                        String string3 = ((String)objectArray[2]).trim();
                        if (!StringParser.parse(string3, (ValueMap)(object = new ValueMap()))) {
                            throw new BARException(204, string3);
                        }
                        BARServer.logReceived(1, "%s", string);
                        BARServer.process(l, string2, (ValueMap)object);
                        continue;
                    }
                    throw new CommunicationError(BARControl.tr("malformed command or result ''{0}''", string));
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    if (this.display == null) continue;
                    this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            throw new ConnectionError(BARControl.tr("Timeout reading data from server ''{0}''", ReadThread.this.serverName));
                        }
                    });
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
            catch (IOException iOException) {
                HashMap<Long, Command> hashMap = this.commandHashMap;
                synchronized (hashMap) {
                    for (Command command : this.commandHashMap.values()) {
                        object = command;
                        synchronized (object) {
                            command.setError(29, iOException.getMessage());
                            command.setCompleted();
                            if (command.handler != null) {
                                try {
                                    command.handler.handle(command);
                                }
                                catch (Throwable throwable) {
                                    BARControl.logThrowable(throwable);
                                }
                            }
                            command.notifyAll();
                        }
                    }
                }
                if (!this.quitFlag && this.display != null) {
                    this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            throw new ConnectionError(BARControl.tr("Lost connection to server ''{0}''.", ReadThread.this.serverName));
                        }
                    });
                }
                this.quitFlag = true;
            }
            catch (SWTException sWTException) {
                if (!this.quitFlag && this.display != null) {
                    this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            BARControl.showFatalError(sWTException);
                        }
                    });
                }
                BARControl.printInternalError(sWTException);
                System.exit(127);
            }
            catch (AssertionError assertionError) {
                if (this.display != null) {
                    this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            BARControl.showFatalError((Throwable)((Object)assertionError));
                        }
                    });
                }
                BARControl.printInternalError((Throwable)((Object)assertionError));
                System.exit(127);
            }
            catch (InternalError internalError) {
                BARControl.printInternalError(internalError);
                if (!this.quitFlag && this.display != null) {
                    this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            BARControl.showFatalError(internalError);
                        }
                    });
                }
                BARControl.logThrowable(internalError);
                System.exit(127);
            }
            catch (Throwable throwable) {
                BARControl.internalError(throwable);
            }
        }
    }

    public void quit() {
        this.quitFlag = true;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command commandAdd(String string, int n, int n2, Command.ResultHandler resultHandler, Command.Handler handler) throws ConnectionError {
        Command command = null;
        HashMap<Long, Command> hashMap = this.commandHashMap;
        synchronized (hashMap) {
            if (!this.quitFlag) {
                command = new Command(string, n, n2, resultHandler, handler);
                this.commandHashMap.put(command.id, command);
                if (this.commandHashMap.size() > 256 && Settings.debugLevel > 0) {
                    System.err.println(String.format("Network warning %8d: %d commands", this.commandHashMap.size()));
                }
            } else {
                throw new ConnectionError(BARControl.tr("disconnected", new Object[0]));
            }
            this.commandHashMap.notifyAll();
        }
        return command;
    }

    public Command commandAdd(String string, int n, int n2) throws ConnectionError {
        return this.commandAdd(string, n, n2, null, null);
    }

    public Command commandAdd(String string, int n) throws ConnectionError {
        return this.commandAdd(string, n, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int commandRemove(Command command) {
        HashMap<Long, Command> hashMap = this.commandHashMap;
        synchronized (hashMap) {
            this.commandHashMap.remove(command.id);
            this.commandHashMap.notifyAll();
        }
        return command.getErrorCode();
    }
}

