/*
 * Decompiled with CFR 0.152.
 */
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;

public class StringUtils {
    public static final String QUOTE_CHARS = "'\"";
    public static final char DEFAULT_QUOTE_CHAR = '\"';
    public static final String DEFAULT_QUOTE_STRING = "\"";
    public static final String WHITE_SPACES = " \t\f\r\n";
    public static final Character ESCAPE_CHAR = Character.valueOf('\\');

    public static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static int indexOf(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(List<String> list, String string) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).equals(string)) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(String[] stringArray, String string) {
        return StringUtils.indexOf(stringArray, string) >= 0;
    }

    public static boolean contains(List<String> list, String string) {
        return StringUtils.indexOf(list, string) >= 0;
    }

    public static String[] trimBegin(String[] stringArray, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            int n;
            for (n = 0; n < string2.length() && string.indexOf(string2.charAt(n)) >= 0; ++n) {
            }
            arrayList.add(string2.substring(n));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] trimBegin(String[] stringArray, char c) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            int n;
            for (n = 0; n < string.length() && string.charAt(n) == c; ++n) {
            }
            arrayList.add(string.substring(n));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] trimBegin(String[] stringArray) {
        return StringUtils.trimBegin(stringArray, WHITE_SPACES);
    }

    public static String trimBegin(String string, String string2) {
        int n;
        for (n = 0; n < string.length() && string2.indexOf(string.charAt(n)) >= 0; ++n) {
        }
        return string.substring(n);
    }

    public static String trimBegin(String string, char c) {
        int n;
        for (n = 0; n < string.length() && string.charAt(n) == c; ++n) {
        }
        return string.substring(n);
    }

    public static String trimBegin(String string) {
        return StringUtils.trimBegin(string, WHITE_SPACES);
    }

    public static String[] trimEnd(String[] stringArray, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            int n;
            for (n = string2.length() - 1; n >= 0 && string.indexOf(string2.charAt(n)) >= 0; --n) {
            }
            arrayList.add(string2.substring(n));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] trimEnd(String[] stringArray, char c) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            int n;
            for (n = string.length() - 1; n > 0 && string.charAt(n) == c; --n) {
            }
            arrayList.add(string.substring(n));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] trimEnd(String[] stringArray) {
        return StringUtils.trimEnd(stringArray, WHITE_SPACES);
    }

    public static String trimEnd(String string, String string2) {
        int n;
        for (n = string.length() - 1; n >= 0 && string2.indexOf(string.charAt(n)) >= 0; --n) {
        }
        return string.substring(0, n + 1);
    }

    public static String trimEnd(String string, char c) {
        int n;
        for (n = string.length() - 1; n > 0 && string.charAt(n) == c; --n) {
        }
        return string.substring(0, n + 1);
    }

    public static String trimEnd(String string) {
        return StringUtils.trimEnd(string, WHITE_SPACES);
    }

    public static String trim(String string, String string2) {
        int n;
        int n2;
        for (n2 = 0; n2 < string.length() && string2.indexOf(string.charAt(n2)) >= 0; ++n2) {
        }
        for (n = string.length() - 1; n >= n2 && string2.indexOf(string.charAt(n)) >= 0; --n) {
        }
        return string.substring(n2, n + 1);
    }

    public static String trim(String string, char c) {
        int n;
        int n2;
        for (n2 = 0; n2 < string.length() && string.charAt(n2) == c; ++n2) {
        }
        for (n = string.length() - 1; n >= n2 && string.charAt(n) == c; --n) {
        }
        return string.substring(n2, n + 1);
    }

    public static String trim(String string) {
        return StringUtils.trim(string, WHITE_SPACES);
    }

    public static String[] trim(String[] stringArray, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            int n;
            int n2;
            for (n2 = 0; n2 < string2.length() && string.indexOf(string2.charAt(n2)) >= 0; ++n2) {
            }
            for (n = string2.length() - 1; n >= n2 && string.indexOf(string2.charAt(n)) >= 0; --n) {
            }
            arrayList.add(string2.substring(n2, n + 1));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] trim(String[] stringArray, char c) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            int n;
            int n2;
            for (n2 = 0; n2 < string.length() && string.charAt(n2) == c; ++n2) {
            }
            for (n = string.length() - 1; n >= n2 && string.charAt(n) == c; --n) {
            }
            arrayList.add(string.substring(n2, n + 1));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] trim(String[] stringArray) {
        return StringUtils.trim(stringArray, WHITE_SPACES);
    }

    public static String escape(String string, boolean bl, char c) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append(c);
        }
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                char c2 = string.charAt(i);
                if (c2 == c) {
                    stringBuilder.append("\\" + c);
                    continue;
                }
                if (c2 == '\\') {
                    stringBuilder.append("\\\\");
                    continue;
                }
                stringBuilder.append(c2);
            }
        }
        if (bl) {
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String escape(String string, boolean bl) {
        return StringUtils.escape(string, bl, '\"');
    }

    public static String escape(String string, char c) {
        return StringUtils.escape(string, true, c);
    }

    public static String escape(String string) {
        return StringUtils.escape(string, true);
    }

    public static String unescape(String string, boolean bl, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            int n;
            boolean bl2 = false;
            char c = '\u0000';
            int n2 = 0;
            int n3 = string.length();
            if (bl && string.length() >= 2) {
                for (n = 0; n < string2.length(); ++n) {
                    c = string2.charAt(n);
                    if (string.charAt(0) != c || string.charAt(string.length() - 1) != c) continue;
                    bl2 = true;
                    n2 = 1;
                    n3 = string.length() - 1;
                    break;
                }
            }
            n = n2;
            while (n < n3) {
                char c2 = string.charAt(n);
                if (c2 == ESCAPE_CHAR.charValue() && n + 1 < n3 && bl2 && string.charAt(n + 1) == c) {
                    stringBuffer.append(c);
                    n += 2;
                    continue;
                }
                if (c2 == ESCAPE_CHAR.charValue() && n + 1 < n3) {
                    stringBuffer.append(string.charAt(n + 1));
                    n += 2;
                    continue;
                }
                stringBuffer.append(c2);
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public static String unescape(String string, boolean bl) {
        return StringUtils.unescape(string, bl, "\"'");
    }

    public static String unescape(String string, char c) {
        return StringUtils.unescape(string, true, Character.toString(c));
    }

    public static String unescape(String string) {
        return StringUtils.unescape(string, true);
    }

    public static String quote(String string, String string2, char c) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        if (string2 != null) {
            for (n = 0; n < string2.length(); ++n) {
                if (string.indexOf(string2.charAt(n)) < 0) continue;
                bl = true;
                break;
            }
        }
        if (string2 == null || bl) {
            stringBuilder.append(c);
            if (string != null) {
                for (n = 0; n < string.length(); ++n) {
                    char c2 = string.charAt(n);
                    if (c2 == c) {
                        stringBuilder.append("\\" + c);
                        continue;
                    }
                    stringBuilder.append(c2);
                }
            }
            stringBuilder.append(c);
            return stringBuilder.toString();
        }
        return string;
    }

    public static String quote(String string, char c) {
        return StringUtils.quote(string, null, c);
    }

    public static String quote(String string) {
        return StringUtils.quote(string, '\"');
    }

    public static String unquote(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            int n;
            boolean bl = false;
            char c = '\u0000';
            int n2 = 0;
            int n3 = string.length();
            if (string.length() >= 2) {
                for (n = 0; n < string2.length(); ++n) {
                    c = string2.charAt(n);
                    if (string.charAt(0) != c || string.charAt(string.length() - 1) != c) continue;
                    bl = true;
                    n2 = 1;
                    n3 = string.length() - 1;
                    break;
                }
            }
            n = n2;
            while (n < n3) {
                char c2 = string.charAt(n);
                if (c2 == ESCAPE_CHAR.charValue() && n + 1 < n3 && bl && string.charAt(n + 1) == c) {
                    stringBuffer.append(c);
                    n += 2;
                    continue;
                }
                stringBuffer.append(c2);
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public static String unquote(String string, char c) {
        return StringUtils.unquote(string, Character.toString(c));
    }

    public static String unquote(String string) {
        return StringUtils.unquote(string, "\"'");
    }

    public static String replace(String string, char c, char c2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c3 = string.charAt(i);
            stringBuilder.append(c3 == c ? c2 : c3);
        }
        return stringBuilder.toString();
    }

    public static String map(String string, int n, String[] stringArray, String[] stringArray2) {
        StringBuilder stringBuilder = new StringBuilder();
        assert (stringArray.length == stringArray2.length);
        while (n < string.length()) {
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.startsWith(stringArray[i], n)) continue;
                stringBuilder.append(stringArray2[i]);
                n += stringArray[i].length();
                bl = true;
                break;
            }
            if (bl) continue;
            stringBuilder.append(string.charAt(n));
            ++n;
        }
        return stringBuilder.toString();
    }

    public static String map(String string, String[] stringArray, String[] stringArray2) {
        return StringUtils.map(string, 0, stringArray, stringArray2);
    }

    public static String join(Collection collection, String string, char c) {
        StringBuilder stringBuilder = new StringBuilder();
        if (collection != null) {
            for (Object e : collection) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(string);
                }
                String string2 = e.toString();
                stringBuilder.append(c != '\u0000' ? StringUtils.escape(string2, true, c) : string2);
            }
        }
        return stringBuilder.toString();
    }

    public static String join(Collection collection, String string, boolean bl) {
        return StringUtils.join(collection, string, bl ? (char)'\"' : '\u0000');
    }

    public static String join(Collection collection, String string) {
        return StringUtils.join(collection, string, '\u0000');
    }

    public static <T> String join(List<T> list, int n, int n2, String string, char c) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (list != null && n < list.size()) {
            if (n2 > list.size()) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 < 0) {
                n2 = list.size() - n;
            }
            for (int i = 0; i < n2; ++i) {
                T t = list.get(n + i);
                if (t == null) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(string);
                }
                String string2 = t.toString();
                stringBuilder.append(c != '\u0000' ? StringUtils.escape(string2, true, c) : string2);
            }
        }
        return stringBuilder.toString();
    }

    public static <T> String join(List<T> list, String string, char c) {
        return StringUtils.join(list, 0, -1, string, c);
    }

    public static <T> String join(List<T> list, int n, int n2, char c, char c2) {
        return StringUtils.join(list, n, n2, Character.toString(c), c2);
    }

    public static <T> String join(List<T> list, char c, char c2) {
        return StringUtils.join(list, 0, -1, c, c2);
    }

    public static <T> String join(List<T> list, int n, int n2, String string, boolean bl) {
        return StringUtils.join(list, n, n2, string, bl ? (char)'\"' : '\u0000');
    }

    public static <T> String join(List<T> list, String string, boolean bl) {
        return StringUtils.join(list, 0, -1, string, bl ? (char)'\"' : '\u0000');
    }

    public static <T> String join(List<T> list, int n, int n2, char c, boolean bl) {
        return StringUtils.join(list, n, n2, Character.toString(c), bl);
    }

    public static <T> String join(List<T> list, char c, boolean bl) {
        return StringUtils.join(list, 0, -1, Character.toString(c), bl);
    }

    public static <T> String join(List<T> list, int n, int n2, String string) {
        return StringUtils.join(list, n, n2, string, '\u0000');
    }

    public static <T> String join(List<T> list, String string) {
        return StringUtils.join(list, 0, -1, string);
    }

    public static <T> String join(List<T> list, int n, int n2, char c) {
        return StringUtils.join(list, n, n2, Character.toString(c));
    }

    public static <T> String join(List<T> list, char c) {
        return StringUtils.join(list, 0, -1, c);
    }

    public static <T> String join(List<T> list) {
        return StringUtils.join(list, 0, -1, " ");
    }

    public static String join(Object[] objectArray, int n, int n2, String string, char c) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (objectArray != null && n < objectArray.length) {
            if (n2 > objectArray.length) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 < 0) {
                n2 = objectArray.length - n;
            }
            for (int i = 0; i < n2; ++i) {
                Object object = objectArray[n + i];
                if (object == null) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(string);
                }
                String string2 = object.toString();
                stringBuilder.append(c != '\u0000' ? StringUtils.escape(string2, true, c) : string2);
            }
        }
        return stringBuilder.toString();
    }

    public static String join(Object[] objectArray, String string, char c) {
        return StringUtils.join(objectArray, 0, -1, string, c);
    }

    public static String join(Object[] objectArray, int n, int n2, char c, char c2) {
        return StringUtils.join(objectArray, n, n2, Character.toString(c), c2);
    }

    public static String join(Object[] objectArray, char c, char c2) {
        return StringUtils.join(objectArray, 0, -1, c, c2);
    }

    public static String join(Object[] objectArray, int n, int n2, String string, boolean bl) {
        return StringUtils.join(objectArray, n, n2, string, bl ? (char)'\"' : '\u0000');
    }

    public static String join(Object[] objectArray, String string, boolean bl) {
        return StringUtils.join(objectArray, 0, -1, string, bl ? (char)'\"' : '\u0000');
    }

    public static String join(Object[] objectArray, int n, int n2, char c, boolean bl) {
        return StringUtils.join(objectArray, n, n2, Character.toString(c), bl);
    }

    public static String join(Object[] objectArray, char c, boolean bl) {
        return StringUtils.join(objectArray, 0, -1, Character.toString(c), bl);
    }

    public static String join(Object[] objectArray, int n, int n2, String string) {
        return StringUtils.join(objectArray, n, n2, string, '\u0000');
    }

    public static String join(Object[] objectArray, String string) {
        return StringUtils.join(objectArray, 0, -1, string);
    }

    public static String join(Object[] objectArray, int n, int n2, char c) {
        return StringUtils.join(objectArray, n, n2, Character.toString(c));
    }

    public static String join(Object[] objectArray, char c) {
        return StringUtils.join(objectArray, 0, -1, c);
    }

    public static String join(Object[] objectArray) {
        return StringUtils.join(objectArray, 0, -1, " ");
    }

    public static String join(String[] stringArray, int n, int n2) {
        return StringUtils.join((Object[])stringArray, " ");
    }

    public static String join(String[] stringArray) {
        return StringUtils.join((Object[])stringArray, 0, -1, " ");
    }

    public static String join(boolean[] blArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (blArray != null) {
            for (boolean bl : blArray) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(Boolean.toString(bl));
            }
        }
        return stringBuilder.toString();
    }

    public static String join(boolean[] blArray) {
        return StringUtils.join(blArray, " ");
    }

    public static String join(int[] nArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (nArray != null) {
            for (int n : nArray) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(Integer.toString(n));
            }
        }
        return stringBuilder.toString();
    }

    public static String join(int[] nArray) {
        return StringUtils.join(nArray, " ");
    }

    public static String join(long[] lArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (lArray != null) {
            for (long l : lArray) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(Long.toString(l));
            }
        }
        return stringBuilder.toString();
    }

    public static String join(long[] lArray) {
        return StringUtils.join(lArray, " ");
    }

    public static String join(float[] fArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (fArray != null) {
            for (float f : fArray) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(Float.toString(f));
            }
        }
        return stringBuilder.toString();
    }

    public static String join(float[] fArray) {
        return StringUtils.join(fArray, " ");
    }

    public static String join(double[] dArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (dArray != null) {
            for (double d : dArray) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(Double.toString(d));
            }
        }
        return stringBuilder.toString();
    }

    public static String join(double[] dArray) {
        return StringUtils.join(dArray, " ");
    }

    public static String join(EnumSet enumSet, String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (enumSet != null) {
            for (Enum enum_ : enumSet) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(bl ? Integer.toString(enum_.ordinal()) : enum_.toString());
            }
        }
        return stringBuilder.toString();
    }

    public static String join(EnumSet enumSet, String string) {
        return StringUtils.join(enumSet, string, false);
    }

    public static String join(EnumSet enumSet) {
        return StringUtils.join(enumSet, ",");
    }

    private static <T extends AbstractList<String>> T split(T t, String string, String string2, String string3, String string4, Character c, boolean bl) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            if (string3 != null) {
                while (i < n && string3.indexOf(cArray[i]) >= 0) {
                    ++i;
                }
            }
            stringBuilder.setLength(0);
            while (i < n && string2.indexOf(cArray[i]) == -1) {
                if (c != null && cArray[i] == c.charValue()) {
                    if (i + 1 < n) {
                        stringBuilder.append(cArray[i + 1]);
                    }
                    i += 2;
                    continue;
                }
                if (string4 != null && string4.indexOf(cArray[i]) >= 0) {
                    char c2 = cArray[i];
                    ++i;
                    while (i < n && cArray[i] != c2) {
                        if (c != null && cArray[i] == c.charValue()) {
                            if (i + 1 < n) {
                                stringBuilder.append(cArray[i + 1]);
                            }
                            i += 2;
                            continue;
                        }
                        stringBuilder.append(cArray[i]);
                        ++i;
                    }
                    ++i;
                    continue;
                }
                stringBuilder.append(cArray[i]);
                ++i;
            }
            if (!bl && stringBuilder.length() <= 0) continue;
            t.add((String)stringBuilder.toString());
        }
        return t;
    }

    public static <T extends AbstractList<String>> AbstractList<String> split(T t, String string, String string2, String string3, String string4, boolean bl) {
        return StringUtils.split(t, string, string2, string3, string4, (Character)null, bl);
    }

    public static <T extends AbstractList<String>> AbstractList<String> split(T t, String string, char c, String string2, String string3, boolean bl) {
        return StringUtils.split(t, string, new String(new char[]{c}), string2, string3, bl);
    }

    public static <T extends AbstractList<String>> AbstractList<String> split(T t, String string, String string2, String string3, boolean bl) {
        return StringUtils.split(t, string, string2, WHITE_SPACES, string3, bl);
    }

    public static <T extends AbstractList<String>> AbstractList<String> split(T t, String string, char c, String string2, boolean bl) {
        return StringUtils.split(t, string, c, WHITE_SPACES, string2, bl);
    }

    public static <T extends AbstractList<String>> AbstractList<String> split(T t, String string, String string2, String string3) {
        return StringUtils.split(t, string, string2, WHITE_SPACES, string3, true);
    }

    public static <T extends AbstractList<String>> AbstractList<String> split(T t, String string, String string2, boolean bl) {
        return StringUtils.split(t, string, string2, (String)null, (String)null, bl);
    }

    public static <T extends AbstractList<String>> AbstractList<String> split(T t, String string, char c, boolean bl) {
        return StringUtils.split(t, string, c, (String)null, (String)null, bl);
    }

    public static <T extends AbstractList<String>> AbstractList<String> split(T t, String string, String string2) {
        return StringUtils.split(t, string, string2, true);
    }

    public static <T extends AbstractList<String>> AbstractList<String> split(T t, String string, char c) {
        return StringUtils.split(t, string, c, true);
    }

    public static <T extends AbstractList<String>> AbstractList<String> split(T t, String string) {
        return StringUtils.split(t, string, WHITE_SPACES);
    }

    public static <T extends AbstractList<String>> T split(Class<T> clazz, String string, String string2, String string3, String string4, Character c, boolean bl) {
        try {
            return (T)StringUtils.split((AbstractList)clazz.getConstructor(new Class[0]).newInstance(new Object[0]), string, string2, string3, string4, c, bl);
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static <T extends AbstractList<String>> T split(Class<T> clazz, String string, String string2, String string3, String string4, boolean bl) {
        return StringUtils.split(clazz, string, string2, string3, string4, (Character)null, bl);
    }

    public static <T extends AbstractList<String>> T split(Class<T> clazz, String string, char c, String string2, String string3, boolean bl) {
        return StringUtils.split(clazz, string, new String(new char[]{c}), string2, string3, bl);
    }

    public static <T extends AbstractList<String>> T split(Class<T> clazz, String string, String string2, String string3, Character c, boolean bl) {
        return StringUtils.split(clazz, string, string2, WHITE_SPACES, string3, bl);
    }

    public static <T extends AbstractList<String>> T split(Class<T> clazz, String string, char c, String string2, Character c2, boolean bl) {
        return StringUtils.split(clazz, string, c, WHITE_SPACES, string2, bl);
    }

    public static <T extends AbstractList<String>> T split(Class<T> clazz, String string, String string2, String string3, Character c) {
        return StringUtils.split(clazz, string, string2, WHITE_SPACES, string3, true);
    }

    public static <T extends AbstractList<String>> T split(Class<T> clazz, String string, String string2, boolean bl) {
        return StringUtils.split(clazz, string, string2, (String)null, (String)null, bl);
    }

    public static <T extends AbstractList<String>> T split(Class<T> clazz, String string, char c, boolean bl) {
        return StringUtils.split(clazz, string, c, (String)null, (String)null, bl);
    }

    public static <T extends AbstractList<String>> T split(Class<T> clazz, String string, String string2) {
        return StringUtils.split(clazz, string, string2, true);
    }

    public static <T extends AbstractList<String>> T split(Class<T> clazz, String string, char c) {
        return StringUtils.split(clazz, string, c, true);
    }

    public static <T extends AbstractList<String>> T split(Class<T> clazz, String string) {
        return StringUtils.split(clazz, string, WHITE_SPACES);
    }

    public String[] toArray(Object ... objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : objectArray) {
            if (object instanceof String[]) {
                for (String string : (String[])object) {
                    arrayList.add(string);
                }
                continue;
            }
            if (object instanceof List) {
                for (Object e : (List)object) {
                    arrayList.add(e.toString());
                }
                continue;
            }
            arrayList.add(object.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] splitArray(String string, String string2, String string3, String string4, Character c, boolean bl) {
        ArrayList arrayList = new ArrayList();
        StringUtils.split(arrayList, string, string2, string3, string4, c, bl);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] splitArray(String string, String string2, String string3, String string4, boolean bl) {
        return StringUtils.splitArray(string, string2, string3, string4, null, bl);
    }

    public static String[] splitArray(String string, char c, String string2, String string3, boolean bl) {
        return StringUtils.splitArray(string, new String(new char[]{c}), string2, string3, bl);
    }

    public static String[] splitArray(String string, String string2, String string3, boolean bl) {
        return StringUtils.splitArray(string, string2, WHITE_SPACES, string3, bl);
    }

    public static String[] splitArray(String string, char c, String string2, boolean bl) {
        return StringUtils.splitArray(string, c, WHITE_SPACES, string2, bl);
    }

    public static String[] splitArray(String string, String string2, String string3) {
        return StringUtils.splitArray(string, string2, WHITE_SPACES, string3, true);
    }

    public static String[] splitArray(String string, char c, String string2) {
        return StringUtils.splitArray(string, c, WHITE_SPACES, string2, true);
    }

    public static String[] splitArray(String string, String string2, boolean bl) {
        return StringUtils.splitArray(string, string2, null, null, bl);
    }

    public static String[] splitArray(String string, char c, boolean bl) {
        return StringUtils.splitArray(string, c, null, null, bl);
    }

    public static String[] splitArray(String string, String string2) {
        return StringUtils.splitArray(string, string2, true);
    }

    public static String[] splitArray(String string, char c) {
        return StringUtils.splitArray(string, c, true);
    }

    public static String[] splitArray(String string) {
        return StringUtils.splitArray(string, WHITE_SPACES);
    }

    public static void replace(String[] stringArray, String string, String string2) {
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].replace(string, string2);
        }
    }

    public static String repeat(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String repeat(char c, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String globToRegex(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        block7: while (n < string.length()) {
            switch (string.charAt(n)) {
                case '*': {
                    stringBuilder.append(".*");
                    ++n;
                    continue block7;
                }
                case '?': {
                    stringBuilder.append('.');
                    ++n;
                    continue block7;
                }
                case '.': {
                    stringBuilder.append("\\.");
                    ++n;
                    continue block7;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    ++n;
                    continue block7;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '[': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    stringBuilder.append('\\');
                    stringBuilder.append(string.charAt(n));
                    ++n;
                    continue block7;
                }
            }
            stringBuilder.append(string.charAt(n));
            ++n;
        }
        return stringBuilder.toString();
    }

    public static boolean parseBoolean(String string) {
        String[] stringArray;
        for (String string2 : stringArray = new String[]{"1", "true", "yes", "on"}) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public static Enum parseEnum(Class clazz, String string) {
        if (string != null) {
            int n;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
            for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
                if (!string.equalsIgnoreCase(enum_.toString()) && enum_.ordinal() != n) continue;
                return enum_;
            }
        }
        return null;
    }

    public static EnumSet parseEnumSet(Class clazz, String string) {
        EnumSet<Enum> enumSet = EnumSet.noneOf(clazz);
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        for (String string2 : StringUtils.splitArray(string, ",", false)) {
            int n;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
            for (Enum enum_ : enumArray) {
                if (!string2.equalsIgnoreCase(enum_.toString()) && enum_.ordinal() != n) continue;
                enumSet.add(enum_);
            }
        }
        return enumSet;
    }
}

