/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TabJobs {
    private final double MAX_VOLUME_SIZE_ECC = 0.8;
    private final Color COLOR_BLACK;
    private final Color COLOR_WHITE;
    private final Color COLOR_RED;
    private final Color COLOR_MODIFIED;
    private final Color COLOR_INFO_FOREGROUND;
    private final Color COLOR_INFO_BACKGROUND;
    private final Color COLOR_DISABLED_BACKGROUND;
    private final Color COLOR_BACKGROUND_ODD;
    private final Color COLOR_BACKGROUND_EVEN;
    private final Color COLOR_EXPIRED;
    private final Color COLOR_IN_TRANSIT;
    private final Image IMAGE_DIRECTORY;
    private final Image IMAGE_DIRECTORY_INCLUDED;
    private final Image IMAGE_DIRECTORY_EXCLUDED;
    private final Image IMAGE_FILE;
    private final Image IMAGE_FILE_INCLUDED;
    private final Image IMAGE_FILE_EXCLUDED;
    private final Image IMAGE_LINK;
    private final Image IMAGE_LINK_INCLUDED;
    private final Image IMAGE_LINK_EXCLUDED;
    private final Image IMAGE_DEVICE;
    private final Image IMAGE_DEVICE_INCLUDED;
    private final Image IMAGE_DEVICE_EXCLUDED;
    private final Image IMAGE_TRASHCAN;
    private final Image IMAGE_TOGGLE_MARK;
    private final Image IMAGE_EDIT;
    private final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private Shell shell;
    private Display display;
    private UpdateThread updateThread;
    private TabStatus tabStatus;
    public Composite widgetTab;
    private TabFolder widgetTabFolder;
    private Combo widgetJobList;
    private Tree widgetFileTree;
    private Shell widgetFileTreeToolTip = null;
    private MenuItem menuItemOpenClose;
    private MenuItem menuItemInclude;
    private MenuItem menuItemExcludeByList;
    private MenuItem menuItemExcludeByNoBackup;
    private MenuItem menuItemExcludeByNoDump;
    private MenuItem menuItemNone;
    private Button widgetInclude;
    private Button widgetExclude;
    private Button widgetNone;
    private Table widgetDeviceTable;
    private Table widgetMountTable;
    private Button widgetMountTableAdd;
    private Button widgetMountTableEdit;
    private Button widgetMountTableRemove;
    private Table widgetIncludeTable;
    private Button widgetIncludeTableAdd;
    private Button widgetIncludeTableEdit;
    private Button widgetIncludeTableRemove;
    private List widgetExcludeList;
    private Button widgetExcludeListAdd;
    private Button widgetExcludeListEdit;
    private Button widgetExcludeListRemove;
    private Button widgetArchivePartSizeLimited;
    private Combo widgetArchivePartSize;
    private List widgetCompressExcludeList;
    private Button widgetCompressExcludeListInsert;
    private Button widgetCompressExcludeListEdit;
    private Button widgetCompressExcludeListRemove;
    private Combo[] widgetCryptAlgorithms = new Combo[4];
    private Text widgetCryptPassword1;
    private Text widgetCryptPassword2;
    private Combo widgetFTPMaxBandWidth;
    private Combo widgetSCPSFTPMaxBandWidth;
    private Combo widgetWebdavMaxBandWidth;
    private Table widgetScheduleTable;
    private Shell widgetScheduleTableToolTip = null;
    private Button widgetScheduleTableAdd;
    private Button widgetScheduleTableEdit;
    private Button widgetScheduleTableRemove;
    private Tree widgetPersistenceTree;
    private Shell widgetPersistenceTreeToolTip = null;
    private Button widgetPersistenceTreeAdd;
    private Button widgetPersistenceTreeEdit;
    private Button widgetPersistenceTreeRemove;
    private WidgetVariable slaveHostName = new WidgetVariable<String>("slave-host-name", "");
    private WidgetVariable slaveHostPort = new WidgetVariable("slave-host-port", 0);
    private WidgetVariable slaveTLSMode = new WidgetVariable<String>("slave-tls-mode", "none");
    private WidgetVariable includeFileCommand = new WidgetVariable<String>("include-file-command", "");
    private WidgetVariable includeImageCommand = new WidgetVariable<String>("include-image-command", "");
    private WidgetVariable excludeCommand = new WidgetVariable<String>("exclude-command", "");
    private WidgetVariable archiveName = new WidgetVariable<String>("archive-name", "");
    private WidgetVariable archiveType = new WidgetVariable<String>("archive-type", new String[]{"normal", "full", "incremental", "differential", "continuous"}, "normal");
    private WidgetVariable archivePartSizeFlag = new WidgetVariable(false);
    private WidgetVariable archivePartSize = new WidgetVariable("archive-part-size", 0L);
    private WidgetVariable deltaCompressAlgorithm = new WidgetVariable<String>("delta-compress-algorithm", new String[]{"none", "xdelta1", "xdelta2", "xdelta3", "xdelta4", "xdelta5", "xdelta6", "xdelta7", "xdelta8", "xdelta9"}, "none");
    private WidgetVariable deltaSource = new WidgetVariable<String>("delta-source", "");
    private WidgetVariable byteCompressAlgorithmType = new WidgetVariable<String>(new String[]{"none", "zip", "bzip", "lzma", "lzo", "lz4-", "zstd"}, "none");
    private WidgetVariable byteCompressAlgorithm = new WidgetVariable<String>(new String[]{"none", "zip0", "zip1", "zip2", "zip3", "zip4", "zip5", "zip6", "zip7", "zip8", "zip9", "bzip1", "bzip2", "bzip3", "bzip4", "bzip5", "bzip6", "bzip7", "bzip8", "bzip9", "lzma1", "lzma2", "lzma3", "lzma4", "lzma5", "lzma6", "lzma7", "lzma8", "lzma9", "lzo1", "lzo2", "lzo3", "lzo4", "lzo5", "lz4-0", "lz4-1", "lz4-2", "lz4-3", "lz4-4", "lz4-5", "lz4-6", "lz4-7", "lz4-8", "lz4-9", "lz4-10", "lz4-11", "lz4-12", "lz4-13", "lz4-14", "lz4-15", "lz4-16", "zstd0", "zstd1", "zstd2", "zstd3", "zstd4", "zstd5", "zstd6", "zstd7", "zstd8", "zstd9", "zstd10", "zstd11", "zstd12", "zstd13", "zstd14", "zstd15", "zstd16", "zstd17", "zstd18", "zstd19"}, "none");
    private WidgetVariable compressMinSize = new WidgetVariable("compress-min-size", 0L);
    private WidgetVariable cryptAlgorithm = new WidgetVariable<String>("crypt-algorithm", new String[]{"none", "3DES", "CAST5", "BLOWFISH", "AES128", "AES192", "AES256", "TWOFISH128", "TWOFISH256", "SERPENT128", "SERPENT192", "SERPENT256", "CAMELLIA128", "CAMELLIA192", "CAMELLIA256"}, "none");
    private WidgetVariable cryptType = new WidgetVariable<String>("crypt-type", new String[]{"none", "symmetric", "asymmetric"}, "none");
    private WidgetVariable cryptPublicKeyFileName = new WidgetVariable<String>("crypt-public-key", "");
    private WidgetVariable cryptPasswordMode = new WidgetVariable<String>("crypt-password-mode", new String[]{"default", "ask", "config"}, "default");
    private WidgetVariable cryptPassword = new WidgetVariable<String>("crypt-password", "");
    private WidgetVariable incrementalListFileName = new WidgetVariable<String>("incremental-list-file", "");
    private WidgetVariable par2Directory = new WidgetVariable<String>("par2-directory", "");
    private WidgetVariable par2BlockSize = new WidgetVariable("par2-block-size", 0);
    private WidgetVariable par2FileCount = new WidgetVariable("par2-file-count", 0);
    private WidgetVariable par2BlockCount = new WidgetVariable("par2-block-count", 0);
    private WidgetVariable storageOnMasterFlag = new WidgetVariable("storage-on-master", true);
    private WidgetVariable storageType = new WidgetVariable<StorageTypes>("storage-type", new StorageTypes[]{StorageTypes.FILESYSTEM, StorageTypes.FTP, StorageTypes.SCP, StorageTypes.SFTP, StorageTypes.WEBDAV, StorageTypes.WEBDAVS, StorageTypes.SMB, StorageTypes.CD, StorageTypes.DVD, StorageTypes.BD, StorageTypes.DEVICE}, StorageTypes.FILESYSTEM);
    private WidgetVariable storageHostName = new WidgetVariable<String>("");
    private WidgetVariable storageHostPort = new WidgetVariable("", 0);
    private WidgetVariable storageLoginName = new WidgetVariable<String>("", "");
    private WidgetVariable storageLoginPassword = new WidgetVariable<String>("", "");
    private WidgetVariable storageShareName = new WidgetVariable<String>("", "");
    private WidgetVariable storageDeviceName = new WidgetVariable<String>("", "");
    private WidgetVariable storageFileName = new WidgetVariable<String>("", "");
    private WidgetVariable archiveFileMode = new WidgetVariable<String>("archive-file-mode", new String[]{"stop", "rename", "append", "overwrite"}, "stop");
    private WidgetVariable sshPublicKeyFileName = new WidgetVariable<String>("ssh-public-key", "");
    private WidgetVariable sshPrivateKeyFileName = new WidgetVariable<String>("ssh-private-key", "");
    private WidgetVariable maxBandWidthFlag = new WidgetVariable(false);
    private WidgetVariable maxBandWidth = new WidgetVariable("max-band-width", 0L);
    private WidgetVariable volumeSize = new WidgetVariable<String>("volume-size", "");
    private WidgetVariable ecc = new WidgetVariable("ecc", false);
    private WidgetVariable blank = new WidgetVariable("blank", false);
    private WidgetVariable waitFirstVolume = new WidgetVariable("wait-first-volume", false);
    private WidgetVariable skipUnreadable = new WidgetVariable("skip-unreadable", false);
    private WidgetVariable noStopOnOwnerError = new WidgetVariable("no-stop-on-owner-error", false);
    private WidgetVariable noStopOnAttributeError = new WidgetVariable("no-stop-on-attribute-error", false);
    private WidgetVariable rawImages = new WidgetVariable("raw-images", false);
    private WidgetVariable overwriteFiles = new WidgetVariable("overwrite-files", false);
    private WidgetVariable preCommand = new WidgetVariable<String>("pre-command", "");
    private WidgetVariable postCommand = new WidgetVariable<String>("post-command", "");
    private WidgetVariable slavePreCommand = new WidgetVariable<String>("slave-pre-command", "");
    private WidgetVariable slavePostCommand = new WidgetVariable<String>("slave-post-command", "");
    private WidgetVariable maxStorageSize = new WidgetVariable<String>("max-storage-size", "");
    private WidgetVariable comment = new WidgetVariable<String>("comment", "");
    private DirectoryInfoThread directoryInfoThread;
    private boolean directorySizesFlag = false;
    private JobData selectedJobData = null;
    private WidgetEvent selectJobEvent = new WidgetEvent();
    private HashMap<String, EntryData> includeHashMap = new HashMap();
    private HashSet<String> excludeHashSet = new HashSet();
    private HashSet<String> sourceHashSet = new HashSet();
    private HashSet<String> compressExcludeHashSet = new HashSet();
    private HashMap<String, ScheduleData> scheduleDataMap = new HashMap();

    TabJobs(TabFolder tabFolder, int n) {
        int n2;
        this.shell = tabFolder.getShell();
        this.display = this.shell.getDisplay();
        this.COLOR_BLACK = this.display.getSystemColor(2);
        this.COLOR_WHITE = this.display.getSystemColor(1);
        this.COLOR_RED = this.display.getSystemColor(3);
        this.COLOR_MODIFIED = new Color(null, 255, 160, 160);
        this.COLOR_INFO_FOREGROUND = this.display.getSystemColor(28);
        this.COLOR_INFO_BACKGROUND = this.display.getSystemColor(29);
        this.COLOR_DISABLED_BACKGROUND = this.display.getSystemColor(22);
        this.COLOR_BACKGROUND_ODD = new Color(this.display, 248, 247, 246);
        this.COLOR_BACKGROUND_EVEN = this.display.getSystemColor(1);
        this.COLOR_EXPIRED = new Color(null, 255, 160, 160);
        this.COLOR_IN_TRANSIT = new Color(null, 160, 255, 160);
        this.IMAGE_DIRECTORY = Widgets.loadImage(this.display, "directory.png");
        this.IMAGE_DIRECTORY_INCLUDED = Widgets.loadImage(this.display, "directoryIncluded.png");
        this.IMAGE_DIRECTORY_EXCLUDED = Widgets.loadImage(this.display, "directoryExcluded.png");
        this.IMAGE_FILE = Widgets.loadImage(this.display, "file.png");
        this.IMAGE_FILE_INCLUDED = Widgets.loadImage(this.display, "fileIncluded.png");
        this.IMAGE_FILE_EXCLUDED = Widgets.loadImage(this.display, "fileExcluded.png");
        this.IMAGE_LINK = Widgets.loadImage(this.display, "link.png");
        this.IMAGE_LINK_INCLUDED = Widgets.loadImage(this.display, "linkIncluded.png");
        this.IMAGE_LINK_EXCLUDED = Widgets.loadImage(this.display, "linkExcluded.png");
        this.IMAGE_DEVICE = Widgets.loadImage(this.display, "device.png");
        this.IMAGE_DEVICE_INCLUDED = Widgets.loadImage(this.display, "deviceIncluded.png");
        this.IMAGE_DEVICE_EXCLUDED = Widgets.loadImage(this.display, "deviceExcluded.png");
        this.IMAGE_TRASHCAN = Widgets.loadImage(this.display, "trashcan.png");
        this.IMAGE_TOGGLE_MARK = Widgets.loadImage(this.display, "togglemark.png");
        this.IMAGE_EDIT = Widgets.loadImage(this.display, "edit.png");
        this.directoryInfoThread = new DirectoryInfoThread(this.display);
        this.directoryInfoThread.start();
        this.widgetTab = Widgets.addTab(tabFolder, BARControl.tr("Jobs", new Object[0]) + (n != 0 ? " (" + Widgets.acceleratorToText(n) + ")" : ""), !BARServer.isSlave());
        this.widgetTab.setLayout(new TableLayout(new double[]{0.0, 0.0, 1.0, 0.0}, 1.0, 2));
        Widgets.layout(this.widgetTab, 0, 0, 15);
        Composite composite = Widgets.newComposite(this.widgetTab);
        composite.setLayout(new TableLayout(null, new double[]{0.0, 1.0, 0.0, 0.0, 0.0, 0.0}));
        Widgets.layout(composite, 0, 0, 12);
        Label label = Widgets.newLabel(composite, BARControl.tr("Name", new Object[0]) + ":");
        Widgets.layout(label, 0, 0, 4);
        this.widgetJobList = Widgets.newOptionMenu(composite);
        this.widgetJobList.setToolTipText(BARControl.tr("Existing job entries.", new Object[0]));
        Widgets.setOptionMenuItems(this.widgetJobList, new Object[0]);
        Widgets.layout(this.widgetJobList, 0, 1, 12);
        this.widgetJobList.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Combo combo = (Combo)selectionEvent.widget;
                int n = combo.getSelectionIndex();
                if (n >= 0) {
                    TabJobs.this.selectedJobData = (JobData)Widgets.getSelectedOptionMenuItem(TabJobs.this.widgetJobList, null);
                    Widgets.notify((Widget)TabJobs.this.shell, 65539, ((TabJobs)TabJobs.this).selectedJobData.uuid);
                }
            }
        });
        Button button = Widgets.newButton(composite, BARControl.tr("New", new Object[0]) + "\u2026");
        button.setToolTipText(BARControl.tr("Create new job entry.", new Object[0]));
        Widgets.layout(button, 0, 2, 0);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.jobNew();
            }
        });
        button = Widgets.newButton(composite, BARControl.tr("Clone", new Object[0]) + "\u2026", Settings.hasNormalRole());
        button.setToolTipText(BARControl.tr("Clone an existing job entry.", new Object[0]));
        button.setEnabled(false);
        Widgets.layout(button, 0, 3, 0);
        Widgets.addEventListener(new WidgetEventListener(button, this.selectJobEvent){

            @Override
            public void trigger(Control control) {
                Widgets.setEnabled(control, TabJobs.this.selectedJobData != null);
            }
        });
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (TabJobs.this.selectedJobData != null) {
                    TabJobs.this.jobClone();
                }
            }
        });
        button = Widgets.newButton(composite, BARControl.tr("Rename", new Object[0]) + "\u2026", Settings.hasNormalRole());
        button.setToolTipText(BARControl.tr("Rename a job entry.", new Object[0]));
        button.setEnabled(false);
        Widgets.layout(button, 0, 4, 0);
        Widgets.addEventListener(new WidgetEventListener(button, this.selectJobEvent){

            @Override
            public void trigger(Control control) {
                Widgets.setEnabled(control, TabJobs.this.selectedJobData != null);
            }
        });
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (TabJobs.this.selectedJobData != null) {
                    TabJobs.this.jobRename();
                }
            }
        });
        button = Widgets.newButton(composite, BARControl.tr("Delete", new Object[0]) + "\u2026");
        button.setToolTipText(BARControl.tr("Delete a job entry.", new Object[0]));
        button.setEnabled(false);
        Widgets.layout(button, 0, 5, 0);
        Widgets.addEventListener(new WidgetEventListener(button, this.selectJobEvent){

            @Override
            public void trigger(Control control) {
                Widgets.setEnabled(control, TabJobs.this.selectedJobData != null);
            }
        });
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (TabJobs.this.selectedJobData != null) {
                    TabJobs.this.jobDelete();
                }
            }
        });
        composite = Widgets.newComposite(this.widgetTab, Settings.hasExpertRole());
        composite.setLayout(new TableLayout(null, new double[]{0.0, 1.0, 0.0, 0.0, 0.0}));
        Widgets.layout(composite, 1, 0, 12);
        label = Widgets.newLabel(composite, BARControl.tr("Slave", new Object[0]) + ":");
        Widgets.layout(label, 0, 0, 4);
        Text text = Widgets.newText(composite);
        text.setToolTipText(BARControl.tr("Hostname of slave to run job. Leave empty to run on host where BAR is executed.", new Object[0]));
        text.setEnabled(false);
        Widgets.layout(text, 0, 1, 12);
        Widgets.addEventListener(new WidgetEventListener(text, this.selectJobEvent){

            @Override
            public void trigger(Control control) {
                Widgets.setEnabled(control, TabJobs.this.selectedJobData != null);
            }
        });
        text.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                Text text = (Text)modifyEvent.widget;
                String string = text.getText().trim();
                Color color = TabJobs.this.COLOR_MODIFIED;
                if (TabJobs.this.slaveHostName.getString().equals(string)) {
                    color = null;
                }
                text.setBackground(color);
            }
        });
        text.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                Text text = (Text)selectionEvent.widget;
                String string = text.getText().trim();
                try {
                    TabJobs.this.slaveHostName.set(string);
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.slaveHostName);
                    text.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
            }
        });
        text.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Text text = (Text)focusEvent.widget;
                String string = text.getText().trim();
                try {
                    TabJobs.this.slaveHostName.set(string);
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.slaveHostName);
                    text.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener((Widget)text, this.slaveHostName));
        label = Widgets.newLabel(composite, BARControl.tr("Port", new Object[0]) + ":");
        Widgets.layout(label, 0, 2, 4);
        Spinner spinner = Widgets.newSpinner(composite);
        spinner.setToolTipText(BARControl.tr("Port number. Set to 0 to use default port number from configuration file.", new Object[0]));
        spinner.setMinimum(0);
        spinner.setMaximum(65535);
        spinner.setEnabled(false);
        Widgets.layout(spinner, 0, 3, 4, 0, 0, 0, 0, 80, -1);
        Widgets.addEventListener(new WidgetEventListener(spinner, this.selectJobEvent){

            @Override
            public void trigger(Control control) {
                Widgets.setEnabled(control, TabJobs.this.selectedJobData != null && !TabJobs.this.slaveHostName.getString().isEmpty());
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(spinner, new WidgetVariable[]{this.slaveHostName}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                Widgets.setEnabled(control, !widgetVariable.getString().isEmpty());
            }
        });
        spinner.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                Spinner spinner = (Spinner)modifyEvent.widget;
                int n = spinner.getSelection();
                Color color = TabJobs.this.COLOR_MODIFIED;
                if (TabJobs.this.slaveHostPort.getInteger() == n) {
                    color = null;
                }
                spinner.setBackground(color);
                spinner.setData("showedErrorDialog", false);
            }
        });
        spinner.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                Spinner spinner = (Spinner)selectionEvent.widget;
                int n = spinner.getSelection();
                try {
                    TabJobs.this.slaveHostPort.set(n);
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.slaveHostPort);
                    spinner.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Spinner spinner = (Spinner)selectionEvent.widget;
                int n = spinner.getSelection();
                try {
                    TabJobs.this.slaveHostPort.set(n);
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.slaveHostPort);
                    spinner.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        spinner.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                Spinner spinner = (Spinner)focusEvent.widget;
                spinner.setData("showedErrorDialog", false);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Spinner spinner = (Spinner)focusEvent.widget;
                int n = spinner.getSelection();
                try {
                    TabJobs.this.slaveHostPort.set(n);
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.slaveHostPort);
                    spinner.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener((Widget)spinner, this.slaveHostPort));
        label = new Label(composite, 16384);
        label.setText(BARControl.tr("TLS", new Object[0]));
        label.setLayoutData(new TableLayoutData(0, 4, 4));
        Combo combo = Widgets.newOptionMenu(composite);
        Widgets.setOptionMenuItems(combo, new Object[]{BARControl.tr("none", new Object[0]), BARServer.TLSModes.NONE, BARControl.tr("try", new Object[0]), BARServer.TLSModes.TRY, BARControl.tr("force", new Object[0]), BARServer.TLSModes.FORCE});
        Widgets.setSelectedOptionMenuItem(combo, BARServer.TLSModes.FORCE);
        Widgets.layout(combo, 0, 5, 4);
        Widgets.addEventListener(new WidgetEventListener(combo, this.selectJobEvent){

            @Override
            public void trigger(Control control) {
                Widgets.setEnabled(control, TabJobs.this.selectedJobData != null && !TabJobs.this.slaveHostName.getString().isEmpty());
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(combo, new WidgetVariable[]{this.slaveHostName}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                Widgets.setEnabled(control, !widgetVariable.getString().isEmpty());
            }
        });
        combo.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Combo combo = (Combo)selectionEvent.widget;
                BARServer.TLSModes tLSModes = Widgets.getSelectedComboItem(combo, BARServer.TLSModes.NONE);
                try {
                    TabJobs.this.slaveTLSMode.set(tLSModes.toString());
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.slaveTLSMode);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener((Widget)combo, this.slaveTLSMode));
        this.widgetTabFolder = Widgets.newTabFolder(this.widgetTab);
        Widgets.setEnabled(this.widgetTabFolder, false);
        Widgets.layout(this.widgetTabFolder, 2, 0, 15);
        Composite composite2 = Widgets.addTab(this.widgetTabFolder, BARControl.tr("Entries", new Object[0]));
        composite2.setLayout(new TableLayout(new double[]{1.0, 0.0}, 1.0));
        Widgets.layout(composite2, 0, 0, 15);
        this.widgetFileTree = Widgets.newTree(composite2, 2);
        Widgets.layout(this.widgetFileTree, 0, 0, 15);
        Object object = new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TreeColumn treeColumn = (TreeColumn)selectionEvent.widget;
                FileTreeDataComparator fileTreeDataComparator = new FileTreeDataComparator(TabJobs.this.widgetFileTree, treeColumn);
                Tree tree = TabJobs.this.widgetFileTree;
                synchronized (tree) {
                    Widgets.sortTreeColumn(TabJobs.this.widgetFileTree, treeColumn, fileTreeDataComparator);
                }
            }
        };
        TreeColumn treeColumn = Widgets.addTreeColumn(this.widgetFileTree, "Name", 16384, 390, true);
        treeColumn.setToolTipText(BARControl.tr("Click to sort by name.", new Object[0]));
        treeColumn.addSelectionListener((SelectionListener)object);
        treeColumn = Widgets.addTreeColumn(this.widgetFileTree, "Type", 16384, 160, true);
        treeColumn.setToolTipText(BARControl.tr("Click to sort by type.", new Object[0]));
        treeColumn.addSelectionListener((SelectionListener)object);
        treeColumn = Widgets.addTreeColumn(this.widgetFileTree, "Size", 131072, 100, true);
        treeColumn.setToolTipText(BARControl.tr("Click to sort by size.", new Object[0]));
        treeColumn.addSelectionListener((SelectionListener)object);
        treeColumn = Widgets.addTreeColumn(this.widgetFileTree, "Modified", 16384, 100, true);
        treeColumn.setToolTipText(BARControl.tr("Click to sort by modification time.", new Object[0]));
        treeColumn.addSelectionListener((SelectionListener)object);
        this.widgetFileTree.addListener(17, new Listener(){

            @Override
            public void handleEvent(Event event) {
                TreeItem treeItem = (TreeItem)event.item;
                TabJobs.this.updateFileTree(treeItem);
            }
        });
        this.widgetFileTree.addListener(18, new Listener(){

            @Override
            public void handleEvent(Event event) {
                TreeItem treeItem = (TreeItem)event.item;
                if (!treeItem.isDisposed()) {
                    treeItem.removeAll();
                    new TreeItem(treeItem, 0);
                }
            }
        });
        this.widgetFileTree.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TreeItem treeItem = (TreeItem)selectionEvent.item;
                if (treeItem != null) {
                    FileTreeData fileTreeData = (FileTreeData)treeItem.getData();
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    if (TabJobs.this.isIncluded(fileTreeData.name) && !TabJobs.this.isExcluded(fileTreeData.name)) {
                        bl = true;
                    } else if (fileTreeData.noBackup) {
                        bl4 = true;
                    } else if (fileTreeData.noDump) {
                        bl3 = true;
                    } else if (TabJobs.this.excludeHashSet.contains(fileTreeData.name)) {
                        bl2 = true;
                    } else {
                        bl5 = true;
                    }
                    TabJobs.this.menuItemOpenClose.setEnabled(fileTreeData.fileType == BARServer.FileTypes.DIRECTORY);
                    TabJobs.this.menuItemInclude.setSelection(bl);
                    TabJobs.this.menuItemExcludeByList.setSelection(bl2);
                    TabJobs.this.menuItemExcludeByNoBackup.setSelection(bl4);
                    TabJobs.this.menuItemExcludeByNoDump.setSelection(bl3);
                    TabJobs.this.menuItemNone.setSelection(bl5);
                    TabJobs.this.widgetInclude.setEnabled(!bl);
                    TabJobs.this.widgetExclude.setEnabled(!bl2 && !bl4 && !bl3);
                    TabJobs.this.widgetNone.setEnabled(!bl5);
                }
            }
        });
        this.widgetFileTree.addMouseListener(new MouseListener(){

            @Override
            public void mouseDoubleClick(MouseEvent mouseEvent) {
                TreeItem treeItem = TabJobs.this.widgetFileTree.getItem(new Point(mouseEvent.x, mouseEvent.y));
                if (treeItem != null) {
                    FileTreeData fileTreeData = (FileTreeData)treeItem.getData();
                    if (fileTreeData.fileType == BARServer.FileTypes.DIRECTORY) {
                        Event event = new Event();
                        event.item = treeItem;
                        if (treeItem.getExpanded()) {
                            TabJobs.this.widgetFileTree.notifyListeners(18, event);
                            treeItem.setExpanded(false);
                        } else {
                            TabJobs.this.widgetFileTree.notifyListeners(17, event);
                            treeItem.setExpanded(true);
                        }
                    }
                }
            }

            @Override
            public void mouseDown(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseUp(MouseEvent mouseEvent) {
            }
        });
        this.widgetFileTree.addMouseTrackListener(new MouseTrackListener(){

            @Override
            public void mouseEnter(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExit(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseHover(MouseEvent mouseEvent) {
                Tree tree = (Tree)mouseEvent.widget;
                if (TabJobs.this.widgetFileTreeToolTip != null) {
                    TabJobs.this.widgetFileTreeToolTip.dispose();
                    TabJobs.this.widgetFileTreeToolTip = null;
                }
                if (mouseEvent.x > tree.getBounds().width / 2) {
                    Color color = TabJobs.this.display.getSystemColor(28);
                    Color color2 = TabJobs.this.display.getSystemColor(29);
                    TabJobs.this.widgetFileTreeToolTip = new Shell(TabJobs.this.shell, 540676);
                    TabJobs.this.widgetFileTreeToolTip.setBackground(color2);
                    TabJobs.this.widgetFileTreeToolTip.setLayout(new TableLayout(0.0, new double[]{0.0, 1.0}, 2));
                    Widgets.layout(TabJobs.this.widgetFileTreeToolTip, 0, 0, 15);
                    Label label = Widgets.newLabel((Composite)TabJobs.this.widgetFileTreeToolTip, BARControl.tr("Tree representation of files, directories, links and special entries.\nDouble-click to open sub-directories, right-click to open context menu.\nNote size column: numbers in red color indicates size update is still in progress.", new Object[0]));
                    label.setForeground(color);
                    label.setBackground(color2);
                    Widgets.layout(label, 0, 0, 4);
                    Point point = TabJobs.this.display.getCursorLocation();
                    if (point.x > 16) {
                        point.x -= 16;
                    }
                    if (point.y > 16) {
                        point.y -= 16;
                    }
                    Widgets.showToolTip(TabJobs.this.widgetFileTreeToolTip, point.x, point.y);
                }
            }
        });
        this.widgetFileTree.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                TreeItem treeItem;
                if ((Widgets.isAccelerator(keyEvent, 13) || Widgets.isAccelerator(keyEvent, 0x1000050)) && (treeItem = TabJobs.this.widgetFileTree.getSelection()[0]) != null) {
                    FileTreeData fileTreeData = (FileTreeData)treeItem.getData();
                    if (fileTreeData.fileType == BARServer.FileTypes.DIRECTORY) {
                        Event event = new Event();
                        event.item = treeItem;
                        if (treeItem.getExpanded()) {
                            TabJobs.this.widgetFileTree.notifyListeners(18, event);
                            treeItem.setExpanded(false);
                        } else {
                            TabJobs.this.widgetFileTree.notifyListeners(17, event);
                            treeItem.setExpanded(true);
                        }
                    }
                }
            }
        });
        Menu menu = Widgets.newPopupMenu(this.shell);
        this.menuItemOpenClose = Widgets.addMenuItem(menu, BARControl.tr("Open/Close", new Object[0]));
        this.menuItemOpenClose.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuItem menuItem = (MenuItem)selectionEvent.widget;
                TreeItem[] treeItemArray = TabJobs.this.widgetFileTree.getSelection();
                if (treeItemArray != null) {
                    FileTreeData fileTreeData = (FileTreeData)treeItemArray[0].getData();
                    if (fileTreeData.fileType == BARServer.FileTypes.DIRECTORY) {
                        Event event = new Event();
                        event.item = treeItemArray[0];
                        if (treeItemArray[0].getExpanded()) {
                            TabJobs.this.widgetFileTree.notifyListeners(18, event);
                            treeItemArray[0].setExpanded(false);
                        } else {
                            TabJobs.this.widgetFileTree.notifyListeners(17, event);
                            treeItemArray[0].setExpanded(true);
                        }
                    }
                }
            }
        });
        Widgets.addMenuItemSeparator(menu);
        this.menuItemInclude = Widgets.addMenuItemRadio(menu, BARControl.tr("Include", new Object[0]));
        this.menuItemInclude.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuItem menuItem = (MenuItem)selectionEvent.widget;
                if (menuItem.getSelection()) {
                    block7: for (TreeItem treeItem : TabJobs.this.widgetFileTree.getSelection()) {
                        FileTreeData fileTreeData = (FileTreeData)treeItem.getData();
                        fileTreeData.include();
                        switch (fileTreeData.fileType) {
                            case FILE: {
                                treeItem.setImage(TabJobs.this.IMAGE_FILE_INCLUDED);
                                continue block7;
                            }
                            case DIRECTORY: {
                                treeItem.setImage(TabJobs.this.IMAGE_DIRECTORY_INCLUDED);
                                continue block7;
                            }
                            case LINK: {
                                treeItem.setImage(TabJobs.this.IMAGE_LINK_INCLUDED);
                                continue block7;
                            }
                            case HARDLINK: {
                                treeItem.setImage(TabJobs.this.IMAGE_LINK_INCLUDED);
                                continue block7;
                            }
                            case SPECIAL: {
                                treeItem.setImage(TabJobs.this.IMAGE_FILE_INCLUDED);
                            }
                        }
                    }
                }
            }
        });
        this.menuItemExcludeByList = Widgets.addMenuItemRadio(menu, BARControl.tr("Exclude", new Object[0]));
        this.menuItemExcludeByList.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuItem menuItem = (MenuItem)selectionEvent.widget;
                if (menuItem.getSelection()) {
                    block7: for (TreeItem treeItem : TabJobs.this.widgetFileTree.getSelection()) {
                        FileTreeData fileTreeData = (FileTreeData)treeItem.getData();
                        fileTreeData.excludeByList();
                        switch (fileTreeData.fileType) {
                            case FILE: {
                                treeItem.setImage(TabJobs.this.IMAGE_FILE_EXCLUDED);
                                continue block7;
                            }
                            case DIRECTORY: {
                                treeItem.setImage(TabJobs.this.IMAGE_DIRECTORY_EXCLUDED);
                                continue block7;
                            }
                            case LINK: {
                                treeItem.setImage(TabJobs.this.IMAGE_LINK_EXCLUDED);
                                continue block7;
                            }
                            case HARDLINK: {
                                treeItem.setImage(TabJobs.this.IMAGE_LINK_EXCLUDED);
                                continue block7;
                            }
                            case SPECIAL: {
                                treeItem.setImage(TabJobs.this.IMAGE_FILE_EXCLUDED);
                            }
                        }
                    }
                }
            }
        });
        this.menuItemExcludeByNoBackup = Widgets.addMenuItemRadio(menu, BARControl.tr("Exclude by .nobackup", new Object[0]), Settings.hasExpertRole());
        this.menuItemExcludeByNoBackup.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuItem menuItem = (MenuItem)selectionEvent.widget;
                if (menuItem.getSelection()) {
                    block7: for (TreeItem treeItem : TabJobs.this.widgetFileTree.getSelection()) {
                        FileTreeData fileTreeData = (FileTreeData)treeItem.getData();
                        fileTreeData.excludeByNoBackup();
                        switch (fileTreeData.fileType) {
                            case FILE: {
                                treeItem.setImage(TabJobs.this.IMAGE_FILE_EXCLUDED);
                                continue block7;
                            }
                            case DIRECTORY: {
                                treeItem.setImage(TabJobs.this.IMAGE_DIRECTORY_EXCLUDED);
                                continue block7;
                            }
                            case LINK: {
                                treeItem.setImage(TabJobs.this.IMAGE_LINK_EXCLUDED);
                                continue block7;
                            }
                            case HARDLINK: {
                                treeItem.setImage(TabJobs.this.IMAGE_LINK_EXCLUDED);
                                continue block7;
                            }
                            case SPECIAL: {
                                treeItem.setImage(TabJobs.this.IMAGE_FILE_EXCLUDED);
                            }
                        }
                    }
                }
            }
        });
        this.menuItemExcludeByNoDump = Widgets.addMenuItemRadio(menu, BARControl.tr("Exclude by no dump", new Object[0]), Settings.hasExpertRole());
        this.menuItemExcludeByNoDump.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuItem menuItem = (MenuItem)selectionEvent.widget;
                if (menuItem.getSelection()) {
                    block7: for (TreeItem treeItem : TabJobs.this.widgetFileTree.getSelection()) {
                        FileTreeData fileTreeData = (FileTreeData)treeItem.getData();
                        fileTreeData.excludeByNoDump();
                        switch (fileTreeData.fileType) {
                            case FILE: {
                                treeItem.setImage(TabJobs.this.IMAGE_FILE_EXCLUDED);
                                continue block7;
                            }
                            case DIRECTORY: {
                                treeItem.setImage(TabJobs.this.IMAGE_DIRECTORY_EXCLUDED);
                                continue block7;
                            }
                            case LINK: {
                                treeItem.setImage(TabJobs.this.IMAGE_LINK_EXCLUDED);
                                continue block7;
                            }
                            case HARDLINK: {
                                treeItem.setImage(TabJobs.this.IMAGE_LINK_EXCLUDED);
                                continue block7;
                            }
                            case SPECIAL: {
                                treeItem.setImage(TabJobs.this.IMAGE_FILE_EXCLUDED);
                            }
                        }
                    }
                }
            }
        });
        this.menuItemNone = Widgets.addMenuItemRadio(menu, BARControl.tr("None", new Object[0]));
        this.menuItemNone.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuItem menuItem = (MenuItem)selectionEvent.widget;
                if (menuItem.getSelection()) {
                    block7: for (TreeItem treeItem : TabJobs.this.widgetFileTree.getSelection()) {
                        FileTreeData fileTreeData = (FileTreeData)treeItem.getData();
                        fileTreeData.none();
                        switch (fileTreeData.fileType) {
                            case FILE: {
                                treeItem.setImage(TabJobs.this.IMAGE_FILE);
                                continue block7;
                            }
                            case DIRECTORY: {
                                treeItem.setImage(TabJobs.this.IMAGE_DIRECTORY);
                                continue block7;
                            }
                            case LINK: {
                                treeItem.setImage(TabJobs.this.IMAGE_LINK);
                                continue block7;
                            }
                            case HARDLINK: {
                                treeItem.setImage(TabJobs.this.IMAGE_LINK);
                                continue block7;
                            }
                            case SPECIAL: {
                                treeItem.setImage(TabJobs.this.IMAGE_FILE);
                            }
                        }
                    }
                }
            }
        });
        Widgets.addMenuItemSeparator(menu);
        MenuItem menuItem = Widgets.addMenuItem(menu, BARControl.tr("Add mount", new Object[0]) + "\u2026", Settings.hasExpertRole());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                for (TreeItem treeItem : TabJobs.this.widgetFileTree.getSelection()) {
                    FileTreeData fileTreeData = (FileTreeData)treeItem.getData();
                    TabJobs.this.mountListAdd(fileTreeData.name);
                }
            }
        });
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Remove mount", new Object[0]), Settings.hasExpertRole());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                for (TreeItem treeItem : TabJobs.this.widgetFileTree.getSelection()) {
                    FileTreeData fileTreeData = (FileTreeData)treeItem.getData();
                    TabJobs.this.mountListRemove(fileTreeData.name);
                }
            }
        });
        Widgets.addMenuItemSeparator(menu, Settings.hasExpertRole());
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Directory/File size", new Object[0]));
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                for (TreeItem treeItem : TabJobs.this.widgetFileTree.getSelection()) {
                    FileTreeData fileTreeData = (FileTreeData)treeItem.getData();
                    TabJobs.this.directoryInfoThread.add(((TabJobs)TabJobs.this).selectedJobData.uuid, fileTreeData.name, true, treeItem);
                }
            }
        });
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuShown(MenuEvent menuEvent) {
                if (TabJobs.this.widgetFileTreeToolTip != null) {
                    TabJobs.this.widgetFileTreeToolTip.dispose();
                    TabJobs.this.widgetFileTreeToolTip = null;
                }
            }

            @Override
            public void menuHidden(MenuEvent menuEvent) {
            }
        });
        this.widgetFileTree.setMenu(menu);
        composite = Widgets.newComposite(composite2, 0, 4);
        composite.setLayout(new TableLayout(1.0, new double[]{1.0, 1.0, 1.0, 0.0, 0.0, 0.0}));
        Widgets.layout(composite, 1, 0, 12);
        this.widgetInclude = Widgets.newButton(composite, BARControl.tr("Include", new Object[0]));
        this.widgetInclude.setToolTipText(BARControl.tr("Include entry in archive.", new Object[0]));
        Widgets.layout(this.widgetInclude, 0, 0, 12);
        this.widgetInclude.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                block7: for (TreeItem treeItem : TabJobs.this.widgetFileTree.getSelection()) {
                    FileTreeData fileTreeData = (FileTreeData)treeItem.getData();
                    fileTreeData.include();
                    switch (fileTreeData.fileType) {
                        case FILE: {
                            treeItem.setImage(TabJobs.this.IMAGE_FILE_INCLUDED);
                            continue block7;
                        }
                        case DIRECTORY: {
                            treeItem.setImage(TabJobs.this.IMAGE_DIRECTORY_INCLUDED);
                            continue block7;
                        }
                        case LINK: {
                            treeItem.setImage(TabJobs.this.IMAGE_LINK_INCLUDED);
                            continue block7;
                        }
                        case HARDLINK: {
                            treeItem.setImage(TabJobs.this.IMAGE_LINK_INCLUDED);
                            continue block7;
                        }
                        case SPECIAL: {
                            treeItem.setImage(TabJobs.this.IMAGE_FILE_INCLUDED);
                        }
                    }
                }
            }
        });
        this.widgetExclude = Widgets.newButton(composite, BARControl.tr("Exclude", new Object[0]));
        this.widgetExclude.setToolTipText(BARControl.tr("Exclude entry from archive.", new Object[0]));
        Widgets.layout(this.widgetExclude, 0, 1, 12);
        this.widgetExclude.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                block7: for (TreeItem treeItem : TabJobs.this.widgetFileTree.getSelection()) {
                    FileTreeData fileTreeData = (FileTreeData)treeItem.getData();
                    fileTreeData.excludeByList();
                    switch (fileTreeData.fileType) {
                        case FILE: {
                            treeItem.setImage(TabJobs.this.IMAGE_FILE_EXCLUDED);
                            continue block7;
                        }
                        case DIRECTORY: {
                            treeItem.setImage(TabJobs.this.IMAGE_DIRECTORY_EXCLUDED);
                            continue block7;
                        }
                        case LINK: {
                            treeItem.setImage(TabJobs.this.IMAGE_LINK_EXCLUDED);
                            continue block7;
                        }
                        case HARDLINK: {
                            treeItem.setImage(TabJobs.this.IMAGE_LINK_EXCLUDED);
                            continue block7;
                        }
                        case SPECIAL: {
                            treeItem.setImage(TabJobs.this.IMAGE_FILE_EXCLUDED);
                        }
                    }
                }
            }
        });
        this.widgetNone = Widgets.newButton(composite, BARControl.tr("None", new Object[0]));
        this.widgetNone.setToolTipText(BARControl.tr("Do not include/exclude entry in/from archive.", new Object[0]));
        Widgets.layout(this.widgetNone, 0, 2, 12);
        this.widgetNone.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                block7: for (TreeItem treeItem : TabJobs.this.widgetFileTree.getSelection()) {
                    FileTreeData fileTreeData = (FileTreeData)treeItem.getData();
                    fileTreeData.none();
                    switch (fileTreeData.fileType) {
                        case FILE: {
                            treeItem.setImage(TabJobs.this.IMAGE_FILE);
                            continue block7;
                        }
                        case DIRECTORY: {
                            treeItem.setImage(TabJobs.this.IMAGE_DIRECTORY);
                            continue block7;
                        }
                        case LINK: {
                            treeItem.setImage(TabJobs.this.IMAGE_LINK);
                            continue block7;
                        }
                        case HARDLINK: {
                            treeItem.setImage(TabJobs.this.IMAGE_LINK);
                            continue block7;
                        }
                        case SPECIAL: {
                            treeItem.setImage(TabJobs.this.IMAGE_FILE);
                        }
                    }
                }
            }
        });
        Control control = Widgets.newSpacer(composite);
        Widgets.layout(control, 0, 3, 0, 0, 0, 30, 0);
        button = Widgets.newButton(composite, this.IMAGE_DIRECTORY_INCLUDED);
        button.setToolTipText(BARControl.tr("Open all included directories.", new Object[0]));
        Widgets.layout((Control)button, 0, 4, 8, 0, 0, 2, 0);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.openAllIncludedDirectories();
            }
        });
        button = Widgets.newCheckbox(composite, BARControl.tr("directory size", new Object[0]));
        button.setToolTipText(BARControl.tr("Show directory sizes (sum of file sizes).", new Object[0]));
        Widgets.layout((Control)button, 0, 5, 8, 0, 0, 2, 0);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                TabJobs.this.directorySizesFlag = button.getSelection();
            }
        });
        composite2 = Widgets.addTab(this.widgetTabFolder, BARControl.tr("Images", new Object[0]), Settings.hasExpertRole());
        composite2.setLayout(new TableLayout(new double[]{1.0, 0.0}, 1.0));
        Widgets.layout(composite2, 0, 0, 15);
        this.widgetDeviceTable = Widgets.newTable(composite2, 2);
        this.widgetDeviceTable.setToolTipText(BARControl.tr("List of existing devices for image storage.\nRight-click to open context menu.", new Object[0]));
        Widgets.layout(this.widgetDeviceTable, 0, 0, 15);
        object = new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TableColumn tableColumn = (TableColumn)selectionEvent.widget;
                DeviceDataComparator deviceDataComparator = new DeviceDataComparator(TabJobs.this.widgetDeviceTable, tableColumn);
                Table table = TabJobs.this.widgetDeviceTable;
                synchronized (table) {
                    Widgets.sortTableColumn(TabJobs.this.widgetDeviceTable, tableColumn, deviceDataComparator);
                }
            }
        };
        TableColumn tableColumn = Widgets.addTableColumn(this.widgetDeviceTable, 0, "Name", 16384, 500, true);
        tableColumn.addSelectionListener((SelectionListener)object);
        tableColumn = Widgets.addTableColumn(this.widgetDeviceTable, 1, "Type", 16384, 100, false);
        tableColumn.addSelectionListener((SelectionListener)object);
        tableColumn = Widgets.addTableColumn(this.widgetDeviceTable, 2, "Size", 131072, 100, false);
        tableColumn.addSelectionListener((SelectionListener)object);
        menu = Widgets.newPopupMenu(this.shell);
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Include", new Object[0]));
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuItem menuItem = (MenuItem)selectionEvent.widget;
                for (TableItem tableItem : TabJobs.this.widgetDeviceTable.getSelection()) {
                    DeviceData deviceData = (DeviceData)tableItem.getData();
                    deviceData.include();
                    tableItem.setImage(TabJobs.this.IMAGE_DEVICE_INCLUDED);
                }
            }
        });
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Exclude", new Object[0]));
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                for (TableItem tableItem : TabJobs.this.widgetDeviceTable.getSelection()) {
                    DeviceData deviceData = (DeviceData)tableItem.getData();
                    deviceData.exclude();
                    tableItem.setImage(TabJobs.this.IMAGE_DEVICE_EXCLUDED);
                }
            }
        });
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("None", new Object[0]));
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                for (TableItem tableItem : TabJobs.this.widgetDeviceTable.getSelection()) {
                    DeviceData deviceData = (DeviceData)tableItem.getData();
                    TabJobs.this.includeListRemove(deviceData.name);
                    TabJobs.this.excludeListRemove(deviceData.name);
                    tableItem.setImage(TabJobs.this.IMAGE_DEVICE);
                }
            }
        });
        this.widgetDeviceTable.setMenu(menu);
        composite = Widgets.newComposite(composite2);
        composite.setLayout(new TableLayout(1.0, new double[]{1.0, 1.0, 1.0, 0.0, 0.0, 0.0}));
        Widgets.layout(composite, 1, 0, 12);
        button = Widgets.newButton(composite, BARControl.tr("Include", new Object[0]));
        button.setToolTipText(BARControl.tr("Include selected device for image storage.", new Object[0]));
        Widgets.layout(button, 0, 0, 12);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                for (TableItem tableItem : TabJobs.this.widgetDeviceTable.getSelection()) {
                    DeviceData deviceData = (DeviceData)tableItem.getData();
                    deviceData.include();
                    tableItem.setImage(TabJobs.this.IMAGE_DEVICE_INCLUDED);
                }
            }
        });
        button = Widgets.newButton(composite, BARControl.tr("Exclude", new Object[0]));
        button.setToolTipText(BARControl.tr("Exclude selected device from image storage.", new Object[0]));
        Widgets.layout(button, 0, 1, 12);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                for (TableItem tableItem : TabJobs.this.widgetDeviceTable.getSelection()) {
                    DeviceData deviceData = (DeviceData)tableItem.getData();
                    deviceData.exclude();
                    tableItem.setImage(TabJobs.this.IMAGE_DEVICE_EXCLUDED);
                }
            }
        });
        button = Widgets.newButton(composite, BARControl.tr("None", new Object[0]));
        button.setToolTipText(BARControl.tr("Remove selected device from image storage.", new Object[0]));
        Widgets.layout(button, 0, 2, 12);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                for (TableItem tableItem : TabJobs.this.widgetDeviceTable.getSelection()) {
                    DeviceData deviceData = (DeviceData)tableItem.getData();
                    deviceData.none();
                    TabJobs.this.includeListRemove(deviceData.name);
                    TabJobs.this.excludeListRemove(deviceData.name);
                    tableItem.setImage(TabJobs.this.IMAGE_DEVICE);
                }
            }
        });
        composite2 = Widgets.addTab(this.widgetTabFolder, Settings.hasNormalRole() ? BARControl.tr("Filters && Mounts", new Object[0]) : BARControl.tr("Filters", new Object[0]));
        composite2.setLayout(new TableLayout(new double[]{1.0, 0.0}, 1.0));
        Widgets.layout(composite2, 0, 0, 15);
        TabFolder tabFolder2 = Widgets.newTabFolder(composite2);
        Widgets.layout(tabFolder2, 0, 0, 15);
        Composite composite3 = Widgets.addTab(tabFolder2, BARControl.tr("Included", new Object[0]));
        composite3.setLayout(new TableLayout(new double[]{1.0, 0.0}, 1.0));
        Widgets.layout(composite3, 0, 0, 15);
        this.widgetIncludeTable = Widgets.newTable(composite3);
        this.widgetIncludeTable.setToolTipText(BARControl.tr("List of include patterns, right-click for context menu.", new Object[0]));
        this.widgetIncludeTable.setHeaderVisible(false);
        this.widgetIncludeTable.setLayout(new TableLayout(null, 1.0));
        Widgets.addTableColumn(this.widgetIncludeTable, 0, 16384, 0, true);
        Widgets.layout(this.widgetIncludeTable, 0, 0, 15);
        this.widgetIncludeTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseDoubleClick(MouseEvent mouseEvent) {
                TabJobs.this.includeListEdit();
            }

            @Override
            public void mouseDown(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseUp(MouseEvent mouseEvent) {
            }
        });
        this.widgetIncludeTable.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (Widgets.isAccelerator(keyEvent, 0x1000009)) {
                    Widgets.invoke(TabJobs.this.widgetIncludeTableAdd);
                } else if (Widgets.isAccelerator(keyEvent, 127)) {
                    Widgets.invoke(TabJobs.this.widgetIncludeTableRemove);
                } else if (Widgets.isAccelerator(keyEvent, 13) || Widgets.isAccelerator(keyEvent, 0x1000050)) {
                    Widgets.invoke(TabJobs.this.widgetIncludeTableEdit);
                }
            }
        });
        menu = Widgets.newPopupMenu(this.shell);
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Add", new Object[0]) + "\u2026");
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.includeListAdd();
            }
        });
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Edit", new Object[0]) + "\u2026");
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.includeListEdit();
            }
        });
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Clone", new Object[0]) + "\u2026", Settings.hasNormalRole());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.includeListClone();
            }
        });
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Remove", new Object[0]) + "\u2026");
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.includeListRemove();
            }
        });
        this.widgetIncludeTable.setMenu(menu);
        composite = Widgets.newComposite(composite3);
        Widgets.layout(composite, 1, 0, 12);
        this.widgetIncludeTableAdd = Widgets.newButton(composite, BARControl.tr("Add", new Object[0]) + "\u2026");
        this.widgetIncludeTableAdd.setToolTipText(BARControl.tr("Add entry to included list.", new Object[0]));
        Widgets.layout(this.widgetIncludeTableAdd, 0, 0, 4, 0, 0, 0, 0, 110, -1);
        this.widgetIncludeTableAdd.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.includeListAdd();
            }
        });
        this.widgetIncludeTableEdit = Widgets.newButton(composite, BARControl.tr("Edit", new Object[0]) + "\u2026");
        this.widgetIncludeTableEdit.setToolTipText(BARControl.tr("Edit entry in included list.", new Object[0]));
        Widgets.layout(this.widgetIncludeTableEdit, 0, 1, 4, 0, 0, 0, 0, 110, -1);
        this.widgetIncludeTableEdit.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.includeListEdit();
            }
        });
        button = Widgets.newButton(composite, BARControl.tr("Clone", new Object[0]) + "\u2026", Settings.hasNormalRole());
        button.setToolTipText(BARControl.tr("Clone entry in included list.", new Object[0]));
        Widgets.layout(button, 0, 2, 4, 0, 0, 0, 0, 110, -1);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.includeListClone();
            }
        });
        this.widgetIncludeTableRemove = Widgets.newButton(composite, BARControl.tr("Remove", new Object[0]) + "\u2026");
        this.widgetIncludeTableRemove.setToolTipText(BARControl.tr("Remove entry from included list.", new Object[0]));
        Widgets.layout(this.widgetIncludeTableRemove, 0, 3, 4, 0, 0, 0, 0, 110, -1);
        this.widgetIncludeTableRemove.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.includeListRemove();
            }
        });
        composite3 = Widgets.addTab(tabFolder2, BARControl.tr("Excluded", new Object[0]));
        composite3.setLayout(new TableLayout(new double[]{1.0, 0.0}, 1.0));
        Widgets.layout(composite3, 0, 0, 15);
        this.widgetExcludeList = Widgets.newList(composite3);
        this.widgetExcludeList.setToolTipText(BARControl.tr("List of exclude patterns, right-click for context menu.", new Object[0]));
        Widgets.layout(this.widgetExcludeList, 0, 0, 15);
        this.widgetExcludeList.addMouseListener(new MouseListener(){

            @Override
            public void mouseDoubleClick(MouseEvent mouseEvent) {
                TabJobs.this.excludeListEdit();
            }

            @Override
            public void mouseDown(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseUp(MouseEvent mouseEvent) {
            }
        });
        this.widgetExcludeList.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (Widgets.isAccelerator(keyEvent, 0x1000009)) {
                    Widgets.invoke(TabJobs.this.widgetExcludeListAdd);
                } else if (Widgets.isAccelerator(keyEvent, 127)) {
                    Widgets.invoke(TabJobs.this.widgetExcludeListRemove);
                } else if (Widgets.isAccelerator(keyEvent, 13) || Widgets.isAccelerator(keyEvent, 0x1000050)) {
                    Widgets.invoke(TabJobs.this.widgetExcludeListEdit);
                }
            }
        });
        menu = Widgets.newPopupMenu(this.shell);
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Add", new Object[0]) + "\u2026");
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.excludeListAdd();
            }
        });
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Edit", new Object[0]) + "\u2026");
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.excludeListEdit();
            }
        });
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Clone", new Object[0]) + "\u2026", Settings.hasNormalRole());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.excludeListClone();
            }
        });
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Remove", new Object[0]) + "\u2026");
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.excludeListRemove();
            }
        });
        this.widgetExcludeList.setMenu(menu);
        composite = Widgets.newComposite(composite3);
        Widgets.layout(composite, 1, 0, 12);
        this.widgetExcludeListAdd = Widgets.newButton(composite, BARControl.tr("Add", new Object[0]) + "\u2026");
        this.widgetExcludeListAdd.setToolTipText(BARControl.tr("Add entry to excluded list.", new Object[0]));
        Widgets.layout(this.widgetExcludeListAdd, 0, 0, 4, 0, 0, 0, 0, 110, -1);
        this.widgetExcludeListAdd.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.excludeListAdd();
            }
        });
        this.widgetExcludeListEdit = Widgets.newButton(composite, BARControl.tr("Edit", new Object[0]) + "\u2026");
        this.widgetExcludeListEdit.setToolTipText(BARControl.tr("Edit entry in excluded list.", new Object[0]));
        Widgets.layout(this.widgetExcludeListEdit, 0, 1, 4, 0, 0, 0, 0, 110, -1);
        this.widgetExcludeListEdit.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.excludeListEdit();
            }
        });
        button = Widgets.newButton(composite, BARControl.tr("Clone", new Object[0]) + "\u2026", Settings.hasNormalRole());
        button.setToolTipText(BARControl.tr("Clone entry in excluded list.", new Object[0]));
        Widgets.layout(button, 0, 2, 4, 0, 0, 0, 0, 110, -1);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.excludeListClone();
            }
        });
        this.widgetExcludeListRemove = Widgets.newButton(composite, BARControl.tr("Remove", new Object[0]) + "\u2026");
        this.widgetExcludeListRemove.setToolTipText(BARControl.tr("Remove entry from excluded list.", new Object[0]));
        Widgets.layout(this.widgetExcludeListRemove, 0, 3, 4, 0, 0, 0, 0, 110, -1);
        this.widgetExcludeListRemove.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.excludeListRemove();
            }
        });
        composite3 = Widgets.addTab(tabFolder2, BARControl.tr("Include command", new Object[0]), Settings.hasExpertRole());
        composite3.setLayout(new TableLayout(1.0, 1.0));
        Widgets.layout(composite3, 0, 0, 15);
        Composite composite4 = Widgets.newComposite(composite3);
        composite4.setLayout(new TableLayout(new double[]{0.0, 1.0, 0.0}, 1.0));
        Widgets.layout(composite4, 0, 0, 15);
        label = Widgets.newLabel(composite4, BARControl.tr("Entries", new Object[0]) + ":");
        Widgets.layout(label, 0, 0, 4);
        StyledText styledText = Widgets.newStyledText(composite4, 19202);
        styledText.setToolTipText(BARControl.tr("Command or script to execute to get a list of entries to include.", new Object[0]));
        Widgets.layout(styledText, 1, 0, 15);
        styledText.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                StyledText styledText = (StyledText)modifyEvent.widget;
                String string = styledText.getText();
                Color color = TabJobs.this.COLOR_MODIFIED;
                if (TabJobs.this.includeFileCommand.equals(string.replace(styledText.getLineDelimiter(), "\n"))) {
                    color = null;
                }
                styledText.setBackground(color);
            }
        });
        styledText.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                StyledText styledText = (StyledText)selectionEvent.widget;
                String string = styledText.getText();
                try {
                    TabJobs.this.includeFileCommand.set(string.replace(styledText.getLineDelimiter(), "\n"));
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.includeFileCommand);
                    styledText.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
            }
        });
        styledText.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                StyledText styledText = (StyledText)focusEvent.widget;
                String string = styledText.getText();
                try {
                    TabJobs.this.includeFileCommand.set(string.replace(styledText.getLineDelimiter(), "\n"));
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.includeFileCommand);
                    styledText.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener((Widget)styledText, this.includeFileCommand));
        button = Widgets.newButton(composite4, BARControl.tr("Test", new Object[0]) + "\u2026");
        button.setToolTipText(BARControl.tr("Test script.", new Object[0]));
        Widgets.layout(button, 2, 0, 8);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.testScript("include-file-command", TabJobs.this.includeFileCommand.getString());
            }
        });
        composite4 = Widgets.newComposite(composite3);
        composite4.setLayout(new TableLayout(new double[]{0.0, 1.0, 0.0}, 1.0));
        Widgets.layout(composite4, 1, 0, 15);
        label = Widgets.newLabel(composite4, BARControl.tr("Images", new Object[0]) + ":");
        Widgets.layout(label, 0, 0, 4);
        styledText = Widgets.newStyledText(composite4, 19202);
        styledText.setToolTipText(BARControl.tr("Command or script to execute to get a list of images to include.", new Object[0]));
        Widgets.layout(styledText, 1, 0, 15);
        styledText.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                StyledText styledText = (StyledText)modifyEvent.widget;
                String string = styledText.getText();
                Color color = TabJobs.this.COLOR_MODIFIED;
                if (TabJobs.this.includeImageCommand.equals(string.replace(styledText.getLineDelimiter(), "\n"))) {
                    color = null;
                }
                styledText.setBackground(color);
            }
        });
        styledText.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                StyledText styledText = (StyledText)selectionEvent.widget;
                String string = styledText.getText();
                try {
                    TabJobs.this.includeImageCommand.set(string.replace(styledText.getLineDelimiter(), "\n"));
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.includeImageCommand);
                    styledText.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
            }
        });
        styledText.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                StyledText styledText = (StyledText)focusEvent.widget;
                String string = styledText.getText();
                try {
                    TabJobs.this.includeImageCommand.set(string.replace(styledText.getLineDelimiter(), "\n"));
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.includeImageCommand);
                    styledText.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener((Widget)styledText, this.includeImageCommand));
        button = Widgets.newButton(composite4, BARControl.tr("Test", new Object[0]) + "\u2026");
        button.setToolTipText(BARControl.tr("Test script.", new Object[0]));
        Widgets.layout(button, 2, 0, 8);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.testScript("include-image-command", TabJobs.this.includeImageCommand.getString());
            }
        });
        composite3 = Widgets.addTab(tabFolder2, BARControl.tr("Exclude command", new Object[0]), Settings.hasExpertRole());
        composite3.setLayout(new TableLayout(new double[]{1.0, 0.0}, 1.0));
        Widgets.layout(composite3, 0, 0, 15);
        styledText = Widgets.newStyledText(composite3, 19202);
        styledText.setToolTipText(BARControl.tr("Command or script to execute to get a list of entries/images to exclude.", new Object[0]));
        Widgets.layout(styledText, 0, 0, 15);
        styledText.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                StyledText styledText = (StyledText)modifyEvent.widget;
                String string = styledText.getText();
                Color color = TabJobs.this.COLOR_MODIFIED;
                if (TabJobs.this.excludeCommand.equals(string.replace(styledText.getLineDelimiter(), "\n"))) {
                    color = null;
                }
                styledText.setBackground(color);
            }
        });
        styledText.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                StyledText styledText = (StyledText)selectionEvent.widget;
                String string = styledText.getText();
                try {
                    TabJobs.this.excludeCommand.set(string.replace(styledText.getLineDelimiter(), "\n"));
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.excludeCommand);
                    styledText.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
            }
        });
        styledText.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                StyledText styledText = (StyledText)focusEvent.widget;
                String string = styledText.getText();
                try {
                    TabJobs.this.excludeCommand.set(string.replace(styledText.getLineDelimiter(), "\n"));
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.excludeCommand);
                    styledText.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener((Widget)styledText, this.excludeCommand));
        button = Widgets.newButton(composite3, BARControl.tr("Test", new Object[0]) + "\u2026");
        button.setToolTipText(BARControl.tr("Test script.", new Object[0]));
        Widgets.layout(button, 1, 0, 8);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.testScript("exclude-command", TabJobs.this.excludeCommand.getString());
            }
        });
        composite3 = Widgets.addTab(tabFolder2, BARControl.tr("Mounts", new Object[0]), Settings.hasNormalRole());
        composite3.setLayout(new TableLayout(new double[]{1.0, 0.0}, 1.0));
        Widgets.layout(composite3, 0, 0, 15);
        object = new Listener(){

            @Override
            public void handleEvent(Event event) {
                Settings.mountTableColumns = new Settings.ColumnWidth(Widgets.getTableColumnWidth(TabJobs.this.widgetMountTable));
            }
        };
        this.widgetMountTable = Widgets.newTable(composite3);
        this.widgetMountTable.setToolTipText(BARControl.tr("List of devices to mount, right-click for context menu.", new Object[0]));
        Widgets.layout(this.widgetMountTable, 0, 0, 15);
        tableColumn = Widgets.addTableColumn(this.widgetMountTable, 0, BARControl.tr("Name", new Object[0]), 16384, 600, true);
        tableColumn.addSelectionListener(Widgets.DEFAULT_TABLE_SELECTION_LISTENER_STRING);
        tableColumn.addListener(11, (Listener)object);
        tableColumn = Widgets.addTableColumn(this.widgetMountTable, 1, BARControl.tr("Device", new Object[0]), 16384, 100, true);
        tableColumn.addSelectionListener(Widgets.DEFAULT_TABLE_SELECTION_LISTENER_STRING);
        tableColumn.addListener(11, (Listener)object);
        Widgets.setTableColumnWidth(this.widgetMountTable, Settings.mountTableColumns.width);
        this.widgetMountTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseDoubleClick(MouseEvent mouseEvent) {
                TabJobs.this.mountListEdit();
            }

            @Override
            public void mouseDown(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseUp(MouseEvent mouseEvent) {
            }
        });
        this.widgetMountTable.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (Widgets.isAccelerator(keyEvent, 0x1000009)) {
                    Widgets.invoke(TabJobs.this.widgetMountTableAdd);
                } else if (Widgets.isAccelerator(keyEvent, 127)) {
                    Widgets.invoke(TabJobs.this.widgetMountTableRemove);
                } else if (Widgets.isAccelerator(keyEvent, 13) || Widgets.isAccelerator(keyEvent, 0x1000050)) {
                    Widgets.invoke(TabJobs.this.widgetMountTableEdit);
                }
            }
        });
        menu = Widgets.newPopupMenu(this.shell);
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Add", new Object[0]) + "\u2026");
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.mountListAdd();
            }
        });
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Edit", new Object[0]) + "\u2026");
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.mountListEdit();
            }
        });
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Clone", new Object[0]) + "\u2026", Settings.hasNormalRole());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.mountListClone();
            }
        });
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Remove", new Object[0]) + "\u2026");
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.mountListRemove();
            }
        });
        this.widgetMountTable.setMenu(menu);
        composite = Widgets.newComposite(composite3);
        Widgets.layout(composite, 1, 0, 12);
        this.widgetMountTableAdd = Widgets.newButton(composite, BARControl.tr("Add", new Object[0]) + "\u2026");
        this.widgetMountTableAdd.setToolTipText(BARControl.tr("Add entry to mount list.", new Object[0]));
        Widgets.layout(this.widgetMountTableAdd, 0, 0, 4, 0, 0, 0, 0, 110, -1);
        this.widgetMountTableAdd.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.mountListAdd();
            }
        });
        this.widgetMountTableEdit = Widgets.newButton(composite, BARControl.tr("Edit", new Object[0]) + "\u2026");
        this.widgetMountTableEdit.setToolTipText(BARControl.tr("Edit entry in mount list.", new Object[0]));
        Widgets.layout(this.widgetMountTableEdit, 0, 1, 4, 0, 0, 0, 0, 110, -1);
        this.widgetMountTableEdit.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.mountListEdit();
            }
        });
        button = Widgets.newButton(composite, BARControl.tr("Clone", new Object[0]) + "\u2026", Settings.hasNormalRole());
        button.setToolTipText(BARControl.tr("Clone entry in mount list.", new Object[0]));
        Widgets.layout(button, 0, 2, 4, 0, 0, 0, 0, 110, -1);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.mountListClone();
            }
        });
        this.widgetMountTableRemove = Widgets.newButton(composite, BARControl.tr("Remove", new Object[0]) + "\u2026");
        this.widgetMountTableRemove.setToolTipText(BARControl.tr("Remove entry from mount list.", new Object[0]));
        Widgets.layout(this.widgetMountTableRemove, 0, 3, 4, 0, 0, 0, 0, 110, -1);
        this.widgetMountTableRemove.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.mountListRemove();
            }
        });
        composite = Widgets.newComposite(composite2);
        composite.setLayout(new TableLayout(1.0, new double[]{0.0, 1.0}));
        Widgets.layout(composite, 1, 0, 12);
        label = Widgets.newLabel(composite, BARControl.tr("Options", new Object[0]) + ":");
        Widgets.layout(label, 0, 0, 5);
        composite4 = Widgets.newComposite(composite);
        Widgets.layout(composite4, 0, 1, 12);
        button = Widgets.newCheckbox(composite4, BARControl.tr("skip unreadable entries", new Object[0]));
        button.setToolTipText(BARControl.tr("If enabled then skip not readable entries (write information to log file).\nIf disabled stop job with an error.", new Object[0]));
        Widgets.layout(button, 0, 0, 4);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                boolean bl = button.getSelection();
                try {
                    TabJobs.this.skipUnreadable.set(bl);
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.skipUnreadable);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener((Widget)button, this.skipUnreadable));
        button = Widgets.newCheckbox(composite4, BARControl.tr("no stop on owner error", new Object[0]));
        button.setToolTipText(BARControl.tr("If enabled then do not stop if the owner of an entry cannot be set.", new Object[0]));
        Widgets.layout(button, 1, 0, 4);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                boolean bl = button.getSelection();
                try {
                    TabJobs.this.noStopOnOwnerError.set(bl);
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.noStopOnOwnerError);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener((Widget)button, this.noStopOnOwnerError));
        button = Widgets.newCheckbox(composite4, BARControl.tr("no stop on attribute error", new Object[0]));
        button.setToolTipText(BARControl.tr("If enabled then do not stop if there is an attribute error when reading a file.", new Object[0]));
        Widgets.layout(button, 2, 0, 4);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                boolean bl = button.getSelection();
                try {
                    TabJobs.this.noStopOnAttributeError.set(bl);
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.noStopOnAttributeError);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener((Widget)button, this.noStopOnAttributeError));
        button = Widgets.newCheckbox(composite4, BARControl.tr("raw images", new Object[0]), Settings.hasExpertRole());
        button.setToolTipText(BARControl.tr("If enabled then store all data of a device into an image.\nIf disabled try to detect file system and only store used blocks to image.", new Object[0]));
        Widgets.layout(button, 3, 0, 4);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                boolean bl = button.getSelection();
                try {
                    TabJobs.this.rawImages.set(bl);
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.rawImages);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener((Widget)button, this.rawImages));
        composite2 = Widgets.addTab(this.widgetTabFolder, BARControl.tr("Compress && Crypt", new Object[0]));
        composite2.setLayout(new TableLayout(new double[]{0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, new double[]{0.0, 1.0}));
        Widgets.layout(composite2, 0, 0, 15);
        label = Widgets.newLabel(composite2, BARControl.tr("Part size", new Object[0]) + ":");
        Widgets.layout(label, 0, 0, 4);
        composite = Widgets.newComposite(composite2);
        Widgets.layout(composite, 0, 1, 12);
        button = Widgets.newRadio(composite, BARControl.tr("unlimited", new Object[0]));
        button.setToolTipText(BARControl.tr("Create storage files with an unlimited size. Do not split storage files.", new Object[0]));
        Widgets.layout(button, 0, 0, 4);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    boolean bl = TabJobs.this.archivePartSizeFlag.set(false);
                    TabJobs.this.archivePartSize.set(0L);
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.archivePartSize);
                    if (bl && (TabJobs.this.storageType.getEnum() == StorageTypes.CD || TabJobs.this.storageType.getEnum() == StorageTypes.DVD || TabJobs.this.storageType.getEnum() == StorageTypes.BD)) {
                        Dialogs.warning(TabJobs.this.shell, BARControl.tr("When writing to a CD/DVD/BD without splitting enabled\nthe resulting archive file may not fit on medium.", new Object[0]));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(button, new WidgetVariable[]{this.archivePartSizeFlag}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                ((Button)control).setSelection(!widgetVariable.getBoolean());
            }
        });
        this.widgetArchivePartSizeLimited = Widgets.newRadio(composite, BARControl.tr("limit to", new Object[0]));
        this.widgetArchivePartSizeLimited.setToolTipText(BARControl.tr("Limit size of storage files to specified value.", new Object[0]));
        Widgets.layout(this.widgetArchivePartSizeLimited, 0, 1, 4);
        this.widgetArchivePartSizeLimited.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.archivePartSizeFlag.set(true);
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(this.widgetArchivePartSizeLimited, new WidgetVariable[]{this.archivePartSizeFlag}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                ((Button)control).setSelection(widgetVariable.getBoolean());
            }
        });
        this.widgetArchivePartSize = Widgets.newCombo(composite);
        this.widgetArchivePartSize.setToolTipText(BARControl.tr("Size limit for one storage file part.", new Object[0]));
        this.widgetArchivePartSize.setItems(new String[]{"32M", "64M", "128M", "140M", "215M", "240M", "250M", "256M", "260M", "280M", "425M", "470M", "512M", "620M", "660M", "800M", "850M", "1G", "1800M", "2G", "4G", "5G", "6.4G", "8G", "10G", "20G"});
        this.widgetArchivePartSize.setData("showedErrorDialog", false);
        Widgets.layout(this.widgetArchivePartSize, 0, 2, 4, 0, 0, 0, 0, 100, -1);
        Widgets.addModifyListener(new WidgetModifyListener(this.widgetArchivePartSize, new WidgetVariable[]{this.archivePartSizeFlag}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                Widgets.setEnabled(control, widgetVariable.getBoolean());
            }
        });
        this.widgetArchivePartSize.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                Combo combo = (Combo)modifyEvent.widget;
                Color color = TabJobs.this.COLOR_MODIFIED;
                try {
                    long l = Units.parseByteSize(combo.getText());
                    if (TabJobs.this.archivePartSize.getLong() == l) {
                        color = null;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                combo.setBackground(color);
                combo.setData("showedErrorDialog", false);
            }
        });
        this.widgetArchivePartSize.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                Combo combo = (Combo)selectionEvent.widget;
                String string = combo.getText();
                try {
                    long l = Units.parseByteSize(string);
                    TabJobs.this.archivePartSize.set(l);
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.archivePartSize);
                    combo.setText(Units.formatSize(l));
                    combo.setBackground(null);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!((Boolean)combo.getData("showedErrorDialog")).booleanValue()) {
                        combo.setData("showedErrorDialog", true);
                        Dialogs.error(TabJobs.this.shell, BARControl.tr("''{0}'' is not a valid size!\n\nEnter a number in the format ''n'' or ''n.m''. Optional units are KB, MB, or GB.", string));
                        combo.forceFocus();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Combo combo = (Combo)selectionEvent.widget;
                String string = combo.getText();
                try {
                    long l = Units.parseByteSize(string);
                    TabJobs.this.archivePartSize.set(l);
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.archivePartSize);
                    combo.setText(Units.formatSize(l));
                    combo.setBackground(null);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!((Boolean)combo.getData("showedErrorDialog")).booleanValue()) {
                        combo.setData("showedErrorDialog", true);
                        Dialogs.error(TabJobs.this.shell, BARControl.tr("''{0}'' is not a valid size!\n\nEnter a number in the format ''n'' or ''n.m''. Optional units are KB, MB, or GB.", string));
                        combo.forceFocus();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.widgetArchivePartSize.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                Combo combo = (Combo)focusEvent.widget;
                combo.setData("showedErrorDialog", false);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Combo combo = (Combo)focusEvent.widget;
                String string = combo.getText();
                try {
                    long l = Units.parseByteSize(string);
                    TabJobs.this.archivePartSize.set(l);
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.archivePartSize);
                    combo.setText(Units.formatSize(l));
                    combo.setBackground(null);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!((Boolean)combo.getData("showedErrorDialog")).booleanValue()) {
                        combo.setData("showedErrorDialog", true);
                        Dialogs.error(TabJobs.this.shell, BARControl.tr("''{0}'' is not a valid size!\n\nEnter a number in the format ''n'' or ''n.m''. Optional units are KB, MB, or GB.", string));
                        combo.forceFocus();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(this.widgetArchivePartSize, new WidgetVariable[]{this.archivePartSize}){

            @Override
            public String getString(WidgetVariable widgetVariable) {
                return Units.formatSize(widgetVariable.getLong());
            }
        });
        label = Widgets.newLabel(composite, BARControl.tr("bytes", new Object[0]));
        Widgets.layout(label, 0, 3, 4);
        composite.addMouseListener(new MouseListener(){

            @Override
            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseDown(MouseEvent mouseEvent) {
                Rectangle rectangle = TabJobs.this.widgetArchivePartSize.getBounds();
                if (rectangle.contains(mouseEvent.x, mouseEvent.y)) {
                    TabJobs.this.archivePartSizeFlag.set(true);
                    TabJobs.this.widgetArchivePartSize.setListVisible(true);
                }
            }

            @Override
            public void mouseUp(MouseEvent mouseEvent) {
            }
        });
        label = Widgets.newLabel(composite2, BARControl.tr("Compress", new Object[0]) + ":");
        Widgets.layout(label, 1, 0, 4);
        composite = Widgets.newComposite(composite2);
        composite.setLayout(new TableLayout(0.0, 0.0));
        Widgets.layout(composite, 1, 1, 4);
        composite4 = Widgets.newComposite(composite, Settings.hasExpertRole());
        composite4.setLayout(new TableLayout(0.0, 0.0));
        Widgets.layout(composite4, 0, 0, 0);
        label = Widgets.newLabel(composite4, BARControl.tr("Delta", new Object[0]) + ":");
        Widgets.layout(label, 0, 0, 0);
        combo = Widgets.newOptionMenu(composite4);
        combo.setToolTipText(BARControl.tr("Delta compression method to use.", new Object[0]));
        Widgets.setComboItems(combo, new String[]{"", "none", "xdelta1", "xdelta1", "xdelta2", "xdelta2", "xdelta3", "xdelta3", "xdelta4", "xdelta4", "xdelta5", "xdelta5", "xdelta6", "xdelta6", "xdelta7", "xdelta7", "xdelta8", "xdelta8", "xdelta9", "xdelta9"});
        Widgets.layout(combo, 0, 1, 4);
        combo.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Combo combo = (Combo)selectionEvent.widget;
                String string = (String)Widgets.getSelectedComboItem(combo);
                try {
                    TabJobs.this.deltaCompressAlgorithm.set(string);
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "compress-algorithm", TabJobs.this.deltaCompressAlgorithm.getString() + "+" + TabJobs.this.byteCompressAlgorithm.getString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener((Widget)combo, this.deltaCompressAlgorithm));
        label = Widgets.newLabel(composite, BARControl.tr("Byte", new Object[0]) + ":");
        Widgets.layout(label, 0, 1, 0);
        Combo combo2 = Widgets.newOptionMenu(composite);
        combo2.setToolTipText(BARControl.tr("Byte compression method to use.", new Object[0]));
        Widgets.setComboItems(combo2, new String[]{" ", "none", "zip", "zip", "bzip", "bzip", "lzma", "lzma", "lzo", "lzo", "lz4", "lz4", "zstd", "zstd"});
        Widgets.layout(combo2, 0, 2, 4);
        combo2.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Combo combo = (Combo)selectionEvent.widget;
                String string = (String)Widgets.getSelectedComboItem(combo);
                try {
                    if (string.equals("none")) {
                        TabJobs.this.byteCompressAlgorithm.set("none");
                    } else if (string.equals("zip")) {
                        TabJobs.this.byteCompressAlgorithm.set("zip0");
                    } else if (string.equals("bzip")) {
                        TabJobs.this.byteCompressAlgorithm.set("bzip1");
                    } else if (string.equals("lzma")) {
                        TabJobs.this.byteCompressAlgorithm.set("lzma1");
                    } else if (string.equals("lzo")) {
                        TabJobs.this.byteCompressAlgorithm.set("lzo1");
                    } else if (string.equals("lz4")) {
                        TabJobs.this.byteCompressAlgorithm.set("lz4-0");
                    } else if (string.equals("zstd")) {
                        TabJobs.this.byteCompressAlgorithm.set("zstd0");
                    }
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "compress-algorithm", TabJobs.this.deltaCompressAlgorithm.getString() + "+" + TabJobs.this.byteCompressAlgorithm.getString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener((Widget)combo2, this.byteCompressAlgorithmType));
        final Combo combo3 = Widgets.newOptionMenu(composite);
        combo3.setEnabled(true);
        combo3.setToolTipText(BARControl.tr("Byte compression level to use.", new Object[0]));
        Widgets.setComboItems(combo3, new String[]{" ", "none"});
        Widgets.layout(combo3, 0, 3, 4);
        combo3.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Combo combo = (Combo)selectionEvent.widget;
                String string = (String)Widgets.getSelectedComboItem(combo);
                try {
                    TabJobs.this.byteCompressAlgorithm.set(string);
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "compress-algorithm", TabJobs.this.deltaCompressAlgorithm.getString() + "+" + TabJobs.this.byteCompressAlgorithm.getString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        combo2.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                boolean bl;
                String[] stringArray;
                Combo combo = (Combo)modifyEvent.widget;
                String string = (String)Widgets.getSelectedComboItem(combo);
                if (string.equals("none")) {
                    stringArray = new String[]{" ", "none"};
                    bl = false;
                } else if (string.startsWith("zip")) {
                    stringArray = new String[]{"0", "zip0", "1", "zip1", "2", "zip2", "3", "zip3", "4", "zip4", "5", "zip5", "6", "zip6", "7", "zip7", "8", "zip8", "9", "zip9"};
                    bl = true;
                } else if (string.startsWith("bzip")) {
                    stringArray = new String[]{"1", "bzip1", "2", "bzip2", "3", "bzip3", "4", "bzip4", "5", "bzip5", "6", "bzip6", "7", "bzip7", "8", "bzip8", "9", "bzip9"};
                    bl = true;
                } else if (string.startsWith("lzma")) {
                    stringArray = new String[]{"1", "lzma1", "2", "lzma2", "3", "lzma3", "4", "lzma4", "5", "lzma5", "6", "lzma6", "7", "lzma7", "8", "lzma8", "9", "lzma9"};
                    bl = true;
                } else if (string.startsWith("lzo")) {
                    stringArray = new String[]{"1", "lzo1", "2", "lzo2", "3", "lzo3", "4", "lzo4", "5", "lzo5"};
                    bl = true;
                } else if (string.startsWith("lz4")) {
                    stringArray = new String[]{"0", "lz4-0", "1", "lz4-1", "2", "lz4-2", "3", "lz4-3", "4", "lz4-4", "5", "lz4-5", "6", "lz4-6", "7", "lz4-7", "8", "lz4-8", "9", "lz4-9", "10", "lz4-10", "11", "lz4-11", "12", "lz4-12", "13", "lz4-13", "14", "lz4-14", "15", "lz4-15", "16", "lz4-16"};
                    bl = true;
                } else if (string.startsWith("zstd")) {
                    stringArray = new String[]{"0", "zstd0", "1", "zstd1", "2", "zstd2", "3", "zstd3", "4", "zstd4", "5", "zstd5", "6", "zstd6", "7", "zstd7", "8", "zstd8", "9", "zstd9", "10", "zstd10", "11", "zstd11", "12", "zstd12", "13", "zstd13", "14", "zstd14", "15", "zstd15", "16", "zstd16", "17", "zstd17", "18", "zstd18", "19", "zstd19"};
                    bl = true;
                } else {
                    stringArray = new String[]{" ", "none"};
                    bl = false;
                }
                combo3.setEnabled(bl);
                Widgets.setComboItems(combo3, stringArray);
                Widgets.setSelectedComboItem(combo3, 0);
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener((Widget)combo3, this.byteCompressAlgorithm));
        composite = Widgets.newComposite(composite2, Settings.hasExpertRole());
        composite.setLayout(new TableLayout(1.0, new double[]{0.0, 1.0, 0.0}));
        Widgets.layout(composite, 2, 1, 12);
        label = Widgets.newLabel(composite, BARControl.tr("Source", new Object[0]) + ":");
        Widgets.layout(label, 0, 0, 0);
        text = Widgets.newText(composite);
        Widgets.layout(text, 0, 1, 12);
        Widgets.addModifyListener(new WidgetModifyListener(text, new WidgetVariable[]{this.deltaCompressAlgorithm}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                Widgets.setEnabled(control, !TabJobs.this.deltaCompressAlgorithm.equals("none"));
            }
        });
        text.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                Text text = (Text)modifyEvent.widget;
                String string = text.getText();
                Color color = TabJobs.this.COLOR_MODIFIED;
                if (TabJobs.this.deltaSource.getString().equals(string)) {
                    color = null;
                }
                text.setBackground(color);
            }
        });
        text.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                Text text = (Text)selectionEvent.widget;
                String string = text.getText();
                TabJobs.this.deltaSource.set(string);
                TabJobs.this.sourceListRemoveAll();
                TabJobs.this.sourceListAdd(string);
                text.setBackground(null);
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
            }
        });
        text.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Text text = (Text)focusEvent.widget;
                String string = text.getText();
                TabJobs.this.deltaSource.set(string);
                TabJobs.this.sourceListRemoveAll();
                TabJobs.this.sourceListAdd(string);
                text.setBackground(null);
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener((Widget)text, this.deltaSource));
        button = Widgets.newButton(composite, this.IMAGE_DIRECTORY);
        button.setToolTipText(BARControl.tr("Select remote file. CTRL+click to select local file.", new Object[0]));
        Widgets.layout(button, 0, 2, 0);
        Widgets.addModifyListener(new WidgetModifyListener(button, new WidgetVariable[]{this.deltaCompressAlgorithm}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                Widgets.setEnabled(control, !TabJobs.this.deltaCompressAlgorithm.equals("none"));
            }
        });
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = Dialogs.file(TabJobs.this.shell, Dialogs.FileDialogTypes.SAVE, BARControl.tr("Select source file", new Object[0]), TabJobs.this.deltaSource.getString(), new String[]{BARControl.tr("BAR files", new Object[0]), "*.bar", BARControl.tr("All files", new Object[0]), BARControl.ALL_FILE_EXTENSION}, "*", 0, (selectionEvent.stateMask & 0x40000) == 0 ? BARServer.remoteListDirectory(((TabJobs)TabJobs.this).selectedJobData.uuid) : BARControl.listDirectory);
                if (string != null) {
                    TabJobs.this.deltaSource.set(string);
                    TabJobs.this.sourceListRemoveAll();
                    TabJobs.this.sourceListAdd(string);
                }
            }
        });
        label = Widgets.newLabel(composite2, BARControl.tr("Compress exclude", new Object[0]) + ":", Settings.hasNormalRole());
        Widgets.layout(label, 3, 0, 5);
        composite = Widgets.newComposite(composite2, Settings.hasNormalRole());
        composite.setLayout(new TableLayout(new double[]{1.0, 0.0}, 1.0));
        Widgets.layout(composite, 3, 1, 15);
        this.widgetCompressExcludeList = Widgets.newList(composite);
        this.widgetCompressExcludeList.setToolTipText(BARControl.tr("List of compress exclude patterns. Entries which match to one of these patterns will not be compressed.\nRight-click for context menu.", new Object[0]));
        Widgets.layout(this.widgetCompressExcludeList, 0, 0, 15);
        this.widgetCompressExcludeList.addMouseListener(new MouseListener(){

            @Override
            public void mouseDoubleClick(MouseEvent mouseEvent) {
                TabJobs.this.compressExcludeListEdit();
            }

            @Override
            public void mouseDown(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseUp(MouseEvent mouseEvent) {
            }
        });
        this.widgetCompressExcludeList.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (Widgets.isAccelerator(keyEvent, 0x1000009)) {
                    Widgets.invoke(TabJobs.this.widgetCompressExcludeListInsert);
                } else if (Widgets.isAccelerator(keyEvent, 127)) {
                    Widgets.invoke(TabJobs.this.widgetCompressExcludeListRemove);
                } else if (Widgets.isAccelerator(keyEvent, 13) || Widgets.isAccelerator(keyEvent, 0x1000050)) {
                    Widgets.invoke(TabJobs.this.widgetCompressExcludeListEdit);
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(this.widgetCompressExcludeList, new WidgetVariable[]{this.deltaCompressAlgorithm, this.byteCompressAlgorithm}){

            @Override
            public void modified(Control control, WidgetVariable[] widgetVariableArray) {
                Widgets.setEnabled(control, !TabJobs.this.deltaCompressAlgorithm.equals("none") || !TabJobs.this.byteCompressAlgorithm.equals("none"));
            }
        });
        menu = Widgets.newPopupMenu(this.shell);
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Add", new Object[0]) + "\u2026");
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.compressExcludeListAdd();
            }
        });
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Add most used compressed file suffixes", new Object[0]));
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                String[] stringArray = new String[]{"*.gz", "*.tgz", "*.bz", "*.bz2", "*.gzip", "*.lzma", "*.lzo", "*.zip", "*.rar", "*.7z"};
                TabJobs.this.compressExcludeListAdd(stringArray);
            }
        });
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Add most used multi-media file suffixes", new Object[0]));
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                String[] stringArray = new String[]{"*.jpg", "*.jpeg", "*.mkv", "*.mp3", "*.mp4", "*.mpg", "*.mpeg", "*.avi", "*.wma", "*.wmv", "*.flv", "*.3gp"};
                TabJobs.this.compressExcludeListAdd(stringArray);
            }
        });
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Add most used package file suffixes", new Object[0]));
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                String[] stringArray = new String[]{"*.rpm", "*.deb", "*.pkg"};
                TabJobs.this.compressExcludeListAdd(stringArray);
            }
        });
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Remove", new Object[0]) + "\u2026");
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.compressExcludeListRemove();
            }
        });
        this.widgetCompressExcludeList.setMenu(menu);
        composite4 = Widgets.newComposite(composite);
        Widgets.layout(composite4, 1, 0, 4);
        this.widgetCompressExcludeListInsert = Widgets.newButton(composite4, BARControl.tr("Add", new Object[0]) + "\u2026");
        this.widgetCompressExcludeListInsert.setToolTipText(BARControl.tr("Add entry to compress exclude list.", new Object[0]));
        Widgets.layout(this.widgetCompressExcludeListInsert, 0, 0, 0, 0, 0, 0, 0, 110, -1);
        Widgets.addModifyListener(new WidgetModifyListener(this.widgetCompressExcludeListInsert, new WidgetVariable[]{this.deltaCompressAlgorithm, this.byteCompressAlgorithm}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                Widgets.setEnabled(control, !TabJobs.this.deltaCompressAlgorithm.equals("none") || !widgetVariable.equals("none"));
            }
        });
        this.widgetCompressExcludeListInsert.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.compressExcludeListAdd();
            }
        });
        this.widgetCompressExcludeListEdit = Widgets.newButton(composite4, BARControl.tr("Edit", new Object[0]) + "\u2026");
        this.widgetCompressExcludeListEdit.setToolTipText(BARControl.tr("Edit entry in compress exclude list.", new Object[0]));
        Widgets.layout(this.widgetCompressExcludeListEdit, 0, 1, 0, 0, 0, 0, 0, 110, -1);
        Widgets.addModifyListener(new WidgetModifyListener(this.widgetCompressExcludeListEdit, new WidgetVariable[]{this.deltaCompressAlgorithm, this.byteCompressAlgorithm}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                Widgets.setEnabled(control, !TabJobs.this.deltaCompressAlgorithm.equals("none") || !widgetVariable.equals("none"));
            }
        });
        this.widgetCompressExcludeListEdit.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.compressExcludeListEdit();
            }
        });
        this.widgetCompressExcludeListRemove = Widgets.newButton(composite4, BARControl.tr("Remove", new Object[0]) + "\u2026");
        this.widgetCompressExcludeListRemove.setToolTipText(BARControl.tr("Remove entry from compress exclude list.", new Object[0]));
        Widgets.layout(this.widgetCompressExcludeListRemove, 0, 2, 0, 0, 0, 0, 0, 110, -1);
        Widgets.addModifyListener(new WidgetModifyListener(this.widgetCompressExcludeListRemove, new WidgetVariable[]{this.deltaCompressAlgorithm, this.byteCompressAlgorithm}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                Widgets.setEnabled(control, !TabJobs.this.deltaCompressAlgorithm.equals("none") || !widgetVariable.equals("none"));
            }
        });
        this.widgetCompressExcludeListRemove.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.compressExcludeListRemove();
            }
        });
        label = Widgets.newLabel(composite2, BARControl.tr("Crypt", new Object[0]) + ":");
        Widgets.layout(label, 4, 0, Settings.hasExpertRole() ? 5 : 4);
        composite = Widgets.newComposite(composite2);
        Widgets.layout(composite, 4, 1, 12);
        for (n2 = 0; n2 < 1; ++n2) {
            this.widgetCryptAlgorithms[n2] = Widgets.newOptionMenu(composite);
            this.widgetCryptAlgorithms[n2].setToolTipText(BARControl.tr("Encryption methods to use.", new Object[0]));
            Widgets.setComboItems(this.widgetCryptAlgorithms[n2], new String[]{"", "none", "3DES", "3DES", "CAST5", "CAST5", "BLOWFISH", "BLOWFISH", "AES128", "AES128", "AES192", "AES192", "AES256", "AES256", "TWOFISH128", "TWOFISH128", "TWOFISH256", "TWOFISH256", "SERPENT128", "SERPENT128", "SERPENT192", "SERPENT192", "SERPENT256", "SERPENT256", "CAMELLIA128", "CAMELLIA128", "CAMELLIA192", "CAMELLIA192", "CAMELLIA256", "CAMELLIA256"});
            Widgets.layout(this.widgetCryptAlgorithms[n2], 0, n2, 4);
            this.widgetCryptAlgorithms[n2].addSelectionListener(new SelectionListener(){

                @Override
                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    try {
                        StringBuilder stringBuilder = new StringBuilder();
                        for (int i = 0; i < 1; ++i) {
                            String string = (String)Widgets.getSelectedComboItem(TabJobs.this.widgetCryptAlgorithms[i]);
                            if (stringBuilder.length() > 0) {
                                stringBuilder.append('+');
                            }
                            stringBuilder.append(string);
                        }
                        TabJobs.this.cryptAlgorithm.set(stringBuilder.toString());
                        BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.cryptAlgorithm);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        for (n2 = 0; n2 < 1; ++n2) {
            Widgets.addModifyListener(new WidgetModifyListener(this.widgetCryptAlgorithms[n2], new WidgetVariable[]{this.cryptAlgorithm}){

                @Override
                public void modified(Control control, WidgetVariable widgetVariable) {
                    String[] stringArray = StringUtils.splitArray(TabJobs.this.cryptAlgorithm.getString(), "+");
                    for (int i = 0; i < 1; ++i) {
                        if (i < stringArray.length) {
                            Widgets.setSelectedComboItem(TabJobs.this.widgetCryptAlgorithms[i], stringArray[i]);
                            continue;
                        }
                        Widgets.setSelectedComboItem(TabJobs.this.widgetCryptAlgorithms[i], "none");
                    }
                }
            });
        }
        composite = Widgets.newComposite(composite2, Settings.hasExpertRole());
        composite.setLayout(new TableLayout(1.0, new double[]{0.0, 0.0, 0.0, 0.0, 1.0, 0.0}));
        Widgets.layout(composite, 5, 1, 12);
        button = Widgets.newRadio(composite, BARControl.tr("symmetric", new Object[0]));
        button.setToolTipText(BARControl.tr("Use symmetric encryption with pass-phrase.", new Object[0]));
        button.setSelection(true);
        Widgets.layout(button, 0, 0, 4);
        Widgets.addModifyListener(new WidgetModifyListener(button, new WidgetVariable[]{this.cryptAlgorithm}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                Widgets.setEnabled(control, !widgetVariable.equals("none"));
            }
        });
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    TabJobs.this.cryptType.set("symmetric");
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.cryptType);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(button, new WidgetVariable[]{this.cryptType}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                ((Button)control).setSelection(widgetVariable.equals("none") || widgetVariable.equals("symmetric"));
            }
        });
        button = Widgets.newRadio(composite, BARControl.tr("asymmetric", new Object[0]));
        button.setToolTipText(BARControl.tr("Use asymmetric hybrid-encryption with pass-phrase and public/private key.", new Object[0]));
        button.setSelection(false);
        Widgets.layout(button, 0, 1, 4);
        Widgets.addModifyListener(new WidgetModifyListener(button, new WidgetVariable[]{this.cryptAlgorithm}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                Widgets.setEnabled(control, !widgetVariable.equals("none"));
            }
        });
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    TabJobs.this.cryptType.set("asymmetric");
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.cryptType);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(button, new WidgetVariable[]{this.cryptType}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                ((Button)control).setSelection(widgetVariable.equals("asymmetric"));
            }
        });
        control = Widgets.newSpacer(composite);
        Widgets.layout(control, 0, 2, 0, 0, 0, 5, 0);
        label = Widgets.newLabel(composite, BARControl.tr("Public key", new Object[0]) + ":");
        Widgets.layout(label, 0, 3, 4);
        text = Widgets.newText(composite);
        text.setToolTipText(BARControl.tr("Public key file used for asymmetric encryption.", new Object[0]));
        Widgets.layout(text, 0, 4, 12);
        Widgets.addModifyListener(new WidgetModifyListener(text, new WidgetVariable[]{this.cryptAlgorithm, this.cryptType}){

            @Override
            public void modified(Text text, WidgetVariable widgetVariable) {
            }

            @Override
            public void modified(Text text, WidgetVariable[] widgetVariableArray) {
                Widgets.setEnabled(text, !widgetVariableArray[0].equals("none") && widgetVariableArray[1].equals("asymmetric"));
            }
        });
        text.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                Text text = (Text)modifyEvent.widget;
                String string = text.getText();
                Color color = TabJobs.this.COLOR_MODIFIED;
                if (TabJobs.this.cryptPublicKeyFileName.getString().equals(string)) {
                    color = null;
                }
                text.setBackground(color);
            }
        });
        text.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                Text text = (Text)selectionEvent.widget;
                String string = text.getText();
                try {
                    TabJobs.this.cryptPublicKeyFileName.set(string);
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.cryptPublicKeyFileName);
                    text.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
            }
        });
        text.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Text text = (Text)focusEvent.widget;
                String string = text.getText();
                try {
                    TabJobs.this.cryptPublicKeyFileName.set(string);
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.cryptPublicKeyFileName);
                    text.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener((Widget)text, this.cryptPublicKeyFileName));
        button = Widgets.newButton(composite, this.IMAGE_DIRECTORY);
        button.setToolTipText(BARControl.tr("Select remote file. CTRL+click to select local file.", new Object[0]));
        Widgets.layout(button, 0, 5, 0);
        Widgets.addModifyListener(new WidgetModifyListener(button, new WidgetVariable[]{this.cryptAlgorithm, this.cryptType}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
            }

            @Override
            public void modified(Control control, WidgetVariable[] widgetVariableArray) {
                Widgets.setEnabled(control, !widgetVariableArray[0].equals("none") && widgetVariableArray[1].equals("asymmetric"));
            }
        });
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = Dialogs.file(TabJobs.this.shell, Dialogs.FileDialogTypes.OPEN, BARControl.tr("Select public key file", new Object[0]), TabJobs.this.cryptPublicKeyFileName.getString(), new String[]{BARControl.tr("Public key", new Object[0]), "*.public", BARControl.tr("All files", new Object[0]), BARControl.ALL_FILE_EXTENSION}, "*", 0, (selectionEvent.stateMask & 0x40000) == 0 ? BARServer.remoteListDirectory(((TabJobs)TabJobs.this).selectedJobData.uuid) : BARControl.listDirectory);
                if (string != null) {
                    try {
                        TabJobs.this.cryptPublicKeyFileName.set(string);
                        BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.cryptPublicKeyFileName);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        label = Widgets.newLabel(composite2, BARControl.tr("Crypt password", new Object[0]) + ":");
        Widgets.layout(label, 6, 0, 4);
        composite = Widgets.newComposite(composite2);
        composite.setLayout(new TableLayout(1.0, new double[]{0.0, 0.0, 0.0, 1.0, 0.0, 1.0}));
        Widgets.layout(composite, 6, 1, 12);
        button = Widgets.newRadio(composite, BARControl.tr("default", new Object[0]));
        button.setToolTipText(BARControl.tr("Use default password from configuration file for encryption.", new Object[0]));
        Widgets.layout(button, 0, 0, 4);
        Widgets.addModifyListener(new WidgetModifyListener(button, new WidgetVariable[]{this.cryptAlgorithm, this.cryptType}){

            @Override
            public void modified(Control control, WidgetVariable[] widgetVariableArray) {
                Widgets.setEnabled(control, !widgetVariableArray[0].equals("none") && (widgetVariableArray[1].equals("none") || widgetVariableArray[1].equals("symmetric")));
            }
        });
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    TabJobs.this.cryptPasswordMode.set("default");
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.cryptPasswordMode);
                    TabJobs.this.cryptPassword.set("");
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.cryptPassword);
                    TabJobs.this.widgetCryptPassword1.setBackground(null);
                    TabJobs.this.widgetCryptPassword2.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(button, new WidgetVariable[]{this.cryptPasswordMode}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                ((Button)control).setSelection(widgetVariable.equals("default"));
            }
        });
        button = Widgets.newRadio(composite, BARControl.tr("ask", new Object[0]));
        button.setToolTipText(BARControl.tr("Input password for encryption.", new Object[0]));
        Widgets.layout(button, 0, 1, 4);
        Widgets.addModifyListener(new WidgetModifyListener(button, new WidgetVariable[]{this.cryptAlgorithm, this.cryptType}){

            @Override
            public void modified(Control control, WidgetVariable[] widgetVariableArray) {
                Widgets.setEnabled(control, !widgetVariableArray[0].equals("none") && (widgetVariableArray[1].equals("none") || widgetVariableArray[1].equals("symmetric")));
            }
        });
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    TabJobs.this.cryptPasswordMode.set("ask");
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.cryptPasswordMode);
                    TabJobs.this.cryptPassword.set("");
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.cryptPassword);
                    TabJobs.this.widgetCryptPassword1.setBackground(null);
                    TabJobs.this.widgetCryptPassword2.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(button, new WidgetVariable[]{this.cryptPasswordMode}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                ((Button)control).setSelection(widgetVariable.equals("ask"));
            }
        });
        button = Widgets.newRadio(composite, BARControl.tr("this", new Object[0]));
        button.setToolTipText(BARControl.tr("Use specified password for encryption.", new Object[0]));
        Widgets.layout(button, 0, 2, 4);
        Widgets.addModifyListener(new WidgetModifyListener(button, new WidgetVariable[]{this.cryptAlgorithm, this.cryptType}){

            @Override
            public void modified(Control control, WidgetVariable[] widgetVariableArray) {
                Widgets.setEnabled(control, !widgetVariableArray[0].equals("none") && (widgetVariableArray[1].equals("none") || widgetVariableArray[1].equals("symmetric")));
            }
        });
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    TabJobs.this.cryptPasswordMode.set("config");
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.cryptPasswordMode);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(button, new WidgetVariable[]{this.cryptPasswordMode}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                ((Button)control).setSelection(widgetVariable.equals("config"));
            }
        });
        this.widgetCryptPassword1 = Widgets.newPassword(composite);
        this.widgetCryptPassword1.setToolTipText(BARControl.tr("Password used for encryption.", new Object[0]));
        Widgets.layout(this.widgetCryptPassword1, 0, 3, 12);
        Widgets.addModifyListener(new WidgetModifyListener(this.widgetCryptPassword1, new WidgetVariable[]{this.cryptAlgorithm, this.cryptType, this.cryptPasswordMode}){

            @Override
            public void modified(Text text, WidgetVariable[] widgetVariableArray) {
                boolean bl;
                boolean bl2 = bl = !widgetVariableArray[0].equals("none") && (widgetVariableArray[1].equals("none") || widgetVariableArray[1].equals("symmetric")) && widgetVariableArray[2].equals("config");
                if (!bl) {
                    text.setText("");
                }
                Widgets.setEnabled(text, bl);
            }
        });
        this.widgetCryptPassword1.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                Text text = (Text)modifyEvent.widget;
                String string = text.getText();
                Color color = TabJobs.this.COLOR_MODIFIED;
                if (TabJobs.this.cryptPassword.getString().equals(string)) {
                    color = null;
                }
                text.setBackground(color);
            }
        });
        this.widgetCryptPassword1.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                String string;
                String string2 = TabJobs.this.widgetCryptPassword1.getText();
                if (string2.equals(string = TabJobs.this.widgetCryptPassword2.getText())) {
                    try {
                        TabJobs.this.cryptPassword.set(string2);
                        BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.cryptPassword);
                        TabJobs.this.widgetCryptPassword1.setBackground(null);
                        TabJobs.this.widgetCryptPassword2.setBackground(null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
            }
        });
        this.widgetCryptPassword1.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                String string;
                String string2 = TabJobs.this.widgetCryptPassword1.getText();
                if (string2.equals(string = TabJobs.this.widgetCryptPassword2.getText())) {
                    try {
                        TabJobs.this.cryptPassword.set(string2);
                        BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.cryptPassword);
                        TabJobs.this.widgetCryptPassword1.setBackground(null);
                        TabJobs.this.widgetCryptPassword2.setBackground(null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(this.widgetCryptPassword1, new WidgetVariable[]{this.cryptPassword}){

            @Override
            public void modified(Text text, WidgetVariable[] widgetVariableArray) {
                boolean bl;
                super.modified(text, widgetVariableArray);
                boolean bl2 = bl = !TabJobs.this.cryptAlgorithm.getString().equals("none") && (TabJobs.this.cryptType.getString().equals("none") || TabJobs.this.cryptType.getString().equals("symmetric")) && TabJobs.this.cryptPasswordMode.getString().equals("config");
                if (!bl) {
                    text.setText("");
                }
            }
        });
        label = Widgets.newLabel(composite, BARControl.tr("Repeat", new Object[0]) + ":");
        Widgets.layout(label, 0, 4, 4);
        this.widgetCryptPassword2 = Widgets.newPassword(composite);
        this.widgetCryptPassword1.setToolTipText(BARControl.tr("Password used for encryption.", new Object[0]));
        Widgets.layout(this.widgetCryptPassword2, 0, 5, 12);
        Widgets.addModifyListener(new WidgetModifyListener(this.widgetCryptPassword2, new WidgetVariable[]{this.cryptAlgorithm, this.cryptType, this.cryptPasswordMode}){

            @Override
            public void modified(Text text, WidgetVariable[] widgetVariableArray) {
                boolean bl;
                boolean bl2 = bl = !widgetVariableArray[0].equals("none") && (widgetVariableArray[1].equals("none") || widgetVariableArray[1].equals("symmetric")) && widgetVariableArray[2].equals("config");
                if (!bl) {
                    text.setText("");
                }
                Widgets.setEnabled(text, bl);
            }
        });
        this.widgetCryptPassword2.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                Text text = (Text)modifyEvent.widget;
                String string = text.getText();
                Color color = TabJobs.this.COLOR_MODIFIED;
                if (TabJobs.this.cryptPassword.getString().equals(string)) {
                    color = null;
                }
                text.setBackground(color);
            }
        });
        this.widgetCryptPassword2.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                String string;
                String string2 = TabJobs.this.widgetCryptPassword1.getText();
                if (string2.equals(string = TabJobs.this.widgetCryptPassword2.getText())) {
                    try {
                        TabJobs.this.cryptPassword.set(string2);
                        BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.cryptPassword);
                        TabJobs.this.widgetCryptPassword1.setBackground(null);
                        TabJobs.this.widgetCryptPassword2.setBackground(null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
            }
        });
        this.widgetCryptPassword2.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                String string;
                String string2 = TabJobs.this.widgetCryptPassword1.getText();
                if (string2.equals(string = TabJobs.this.widgetCryptPassword2.getText())) {
                    try {
                        TabJobs.this.cryptPassword.set(string2);
                        BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.cryptPassword);
                        TabJobs.this.widgetCryptPassword1.setBackground(null);
                        TabJobs.this.widgetCryptPassword2.setBackground(null);
                    }
                    catch (Exception exception) {}
                } else {
                    Dialogs.error(TabJobs.this.shell, BARControl.tr("Crypt passwords are not equal!", new Object[0]));
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(this.widgetCryptPassword2, new WidgetVariable[]{this.cryptPassword}){

            @Override
            public void modified(Text text, WidgetVariable[] widgetVariableArray) {
                boolean bl;
                super.modified(text, widgetVariableArray);
                boolean bl2 = bl = !TabJobs.this.cryptAlgorithm.getString().equals("none") && (TabJobs.this.cryptType.getString().equals("none") || TabJobs.this.cryptType.getString().equals("symmetric")) && TabJobs.this.cryptPasswordMode.getString().equals("config");
                if (!bl) {
                    text.setText("");
                }
            }
        });
        composite2 = Widgets.addTab(this.widgetTabFolder, BARControl.tr("Storage", new Object[0]));
        composite2.setLayout(new TableLayout(new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, new double[]{0.0, 1.0}));
        Widgets.layout(composite2, 0, 0, 15);
        label = Widgets.newLabel(composite2, BARControl.tr("Mode", new Object[0]) + ":", Settings.hasNormalRole());
        Widgets.layout(label, 1, 0, 4);
        composite = Widgets.newComposite(composite2, Settings.hasNormalRole());
        composite.setLayout(new TableLayout(1.0, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0}));
        Widgets.layout(composite, 1, 1, 12);
        button = Widgets.newRadio(composite, BARControl.tr("normal", new Object[0]));
        button.setToolTipText(BARControl.tr("Normal mode: do not create incremental data files.", new Object[0]));
        Widgets.layout(button, 0, 0, 4);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    TabJobs.this.archiveType.set("normal");
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.archiveType);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(button, new WidgetVariable[]{this.archiveType}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                ((Button)control).setSelection(widgetVariable.equals("normal"));
            }
        });
        button = Widgets.newRadio(composite, BARControl.tr("full", new Object[0]));
        button.setToolTipText(BARControl.tr("Full mode: store all entries and create incremental data files.", new Object[0]));
        Widgets.layout(button, 0, 1, 4);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    TabJobs.this.archiveType.set("full");
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.archiveType);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(button, new WidgetVariable[]{this.archiveType}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                ((Button)control).setSelection(widgetVariable.equals("full"));
            }
        });
        button = Widgets.newRadio(composite, BARControl.tr("incremental", new Object[0]));
        button.setToolTipText(BARControl.tr("Incremental mode: store only modified entries since last full or incremental storage.", new Object[0]));
        Widgets.layout(button, 0, 2, 4);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    TabJobs.this.archiveType.set("incremental");
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.archiveType);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(button, new WidgetVariable[]{this.archiveType}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                ((Button)control).setSelection(widgetVariable.equals("incremental"));
            }
        });
        button = Widgets.newRadio(composite, BARControl.tr("differential", new Object[0]));
        button.setToolTipText(BARControl.tr("Differential mode: store only modified entries since last full storage.", new Object[0]));
        Widgets.layout(button, 0, 3, 4);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    TabJobs.this.archiveType.set("differential");
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.archiveType);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(button, new WidgetVariable[]{this.archiveType}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                ((Button)control).setSelection(widgetVariable.equals("differential"));
            }
        });
        label = Widgets.newLabel(composite2, BARControl.tr("File name", new Object[0]) + ":");
        Widgets.layout(label, 2, 0, 4);
        composite = Widgets.newComposite(composite2);
        composite.setLayout(new TableLayout(1.0, new double[]{1.0, 0.0}));
        Widgets.layout(composite, 2, 1, 12);
        text = Widgets.newText(composite);
        text.setToolTipText(BARControl.tr("Name of storage files to create. Several macros are supported. Click on button to the right to open storage file name editor.", new Object[0]));
        Widgets.layout(text, 0, 0, 12);
        text.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                Text text = (Text)modifyEvent.widget;
                String string = text.getText();
                Color color = TabJobs.this.COLOR_MODIFIED;
                if (TabJobs.this.storageFileName.getString().equals(string)) {
                    color = null;
                }
                text.setBackground(color);
            }
        });
        text.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                Text text = (Text)selectionEvent.widget;
                try {
                    TabJobs.this.storageFileName.set(text.getText());
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "archive-name", TabJobs.this.getArchiveName());
                    text.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
            }
        });
        text.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Text text = (Text)focusEvent.widget;
                try {
                    TabJobs.this.storageFileName.set(text.getText());
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "archive-name", TabJobs.this.getArchiveName());
                    text.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener((Widget)text, this.storageFileName));
        Widgets.addModifyListener(new WidgetModifyListener(text, new WidgetVariable[]{this.storageFileName}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                try {
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "archive-name", TabJobs.this.getArchiveName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        button = Widgets.newButton(composite, this.IMAGE_EDIT);
        Widgets.layout(button, 0, 1, 0);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (TabJobs.this.selectedJobData != null) {
                    try {
                        String string = TabJobs.this.fileNameEdit(TabJobs.this.storageFileName.getString());
                        if (string != null) {
                            TabJobs.this.storageFileName.set(string);
                            BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "archive-name", TabJobs.this.getArchiveName());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        button = Widgets.newButton(composite, this.IMAGE_DIRECTORY);
        button.setToolTipText(BARControl.tr("Select remote file. CTRL+click to select local file.", new Object[0]));
        Widgets.layout(button, 0, 2, 0);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                String string;
                if (TabJobs.this.selectedJobData != null && (string = Dialogs.file(TabJobs.this.shell, Dialogs.FileDialogTypes.SAVE, BARControl.tr("Select storage file name", new Object[0]), TabJobs.this.storageFileName.getString(), new String[]{BARControl.tr("BAR files", new Object[0]), "*.bar", BARControl.tr("All files", new Object[0]), BARControl.ALL_FILE_EXTENSION}, "*", 0, (selectionEvent.stateMask & 0x40000) == 0 ? BARServer.remoteListDirectory(((TabJobs)TabJobs.this).selectedJobData.uuid) : BARControl.listDirectory)) != null) {
                    try {
                        TabJobs.this.storageFileName.set(string);
                        BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "archive-name", TabJobs.this.getArchiveName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        label = Widgets.newLabel(composite2, BARControl.tr("Incremental file name", new Object[0]) + ":", Settings.hasExpertRole());
        Widgets.layout(label, 3, 0, 4);
        composite = Widgets.newComposite(composite2, Settings.hasExpertRole());
        composite.setLayout(new TableLayout(1.0, new double[]{1.0, 0.0}));
        Widgets.layout(composite, 3, 1, 12);
        text = Widgets.newText(composite);
        text.setToolTipText(BARControl.tr("Name of incremental data file. If no file name is given a name is derived automatically from the storage file name.", new Object[0]));
        Widgets.layout(text, 0, 0, 12);
        text.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                Text text = (Text)modifyEvent.widget;
                String string = text.getText();
                Color color = TabJobs.this.COLOR_MODIFIED;
                if (TabJobs.this.incrementalListFileName.getString().equals(string)) {
                    color = null;
                }
                text.setBackground(color);
            }
        });
        text.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                Text text = (Text)selectionEvent.widget;
                String string = text.getText();
                try {
                    TabJobs.this.incrementalListFileName.set(string);
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.incrementalListFileName);
                    text.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
            }
        });
        text.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Text text = (Text)focusEvent.widget;
                String string = text.getText();
                try {
                    TabJobs.this.incrementalListFileName.set(string);
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.incrementalListFileName);
                    text.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener((Widget)text, this.incrementalListFileName));
        button = Widgets.newButton(composite, this.IMAGE_DIRECTORY);
        button.setToolTipText(BARControl.tr("Select remote file. CTRL+click to select local file.", new Object[0]));
        Widgets.layout(button, 0, 1, 0);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = Dialogs.file(TabJobs.this.shell, Dialogs.FileDialogTypes.SAVE, BARControl.tr("Select incremental file", new Object[0]), TabJobs.this.incrementalListFileName.getString(), new String[]{BARControl.tr("BAR incremental data", new Object[0]), "*.bid", BARControl.tr("All files", new Object[0]), BARControl.ALL_FILE_EXTENSION}, "*", 0, (selectionEvent.stateMask & 0x40000) == 0 ? BARServer.remoteListDirectory(((TabJobs)TabJobs.this).selectedJobData.uuid) : BARControl.listDirectory);
                if (string != null) {
                    try {
                        TabJobs.this.incrementalListFileName.set(string);
                        BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.incrementalListFileName);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        label = Widgets.newLabel(composite2, BARControl.tr("PAR2", new Object[0]) + ":", Settings.hasExpertRole());
        Widgets.layout(label, 4, 0, 5);
        composite = Widgets.newComposite(composite2, Settings.hasExpertRole());
        composite.setLayout(new TableLayout(1.0, new double[]{0.0, 1.0}));
        Widgets.layout(composite, 4, 1, 12);
        label = Widgets.newLabel(composite, BARControl.tr("Directory", new Object[0]) + ":", Settings.hasExpertRole());
        Widgets.layout(label, 0, 0, 4);
        composite4 = Widgets.newComposite(composite, Settings.hasExpertRole());
        composite4.setLayout(new TableLayout(1.0, new double[]{0.0, 1.0, 0.0, 0.0}));
        Widgets.layout(composite4, 0, 1, 12);
        text = Widgets.newText(composite4);
        text.setToolTipText(BARControl.tr("Name of the directory to store PAR2 checksum files. If no directory is given no PAR2 checksum files are created.", new Object[0]));
        Widgets.layout(text, 0, 1, 12);
        text.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                Text text = (Text)modifyEvent.widget;
                String string = text.getText();
                Color color = TabJobs.this.COLOR_MODIFIED;
                if (TabJobs.this.incrementalListFileName.getString().equals(string)) {
                    color = null;
                }
                text.setBackground(color);
            }
        });
        text.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                Text text = (Text)selectionEvent.widget;
                String string = text.getText();
                try {
                    TabJobs.this.par2Directory.set(string);
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.par2Directory);
                    text.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
            }
        });
        text.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Text text = (Text)focusEvent.widget;
                String string = text.getText();
                try {
                    TabJobs.this.par2Directory.set(string);
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.par2Directory);
                    text.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener((Widget)text, this.par2Directory));
        button = Widgets.newButton(composite4, this.IMAGE_EDIT);
        Widgets.layout(button, 0, 2, 0);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (TabJobs.this.selectedJobData != null) {
                    try {
                        String string = TabJobs.this.fileNameEdit(TabJobs.this.par2Directory.getString());
                        if (string != null) {
                            TabJobs.this.par2Directory.set(string);
                            BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.par2Directory);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        button = Widgets.newButton(composite4, this.IMAGE_DIRECTORY);
        button.setToolTipText(BARControl.tr("Select PAR2 directory. CTRL+click to select local file.", new Object[0]));
        Widgets.layout(button, 0, 3, 0);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                String string;
                if (TabJobs.this.selectedJobData != null && (string = Dialogs.file(TabJobs.this.shell, Dialogs.FileDialogTypes.DIRECTORY, BARControl.tr("Select PAR2 checksums directory", new Object[0]), TabJobs.this.storageFileName.getString(), new String[]{BARControl.tr("All files", new Object[0]), BARControl.ALL_FILE_EXTENSION}, "*", 0, (selectionEvent.stateMask & 0x40000) == 0 ? BARServer.remoteListDirectory(((TabJobs)TabJobs.this).selectedJobData.uuid) : BARControl.listDirectory)) != null) {
                    try {
                        TabJobs.this.par2Directory.set(string);
                        BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.par2Directory);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        label = Widgets.newLabel(composite, BARControl.tr("Block size", new Object[0]) + ":", Settings.hasExpertRole());
        Widgets.layout(label, 1, 0, 4);
        spinner = Widgets.newSpinner(composite);
        spinner.setToolTipText(BARControl.tr("PAR2 block size.", new Object[0]));
        spinner.setMinimum(512);
        spinner.setMaximum(65535);
        spinner.setEnabled(false);
        Widgets.layout(spinner, 1, 1, 4, 0, 0, 0, 0, 80, -1);
        Widgets.addEventListener(new WidgetEventListener(spinner, this.selectJobEvent){

            @Override
            public void trigger(Control control) {
                Widgets.setEnabled(control, TabJobs.this.selectedJobData != null && !TabJobs.this.par2Directory.getString().isEmpty());
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(spinner, new WidgetVariable[]{this.par2Directory}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                Widgets.setEnabled(control, !widgetVariable.getString().isEmpty());
            }
        });
        spinner.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                Spinner spinner = (Spinner)modifyEvent.widget;
                int n = spinner.getSelection();
                Color color = TabJobs.this.COLOR_MODIFIED;
                if (TabJobs.this.par2BlockSize.getInteger() == n) {
                    color = null;
                }
                spinner.setBackground(color);
                spinner.setData("showedErrorDialog", false);
            }
        });
        spinner.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                Spinner spinner = (Spinner)selectionEvent.widget;
                int n = spinner.getSelection();
                try {
                    TabJobs.this.par2BlockSize.set(n);
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.slaveHostPort);
                    spinner.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Spinner spinner = (Spinner)selectionEvent.widget;
                int n = spinner.getSelection();
                try {
                    TabJobs.this.par2BlockSize.set(n);
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.par2BlockSize);
                    spinner.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        spinner.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                Spinner spinner = (Spinner)focusEvent.widget;
                spinner.setData("showedErrorDialog", false);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Spinner spinner = (Spinner)focusEvent.widget;
                int n = spinner.getSelection();
                try {
                    TabJobs.this.par2BlockSize.set(n);
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.par2BlockSize);
                    spinner.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener((Widget)spinner, this.par2BlockSize));
        label = Widgets.newLabel(composite, BARControl.tr("File count", new Object[0]) + ":", Settings.hasExpertRole());
        Widgets.layout(label, 2, 0, 4);
        spinner = Widgets.newSpinner(composite);
        spinner.setToolTipText(BARControl.tr("PAR2 file count.", new Object[0]));
        spinner.setMinimum(1);
        spinner.setMaximum(65535);
        spinner.setEnabled(false);
        Widgets.layout(spinner, 2, 1, 4, 0, 0, 0, 0, 80, -1);
        Widgets.addEventListener(new WidgetEventListener(spinner, this.selectJobEvent){

            @Override
            public void trigger(Control control) {
                Widgets.setEnabled(control, TabJobs.this.selectedJobData != null && !TabJobs.this.par2Directory.getString().isEmpty());
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(spinner, new WidgetVariable[]{this.par2Directory}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                Widgets.setEnabled(control, !widgetVariable.getString().isEmpty());
            }
        });
        spinner.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                Spinner spinner = (Spinner)modifyEvent.widget;
                int n = spinner.getSelection();
                Color color = TabJobs.this.COLOR_MODIFIED;
                if (TabJobs.this.par2FileCount.getInteger() == n) {
                    color = null;
                }
                spinner.setBackground(color);
                spinner.setData("showedErrorDialog", false);
            }
        });
        spinner.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                Spinner spinner = (Spinner)selectionEvent.widget;
                int n = spinner.getSelection();
                try {
                    TabJobs.this.par2FileCount.set(n);
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.par2FileCount);
                    spinner.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Spinner spinner = (Spinner)selectionEvent.widget;
                int n = spinner.getSelection();
                try {
                    TabJobs.this.par2FileCount.set(n);
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.par2FileCount);
                    spinner.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        spinner.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                Spinner spinner = (Spinner)focusEvent.widget;
                spinner.setData("showedErrorDialog", false);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Spinner spinner = (Spinner)focusEvent.widget;
                int n = spinner.getSelection();
                try {
                    TabJobs.this.slaveHostPort.set(n);
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.slaveHostPort);
                    spinner.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener((Widget)spinner, this.par2FileCount));
        label = Widgets.newLabel(composite, BARControl.tr("Block count", new Object[0]) + ":", Settings.hasExpertRole());
        Widgets.layout(label, 3, 0, 4);
        spinner = Widgets.newSpinner(composite);
        spinner.setToolTipText(BARControl.tr("PAR2 block count.", new Object[0]));
        spinner.setMinimum(1);
        spinner.setMaximum(65535);
        spinner.setEnabled(false);
        Widgets.layout(spinner, 3, 1, 4, 0, 0, 0, 0, 80, -1);
        Widgets.addEventListener(new WidgetEventListener(spinner, this.selectJobEvent){

            @Override
            public void trigger(Control control) {
                Widgets.setEnabled(control, TabJobs.this.selectedJobData != null && !TabJobs.this.par2Directory.getString().isEmpty());
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(spinner, new WidgetVariable[]{this.par2Directory}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                Widgets.setEnabled(control, !widgetVariable.getString().isEmpty());
            }
        });
        spinner.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                Spinner spinner = (Spinner)modifyEvent.widget;
                int n = spinner.getSelection();
                Color color = TabJobs.this.COLOR_MODIFIED;
                if (TabJobs.this.par2BlockCount.getInteger() == n) {
                    color = null;
                }
                spinner.setBackground(color);
                spinner.setData("showedErrorDialog", false);
            }
        });
        spinner.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                Spinner spinner = (Spinner)selectionEvent.widget;
                int n = spinner.getSelection();
                try {
                    TabJobs.this.par2BlockCount.set(n);
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.par2BlockCount);
                    spinner.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Spinner spinner = (Spinner)selectionEvent.widget;
                int n = spinner.getSelection();
                try {
                    TabJobs.this.par2BlockCount.set(n);
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.par2BlockCount);
                    spinner.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        spinner.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                Spinner spinner = (Spinner)focusEvent.widget;
                spinner.setData("showedErrorDialog", false);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Spinner spinner = (Spinner)focusEvent.widget;
                int n = spinner.getSelection();
                try {
                    TabJobs.this.par2BlockCount.set(n);
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.par2BlockCount);
                    spinner.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener((Widget)spinner, this.par2BlockCount));
        label = Widgets.newLabel(composite2, BARControl.tr("Destination", new Object[0]) + ":");
        Widgets.layout(label, 5, 0, 4);
        composite = Widgets.newComposite(composite2);
        composite.setLayout(new TableLayout(1.0, new double[]{0.0, 1.0}));
        Widgets.layout(composite, 5, 1, 4);
        combo = Widgets.newOptionMenu(composite);
        combo.setToolTipText(BARControl.tr("Storage destination type:\n  into file system\n  on FTP server\n  on SSH server with sftp (secure FTP)\n  on WebDAV server\n  on WebDAV secure server\n  on SMB/CIFS server\n  on CD\n  on DVD\n  on BD\n  on generic device\n", new Object[0]));
        Widgets.setComboItems(combo, new Object[]{BARControl.tr("file system", new Object[0]), StorageTypes.FILESYSTEM, "ftp", StorageTypes.FTP, "sftp", StorageTypes.SFTP, "webdav", StorageTypes.WEBDAV, "webdavs", StorageTypes.WEBDAVS, "smb", StorageTypes.SMB, "CD", StorageTypes.CD, "DVD", StorageTypes.DVD, "BD", StorageTypes.BD, BARControl.tr("device", new Object[0]), StorageTypes.DEVICE});
        Widgets.layout(combo, 0, 0, 4);
        combo.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Combo combo = (Combo)selectionEvent.widget;
                StorageTypes storageTypes = (StorageTypes)((Object)Widgets.getSelectedComboItem(combo));
                try {
                    switch (storageTypes) {
                        case CD: {
                            if (TabJobs.this.archivePartSizeFlag.getBoolean() && Units.parseByteSize(TabJobs.this.volumeSize.getString()) <= 0L) {
                                Dialogs.warning(TabJobs.this.shell, BARControl.tr("When writing to a CD without setting medium size\nthe resulting archive file may not fit on medium.", new Object[0]));
                            }
                            long l = (long)((double)Units.parseByteSize(TabJobs.this.volumeSize.getString()) * 0.8);
                            if (TabJobs.this.ecc.getBoolean() && TabJobs.this.archivePartSizeFlag.getBoolean() && TabJobs.this.archivePartSize.getLong() > 0L && l % TabJobs.this.archivePartSize.getLong() > 0L && (double)(l % TabJobs.this.archivePartSize.getLong()) < (double)TabJobs.this.archivePartSize.getLong() * 0.5) {
                                Dialogs.warning(TabJobs.this.shell, BARControl.tr("When writing to a CD with error-correction codes enabled\nsome free space should be available on medium for error-correction codes (~20%).\n\nGood settings may be:\n- part size 215M, size 430M, medium 540\n- part size 260M, size 520M, medium 650\n- part size 280M, size 560M, medium 700\n- part size 250M, size 650M, medium 800\n- part size 240M, size 720M, medium 900\n", new Object[0]));
                            }
                        }
                        case DVD: {
                            if (TabJobs.this.archivePartSizeFlag.getBoolean() && Units.parseByteSize(TabJobs.this.volumeSize.getString()) <= 0L) {
                                Dialogs.warning(TabJobs.this.shell, BARControl.tr("When writing to a DVD without setting medium size\nthe resulting archive file may not fit on medium.", new Object[0]));
                            }
                            long l = (long)((double)Units.parseByteSize(TabJobs.this.volumeSize.getString()) * 0.8);
                            if (TabJobs.this.ecc.getBoolean() && TabJobs.this.archivePartSizeFlag.getBoolean() && TabJobs.this.archivePartSize.getLong() > 0L && l % TabJobs.this.archivePartSize.getLong() > 0L && (double)(l % TabJobs.this.archivePartSize.getLong()) < (double)TabJobs.this.archivePartSize.getLong() * 0.5) {
                                Dialogs.warning(TabJobs.this.shell, BARControl.tr("When writing to a DVD with error-correction codes enabled\nsome free space should be available on medium for error-correction codes (~20%).\n\nGood settings may be:\n- part size 470M, size 3.7G,\tmedium 4.7G\n- part size 425M, size 6.8G,\tmedium 8.5G\n- part size 470M, size 7.52G,\tmedium 9.4G\n- part size 660M, size 10.56G,\tmedium 13.2G\n- part size 850M, size 13.6G,\tmedium 17G", new Object[0]));
                            }
                        }
                        case BD: {
                            if (TabJobs.this.archivePartSizeFlag.getBoolean() && Units.parseByteSize(TabJobs.this.volumeSize.getString()) <= 0L) {
                                Dialogs.warning(TabJobs.this.shell, BARControl.tr("When writing to a BD without setting medium size\nthe resulting archive file may not fit on medium.", new Object[0]));
                            }
                            long l = (long)((double)Units.parseByteSize(TabJobs.this.volumeSize.getString()) * 0.8);
                            if (!TabJobs.this.ecc.getBoolean() || !TabJobs.this.archivePartSizeFlag.getBoolean() || TabJobs.this.archivePartSize.getLong() <= 0L || l % TabJobs.this.archivePartSize.getLong() <= 0L || !((double)(l % TabJobs.this.archivePartSize.getLong()) < (double)TabJobs.this.archivePartSize.getLong() * 0.5)) break;
                            Dialogs.warning(TabJobs.this.shell, BARControl.tr("When writing to a BD with error-correction codes enabled\nsome free space should be available on medium for error-correction codes (~20%).\n\nGood settings may be:\n- part size 1G,\t\tsize 20G,\t\tmedium 25G\n- part size 2G,\t\tsize 40G,\t\tmedium 50G\n- part size 5G,\t\tsize 80G,\t\tmedium 100G\n- part size 6.4G,\tsize 102.4G,\tmedium 128G\n", new Object[0]));
                        }
                    }
                    TabJobs.this.storageType.set(storageTypes);
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "archive-name", TabJobs.this.getArchiveName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener((Widget)combo, this.storageType));
        button = Widgets.newCheckbox(composite, BARControl.tr("on master", new Object[0]));
        button.setToolTipText(BARControl.tr("Enable for storage through master.", new Object[0]));
        button.setEnabled(false);
        Widgets.layout(button, 0, 10, 0);
        Widgets.addEventListener(new WidgetEventListener(button, this.selectJobEvent){

            @Override
            public void trigger(Control control) {
                Widgets.setEnabled(control, TabJobs.this.selectedJobData != null && !TabJobs.this.slaveHostName.getString().isEmpty());
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(button, new WidgetVariable[]{this.slaveHostName}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                Widgets.setEnabled(control, !widgetVariable.getString().isEmpty());
            }
        });
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                try {
                    TabJobs.this.storageOnMasterFlag.set(button.getSelection());
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.storageOnMasterFlag);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener((Widget)button, this.storageOnMasterFlag));
        Object object2 = new BARWidgets.File(composite2, EnumSet.allOf(BARWidgets.File.WidgetTypes.class), this.maxStorageSize, this.archiveFileMode);
        Widgets.layout((Control)object2, 6, 1, 13);
        Widgets.addModifyListener(new WidgetModifyListener(((BARWidgets.File)object2).maxStorageSize, new WidgetVariable[]{this.maxStorageSize}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                try {
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.maxStorageSize);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public String getString(WidgetVariable widgetVariable) {
                return widgetVariable.getLong() > 0L ? Units.formatByteSize(widgetVariable.getLong()) : "";
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(((BARWidgets.File)object2).archiveFileMode, new WidgetVariable[]{this.archiveFileMode}){

            @Override
            public void modified(Combo combo, WidgetVariable widgetVariable) {
                try {
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.archiveFileMode);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener((Widget)object2, new WidgetVariable[]{this.storageType}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                Widgets.setVisible(control, widgetVariable.getEnum() == StorageTypes.FILESYSTEM);
            }
        });
        Object object3 = new BARWidgets.FTP(composite2, this.storageHostName, this.storageLoginName, this.storageLoginPassword, this.archiveFileMode);
        Widgets.layout((Control)object3, 6, 1, 13);
        Widgets.addModifyListener(new WidgetModifyListener(((BARWidgets.FTP)object3).hostName, new WidgetVariable[]{this.storageHostName}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                try {
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "archive-name", TabJobs.this.getArchiveName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(((BARWidgets.FTP)object3).loginName, new WidgetVariable[]{this.storageLoginName}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                try {
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "ftp-login-name", TabJobs.this.storageLoginName.getString());
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "archive-name", TabJobs.this.getArchiveName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(((BARWidgets.FTP)object3).loginPassword, new WidgetVariable[]{this.storageLoginPassword}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                try {
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "ftp-password", TabJobs.this.storageLoginPassword.getString());
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "archive-name", TabJobs.this.getArchiveName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(((BARWidgets.FTP)object3).archiveFileMode, new WidgetVariable[]{this.archiveFileMode}){

            @Override
            public void modified(Combo combo, WidgetVariable widgetVariable) {
                try {
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.archiveFileMode);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener((Widget)object3, new WidgetVariable[]{this.storageType}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                Widgets.setVisible(control, widgetVariable.getEnum() == StorageTypes.FTP);
            }
        });
        BARWidgets.SFTP sFTP = new BARWidgets.SFTP(composite2, this.storageHostName, this.storageHostPort, this.storageLoginName, this.storageLoginPassword, this.sshPublicKeyFileName, this.sshPrivateKeyFileName, this.archiveFileMode);
        Widgets.layout(sFTP, 6, 1, 13);
        Widgets.addModifyListener(new WidgetModifyListener(sFTP.hostName, new WidgetVariable[]{this.storageHostName}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                try {
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "archive-name", TabJobs.this.getArchiveName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(sFTP.hostPort, new WidgetVariable[]{this.storageHostPort}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                try {
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "ssh-login-port", TabJobs.this.storageHostPort.getInteger());
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "archive-name", TabJobs.this.getArchiveName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(sFTP.loginName, new WidgetVariable[]{this.storageLoginName}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                try {
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "ssh-login-name", TabJobs.this.storageLoginName.getString());
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "archive-name", TabJobs.this.getArchiveName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(sFTP.loginPassword, new WidgetVariable[]{this.storageLoginPassword}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                try {
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "ssh-password", TabJobs.this.storageLoginPassword.getString());
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "archive-name", TabJobs.this.getArchiveName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(sFTP.publicKey, new WidgetVariable[]{this.sshPublicKeyFileName}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                try {
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.sshPublicKeyFileName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(sFTP.privateKey, new WidgetVariable[]{this.sshPrivateKeyFileName}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                try {
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.sshPrivateKeyFileName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(sFTP.archiveFileMode, new WidgetVariable[]{this.archiveFileMode}){

            @Override
            public void modified(Combo combo, WidgetVariable widgetVariable) {
                try {
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.archiveFileMode);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(sFTP, new WidgetVariable[]{this.storageType}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                Widgets.setVisible(control, widgetVariable.getEnum() == StorageTypes.SCP || widgetVariable.getEnum() == StorageTypes.SFTP);
            }
        });
        BARWidgets.WebDAV webDAV = new BARWidgets.WebDAV(composite2, this.storageHostName, this.storageHostPort, this.storageLoginName, this.storageLoginPassword, this.sshPublicKeyFileName, this.sshPrivateKeyFileName, this.archiveFileMode);
        Widgets.layout(webDAV, 6, 1, 13);
        Widgets.addModifyListener(new WidgetModifyListener(webDAV.hostName, new WidgetVariable[]{this.storageHostName}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                try {
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "archive-name", TabJobs.this.getArchiveName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(webDAV.hostPort, new WidgetVariable[]{this.storageHostPort}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                try {
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "webdav-port", TabJobs.this.storageHostPort.getInteger());
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "archive-name", TabJobs.this.getArchiveName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(webDAV.loginName, new WidgetVariable[]{this.storageLoginName}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                try {
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "webdav-login-name", TabJobs.this.storageLoginName.getString());
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "archive-name", TabJobs.this.getArchiveName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(webDAV.loginPassword, new WidgetVariable[]{this.storageLoginPassword}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                try {
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "webdav-password", TabJobs.this.storageLoginPassword.getString());
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "archive-name", TabJobs.this.getArchiveName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(webDAV.publicKey, new WidgetVariable[]{this.sshPublicKeyFileName}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                try {
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.sshPublicKeyFileName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(webDAV.privateKey, new WidgetVariable[]{this.sshPrivateKeyFileName}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                try {
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.sshPrivateKeyFileName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(webDAV.archiveFileMode, new WidgetVariable[]{this.archiveFileMode}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                try {
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.archiveFileMode);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(webDAV, new WidgetVariable[]{this.storageType}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                Widgets.setVisible(control, widgetVariable.getEnum() == StorageTypes.WEBDAV || widgetVariable.getEnum() == StorageTypes.WEBDAVS);
            }
        });
        BARWidgets.SMB sMB = new BARWidgets.SMB(composite2, this.storageHostName, this.storageLoginName, this.storageLoginPassword, this.storageShareName, this.archiveFileMode);
        Widgets.layout(sMB, 6, 1, 13);
        Widgets.addModifyListener(new WidgetModifyListener(sMB.hostName, new WidgetVariable[]{this.storageHostName}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                try {
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "archive-name", TabJobs.this.getArchiveName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(sMB.loginName, new WidgetVariable[]{this.storageLoginName}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                try {
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "smb-login-name", TabJobs.this.storageLoginName.getString());
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "archive-name", TabJobs.this.getArchiveName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(sMB.loginPassword, new WidgetVariable[]{this.storageLoginPassword}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                try {
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "smb-password", TabJobs.this.storageLoginPassword.getString());
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "archive-name", TabJobs.this.getArchiveName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(sMB.shareName, new WidgetVariable[]{this.storageShareName}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                try {
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "archive-name", TabJobs.this.getArchiveName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(sMB.archiveFileMode, new WidgetVariable[]{this.archiveFileMode}){

            @Override
            public void modified(Combo combo, WidgetVariable widgetVariable) {
                try {
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.archiveFileMode);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(sMB, new WidgetVariable[]{this.storageType}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                Widgets.setVisible(control, widgetVariable.getEnum() == StorageTypes.SMB);
            }
        });
        BARWidgets.Optical optical = new BARWidgets.Optical(composite2, this.storageDeviceName, this.volumeSize, this.ecc, this.blank, this.waitFirstVolume, this.archivePartSizeFlag, this.archivePartSize);
        Widgets.layout(optical, 6, 1, 13);
        Widgets.addModifyListener(new WidgetModifyListener(optical.deviceName, new WidgetVariable[]{this.storageDeviceName}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                try {
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "archive-name", TabJobs.this.getArchiveName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(optical.volumeSize, new WidgetVariable[]{this.volumeSize}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                try {
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.volumeSize);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(optical.ecc, new WidgetVariable[]{this.ecc}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                try {
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.ecc);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(optical.blank, new WidgetVariable[]{this.blank}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                try {
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.blank);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(optical.waitFirstVolume, new WidgetVariable[]{this.waitFirstVolume}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                try {
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.waitFirstVolume);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(optical, new WidgetVariable[]{this.storageType}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                Widgets.setVisible(control, widgetVariable.getEnum() == StorageTypes.CD || widgetVariable.getEnum() == StorageTypes.DVD || widgetVariable.getEnum() == StorageTypes.BD);
            }
        });
        BARWidgets.Device device = new BARWidgets.Device(composite2, this.storageDeviceName, this.volumeSize);
        Widgets.layout(device, 6, 1, 13);
        Widgets.addModifyListener(new WidgetModifyListener(device.deviceName, new WidgetVariable[]{this.storageDeviceName}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                try {
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, "archive-name", TabJobs.this.getArchiveName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(device.volumeSize, new WidgetVariable[]{this.volumeSize}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                try {
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.volumeSize);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(device, new WidgetVariable[]{this.storageType}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                Widgets.setVisible(control, widgetVariable.getEnum() == StorageTypes.DEVICE);
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(this.archiveName){

            @Override
            public void parse(String string) {
                URIParts uRIParts = new URIParts(string);
                TabJobs.this.storageType.set(uRIParts.type);
                TabJobs.this.storageLoginName.set(uRIParts.loginName);
                TabJobs.this.storageLoginPassword.set(uRIParts.loginPassword);
                TabJobs.this.storageHostName.set(uRIParts.hostName);
                TabJobs.this.storageHostPort.set(uRIParts.hostPort);
                TabJobs.this.storageShareName.set(uRIParts.shareName);
                TabJobs.this.storageDeviceName.set(uRIParts.deviceName);
                TabJobs.this.storageFileName.set(uRIParts.fileName);
            }
        });
        composite2 = Widgets.addTab(this.widgetTabFolder, BARControl.tr("Scripts", new Object[0]), Settings.hasExpertRole());
        composite2.setLayout(new TableLayout(1.0, 1.0));
        Widgets.layout(composite2, 0, 0, 15);
        tabFolder2 = Widgets.newTabFolder(composite2);
        Widgets.layout(tabFolder2, 0, 0, 15);
        composite3 = Widgets.addTab(tabFolder2, BARControl.tr("Local", new Object[0]), Settings.hasExpertRole());
        composite3.setLayout(new TableLayout(new double[]{0.0, 1.0, 0.0, 1.0}, 1.0));
        Widgets.layout(composite3, 0, 0, 15);
        label = Widgets.newLabel(composite3, BARControl.tr("Pre-script", new Object[0]) + ":");
        Widgets.layout(label, 0, 0, 4);
        composite = Widgets.newComposite(composite3, 0, 4);
        composite.setLayout(new TableLayout(new double[]{1.0, 0.0}, 1.0));
        Widgets.layout(composite, 1, 0, 15);
        styledText = Widgets.newStyledText(composite, 19202);
        styledText.setToolTipText(BARControl.tr("Command or script to execute before start of job.\n\nMacros:\n\n%name - job name\n%archive - archive name\n%type - archive type\n%file - archive file name\n%directory - archive directory\n\nAdditional time macros are available.", new Object[0]));
        Widgets.layout(styledText, 0, 0, 15);
        styledText.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                StyledText styledText = (StyledText)modifyEvent.widget;
                String string = styledText.getText();
                Color color = TabJobs.this.COLOR_MODIFIED;
                if (TabJobs.this.preCommand.equals(string.replace(styledText.getLineDelimiter(), "\n"))) {
                    color = null;
                }
                styledText.setBackground(color);
            }
        });
        styledText.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                StyledText styledText = (StyledText)selectionEvent.widget;
                String string = styledText.getText();
                try {
                    TabJobs.this.preCommand.set(string.replace(styledText.getLineDelimiter(), "\n"));
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.preCommand);
                    styledText.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
            }
        });
        styledText.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                StyledText styledText = (StyledText)focusEvent.widget;
                String string = styledText.getText();
                try {
                    TabJobs.this.preCommand.set(string.replace(styledText.getLineDelimiter(), "\n"));
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.preCommand);
                    styledText.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener((Widget)styledText, this.preCommand));
        button = Widgets.newButton(composite, BARControl.tr("Test", new Object[0]) + "\u2026");
        button.setToolTipText(BARControl.tr("Test script.", new Object[0]));
        Widgets.layout(button, 1, 0, 8);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.testScript("pre-command", TabJobs.this.preCommand.getString());
            }
        });
        label = Widgets.newLabel(composite3, BARControl.tr("Post-script", new Object[0]) + ":");
        Widgets.layout(label, 2, 0, 4);
        composite = Widgets.newComposite(composite3, 0, 4);
        composite.setLayout(new TableLayout(new double[]{1.0, 0.0}, 1.0));
        Widgets.layout(composite, 3, 0, 15);
        styledText = Widgets.newStyledText(composite, 19202);
        styledText.setToolTipText(BARControl.tr("Command or script to execute after termination of job.\n\nMacros:\n\n%name - job name\n%archive - archive name\n%type - archive type\n%T - archive type short\n%file - archive file name\n%directory - archive directory\n%error - error code\n%message - message\n%nextSchedule - next schedule [s]\n%nextScheduleDateTime - next schedule date/time [s]\n\nAdditional time macros are available.", new Object[0]));
        Widgets.layout(styledText, 0, 0, 15);
        styledText.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                StyledText styledText = (StyledText)modifyEvent.widget;
                String string = styledText.getText();
                Color color = TabJobs.this.COLOR_MODIFIED;
                if (TabJobs.this.postCommand.equals(string.replace(styledText.getLineDelimiter(), "\n"))) {
                    color = null;
                }
                styledText.setBackground(color);
            }
        });
        styledText.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                StyledText styledText = (StyledText)selectionEvent.widget;
                String string = styledText.getText();
                try {
                    TabJobs.this.postCommand.set(string.replace(styledText.getLineDelimiter(), "\n"));
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.postCommand);
                    styledText.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
            }
        });
        styledText.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                StyledText styledText = (StyledText)focusEvent.widget;
                String string = styledText.getText();
                try {
                    TabJobs.this.postCommand.set(string.replace(styledText.getLineDelimiter(), "\n"));
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.postCommand);
                    styledText.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener((Widget)styledText, this.postCommand));
        button = Widgets.newButton(composite, BARControl.tr("Test", new Object[0]) + "\u2026");
        button.setToolTipText(BARControl.tr("Test script.", new Object[0]));
        Widgets.layout(button, 1, 0, 8);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.testScript("post-command", TabJobs.this.postCommand.getString());
            }
        });
        composite3 = Widgets.addTab(tabFolder2, BARControl.tr("Slave", new Object[0]), Settings.hasExpertRole());
        composite3.setLayout(new TableLayout(new double[]{0.0, 1.0, 0.0, 1.0}, 1.0));
        Widgets.layout(composite3, 0, 0, 15);
        label = Widgets.newLabel(composite3, BARControl.tr("Pre-script", new Object[0]) + ":");
        Widgets.layout(label, 0, 0, 4);
        composite = Widgets.newComposite(composite3, 0, 4);
        composite.setLayout(new TableLayout(new double[]{1.0, 0.0}, 1.0));
        Widgets.layout(composite, 1, 0, 15);
        styledText = Widgets.newStyledText(composite, 19202);
        styledText.setToolTipText(BARControl.tr("Command or script to execute before start of job on slave.\n\nMacros:\n\n%name - job name\n%archive - archive name\n%type - archive type\n%file - archive file name\n%directory - archive directory\n\nAdditional time macros are available.", new Object[0]));
        Widgets.setEnabled(styledText, false);
        Widgets.layout(styledText, 0, 0, 15);
        styledText.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                StyledText styledText = (StyledText)modifyEvent.widget;
                String string = styledText.getText();
                Color color = TabJobs.this.COLOR_MODIFIED;
                if (TabJobs.this.slavePreCommand.equals(string.replace(styledText.getLineDelimiter(), "\n"))) {
                    color = null;
                }
                styledText.setBackground(color);
            }
        });
        styledText.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                StyledText styledText = (StyledText)selectionEvent.widget;
                String string = styledText.getText();
                try {
                    TabJobs.this.slavePreCommand.set(string.replace(styledText.getLineDelimiter(), "\n"));
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.slavePreCommand);
                    styledText.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
            }
        });
        styledText.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                StyledText styledText = (StyledText)focusEvent.widget;
                String string = styledText.getText();
                try {
                    TabJobs.this.slavePreCommand.set(string.replace(styledText.getLineDelimiter(), "\n"));
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.slavePreCommand);
                    styledText.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener((Widget)styledText, this.slavePreCommand));
        Widgets.addModifyListener(new WidgetModifyListener(styledText, new WidgetVariable[]{this.slaveHostName}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                if (!widgetVariable.getString().isEmpty()) {
                    Widgets.setEnabled(control, true);
                    control.setBackground(null);
                } else {
                    Widgets.setEnabled(control, false);
                    control.setBackground(TabJobs.this.COLOR_DISABLED_BACKGROUND);
                }
            }
        });
        button = Widgets.newButton(composite, BARControl.tr("Test", new Object[0]) + "\u2026");
        button.setToolTipText(BARControl.tr("Test script.", new Object[0]));
        Widgets.setEnabled(button, false);
        Widgets.layout(button, 1, 0, 8);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.testScript("pre-command", TabJobs.this.slavePreCommand.getString());
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(button, new WidgetVariable[]{this.slaveHostName}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                Widgets.setEnabled(control, !widgetVariable.getString().isEmpty());
            }
        });
        label = Widgets.newLabel(composite3, BARControl.tr("Post-script", new Object[0]) + ":");
        Widgets.layout(label, 2, 0, 4);
        composite = Widgets.newComposite(composite3, 0, 4);
        composite.setLayout(new TableLayout(new double[]{1.0, 0.0}, 1.0));
        Widgets.layout(composite, 3, 0, 15);
        styledText = Widgets.newStyledText(composite, 19202);
        styledText.setToolTipText(BARControl.tr("Command or script to execute after termination of job on slave.\n\nMacros:\n\n%name - job name\n%archive - archive name\n%type - archive type\n%T - archive type short\n%file - archive file name\n%directory - archive directory\n%error - error code\n%message - message\n%nextSchedule - next schedule [s]\n%nextScheduleDateTime - next schedule date/time\n\nAdditional time macros are available.", new Object[0]));
        Widgets.setEnabled(styledText, false);
        Widgets.layout(styledText, 0, 0, 15);
        styledText.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                StyledText styledText = (StyledText)modifyEvent.widget;
                String string = styledText.getText();
                Color color = TabJobs.this.COLOR_MODIFIED;
                if (TabJobs.this.slavePostCommand.equals(string.replace(styledText.getLineDelimiter(), "\n"))) {
                    color = null;
                }
                styledText.setBackground(color);
            }
        });
        styledText.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                StyledText styledText = (StyledText)selectionEvent.widget;
                String string = styledText.getText();
                try {
                    TabJobs.this.slavePostCommand.set(string.replace(styledText.getLineDelimiter(), "\n"));
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.slavePostCommand);
                    styledText.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
            }
        });
        styledText.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                StyledText styledText = (StyledText)focusEvent.widget;
                String string = styledText.getText();
                try {
                    TabJobs.this.slavePostCommand.set(string.replace(styledText.getLineDelimiter(), "\n"));
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.slavePostCommand);
                    styledText.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener((Widget)styledText, this.slavePostCommand));
        Widgets.addModifyListener(new WidgetModifyListener(styledText, new WidgetVariable[]{this.slaveHostName}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                if (!widgetVariable.getString().isEmpty()) {
                    Widgets.setEnabled(control, true);
                    control.setBackground(null);
                } else {
                    Widgets.setEnabled(control, false);
                    control.setBackground(TabJobs.this.COLOR_DISABLED_BACKGROUND);
                }
            }
        });
        button = Widgets.newButton(composite, BARControl.tr("Test", new Object[0]) + "\u2026");
        button.setToolTipText(BARControl.tr("Test script.", new Object[0]));
        Widgets.layout(button, 1, 0, 8);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.testScript("post-command", TabJobs.this.slavePostCommand.getString());
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(button, new WidgetVariable[]{this.slaveHostName}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                Widgets.setEnabled(control, !widgetVariable.getString().isEmpty());
            }
        });
        composite2 = Widgets.addTab(this.widgetTabFolder, BARControl.tr("Schedule", new Object[0]));
        composite2.setLayout(new TableLayout(new double[]{1.0, 0.0}, 1.0));
        Widgets.layout(composite2, 0, 0, 15);
        this.widgetScheduleTable = Widgets.newTable(composite2, 32);
        Widgets.layout(this.widgetScheduleTable, 0, 0, 15);
        object2 = new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TableColumn tableColumn = (TableColumn)selectionEvent.widget;
                ScheduleDataComparator scheduleDataComparator = new ScheduleDataComparator(TabJobs.this.widgetScheduleTable, tableColumn);
                Widgets.sortTableColumn(TabJobs.this.widgetScheduleTable, tableColumn, scheduleDataComparator);
            }
        };
        object3 = new Listener(){

            @Override
            public void handleEvent(Event event) {
                Settings.scheduleTableColumns = new Settings.ColumnWidth(Widgets.getTableColumnWidth(TabJobs.this.widgetScheduleTable));
            }
        };
        tableColumn = Widgets.addTableColumn(this.widgetScheduleTable, 0, BARControl.tr("Date", new Object[0]), 16384, 120, false);
        tableColumn.addSelectionListener((SelectionListener)object2);
        tableColumn.addListener(11, (Listener)object3);
        tableColumn = Widgets.addTableColumn(this.widgetScheduleTable, 1, BARControl.tr("Week days", new Object[0]), 16384, 250, true);
        Widgets.sortTableColumn(this.widgetScheduleTable, tableColumn, new ScheduleDataComparator(this.widgetScheduleTable, tableColumn));
        tableColumn.addSelectionListener((SelectionListener)object2);
        tableColumn.addListener(11, (Listener)object3);
        tableColumn = Widgets.addTableColumn(this.widgetScheduleTable, 2, BARControl.tr("Time", new Object[0]), 16384, 100, false);
        tableColumn.addSelectionListener((SelectionListener)object2);
        tableColumn.addListener(11, (Listener)object3);
        tableColumn = Widgets.addTableColumn(this.widgetScheduleTable, 3, BARControl.tr("Archive type", new Object[0]), 16384, 100, true);
        tableColumn.addSelectionListener((SelectionListener)object2);
        tableColumn.addListener(11, (Listener)object3);
        tableColumn = Widgets.addTableColumn(this.widgetScheduleTable, 4, BARControl.tr("Begin", new Object[0]), 16384, 100, false);
        tableColumn.addSelectionListener((SelectionListener)object2);
        tableColumn.addListener(11, (Listener)object3);
        tableColumn = Widgets.addTableColumn(this.widgetScheduleTable, 5, BARControl.tr("End", new Object[0]), 16384, 100, false);
        tableColumn.addSelectionListener((SelectionListener)object2);
        tableColumn.addListener(11, (Listener)object3);
        tableColumn = Widgets.addTableColumn(this.widgetScheduleTable, 6, BARControl.tr("Custom text", new Object[0]), 16384, 90, true);
        tableColumn.addSelectionListener((SelectionListener)object2);
        tableColumn.addListener(11, (Listener)object3);
        tableColumn = Widgets.addTableColumn(this.widgetScheduleTable, 7, BARControl.tr("Test", new Object[0]), 16384, 100, false);
        tableColumn.addSelectionListener((SelectionListener)object2);
        tableColumn.addListener(11, (Listener)object3);
        Widgets.setTableColumnWidth(this.widgetScheduleTable, Settings.scheduleTableColumns.width);
        this.widgetScheduleTable.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Table table = (Table)selectionEvent.widget;
                int n = table.getSelectionIndex();
                if (n >= 0) {
                    TableItem tableItem = table.getItem(n);
                    ScheduleData scheduleData = (ScheduleData)tableItem.getData();
                    try {
                        if (scheduleData.enabled != tableItem.getChecked()) {
                            scheduleData.enabled = tableItem.getChecked();
                            BARServer.setScheduleOption(((TabJobs)TabJobs.this).selectedJobData.uuid, scheduleData.uuid, "enabled", scheduleData.enabled);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.widgetScheduleTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseDoubleClick(MouseEvent mouseEvent) {
                TabJobs.this.scheduleEditEntry();
            }

            @Override
            public void mouseDown(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseUp(MouseEvent mouseEvent) {
            }
        });
        this.widgetScheduleTable.addMouseTrackListener(new MouseTrackListener(){

            @Override
            public void mouseEnter(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExit(MouseEvent mouseEvent) {
                if (TabJobs.this.widgetScheduleTableToolTip != null) {
                    TabJobs.this.widgetScheduleTableToolTip.dispose();
                    TabJobs.this.widgetScheduleTableToolTip = null;
                }
            }

            @Override
            public void mouseHover(MouseEvent mouseEvent) {
                Table table = (Table)mouseEvent.widget;
                TableItem tableItem = table.getItem(new Point(mouseEvent.x, mouseEvent.y));
                if (TabJobs.this.widgetScheduleTableToolTip != null) {
                    TabJobs.this.widgetScheduleTableToolTip.dispose();
                    TabJobs.this.widgetScheduleTableToolTip = null;
                }
                if (tableItem != null && mouseEvent.x > table.getBounds().width / 2) {
                    ScheduleData scheduleData = (ScheduleData)tableItem.getData();
                    TabJobs.this.widgetScheduleTableToolTip = new Shell(TabJobs.this.shell, 540676);
                    TabJobs.this.widgetScheduleTableToolTip.setBackground(TabJobs.this.COLOR_INFO_BACKGROUND);
                    TabJobs.this.widgetScheduleTableToolTip.setLayout(new TableLayout(0.0, new double[]{0.0, 1.0}, 2));
                    Widgets.layout(TabJobs.this.widgetScheduleTableToolTip, 0, 0, 15);
                    TabJobs.this.widgetScheduleTableToolTip.addMouseTrackListener(new MouseTrackListener(){

                        @Override
                        public void mouseEnter(MouseEvent mouseEvent) {
                        }

                        @Override
                        public void mouseExit(MouseEvent mouseEvent) {
                            TabJobs.this.widgetScheduleTableToolTip.dispose();
                            TabJobs.this.widgetScheduleTableToolTip = null;
                        }

                        @Override
                        public void mouseHover(MouseEvent mouseEvent) {
                        }
                    });
                    Label label = Widgets.newLabel((Composite)TabJobs.this.widgetScheduleTableToolTip, BARControl.tr("Last created", new Object[0]) + ":");
                    label.setForeground(TabJobs.this.COLOR_INFO_FOREGROUND);
                    label.setBackground(TabJobs.this.COLOR_INFO_BACKGROUND);
                    Widgets.layout(label, 0, 0, 4);
                    label = Widgets.newLabel((Composite)TabJobs.this.widgetScheduleTableToolTip, scheduleData.lastExecutedDateTime > 0L ? TabJobs.this.SIMPLE_DATE_FORMAT.format(new Date(scheduleData.lastExecutedDateTime * 1000L)) : "-");
                    label.setForeground(TabJobs.this.COLOR_INFO_FOREGROUND);
                    label.setBackground(TabJobs.this.COLOR_INFO_BACKGROUND);
                    Widgets.layout(label, 0, 1, 12);
                    label = Widgets.newLabel((Composite)TabJobs.this.widgetScheduleTableToolTip, BARControl.tr("Total entities", new Object[0]) + ":");
                    label.setForeground(TabJobs.this.COLOR_INFO_FOREGROUND);
                    label.setBackground(TabJobs.this.COLOR_INFO_BACKGROUND);
                    Widgets.layout(label, 1, 0, 4);
                    label = Widgets.newLabel((Composite)TabJobs.this.widgetScheduleTableToolTip, String.format("%d", scheduleData.totalEntities));
                    label.setForeground(TabJobs.this.COLOR_INFO_FOREGROUND);
                    label.setBackground(TabJobs.this.COLOR_INFO_BACKGROUND);
                    Widgets.layout(label, 1, 1, 12);
                    label = Widgets.newLabel((Composite)TabJobs.this.widgetScheduleTableToolTip, BARControl.tr("Total entries", new Object[0]) + ":");
                    label.setForeground(TabJobs.this.COLOR_INFO_FOREGROUND);
                    label.setBackground(TabJobs.this.COLOR_INFO_BACKGROUND);
                    Widgets.layout(label, 2, 0, 4);
                    label = Widgets.newLabel((Composite)TabJobs.this.widgetScheduleTableToolTip, String.format("%d", scheduleData.totalEntryCount));
                    label.setForeground(TabJobs.this.COLOR_INFO_FOREGROUND);
                    label.setBackground(TabJobs.this.COLOR_INFO_BACKGROUND);
                    Widgets.layout(label, 2, 1, 12);
                    label = Widgets.newLabel((Composite)TabJobs.this.widgetScheduleTableToolTip, BARControl.tr("Total size", new Object[0]) + ":");
                    label.setForeground(TabJobs.this.COLOR_INFO_FOREGROUND);
                    label.setBackground(TabJobs.this.COLOR_INFO_BACKGROUND);
                    Widgets.layout(label, 3, 0, 4);
                    label = Widgets.newLabel((Composite)TabJobs.this.widgetScheduleTableToolTip, String.format(BARControl.tr("{0} {0,choice,0#bytes|1#byte|1<bytes} ({1})", scheduleData.totalEntrySize, Units.formatByteSize(scheduleData.totalEntrySize)), new Object[0]));
                    label.setForeground(TabJobs.this.COLOR_INFO_FOREGROUND);
                    label.setBackground(TabJobs.this.COLOR_INFO_BACKGROUND);
                    Widgets.layout(label, 3, 1, 12);
                    Point point = TabJobs.this.widgetScheduleTableToolTip.computeSize(-1, -1);
                    Point point2 = TabJobs.this.widgetScheduleTable.toDisplay(mouseEvent.x + 16, mouseEvent.y);
                    TabJobs.this.widgetScheduleTableToolTip.setBounds(point2.x, point2.y, point.x, point.y);
                    TabJobs.this.widgetScheduleTableToolTip.setVisible(true);
                }
            }
        });
        this.widgetScheduleTable.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (Widgets.isAccelerator(keyEvent, 0x1000009)) {
                    Widgets.invoke(TabJobs.this.widgetScheduleTableAdd);
                } else if (Widgets.isAccelerator(keyEvent, 127)) {
                    Widgets.invoke(TabJobs.this.widgetScheduleTableRemove);
                } else if (Widgets.isAccelerator(keyEvent, 13) || Widgets.isAccelerator(keyEvent, 0x1000050)) {
                    Widgets.invoke(TabJobs.this.widgetScheduleTableEdit);
                }
            }
        });
        menu = Widgets.newPopupMenu(this.shell);
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Add", new Object[0]) + "\u2026");
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.scheduleAddEntry();
            }
        });
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Edit", new Object[0]) + "\u2026");
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.scheduleEditEntry();
            }
        });
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Clone", new Object[0]) + "\u2026", Settings.hasNormalRole());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.scheduleCloneEntry();
            }
        });
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Remove", new Object[0]) + "\u2026");
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.scheduleRemoveEntry();
            }
        });
        Widgets.addMenuItemSeparator(menu, Settings.hasExpertRole());
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Trigger now", new Object[0]), Settings.hasExpertRole());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.scheduleTriggerEntry();
            }
        });
        this.widgetScheduleTable.setMenu(menu);
        composite = Widgets.newComposite(composite2);
        Widgets.layout(composite, 1, 0, 12);
        this.widgetScheduleTableAdd = Widgets.newButton(composite, BARControl.tr("Add", new Object[0]) + "\u2026");
        this.widgetScheduleTableAdd.setToolTipText(BARControl.tr("Add new schedule entry.", new Object[0]));
        Widgets.layout(this.widgetScheduleTableAdd, 0, 0, 0, 0, 0, 0, 0, 110, -1);
        this.widgetScheduleTableAdd.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.scheduleAddEntry();
            }
        });
        this.widgetScheduleTableEdit = Widgets.newButton(composite, BARControl.tr("Edit", new Object[0]) + "\u2026");
        this.widgetScheduleTableEdit.setToolTipText(BARControl.tr("Edit schedule entry.", new Object[0]));
        Widgets.layout(this.widgetScheduleTableEdit, 0, 1, 0, 0, 0, 0, 0, 110, -1);
        this.widgetScheduleTableEdit.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.scheduleEditEntry();
            }
        });
        button = Widgets.newButton(composite, BARControl.tr("Clone", new Object[0]) + "\u2026", Settings.hasNormalRole());
        button.setToolTipText(BARControl.tr("Clone schedule entry.", new Object[0]));
        Widgets.layout(button, 0, 2, 0, 0, 0, 0, 0, 110, -1);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.scheduleCloneEntry();
            }
        });
        this.widgetScheduleTableRemove = Widgets.newButton(composite, BARControl.tr("Remove", new Object[0]) + "\u2026");
        this.widgetScheduleTableRemove.setToolTipText(BARControl.tr("Remove schedule entry.", new Object[0]));
        Widgets.layout(this.widgetScheduleTableRemove, 0, 3, 0, 0, 0, 0, 0, 110, -1);
        this.widgetScheduleTableRemove.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.scheduleRemoveEntry();
            }
        });
        composite2 = Widgets.addTab(this.widgetTabFolder, BARControl.tr("Persistence", new Object[0]), Settings.hasExpertRole());
        composite2.setLayout(new TableLayout(new double[]{1.0, 0.0}, 1.0));
        Widgets.layout(composite2, 0, 0, 15);
        this.widgetPersistenceTree = Widgets.newTree(composite2);
        this.widgetPersistenceTree.setLayout(new TableLayout(1.0, new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 0.0}));
        Widgets.layout(this.widgetPersistenceTree, 0, 0, 15);
        Widgets.addTreeColumn(this.widgetPersistenceTree, BARControl.tr("Archive type", new Object[0]), 16384, 100, true);
        Widgets.addTreeColumn(this.widgetPersistenceTree, BARControl.tr("min. keep", new Object[0]), 131072, 90, true);
        Widgets.addTreeColumn(this.widgetPersistenceTree, BARControl.tr("max. keep", new Object[0]), 131072, 90, true);
        Widgets.addTreeColumn(this.widgetPersistenceTree, BARControl.tr("max. age", new Object[0]), 131072, 90, true);
        Widgets.addTreeColumn(this.widgetPersistenceTree, BARControl.tr("Created", new Object[0]), 16384, 140, true);
        Widgets.addTreeColumn(this.widgetPersistenceTree, BARControl.tr("Age [days]", new Object[0]), 131072, 90, true);
        Widgets.addTreeColumn(this.widgetPersistenceTree, BARControl.tr("Total size", new Object[0]), 131072, 120, true);
        Widgets.setTreeColumnWidth(this.widgetPersistenceTree, Settings.persistenceTreeColumns.width);
        this.widgetPersistenceTree.addListener(40, new Listener(){

            @Override
            public void handleEvent(Event event) {
                TreeItem treeItem = (TreeItem)event.item;
                Rectangle rectangle = TabJobs.this.widgetPersistenceTree.getBounds();
                Rectangle rectangle2 = event.getBounds();
                GC gC = event.gc;
                gC.setAdvanced(true);
                if (gC.getAdvanced()) {
                    gC.setAlpha(127);
                }
                if (!(treeItem.getData() instanceof PersistenceData) && treeItem.getData() instanceof EntityIndexData) {
                    EntityIndexData entityIndexData = (EntityIndexData)treeItem.getData();
                    if (entityIndexData.inTransit) {
                        Color color = gC.getBackground();
                        gC.setBackground(TabJobs.this.COLOR_IN_TRANSIT);
                        gC.fillRectangle(rectangle2.x, rectangle2.y, rectangle.width, rectangle2.height);
                        gC.setBackground(color);
                    }
                }
                event.detail &= 0xFFFFFFF7;
            }
        });
        this.widgetPersistenceTree.addMouseListener(new MouseListener(){

            @Override
            public void mouseDoubleClick(MouseEvent mouseEvent) {
                TabJobs.this.persistenceListEdit();
            }

            @Override
            public void mouseDown(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseUp(MouseEvent mouseEvent) {
            }
        });
        this.widgetPersistenceTree.addMouseTrackListener(new MouseTrackListener(){

            @Override
            public void mouseEnter(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExit(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseHover(MouseEvent mouseEvent) {
                Tree tree = (Tree)mouseEvent.widget;
                TreeItem treeItem = tree.getItem(new Point(mouseEvent.x, mouseEvent.y));
                if (TabJobs.this.widgetPersistenceTreeToolTip != null) {
                    TabJobs.this.widgetPersistenceTreeToolTip.dispose();
                    TabJobs.this.widgetPersistenceTreeToolTip = null;
                }
                if (treeItem != null && mouseEvent.x > tree.getBounds().width / 2) {
                    Point point = TabJobs.this.display.getCursorLocation();
                    if (point.x > 16) {
                        point.x -= 16;
                    }
                    if (point.y > 16) {
                        point.y -= 16;
                    }
                    if (!(treeItem.getData() instanceof PersistenceData) && treeItem.getData() instanceof EntityIndexData) {
                        TabJobs.this.showEntityIndexToolTip((EntityIndexData)treeItem.getData(), point.x, point.y);
                    }
                }
            }
        });
        this.widgetPersistenceTree.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (Widgets.isAccelerator(keyEvent, 0x1000009)) {
                    Widgets.invoke(TabJobs.this.widgetPersistenceTreeAdd);
                } else if (Widgets.isAccelerator(keyEvent, 127)) {
                    Widgets.invoke(TabJobs.this.widgetPersistenceTreeRemove);
                } else if (Widgets.isAccelerator(keyEvent, 13) || Widgets.isAccelerator(keyEvent, 0x1000050)) {
                    Widgets.invoke(TabJobs.this.widgetPersistenceTreeEdit);
                }
            }
        });
        menu = Widgets.newPopupMenu(this.shell);
        menu.addListener(22, new Listener(){

            @Override
            public void handleEvent(Event event) {
                Menu menu = (Menu)event.widget;
                Point point = TabJobs.this.widgetPersistenceTree.toControl(Display.getCurrent().getCursorLocation());
                final TreeItem treeItem = TabJobs.this.widgetPersistenceTree.getItem(point);
                Widgets.removeAllMenuItems(menu);
                if (treeItem != null) {
                    if (treeItem.getData() instanceof PersistenceData) {
                        final PersistenceData persistenceData = (PersistenceData)treeItem.getData();
                        MenuItem menuItem = Widgets.addMenuItem(menu, BARControl.tr("Add", new Object[0]) + "\u2026");
                        menuItem.addSelectionListener(new SelectionListener(){

                            @Override
                            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                            }

                            @Override
                            public void widgetSelected(SelectionEvent selectionEvent) {
                                TabJobs.this.persistenceListAdd();
                            }
                        });
                        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Edit", new Object[0]) + "\u2026");
                        menuItem.addSelectionListener(new SelectionListener(){

                            @Override
                            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                            }

                            @Override
                            public void widgetSelected(SelectionEvent selectionEvent) {
                                TabJobs.this.persistenceListEdit();
                            }
                        });
                        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Clone", new Object[0]) + "\u2026", Settings.hasNormalRole());
                        menuItem.addSelectionListener(new SelectionListener(){

                            @Override
                            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                            }

                            @Override
                            public void widgetSelected(SelectionEvent selectionEvent) {
                                TabJobs.this.persistenceListClone();
                            }
                        });
                        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Remove", new Object[0]) + "\u2026");
                        menuItem.addSelectionListener(new SelectionListener(){

                            @Override
                            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                            }

                            @Override
                            public void widgetSelected(SelectionEvent selectionEvent) {
                                TabJobs.this.persistenceListRemove(persistenceData);
                            }
                        });
                    } else if (treeItem.getData() instanceof EntityIndexData) {
                        final EntityIndexData entityIndexData = (EntityIndexData)treeItem.getData();
                        MenuItem menuItem = Widgets.addMenuItem(menu, BARControl.tr("Refresh", new Object[0]) + "\u2026");
                        menuItem.addSelectionListener(new SelectionListener(){

                            @Override
                            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                            }

                            @Override
                            public void widgetSelected(SelectionEvent selectionEvent) {
                                TabJobs.this.refreshEntityIndex(entityIndexData);
                            }
                        });
                        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Remove from index", new Object[0]) + "\u2026");
                        menuItem.addSelectionListener(new SelectionListener(){

                            @Override
                            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                            }

                            @Override
                            public void widgetSelected(SelectionEvent selectionEvent) {
                                if (Dialogs.confirm(TabJobs.this.shell, BARControl.tr("Remove entity from index with {0} {0,choice,0#entries|1#entry|1<entries}?", entityIndexData.totalEntryCount))) {
                                    TabJobs.this.removeEntityIndex(entityIndexData);
                                    Widgets.removeTreeItem(TabJobs.this.widgetPersistenceTree, entityIndexData);
                                }
                            }
                        });
                        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Delete", new Object[0]) + "\u2026");
                        menuItem.addSelectionListener(new SelectionListener(){

                            @Override
                            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                            }

                            @Override
                            public void widgetSelected(SelectionEvent selectionEvent) {
                                if (Dialogs.confirm(TabJobs.this.shell, BARControl.tr("Delete entity with {0} {0,choice,0#entries|1#entry|1<entries}, {1} ({2} {2,choice,0#bytes|1#byte|1<bytes})?", entityIndexData.totalEntryCount, Units.formatByteSize(entityIndexData.totalEntrySize), entityIndexData.totalEntrySize)) && TabJobs.this.deleteEntity(entityIndexData)) {
                                    Widgets.removeTreeItem(treeItem);
                                }
                            }
                        });
                        Widgets.addMenuItemSeparator(menu);
                        menuItem = Widgets.addMenuItem(menu, BARControl.tr("Info", new Object[0]) + "\u2026");
                        menuItem.addSelectionListener(new SelectionListener(){

                            @Override
                            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                            }

                            @Override
                            public void widgetSelected(SelectionEvent selectionEvent) {
                                if (TabJobs.this.widgetPersistenceTreeToolTip != null) {
                                    TabJobs.this.widgetPersistenceTreeToolTip.dispose();
                                    TabJobs.this.widgetPersistenceTreeToolTip = null;
                                }
                                if (treeItem != null) {
                                    Point point = TabJobs.this.display.getCursorLocation();
                                    if (point.x > 16) {
                                        point.x -= 16;
                                    }
                                    if (point.y > 16) {
                                        point.y -= 16;
                                    }
                                    TabJobs.this.showEntityIndexToolTip(entityIndexData, point.x, point.y);
                                }
                            }
                        });
                    }
                }
            }
        });
        this.widgetPersistenceTree.setMenu(menu);
        composite = Widgets.newComposite(composite2);
        Widgets.layout(composite, 1, 0, 12);
        this.widgetPersistenceTreeAdd = Widgets.newButton(composite, BARControl.tr("Add", new Object[0]) + "\u2026");
        this.widgetPersistenceTreeAdd.setToolTipText(BARControl.tr("Add new persistence entry.", new Object[0]));
        Widgets.layout(this.widgetPersistenceTreeAdd, 0, 0, 0, 0, 0, 0, 0, 110, -1);
        this.widgetPersistenceTreeAdd.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.persistenceListAdd();
            }
        });
        this.widgetPersistenceTreeEdit = Widgets.newButton(composite, BARControl.tr("Edit", new Object[0]) + "\u2026");
        this.widgetPersistenceTreeEdit.setToolTipText(BARControl.tr("Edit persistence entry.", new Object[0]));
        Widgets.layout(this.widgetPersistenceTreeEdit, 0, 1, 0, 0, 0, 0, 0, 110, -1);
        this.widgetPersistenceTreeEdit.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.persistenceListEdit();
            }
        });
        button = Widgets.newButton(composite, BARControl.tr("Clone", new Object[0]) + "\u2026", Settings.hasNormalRole());
        button.setToolTipText(BARControl.tr("Clone persistence entry.", new Object[0]));
        Widgets.layout(button, 0, 2, 0, 0, 0, 0, 0, 110, -1);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.persistenceListClone();
            }
        });
        this.widgetPersistenceTreeRemove = Widgets.newButton(composite, BARControl.tr("Remove", new Object[0]) + "\u2026");
        this.widgetPersistenceTreeRemove.setToolTipText(BARControl.tr("Remove persistence entry.", new Object[0]));
        Widgets.layout(this.widgetPersistenceTreeRemove, 0, 3, 0, 0, 0, 0, 0, 110, -1);
        this.widgetPersistenceTreeRemove.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabJobs.this.persistenceListRemove();
            }
        });
        composite2 = Widgets.addTab(this.widgetTabFolder, BARControl.tr("Comment", new Object[0]), Settings.hasNormalRole());
        composite2.setLayout(new TableLayout(1.0, 1.0));
        Widgets.layout(composite2, 0, 0, 15);
        styledText = Widgets.newStyledText(composite2, 19202);
        styledText.setToolTipText(BARControl.tr("Free text comment for job.", new Object[0]));
        Widgets.layout(styledText, 0, 0, 15);
        styledText.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                StyledText styledText = (StyledText)modifyEvent.widget;
                String string = styledText.getText();
                Color color = TabJobs.this.COLOR_MODIFIED;
                if (TabJobs.this.comment.equals(string.replace(styledText.getLineDelimiter(), "\n"))) {
                    color = null;
                }
                styledText.setBackground(color);
            }
        });
        styledText.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                StyledText styledText = (StyledText)selectionEvent.widget;
                String string = styledText.getText();
                try {
                    TabJobs.this.comment.set(string.replace(styledText.getLineDelimiter(), "\n"));
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.comment);
                    styledText.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
            }
        });
        styledText.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                StyledText styledText = (StyledText)focusEvent.widget;
                String string = styledText.getText();
                try {
                    TabJobs.this.comment.set(string.replace(styledText.getLineDelimiter(), "\n"));
                    BARServer.setJobOption(((TabJobs)TabJobs.this).selectedJobData.uuid, TabJobs.this.comment);
                    styledText.setBackground(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener((Widget)styledText, this.comment));
        Widgets.addEventListener(new WidgetEventListener(this.widgetTabFolder, this.selectJobEvent){

            @Override
            public void trigger(Control control) {
                Widgets.setEnabled(control, TabJobs.this.selectedJobData != null);
            }
        });
        this.shell.addListener(65535, new Listener(){

            @Override
            public void handleEvent(Event event) {
                TabJobs.this.clearSelectedJob();
            }
        });
        this.shell.addListener(65536, new Listener(){

            @Override
            public void handleEvent(Event event) {
                assert (event.text != null);
            }
        });
        this.shell.addListener(65537, new Listener(){

            @Override
            public void handleEvent(Event event) {
                TabJobs.this.update();
            }
        });
        this.shell.addListener(65538, new Listener(){

            @Override
            public void handleEvent(Event event) {
                assert (event.text != null);
                TabJobs.this.clearSelectedJob();
            }
        });
        this.shell.addListener(65539, new Listener(){

            @Override
            public void handleEvent(Event event) {
                assert (event.text != null);
                if (!TabJobs.this.widgetJobList.isDisposed()) {
                    for (JobData jobData : (JobData[])Widgets.getOptionMenuItems(TabJobs.this.widgetJobList, JobData.class)) {
                        if (!jobData.uuid.equals(event.text)) continue;
                        TabJobs.this.setSelectedJob(jobData);
                        break;
                    }
                }
            }
        });
        this.updateThread = new UpdateThread();
    }

    public void setTabStatus(TabStatus tabStatus) {
        this.tabStatus = tabStatus;
    }

    public void startUpdate() {
        this.updateThread.start();
    }

    public void updateJobList(final Collection<JobData> collection) {
        this.display.syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Override
            public void run() {
                if (!TabJobs.this.widgetJobList.isDisposed()) {
                    void var4_7;
                    HashSet<JobData> hashSet = new HashSet<JobData>();
                    JobData[] object = (JobData[])Widgets.getOptionMenuItems(TabJobs.this.widgetJobList, JobData.class);
                    int combo = object.length;
                    boolean object2 = false;
                    while (var4_7 < combo) {
                        JobData jobData = object[var4_7];
                        hashSet.add(jobData);
                        ++var4_7;
                    }
                    Comparator<JobData> comparator = new Comparator<JobData>(){

                        @Override
                        public int compare(JobData jobData, JobData jobData2) {
                            return jobData2.name.compareTo(jobData.name);
                        }
                    };
                    Combo combo2 = TabJobs.this.widgetJobList;
                    synchronized (combo2) {
                        for (JobData jobData : collection) {
                            if (!Widgets.updateInsertOptionMenuItem(TabJobs.this.widgetJobList, comparator, jobData, jobData.name)) continue;
                            hashSet.remove(jobData);
                        }
                    }
                    for (JobData jobData : hashSet) {
                        Widgets.removeOptionMenuItem(TabJobs.this.widgetJobList, jobData);
                    }
                    Widgets.setSelectedOptionMenuItem(TabJobs.this.widgetJobList, TabJobs.this.selectedJobData);
                }
            }
        });
    }

    public boolean jobNew() {
        class Data {
            String jobName = "";

            Data() {
            }
        }
        final Data data = new Data();
        final Shell shell = Dialogs.openModal(this.shell, BARControl.tr("New job", new Object[0]), 300, -1, new double[]{1.0, 0.0}, 1.0);
        Composite composite = Widgets.newComposite((Composite)shell, 0, 4);
        composite.setLayout(new TableLayout(null, new double[]{0.0, 1.0}, 4));
        Widgets.layout((Control)composite, 0, 0, 12, 0, 0, 2);
        Label label = Widgets.newLabel(composite, BARControl.tr("Name", new Object[0]) + ":");
        Widgets.layout(label, 0, 0, 4);
        final Text text = Widgets.newText(composite);
        Widgets.layout(text, 0, 1, 12);
        composite = Widgets.newComposite((Composite)shell, 0, 4);
        composite.setLayout(new TableLayout(0.0, 1.0));
        Widgets.layout((Control)composite, 1, 0, 12, 0, 0, 2);
        final Button button = Widgets.newButton(composite, BARControl.tr("Add", new Object[0]));
        button.setEnabled(false);
        Widgets.layout(button, 0, 0, 4, 0, 0, 0, 0, 100, -1);
        Button button2 = Widgets.newButton(composite, BARControl.tr("Cancel", new Object[0]));
        Widgets.layout(button2, 0, 1, 8, 0, 0, 0, 0, 100, -1);
        button2.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Dialogs.close(shell, false);
            }
        });
        text.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                Text text = (Text)modifyEvent.widget;
                String string = text.getText().trim();
                button.setEnabled(!string.isEmpty());
            }
        });
        text.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                button.forceFocus();
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                throw new Error("NYI");
            }
        });
        button.addSelectionListener(new SelectionListener(){
            {
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                data.jobName = text.getText();
                Dialogs.close(shell, true);
            }
        });
        if (((Boolean)Dialogs.run(shell, false)).booleanValue()) {
            if (!data.jobName.isEmpty()) {
                try {
                    ValueMap valueMap = new ValueMap();
                    BARServer.executeCommand(StringParser.format("JOB_NEW name=%S", data.jobName), 0, valueMap);
                    String string = valueMap.getString("jobUUID");
                    Widgets.notify((Widget)this.shell, 65536, string);
                }
                catch (Exception exception) {
                    Dialogs.error(this.shell, BARControl.tr("Cannot create new job:\n\n{0}", exception.getMessage()));
                    BARControl.logThrowable(exception);
                    return false;
                }
                catch (CommunicationError communicationError) {
                    Dialogs.error(this.shell, BARControl.tr("Cannot create new job:\n\n{0}", communicationError.getMessage()));
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean jobClone(final JobData jobData) {
        assert (jobData != null);
        class Data {
            String jobName = "";

            Data() {
            }
        }
        final Data data = new Data();
        final Shell shell = Dialogs.openModal(this.shell, BARControl.tr("Clone job", new Object[0]), 300, -1, new double[]{1.0, 0.0}, 1.0);
        Composite composite = Widgets.newComposite((Composite)shell, 0, 4);
        composite.setLayout(new TableLayout(null, new double[]{0.0, 1.0}, 4));
        Widgets.layout((Control)composite, 0, 0, 12, 0, 0, 2);
        Label label = Widgets.newLabel(composite, BARControl.tr("Name", new Object[0]) + ":");
        Widgets.layout(label, 0, 0, 4);
        final Text text = Widgets.newText(composite);
        text.setText(jobData.name);
        Widgets.layout(text, 0, 1, 12);
        composite = Widgets.newComposite((Composite)shell, 0, 4);
        composite.setLayout(new TableLayout(0.0, 1.0));
        Widgets.layout((Control)composite, 1, 0, 12, 0, 0, 2);
        final Button button = Widgets.newButton(composite, BARControl.tr("Clone", new Object[0]));
        button.setEnabled(false);
        Widgets.layout(button, 0, 0, 4, 0, 0, 0, 0, 100, -1);
        Button button2 = Widgets.newButton(composite, BARControl.tr("Cancel", new Object[0]));
        Widgets.layout(button2, 0, 1, 8, 0, 0, 0, 0, 100, -1);
        button2.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Dialogs.close(shell, false);
            }
        });
        text.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                Text text = (Text)modifyEvent.widget;
                String string = text.getText();
                button.setEnabled(!string.isEmpty() && !string.equals(jobData.name));
            }
        });
        text.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                button.forceFocus();
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                throw new Error("NYI");
            }
        });
        button.addSelectionListener(new SelectionListener(){
            {
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                data.jobName = text.getText();
                Dialogs.close(shell, true);
            }
        });
        Widgets.setFocus(text);
        if (((Boolean)Dialogs.run(shell, false)).booleanValue()) {
            if (!data.jobName.isEmpty()) {
                try {
                    ValueMap valueMap = new ValueMap();
                    BARServer.executeCommand(StringParser.format("JOB_CLONE jobUUID=%s name=%S", jobData.uuid, data.jobName), 0, valueMap);
                    String string = valueMap.getString("jobUUID");
                    Widgets.notify((Widget)this.shell, 65536, string);
                }
                catch (Exception exception) {
                    Dialogs.error(this.shell, BARControl.tr("Cannot clone job ''{0}'':\n\n{1}", jobData.name.replaceAll("&", "&&"), exception.getMessage()));
                    BARControl.logThrowable(exception);
                    return false;
                }
                catch (CommunicationError communicationError) {
                    Dialogs.error(this.shell, BARControl.tr("Cannot clone job ''{0}'':\n\n{1}", jobData.name.replaceAll("&", "&&"), communicationError.getMessage()));
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean jobRename(final JobData jobData) {
        assert (jobData != null);
        class Data {
            String jobName = "";

            Data() {
            }
        }
        final Data data = new Data();
        final Shell shell = Dialogs.openModal(this.shell, BARControl.tr("Rename job", new Object[0]), 300, -1, new double[]{1.0, 0.0}, 1.0);
        Composite composite = Widgets.newComposite((Composite)shell, 0, 4);
        composite.setLayout(new TableLayout(null, new double[]{0.0, 1.0}, 4));
        Widgets.layout((Control)composite, 0, 0, 12, 0, 0, 2);
        Label label = Widgets.newLabel(composite, BARControl.tr("Old name", new Object[0]) + ":");
        Widgets.layout(label, 0, 0, 4);
        label = Widgets.newLabel(composite, jobData.name.replaceAll("&", "&&"));
        Widgets.layout(label, 0, 1, 4);
        label = Widgets.newLabel(composite, BARControl.tr("New name", new Object[0]) + ":");
        Widgets.layout(label, 1, 0, 4);
        final Text text = Widgets.newText(composite);
        text.setText(jobData.name);
        Widgets.layout(text, 1, 1, 12);
        composite = Widgets.newComposite((Composite)shell, 0, 4);
        composite.setLayout(new TableLayout(0.0, 1.0));
        Widgets.layout((Control)composite, 1, 0, 12, 0, 0, 2);
        final Button button = Widgets.newButton(composite, BARControl.tr("Rename", new Object[0]));
        button.setEnabled(false);
        Widgets.layout(button, 0, 0, 4);
        Button button2 = Widgets.newButton(composite, BARControl.tr("Cancel", new Object[0]));
        Widgets.layout(button2, 0, 1, 8);
        button2.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Dialogs.close(shell, false);
            }
        });
        text.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                Text text = (Text)modifyEvent.widget;
                String string = text.getText();
                button.setEnabled(!string.isEmpty() && !string.equals(jobData.name));
            }
        });
        text.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                button.forceFocus();
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                throw new Error("NYI");
            }
        });
        button.addSelectionListener(new SelectionListener(){
            {
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                data.jobName = text.getText();
                Dialogs.close(shell, true);
            }
        });
        Widgets.setFocus(text);
        if (((Boolean)Dialogs.run(shell, false)).booleanValue()) {
            if (!data.jobName.isEmpty()) {
                try {
                    BARServer.executeCommand(StringParser.format("JOB_RENAME jobUUID=%s newName=%S", jobData.uuid, data.jobName), 0);
                }
                catch (Exception exception) {
                    Dialogs.error(this.shell, BARControl.tr("Cannot rename job ''{0}'':\n\n{1}", jobData.name.replaceAll("&", "&&"), exception.getMessage()));
                    BARControl.logThrowable(exception);
                    return false;
                }
                catch (CommunicationError communicationError) {
                    Dialogs.error(this.shell, BARControl.tr("Cannot rename job ''{0}'':\n\n{1}", jobData.name.replaceAll("&", "&&"), communicationError.getMessage()));
                    return false;
                }
            }
            Widgets.notify((Widget)this.shell, 65537, jobData.uuid);
            return true;
        }
        return false;
    }

    public boolean jobDelete(JobData jobData) {
        assert (jobData != null);
        if (Dialogs.confirm(this.shell, BARControl.tr("Delete job ''{0}''?", jobData.name.replaceAll("&", "&&")))) {
            try {
                BARServer.executeCommand(StringParser.format("JOB_DELETE jobUUID=%s", jobData.uuid), 0);
            }
            catch (Exception exception) {
                Dialogs.error(this.shell, BARControl.tr("Cannot delete job ''{0}'':\n\n{1}", jobData.name.replaceAll("&", "&&"), exception.getMessage()));
                BARControl.logThrowable(exception);
                return false;
            }
            catch (CommunicationError communicationError) {
                Dialogs.error(this.shell, BARControl.tr("Cannot delete job ''{0}'':\n\n{1}", jobData.name.replaceAll("&", "&&"), communicationError.getMessage()));
                return false;
            }
            Widgets.notify((Widget)this.shell, 65538, jobData.uuid);
            return true;
        }
        return false;
    }

    private void getJobData() {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                Widgets.setEnabled(TabJobs.this.widgetTabFolder, false);
            }
        });
        if (this.selectedJobData != null) {
            BARServer.lockSet();
            try {
                BARServer.getJobOption(this.selectedJobData.uuid, this.slaveHostName);
                BARServer.getJobOption(this.selectedJobData.uuid, this.slaveHostPort);
                BARServer.getJobOption(this.selectedJobData.uuid, this.slaveTLSMode);
                BARServer.getJobOption(this.selectedJobData.uuid, this.includeFileCommand);
                BARServer.getJobOption(this.selectedJobData.uuid, this.includeImageCommand);
                BARServer.getJobOption(this.selectedJobData.uuid, this.excludeCommand);
                BARServer.getJobOption(this.selectedJobData.uuid, this.archiveName);
                BARServer.getJobOption(this.selectedJobData.uuid, this.archiveType);
                this.archivePartSize.set(Units.parseByteSize(BARServer.getStringJobOption(this.selectedJobData.uuid, "archive-part-size"), 0L));
                this.archivePartSizeFlag.set(this.archivePartSize.getLong() > 0L);
                String[] stringArray = this.parseCompressAlgorithm(BARServer.getStringJobOption(this.selectedJobData.uuid, "compress-algorithm"));
                this.deltaCompressAlgorithm.set(stringArray[0]);
                this.byteCompressAlgorithmType.set(stringArray[1]);
                this.byteCompressAlgorithm.set(stringArray[2]);
                this.cryptAlgorithm.set(BARServer.getStringJobOption(this.selectedJobData.uuid, "crypt-algorithm"));
                this.cryptType.set(BARServer.getStringJobOption(this.selectedJobData.uuid, "crypt-type"));
                BARServer.getJobOption(this.selectedJobData.uuid, this.cryptPublicKeyFileName);
                this.cryptPasswordMode.set(BARServer.getStringJobOption(this.selectedJobData.uuid, "crypt-password-mode"));
                BARServer.getJobOption(this.selectedJobData.uuid, this.cryptPassword);
                BARServer.getJobOption(this.selectedJobData.uuid, this.incrementalListFileName);
                this.archiveFileMode.set(BARServer.getStringJobOption(this.selectedJobData.uuid, "archive-file-mode"));
                BARServer.getJobOption(this.selectedJobData.uuid, this.storageOnMasterFlag);
                BARServer.getJobOption(this.selectedJobData.uuid, this.sshPublicKeyFileName);
                BARServer.getJobOption(this.selectedJobData.uuid, this.sshPrivateKeyFileName);
                BARServer.getJobOption(this.selectedJobData.uuid, this.volumeSize);
                BARServer.getJobOption(this.selectedJobData.uuid, this.ecc);
                BARServer.getJobOption(this.selectedJobData.uuid, this.blank);
                BARServer.getJobOption(this.selectedJobData.uuid, this.waitFirstVolume);
                BARServer.getJobOption(this.selectedJobData.uuid, this.skipUnreadable);
                BARServer.getJobOption(this.selectedJobData.uuid, this.noStopOnOwnerError);
                BARServer.getJobOption(this.selectedJobData.uuid, this.noStopOnAttributeError);
                BARServer.getJobOption(this.selectedJobData.uuid, this.rawImages);
                BARServer.getJobOption(this.selectedJobData.uuid, this.overwriteFiles);
                BARServer.getJobOption(this.selectedJobData.uuid, this.preCommand);
                BARServer.getJobOption(this.selectedJobData.uuid, this.postCommand);
                BARServer.getJobOption(this.selectedJobData.uuid, this.slavePreCommand);
                BARServer.getJobOption(this.selectedJobData.uuid, this.slavePostCommand);
                BARServer.getJobOption(this.selectedJobData.uuid, this.maxStorageSize);
                BARServer.getJobOption(this.selectedJobData.uuid, this.comment);
                this.updateIncludeList(this.selectedJobData);
                this.updateExcludeList(this.selectedJobData);
                this.updateMountList(this.selectedJobData);
                this.updateSourceList(this.selectedJobData);
                this.updateCompressExcludeList(this.selectedJobData);
                this.updateScheduleTable(this.selectedJobData);
                this.updatePersistenceTree(this.selectedJobData);
                this.updateFileTreeImages();
                this.updateDeviceImages();
            }
            catch (Exception exception) {
            }
            finally {
                BARServer.unlockSet();
            }
        } else {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    TabJobs.this.clearSelectedJob();
                }
            });
        }
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                Widgets.setEnabled(TabJobs.this.widgetTabFolder, true);
            }
        });
    }

    private void update() {
        block3: {
            if (this.selectedJobData != null) {
                try {
                    this.updateRootList();
                    this.updateDevicesList();
                    this.updatePersistenceTree(this.selectedJobData);
                }
                catch (Throwable throwable) {
                    if (Settings.debugLevel <= 0) break block3;
                    BARServer.disconnect();
                    BARControl.internalError(throwable);
                }
            }
        }
    }

    private boolean isIncluded(String string) {
        for (String string2 : this.includeHashMap.keySet()) {
            if (!string.matches(StringUtils.globToRegex(string2))) continue;
            return true;
        }
        return false;
    }

    private boolean isExcluded(String string) {
        for (String string2 : this.excludeHashSet) {
            if (!string.matches(StringUtils.globToRegex(string2))) continue;
            return true;
        }
        return false;
    }

    private String[] parseCompressAlgorithm(String string) {
        try {
            String[] stringArray = StringUtils.splitArray(string, "+");
            Matcher matcher = Pattern.compile("^(none|zip|bzip|lzma|lzo|lz4|zstd)(-{0,1}[0-9]+){0,1}$").matcher(stringArray[1]);
            String string2 = matcher.matches() ? matcher.group(1) : "";
            if (stringArray.length >= 2) {
                return new String[]{stringArray[0], string2, stringArray[1]};
            }
            if (stringArray.length >= 1) {
                return new String[]{"", string2, stringArray[0]};
            }
            return new String[]{"", "", ""};
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return new String[]{"", "", ""};
        }
    }

    private String getArchiveName() {
        URIParts uRIParts = new URIParts((StorageTypes)((Object)this.storageType.getEnum()), this.storageHostName.getString(), this.storageHostPort.getInteger(), this.storageLoginName.getString(), this.storageLoginPassword.getString(), this.storageShareName.getString(), this.storageDeviceName.getString(), this.storageFileName.getString());
        return uRIParts.getURI();
    }

    private void setSelectedJob(JobData jobData) {
        this.selectedJobData = jobData;
        if (this.selectedJobData != null) {
            Widgets.setSelectedOptionMenuItem(this.widgetJobList, this.selectedJobData);
        } else {
            Widgets.clearSelectedOptionMenuItem(this.widgetJobList);
        }
        this.closeAllFileTree();
        this.clearIncludeList();
        this.clearExcludeList();
        this.clearSourceList();
        this.clearCompressExcludeList();
        this.clearScheduleTable();
        this.clearPersistenceTable();
        this.updateRootList();
        this.updateDevicesList();
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                TabJobs.this.selectJobEvent.trigger();
            }
        });
        this.getJobData();
    }

    private void clearSelectedJob() {
        this.selectedJobData = null;
        this.closeAllFileTree();
        this.clearIncludeList();
        this.clearExcludeList();
        this.clearSourceList();
        this.clearCompressExcludeList();
        this.clearScheduleTable();
        this.clearPersistenceTable();
        this.selectJobEvent.trigger();
    }

    private void jobClone() {
        assert (this.selectedJobData != null);
        this.jobClone(this.selectedJobData);
    }

    private void jobRename() {
        assert (this.selectedJobData != null);
        if (this.jobRename(this.selectedJobData)) {
            // empty if block
        }
    }

    private void jobDelete() {
        assert (this.selectedJobData != null);
        if (this.jobDelete(this.selectedJobData)) {
            this.selectedJobData = null;
            this.clearSelectedJob();
        }
    }

    private void updateRootList() {
        final ArrayList arrayList = new ArrayList();
        try {
            BARServer.executeCommand(StringParser.format("ROOT_LIST jobUUID=%s allMounts=no", this.selectedJobData != null ? this.selectedJobData.uuid : ""), 1, new Command.ResultHandler(){

                @Override
                public void handle(int n, ValueMap valueMap) {
                    String string = valueMap.getString("name");
                    arrayList.add(string);
                }
            });
        }
        catch (BARException bARException) {
            if (!this.shell.isDisposed()) {
                Dialogs.warning(this.shell, bARException.getCode() == 252 ? Dialogs.booleanFieldUpdater(Settings.class, "showSlaveDisconnected") : (BooleanFieldUpdater)null, BARControl.tr("Cannot get root list (error: {0})", bARException.getMessage()), new Object[0]);
            }
        }
        catch (IOException iOException) {
            if (!this.shell.isDisposed()) {
                Dialogs.warning(this.shell, BARControl.tr("Cannot get root list (error: {0})", iOException.getMessage()));
            }
        }
        catch (Exception exception) {
            Dialogs.error(this.shell, BARControl.tr("Cannot get root list (error: {0})", exception.getMessage()));
            BARControl.logThrowable(exception);
        }
        if (!this.widgetFileTree.isDisposed()) {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    FileTreeDataComparator fileTreeDataComparator = new FileTreeDataComparator(TabJobs.this.widgetFileTree);
                    HashSet<TreeItem> hashSet = Widgets.getTreeItems(TabJobs.this.widgetFileTree);
                    for (String string : arrayList) {
                        Image image = TabJobs.this.isIncluded(string) && !TabJobs.this.isExcluded(string) ? TabJobs.this.IMAGE_DIRECTORY_INCLUDED : (TabJobs.this.excludeHashSet.contains(string) ? TabJobs.this.IMAGE_DIRECTORY_EXCLUDED : TabJobs.this.IMAGE_DIRECTORY);
                        TreeItem treeItem = Widgets.updateInsertTreeItem(TabJobs.this.widgetFileTree, fileTreeDataComparator, new FileTreeData(string, BARServer.FileTypes.DIRECTORY, string, false, false), image, 2, string);
                        hashSet.remove(treeItem);
                    }
                    Widgets.removeTreeItems(hashSet);
                }
            });
        }
    }

    private void closeAllFileTree() {
        if (!this.widgetFileTree.isDisposed()) {
            for (TreeItem treeItem : this.widgetFileTree.getItems()) {
                treeItem.removeAll();
                new TreeItem(treeItem, 0);
            }
        }
        this.directoryInfoThread.clear();
    }

    private TreeItem findTreeItem(TreeItem[] treeItemArray, String string) {
        for (TreeItem treeItem : treeItemArray) {
            FileTreeData fileTreeData = (FileTreeData)treeItem.getData();
            if (fileTreeData == null || !fileTreeData.name.equals(string)) continue;
            return treeItem;
        }
        return null;
    }

    private void openAllIncludedDirectories() {
        block0: for (TableItem tableItem : this.widgetIncludeTable.getItems()) {
            EntryData entryData = (EntryData)tableItem.getData();
            TreeItem[] treeItemArray = this.widgetFileTree.getItems();
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : StringUtils.splitArray(entryData.pattern, BARServer.filePathSeparator, true)) {
                if (stringBuilder.length() == 0 || stringBuilder.charAt(stringBuilder.length() - 1) != BARServer.filePathSeparator) {
                    stringBuilder.append(BARServer.filePathSeparator);
                }
                stringBuilder.append(string);
                TreeItem treeItem = this.findTreeItem(treeItemArray, stringBuilder.toString());
                if (treeItem == null) continue block0;
                FileTreeData fileTreeData = (FileTreeData)treeItem.getData();
                if (fileTreeData.fileType != BARServer.FileTypes.DIRECTORY) continue;
                if (!treeItem.getExpanded()) {
                    Event event = new Event();
                    event.item = treeItem;
                    this.widgetFileTree.notifyListeners(17, event);
                    treeItem.setExpanded(true);
                }
                treeItemArray = treeItem.getItems();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFileTree(final TreeItem treeItem) {
        BARControl.waitCursor();
        try {
            final ArrayList arrayList = new ArrayList();
            BARServer.executeCommand(StringParser.format("FILE_LIST jobUUID=%s directory=%'S", this.selectedJobData.uuid != null ? this.selectedJobData.uuid : "", ((FileTreeData)treeItem.getData()).name), 0, new Command.ResultHandler(){

                @Override
                public void handle(int n, ValueMap valueMap) {
                    BARServer.FileTypes fileTypes = valueMap.getEnum("fileType", BARServer.FileTypes.class);
                    block0 : switch (fileTypes) {
                        case FILE: {
                            String string = valueMap.getString("name");
                            long l = valueMap.getLong("size", 0L);
                            long l2 = valueMap.getLong("dateTime", 0L);
                            boolean bl = valueMap.getBoolean("noDump", false);
                            arrayList.add(new FileTreeData(string, BARServer.FileTypes.FILE, l, l2, new File(string).getName(), false, bl));
                            break;
                        }
                        case DIRECTORY: {
                            String string = valueMap.getString("name");
                            long l = valueMap.getLong("dateTime", 0L);
                            boolean bl = valueMap.getBoolean("noBackup", false);
                            boolean bl2 = valueMap.getBoolean("noDump", false);
                            arrayList.add(new FileTreeData(string, BARServer.FileTypes.DIRECTORY, l, new File(string).getName(), bl, bl2));
                            break;
                        }
                        case LINK: {
                            String string = valueMap.getString("name");
                            long l = valueMap.getLong("dateTime", 0L);
                            boolean bl = valueMap.getBoolean("noDump", false);
                            arrayList.add(new FileTreeData(string, BARServer.FileTypes.LINK, l, new File(string).getName(), false, bl));
                            break;
                        }
                        case HARDLINK: {
                            String string = valueMap.getString("name");
                            long l = valueMap.getLong("size");
                            long l3 = valueMap.getLong("dateTime", 0L);
                            boolean bl = valueMap.getBoolean("noDump", false);
                            arrayList.add(new FileTreeData(string, BARServer.FileTypes.HARDLINK, l, l3, new File(string).getName(), false, bl));
                            break;
                        }
                        case SPECIAL: {
                            String string = valueMap.getString("name");
                            long l = valueMap.getLong("size", 0L);
                            long l4 = valueMap.getLong("dateTime", 0L);
                            boolean bl = valueMap.getBoolean("noBackup", false);
                            boolean bl3 = valueMap.getBoolean("noDump", false);
                            BARServer.SpecialTypes specialTypes = valueMap.getEnum("specialType", BARServer.SpecialTypes.class);
                            switch (specialTypes) {
                                case DEVICE_CHARACTER: {
                                    arrayList.add(new FileTreeData(string, BARServer.SpecialTypes.DEVICE_CHARACTER, l4, string, false, bl3));
                                    break block0;
                                }
                                case DEVICE_BLOCK: {
                                    arrayList.add(new FileTreeData(string, BARServer.SpecialTypes.DEVICE_BLOCK, l, l4, string, false, bl3));
                                    break block0;
                                }
                                case FIFO: {
                                    arrayList.add(new FileTreeData(string, BARServer.SpecialTypes.FIFO, l4, string, false, bl3));
                                    break block0;
                                }
                                case SOCKET: {
                                    arrayList.add(new FileTreeData(string, BARServer.SpecialTypes.SOCKET, l4, string, false, bl3));
                                    break block0;
                                }
                                case OTHER: {
                                    arrayList.add(new FileTreeData(string, BARServer.SpecialTypes.OTHER, l4, string, false, bl3));
                                }
                            }
                        }
                    }
                }
            });
            if (!treeItem.isDisposed()) {
                final FileTreeDataComparator fileTreeDataComparator = new FileTreeDataComparator(this.widgetFileTree);
                if (!treeItem.getExpanded()) {
                    treeItem.removeAll();
                }
                final HashSet<TreeItem> hashSet = Widgets.getSubTreeItems(treeItem);
                for (final FileTreeData fileTreeData : arrayList) {
                    block4 : switch (fileTreeData.fileType) {
                        case FILE: {
                            final Image image = this.isIncluded(fileTreeData.name) && !this.isExcluded(fileTreeData.name) ? this.IMAGE_FILE_INCLUDED : (this.isExcluded(fileTreeData.name) || fileTreeData.noDump ? this.IMAGE_FILE_EXCLUDED : this.IMAGE_FILE);
                            this.display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    TreeItem treeItem2 = Widgets.updateInsertTreeItem(treeItem, fileTreeDataComparator, fileTreeData, image, 0, fileTreeData.title, "FILE", Units.formatByteSize(fileTreeData.size), TabJobs.this.SIMPLE_DATE_FORMAT.format(new Date(fileTreeData.dateTime * 1000L)));
                                    hashSet.remove(treeItem2);
                                }
                            });
                            break;
                        }
                        case DIRECTORY: {
                            final Image image = this.isIncluded(fileTreeData.name) && !this.isExcluded(fileTreeData.name) ? this.IMAGE_DIRECTORY_INCLUDED : (this.isExcluded(fileTreeData.name) || fileTreeData.noBackup || fileTreeData.noDump ? this.IMAGE_DIRECTORY_EXCLUDED : this.IMAGE_DIRECTORY);
                            this.display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    TreeItem treeItem2 = Widgets.updateInsertTreeItem(treeItem, fileTreeDataComparator, fileTreeData, image, 2, fileTreeData.title, "DIR", null, TabJobs.this.SIMPLE_DATE_FORMAT.format(new Date(fileTreeData.dateTime * 1000L)));
                                    hashSet.remove(treeItem2);
                                    TabJobs.this.directoryInfoThread.add(((TabJobs)TabJobs.this).selectedJobData.uuid, fileTreeData.name, treeItem2);
                                }
                            });
                            break;
                        }
                        case LINK: {
                            final Image image = this.isIncluded(fileTreeData.name) && !this.isExcluded(fileTreeData.name) ? this.IMAGE_LINK_INCLUDED : (this.isExcluded(fileTreeData.name) || fileTreeData.noDump ? this.IMAGE_LINK_EXCLUDED : this.IMAGE_LINK);
                            this.display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    TreeItem treeItem2 = Widgets.updateInsertTreeItem(treeItem, fileTreeDataComparator, fileTreeData, image, 0, fileTreeData.title, "LINK", null, TabJobs.this.SIMPLE_DATE_FORMAT.format(new Date(fileTreeData.dateTime * 1000L)));
                                    hashSet.remove(treeItem2);
                                }
                            });
                            break;
                        }
                        case HARDLINK: {
                            final Image image = this.isIncluded(fileTreeData.name) && !this.isExcluded(fileTreeData.name) ? this.IMAGE_FILE_INCLUDED : (this.isExcluded(fileTreeData.name) || fileTreeData.noDump ? this.IMAGE_FILE_EXCLUDED : this.IMAGE_FILE);
                            this.display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    TreeItem treeItem2 = Widgets.updateInsertTreeItem(treeItem, fileTreeDataComparator, fileTreeData, image, 0, fileTreeData.title, "HARDLINK", Units.formatByteSize(fileTreeData.size), TabJobs.this.SIMPLE_DATE_FORMAT.format(new Date(fileTreeData.dateTime * 1000L)));
                                    hashSet.remove(treeItem2);
                                }
                            });
                            break;
                        }
                        case SPECIAL: {
                            final Image image = this.isIncluded(fileTreeData.name) && !this.isExcluded(fileTreeData.name) ? this.IMAGE_FILE_INCLUDED : (this.isExcluded(fileTreeData.name) || fileTreeData.noDump ? this.IMAGE_FILE_EXCLUDED : this.IMAGE_FILE);
                            switch (fileTreeData.specialType) {
                                case DEVICE_CHARACTER: {
                                    this.display.syncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            TreeItem treeItem2 = Widgets.updateInsertTreeItem(treeItem, fileTreeDataComparator, fileTreeData, image, 0, fileTreeData.title, "CHARACTER DEVICE", TabJobs.this.SIMPLE_DATE_FORMAT.format(new Date(fileTreeData.dateTime * 1000L)));
                                            hashSet.remove(treeItem2);
                                        }
                                    });
                                    break block4;
                                }
                                case DEVICE_BLOCK: {
                                    this.display.syncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            TreeItem treeItem2 = Widgets.updateInsertTreeItem(treeItem, fileTreeDataComparator, fileTreeData, image, 0, fileTreeData.title, "BLOCK DEVICE", fileTreeData.size > 0L ? Units.formatByteSize(fileTreeData.size) : null, TabJobs.this.SIMPLE_DATE_FORMAT.format(new Date(fileTreeData.dateTime * 1000L)));
                                        }
                                    });
                                    break block4;
                                }
                                case FIFO: {
                                    this.display.syncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            TreeItem treeItem2 = Widgets.updateInsertTreeItem(treeItem, fileTreeDataComparator, fileTreeData, image, 0, fileTreeData.title, "FIFO", null, TabJobs.this.SIMPLE_DATE_FORMAT.format(new Date(fileTreeData.dateTime * 1000L)));
                                            hashSet.remove(treeItem2);
                                        }
                                    });
                                    break block4;
                                }
                                case SOCKET: {
                                    this.display.syncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            TreeItem treeItem2 = Widgets.updateInsertTreeItem(treeItem, fileTreeDataComparator, fileTreeData, image, 0, fileTreeData.title, "SOCKET", TabJobs.this.SIMPLE_DATE_FORMAT.format(new Date(fileTreeData.dateTime * 1000L)));
                                            hashSet.remove(treeItem2);
                                        }
                                    });
                                    break block4;
                                }
                                case OTHER: {
                                    this.display.syncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            TreeItem treeItem2 = Widgets.updateInsertTreeItem(treeItem, fileTreeDataComparator, fileTreeData, image, 0, fileTreeData.title, "SPECIAL", TabJobs.this.SIMPLE_DATE_FORMAT.format(new Date(fileTreeData.dateTime * 1000L)));
                                            hashSet.remove(treeItem2);
                                        }
                                    });
                                }
                            }
                        }
                    }
                }
                Widgets.removeTreeItems(hashSet);
            }
        }
        catch (BARException bARException) {
            if (!this.shell.isDisposed()) {
                Dialogs.warning(this.shell, bARException.getCode() == 252 ? Dialogs.booleanFieldUpdater(Settings.class, "showSlaveDisconnected") : (BooleanFieldUpdater)null, BARControl.tr("Cannot get file list (error: {0})", bARException.getMessage()), new Object[0]);
            }
        }
        catch (IOException iOException) {
            if (!this.shell.isDisposed()) {
                Dialogs.warning(this.shell, BARControl.tr("Cannot get file list (error: {0})", iOException.getMessage()));
            }
        }
        catch (Exception exception) {
            Dialogs.error(this.shell, BARControl.tr("Cannot get file list (error: {0})", exception.getMessage()));
            BARControl.logThrowable(exception);
        }
        finally {
            BARControl.resetCursor();
        }
    }

    private void updateFileTreeImages(TreeItem treeItem) {
        FileTreeData fileTreeData = (FileTreeData)treeItem.getData();
        Image image = null;
        if (this.isIncluded(fileTreeData.name) && !this.isExcluded(fileTreeData.name)) {
            switch (fileTreeData.fileType) {
                case FILE: {
                    image = this.IMAGE_FILE_INCLUDED;
                    break;
                }
                case DIRECTORY: {
                    image = this.IMAGE_DIRECTORY_INCLUDED;
                    break;
                }
                case LINK: {
                    image = this.IMAGE_LINK_INCLUDED;
                    break;
                }
                case HARDLINK: {
                    image = this.IMAGE_LINK_INCLUDED;
                    break;
                }
                case SPECIAL: {
                    image = this.IMAGE_FILE_INCLUDED;
                }
            }
        } else if (this.isExcluded(fileTreeData.name) || fileTreeData.noBackup || fileTreeData.noDump) {
            switch (fileTreeData.fileType) {
                case FILE: {
                    image = this.IMAGE_FILE_EXCLUDED;
                    break;
                }
                case DIRECTORY: {
                    image = this.IMAGE_DIRECTORY_EXCLUDED;
                    break;
                }
                case LINK: {
                    image = this.IMAGE_LINK_EXCLUDED;
                    break;
                }
                case HARDLINK: {
                    image = this.IMAGE_LINK_EXCLUDED;
                    break;
                }
                case SPECIAL: {
                    image = this.IMAGE_FILE_EXCLUDED;
                }
            }
        } else {
            block14 : switch (fileTreeData.fileType) {
                case FILE: {
                    image = this.IMAGE_FILE;
                    break;
                }
                case DIRECTORY: {
                    image = this.IMAGE_DIRECTORY;
                    break;
                }
                case LINK: {
                    image = this.IMAGE_LINK;
                    break;
                }
                case HARDLINK: {
                    image = this.IMAGE_LINK;
                    break;
                }
                case SPECIAL: {
                    switch (fileTreeData.specialType) {
                        case DEVICE_CHARACTER: {
                            image = this.IMAGE_FILE;
                            break block14;
                        }
                        case DEVICE_BLOCK: {
                            image = this.IMAGE_FILE;
                            break block14;
                        }
                        case FIFO: {
                            image = this.IMAGE_FILE;
                            break block14;
                        }
                        case SOCKET: {
                            image = this.IMAGE_FILE;
                            break block14;
                        }
                        case OTHER: {
                            image = this.IMAGE_FILE;
                        }
                    }
                }
            }
        }
        treeItem.setImage(image);
        if (treeItem.getExpanded()) {
            for (TreeItem treeItem2 : treeItem.getItems()) {
                this.updateFileTreeImages(treeItem2);
            }
        }
    }

    private void updateFileTreeImages() {
        if (!this.widgetFileTree.isDisposed()) {
            for (TreeItem treeItem : this.widgetFileTree.getItems()) {
                this.updateFileTreeImages(treeItem);
            }
        }
    }

    private void updateDevicesList() {
        final ArrayList arrayList = new ArrayList();
        try {
            if (!this.widgetDeviceTable.isDisposed()) {
                BARServer.executeCommand(StringParser.format("DEVICE_LIST jobUUID=%s", this.selectedJobData != null ? this.selectedJobData.uuid : ""), 1, new Command.ResultHandler(){

                    @Override
                    public void handle(int n, ValueMap valueMap) {
                        String string = valueMap.getString("name");
                        long l = valueMap.getLong("size", 0L);
                        String string2 = valueMap.getString("fileSystemType", "");
                        boolean bl = valueMap.getBoolean("mounted");
                        arrayList.add(new DeviceData(string, l, string2));
                    }
                });
            }
        }
        catch (BARException bARException) {
            if (!this.shell.isDisposed()) {
                Dialogs.warning(this.shell, bARException.getCode() == 252 ? Dialogs.booleanFieldUpdater(Settings.class, "showSlaveDisconnected") : (BooleanFieldUpdater)null, BARControl.tr("Cannot get device list (error: {0})", bARException.getMessage()), new Object[0]);
            }
        }
        catch (IOException iOException) {
            if (!this.shell.isDisposed()) {
                Dialogs.warning(this.shell, BARControl.tr("Cannot get device list (error: {0})", iOException.getMessage()));
            }
        }
        catch (Exception exception) {
            Dialogs.error(this.shell, BARControl.tr("Cannot get device list (error: {0})", exception.getMessage()));
            BARControl.logThrowable(exception);
        }
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!TabJobs.this.widgetDeviceTable.isDisposed()) {
                    DeviceDataComparator deviceDataComparator = new DeviceDataComparator(TabJobs.this.widgetDeviceTable);
                    HashSet<TableItem> hashSet = Widgets.getAllTableItems(TabJobs.this.widgetDeviceTable);
                    for (DeviceData deviceData : arrayList) {
                        TableItem tableItem = Widgets.updateInsertTableItem(TabJobs.this.widgetDeviceTable, deviceDataComparator, deviceData, TabJobs.this.IMAGE_DEVICE, deviceData.name, deviceData.fileSystemType, Units.formatByteSize(deviceData.size));
                        hashSet.remove(tableItem);
                    }
                    Widgets.removeTableItems(hashSet);
                }
            }
        });
    }

    private void updateDeviceImages() {
        if (!this.widgetDeviceTable.isDisposed()) {
            for (TableItem tableItem : this.widgetDeviceTable.getItems()) {
                DeviceData deviceData = (DeviceData)tableItem.getData();
                Image image = this.isIncluded(deviceData.name) && !this.isExcluded(deviceData.name) ? this.IMAGE_DEVICE_INCLUDED : (this.isExcluded(deviceData.name) ? this.IMAGE_DEVICE : this.IMAGE_DEVICE);
                tableItem.setImage(image);
            }
        }
    }

    private void clearIncludeList() {
        if (!this.widgetIncludeTable.isDisposed()) {
            Widgets.removeAllTableItems(this.widgetIncludeTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIncludeList(JobData jobData) {
        final EntryDataComparator entryDataComparator = new EntryDataComparator(this.widgetIncludeTable);
        HashMap<String, EntryData> hashMap = this.includeHashMap;
        synchronized (hashMap) {
            this.includeHashMap.clear();
            try {
                BARServer.executeCommand(StringParser.format("INCLUDE_LIST jobUUID=%s", jobData.uuid), 0, new Command.ResultHandler(){

                    @Override
                    public void handle(int n, ValueMap valueMap) {
                        EntryStoreTypes entryStoreTypes = valueMap.getEnum("entryStoreType", EntryStoreTypes.class);
                        PatternTypes patternTypes = valueMap.getEnum("patternType", PatternTypes.class);
                        String string = valueMap.getString("pattern");
                        if (!string.isEmpty()) {
                            TabJobs.this.includeHashMap.put(string, new EntryData(entryStoreTypes, string));
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!TabJobs.this.widgetIncludeTable.isDisposed()) {
                        Widgets.removeAllTableItems(TabJobs.this.widgetIncludeTable);
                        for (EntryData entryData : TabJobs.this.includeHashMap.values()) {
                            Widgets.insertTableItem(TabJobs.this.widgetIncludeTable, entryDataComparator, entryData, entryData.getImage(), entryData.pattern);
                        }
                    }
                }
            });
        }
    }

    private boolean includeEdit(final EntryData entryData, String string, String string2) {
        final Shell shell = Dialogs.openModal(this.shell, string, 300, 70, new double[]{1.0, 0.0}, 1.0);
        Composite composite = Widgets.newComposite((Composite)shell, 0, 4);
        composite.setLayout(new TableLayout(null, new double[]{0.0, 1.0}, 4));
        Widgets.layout((Control)composite, 0, 0, 12, 0, 0, 2);
        Label label = Widgets.newLabel(composite, BARControl.tr("Pattern", new Object[0]) + ":");
        Widgets.layout(label, 0, 0, 4);
        Composite composite2 = Widgets.newComposite(composite);
        composite2.setLayout(new TableLayout(0.0, new double[]{1.0, 0.0}));
        Widgets.layout(composite2, 0, 1, 12);
        final Text text = Widgets.newText(composite2);
        text.setToolTipText(BARControl.tr("Include pattern. Use * and ? as wildcards.", new Object[0]));
        if (entryData.pattern != null) {
            text.setText(entryData.pattern);
        }
        Widgets.layout(text, 0, 0, 12);
        Button button = Widgets.newButton(composite2, this.IMAGE_DIRECTORY);
        button.setToolTipText(BARControl.tr("Select remote path. CTRL+click to select local path.", new Object[0]));
        Widgets.layout(button, 0, 1, 0);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = Dialogs.file(TabJobs.this.shell, Dialogs.FileDialogTypes.ENTRY, BARControl.tr("Select entry", new Object[0]), text.getText(), new String[]{BARControl.tr("All files", new Object[0]), BARControl.ALL_FILE_EXTENSION}, "*", 0, (selectionEvent.stateMask & 0x40000) == 0 ? BARServer.remoteListDirectory(((TabJobs)TabJobs.this).selectedJobData.uuid) : BARControl.listDirectory);
                if (string != null) {
                    text.setText(string.trim());
                }
            }
        });
        label = Widgets.newLabel(composite, BARControl.tr("Type", new Object[0]) + ":", Settings.hasExpertRole());
        Widgets.layout(label, 1, 0, 4);
        composite2 = Widgets.newComposite(composite, Settings.hasExpertRole());
        composite2.setLayout(new TableLayout(0.0, 0.0));
        Widgets.layout(composite2, 1, 1, 12);
        button = Widgets.newRadio(composite2, BARControl.tr("file", new Object[0]));
        button.setSelection(entryData.entryStoreType == EntryStoreTypes.FILE);
        Widgets.layout(button, 0, 0, 4);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                entryData.entryStoreType = EntryStoreTypes.FILE;
            }
        });
        button = Widgets.newRadio(composite2, BARControl.tr("image", new Object[0]));
        button.setSelection(entryData.entryStoreType == EntryStoreTypes.IMAGE);
        Widgets.layout(button, 0, 1, 4);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                entryData.entryStoreType = EntryStoreTypes.IMAGE;
            }
        });
        composite = Widgets.newComposite((Composite)shell, 0, 4);
        composite.setLayout(new TableLayout(0.0, 1.0));
        Widgets.layout((Control)composite, 1, 0, 12, 0, 0, 2);
        final Button button2 = Widgets.newButton(composite, string2);
        if (entryData.pattern != null) {
            button2.setEnabled(!entryData.pattern.isEmpty());
        }
        Widgets.layout(button2, 0, 0, 4, 0, 0, 0, 0, 100, -1);
        button2.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                entryData.pattern = text.getText().trim();
                Dialogs.close(shell, true);
            }
        });
        button = Widgets.newButton(composite, BARControl.tr("Cancel", new Object[0]));
        Widgets.layout(button, 0, 1, 8, 0, 0, 0, 0, 100, -1);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Dialogs.close(shell, false);
            }
        });
        text.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                Text text = (Text)modifyEvent.widget;
                String string = text.getText().trim();
                button2.setEnabled(!string.isEmpty());
            }
        });
        text.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                button2.forceFocus();
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                throw new Error("NYI");
            }
        });
        return (Boolean)Dialogs.run(shell, false) != false && (entryData.pattern == null || !entryData.pattern.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void includeListAdd(EntryData entryData) {
        EntryDataComparator entryDataComparator = new EntryDataComparator(this.widgetIncludeTable);
        assert (this.selectedJobData != null);
        try {
            BARServer.executeCommand(StringParser.format("INCLUDE_LIST_ADD jobUUID=%s entryStoreType=%s patternType=%s pattern=%'S", this.selectedJobData.uuid, entryData.entryStoreType.toString(), "GLOB", entryData.pattern), 0);
        }
        catch (Exception exception) {
            Dialogs.error(this.shell, BARControl.tr("Cannot add include entry:\n\n{0}", exception.getMessage()));
            BARControl.logThrowable(exception);
            return;
        }
        HashMap<String, EntryData> hashMap = this.includeHashMap;
        synchronized (hashMap) {
            this.includeHashMap.put(entryData.pattern, entryData);
            Widgets.updateInsertTableItem(this.widgetIncludeTable, entryDataComparator, entryData, entryData.getImage(), entryData.pattern);
        }
        this.updateFileTreeImages();
        this.updateDeviceImages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void includeListRemove(String[] stringArray) {
        final EntryDataComparator entryDataComparator = new EntryDataComparator(this.widgetIncludeTable);
        assert (this.selectedJobData != null);
        HashMap<String, EntryData> hashMap = this.includeHashMap;
        synchronized (hashMap) {
            for (String string : stringArray) {
                this.includeHashMap.remove(string);
            }
            try {
                BARServer.executeCommand(StringParser.format("INCLUDE_LIST_CLEAR jobUUID=%s", this.selectedJobData.uuid), 0);
                for (EntryData entryData : this.includeHashMap.values()) {
                    BARServer.executeCommand(StringParser.format("INCLUDE_LIST_ADD jobUUID=%s entryStoreType=%s patternType=%s pattern=%'S", this.selectedJobData.uuid, entryData.entryStoreType.toString(), "GLOB", entryData.pattern), 0);
                }
            }
            catch (Exception exception) {
                Dialogs.error(this.shell, BARControl.tr("Cannot remove include entry:\n\n{0}", exception.getMessage()));
                BARControl.logThrowable(exception);
                return;
            }
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!TabJobs.this.widgetIncludeTable.isDisposed()) {
                        Widgets.removeAllTableItems(TabJobs.this.widgetIncludeTable);
                        for (EntryData entryData : TabJobs.this.includeHashMap.values()) {
                            Widgets.insertTableItem(TabJobs.this.widgetIncludeTable, entryDataComparator, entryData, entryData.getImage(), entryData.pattern);
                        }
                    }
                }
            });
        }
        this.updateFileTreeImages();
        this.updateDeviceImages();
    }

    private void includeListRemove(String string) {
        this.includeListRemove(new String[]{string});
    }

    private void includeListAdd() {
        EntryData entryData;
        if (this.selectedJobData != null && this.includeEdit(entryData = new EntryData(EntryStoreTypes.FILE), BARControl.tr("Add new include pattern", new Object[0]), BARControl.tr("Add", new Object[0]))) {
            this.includeListAdd(entryData);
        }
    }

    private void includeListEdit() {
        EntryData entryData;
        EntryData entryData2;
        TableItem[] tableItemArray;
        if (this.selectedJobData != null && (tableItemArray = this.widgetIncludeTable.getSelection()).length > 0 && this.includeEdit(entryData2 = (entryData = (EntryData)tableItemArray[0].getData()).clone(), BARControl.tr("Edit include pattern", new Object[0]), BARControl.tr("Save", new Object[0]))) {
            this.includeListRemove(new String[]{entryData.pattern, entryData2.pattern});
            this.includeListAdd(entryData2);
            this.updateFileTreeImages();
            this.updateDeviceImages();
        }
    }

    private void includeListClone() {
        EntryData entryData;
        TableItem[] tableItemArray;
        if (this.selectedJobData != null && (tableItemArray = this.widgetIncludeTable.getSelection()).length > 0 && this.includeEdit(entryData = ((EntryData)tableItemArray[0].getData()).clone(), BARControl.tr("Clone include pattern", new Object[0]), BARControl.tr("Add", new Object[0]))) {
            this.includeListRemove(entryData.pattern);
            this.includeListAdd(entryData);
            this.updateFileTreeImages();
            this.updateDeviceImages();
        }
    }

    private void includeListRemove() {
        if (this.selectedJobData != null) {
            ArrayList<EntryData> arrayList = new ArrayList<EntryData>();
            for (TableItem tableItem : this.widgetIncludeTable.getSelection()) {
                arrayList.add((EntryData)tableItem.getData());
            }
            if (arrayList.size() > 0 && (arrayList.size() == 1 || Dialogs.confirm(this.shell, BARControl.tr("Remove {0} include {0,choice,0#patterns|1#pattern|1<patterns}?", arrayList.size())))) {
                for (EntryData entryData : arrayList) {
                    this.includeListRemove(entryData.pattern);
                }
            }
        }
    }

    private void clearExcludeList() {
        if (!this.widgetExcludeList.isDisposed()) {
            Widgets.removeAllListItems(this.widgetExcludeList);
        }
    }

    private void updateExcludeList(JobData jobData) {
        this.excludeHashSet.clear();
        final ArrayList arrayList = new ArrayList();
        try {
            BARServer.executeCommand(StringParser.format("EXCLUDE_LIST jobUUID=%s", jobData.uuid), 0, new Command.ResultHandler(){

                @Override
                public void handle(int n, ValueMap valueMap) {
                    PatternTypes patternTypes = valueMap.getEnum("patternType", PatternTypes.class);
                    String string = valueMap.getString("pattern");
                    if (!string.isEmpty()) {
                        arrayList.add(new PatternData(patternTypes, string));
                        TabJobs.this.excludeHashSet.add(string);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!TabJobs.this.widgetExcludeList.isDisposed()) {
                    Widgets.removeAllListItems(TabJobs.this.widgetExcludeList);
                    for (PatternData patternData : arrayList) {
                        Widgets.insertListItem(TabJobs.this.widgetExcludeList, Widgets.getListItemIndex(TabJobs.this.widgetExcludeList, String.CASE_INSENSITIVE_ORDER, patternData.pattern), patternData.pattern, patternData.pattern);
                    }
                }
            }
        });
    }

    private boolean excludeEdit(final String[] stringArray, String string, String string2) {
        assert (this.selectedJobData != null);
        final Shell shell = Dialogs.openModal(this.shell, string, 300, 70, new double[]{1.0, 0.0}, 1.0);
        Composite composite = Widgets.newComposite((Composite)shell, 0, 4);
        composite.setLayout(new TableLayout(null, new double[]{0.0, 1.0, 0.0}, 4));
        Widgets.layout((Control)composite, 0, 0, 12, 0, 0, 2);
        Label label = Widgets.newLabel(composite, BARControl.tr("Pattern", new Object[0]) + ":");
        Widgets.layout(label, 0, 0, 4);
        final Text text = Widgets.newText(composite);
        text.setToolTipText(BARControl.tr("Exclude pattern. Use * and ? as wildcards.", new Object[0]));
        if (stringArray[0] != null) {
            text.setText(stringArray[0]);
        }
        Widgets.layout(text, 0, 1, 12);
        Button button = Widgets.newButton(composite, this.IMAGE_DIRECTORY);
        button.setToolTipText(BARControl.tr("Select remote path. CTRL+click to select local path.", new Object[0]));
        Widgets.layout(button, 0, 2, 0);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = Dialogs.file(TabJobs.this.shell, Dialogs.FileDialogTypes.ENTRY, BARControl.tr("Select entry", new Object[0]), text.getText(), new String[]{BARControl.tr("All files", new Object[0]), BARControl.ALL_FILE_EXTENSION}, "*", 0, (selectionEvent.stateMask & 0x40000) == 0 ? BARServer.remoteListDirectory(((TabJobs)TabJobs.this).selectedJobData.uuid) : BARControl.listDirectory);
                if (string != null) {
                    text.setText(string.trim());
                }
            }
        });
        composite = Widgets.newComposite((Composite)shell, 0, 4);
        composite.setLayout(new TableLayout(0.0, 1.0));
        Widgets.layout((Control)composite, 1, 0, 12, 0, 0, 2);
        final Button button2 = Widgets.newButton(composite, string2);
        button2.setEnabled(stringArray[0] != null && !stringArray[0].isEmpty());
        Widgets.layout(button2, 0, 0, 4, 0, 0, 0, 0, 100, -1);
        button2.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                stringArray[0] = text.getText().trim();
                Dialogs.close(shell, true);
            }
        });
        button = Widgets.newButton(composite, BARControl.tr("Cancel", new Object[0]));
        Widgets.layout(button, 0, 1, 8, 0, 0, 0, 0, 100, -1);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Dialogs.close(shell, false);
            }
        });
        text.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                Text text = (Text)modifyEvent.widget;
                String string = text.getText().trim();
                button2.setEnabled(!string.isEmpty());
            }
        });
        text.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                button2.forceFocus();
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                throw new Error("NYI");
            }
        });
        return (Boolean)Dialogs.run(shell, false) != false && !stringArray[0].isEmpty();
    }

    private void excludeListAdd(String string) {
        assert (this.selectedJobData != null);
        try {
            BARServer.executeCommand(StringParser.format("EXCLUDE_LIST_ADD jobUUID=%s patternType=%s pattern=%'S", this.selectedJobData.uuid, "GLOB", string), 0);
        }
        catch (Exception exception) {
            Dialogs.error(this.shell, BARControl.tr("Cannot add exclude entry:\n\n{0}", exception.getMessage()));
            BARControl.logThrowable(exception);
            return;
        }
        this.excludeHashSet.add(string);
        Widgets.updateInsertListItem(this.widgetExcludeList, String.CASE_INSENSITIVE_ORDER, string, string);
        this.updateFileTreeImages();
        this.updateDeviceImages();
    }

    private void excludeListRemove(String[] stringArray) {
        assert (this.selectedJobData != null);
        for (String string : stringArray) {
            this.excludeHashSet.remove(string);
        }
        try {
            BARServer.executeCommand(StringParser.format("EXCLUDE_LIST_CLEAR jobUUID=%s", this.selectedJobData.uuid), 0);
            Widgets.removeAllListItems(this.widgetExcludeList);
            for (String string : this.excludeHashSet) {
                BARServer.executeCommand(StringParser.format("EXCLUDE_LIST_ADD jobUUID=%s patternType=%s pattern=%'S", this.selectedJobData.uuid, "GLOB", string), 0);
                Widgets.insertListItem(this.widgetExcludeList, Widgets.getListItemIndex(this.widgetExcludeList, String.CASE_INSENSITIVE_ORDER, string), string, string);
            }
        }
        catch (Exception exception) {
            Dialogs.error(this.shell, BARControl.tr("Cannot remove exclude entry:\n\n{0}", exception.getMessage()));
            BARControl.logThrowable(exception);
            return;
        }
        this.updateFileTreeImages();
        this.updateDeviceImages();
    }

    private void excludeListRemove(String string) {
        this.excludeListRemove(new String[]{string});
    }

    private void excludeListAdd() {
        String[] stringArray;
        if (this.selectedJobData != null && this.excludeEdit(stringArray = new String[1], BARControl.tr("Add new exclude pattern", new Object[0]), BARControl.tr("Add", new Object[0]))) {
            this.excludeListAdd(stringArray[0]);
        }
    }

    private void excludeListEdit() {
        String string;
        String[] stringArray;
        String[] stringArray2;
        if (this.selectedJobData != null && (stringArray2 = this.widgetExcludeList.getSelection()).length > 0 && this.excludeEdit(stringArray = new String[]{new String(string = stringArray2[0])}, BARControl.tr("Edit exclude pattern", new Object[0]), BARControl.tr("Save", new Object[0]))) {
            this.excludeListRemove(new String[]{string, stringArray[0]});
            this.excludeListAdd(stringArray[0]);
            this.updateFileTreeImages();
            this.updateDeviceImages();
        }
    }

    private void excludeListClone() {
        String[] stringArray;
        String[] stringArray2;
        if (this.selectedJobData != null && (stringArray2 = this.widgetExcludeList.getSelection()).length > 0 && this.excludeEdit(stringArray = new String[]{new String(stringArray2[0])}, BARControl.tr("Clone exclude pattern", new Object[0]), BARControl.tr("Add", new Object[0]))) {
            this.excludeListRemove(new String[]{stringArray[0]});
            this.excludeListAdd(stringArray[0]);
            this.updateFileTreeImages();
            this.updateDeviceImages();
        }
    }

    private void excludeListRemove() {
        String[] stringArray;
        if (this.selectedJobData != null && (stringArray = this.widgetExcludeList.getSelection()).length > 0 && (stringArray.length == 1 || Dialogs.confirm(this.shell, BARControl.tr("Remove {0} exclude {0,choice,0#patterns|1#pattern|1<patterns}?", stringArray.length)))) {
            this.excludeListRemove(stringArray);
        }
    }

    private void clearCompressExcludeList() {
        if (!this.widgetCompressExcludeList.isDisposed()) {
            Widgets.removeAllListItems(this.widgetCompressExcludeList);
        }
    }

    private void updateCompressExcludeList(JobData jobData) {
        this.compressExcludeHashSet.clear();
        final ArrayList arrayList = new ArrayList();
        try {
            BARServer.executeCommand(StringParser.format("EXCLUDE_COMPRESS_LIST jobUUID=%s", jobData.uuid), 0, new Command.ResultHandler(){

                @Override
                public void handle(int n, ValueMap valueMap) {
                    PatternTypes patternTypes = valueMap.getEnum("patternType", PatternTypes.class);
                    String string = valueMap.getString("pattern");
                    if (!string.isEmpty()) {
                        arrayList.add(new PatternData(patternTypes, string));
                        TabJobs.this.compressExcludeHashSet.add(string);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!TabJobs.this.widgetCompressExcludeList.isDisposed()) {
                    Widgets.removeAllListItems(TabJobs.this.widgetCompressExcludeList);
                    for (PatternData patternData : arrayList) {
                        Widgets.insertListItem(TabJobs.this.widgetCompressExcludeList, Widgets.getListItemIndex(TabJobs.this.widgetCompressExcludeList, String.CASE_INSENSITIVE_ORDER, patternData.pattern), patternData.pattern, patternData.pattern);
                    }
                }
            }
        });
    }

    private void updateMountList(JobData jobData) {
        final ArrayList arrayList = new ArrayList();
        try {
            BARServer.executeCommand(StringParser.format("MOUNT_LIST jobUUID=%s", jobData.uuid), 0, new Command.ResultHandler(){

                @Override
                public void handle(int n, ValueMap valueMap) {
                    int n2 = valueMap.getInt("id");
                    String string = valueMap.getString("name");
                    String string2 = valueMap.getString("device", null);
                    if (!string.isEmpty()) {
                        arrayList.add(new MountData(n2, string, string2));
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!TabJobs.this.widgetMountTable.isDisposed()) {
                    MountDataComparator mountDataComparator = new MountDataComparator(TabJobs.this.widgetMountTable);
                    HashSet<TableItem> hashSet = Widgets.getAllTableItems(TabJobs.this.widgetMountTable);
                    for (MountData mountData : arrayList) {
                        TableItem tableItem = Widgets.updateInsertTableItem(TabJobs.this.widgetMountTable, mountDataComparator, mountData, mountData.name, mountData.device != null ? mountData.device : "");
                        hashSet.remove(tableItem);
                    }
                    Widgets.removeTableItems(hashSet);
                }
            }
        });
    }

    private boolean mountEdit(final MountData mountData, String string, String string2) {
        assert (this.selectedJobData != null);
        final Shell shell = Dialogs.openModal(this.shell, string, 300, 70, new double[]{1.0, 0.0}, 1.0);
        Composite composite = Widgets.newComposite((Composite)shell, 0, 4);
        composite.setLayout(new TableLayout(null, new double[]{0.0, 1.0}, 4));
        Widgets.layout((Control)composite, 0, 0, 12, 0, 0, 2);
        Label label = Widgets.newLabel(composite, BARControl.tr("Name", new Object[0]) + ":");
        Widgets.layout(label, 0, 0, 4);
        Composite composite2 = Widgets.newComposite(composite);
        composite2.setLayout(new TableLayout(0.0, new double[]{1.0, 0.0}));
        Widgets.layout(composite2, 0, 1, 12);
        final Text text = Widgets.newText(composite2);
        text.setToolTipText(BARControl.tr("Mount name.", new Object[0]));
        if (mountData.name != null) {
            text.setText(mountData.name);
        }
        Widgets.layout(text, 0, 0, 12);
        Button button = Widgets.newButton(composite2, this.IMAGE_DIRECTORY);
        button.setToolTipText(BARControl.tr("Select remote path. CTRL+click to select local path.", new Object[0]));
        Widgets.layout(button, 0, 1, 0);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = Dialogs.file(TabJobs.this.shell, Dialogs.FileDialogTypes.DIRECTORY, BARControl.tr("Select name", new Object[0]), text.getText(), (selectionEvent.stateMask & 0x40000) == 0 ? BARServer.remoteListDirectory(((TabJobs)TabJobs.this).selectedJobData.uuid) : BARControl.listDirectory);
                if (string != null) {
                    text.setText(string.trim());
                }
            }
        });
        label = Widgets.newLabel(composite, BARControl.tr("Device", new Object[0]) + ":");
        Widgets.layout(label, 1, 0, 4);
        composite2 = Widgets.newComposite(composite);
        composite2.setLayout(new TableLayout(0.0, new double[]{1.0, 0.0}));
        Widgets.layout(composite2, 1, 1, 12);
        final Text text2 = Widgets.newText(composite2);
        text2.setToolTipText(BARControl.tr("Mount device (optional).", new Object[0]));
        if (mountData.device != null) {
            text2.setText(mountData.device);
        }
        Widgets.layout(text2, 0, 0, 12);
        button = Widgets.newButton(composite2, this.IMAGE_DIRECTORY);
        button.setToolTipText(BARControl.tr("Select remote path. CTRL+click to select local path.", new Object[0]));
        Widgets.layout(button, 0, 1, 0);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = Dialogs.file(TabJobs.this.shell, Dialogs.FileDialogTypes.OPEN, BARControl.tr("Select device", new Object[0]), text2.getText(), (selectionEvent.stateMask & 0x40000) == 0 ? BARServer.remoteListDirectory(((TabJobs)TabJobs.this).selectedJobData.uuid) : BARControl.listDirectory);
                if (string != null) {
                    text2.setText(string.trim());
                }
            }
        });
        composite = Widgets.newComposite((Composite)shell, 0, 4);
        composite.setLayout(new TableLayout(0.0, 1.0));
        Widgets.layout((Control)composite, 1, 0, 12, 0, 0, 2);
        final Button button2 = Widgets.newButton(composite, string2);
        button2.setEnabled(mountData.name != null && !mountData.name.isEmpty());
        Widgets.layout(button2, 0, 0, 4, 0, 0, 0, 0, 100, -1);
        button2.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                mountData.name = text.getText().trim();
                mountData.device = text2.getText().trim();
                Dialogs.close(shell, true);
            }
        });
        button = Widgets.newButton(composite, BARControl.tr("Cancel", new Object[0]));
        Widgets.layout(button, 0, 1, 8, 0, 0, 0, 0, 100, -1);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Dialogs.close(shell, false);
            }
        });
        text.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                Text text = (Text)modifyEvent.widget;
                String string = text.getText().trim();
                button2.setEnabled(!string.isEmpty());
            }
        });
        text.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                button2.forceFocus();
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                throw new Error("NYI");
            }
        });
        return (Boolean)Dialogs.run(shell, false) != false && !mountData.name.isEmpty();
    }

    private void mountListAdd(MountData mountData) {
        TableItem[] tableItemArray;
        MountDataComparator mountDataComparator = new MountDataComparator(this.widgetMountTable);
        assert (this.selectedJobData != null);
        try {
            tableItemArray = new ValueMap();
            BARServer.executeCommand(StringParser.format("MOUNT_LIST_ADD jobUUID=%s name=%'S device=%'S", this.selectedJobData.uuid, mountData.name, mountData.device), 0, (ValueMap)tableItemArray);
            mountData.id = tableItemArray.getInt("id");
        }
        catch (Exception exception) {
            Dialogs.error(this.shell, BARControl.tr("Cannot add mount data:\n\n{0}", exception.getMessage()));
            BARControl.logThrowable(exception);
            return;
        }
        Widgets.updateInsertTableItem(this.widgetMountTable, mountDataComparator, mountData, mountData.name, mountData.device != null ? mountData.device : "");
        for (TableItem tableItem : tableItemArray = this.widgetMountTable.getItems()) {
            MountData mountData2 = (MountData)tableItem.getData();
            if (mountData2 == mountData || !mountData2.name.equals(mountData.name)) continue;
            Widgets.removeTableItem(this.widgetMountTable, mountData2);
        }
    }

    private void mountListUpdate(MountData mountData) {
        TableItem[] tableItemArray;
        MountDataComparator mountDataComparator = new MountDataComparator(this.widgetMountTable);
        assert (this.selectedJobData != null);
        try {
            BARServer.executeCommand(StringParser.format("MOUNT_LIST_UPDATE jobUUID=%s id=%d name=%'S device=%'S", this.selectedJobData.uuid, mountData.id, mountData.name, mountData.device), 0);
        }
        catch (Exception exception) {
            Dialogs.error(this.shell, BARControl.tr("Cannot update mount data:\n\n{0}", exception.getMessage()));
            BARControl.logThrowable(exception);
            return;
        }
        Widgets.updateInsertTableItem(this.widgetMountTable, mountDataComparator, mountData, mountData.name, mountData.device != null ? mountData.device : "");
        for (TableItem tableItem : tableItemArray = this.widgetMountTable.getItems()) {
            MountData mountData2 = (MountData)tableItem.getData();
            if (mountData2 == mountData || !mountData2.name.equals(mountData.name)) continue;
            Widgets.removeTableItem(this.widgetMountTable, mountData2);
        }
    }

    private void mountListRemove(MountData mountData) {
        assert (this.selectedJobData != null);
        try {
            BARServer.executeCommand(StringParser.format("MOUNT_LIST_REMOVE jobUUID=%s id=%d", this.selectedJobData.uuid, mountData.id), 0);
        }
        catch (Exception exception) {
            Dialogs.error(this.shell, BARControl.tr("Cannot remove mount data:\n\n{0}", exception.getMessage()));
            BARControl.logThrowable(exception);
            return;
        }
        Widgets.removeTableItem(this.widgetMountTable, mountData);
    }

    private void mountListRemove(String[] stringArray) {
        TableItem[] tableItemArray;
        assert (this.selectedJobData != null);
        for (TableItem tableItem : tableItemArray = this.widgetMountTable.getItems()) {
            MountData mountData = (MountData)tableItem.getData();
            if (StringUtils.indexOf(stringArray, mountData.name) < 0) continue;
            this.mountListRemove(mountData);
        }
    }

    private void mountListRemove(String string) {
        this.mountListRemove(new String[]{string});
    }

    private void mountListAdd(String string) {
        assert (this.selectedJobData != null);
        MountData mountData = new MountData(string);
        if (this.mountEdit(mountData, BARControl.tr("Add new mount", new Object[0]), BARControl.tr("Add", new Object[0]))) {
            this.mountListAdd(mountData);
        }
    }

    private void mountListAdd() {
        if (this.selectedJobData != null) {
            this.mountListAdd("");
        }
    }

    private void mountListEdit() {
        MountData mountData;
        TableItem[] tableItemArray;
        if (this.selectedJobData != null && (tableItemArray = this.widgetMountTable.getSelection()).length > 0 && this.mountEdit(mountData = (MountData)tableItemArray[0].getData(), BARControl.tr("Edit mount", new Object[0]), BARControl.tr("Save", new Object[0]))) {
            this.mountListUpdate(mountData);
        }
    }

    private void mountListClone() {
        MountData mountData;
        TableItem[] tableItemArray;
        if (this.selectedJobData != null && (tableItemArray = this.widgetMountTable.getSelection()).length > 0 && this.mountEdit(mountData = (MountData)tableItemArray[0].getData(), BARControl.tr("Clone mount", new Object[0]), BARControl.tr("Add", new Object[0]))) {
            this.mountListAdd(mountData);
        }
    }

    private void mountListRemove() {
        TableItem[] tableItemArray;
        if (this.selectedJobData != null && (tableItemArray = this.widgetMountTable.getSelection()).length > 0 && (tableItemArray.length == 1 || Dialogs.confirm(this.shell, BARControl.tr("Remove {0} {0,choice,0#mounts|1#mount|1<mounts}?", tableItemArray.length)))) {
            for (TableItem tableItem : tableItemArray) {
                this.mountListRemove((MountData)tableItem.getData());
            }
        }
    }

    private void clearSourceList() {
        this.deltaSource.set("");
    }

    private void updateSourceList(JobData jobData) {
        this.sourceHashSet.clear();
        this.deltaSource.set("");
        try {
            BARServer.executeCommand(StringParser.format("SOURCE_LIST jobUUID=%s", jobData.uuid), 0, new Command.ResultHandler(){

                @Override
                public void handle(int n, ValueMap valueMap) {
                    PatternTypes patternTypes = valueMap.getEnum("patternType", PatternTypes.class);
                    String string = valueMap.getString("pattern");
                    if (!string.isEmpty()) {
                        TabJobs.this.sourceHashSet.add(string);
                        TabJobs.this.deltaSource.set(string);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean setNoBackup(String string, boolean bl) {
        assert (this.selectedJobData != null);
        try {
            BARServer.executeCommand(StringParser.format("%s jobUUID=%s attribute=%s name=%'S", bl ? "FILE_ATTRIBUTE_SET" : "FILE_ATTRIBUTE_CLEAR", this.selectedJobData.uuid, "NOBACKUP", string), 0);
        }
        catch (Exception exception) {
            Dialogs.error(this.shell, BARControl.tr("Cannot set/remove .nobackup for {0}:\n\n{1}", string, exception.getMessage()));
            BARControl.logThrowable(exception);
            return false;
        }
        this.updateFileTreeImages();
        this.updateDeviceImages();
        return true;
    }

    private boolean setNoDump(String string, boolean bl) {
        assert (this.selectedJobData != null);
        try {
            BARServer.executeCommand(StringParser.format("%s jobUUID=%s attribute=%s name=%'S", bl ? "FILE_ATTRIBUTE_SET" : "FILE_ATTRIBUTE_CLEAR", this.selectedJobData.uuid, "NODUMP", string), 0);
        }
        catch (Exception exception) {
            Dialogs.error(this.shell, BARControl.tr("Cannot set/clear no-dump attribute for {0}:\n\n{1}", string, exception.getMessage()));
            BARControl.logThrowable(exception);
            return false;
        }
        this.updateFileTreeImages();
        this.updateDeviceImages();
        return true;
    }

    private void sourceListAdd(String[] stringArray) {
        assert (this.selectedJobData != null);
        try {
            for (String string : stringArray) {
                if (this.sourceHashSet.contains(string)) continue;
                BARServer.executeCommand(StringParser.format("SOURCE_LIST_ADD jobUUID=%s patternType=%s pattern=%'S", this.selectedJobData.uuid, "GLOB", string), 0);
                this.sourceHashSet.add(string);
            }
        }
        catch (Exception exception) {
            Dialogs.error(this.shell, BARControl.tr("Cannot add source pattern:\n\n{0}", exception.getMessage()));
            BARControl.logThrowable(exception);
            return;
        }
    }

    private void sourceListAdd(String string) {
        this.sourceListAdd(new String[]{string});
    }

    private void sourceListRemove(String[] stringArray) {
        assert (this.selectedJobData != null);
        for (String string : stringArray) {
            this.sourceHashSet.remove(string);
        }
        try {
            BARServer.executeCommand(StringParser.format("SOURCE_LIST_CLEAR jobUUID=%s", this.selectedJobData.uuid), 0);
            for (String string : this.sourceHashSet) {
                BARServer.executeCommand(StringParser.format("SOURCE_LIST_ADD jobUUID=%s patternType=%s pattern=%'S", this.selectedJobData.uuid, "GLOB", string), 0);
            }
        }
        catch (Exception exception) {
            Dialogs.error(this.shell, BARControl.tr("Cannot remove source pattern:\n\n{0}", exception.getMessage()));
            BARControl.logThrowable(exception);
            return;
        }
    }

    private void sourceListRemove(String string) {
        this.sourceListRemove(new String[]{string});
    }

    private void sourceListRemoveAll() {
        this.sourceHashSet.clear();
        try {
            BARServer.executeCommand(StringParser.format("SOURCE_LIST_CLEAR jobUUID=%s", this.selectedJobData.uuid), 0);
        }
        catch (Exception exception) {
            Dialogs.error(this.shell, BARControl.tr("Cannot clear source patterns:\n\n{0}", exception.getMessage()));
            BARControl.logThrowable(exception);
            return;
        }
    }

    private boolean compressExcludeEdit(final String[] stringArray, String string, String string2) {
        assert (this.selectedJobData != null);
        final Shell shell = Dialogs.openModal(this.shell, string, 300, 70, new double[]{1.0, 0.0}, 1.0);
        Composite composite = Widgets.newComposite((Composite)shell, 0, 4);
        composite.setLayout(new TableLayout(null, new double[]{0.0, 1.0, 0.0}, 4));
        Widgets.layout((Control)composite, 0, 0, 12, 0, 0, 2);
        Label label = Widgets.newLabel(composite, BARControl.tr("Pattern", new Object[0]) + ":");
        Widgets.layout(label, 0, 0, 4);
        final Text text = Widgets.newText(composite);
        text.setToolTipText(BARControl.tr("Compress exclude pattern. Use * and ? as wildcards.", new Object[0]));
        if (stringArray[0] != null) {
            text.setText(stringArray[0]);
        }
        Widgets.layout(text, 0, 1, 12);
        Button button = Widgets.newButton(composite, this.IMAGE_DIRECTORY);
        button.setToolTipText(BARControl.tr("Select remote path. CTRL+click to select local path.", new Object[0]));
        Widgets.layout(button, 0, 2, 0);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = Dialogs.file(TabJobs.this.shell, Dialogs.FileDialogTypes.OPEN, BARControl.tr("Select entry", new Object[0]), text.getText(), new String[]{BARControl.tr("All files", new Object[0]), BARControl.ALL_FILE_EXTENSION}, "*", 0, (selectionEvent.stateMask & 0x40000) == 0 ? BARServer.remoteListDirectory(((TabJobs)TabJobs.this).selectedJobData.uuid) : BARControl.listDirectory);
                if (string != null) {
                    text.setText(string);
                }
            }
        });
        composite = Widgets.newComposite((Composite)shell, 0, 4);
        composite.setLayout(new TableLayout(0.0, 1.0));
        Widgets.layout((Control)composite, 1, 0, 12, 0, 0, 2);
        final Button button2 = Widgets.newButton(composite, string2);
        button2.setEnabled(stringArray[0] != null && !stringArray[0].isEmpty());
        Widgets.layout(button2, 0, 0, 4, 0, 0, 0, 0, 100, -1);
        button = Widgets.newButton(composite, BARControl.tr("Cancel", new Object[0]));
        Widgets.layout(button, 0, 1, 8, 0, 0, 0, 0, 100, -1);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Dialogs.close(shell, false);
            }
        });
        text.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                Text text = (Text)modifyEvent.widget;
                String string = text.getText().trim();
                button2.setEnabled(!string.isEmpty());
            }
        });
        text.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                button2.forceFocus();
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                throw new Error("NYI");
            }
        });
        button2.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                stringArray[0] = text.getText();
                Dialogs.close(shell, true);
            }
        });
        return (Boolean)Dialogs.run(shell, false) != false && !stringArray[0].isEmpty();
    }

    private void compressExcludeListAdd(String string) {
        assert (this.selectedJobData != null);
        if (!this.compressExcludeHashSet.contains(string)) {
            try {
                BARServer.executeCommand(StringParser.format("EXCLUDE_COMPRESS_LIST_ADD jobUUID=%s patternType=%s pattern=%'S", this.selectedJobData.uuid, "GLOB", string), 0);
            }
            catch (Exception exception) {
                Dialogs.error(this.shell, BARControl.tr("Cannot add compress exclude entry:\n\n{0}", exception.getMessage()));
                BARControl.logThrowable(exception);
                return;
            }
            this.compressExcludeHashSet.add(string);
            Widgets.insertListItem(this.widgetCompressExcludeList, Widgets.getListItemIndex(this.widgetCompressExcludeList, String.CASE_INSENSITIVE_ORDER, string), string, string);
        }
        this.updateFileTreeImages();
        this.updateDeviceImages();
    }

    private void compressExcludeListAdd(String[] stringArray) {
        if (this.selectedJobData != null) {
            try {
                for (String string : stringArray) {
                    if (!this.compressExcludeHashSet.contains(string)) {
                        BARServer.executeCommand(StringParser.format("EXCLUDE_COMPRESS_LIST_ADD jobUUID=%s patternType=%s pattern=%'S", this.selectedJobData.uuid, "GLOB", string), 0);
                    }
                    this.compressExcludeHashSet.add(string);
                    Widgets.insertListItem(this.widgetCompressExcludeList, Widgets.getListItemIndex(this.widgetCompressExcludeList, String.CASE_INSENSITIVE_ORDER, string), string, string);
                }
            }
            catch (Exception exception) {
                Dialogs.error(this.shell, BARControl.tr("Cannot add compress exclude entry:\n\n{0}", exception.getMessage()));
                BARControl.logThrowable(exception);
                return;
            }
            this.updateFileTreeImages();
            this.updateDeviceImages();
        }
    }

    private void compressExcludeListAdd() {
        String[] stringArray;
        if (this.selectedJobData != null && this.compressExcludeEdit(stringArray = new String[1], BARControl.tr("Add new compress exclude pattern", new Object[0]), BARControl.tr("Add", new Object[0]))) {
            this.compressExcludeListAdd(stringArray[0]);
        }
    }

    private void compressExcludeListEdit() {
        String string;
        String[] stringArray;
        String[] stringArray2;
        if (this.selectedJobData != null && (stringArray2 = this.widgetCompressExcludeList.getSelection()).length > 0 && this.compressExcludeEdit(stringArray = new String[]{new String(string = stringArray2[0])}, BARControl.tr("Edit compress exclude pattern", new Object[0]), BARControl.tr("Save", new Object[0]))) {
            this.compressExcludeListRemove(new String[]{string, stringArray[0]});
            this.compressExcludeListAdd(stringArray[0]);
            this.updateFileTreeImages();
            this.updateDeviceImages();
        }
    }

    private void compressExcludeListRemove(String[] stringArray) {
        assert (this.selectedJobData != null);
        for (String string : stringArray) {
            this.compressExcludeHashSet.remove(string);
        }
        try {
            BARServer.executeCommand(StringParser.format("EXCLUDE_COMPRESS_LIST_CLEAR jobUUID=%s", this.selectedJobData.uuid), 0);
            Widgets.removeAllListItems(this.widgetCompressExcludeList);
            for (String string : this.compressExcludeHashSet) {
                BARServer.executeCommand(StringParser.format("EXCLUDE_COMPRESS_LIST_ADD jobUUID=%s patternType=%s pattern=%'S", this.selectedJobData.uuid, "GLOB", string), 0);
                Widgets.insertListItem(this.widgetCompressExcludeList, Widgets.getListItemIndex(this.widgetCompressExcludeList, String.CASE_INSENSITIVE_ORDER, string), string, string);
            }
        }
        catch (Exception exception) {
            Dialogs.error(this.shell, BARControl.tr("Cannot remove compress exclude entry:\n\n{0}", exception.getMessage()));
            BARControl.logThrowable(exception);
            return;
        }
        this.updateFileTreeImages();
        this.updateDeviceImages();
    }

    private void compressExcludeListRemove(String string) {
        this.compressExcludeListRemove(new String[]{string});
    }

    private void compressExcludeListRemove() {
        String[] stringArray;
        if (this.selectedJobData != null && (stringArray = this.widgetCompressExcludeList.getSelection()).length > 0 && Dialogs.confirm(this.shell, BARControl.tr("Remove {0} selected compress exclude {0,choice,0#patterns|1#pattern|1<patterns}?", stringArray.length))) {
            this.compressExcludeListRemove(stringArray);
        }
    }

    private String fileNameEdit(String string) {
        assert (this.selectedJobData != null);
        final Shell shell = Dialogs.openModal(this.shell, BARControl.tr("Edit storage file name", new Object[0]), 900, -1, new double[]{1.0, 0.0}, 1.0);
        Composite composite = Widgets.newComposite((Composite)shell, 0);
        composite.setLayout(new TableLayout(0.0, 1.0));
        Widgets.layout((Control)composite, 0, 0, 12, 0, 0, 2);
        final StorageFileNameEditor storageFileNameEditor = new StorageFileNameEditor(composite, string);
        composite = Widgets.newComposite((Composite)shell, 0);
        composite.setLayout(new TableLayout(0.0, 1.0));
        Widgets.layout((Control)composite, 2, 0, 12, 0, 0, 2);
        Button button = Widgets.newButton(composite, BARControl.tr("Save", new Object[0]));
        Widgets.layout(button, 0, 0, 4, 0, 0, 0, 0, 100, -1);
        Button button2 = Widgets.newButton(composite, BARControl.tr("Cancel", new Object[0]));
        Widgets.layout(button2, 0, 1, 8, 0, 0, 0, 0, 100, -1);
        button2.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Dialogs.close(shell, false);
            }
        });
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Dialogs.close(shell, storageFileNameEditor.getFileName());
            }
        });
        return (String)Dialogs.run(shell);
    }

    private void testScript(String string, String string2) {
        BusyDialog busyDialog = new BusyDialog(this.shell, BARControl.tr("Test script results", new Object[0]), 500, 300, 0x10000C0);
        String[] stringArray = new String[1];
        ValueMap valueMap = new ValueMap();
        Command command = BARServer.runCommand(StringParser.format("TEST_SCRIPT name=%'S script=%'S", string, string2), 0);
        while (!command.endOfData() && command.getNextResult(stringArray, valueMap, 60000) == 0) {
            try {
                String string3 = valueMap.getString("line");
                busyDialog.updateList(string3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                BARControl.logThrowable(illegalArgumentException);
            }
        }
        busyDialog.done();
    }

    private TableItem getScheduleTableItemByUUID(String string) {
        for (TableItem tableItem : this.widgetScheduleTable.getItems()) {
            if (!((ScheduleData)tableItem.getData()).uuid.equals(string)) continue;
            return tableItem;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearScheduleTable() {
        HashMap<String, ScheduleData> hashMap = this.scheduleDataMap;
        synchronized (hashMap) {
            this.scheduleDataMap.clear();
            Widgets.removeAllTableItems(this.widgetScheduleTable);
        }
    }

    private void updateScheduleTable(JobData jobData) {
        try {
            try {
                final HashMap hashMap = new HashMap();
                BARServer.executeCommand(StringParser.format("SCHEDULE_LIST jobUUID=%s", jobData.uuid), 1, new Command.ResultHandler(){

                    @Override
                    public void handle(int n, ValueMap valueMap) {
                        String string = valueMap.getString("jobName");
                        String string2 = valueMap.getString("jobUUID");
                        String string3 = valueMap.getString("scheduleUUID");
                        String string4 = valueMap.getString("date");
                        String string5 = valueMap.getString("weekDays");
                        String string6 = valueMap.getString("time");
                        ArchiveTypes archiveTypes = valueMap.getEnum("archiveType", ArchiveTypes.class);
                        int n2 = valueMap.getInt("interval");
                        String string7 = valueMap.getString("customText");
                        String string8 = valueMap.getString("beginTime");
                        String string9 = valueMap.getString("endTime");
                        boolean bl = valueMap.getBoolean("testCreatedArchives");
                        boolean bl2 = valueMap.getBoolean("noStorage");
                        boolean bl3 = valueMap.getBoolean("enabled");
                        long l = valueMap.getLong("lastExecutedDateTime");
                        long l2 = valueMap.getLong("nextExecutedDateTime");
                        long l3 = valueMap.getLong("totalEntities");
                        long l4 = valueMap.getLong("totalEntryCount");
                        long l5 = valueMap.getLong("totalEntrySize", Long.MAX_VALUE);
                        ScheduleData scheduleData = (ScheduleData)TabJobs.this.scheduleDataMap.get(string3);
                        if (scheduleData != null) {
                            scheduleData.setDate(string4);
                            scheduleData.setWeekDays(string5);
                            scheduleData.setTime(string6);
                            scheduleData.archiveType = archiveTypes;
                            scheduleData.interval = n2;
                            scheduleData.setBeginTime(string8);
                            scheduleData.setEndTime(string9);
                            scheduleData.customText = string7;
                            scheduleData.testCreatedArchives = bl;
                            scheduleData.noStorage = bl2;
                            scheduleData.enabled = bl3;
                            scheduleData.lastExecutedDateTime = l;
                            scheduleData.totalEntities = l3;
                            scheduleData.totalEntryCount = l4;
                            scheduleData.totalEntrySize = l5;
                        } else {
                            scheduleData = new ScheduleData(string3, string4, string5, string6, archiveTypes, n2, string8, string9, string7, bl, bl2, bl3, l, l3, l4, l5);
                        }
                        hashMap.put(string3, scheduleData);
                    }
                });
                this.scheduleDataMap = hashMap;
            }
            catch (Exception exception) {
                return;
            }
            this.display.syncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (!TabJobs.this.widgetScheduleTable.isDisposed()) {
                        HashMap hashMap = TabJobs.this.scheduleDataMap;
                        synchronized (hashMap) {
                            ScheduleDataComparator scheduleDataComparator = new ScheduleDataComparator(TabJobs.this.widgetScheduleTable);
                            HashSet<TableItem> hashSet = Widgets.getAllTableItems(TabJobs.this.widgetScheduleTable);
                            for (ScheduleData scheduleData : TabJobs.this.scheduleDataMap.values()) {
                                TableItem tableItem = Widgets.updateInsertTableItem(TabJobs.this.widgetScheduleTable, scheduleDataComparator, scheduleData, scheduleData.getDate(), scheduleData.getWeekDays(), scheduleData.getTime(), scheduleData.archiveType.toString(), scheduleData.getBeginTime(), scheduleData.getEndTime(), scheduleData.customText, scheduleData.testCreatedArchives ? BARControl.tr("yes", new Object[0]) : BARControl.tr("no", new Object[0]));
                                tableItem.setChecked(scheduleData.enabled);
                                hashSet.remove(tableItem);
                            }
                            Widgets.removeTableItems(hashSet);
                        }
                    }
                }
            });
        }
        catch (CommunicationError communicationError) {
            Dialogs.error(this.shell, BARControl.tr("Cannot get schedule list (error: {0})", communicationError.getMessage()));
            return;
        }
    }

    private boolean scheduleEdit(final ScheduleData scheduleData, String string, String string2) {
        final Shell shell = Dialogs.openModal(this.shell, string, 300, 70, new double[]{1.0, 0.0}, 1.0);
        final Button[] buttonArray = new Button[7];
        Composite composite = Widgets.newComposite((Composite)shell, 0);
        composite.setLayout(new TableLayout(null, new double[]{0.0, 1.0}));
        Widgets.layout((Control)composite, 0, 0, 12, 0, 0, 2);
        Label label = Widgets.newLabel(composite, BARControl.tr("Type", new Object[0]) + ":");
        Widgets.layout(label, 0, 0, 4);
        Composite composite2 = Widgets.newComposite(composite, 0);
        Widgets.layout(composite2, 0, 1, 12);
        final Button button = Widgets.newRadio(composite2, BARControl.tr("normal", new Object[0]), Settings.hasNormalRole());
        button.setToolTipText(BARControl.tr("Execute job as normal backup (no incremental data).", new Object[0]));
        Widgets.layout(button, 0, 0, 4);
        button.setSelection(scheduleData.archiveType == ArchiveTypes.NORMAL);
        final Button button2 = Widgets.newRadio(composite2, BARControl.tr("full", new Object[0]));
        button2.setToolTipText(BARControl.tr("Execute job as full backup.", new Object[0]));
        Widgets.layout(button2, 0, 1, 4);
        button2.setSelection(scheduleData.archiveType == ArchiveTypes.FULL);
        final Button button3 = Widgets.newRadio(composite2, BARControl.tr("incremental", new Object[0]));
        button3.setToolTipText(BARControl.tr("Execute job as incremental backup.", new Object[0]));
        Widgets.layout(button3, 0, 2, 4);
        button3.setSelection(scheduleData.archiveType == ArchiveTypes.INCREMENTAL);
        final Button button4 = Widgets.newRadio(composite2, BARControl.tr("differential", new Object[0]), Settings.hasExpertRole());
        button4.setToolTipText(BARControl.tr("Execute job as differential backup.", new Object[0]));
        Widgets.layout(button4, 0, 3, 4);
        button4.setSelection(scheduleData.archiveType == ArchiveTypes.DIFFERENTIAL);
        final Button button5 = Widgets.newRadio(composite2, BARControl.tr("continuous", new Object[0]), Settings.hasExpertRole());
        button5.setToolTipText(BARControl.tr("Execute job as continuous backup.", new Object[0]));
        Widgets.layout(button5, 0, 4, 4);
        button5.setSelection(scheduleData.archiveType == ArchiveTypes.CONTINUOUS);
        label = Widgets.newLabel(composite, BARControl.tr("Date", new Object[0]) + ":", Settings.hasNormalRole());
        Widgets.layout(label, 1, 0, 4);
        composite2 = Widgets.newComposite(composite, 0, Settings.hasNormalRole());
        Widgets.layout(composite2, 1, 1, 12);
        final Combo combo = Widgets.newOptionMenu(composite2);
        combo.setToolTipText(BARControl.tr("Year to execute job. Leave to '*' for each year.", new Object[0]));
        combo.setItems(new String[]{"*", "2008", "2009", "2010", "2011", "2012", "2013", "2014", "2015", "2016", "2017", "2018", "2019", "2020", "2021", "2022", "2023", "2024", "2025"});
        combo.setText(scheduleData.getYear());
        if (combo.getText().isEmpty()) {
            combo.setText("*");
        }
        if (combo.getText().isEmpty()) {
            combo.setText("*");
        }
        Widgets.layout(combo, 0, 0, 4);
        final Combo combo2 = Widgets.newOptionMenu(composite2);
        combo2.setToolTipText(BARControl.tr("Month to execute job. Leave to '*' for each month.", new Object[0]));
        combo2.setItems(new String[]{"*", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"});
        combo2.setText(scheduleData.getMonth());
        if (combo2.getText().isEmpty()) {
            combo2.setText("*");
        }
        Widgets.layout(combo2, 0, 1, 4);
        final Combo combo3 = Widgets.newOptionMenu(composite2);
        combo3.setToolTipText(BARControl.tr("Day to execute job. Leave to '*' for each day.", new Object[0]));
        combo3.setItems(new String[]{"*", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"});
        combo3.setText(scheduleData.getDay());
        if (combo3.getText().isEmpty()) {
            combo3.setText("*");
        }
        Widgets.layout(combo3, 0, 2, 4);
        label = Widgets.newLabel(composite, BARControl.tr("Week days", new Object[0]) + ":");
        Widgets.layout(label, 2, 0, 4);
        composite2 = Widgets.newComposite(composite, 0);
        Widgets.layout(composite2, 2, 1, 12);
        buttonArray[0] = Widgets.newCheckbox(composite2, BARControl.tr("Mon", new Object[0]));
        buttonArray[0].setToolTipText(BARControl.tr("Week days to execute job.", new Object[0]));
        Widgets.layout(buttonArray[0], 0, 0, 4);
        buttonArray[0].setSelection(scheduleData.weekDayIsEnabled(0));
        buttonArray[1] = Widgets.newCheckbox(composite2, BARControl.tr("Tue", new Object[0]));
        buttonArray[1].setToolTipText(BARControl.tr("Week days to execute job.", new Object[0]));
        Widgets.layout(buttonArray[1], 0, 1, 4);
        buttonArray[1].setSelection(scheduleData.weekDayIsEnabled(1));
        buttonArray[2] = Widgets.newCheckbox(composite2, BARControl.tr("Wed", new Object[0]));
        buttonArray[2].setToolTipText(BARControl.tr("Week days to execute job.", new Object[0]));
        Widgets.layout(buttonArray[2], 0, 2, 4);
        buttonArray[2].setSelection(scheduleData.weekDayIsEnabled(2));
        buttonArray[3] = Widgets.newCheckbox(composite2, BARControl.tr("Thu", new Object[0]));
        buttonArray[3].setToolTipText(BARControl.tr("Week days to execute job.", new Object[0]));
        Widgets.layout(buttonArray[3], 0, 3, 4);
        buttonArray[3].setSelection(scheduleData.weekDayIsEnabled(3));
        buttonArray[4] = Widgets.newCheckbox(composite2, BARControl.tr("Fri", new Object[0]));
        buttonArray[4].setToolTipText(BARControl.tr("Week days to execute job.", new Object[0]));
        Widgets.layout(buttonArray[4], 0, 4, 4);
        buttonArray[4].setSelection(scheduleData.weekDayIsEnabled(4));
        buttonArray[5] = Widgets.newCheckbox(composite2, BARControl.tr("Sat", new Object[0]));
        buttonArray[5].setToolTipText(BARControl.tr("Week days to execute job.", new Object[0]));
        Widgets.layout(buttonArray[5], 0, 5, 4);
        buttonArray[5].setSelection(scheduleData.weekDayIsEnabled(5));
        buttonArray[6] = Widgets.newCheckbox(composite2, BARControl.tr("Sun", new Object[0]));
        buttonArray[6].setToolTipText(BARControl.tr("Week days to execute job.", new Object[0]));
        Widgets.layout(buttonArray[6], 0, 6, 4);
        buttonArray[6].setSelection(scheduleData.weekDayIsEnabled(6));
        Button button6 = Widgets.newButton(composite2, this.IMAGE_TOGGLE_MARK);
        button6.setToolTipText(BARControl.tr("Toggle week days set.", new Object[0]));
        Widgets.layout(button6, 0, 7, 4);
        button6.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                for (Button button : buttonArray) {
                    button.setSelection(!button.getSelection());
                }
            }
        });
        label = Widgets.newLabel(composite, BARControl.tr("Time", new Object[0]) + ":");
        Widgets.layout(label, 3, 0, 4);
        composite2 = Widgets.newComposite(composite, 0);
        Widgets.layout(composite2, 3, 1, 12);
        final Combo combo4 = Widgets.newOptionMenu(composite2);
        combo4.setEnabled(scheduleData.archiveType != ArchiveTypes.CONTINUOUS);
        combo4.setToolTipText(BARControl.tr("Hour to execute job. Leave to '*' for every hour.", new Object[0]));
        combo4.setItems(new String[]{"*", "00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"});
        combo4.setText(scheduleData.getHour());
        if (combo4.getText().isEmpty()) {
            combo4.setText("*");
        }
        Widgets.layout(combo4, 0, 0, 4);
        final Combo combo5 = Widgets.newOptionMenu(composite2);
        combo5.setEnabled(scheduleData.archiveType != ArchiveTypes.CONTINUOUS);
        combo5.setToolTipText(BARControl.tr("Minute to execute job. Leave to '*' for every minute.", new Object[0]));
        combo5.setItems(new String[]{"*", "00", "05", "10", "15", "20", "30", "35", "40", "45", "50", "55"});
        combo5.setText(scheduleData.getMinute());
        if (combo5.getText().isEmpty()) {
            combo5.setText("*");
        }
        Widgets.layout(combo5, 0, 1, 4);
        label = Widgets.newLabel(composite, BARControl.tr("Interval", new Object[0]) + ":", Settings.hasExpertRole());
        Widgets.layout(label, 4, 0, 4);
        composite2 = Widgets.newComposite(composite, 0, Settings.hasExpertRole());
        Widgets.layout(composite2, 4, 1, 12);
        final Combo combo6 = Widgets.newOptionMenu(composite2);
        combo6.setEnabled(scheduleData.archiveType == ArchiveTypes.CONTINUOUS);
        combo6.setToolTipText(BARControl.tr("Interval time for continuous storage.", new Object[0]));
        Widgets.setOptionMenuItems(combo6, new Object[]{"", 0, BARControl.tr("1 min", new Object[0]), 1, BARControl.tr("5 min", new Object[0]), 5, BARControl.tr("10 min", new Object[0]), 10, BARControl.tr("30 min", new Object[0]), 30, BARControl.tr("1 h", new Object[0]), 60, BARControl.tr("2 h", new Object[0]), 180, BARControl.tr("4 h", new Object[0]), 240, BARControl.tr("8 h", new Object[0]), 480});
        Widgets.setSelectedOptionMenuItem(combo6, Integer.valueOf(scheduleData.interval));
        Widgets.layout(combo6, 0, 0, 4);
        label = Widgets.newLabel(composite2, BARControl.tr("Active time", new Object[0]) + ":");
        Widgets.layout(label, 0, 1, 4);
        final Combo combo7 = Widgets.newOptionMenu(composite2);
        combo7.setEnabled(scheduleData.archiveType == ArchiveTypes.CONTINUOUS);
        combo7.setToolTipText(BARControl.tr("Begin hour where continuous storage is active.", new Object[0]));
        combo7.setItems(new String[]{"*", "00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"});
        combo7.setText(scheduleData.getBeginHour());
        if (combo7.getText().isEmpty()) {
            combo7.setText("*");
        }
        Widgets.layout(combo7, 0, 2, 4);
        final Combo combo8 = Widgets.newOptionMenu(composite2);
        combo8.setEnabled(scheduleData.archiveType == ArchiveTypes.CONTINUOUS);
        combo8.setToolTipText(BARControl.tr("Begin minute where continuous storage is active.", new Object[0]));
        combo8.setItems(new String[]{"*", "00", "05", "10", "15", "20", "30", "35", "40", "45", "50", "55"});
        combo8.setText(scheduleData.getBeginMinute());
        if (combo8.getText().isEmpty()) {
            combo8.setText("*");
        }
        Widgets.layout(combo8, 0, 3, 4);
        label = Widgets.newLabel(composite2, "..");
        Widgets.layout(label, 0, 4, 4);
        final Combo combo9 = Widgets.newOptionMenu(composite2);
        combo9.setEnabled(scheduleData.archiveType == ArchiveTypes.CONTINUOUS);
        combo9.setToolTipText(BARControl.tr("End hour where continuous storage is active.", new Object[0]));
        combo9.setItems(new String[]{"*", "00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"});
        combo9.setText(scheduleData.getEndHour());
        if (combo9.getText().isEmpty()) {
            combo9.setText("*");
        }
        Widgets.layout(combo9, 0, 5, 4);
        final Combo combo10 = Widgets.newOptionMenu(composite2);
        combo10.setEnabled(scheduleData.archiveType == ArchiveTypes.CONTINUOUS);
        combo10.setToolTipText(BARControl.tr("End minute where continuous storage is active.", new Object[0]));
        combo10.setItems(new String[]{"*", "00", "05", "10", "15", "20", "30", "35", "40", "45", "50", "55"});
        combo10.setText(scheduleData.getEndMinute());
        if (combo10.getText().isEmpty()) {
            combo10.setText("*");
        }
        Widgets.layout(combo10, 0, 6, 4);
        label = Widgets.newLabel(composite, BARControl.tr("Custom text", new Object[0]) + ":", Settings.hasExpertRole());
        Widgets.layout(label, 5, 0, 4);
        final Text text = Widgets.newText(composite, Settings.hasExpertRole());
        text.setToolTipText(BARControl.tr("Custom text", new Object[0]) + ".");
        text.setText(scheduleData.customText);
        Widgets.layout(text, 5, 1, 12);
        label = Widgets.newLabel(composite, BARControl.tr("Options", new Object[0]) + ":");
        Widgets.layout(label, 6, 0, 4);
        composite2 = Widgets.newComposite(composite);
        Widgets.layout(composite2, 6, 1, 12);
        final Button button7 = Widgets.newCheckbox(composite2, BARControl.tr("test created archives", new Object[0]));
        button7.setToolTipText(BARControl.tr("Test created archives.", new Object[0]));
        Widgets.layout(button7, 0, 0, 4);
        button7.setSelection(scheduleData.testCreatedArchives);
        final Button button8 = Widgets.newCheckbox(composite2, BARControl.tr("do no create storages", new Object[0]), Settings.hasExpertRole());
        button8.setToolTipText(BARControl.tr("Do not create storage files. Only update incremental data.", new Object[0]));
        Widgets.layout(button8, 0, 1, 4);
        button8.setSelection(scheduleData.noStorage);
        final Button button9 = Widgets.newCheckbox(composite2, BARControl.tr("enabled", new Object[0]));
        Widgets.layout(button9, 0, 2, 4);
        button9.setSelection(scheduleData.enabled);
        composite = Widgets.newComposite((Composite)shell, 0);
        composite.setLayout(new TableLayout(0.0, 1.0));
        Widgets.layout((Control)composite, 1, 0, 12, 0, 0, 2);
        Button button10 = Widgets.newButton(composite, string2);
        Widgets.layout(button10, 0, 0, 4, 0, 0, 0, 0, 100, -1);
        button6 = Widgets.newButton(composite, BARControl.tr("Cancel", new Object[0]));
        Widgets.layout(button6, 0, 1, 8, 0, 0, 0, 0, 100, -1);
        button6.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Dialogs.close(shell, false);
            }
        });
        button5.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                combo4.setEnabled(!button.getSelection());
                combo5.setEnabled(!button.getSelection());
                combo6.setEnabled(button.getSelection());
                combo7.setEnabled(button.getSelection());
                combo8.setEnabled(button.getSelection());
                combo9.setEnabled(button.getSelection());
                combo10.setEnabled(button.getSelection());
            }
        });
        button10.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                scheduleData.archiveType = button.getSelection() ? ArchiveTypes.NORMAL : (button2.getSelection() ? ArchiveTypes.FULL : (button3.getSelection() ? ArchiveTypes.INCREMENTAL : (button4.getSelection() ? ArchiveTypes.DIFFERENTIAL : (button5.getSelection() ? ArchiveTypes.CONTINUOUS : ArchiveTypes.NORMAL))));
                scheduleData.setDate(combo.getText(), combo2.getText(), combo3.getText());
                scheduleData.setWeekDays(buttonArray[0].getSelection(), buttonArray[1].getSelection(), buttonArray[2].getSelection(), buttonArray[3].getSelection(), buttonArray[4].getSelection(), buttonArray[5].getSelection(), buttonArray[6].getSelection());
                scheduleData.setTime(combo4.getText(), combo5.getText());
                scheduleData.interval = Widgets.getSelectedOptionMenuItem(combo6, 0);
                scheduleData.setBeginTime(combo7.getText(), combo8.getText());
                scheduleData.setEndTime(combo9.getText(), combo10.getText());
                scheduleData.customText = text.getText();
                scheduleData.testCreatedArchives = button7.getSelection();
                scheduleData.noStorage = button8.getSelection();
                scheduleData.enabled = button9.getSelection();
                if (scheduleData.archiveType != ArchiveTypes.CONTINUOUS && scheduleData.minute == -1 && !Dialogs.confirm(shell, BARControl.tr("No specific time set. Really execute job every minute?", new Object[0]))) {
                    return;
                }
                if (scheduleData.weekDays == 0) {
                    Dialogs.error(shell, BARControl.tr("No weekdays specified!", new Object[0]));
                    return;
                }
                if (scheduleData.day != -1 && scheduleData.weekDays != -1 && !Dialogs.confirm(shell, BARControl.tr("The job may not be triggered if the specified day is not in the set of specified weekdays.\nReally keep this setting?", new Object[0]))) {
                    return;
                }
                Dialogs.close(shell, true);
            }
        });
        return (Boolean)Dialogs.run(shell, false);
    }

    private void scheduleAddEntry() {
        ScheduleData scheduleData;
        if (this.selectedJobData != null && this.scheduleEdit(scheduleData = new ScheduleData(), BARControl.tr("New schedule", new Object[0]), BARControl.tr("Add", new Object[0]))) {
            Object object;
            try {
                object = new ValueMap();
                BARServer.executeCommand(StringParser.format("SCHEDULE_LIST_ADD jobUUID=%s date=%s weekDays=%s time=%s archiveType=%s interval=%d beginTime=%s endTime=%s customText=%S testCreatedArchives=%y noStorage=%y enabled=%y", this.selectedJobData.uuid, scheduleData.getDate(), scheduleData.weekDaysToString(), scheduleData.getTime(), scheduleData.archiveType.toString(), scheduleData.interval, scheduleData.getBeginTime(), scheduleData.getEndTime(), scheduleData.customText, scheduleData.testCreatedArchives, scheduleData.noStorage, scheduleData.enabled), 0, (ValueMap)object);
                scheduleData.uuid = ((ValueMap)object).getString("scheduleUUID");
                this.scheduleDataMap.put(scheduleData.uuid, scheduleData);
            }
            catch (Exception exception) {
                Dialogs.error(this.shell, BARControl.tr("Cannot create new schedule:\n\n{0}", exception.getMessage()));
                BARControl.logThrowable(exception);
                return;
            }
            object = Widgets.updateInsertTableItem(this.widgetScheduleTable, new ScheduleDataComparator(this.widgetScheduleTable), scheduleData, scheduleData.getDate(), scheduleData.getWeekDays(), scheduleData.getTime(), scheduleData.archiveType.toString(), scheduleData.getBeginTime(), scheduleData.getEndTime(), scheduleData.customText, scheduleData.testCreatedArchives ? BARControl.tr("yes", new Object[0]) : BARControl.tr("no", new Object[0]));
            ((TableItem)object).setChecked(scheduleData.enabled);
            ((Widget)object).setData(scheduleData);
            Widgets.notify((Widget)this.shell, 65537, this.selectedJobData.uuid);
        }
    }

    private void scheduleEditEntry() {
        TableItem tableItem;
        ScheduleData scheduleData;
        int n;
        if (this.selectedJobData != null && (n = this.widgetScheduleTable.getSelectionIndex()) >= 0 && this.scheduleEdit(scheduleData = (ScheduleData)(tableItem = this.widgetScheduleTable.getItem(n)).getData(), BARControl.tr("Edit schedule", new Object[0]), BARControl.tr("Save", new Object[0]))) {
            try {
                BARServer.setScheduleOption(this.selectedJobData.uuid, scheduleData.uuid, "date", scheduleData.getDate());
                BARServer.setScheduleOption(this.selectedJobData.uuid, scheduleData.uuid, "weekdays", scheduleData.weekDaysToString());
                BARServer.setScheduleOption(this.selectedJobData.uuid, scheduleData.uuid, "time", scheduleData.getTime());
                BARServer.setScheduleOption(this.selectedJobData.uuid, scheduleData.uuid, "archive-type", scheduleData.archiveType.toString());
                BARServer.setScheduleOption(this.selectedJobData.uuid, scheduleData.uuid, "interval", scheduleData.interval);
                BARServer.setScheduleOption(this.selectedJobData.uuid, scheduleData.uuid, "begin", scheduleData.getBeginTime());
                BARServer.setScheduleOption(this.selectedJobData.uuid, scheduleData.uuid, "end", scheduleData.getEndTime());
                BARServer.setScheduleOption(this.selectedJobData.uuid, scheduleData.uuid, "text", scheduleData.customText);
                BARServer.setScheduleOption(this.selectedJobData.uuid, scheduleData.uuid, "test-created-archives", scheduleData.testCreatedArchives);
                BARServer.setScheduleOption(this.selectedJobData.uuid, scheduleData.uuid, "no-storage", scheduleData.noStorage);
                BARServer.setScheduleOption(this.selectedJobData.uuid, scheduleData.uuid, "enabled", scheduleData.enabled);
            }
            catch (Exception exception) {
                Dialogs.error(this.shell, BARControl.tr("Cannot update schedule entry:\n\n{0}", exception.getMessage()));
                BARControl.logThrowable(exception);
                return;
            }
            Widgets.updateTableItem(tableItem, scheduleData, scheduleData.getDate(), scheduleData.getWeekDays(), scheduleData.getTime(), scheduleData.archiveType.getText(), scheduleData.getBeginTime(), scheduleData.getEndTime(), scheduleData.customText, scheduleData.testCreatedArchives ? BARControl.tr("yes", new Object[0]) : BARControl.tr("no", new Object[0]));
            tableItem.setChecked(scheduleData.enabled);
            Widgets.notify((Widget)this.shell, 65537, this.selectedJobData.uuid);
        }
    }

    private void scheduleCloneEntry() {
        TableItem tableItem;
        ScheduleData scheduleData;
        ScheduleData scheduleData2;
        int n;
        if (this.selectedJobData != null && (n = this.widgetScheduleTable.getSelectionIndex()) >= 0 && this.scheduleEdit(scheduleData2 = (scheduleData = (ScheduleData)(tableItem = this.widgetScheduleTable.getItem(n)).getData()).clone(), BARControl.tr("Clone schedule", new Object[0]), BARControl.tr("Add", new Object[0]))) {
            Object object;
            try {
                object = new ValueMap();
                BARServer.executeCommand(StringParser.format("SCHEDULE_LIST_ADD jobUUID=%s date=%s weekDays=%s time=%s archiveType=%s beginTime=%s endTime=%s customText=%S testCreatedArchives=%y noStorage=%y enabled=%y", this.selectedJobData.uuid, scheduleData2.getDate(), scheduleData2.getWeekDays(), scheduleData2.getTime(), scheduleData2.archiveType.toString(), scheduleData.getBeginTime(), scheduleData.getEndTime(), scheduleData2.customText, scheduleData2.testCreatedArchives, scheduleData2.noStorage, scheduleData2.enabled), 0, (ValueMap)object);
                scheduleData.uuid = ((ValueMap)object).getString("scheduleUUID");
                this.scheduleDataMap.put(scheduleData.uuid, scheduleData2);
            }
            catch (Exception exception) {
                Dialogs.error(this.shell, BARControl.tr("Cannot clone new schedule:\n\n{0}", exception.getMessage()));
                BARControl.logThrowable(exception);
                return;
            }
            object = Widgets.updateInsertTableItem(this.widgetScheduleTable, new ScheduleDataComparator(this.widgetScheduleTable), scheduleData2, scheduleData2.getDate(), scheduleData2.getWeekDays(), scheduleData2.getTime(), scheduleData2.archiveType.toString(), scheduleData2.getBeginTime(), scheduleData2.getEndTime(), scheduleData2.customText, scheduleData2.testCreatedArchives ? BARControl.tr("yes", new Object[0]) : BARControl.tr("no", new Object[0]));
            ((TableItem)object).setChecked(scheduleData2.enabled);
            ((Widget)object).setData(scheduleData2);
            Widgets.notify((Widget)this.shell, 65537, this.selectedJobData.uuid);
        }
    }

    private void scheduleRemoveEntry() {
        TableItem[] tableItemArray;
        if (this.selectedJobData != null && (tableItemArray = this.widgetScheduleTable.getSelection()).length > 0 && Dialogs.confirm(this.shell, BARControl.tr("Delete {0} selected schedule {0,choice,0#entries|1#entry|1<entries}?", tableItemArray.length))) {
            try {
                for (TableItem tableItem : tableItemArray) {
                    ScheduleData scheduleData = (ScheduleData)tableItem.getData();
                    BARServer.executeCommand(StringParser.format("SCHEDULE_LIST_REMOVE jobUUID=%s scheduleUUID=%s", this.selectedJobData.uuid, scheduleData.uuid), 0);
                    this.scheduleDataMap.remove(scheduleData.uuid);
                    tableItem.dispose();
                }
            }
            catch (Exception exception) {
                Dialogs.error(this.shell, BARControl.tr("Cannot delete schedule:\n\n{0}", exception.getMessage()));
                BARControl.logThrowable(exception);
                return;
            }
        }
    }

    private void scheduleTriggerEntry() {
        int n;
        if (this.selectedJobData != null && (n = this.widgetScheduleTable.getSelectionIndex()) >= 0) {
            TableItem tableItem = this.widgetScheduleTable.getItem(n);
            ScheduleData scheduleData = (ScheduleData)tableItem.getData();
            try {
                BARServer.executeCommand(StringParser.format("SCHEDULE_TRIGGER jobUUID=%s scheduleUUID=%s", this.selectedJobData.uuid, scheduleData.uuid), 0);
            }
            catch (Exception exception) {
                Dialogs.error(this.shell, BARControl.tr("Cannot trigger schedule of job ''{0}'':\n\n{1}", this.selectedJobData.name.replaceAll("&", "&&"), exception.getMessage()));
                BARControl.logThrowable(exception);
                return;
            }
        }
    }

    private void clearPersistenceTable() {
        Widgets.removeAllTreeItems(this.widgetPersistenceTree);
    }

    private void updatePersistenceTree(JobData jobData) {
        ArrayList arrayList;
        HashMap hashMap;
        block2: {
            hashMap = new HashMap();
            arrayList = new ArrayList();
            try {
                BARServer.executeCommand(StringParser.format("PERSISTENCE_LIST jobUUID=%s", jobData.uuid), 1, new Command.ResultHandler(){

                    @Override
                    public void handle(int n, ValueMap valueMap) {
                        int n2 = valueMap.getInt("persistenceId", 0);
                        long l = valueMap.getLong("entityId", 0L);
                        if (l != 0L) {
                            ArchiveTypes archiveTypes = valueMap.getEnum("archiveType", ArchiveTypes.class, ArchiveTypes.UNKNOWN);
                            long l2 = valueMap.getLong("createdDateTime");
                            long l3 = valueMap.getLong("size");
                            long l4 = valueMap.getLong("totalEntryCount");
                            long l5 = valueMap.getLong("totalEntrySize", Long.MAX_VALUE);
                            boolean bl = valueMap.getBoolean("inTransit");
                            EntityIndexData entityIndexData = new EntityIndexData(l, "", l2, l3, l4, l5, bl);
                            hashMap.put(entityIndexData, n2);
                        } else if ((long)n2 != 0L) {
                            ArchiveTypes archiveTypes = valueMap.getEnum("archiveType", ArchiveTypes.class, ArchiveTypes.UNKNOWN);
                            int n3 = !valueMap.getString("minKeep", "*").equals("*") ? valueMap.getInt("minKeep") : -1;
                            int n4 = !valueMap.getString("maxKeep", "*").equals("*") ? valueMap.getInt("maxKeep") : -1;
                            int n5 = !valueMap.getString("maxAge", "*").equals("*") ? valueMap.getInt("maxAge") : -1;
                            String string = valueMap.getString("moveTo");
                            PersistenceData persistenceData = new PersistenceData(n2, archiveTypes, n3, n4, n5, string);
                            arrayList.add(persistenceData);
                        }
                    }
                });
            }
            catch (Exception exception) {
                if (Settings.debugLevel <= 0) break block2;
                BARControl.printStackTrace(exception);
            }
        }
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!TabJobs.this.widgetPersistenceTree.isDisposed()) {
                    TreeItem treeItem;
                    PersistenceDataComparator persistenceDataComparator = new PersistenceDataComparator(PersistenceDataComparator.SortModes.MAX_AGE);
                    HashSet<TreeItem> hashSet = Widgets.getAllTreeItems(TabJobs.this.widgetPersistenceTree);
                    HashMap<Integer, TreeItem> hashMap2 = new HashMap<Integer, TreeItem>();
                    for (Comparable comparable : arrayList) {
                        treeItem = Widgets.updateInsertTreeItem(TabJobs.this.widgetPersistenceTree, persistenceDataComparator, comparable, 2, comparable.archiveType.getText(), Keep.format(comparable.minKeep), Keep.format(comparable.maxKeep), Age.format(comparable.maxAge));
                        hashMap2.put(comparable.id, treeItem);
                        hashSet.remove(treeItem);
                    }
                    for (Comparable comparable : hashMap.keySet()) {
                        treeItem = (TreeItem)hashMap2.get(hashMap.get(comparable));
                        if (treeItem == null) continue;
                        TreeItem treeItem2 = Widgets.updateInsertTreeItem(treeItem, comparable, 4, "", "", "", "", TabJobs.this.SIMPLE_DATE_FORMAT.format(new Date(((EntityIndexData)comparable).createdDateTime * 1000L)), (int)((System.currentTimeMillis() / 1000L - ((EntityIndexData)comparable).createdDateTime) / 86400L), Units.formatByteSize(((EntityIndexData)comparable).totalSize));
                        if (((EntityIndexData)comparable).inTransit) {
                            Widgets.setTreeItemColor(treeItem2, TabJobs.this.COLOR_IN_TRANSIT);
                        }
                        hashSet.remove(treeItem2);
                    }
                    Widgets.removeTreeItems(hashSet);
                }
            }
        });
    }

    private boolean persistenceEdit(final PersistenceData persistenceData, String string, String string2) {
        final Shell shell = Dialogs.openModal(this.shell, string, 300, 70, new double[]{1.0, 0.0}, 1.0);
        Composite composite = Widgets.newComposite((Composite)shell, 0);
        composite.setLayout(new TableLayout(new double[]{0.0, 0.0, 0.0, 0.0, 1.0}, new double[]{0.0, 1.0}));
        Widgets.layout((Control)composite, 0, 0, 12, 0, 0, 2);
        Label label = Widgets.newLabel(composite, BARControl.tr("Type", new Object[0]) + ":");
        Widgets.layout(label, 0, 0, 4);
        Composite composite2 = Widgets.newComposite(composite, 0);
        Widgets.layout(composite2, 0, 1, 12);
        final Button button = Widgets.newRadio(composite2, BARControl.tr("normal", new Object[0]), Settings.hasNormalRole());
        button.setToolTipText(BARControl.tr("Execute job as normal backup (no incremental data).", new Object[0]));
        button.setSelection(persistenceData.archiveType == ArchiveTypes.NORMAL);
        Widgets.layout(button, 0, 0, 4);
        final Button button2 = Widgets.newRadio(composite2, BARControl.tr("full", new Object[0]));
        button2.setToolTipText(BARControl.tr("Execute job as full backup.", new Object[0]));
        button2.setSelection(persistenceData.archiveType == ArchiveTypes.FULL);
        Widgets.layout(button2, 0, 1, 4);
        final Button button3 = Widgets.newRadio(composite2, BARControl.tr("incremental", new Object[0]));
        button3.setToolTipText(BARControl.tr("Execute job as incremental backup.", new Object[0]));
        button3.setSelection(persistenceData.archiveType == ArchiveTypes.INCREMENTAL);
        Widgets.layout(button3, 0, 2, 4);
        final Button button4 = Widgets.newRadio(composite2, BARControl.tr("differential", new Object[0]), Settings.hasExpertRole());
        button4.setToolTipText(BARControl.tr("Execute job as differential backup.", new Object[0]));
        button4.setSelection(persistenceData.archiveType == ArchiveTypes.DIFFERENTIAL);
        Widgets.layout(button4, 0, 3, 4);
        final Button button5 = Widgets.newRadio(composite2, BARControl.tr("continuous", new Object[0]), Settings.hasExpertRole());
        button5.setToolTipText(BARControl.tr("Execute job as continuous backup.", new Object[0]));
        button5.setSelection(persistenceData.archiveType == ArchiveTypes.CONTINUOUS);
        Widgets.layout(button5, 0, 4, 4);
        label = Widgets.newLabel(composite, BARControl.tr("Keep", new Object[0]) + ":", Settings.hasNormalRole());
        Widgets.layout(label, 1, 0, 4);
        composite2 = Widgets.newComposite(composite, 0);
        Widgets.layout(composite2, 1, 1, 12);
        label = Widgets.newLabel(composite2, BARControl.tr("min", new Object[0]) + ".:", Settings.hasExpertRole());
        Widgets.layout(label, 0, 0, 4);
        final Combo combo = Widgets.newOptionMenu(composite2, Settings.hasExpertRole());
        combo.setToolTipText(BARControl.tr("Min. number of archives to keep.", new Object[0]));
        Widgets.setOptionMenuItems(combo, new Object[]{BARControl.tr("unlimited", new Object[0]), -1, "0", 0, "1", 1, "2", 2, "3", 3, "4", 4, "5", 5, "6", 6, "7", 7, "8", 8, "9", 9, "10", 10});
        Widgets.setSelectedOptionMenuItem(combo, Integer.valueOf(persistenceData.minKeep));
        Widgets.layout(combo, 0, 1, 4);
        label = Widgets.newLabel(composite2, BARControl.tr("max", new Object[0]) + ".:", Settings.hasNormalRole());
        Widgets.layout(label, 0, 2, 4);
        final Combo combo2 = Widgets.newOptionMenu(composite2, Settings.hasNormalRole());
        combo2.setToolTipText(BARControl.tr("Max. number of archives to keep.", new Object[0]));
        Widgets.setOptionMenuItems(combo2, new Object[]{BARControl.tr("unlimited", new Object[0]), -1, "1", 1, "2", 2, "3", 3, "4", 4, "5", 5, "6", 6, "7", 7, "8", 8, "9", 9, "10", 10});
        Widgets.setSelectedOptionMenuItem(combo2, Integer.valueOf(persistenceData.maxKeep));
        Widgets.layout(combo2, 0, 3, 4);
        label = Widgets.newLabel(composite2, BARControl.tr("age", new Object[0]) + ":", Settings.hasExpertRole());
        Widgets.layout(label, 0, 4, 4);
        final Combo combo3 = Widgets.newOptionMenu(composite2, Settings.hasExpertRole());
        combo3.setToolTipText(BARControl.tr("Max. age of archives to keep.", new Object[0]));
        Widgets.setOptionMenuItems(combo3, new Object[]{BARControl.tr("forever", new Object[0]), -1, BARControl.tr("1 day", new Object[0]), 1, BARControl.tr("2 days", new Object[0]), 2, BARControl.tr("3 days", new Object[0]), 3, BARControl.tr("4 days", new Object[0]), 4, BARControl.tr("5 days", new Object[0]), 5, BARControl.tr("6 days", new Object[0]), 6, BARControl.tr("1 week", new Object[0]), 7, BARControl.tr("2 weeks", new Object[0]), 14, BARControl.tr("3 weeks", new Object[0]), 21, BARControl.tr("1 month", new Object[0]), 30, BARControl.tr("2 months", new Object[0]), 60, BARControl.tr("3 months", new Object[0]), 90, BARControl.tr("6 months", new Object[0]), 180, BARControl.tr("1 year", new Object[0]), 365, BARControl.tr("18 months", new Object[0]), 548, BARControl.tr("2 years", new Object[0]), 730, BARControl.tr("3 years", new Object[0]), 1095, BARControl.tr("4 years", new Object[0]), 1460, BARControl.tr("5 years", new Object[0]), 1825});
        Widgets.setSelectedOptionMenuItem(combo3, Integer.valueOf(persistenceData.maxAge));
        Widgets.layout(combo3, 0, 5, 4);
        label = Widgets.newLabel(composite, BARControl.tr("Move to", new Object[0]) + ":");
        Widgets.layout(label, 2, 0, 4);
        composite2 = Widgets.newComposite(composite, 0);
        composite2.setLayout(new TableLayout(null, new double[]{1.0, 0.0, 0.0}));
        Widgets.layout(composite2, 2, 1, 12);
        final Text text = Widgets.newText(composite2);
        text.setToolTipText(BARControl.tr("Name of directory to move storages to. Several macros are supported. Click on button to the right to open storage file name editor.", new Object[0]));
        text.setText(persistenceData.moveTo.fileName);
        Widgets.layout(text, 0, 0, 12);
        Button button6 = Widgets.newButton(composite2, this.IMAGE_EDIT);
        Widgets.layout(button6, 0, 1, 0);
        button6.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (TabJobs.this.selectedJobData != null) {
                    try {
                        String string = TabJobs.this.fileNameEdit(text.getText());
                        if (string != null) {
                            text.setText(string);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        button6 = Widgets.newButton(composite2, this.IMAGE_DIRECTORY);
        button6.setToolTipText(BARControl.tr("Select remote directory. CTRL+click to select local directory.", new Object[0]));
        Widgets.layout(button6, 0, 2, 0);
        button6.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                String string;
                if (TabJobs.this.selectedJobData != null && (string = Dialogs.file(TabJobs.this.shell, Dialogs.FileDialogTypes.DIRECTORY, BARControl.tr("Select storage directory", new Object[0]), text.getText(), (selectionEvent.stateMask & 0x40000) == 0 ? BARServer.remoteListDirectory(((TabJobs)TabJobs.this).selectedJobData.uuid) : BARControl.listDirectory)) != null) {
                    text.setText(string);
                }
            }
        });
        label = Widgets.newLabel(composite, BARControl.tr("Destination", new Object[0]) + ":");
        Widgets.layout(label, 3, 0, 4);
        composite2 = Widgets.newComposite(composite);
        Widgets.layout(composite2, 3, 1, 12);
        final Combo combo4 = Widgets.newOptionMenu(composite2);
        combo4.setToolTipText(BARControl.tr("Storage destination type:\n  into file system\n  on FTP server\n  on SSH server with scp (secure copy)\n  on SSH server with sftp (secure FTP)\n  on WebDAV server\n  on WebDAV secure server\n  on SMB/CIFS server\n", new Object[0]));
        Widgets.setComboItems(combo4, new Object[]{BARControl.tr("file system", new Object[0]), StorageTypes.FILESYSTEM, "ftp", StorageTypes.FTP, "scp", StorageTypes.SCP, "sftp", StorageTypes.SFTP, "webdav", StorageTypes.WEBDAV, "webdavs", StorageTypes.WEBDAVS, "smb", StorageTypes.SMB});
        Widgets.setSelectedComboItem(combo4, persistenceData.moveTo.type);
        Widgets.layout(combo4, 0, 0, 4);
        BARWidgets.File file = new BARWidgets.File(composite);
        Widgets.layout(file, 4, 1, 13);
        Widgets.addModifyListener(new WidgetModifyListener(file, combo4){

            @Override
            public void modified(Control control, Combo combo) {
                Widgets.setVisible(control, Widgets.getSelectedComboItem(combo) == StorageTypes.FILESYSTEM);
                shell.pack();
            }
        });
        final BARWidgets.FTP fTP = new BARWidgets.FTP(composite);
        Widgets.layout(fTP, 4, 1, 13);
        fTP.hostName.setText(persistenceData.moveTo.hostName);
        fTP.loginName.setText(persistenceData.moveTo.loginName);
        fTP.loginPassword.setText(persistenceData.moveTo.loginPassword);
        Widgets.addModifyListener(new WidgetModifyListener(fTP, combo4){

            @Override
            public void modified(Control control, Combo combo) {
                Widgets.setVisible(control, Widgets.getSelectedComboItem(combo) == StorageTypes.FTP);
                shell.pack();
            }
        });
        final BARWidgets.SFTP sFTP = new BARWidgets.SFTP(composite);
        Widgets.layout(sFTP, 4, 1, 13);
        sFTP.hostName.setText(persistenceData.moveTo.hostName);
        sFTP.hostPort.setSelection(persistenceData.moveTo.hostPort);
        sFTP.loginName.setText(persistenceData.moveTo.loginName);
        sFTP.loginPassword.setText(persistenceData.moveTo.loginPassword);
        Widgets.addModifyListener(new WidgetModifyListener(sFTP, combo4){

            @Override
            public void modified(Control control, Combo combo) {
                Widgets.setVisible(control, Widgets.getSelectedComboItem(combo) == StorageTypes.SCP || Widgets.getSelectedComboItem(combo) == StorageTypes.SFTP);
                shell.pack();
            }
        });
        final BARWidgets.WebDAV webDAV = new BARWidgets.WebDAV(composite);
        Widgets.layout(webDAV, 4, 1, 13);
        sFTP.hostName.setText(persistenceData.moveTo.hostName);
        sFTP.hostPort.setSelection(persistenceData.moveTo.hostPort);
        sFTP.loginName.setText(persistenceData.moveTo.loginName);
        sFTP.loginPassword.setText(persistenceData.moveTo.loginPassword);
        Widgets.addModifyListener(new WidgetModifyListener(webDAV, combo4){

            @Override
            public void modified(Control control, Combo combo) {
                Widgets.setVisible(control, Widgets.getSelectedComboItem(combo) == StorageTypes.WEBDAV || Widgets.getSelectedComboItem(combo) == StorageTypes.WEBDAVS);
                shell.pack();
            }
        });
        final BARWidgets.SMB sMB = new BARWidgets.SMB(composite);
        Widgets.layout(sMB, 5, 1, 13);
        sMB.hostName.setText(persistenceData.moveTo.hostName);
        sMB.loginName.setText(persistenceData.moveTo.loginName);
        sMB.loginPassword.setText(persistenceData.moveTo.loginPassword);
        Widgets.addModifyListener(new WidgetModifyListener(sMB, combo4){

            @Override
            public void modified(Control control, Combo combo) {
                Widgets.setVisible(control, Widgets.getSelectedComboItem(combo) == StorageTypes.SMB);
                shell.pack();
            }
        });
        composite = Widgets.newComposite((Composite)shell, 0);
        composite.setLayout(new TableLayout(0.0, 1.0));
        Widgets.layout((Control)composite, 1, 0, 12, 0, 0, 2);
        Button button7 = Widgets.newButton(composite, string2);
        Widgets.layout(button7, 0, 0, 4, 0, 0, 0, 0, 100, -1);
        button6 = Widgets.newButton(composite, BARControl.tr("Cancel", new Object[0]));
        Widgets.layout(button6, 0, 1, 8, 0, 0, 0, 0, 100, -1);
        button6.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Dialogs.close(shell, false);
            }
        });
        button7.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                persistenceData.archiveType = button.getSelection() ? ArchiveTypes.NORMAL : (button2.getSelection() ? ArchiveTypes.FULL : (button3.getSelection() ? ArchiveTypes.INCREMENTAL : (button4.getSelection() ? ArchiveTypes.DIFFERENTIAL : (button5.getSelection() ? ArchiveTypes.CONTINUOUS : ArchiveTypes.NORMAL))));
                persistenceData.minKeep = Widgets.getSelectedOptionMenuItem(combo, 0);
                persistenceData.maxKeep = Widgets.getSelectedOptionMenuItem(combo2, 0);
                if (persistenceData.maxKeep == 0) {
                    Dialogs.error(shell, BARControl.tr("No max. keep set!", new Object[0]));
                    return;
                }
                persistenceData.maxAge = Widgets.getSelectedOptionMenuItem(combo3, 0);
                if (persistenceData.maxAge == 0) {
                    Dialogs.error(shell, BARControl.tr("No max. age set!", new Object[0]));
                    return;
                }
                persistenceData.moveTo.type = Widgets.getSelectedComboItem(combo4, StorageTypes.FILESYSTEM);
                persistenceData.moveTo.fileName = text.getText();
                switch (Widgets.getSelectedComboItem(combo4, StorageTypes.FILESYSTEM)) {
                    case FILESYSTEM: {
                        break;
                    }
                    case FTP: {
                        persistenceData.moveTo.hostName = fTP.hostName.getText();
                        persistenceData.moveTo.loginName = fTP.loginName.getText();
                        persistenceData.moveTo.loginPassword = fTP.loginPassword.getText();
                        break;
                    }
                    case SCP: 
                    case SFTP: {
                        persistenceData.moveTo.hostName = sFTP.hostName.getText();
                        persistenceData.moveTo.hostPort = sFTP.hostPort.getSelection();
                        persistenceData.moveTo.loginName = sFTP.loginName.getText();
                        persistenceData.moveTo.loginPassword = sFTP.loginPassword.getText();
                        break;
                    }
                    case WEBDAV: 
                    case WEBDAVS: {
                        persistenceData.moveTo.hostName = webDAV.hostName.getText();
                        persistenceData.moveTo.hostPort = webDAV.hostPort.getSelection();
                        persistenceData.moveTo.loginName = webDAV.loginName.getText();
                        persistenceData.moveTo.loginPassword = webDAV.loginPassword.getText();
                        break;
                    }
                    case SMB: {
                        persistenceData.moveTo.hostName = sMB.hostName.getText();
                        persistenceData.moveTo.loginName = sMB.loginName.getText();
                        persistenceData.moveTo.loginPassword = sMB.loginPassword.getText();
                    }
                }
                Dialogs.close(shell, true);
            }
        });
        return (Boolean)Dialogs.run(shell, false);
    }

    private void persistenceListAdd(PersistenceData persistenceData) {
        if (this.selectedJobData != null) {
            try {
                ValueMap valueMap = new ValueMap();
                BARServer.executeCommand(StringParser.format("PERSISTENCE_LIST_ADD jobUUID=%s archiveType=%s minKeep=%s maxKeep=%s maxAge=%s moveTo=%'s", this.selectedJobData.uuid, persistenceData.archiveType.toString(), persistenceData.minKeep != -1 ? Integer.valueOf(persistenceData.minKeep) : "*", persistenceData.maxKeep != -1 ? Integer.valueOf(persistenceData.maxKeep) : "*", persistenceData.maxAge != -1 ? Integer.valueOf(persistenceData.maxAge) : "*", persistenceData.moveTo.getURI()), 0, valueMap);
                persistenceData.id = valueMap.getInt("id");
            }
            catch (Exception exception) {
                Dialogs.error(this.shell, BARControl.tr("Cannot add persistence entry:\n\n{0}", exception.getMessage()));
                BARControl.logThrowable(exception);
                return;
            }
            this.updatePersistenceTree(this.selectedJobData);
        }
    }

    private void persistenceListUpdate(PersistenceData persistenceData) {
        if (this.selectedJobData != null) {
            try {
                BARServer.executeCommand(StringParser.format("PERSISTENCE_LIST_UPDATE jobUUID=%s id=%d archiveType=%s minKeep=%s maxKeep=%s maxAge=%s moveTo=%'s", this.selectedJobData.uuid, persistenceData.id, persistenceData.archiveType.toString(), persistenceData.minKeep != -1 ? Integer.valueOf(persistenceData.minKeep) : "*", persistenceData.maxKeep != -1 ? Integer.valueOf(persistenceData.maxKeep) : "*", persistenceData.maxAge != -1 ? Integer.valueOf(persistenceData.maxAge) : "*", persistenceData.moveTo.getURI()), 0);
            }
            catch (Exception exception) {
                Dialogs.error(this.shell, BARControl.tr("Cannot update persistence data:\n\n{0}", exception.getMessage()));
                BARControl.logThrowable(exception);
                return;
            }
            this.updatePersistenceTree(this.selectedJobData);
        }
    }

    private void persistenceListRemove(PersistenceData persistenceData) {
        if (this.selectedJobData != null) {
            try {
                BARServer.executeCommand(StringParser.format("PERSISTENCE_LIST_REMOVE jobUUID=%s id=%d", this.selectedJobData.uuid, persistenceData.id), 0);
            }
            catch (Exception exception) {
                Dialogs.error(this.shell, BARControl.tr("Cannot remove persistence data:\n\n{0}", exception.getMessage()));
                BARControl.logThrowable(exception);
                return;
            }
            this.updatePersistenceTree(this.selectedJobData);
        }
    }

    private void persistenceListAdd() {
        PersistenceData persistenceData;
        if (this.selectedJobData != null && this.persistenceEdit(persistenceData = new PersistenceData(), BARControl.tr("Add new persistence", new Object[0]), BARControl.tr("Add", new Object[0]))) {
            this.persistenceListAdd(persistenceData);
        }
    }

    private void persistenceListEdit() {
        PersistenceData persistenceData;
        TreeItem[] treeItemArray;
        if (this.selectedJobData != null && (treeItemArray = this.widgetPersistenceTree.getSelection()).length > 0 && treeItemArray[0].getData() instanceof PersistenceData && this.persistenceEdit(persistenceData = (PersistenceData)treeItemArray[0].getData(), BARControl.tr("Edit persistence", new Object[0]), BARControl.tr("Save", new Object[0]))) {
            this.persistenceListUpdate(persistenceData);
        }
    }

    private void persistenceListClone() {
        PersistenceData persistenceData;
        PersistenceData persistenceData2;
        TreeItem[] treeItemArray;
        if (this.selectedJobData != null && (treeItemArray = this.widgetPersistenceTree.getSelection()).length > 0 && this.persistenceEdit(persistenceData2 = (persistenceData = (PersistenceData)treeItemArray[0].getData()).clone(), BARControl.tr("Clone persistence", new Object[0]), BARControl.tr("Add", new Object[0]))) {
            this.persistenceListAdd(persistenceData2);
        }
    }

    private void persistenceListRemove() {
        TreeItem[] treeItemArray;
        if (this.selectedJobData != null && (treeItemArray = this.widgetPersistenceTree.getSelection()).length > 0 && (treeItemArray.length == 1 || Dialogs.confirm(this.shell, BARControl.tr("Remove {0} persistence {0,choice,0#entries|1#entry|1<entries}?", treeItemArray.length)))) {
            for (TreeItem treeItem : treeItemArray) {
                Comparable comparable;
                if (treeItem.getData() instanceof PersistenceData) {
                    comparable = (PersistenceData)treeItem.getData();
                    this.persistenceListRemove((PersistenceData)comparable);
                    continue;
                }
                if (!(treeItem.getData() instanceof EntityIndexData) || !this.deleteEntity((EntityIndexData)(comparable = (EntityIndexData)treeItem.getData()))) continue;
                Widgets.removeTreeItem(this.widgetPersistenceTree, comparable);
            }
        }
    }

    private void showEntityIndexToolTip(EntityIndexData entityIndexData, int n, int n2) {
        if (this.widgetPersistenceTreeToolTip != null) {
            this.widgetPersistenceTreeToolTip.dispose();
        }
        if (entityIndexData != null) {
            Label label;
            this.widgetPersistenceTreeToolTip = new Shell(this.shell, 540676);
            this.widgetPersistenceTreeToolTip.setBackground(this.COLOR_INFO_BACKGROUND);
            this.widgetPersistenceTreeToolTip.setLayout(new TableLayout(0.0, new double[]{0.0, 1.0}, 2));
            Widgets.layout(this.widgetPersistenceTreeToolTip, 0, 0, 15);
            int n3 = 0;
            if (Settings.debugLevel > 0) {
                assert ((entityIndexData.id & 0xFL) == 2L) : entityIndexData;
                label = Widgets.newLabel((Composite)this.widgetPersistenceTreeToolTip, BARControl.tr("Entity id", new Object[0]) + ":");
                label.setForeground(this.COLOR_INFO_FOREGROUND);
                label.setBackground(this.COLOR_INFO_BACKGROUND);
                Widgets.layout(label, n3, 0, 4);
                label = Widgets.newLabel((Composite)this.widgetPersistenceTreeToolTip, Long.toString(entityIndexData.id >> 4));
                label.setForeground(this.COLOR_INFO_FOREGROUND);
                label.setBackground(this.COLOR_INFO_BACKGROUND);
                Widgets.layout(label, n3, 1, 12);
                label = Widgets.newLabel((Composite)this.widgetPersistenceTreeToolTip, BARControl.tr("Schedule UUID", new Object[0]) + ":");
                label.setForeground(this.COLOR_INFO_FOREGROUND);
                label.setBackground(this.COLOR_INFO_BACKGROUND);
                Widgets.layout(label, ++n3, 0, 4);
                label = Widgets.newLabel((Composite)this.widgetPersistenceTreeToolTip, entityIndexData.scheduleUUID);
                label.setForeground(this.COLOR_INFO_FOREGROUND);
                label.setBackground(this.COLOR_INFO_BACKGROUND);
                Widgets.layout(label, n3, 1, 12);
                ++n3;
            }
            label = Widgets.newLabel((Composite)this.widgetPersistenceTreeToolTip, BARControl.tr("Created", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetPersistenceTreeToolTip, entityIndexData.createdDateTime > 0L ? this.SIMPLE_DATE_FORMAT.format(new Date(entityIndexData.createdDateTime * 1000L)) : "-");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 1, 12);
            label = Widgets.newLabel((Composite)this.widgetPersistenceTreeToolTip, BARControl.tr("Total size", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, ++n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetPersistenceTreeToolTip, String.format(BARControl.tr("{0} ({1} {1,choice,0#bytes|1#byte|1<bytes})", Units.formatByteSize(entityIndexData.getTotalSize()), entityIndexData.getTotalSize()), new Object[0]));
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 1, 12);
            label = Widgets.newLabel((Composite)this.widgetPersistenceTreeToolTip, BARControl.tr("Total entries", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, ++n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetPersistenceTreeToolTip, BARControl.tr("{0}", entityIndexData.getTotalEntryCount()));
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 1, 12);
            label = Widgets.newLabel((Composite)this.widgetPersistenceTreeToolTip, BARControl.tr("Total entries size", new Object[0]) + ":");
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, ++n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetPersistenceTreeToolTip, String.format(BARControl.tr("{0} ({1} {1,choice,0#bytes|1#byte|1<bytes})", Units.formatByteSize(entityIndexData.getTotalEntrySize()), entityIndexData.getTotalEntrySize()), new Object[0]));
            label.setForeground(this.COLOR_INFO_FOREGROUND);
            label.setBackground(this.COLOR_INFO_BACKGROUND);
            Widgets.layout(label, n3, 1, 12);
            ++n3;
            Point point = this.widgetPersistenceTreeToolTip.computeSize(-1, -1);
            this.widgetPersistenceTreeToolTip.setBounds(n, n2, point.x, point.y);
            this.widgetPersistenceTreeToolTip.setVisible(true);
            this.shell.addMouseTrackListener(new MouseTrackListener(){

                @Override
                public void mouseEnter(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseExit(MouseEvent mouseEvent) {
                    if (TabJobs.this.widgetPersistenceTreeToolTip != null) {
                        Point point = TabJobs.this.shell.toDisplay(new Point(mouseEvent.x, mouseEvent.y));
                        if (TabJobs.this.widgetPersistenceTreeToolTip.getBounds().contains(point)) {
                            return;
                        }
                        for (Control control : TabJobs.this.widgetPersistenceTreeToolTip.getChildren()) {
                            if (!control.getBounds().contains(point)) continue;
                            return;
                        }
                        TabJobs.this.widgetPersistenceTreeToolTip.dispose();
                        TabJobs.this.widgetPersistenceTreeToolTip = null;
                    }
                }

                @Override
                public void mouseHover(MouseEvent mouseEvent) {
                }
            });
        }
    }

    private void refreshEntityIndex(EntityIndexData entityIndexData) {
        if (this.selectedJobData != null) {
            try {
                BARServer.executeCommand(StringParser.format("INDEX_REFRESH state=* entityId=%lld", entityIndexData.id), 0);
            }
            catch (Exception exception) {
                Dialogs.error(this.shell, BARControl.tr("Cannot refresh entity index data:\n\n{0}", exception.getMessage()));
                BARControl.logThrowable(exception);
                return;
            }
        }
    }

    private void removeEntityIndex(EntityIndexData entityIndexData) {
        if (this.selectedJobData != null) {
            BARControl.waitCursor();
            try {
                BARServer.executeCommand(StringParser.format("INDEX_REMOVE state=* entityId=%lld", entityIndexData.id), 0);
            }
            catch (Exception exception) {
                Dialogs.error(this.shell, BARControl.tr("Cannot remove entity index data:\n\n{0}", exception.getMessage()));
                BARControl.logThrowable(exception);
                return;
            }
            finally {
                BARControl.resetCursor();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private boolean deleteEntity(EntityIndexData var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    class StorageFileNameEditor {
        final Display display;
        final Color textForegroundColor;
        final Color textBackgroundColor;
        final Color textHighlightColor;
        final Color separatorForegroundColor;
        final Color separatorBackgroundColor;
        final Color separatorHighlightColor;
        final Canvas widgetFileName;
        final Label widgetExample;
        final Text widgetText;
        LinkedList<StorageNamePart> storageNamePartList = new LinkedList();
        StorageNamePart selectedNamePart = null;
        StorageNamePart highlightedNamePart = null;

        StorageFileNameEditor(Composite composite, String string) {
            this.display = composite.getDisplay();
            this.textForegroundColor = this.display.getSystemColor(2);
            this.textBackgroundColor = this.display.getSystemColor(15);
            this.textHighlightColor = new Color(null, 250, 10, 10);
            this.separatorForegroundColor = this.textForegroundColor;
            this.separatorBackgroundColor = new Color(null, 173, 216, 230);
            this.separatorHighlightColor = this.textHighlightColor;
            Composite composite2 = Widgets.newComposite(composite, 0);
            composite2.setLayout(new TableLayout(0.0, new double[]{0.0, 1.0, 0.0}));
            Widgets.layout(composite2, 0, 0, 12);
            Label label = Widgets.newLabel(composite2, BARControl.tr("File name", new Object[0]) + ":");
            Widgets.layout(label, 0, 0, 4);
            this.widgetFileName = Widgets.newCanvas(composite2, 2048);
            this.widgetFileName.setToolTipText(BARControl.tr("Drag to trashcan icon to the right to remove name part.", new Object[0]));
            this.widgetFileName.setBackground(composite2.getDisplay().getSystemColor(1));
            Widgets.layout(this.widgetFileName, 0, 1, 12, 0, 0, 0, 0, -1, Widgets.getTextHeight(this.widgetFileName) + 5);
            this.widgetFileName.addMouseTrackListener(new MouseTrackListener(){

                @Override
                public void mouseEnter(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseExit(MouseEvent mouseEvent) {
                    StorageFileNameEditor.this.clearHighlight();
                }

                @Override
                public void mouseHover(MouseEvent mouseEvent) {
                }
            });
            this.widgetFileName.addMouseMoveListener(new MouseMoveListener(){

                @Override
                public void mouseMove(MouseEvent mouseEvent) {
                    Point point = new Point(mouseEvent.x, mouseEvent.y);
                    StorageFileNameEditor.this.setHighlight(point);
                }
            });
            this.widgetFileName.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (StorageFileNameEditor.this.highlightedNamePart != null && StorageFileNameEditor.this.highlightedNamePart.string != null && (Widgets.isAccelerator(keyEvent, 127) || Widgets.isAccelerator(keyEvent, 8))) {
                        StorageFileNameEditor.this.remPart(StorageFileNameEditor.this.highlightedNamePart);
                    }
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                }
            });
            DragSource dragSource = new DragSource(this.widgetFileName, 2);
            dragSource.setTransfer(new Transfer[]{StorageNamePartTransfer.getInstance()});
            dragSource.addDragListener(new DragSourceListener(){

                @Override
                public void dragStart(DragSourceEvent dragSourceEvent) {
                    Point point = new Point(dragSourceEvent.x, dragSourceEvent.y);
                    StorageNamePart storageNamePart = StorageFileNameEditor.this.getPart(point);
                    if (storageNamePart != null && storageNamePart.string != null) {
                        StorageFileNameEditor.this.selectedNamePart = storageNamePart;
                    } else {
                        dragSourceEvent.doit = false;
                    }
                }

                @Override
                public void dragSetData(DragSourceEvent dragSourceEvent) {
                    dragSourceEvent.data = StorageFileNameEditor.this.selectedNamePart;
                }

                @Override
                public void dragFinished(DragSourceEvent dragSourceEvent) {
                    if (dragSourceEvent.detail == 2) {
                        StorageFileNameEditor.this.remPart(StorageFileNameEditor.this.selectedNamePart);
                    }
                    StorageFileNameEditor.this.selectedNamePart = null;
                    StorageFileNameEditor.this.widgetFileName.redraw();
                }
            });
            DropTarget dropTarget = new DropTarget(this.widgetFileName, 3);
            dropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance(), StorageNamePartTransfer.getInstance()});
            dropTarget.addDropListener(new DropTargetAdapter(){

                @Override
                public void dragLeave(DropTargetEvent dropTargetEvent) {
                    StorageFileNameEditor.this.clearHighlight();
                }

                @Override
                public void dragOver(DropTargetEvent dropTargetEvent) {
                    Point point = StorageFileNameEditor.this.display.map(null, StorageFileNameEditor.this.widgetFileName, dropTargetEvent.x, dropTargetEvent.y);
                    StorageFileNameEditor.this.setHighlight(point);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void drop(DropTargetEvent dropTargetEvent) {
                    if (dropTargetEvent.data != null) {
                        Point point = StorageFileNameEditor.this.display.map(null, StorageFileNameEditor.this.widgetFileName, dropTargetEvent.x, dropTargetEvent.y);
                        LinkedList<StorageNamePart> linkedList = StorageFileNameEditor.this.storageNamePartList;
                        synchronized (linkedList) {
                            int n;
                            for (n = 0; n < StorageFileNameEditor.this.storageNamePartList.size() && !StorageFileNameEditor.this.storageNamePartList.get((int)n).bounds.contains(point); ++n) {
                            }
                            if (dropTargetEvent.data instanceof StorageNamePart) {
                                StorageFileNameEditor.this.addParts(n, ((StorageNamePart)dropTargetEvent.data).string);
                            } else if (dropTargetEvent.data instanceof String) {
                                StorageFileNameEditor.this.addParts(n, (String)dropTargetEvent.data);
                            }
                        }
                    } else {
                        dropTargetEvent.detail = 0;
                    }
                }
            });
            this.widgetFileName.addPaintListener(new PaintListener(){

                @Override
                public void paintControl(PaintEvent paintEvent) {
                    StorageFileNameEditor.this.redraw(paintEvent);
                }
            });
            Label label2 = Widgets.newImage(composite2, TabJobs.this.IMAGE_TRASHCAN, 2048);
            label2.setToolTipText(BARControl.tr("Use drag&drop to remove name parts.", new Object[0]));
            Widgets.layout(label2, 0, 2, 0);
            dropTarget = new DropTarget(label2, 2);
            dropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance(), StorageNamePartTransfer.getInstance()});
            dropTarget.addDropListener(new DropTargetAdapter(){

                @Override
                public void dragLeave(DropTargetEvent dropTargetEvent) {
                }

                @Override
                public void dragOver(DropTargetEvent dropTargetEvent) {
                }

                @Override
                public void drop(DropTargetEvent dropTargetEvent) {
                    if (dropTargetEvent.data != null) {
                        if (!(dropTargetEvent.data instanceof String) && !(dropTargetEvent.data instanceof StorageNamePart)) {
                            dropTargetEvent.detail = 0;
                        }
                    } else {
                        dropTargetEvent.detail = 0;
                    }
                }
            });
            label = Widgets.newLabel(composite2, BARControl.tr("Example", new Object[0]) + ":");
            Widgets.layout(label, 1, 0, 4);
            this.widgetExample = Widgets.newView(composite2);
            Widgets.layout(this.widgetExample, 1, 1, 12, 0, 2);
            composite2 = Widgets.newComposite(composite, 0);
            composite2.setToolTipText(BARControl.tr("Use drag&drop to add name parts.", new Object[0]));
            composite2.setLayout(new TableLayout(0.0, new double[]{0.0, 0.4, 0.0, 0.4, 0.0, 0.2}));
            Widgets.layout(composite2, 1, 0, 15);
            this.addDragAndDrop(composite2, "-", "'-'", 0, 0);
            this.addDragAndDrop(composite2, "_", "'_'", 1, 0);
            this.addDragAndDrop(composite2, BARServer.filePathSeparator, BARServer.filePathSeparator, 2, 0);
            this.addDragAndDrop(composite2, ".bar", "'.bar'", 3, 0);
            Composite composite3 = Widgets.newComposite(composite2, 0);
            composite3.setToolTipText(BARControl.tr("Use drag&drop to add name parts.", new Object[0]));
            composite3.setLayout(new TableLayout(0.0, new double[]{1.0, 0.0}));
            this.widgetText = Widgets.newText(composite3);
            Widgets.layout(this.widgetText, 0, 0, 12);
            Button button = Widgets.newButton(composite3, TabJobs.this.IMAGE_DIRECTORY);
            button.setToolTipText(BARControl.tr("Select remote file. CTRL+click to select local file.", new Object[0]));
            Widgets.layout(button, 0, 1, 0);
            button.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    String string = Dialogs.file(TabJobs.this.shell, Dialogs.FileDialogTypes.ENTRY, BARControl.tr("Select source file", new Object[0]), StorageFileNameEditor.this.widgetText.getText(), new String[]{BARControl.tr("BAR files", new Object[0]), "*.bar", BARControl.tr("All files", new Object[0]), BARControl.ALL_FILE_EXTENSION}, "*", 0, (selectionEvent.stateMask & 0x40000) == 0 ? BARServer.remoteListDirectory(((TabJobs)TabJobs.this).selectedJobData.uuid) : BARControl.listDirectory);
                    if (string != null) {
                        StorageFileNameEditor.this.widgetText.setText(string);
                    }
                }
            });
            this.addDragAndDrop(composite2, "Text", composite3, this.widgetText, 4, 0);
            this.addDragAndDrop(composite2, "#", BARControl.tr("part number 1 digit", new Object[0]), 6, 0);
            this.addDragAndDrop(composite2, "##", BARControl.tr("part number 2 digits", new Object[0]), 7, 0);
            this.addDragAndDrop(composite2, "###", BARControl.tr("part number 3 digits", new Object[0]), 8, 0);
            this.addDragAndDrop(composite2, "####", BARControl.tr("part number 4 digits", new Object[0]), 9, 0);
            this.addDragAndDrop(composite2, "%type", BARControl.tr("archive type: full\n,incremental\n,differential\n,continuous", new Object[0]), 11, 0);
            this.addDragAndDrop(composite2, "%T", BARControl.tr("archive type short: F, I, D, C", new Object[0]), 12, 0);
            this.addDragAndDrop(composite2, "%uuid", BARControl.tr("universally unique identifier", new Object[0]), 13, 0);
            this.addDragAndDrop(composite2, "%text", BARControl.tr("schedule custom text", new Object[0]), 14, 0);
            this.addDragAndDrop(composite2, "%d", BARControl.tr("day 01..31", new Object[0]), 0, 1);
            this.addDragAndDrop(composite2, "%j", BARControl.tr("day of year 001..366", new Object[0]), 1, 1);
            this.addDragAndDrop(composite2, "%m", BARControl.tr("month 01..12", new Object[0]), 2, 1);
            this.addDragAndDrop(composite2, "%b", BARControl.tr("month name", new Object[0]), 3, 1);
            this.addDragAndDrop(composite2, "%B", BARControl.tr("full month name", new Object[0]), 4, 1);
            this.addDragAndDrop(composite2, "%H", BARControl.tr("hour 00..23", new Object[0]), 5, 1);
            this.addDragAndDrop(composite2, "%I", BARControl.tr("hour 00..12", new Object[0]), 6, 1);
            this.addDragAndDrop(composite2, "%M", BARControl.tr("minute 00..59", new Object[0]), 7, 1);
            this.addDragAndDrop(composite2, "%S", BARControl.tr("seconds 00..59", new Object[0]), 8, 1);
            this.addDragAndDrop(composite2, "%p", BARControl.tr("'AM' or 'PM'", new Object[0]), 9, 1);
            this.addDragAndDrop(composite2, "%P", BARControl.tr("'am' or 'pm'", new Object[0]), 10, 1);
            this.addDragAndDrop(composite2, "%a", BARControl.tr("week day name", new Object[0]), 11, 1);
            this.addDragAndDrop(composite2, "%A", BARControl.tr("full week day name", new Object[0]), 12, 1);
            this.addDragAndDrop(composite2, "%u", BARControl.tr("day of week 1..7", new Object[0]), 13, 1);
            this.addDragAndDrop(composite2, "%w", BARControl.tr("day of week 0..6", new Object[0]), 14, 1);
            this.addDragAndDrop(composite2, "%U", BARControl.tr("week number 00..53 starting with Sunday", new Object[0]), 15, 1);
            this.addDragAndDrop(composite2, "%U2", BARControl.tr("week number 1 or 2 starting with Sunday", new Object[0]), 16, 1);
            this.addDragAndDrop(composite2, "%U4", BARControl.tr("week number 1, 2, 3, 4 starting with Sunday", new Object[0]), 17, 1);
            this.addDragAndDrop(composite2, "%W", BARControl.tr("week number 00..53 starting with Monday", new Object[0]), 18, 1);
            this.addDragAndDrop(composite2, "%W2", BARControl.tr("week number 1 or 2 starting with Monday", new Object[0]), 19, 1);
            this.addDragAndDrop(composite2, "%W4", BARControl.tr("week number 1, 2, 3, 4 starting with Monday", new Object[0]), 20, 1);
            this.addDragAndDrop(composite2, "%C", BARControl.tr("century two digits", new Object[0]), 21, 1);
            this.addDragAndDrop(composite2, "%y", BARControl.tr("year two digits", new Object[0]), 22, 1);
            this.addDragAndDrop(composite2, "%Y", BARControl.tr("year four digits", new Object[0]), 23, 1);
            this.addDragAndDrop(composite2, "%s", BARControl.tr("seconds since 1.1.1970 00:00", new Object[0]), 24, 1);
            this.addDragAndDrop(composite2, "%Z", BARControl.tr("time-zone abbreviation", new Object[0]), 25, 1);
            this.addDragAndDrop(composite2, "%%", "%", 0, 2);
            this.addDragAndDrop(composite2, "%#", "#", 1, 2);
            this.addDragAndDrop(composite2, "%:", ":", 2, 2);
            this.addDragAndDrop(composite2, "%Y-%m-%d", BARControl.tr("Date YYYY-MM-DD", new Object[0]), 4, 2);
            this.addDragAndDrop(composite2, "%H%:%M%:%S", BARControl.tr("Time hh:mm:ss", new Object[0]), 5, 2);
            this.setFileName(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setFileName(String string) {
            LinkedList<StorageNamePart> linkedList = this.storageNamePartList;
            synchronized (linkedList) {
                this.storageNamePartList.clear();
                this.storageNamePartList.add(new StorageNamePart(null));
                StringBuilder stringBuilder = new StringBuilder();
                int n = 0;
                block9: while (n < string.length()) {
                    switch (string.charAt(n)) {
                        case '%': {
                            stringBuilder = new StringBuilder();
                            stringBuilder.append('%');
                            if (++n < string.length()) {
                                if (string.charAt(n) == '%') {
                                    stringBuilder.append('%');
                                    ++n;
                                } else if (string.charAt(n) == ':') {
                                    stringBuilder.append(':');
                                    ++n;
                                } else {
                                    while (n < string.length() && Character.isLetterOrDigit(string.charAt(n))) {
                                        stringBuilder.append(string.charAt(n));
                                        ++n;
                                    }
                                }
                            }
                            this.storageNamePartList.add(new StorageNamePart(stringBuilder.toString()));
                            this.storageNamePartList.add(new StorageNamePart(null));
                            continue block9;
                        }
                        case '#': {
                            stringBuilder = new StringBuilder();
                            while (n < string.length() && string.charAt(n) == '#') {
                                stringBuilder.append(string.charAt(n));
                                ++n;
                            }
                            this.storageNamePartList.add(new StorageNamePart(stringBuilder.toString()));
                            this.storageNamePartList.add(new StorageNamePart(null));
                            continue block9;
                        }
                        case '-': 
                        case '/': {
                            this.storageNamePartList.add(new StorageNamePart(string.charAt(n)));
                            this.storageNamePartList.add(new StorageNamePart(null));
                            ++n;
                            continue block9;
                        }
                        case '.': {
                            stringBuilder = new StringBuilder();
                            stringBuilder.append('.');
                            ++n;
                            while (n < string.length() && string.charAt(n) != '%' && string.charAt(n) != '#' && string.charAt(n) != '/') {
                                stringBuilder.append(string.charAt(n));
                                ++n;
                            }
                            this.storageNamePartList.add(new StorageNamePart(stringBuilder.toString()));
                            this.storageNamePartList.add(new StorageNamePart(null));
                            continue block9;
                        }
                    }
                    stringBuilder = new StringBuilder();
                    while (n < string.length() && string.charAt(n) != '%' && string.charAt(n) != '#' && string.charAt(n) != '/' && string.charAt(n) != '-' && string.charAt(n) != '.') {
                        stringBuilder.append(string.charAt(n));
                        ++n;
                    }
                    this.storageNamePartList.add(new StorageNamePart(stringBuilder.toString()));
                    this.storageNamePartList.add(new StorageNamePart(null));
                }
            }
            this.widgetFileName.redraw();
            this.updateExample();
        }

        String getFileName() {
            StringBuilder stringBuilder = new StringBuilder();
            for (StorageNamePart storageNamePart : this.storageNamePartList) {
                if (storageNamePart.string == null) continue;
                stringBuilder.append(storageNamePart.string);
            }
            return stringBuilder.toString();
        }

        private void addDragAndDrop(Composite composite, String string, String string2, int n, int n2) {
            Label label = Widgets.newLabel(composite, string, 18432);
            label.setBackground(composite.getDisplay().getSystemColor(15));
            label.setData(string);
            Widgets.layout(label, n, n2 * 2 + 0, 4);
            DragSource dragSource = new DragSource(label, 3);
            dragSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
            dragSource.addDragListener(new DragSourceListener(){

                @Override
                public void dragStart(DragSourceEvent dragSourceEvent) {
                }

                @Override
                public void dragSetData(DragSourceEvent dragSourceEvent) {
                    Control control = ((DragSource)dragSourceEvent.widget).getControl();
                    dragSourceEvent.data = (String)control.getData();
                }

                @Override
                public void dragFinished(DragSourceEvent dragSourceEvent) {
                }
            });
            label = Widgets.newLabel(composite, string2, 16384);
            Widgets.layout(label, n, n2 * 2 + 1, 12);
        }

        private void addDragAndDrop(Composite composite, char c, char c2, int n, int n2) {
            this.addDragAndDrop(composite, Character.toString(c), Character.toString(c2), n, n2);
        }

        private void addDragAndDrop(Composite composite, String string, Control control, Control control2, int n, int n2) {
            Label label = Widgets.newLabel(composite, string, 18432);
            label.setBackground(composite.getDisplay().getSystemColor(15));
            label.setData(control2);
            Widgets.layout(label, n, n2 * 2 + 0, 4);
            DragSource dragSource = new DragSource(label, 3);
            dragSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
            dragSource.addDragListener(new DragSourceListener(){

                @Override
                public void dragStart(DragSourceEvent dragSourceEvent) {
                    String string;
                    Control control = ((DragSource)dragSourceEvent.widget).getControl();
                    Widget widget = (Widget)control.getData();
                    if (widget instanceof Text && ((string = ((Text)widget).getText()) == null || string.length() == 0)) {
                        dragSourceEvent.doit = false;
                    }
                }

                @Override
                public void dragSetData(DragSourceEvent dragSourceEvent) {
                    Control control = ((DragSource)dragSourceEvent.widget).getControl();
                    Widget widget = (Widget)control.getData();
                    if (widget instanceof Text) {
                        dragSourceEvent.data = ((Text)widget).getText();
                        if (dragSourceEvent.data.equals("")) {
                            dragSourceEvent.doit = false;
                        }
                    }
                }

                @Override
                public void dragFinished(DragSourceEvent dragSourceEvent) {
                }
            });
            Widgets.layout(control, n, n2 * 2 + 1, 12);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addParts(int n, String string) {
            boolean bl = false;
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = 0;
            block7: while (n2 < string.length()) {
                StringBuilder stringBuilder;
                switch (string.charAt(n2)) {
                    case '%': {
                        stringBuilder = new StringBuilder();
                        stringBuilder.append('%');
                        if (++n2 < string.length()) {
                            if (string.charAt(n2) == '%') {
                                stringBuilder.append('%');
                                ++n2;
                            } else if (string.charAt(n2) == ':') {
                                stringBuilder.append(':');
                                ++n2;
                            } else {
                                while (n2 < string.length() && Character.isLetterOrDigit(string.charAt(n2))) {
                                    stringBuilder.append(string.charAt(n2));
                                    ++n2;
                                }
                            }
                        }
                        arrayList.add(stringBuilder.toString());
                        continue block7;
                    }
                    case '#': {
                        stringBuilder = new StringBuilder();
                        while (n2 < string.length() && string.charAt(n2) == '#') {
                            stringBuilder.append(string.charAt(n2));
                            ++n2;
                        }
                        arrayList.add(stringBuilder.toString());
                        continue block7;
                    }
                }
                stringBuilder = new StringBuilder();
                while (n2 < string.length() && string.charAt(n2) != '%' && string.charAt(n2) != '#') {
                    stringBuilder.append(string.charAt(n2));
                    ++n2;
                }
                arrayList.add(stringBuilder.toString());
            }
            LinkedList<StorageNamePart> linkedList = this.storageNamePartList;
            synchronized (linkedList) {
                if (n < this.storageNamePartList.size()) {
                    if (this.storageNamePartList.get((int)n).string != null) {
                        if (arrayList.size() > 0) {
                            this.storageNamePartList.get((int)n).string = (String)arrayList.get(0);
                        }
                        for (int i = 1; i < arrayList.size(); ++i) {
                            this.storageNamePartList.add(n + 1, new StorageNamePart(null));
                            this.storageNamePartList.add(n + 2, new StorageNamePart((String)arrayList.get(i)));
                            n += 2;
                        }
                    } else {
                        for (String string2 : arrayList) {
                            this.storageNamePartList.add(n + 1, new StorageNamePart(string2));
                            this.storageNamePartList.add(n + 2, new StorageNamePart(null));
                            n += 2;
                        }
                    }
                } else {
                    for (String string3 : arrayList) {
                        this.storageNamePartList.add(new StorageNamePart(string3));
                        this.storageNamePartList.add(new StorageNamePart(null));
                    }
                }
                bl = true;
            }
            if (bl) {
                this.widgetFileName.redraw();
                this.updateExample();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remPart(StorageNamePart storageNamePart) {
            boolean bl = false;
            LinkedList<StorageNamePart> linkedList = this.storageNamePartList;
            synchronized (linkedList) {
                int n;
                for (n = 0; n < this.storageNamePartList.size() && this.storageNamePartList.get(n) != storageNamePart; ++n) {
                }
                if (n < this.storageNamePartList.size()) {
                    this.storageNamePartList.remove(n);
                    if (n < this.storageNamePartList.size() && this.storageNamePartList.get((int)n).string == null) {
                        this.storageNamePartList.remove(n);
                    }
                    bl = true;
                }
            }
            if (bl) {
                this.widgetFileName.redraw();
                this.updateExample();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void redraw(PaintEvent paintEvent) {
            GC gC = paintEvent.gc;
            Rectangle rectangle = this.widgetFileName.getClientArea();
            int n = 0;
            LinkedList<StorageNamePart> linkedList = this.storageNamePartList;
            synchronized (linkedList) {
                for (StorageNamePart storageNamePart : this.storageNamePartList) {
                    Color color;
                    if (storageNamePart.string != null) {
                        Point point = Widgets.getTextSize((Control)this.widgetFileName, storageNamePart.string);
                        color = storageNamePart == this.highlightedNamePart || storageNamePart == this.selectedNamePart ? this.textHighlightColor : this.textBackgroundColor;
                        gC.setBackground(color);
                        gC.setForeground(this.textForegroundColor);
                        gC.drawString(storageNamePart.string, n, 0);
                        storageNamePart.bounds = new Rectangle(n, 0, point.x, rectangle.height);
                        n += point.x;
                        continue;
                    }
                    color = storageNamePart == this.highlightedNamePart ? this.separatorHighlightColor : this.separatorBackgroundColor;
                    gC.setBackground(color);
                    gC.fillRectangle(n, 0, 8, rectangle.height - 1);
                    gC.setForeground(this.separatorForegroundColor);
                    gC.drawRectangle(n, 0, 8, rectangle.height - 1);
                    storageNamePart.bounds = new Rectangle(n, 0, 8, rectangle.height);
                    n += 9;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateExample() {
            StringBuilder stringBuilder = new StringBuilder();
            LinkedList<StorageNamePart> linkedList = this.storageNamePartList;
            synchronized (linkedList) {
                for (StorageNamePart storageNamePart : this.storageNamePartList) {
                    if (storageNamePart.string == null) continue;
                    if (storageNamePart.string.startsWith("#")) {
                        for (int i = 0; i < storageNamePart.string.length() && storageNamePart.string.charAt(i) == '#'; ++i) {
                            stringBuilder.append("1234567890".charAt(i % 10));
                        }
                        continue;
                    }
                    if (storageNamePart.string.equals("%type")) {
                        stringBuilder.append("full");
                        continue;
                    }
                    if (storageNamePart.string.equals("%T")) {
                        stringBuilder.append("F");
                        continue;
                    }
                    if (storageNamePart.string.equals("%last")) {
                        stringBuilder.append("-last");
                        continue;
                    }
                    if (storageNamePart.string.equals("%uuid")) {
                        stringBuilder.append("9f4aebd5-40a5-4056-8cf1-8be316638685");
                        continue;
                    }
                    if (storageNamePart.string.equals("%text")) {
                        stringBuilder.append("foo");
                        continue;
                    }
                    if (storageNamePart.string.equals("%d")) {
                        stringBuilder.append("24");
                        continue;
                    }
                    if (storageNamePart.string.equals("%j")) {
                        stringBuilder.append("354");
                        continue;
                    }
                    if (storageNamePart.string.equals("%m")) {
                        stringBuilder.append("12");
                        continue;
                    }
                    if (storageNamePart.string.equals("%b")) {
                        stringBuilder.append("Dec");
                        continue;
                    }
                    if (storageNamePart.string.equals("%B")) {
                        stringBuilder.append("December");
                        continue;
                    }
                    if (storageNamePart.string.equals("%H")) {
                        stringBuilder.append("23");
                        continue;
                    }
                    if (storageNamePart.string.equals("%I")) {
                        stringBuilder.append("11");
                        continue;
                    }
                    if (storageNamePart.string.equals("%M")) {
                        stringBuilder.append("55");
                        continue;
                    }
                    if (storageNamePart.string.equals("%S")) {
                        stringBuilder.append("34");
                        continue;
                    }
                    if (storageNamePart.string.equals("%p")) {
                        stringBuilder.append("PM");
                        continue;
                    }
                    if (storageNamePart.string.equals("%P")) {
                        stringBuilder.append("pm");
                        continue;
                    }
                    if (storageNamePart.string.equals("%a")) {
                        stringBuilder.append("Mon");
                        continue;
                    }
                    if (storageNamePart.string.equals("%A")) {
                        stringBuilder.append("Monday");
                        continue;
                    }
                    if (storageNamePart.string.equals("%u")) {
                        stringBuilder.append("1");
                        continue;
                    }
                    if (storageNamePart.string.equals("%w")) {
                        stringBuilder.append("0");
                        continue;
                    }
                    if (storageNamePart.string.equals("%U")) {
                        stringBuilder.append("51");
                        continue;
                    }
                    if (storageNamePart.string.equals("%U2")) {
                        stringBuilder.append("1");
                        continue;
                    }
                    if (storageNamePart.string.equals("%U4")) {
                        stringBuilder.append("3");
                        continue;
                    }
                    if (storageNamePart.string.equals("%W")) {
                        stringBuilder.append("51");
                        continue;
                    }
                    if (storageNamePart.string.equals("%W2")) {
                        stringBuilder.append("1");
                        continue;
                    }
                    if (storageNamePart.string.equals("%W4")) {
                        stringBuilder.append("3");
                        continue;
                    }
                    if (storageNamePart.string.equals("%C")) {
                        stringBuilder.append("20");
                        continue;
                    }
                    if (storageNamePart.string.equals("%y")) {
                        stringBuilder.append("07");
                        continue;
                    }
                    if (storageNamePart.string.equals("%Y")) {
                        stringBuilder.append("2007");
                        continue;
                    }
                    if (storageNamePart.string.equals("%s")) {
                        stringBuilder.append("1198598100");
                        continue;
                    }
                    if (storageNamePart.string.equals("%Z")) {
                        stringBuilder.append("JST");
                        continue;
                    }
                    if (storageNamePart.string.equals("%%")) {
                        stringBuilder.append("%");
                        continue;
                    }
                    if (storageNamePart.string.equals("%#")) {
                        stringBuilder.append("#");
                        continue;
                    }
                    if (storageNamePart.string.equals("%:")) {
                        stringBuilder.append(":");
                        continue;
                    }
                    stringBuilder.append(storageNamePart.string);
                }
            }
            this.widgetExample.setText(stringBuilder.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private StorageNamePart getPart(Point point) {
            LinkedList<StorageNamePart> linkedList = this.storageNamePartList;
            synchronized (linkedList) {
                for (StorageNamePart storageNamePart : this.storageNamePartList) {
                    if (!storageNamePart.bounds.contains(point)) continue;
                    return storageNamePart;
                }
            }
            return null;
        }

        private void clearHighlight() {
            if (this.highlightedNamePart != null) {
                this.highlightedNamePart = null;
                this.widgetFileName.redraw();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setHighlight(Point point) {
            boolean bl = false;
            LinkedList<StorageNamePart> linkedList = this.storageNamePartList;
            synchronized (linkedList) {
                StorageNamePart storageNamePart = this.getPart(point);
                if (this.highlightedNamePart != null && storageNamePart != this.highlightedNamePart) {
                    this.highlightedNamePart = null;
                    bl = true;
                }
                if (storageNamePart != null) {
                    this.highlightedNamePart = storageNamePart;
                    bl = true;
                }
            }
            if (bl) {
                this.widgetFileName.redraw();
            }
        }
    }

    static class StorageNamePartTransfer
    extends ByteArrayTransfer {
        private static final String NAME = "StorageNamePart";
        private static final int ID = StorageNamePartTransfer.registerType("StorageNamePart");
        private static StorageNamePartTransfer instance = new StorageNamePartTransfer();

        StorageNamePartTransfer() {
        }

        public static StorageNamePartTransfer getInstance() {
            return instance;
        }

        @Override
        public void javaToNative(Object object, TransferData transferData) {
            if (!this.validate(object) || !this.isSupportedType(transferData)) {
                DND.error(2003);
            }
            StorageNamePart storageNamePart = (StorageNamePart)object;
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(storageNamePart);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                objectOutputStream.close();
                super.javaToNative(byArray, transferData);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public Object nativeToJava(TransferData transferData) {
            if (this.isSupportedType(transferData)) {
                byte[] byArray = (byte[])super.nativeToJava(transferData);
                if (byArray == null) {
                    return null;
                }
                StorageNamePart storageNamePart = null;
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                    storageNamePart = (StorageNamePart)objectInputStream.readObject();
                    objectInputStream.close();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
                catch (IOException iOException) {
                    return null;
                }
                return storageNamePart;
            }
            return null;
        }

        @Override
        protected String[] getTypeNames() {
            return new String[]{NAME};
        }

        @Override
        protected int[] getTypeIds() {
            return new int[]{ID};
        }

        @Override
        protected boolean validate(Object object) {
            return object != null && object instanceof StorageNamePart;
        }
    }

    class StorageNamePart
    implements Serializable {
        String string;
        Rectangle bounds;

        StorageNamePart(String string) {
            this.string = string;
            this.bounds = new Rectangle(0, 0, 0, 0);
        }

        StorageNamePart(char c) {
            this.string = String.valueOf(c);
            this.bounds = new Rectangle(0, 0, 0, 0);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeObject(this.string);
            objectOutputStream.writeObject(this.bounds);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.string = (String)objectInputStream.readObject();
            this.bounds = (Rectangle)objectInputStream.readObject();
        }

        public String toString() {
            return "StorageNamePart {string=" + this.string + ", " + this.bounds + "}";
        }
    }

    class EntityIndexData
    implements Comparable<EntityIndexData> {
        public long id;
        public String scheduleUUID;
        public long createdDateTime;
        public long totalSize;
        public long totalEntryCount;
        public long totalEntrySize;
        public boolean inTransit;

        EntityIndexData(long l, String string, long l2, long l3, long l4, long l5, boolean bl) {
            assert ((l & 0xFL) == 2L) : l;
            this.id = l;
            this.scheduleUUID = string;
            this.createdDateTime = l2;
            this.totalSize = l3;
            this.totalEntryCount = l4;
            this.totalEntrySize = l5;
            this.inTransit = bl;
        }

        @Override
        public int compareTo(EntityIndexData entityIndexData) {
            int n = this.id == entityIndexData.id ? 0 : (this.createdDateTime > entityIndexData.createdDateTime ? -1 : (this.createdDateTime < entityIndexData.createdDateTime ? 1 : 0));
            return n;
        }

        public String getName() {
            return TabJobs.this.archiveType.toString();
        }

        public long getDateTime() {
            return this.createdDateTime;
        }

        public long getTotalSize() {
            return this.totalSize;
        }

        public long getTotalEntryCount() {
            return this.totalEntryCount;
        }

        public long getTotalEntrySize() {
            return this.totalEntrySize;
        }

        public boolean equals(Object object) {
            EntityIndexData entityIndexData = (EntityIndexData)object;
            return entityIndexData != null && this.id == entityIndexData.id;
        }

        public String toString() {
            return "EntityIndexData {id=" + this.id + ", createdDateTime=" + this.createdDateTime + "}";
        }
    }

    static class PersistenceDataComparator
    implements Comparator<PersistenceData> {
        private SortModes sortMode;

        PersistenceDataComparator(Tree tree, TreeColumn treeColumn) {
            this.sortMode = tree.getColumn(0) == treeColumn ? SortModes.ARCHIVE_TYPE : (tree.getColumn(1) == treeColumn ? SortModes.MIN_KEEP : (tree.getColumn(2) == treeColumn ? SortModes.MAX_KEEP : (tree.getColumn(3) == treeColumn ? SortModes.MAX_AGE : SortModes.MAX_AGE)));
        }

        PersistenceDataComparator(Tree tree) {
            TreeColumn treeColumn = tree.getSortColumn();
            this.sortMode = tree.getColumn(0) == treeColumn ? SortModes.ARCHIVE_TYPE : (tree.getColumn(1) == treeColumn ? SortModes.MIN_KEEP : (tree.getColumn(2) == treeColumn ? SortModes.MAX_KEEP : (tree.getColumn(3) == treeColumn ? SortModes.MAX_AGE : SortModes.MAX_AGE)));
        }

        PersistenceDataComparator(SortModes sortModes) {
            this.sortMode = sortModes;
        }

        @Override
        public int compare(PersistenceData persistenceData, PersistenceData persistenceData2) {
            EnumSet<SortModes> enumSet = EnumSet.allOf(SortModes.class);
            int n = this.compare(this.sortMode, persistenceData, persistenceData2);
            enumSet.remove((Object)this.sortMode);
            for (SortModes sortModes : enumSet) {
                if (n == 0) {
                    n = this.compare(sortModes, persistenceData, persistenceData2);
                }
                if (n == 0) continue;
                break;
            }
            return n;
        }

        private int compare(SortModes sortModes, PersistenceData persistenceData, PersistenceData persistenceData2) {
            int n = 0;
            switch (sortModes) {
                case ARCHIVE_TYPE: {
                    n = persistenceData.archiveType.compareTo(persistenceData2.archiveType);
                    break;
                }
                case MIN_KEEP: {
                    if (persistenceData.minKeep != -1 && persistenceData2.minKeep != -1) {
                        if (persistenceData.minKeep < persistenceData2.minKeep) {
                            n = -1;
                            break;
                        }
                        if (persistenceData.minKeep <= persistenceData2.minKeep) break;
                        n = 1;
                        break;
                    }
                    if (persistenceData.minKeep != -1) {
                        n = 1;
                        break;
                    }
                    if (persistenceData2.minKeep == -1) break;
                    n = -1;
                    break;
                }
                case MAX_KEEP: {
                    if (persistenceData.maxKeep != -1 && persistenceData2.maxKeep != -1) {
                        if (persistenceData.maxKeep < persistenceData2.maxKeep) {
                            n = -1;
                            break;
                        }
                        if (persistenceData.maxKeep <= persistenceData2.maxKeep) break;
                        n = 1;
                        break;
                    }
                    if (persistenceData.maxKeep != -1) {
                        n = 1;
                        break;
                    }
                    if (persistenceData2.maxKeep == -1) break;
                    n = -1;
                    break;
                }
                case MAX_AGE: {
                    if (persistenceData.maxAge != -1 && persistenceData2.maxAge != -1) {
                        if (persistenceData.maxAge < persistenceData2.maxAge) {
                            n = -1;
                            break;
                        }
                        if (persistenceData.maxAge <= persistenceData2.maxAge) break;
                        n = 1;
                        break;
                    }
                    if (persistenceData.maxAge != -1) {
                        n = -1;
                        break;
                    }
                    if (persistenceData2.maxAge == -1) break;
                    n = 1;
                }
            }
            return n;
        }

        static enum SortModes {
            ARCHIVE_TYPE,
            MIN_KEEP,
            MAX_KEEP,
            MAX_AGE;

        }
    }

    class PersistenceData
    implements Cloneable,
    Comparable {
        int id;
        ArchiveTypes archiveType;
        int minKeep;
        int maxKeep;
        int maxAge;
        URIParts moveTo;

        PersistenceData(int n, ArchiveTypes archiveTypes, int n2, int n3, int n4, URIParts uRIParts) {
            this.id = n;
            this.archiveType = archiveTypes;
            this.minKeep = n2;
            this.maxKeep = n3;
            this.maxAge = n4;
            this.moveTo = uRIParts;
        }

        PersistenceData(int n, ArchiveTypes archiveTypes, int n2, int n3, int n4, String string) {
            this(n, archiveTypes, n2, n3, n4, new URIParts(string));
        }

        PersistenceData(ArchiveTypes archiveTypes, int n, int n2, int n3, URIParts uRIParts) {
            this(0, archiveTypes, n, n2, n3, uRIParts);
        }

        PersistenceData(ArchiveTypes archiveTypes, int n, int n2, int n3, String string) {
            this(archiveTypes, n, n2, n3, new URIParts(string));
        }

        PersistenceData() {
            this(ArchiveTypes.NORMAL, 0, -1, -1, "");
        }

        public PersistenceData clone() {
            return new PersistenceData(this.archiveType, this.minKeep, this.maxKeep, this.maxAge, this.moveTo.clone());
        }

        ArchiveTypes getArchiveType() {
            return this.archiveType;
        }

        int getMinKeep() {
            return this.minKeep;
        }

        void setMinKeep(int n) {
            this.minKeep = n;
        }

        int getMaxKeep() {
            return this.minKeep;
        }

        void setMaxKeep(int n) {
            this.maxKeep = n;
        }

        int getMaxAge() {
            return this.maxAge;
        }

        void setMaxAge(int n) {
            this.maxAge = n;
        }

        URIParts getMoveTo() {
            return this.moveTo;
        }

        void setMoveTo(URIParts uRIParts) {
            this.moveTo = uRIParts;
        }

        public boolean equals(Object object) {
            PersistenceData persistenceData = (PersistenceData)object;
            return persistenceData != null && this.id == persistenceData.id;
        }

        public int compareTo(Object object) {
            PersistenceData persistenceData = (PersistenceData)object;
            int n = this.archiveType.compareTo(persistenceData.archiveType);
            if (n == 0) {
                if (this.maxAge != -1 && persistenceData.maxAge != -1) {
                    if (this.maxAge < persistenceData.maxAge) {
                        return -1;
                    }
                    if (this.maxAge > persistenceData.maxAge) {
                        return 1;
                    }
                    return 0;
                }
                if (this.maxAge != -1) {
                    return -1;
                }
                if (persistenceData.maxAge != -1) {
                    return 1;
                }
            }
            return n;
        }

        public String toString() {
            return "PersistenceData { archiveType=" + (Object)((Object)this.archiveType) + ", minKeep=" + this.minKeep + ", maxKeep=" + this.maxKeep + ", maxAge=" + this.maxAge + "}";
        }
    }

    static class ScheduleDataComparator
    implements Comparator<ScheduleData> {
        private SortModes sortMode;

        ScheduleDataComparator(Table table, TableColumn tableColumn) {
            this.sortMode = table.getColumn(0) == tableColumn ? SortModes.DATE : (table.getColumn(1) == tableColumn ? SortModes.WEEKDAY : (table.getColumn(2) == tableColumn ? SortModes.TIME : (table.getColumn(3) == tableColumn ? SortModes.ARCHIVE_TYPE : (table.getColumn(4) == tableColumn ? SortModes.BEGIN_TIME : (table.getColumn(5) == tableColumn ? SortModes.END_TIME : (table.getColumn(6) == tableColumn ? SortModes.CUSTOM_TEXT : (table.getColumn(7) == tableColumn ? SortModes.ENABLED : SortModes.DATE)))))));
        }

        ScheduleDataComparator(Table table) {
            TableColumn tableColumn = table.getSortColumn();
            this.sortMode = table.getColumn(0) == tableColumn ? SortModes.DATE : (table.getColumn(1) == tableColumn ? SortModes.WEEKDAY : (table.getColumn(2) == tableColumn ? SortModes.TIME : (table.getColumn(3) == tableColumn ? SortModes.ARCHIVE_TYPE : (table.getColumn(4) == tableColumn ? SortModes.BEGIN_TIME : (table.getColumn(5) == tableColumn ? SortModes.END_TIME : (table.getColumn(6) == tableColumn ? SortModes.CUSTOM_TEXT : (table.getColumn(7) == tableColumn ? SortModes.ENABLED : SortModes.DATE)))))));
        }

        @Override
        public int compare(ScheduleData scheduleData, ScheduleData scheduleData2) {
            EnumSet<SortModes> enumSet = EnumSet.allOf(SortModes.class);
            int n = this.compare(this.sortMode, scheduleData, scheduleData2);
            enumSet.remove((Object)this.sortMode);
            for (SortModes sortModes : enumSet) {
                if (n == 0) {
                    n = this.compare(sortModes, scheduleData, scheduleData2);
                }
                if (n == 0) continue;
                break;
            }
            return n;
        }

        private int indexOfWeekDay(String string) {
            int n;
            String[] stringArray = new String[]{"mon", "tue", "wed", "thu", "fri", "sat", "sun"};
            for (n = 0; n < stringArray.length && !stringArray[n].equals(string); ++n) {
            }
            return n;
        }

        private int compare(SortModes sortModes, ScheduleData scheduleData, ScheduleData scheduleData2) {
            int n = 0;
            switch (sortModes) {
                case DATE: {
                    String string = scheduleData.getDate();
                    String string2 = scheduleData2.getDate();
                    n = string.compareTo(string2);
                    break;
                }
                case WEEKDAY: {
                    if (scheduleData.weekDays < scheduleData2.weekDays) {
                        n = -1;
                        break;
                    }
                    if (scheduleData.weekDays > scheduleData2.weekDays) {
                        n = 1;
                        break;
                    }
                    n = 0;
                    break;
                }
                case TIME: {
                    String string = scheduleData.getTime();
                    String string3 = scheduleData2.getTime();
                    n = string.compareTo(string3);
                    break;
                }
                case ARCHIVE_TYPE: {
                    n = scheduleData.archiveType.compareTo(scheduleData2.archiveType);
                    break;
                }
                case BEGIN_TIME: {
                    String string = scheduleData.getBeginTime();
                    String string4 = scheduleData2.getBeginTime();
                    n = string.compareTo(string4);
                    break;
                }
                case END_TIME: {
                    String string = scheduleData.getEndTime();
                    String string5 = scheduleData2.getEndTime();
                    n = string.compareTo(string5);
                    break;
                }
                case CUSTOM_TEXT: {
                    n = scheduleData.customText.compareTo(scheduleData2.customText);
                    break;
                }
                case ENABLED: {
                    if (scheduleData.enabled && !scheduleData2.enabled) {
                        n = -1;
                        break;
                    }
                    if (!scheduleData.enabled && scheduleData2.enabled) {
                        n = 1;
                        break;
                    }
                    n = 0;
                    break;
                }
            }
            return n;
        }

        static enum SortModes {
            DATE,
            WEEKDAY,
            TIME,
            ARCHIVE_TYPE,
            BEGIN_TIME,
            END_TIME,
            CUSTOM_TEXT,
            TEST_CREATED_ARCHIVES,
            NO_STORAGE,
            ENABLED;

        }
    }

    class ScheduleData
    implements Cloneable,
    Comparable<ScheduleData> {
        static final int NONE = 0;
        static final int ANY = -1;
        static final int MON = 0;
        static final int TUE = 1;
        static final int WED = 2;
        static final int THU = 3;
        static final int FRI = 4;
        static final int SAT = 5;
        static final int SUN = 6;
        String uuid;
        int year;
        int month;
        int day;
        int weekDays;
        int hour;
        int minute;
        ArchiveTypes archiveType;
        int interval;
        int beginHour;
        int beginMinute;
        int endHour;
        int endMinute;
        String customText;
        boolean testCreatedArchives;
        boolean noStorage;
        boolean enabled;
        long lastExecutedDateTime;
        long totalEntities;
        long totalEntryCount;
        long totalEntrySize;

        ScheduleData(String string, int n, int n2, int n3, int n4, int n5, int n6, ArchiveTypes archiveTypes, int n7, int n8, int n9, int n10, int n11, String string2, boolean bl, boolean bl2, boolean bl3, long l, long l2, long l3, long l4) {
            this.uuid = string;
            this.year = n;
            this.month = n2;
            this.day = n3;
            this.weekDays = n4;
            this.hour = n5;
            this.minute = n6;
            this.archiveType = archiveTypes;
            this.interval = n7;
            this.beginHour = n8;
            this.beginMinute = n9;
            this.endHour = n10;
            this.endMinute = n11;
            this.customText = string2;
            this.testCreatedArchives = bl;
            this.noStorage = bl2;
            this.enabled = bl3;
            this.lastExecutedDateTime = l;
            this.totalEntities = l2;
            this.totalEntryCount = l3;
            this.totalEntrySize = l4;
        }

        ScheduleData() {
            this(null, -1, -1, -1, -1, -1, -1, ArchiveTypes.NORMAL, 0, -1, -1, -1, -1, "", false, false, true, 0L, 0L, 0L, 0L);
        }

        ScheduleData(String string, String string2, String string3, String string4, ArchiveTypes archiveTypes, int n, String string5, String string6, String string7, boolean bl, boolean bl2, boolean bl3, long l, long l2, long l3, long l4) {
            this.uuid = string;
            this.setDate(string2);
            this.setWeekDays(string3);
            this.setTime(string4);
            this.archiveType = archiveTypes;
            this.interval = n;
            this.setBeginTime(string5);
            this.setEndTime(string6);
            this.customText = string7;
            this.testCreatedArchives = bl;
            this.noStorage = bl2;
            this.enabled = bl3;
            this.lastExecutedDateTime = l;
            this.totalEntities = l2;
            this.totalEntryCount = l3;
            this.totalEntrySize = l4;
        }

        ScheduleData(String string, String string2, String string3, String string4, ArchiveTypes archiveTypes) {
            this(string, string2, string3, string4, archiveTypes, 0, "", "", "", false, false, true, 0L, 0L, 0L, 0L);
        }

        public ScheduleData clone() {
            return new ScheduleData(this.uuid, this.year, this.month, this.day, this.weekDays, this.hour, this.minute, this.archiveType, this.interval, this.beginHour, this.beginMinute, this.endHour, this.endMinute, this.customText, this.testCreatedArchives, this.noStorage, this.enabled, this.lastExecutedDateTime, this.totalEntities, this.totalEntryCount, this.totalEntrySize);
        }

        @Override
        public int compareTo(ScheduleData scheduleData) {
            return this.uuid.compareTo(scheduleData.uuid);
        }

        String getDate() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getYear());
            stringBuilder.append('-');
            stringBuilder.append(this.getMonth());
            stringBuilder.append('-');
            stringBuilder.append(this.getDay());
            return stringBuilder.toString();
        }

        private void setDate(String string, String string2, String string3) {
            this.year = !string.equals("*") ? Integer.parseInt(string) : -1;
            this.month = !string2.equals("*") ? Integer.parseInt(string2) : -1;
            int n = this.day = !string3.equals("*") ? Integer.parseInt(string3) : -1;
            assert (this.year == -1 || this.year >= 0) : this.hour;
            assert (this.month == -1 || this.month >= 1 && this.month <= 12) : this.hour;
            assert (this.day == -1 || this.day >= 1 && this.day <= 31) : this.hour;
        }

        private void setDate(String string) {
            String[] stringArray = string.split("-");
            this.setDate(stringArray[0], stringArray[1], stringArray[2]);
        }

        String getYear() {
            assert (this.year == -1 || this.year >= 1) : this.year;
            return this.year != -1 ? String.format("%04d", this.year) : "*";
        }

        String getMonth() {
            assert (this.month == -1 || this.month >= 1 && this.month <= 12) : this.month;
            return this.month != -1 ? String.format("%02d", this.month) : "*";
        }

        String getDay() {
            assert (this.day == -1 || this.day >= 1 && this.day <= 31) : this.day;
            return this.day != -1 ? String.format("%02d", this.day) : "*";
        }

        String getWeekDays() {
            assert (this.weekDays == -1 || (this.weekDays & 0xFFFFFF80) == 0) : this.weekDays;
            if (this.weekDays == -1) {
                return "*";
            }
            StringBuilder stringBuilder = new StringBuilder();
            if ((this.weekDays & 1) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(BARControl.tr("Mon", new Object[0]));
            }
            if ((this.weekDays & 2) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(BARControl.tr("Tue", new Object[0]));
            }
            if ((this.weekDays & 4) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(BARControl.tr("Wed", new Object[0]));
            }
            if ((this.weekDays & 8) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(BARControl.tr("Thu", new Object[0]));
            }
            if ((this.weekDays & 0x10) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(BARControl.tr("Fri", new Object[0]));
            }
            if ((this.weekDays & 0x20) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(BARControl.tr("Sat", new Object[0]));
            }
            if ((this.weekDays & 0x40) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(BARControl.tr("Sun", new Object[0]));
            }
            return stringBuilder.toString();
        }

        void setWeekDays(String string) {
            if (string.equals("*")) {
                this.weekDays = -1;
            } else {
                this.weekDays = 0;
                for (String string2 : string.split(",")) {
                    if (string2.toLowerCase().equals("mon")) {
                        this.weekDays |= 1;
                        continue;
                    }
                    if (string2.toLowerCase().equals("tue")) {
                        this.weekDays |= 2;
                        continue;
                    }
                    if (string2.toLowerCase().equals("wed")) {
                        this.weekDays |= 4;
                        continue;
                    }
                    if (string2.toLowerCase().equals("thu")) {
                        this.weekDays |= 8;
                        continue;
                    }
                    if (string2.toLowerCase().equals("fri")) {
                        this.weekDays |= 0x10;
                        continue;
                    }
                    if (string2.toLowerCase().equals("sat")) {
                        this.weekDays |= 0x20;
                        continue;
                    }
                    if (!string2.toLowerCase().equals("sun")) continue;
                    this.weekDays |= 0x40;
                }
            }
        }

        void setWeekDays(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
            if (bl && bl2 && bl3 && bl4 && bl5 && bl6 && bl7) {
                this.weekDays = -1;
            } else {
                this.weekDays = 0;
                if (bl) {
                    this.weekDays |= 1;
                }
                if (bl2) {
                    this.weekDays |= 2;
                }
                if (bl3) {
                    this.weekDays |= 4;
                }
                if (bl4) {
                    this.weekDays |= 8;
                }
                if (bl5) {
                    this.weekDays |= 0x10;
                }
                if (bl6) {
                    this.weekDays |= 0x20;
                }
                if (bl7) {
                    this.weekDays |= 0x40;
                }
            }
        }

        String getBeginHour() {
            assert (this.beginHour == -1 || this.beginHour >= 0 && this.beginHour <= 23) : this.beginHour;
            return this.beginHour != -1 ? String.format("%02d", this.beginHour) : "*";
        }

        String getHour() {
            assert (this.hour == -1 || this.hour >= 0 && this.hour <= 23) : this.hour;
            return this.hour != -1 ? String.format("%02d", this.hour) : "*";
        }

        String getMinute() {
            assert (this.minute == -1 || this.minute >= 0 && this.minute <= 59) : this.minute;
            return this.minute != -1 ? String.format("%02d", this.minute) : "*";
        }

        String getTime() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getHour());
            stringBuilder.append(':');
            stringBuilder.append(this.getMinute());
            return stringBuilder.toString();
        }

        void setTime(String string, String string2) {
            this.hour = !string.equals("*") ? Integer.parseInt(string, 10) : -1;
            int n = this.minute = !string2.equals("*") ? Integer.parseInt(string2, 10) : -1;
            assert (this.hour == -1 || this.hour >= 0 && this.hour <= 23) : this.hour;
            assert (this.minute == -1 || this.minute >= 0 && this.minute <= 59) : this.minute;
        }

        void setTime(String string) {
            String[] stringArray = string.split(":");
            this.setTime(stringArray[0], stringArray[1]);
        }

        ArchiveTypes getArchiveType() {
            return this.archiveType;
        }

        String getBeginMinute() {
            assert (this.endMinute == -1 || this.endMinute >= 0 && this.endMinute <= 59) : this.endMinute;
            return this.endMinute != -1 ? String.format("%02d", this.endMinute) : "*";
        }

        String getBeginTime() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getBeginHour());
            stringBuilder.append(':');
            stringBuilder.append(this.getBeginMinute());
            return stringBuilder.toString();
        }

        void setBeginTime(String string, String string2) {
            this.beginHour = !string.equals("*") ? Integer.parseInt(string, 10) : -1;
            int n = this.beginMinute = !string2.equals("*") ? Integer.parseInt(string2, 10) : -1;
            assert (this.beginHour == -1 || this.beginHour >= 0 && this.beginHour <= 23) : this.beginHour;
            assert (this.beginMinute == -1 || this.beginMinute >= 0 && this.beginMinute <= 59) : this.beginMinute;
        }

        void setBeginTime(String string) {
            String[] stringArray = string.split(":");
            this.setBeginTime(stringArray[0], stringArray[1]);
        }

        String getEndHour() {
            assert (this.endHour == -1 || this.endHour >= 0 && this.endHour <= 23) : this.endHour;
            return this.endHour != -1 ? String.format("%02d", this.endHour) : "*";
        }

        String getEndMinute() {
            assert (this.endMinute == -1 || this.endMinute >= 0 && this.endMinute <= 59) : this.endMinute;
            return this.endMinute != -1 ? String.format("%02d", this.endMinute) : "*";
        }

        String getEndTime() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getEndHour());
            stringBuilder.append(':');
            stringBuilder.append(this.getEndMinute());
            return stringBuilder.toString();
        }

        void setEndTime(String string, String string2) {
            this.endHour = !string.equals("*") ? Integer.parseInt(string, 10) : -1;
            int n = this.endMinute = !string2.equals("*") ? Integer.parseInt(string2, 10) : -1;
            assert (this.endHour == -1 || this.endHour >= 0 && this.endHour <= 23) : this.endHour;
            assert (this.endMinute == -1 || this.endMinute >= 0 && this.endMinute <= 59) : this.endMinute;
        }

        void setEndTime(String string) {
            String[] stringArray = string.split(":");
            this.setEndTime(stringArray[0], stringArray[1]);
        }

        boolean weekDayIsEnabled(int n) {
            assert (n == 0 || n == 1 || n == 2 || n == 3 || n == 4 || n == 5 || n == 6);
            return this.weekDays == -1 || (this.weekDays & 1 << n) != 0;
        }

        boolean isNoStorage() {
            return this.noStorage;
        }

        boolean isEnabled() {
            return this.enabled;
        }

        String weekDaysToString() {
            assert (this.weekDays == -1 || (this.weekDays & 0xFFFFFF80) == 0) : this.weekDays;
            if (this.weekDays == -1) {
                return "*";
            }
            StringBuilder stringBuilder = new StringBuilder();
            if ((this.weekDays & 1) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append("Mon");
            }
            if ((this.weekDays & 2) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append("Tue");
            }
            if ((this.weekDays & 4) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append("Wed");
            }
            if ((this.weekDays & 8) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append("Thu");
            }
            if ((this.weekDays & 0x10) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append("Fri");
            }
            if ((this.weekDays & 0x20) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append("Sat");
            }
            if ((this.weekDays & 0x40) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append("Sun");
            }
            return stringBuilder.toString();
        }

        public String toString() {
            return "ScheduleData {" + this.uuid + ", " + this.getDate() + ", " + this.getWeekDays() + ", " + this.getTime() + ", " + (Object)((Object)this.archiveType) + ", " + this.noStorage + ", " + this.enabled + "}";
        }

        private String getValidString(String string, String[] stringArray, String string2) {
            for (String string3 : stringArray) {
                if (!string3.equals(string)) continue;
                return string3;
            }
            return string2;
        }
    }

    static class MountDataComparator
    implements Comparator<MountData> {
        MountDataComparator(Table table) {
        }

        @Override
        public int compare(MountData mountData, MountData mountData2) {
            return mountData.name.compareTo(mountData2.name);
        }
    }

    class MountData
    implements Cloneable,
    Comparable<MountData> {
        int id;
        String name;
        String device;

        MountData(int n, String string, String string2) {
            this.id = n;
            this.name = string;
            this.device = string2;
        }

        MountData(String string, String string2) {
            this(0, string, string2);
        }

        MountData(String string) {
            this(0, string, null);
        }

        public MountData clone() {
            return new MountData(this.name, this.device);
        }

        @Override
        public int compareTo(MountData mountData) {
            if (this.id < mountData.id) {
                return -1;
            }
            if (this.id > mountData.id) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return "MountData {" + this.id + ", " + this.name + ", " + this.device + "}";
        }
    }

    class PatternData {
        PatternTypes type;
        String pattern;

        PatternData(PatternTypes patternTypes, String string) {
            this.type = patternTypes;
            this.pattern = string;
        }
    }

    static class EntryDataComparator
    implements Comparator<EntryData> {
        EntryDataComparator(Table table) {
        }

        @Override
        public int compare(EntryData entryData, EntryData entryData2) {
            return entryData.pattern.compareTo(entryData2.pattern);
        }
    }

    class EntryData
    implements Cloneable {
        EntryStoreTypes entryStoreType;
        String pattern;

        EntryData(EntryStoreTypes entryStoreTypes, String string) {
            this.entryStoreType = entryStoreTypes;
            this.pattern = string;
        }

        EntryData(EntryStoreTypes entryStoreTypes) {
            this(entryStoreTypes, null);
        }

        public EntryData clone() {
            return new EntryData(this.entryStoreType, this.pattern);
        }

        Image getImage() {
            Image image = null;
            switch (this.entryStoreType) {
                case FILE: {
                    image = TabJobs.this.IMAGE_FILE;
                    break;
                }
                case IMAGE: {
                    image = TabJobs.this.IMAGE_DEVICE;
                }
            }
            return image;
        }

        public String toString() {
            return "Entry {" + (Object)((Object)this.entryStoreType) + ", " + this.pattern + "}";
        }
    }

    class DirectoryInfoThread
    extends Thread {
        private final int DEFAULT_TIMEOUT = 1000;
        private final int TIMEOUT_DETLA = 2000;
        private final int MAX_TIMEOUT = 5000;
        private Display display;
        private LinkedList<DirectoryInfoRequest> directoryInfoRequestList;

        DirectoryInfoThread(Display display) {
            this.display = display;
            this.directoryInfoRequestList = new LinkedList();
            this.setDaemon(true);
            this.setName("BARControl Directory Info");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                while (true) {
                    boolean bl;
                    long l;
                    final Object[] objectArray = this.directoryInfoRequestList;
                    // MONITORENTER : this.directoryInfoRequestList
                    while (this.directoryInfoRequestList.size() == 0) {
                        try {
                            this.directoryInfoRequestList.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    final DirectoryInfoRequest directoryInfoRequest = this.directoryInfoRequestList.remove();
                    // MONITOREXIT : objectArray
                    if (!TabJobs.this.directorySizesFlag && !directoryInfoRequest.forceFlag) continue;
                    objectArray = new Object[]{null};
                    this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            TreeItem treeItem = directoryInfoRequest.treeItem;
                            objectArray[0] = treeItem.isDisposed();
                        }
                    });
                    if (((Boolean)objectArray[0]).booleanValue()) continue;
                    try {
                        ValueMap valueMap = new ValueMap();
                        BARServer.executeCommand(StringParser.format("DIRECTORY_INFO jobUUID=%s name=%'S timeout=%d", directoryInfoRequest.jobUUID != null ? directoryInfoRequest.jobUUID : "", directoryInfoRequest.name, directoryInfoRequest.timeout), 0, valueMap);
                        long l2 = valueMap.getLong("count");
                        l = valueMap.getLong("size");
                        bl = valueMap.getBoolean("timedOut");
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            TreeItem treeItem = directoryInfoRequest.treeItem;
                            if (!treeItem.isDisposed()) {
                                FileTreeData fileTreeData = (FileTreeData)treeItem.getData();
                                fileTreeData.size = l;
                                treeItem.setText(2, Units.formatByteSize(l));
                                treeItem.setForeground(2, bl ? TabJobs.this.COLOR_RED : TabJobs.this.COLOR_BLACK);
                            }
                        }
                    });
                    if (!bl) continue;
                    if (directoryInfoRequest.timeout + 2000 <= 5000) {
                        directoryInfoRequest.timeout += 2000;
                    }
                    this.add(directoryInfoRequest);
                }
            }
            catch (Throwable throwable) {
                if (Settings.debugLevel <= 0) return;
                BARServer.disconnect();
                BARControl.internalError(throwable);
                return;
            }
        }

        public void add(String string, String string2, boolean bl, TreeItem treeItem, int n) {
            DirectoryInfoRequest directoryInfoRequest = new DirectoryInfoRequest(string, string2, bl, treeItem, n);
            this.add(directoryInfoRequest);
        }

        public void add(String string, String string2, TreeItem treeItem, int n) {
            DirectoryInfoRequest directoryInfoRequest = new DirectoryInfoRequest(string, string2, false, treeItem, n);
            this.add(directoryInfoRequest);
        }

        public void add(String string, String string2, boolean bl, TreeItem treeItem) {
            this.add(string, string2, bl, treeItem, 1000);
        }

        public void add(String string, String string2, TreeItem treeItem) {
            this.add(string, string2, false, treeItem, 1000);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            LinkedList<DirectoryInfoRequest> linkedList = this.directoryInfoRequestList;
            synchronized (linkedList) {
                this.directoryInfoRequestList.clear();
            }
        }

        private int getIndex(DirectoryInfoRequest directoryInfoRequest) {
            ListIterator listIterator = this.directoryInfoRequestList.listIterator();
            boolean bl = false;
            int n = 0;
            while (listIterator.hasNext() && !bl) {
                n = listIterator.nextIndex();
                DirectoryInfoRequest directoryInfoRequest2 = (DirectoryInfoRequest)listIterator.next();
                bl = directoryInfoRequest.depth > directoryInfoRequest2.depth || directoryInfoRequest.timeout < directoryInfoRequest2.timeout;
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(DirectoryInfoRequest directoryInfoRequest) {
            LinkedList<DirectoryInfoRequest> linkedList = this.directoryInfoRequestList;
            synchronized (linkedList) {
                int n = this.getIndex(directoryInfoRequest);
                this.directoryInfoRequestList.add(n, directoryInfoRequest);
                this.directoryInfoRequestList.notifyAll();
            }
        }

        class DirectoryInfoRequest {
            String jobUUID;
            String name;
            boolean forceFlag;
            int depth;
            int timeout;
            TreeItem treeItem;

            DirectoryInfoRequest(String string, String string2, boolean bl, TreeItem treeItem, int n) {
                this.jobUUID = string;
                this.name = string2;
                this.forceFlag = bl;
                this.depth = StringUtils.splitArray(string2, BARServer.filePathSeparator, true).length;
                this.timeout = n;
                this.treeItem = treeItem;
            }

            public String toString() {
                return "DirectoryInfoRequest {" + this.jobUUID + ", " + this.name + ", " + this.forceFlag + ", " + this.depth + ", " + this.timeout + "}";
            }
        }
    }

    static class DeviceDataComparator
    implements Comparator<DeviceData> {
        private SortModes sortMode;

        DeviceDataComparator(Table table, TableColumn tableColumn) {
            this.sortMode = table.getColumn(0) == tableColumn ? SortModes.NAME : (table.getColumn(1) == tableColumn ? SortModes.FILE_SYSTEM_TYPE : (table.getColumn(2) == tableColumn ? SortModes.SIZE : SortModes.NAME));
        }

        DeviceDataComparator(Table table) {
            this(table, table.getSortColumn());
        }

        @Override
        public int compare(DeviceData deviceData, DeviceData deviceData2) {
            switch (this.sortMode) {
                case NAME: {
                    return deviceData.name.compareTo(deviceData2.name);
                }
                case FILE_SYSTEM_TYPE: {
                    return deviceData.fileSystemType.compareTo(deviceData2.fileSystemType);
                }
                case SIZE: {
                    if (deviceData.size < deviceData2.size) {
                        return -1;
                    }
                    if (deviceData.size > deviceData2.size) {
                        return 1;
                    }
                    return 0;
                }
            }
            return 0;
        }

        public String toString() {
            return "DeviceDataComparator {" + (Object)((Object)this.sortMode) + "}";
        }

        static enum SortModes {
            NAME,
            FILE_SYSTEM_TYPE,
            SIZE;

        }
    }

    class DeviceData {
        String name;
        long size;
        String fileSystemType;

        DeviceData(String string, long l, String string2) {
            this.name = string;
            this.size = l;
            this.fileSystemType = string2;
        }

        DeviceData(String string) {
            this.name = string;
            this.size = 0L;
            this.fileSystemType = "";
        }

        public void include() {
            TabJobs.this.includeListAdd(new EntryData(EntryStoreTypes.IMAGE, this.name));
            TabJobs.this.excludeListRemove(this.name);
        }

        public void exclude() {
            TabJobs.this.includeListRemove(this.name);
            TabJobs.this.excludeListAdd(this.name);
        }

        public void none() {
            TabJobs.this.includeListRemove(this.name);
            TabJobs.this.excludeListRemove(this.name);
        }

        Image getImage() {
            Image image = null;
            image = TabJobs.this.isIncluded(this.name) && !TabJobs.this.isExcluded(this.name) ? TabJobs.this.IMAGE_DEVICE_INCLUDED : (TabJobs.this.isExcluded(this.name) ? TabJobs.this.IMAGE_DEVICE : TabJobs.this.IMAGE_DEVICE);
            return image;
        }

        public String toString() {
            return "DeviceData {" + this.name + ", " + this.size + " bytes, " + this.fileSystemType + "}";
        }
    }

    static class FileTreeDataComparator
    implements Comparator<FileTreeData> {
        static final SortModes[] SORT_MODE_SEQUENCE_NAME = new SortModes[]{SortModes.NAME, SortModes.TYPE, SortModes.SIZE, SortModes.DATETIME};
        static final SortModes[] SORT_MODE_SEQUENCE_TYPE = new SortModes[]{SortModes.TYPE, SortModes.NAME, SortModes.SIZE, SortModes.DATETIME};
        static final SortModes[] SORT_MODE_SEQUENCE_SIZE = new SortModes[]{SortModes.SIZE, SortModes.NAME, SortModes.TYPE, SortModes.DATETIME};
        static final SortModes[] SORT_MODE_SEQUENCE_DATETIME = new SortModes[]{SortModes.DATETIME, SortModes.NAME, SortModes.TYPE, SortModes.SIZE};
        private SortModes[] sortModeSequence;

        FileTreeDataComparator(Tree tree, TreeColumn treeColumn) {
            this.sortModeSequence = tree.getColumn(0) == treeColumn ? SORT_MODE_SEQUENCE_NAME : (tree.getColumn(1) == treeColumn ? SORT_MODE_SEQUENCE_TYPE : (tree.getColumn(2) == treeColumn ? SORT_MODE_SEQUENCE_SIZE : (tree.getColumn(3) == treeColumn ? SORT_MODE_SEQUENCE_DATETIME : SORT_MODE_SEQUENCE_NAME)));
        }

        FileTreeDataComparator(Tree tree) {
            this(tree, tree.getSortColumn());
        }

        @Override
        public int compare(FileTreeData fileTreeData, FileTreeData fileTreeData2) {
            int n = 0;
            for (int i = 0; i < this.sortModeSequence.length && n == 0; ++i) {
                if (this.sortModeSequence[i] == SortModes.NAME) {
                    if (fileTreeData.fileType == BARServer.FileTypes.DIRECTORY) {
                        if (fileTreeData2.fileType == BARServer.FileTypes.DIRECTORY) {
                            n = this.compareWithoutType(this.sortModeSequence[i], fileTreeData, fileTreeData2);
                            continue;
                        }
                        n = -1;
                        continue;
                    }
                    if (fileTreeData2.fileType == BARServer.FileTypes.DIRECTORY) {
                        n = 1;
                        continue;
                    }
                    n = this.compareWithoutType(this.sortModeSequence[i], fileTreeData, fileTreeData2);
                    continue;
                }
                n = this.compareWithoutType(this.sortModeSequence[i], fileTreeData, fileTreeData2);
            }
            return n;
        }

        public String toString() {
            return "FileTreeDataComparator {" + this.sortModeSequence + "}";
        }

        private int compareWithoutType(SortModes sortModes, FileTreeData fileTreeData, FileTreeData fileTreeData2) {
            switch (sortModes) {
                case NAME: {
                    return fileTreeData.title.compareTo(fileTreeData2.title);
                }
                case TYPE: {
                    return fileTreeData.fileType.compareTo(fileTreeData2.fileType);
                }
                case SIZE: {
                    if (fileTreeData.size < fileTreeData2.size) {
                        return -1;
                    }
                    if (fileTreeData.size > fileTreeData2.size) {
                        return 1;
                    }
                    return 0;
                }
                case DATETIME: {
                    if (fileTreeData.dateTime < fileTreeData2.dateTime) {
                        return -1;
                    }
                    if (fileTreeData.dateTime > fileTreeData2.dateTime) {
                        return 1;
                    }
                    return 0;
                }
            }
            return 0;
        }

        static enum SortModes {
            NAME,
            TYPE,
            SIZE,
            DATETIME;

        }
    }

    class FileTreeData {
        String name;
        BARServer.FileTypes fileType;
        long size;
        long dateTime;
        String title;
        BARServer.SpecialTypes specialType;
        boolean noBackup;
        boolean noDump;

        FileTreeData(String string, BARServer.FileTypes fileTypes, long l, long l2, String string2, BARServer.SpecialTypes specialTypes, boolean bl, boolean bl2) {
            this.name = string;
            this.fileType = fileTypes;
            this.size = l;
            this.dateTime = l2;
            this.title = string2;
            this.specialType = specialTypes;
            this.noBackup = bl;
            this.noDump = bl2;
        }

        FileTreeData(String string, BARServer.FileTypes fileTypes, long l, long l2, String string2, boolean bl, boolean bl2) {
            this(string, fileTypes, l, l2, string2, BARServer.SpecialTypes.NONE, bl, bl2);
        }

        FileTreeData(String string, BARServer.FileTypes fileTypes, long l, String string2, boolean bl, boolean bl2) {
            this(string, fileTypes, 0L, l, string2, bl, bl2);
        }

        FileTreeData(String string, BARServer.FileTypes fileTypes, String string2, boolean bl, boolean bl2) {
            this(string, fileTypes, 0L, string2, bl, bl2);
        }

        FileTreeData(String string, BARServer.SpecialTypes specialTypes, long l, long l2, String string2, boolean bl, boolean bl2) {
            this(string, BARServer.FileTypes.SPECIAL, l, l2, string2, specialTypes, bl, bl2);
        }

        FileTreeData(String string, BARServer.SpecialTypes specialTypes, long l, String string2, boolean bl, boolean bl2) {
            this(string, BARServer.FileTypes.SPECIAL, 0L, l, string2, specialTypes, bl, bl2);
        }

        Image getImage() {
            Image image = null;
            if (TabJobs.this.isIncluded(this.name) && !TabJobs.this.isExcluded(this.name)) {
                switch (this.fileType) {
                    case FILE: {
                        image = TabJobs.this.IMAGE_FILE_INCLUDED;
                        break;
                    }
                    case DIRECTORY: {
                        image = TabJobs.this.IMAGE_DIRECTORY_INCLUDED;
                        break;
                    }
                    case LINK: {
                        image = TabJobs.this.IMAGE_LINK_INCLUDED;
                        break;
                    }
                    case HARDLINK: {
                        image = TabJobs.this.IMAGE_LINK_INCLUDED;
                        break;
                    }
                    case SPECIAL: {
                        image = TabJobs.this.IMAGE_FILE_INCLUDED;
                    }
                }
            } else if (TabJobs.this.isExcluded(this.name) || this.noBackup || this.noDump) {
                switch (this.fileType) {
                    case FILE: {
                        image = TabJobs.this.IMAGE_FILE_EXCLUDED;
                        break;
                    }
                    case DIRECTORY: {
                        image = TabJobs.this.IMAGE_DIRECTORY_EXCLUDED;
                        break;
                    }
                    case LINK: {
                        image = TabJobs.this.IMAGE_LINK_EXCLUDED;
                        break;
                    }
                    case HARDLINK: {
                        image = TabJobs.this.IMAGE_LINK_EXCLUDED;
                        break;
                    }
                    case SPECIAL: {
                        image = TabJobs.this.IMAGE_FILE_EXCLUDED;
                    }
                }
            } else {
                block14 : switch (this.fileType) {
                    case FILE: {
                        image = TabJobs.this.IMAGE_FILE;
                        break;
                    }
                    case DIRECTORY: {
                        image = TabJobs.this.IMAGE_DIRECTORY;
                        break;
                    }
                    case LINK: {
                        image = TabJobs.this.IMAGE_LINK;
                        break;
                    }
                    case HARDLINK: {
                        image = TabJobs.this.IMAGE_LINK;
                        break;
                    }
                    case SPECIAL: {
                        switch (this.specialType) {
                            case DEVICE_CHARACTER: {
                                image = TabJobs.this.IMAGE_FILE;
                                break block14;
                            }
                            case DEVICE_BLOCK: {
                                image = TabJobs.this.IMAGE_FILE;
                                break block14;
                            }
                            case FIFO: {
                                image = TabJobs.this.IMAGE_FILE;
                                break block14;
                            }
                            case SOCKET: {
                                image = TabJobs.this.IMAGE_FILE;
                                break block14;
                            }
                            case OTHER: {
                                image = TabJobs.this.IMAGE_FILE;
                            }
                        }
                    }
                }
            }
            return image;
        }

        public void include() {
            TabJobs.this.includeListAdd(new EntryData(EntryStoreTypes.FILE, this.name));
            TabJobs.this.excludeListRemove(this.name);
            if (this.fileType == BARServer.FileTypes.DIRECTORY) {
                TabJobs.this.setNoBackup(this.name, false);
            }
            TabJobs.this.setNoDump(this.name, false);
            this.noBackup = false;
            this.noDump = false;
        }

        public void excludeByList() {
            TabJobs.this.includeListRemove(this.name);
            TabJobs.this.excludeListAdd(this.name);
            if (this.fileType == BARServer.FileTypes.DIRECTORY) {
                TabJobs.this.setNoBackup(this.name, false);
            }
            TabJobs.this.setNoDump(this.name, false);
            this.noBackup = false;
            this.noDump = false;
        }

        public void excludeByNoBackup() {
            TabJobs.this.includeListRemove(this.name);
            TabJobs.this.excludeListRemove(this.name);
            if (this.fileType == BARServer.FileTypes.DIRECTORY) {
                TabJobs.this.setNoBackup(this.name, true);
            }
            TabJobs.this.setNoDump(this.name, false);
            this.noBackup = true;
            this.noDump = false;
        }

        public void excludeByNoDump() {
            TabJobs.this.includeListRemove(this.name);
            TabJobs.this.excludeListRemove(this.name);
            if (this.fileType == BARServer.FileTypes.DIRECTORY) {
                TabJobs.this.setNoBackup(this.name, false);
            }
            TabJobs.this.setNoDump(this.name, true);
            this.noBackup = false;
            this.noDump = true;
        }

        public void none() {
            TabJobs.this.includeListRemove(this.name);
            TabJobs.this.excludeListRemove(this.name);
            if (this.fileType == BARServer.FileTypes.DIRECTORY) {
                TabJobs.this.setNoBackup(this.name, false);
            }
            TabJobs.this.setNoDump(this.name, false);
            this.noBackup = false;
            this.noDump = false;
        }

        public String toString() {
            return "FileTreeData {" + this.name + ", " + (Object)((Object)this.fileType) + ", " + this.size + " bytes, dateTime=" + this.dateTime + ", title=" + this.title + "}";
        }
    }

    static enum PatternTypes {
        GLOB,
        REGEX,
        EXTENDED_REGEX;

    }

    static enum EntryStoreTypes {
        FILE,
        IMAGE;

    }

    class UpdateThread
    extends Thread {
        final int SLEEP_TIME = 30;

        UpdateThread() {
            this.setName("BARControl Update Job");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    block8: {
                        try {
                            TabJobs.this.update();
                        }
                        catch (SWTException sWTException) {
                            if (Settings.debugLevel <= 2) break block8;
                            BARControl.printStackTrace(sWTException);
                            System.exit(1);
                        }
                    }
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (Throwable throwable) {
                if (Settings.debugLevel > 0) {
                    BARServer.disconnect();
                    BARControl.internalError(throwable);
                }
                return;
            }
        }
    }
}

