/*
 * Decompiled with CFR 0.152.
 */
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class Background {
    private static final int MAX_BACKGROUND_TASKS = 8;
    public static ExecutorService executorService = Executors.newFixedThreadPool(8, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    });

    public static void run(BackgroundRunnable backgroundRunnable) {
        executorService.submit(new BackgroundTask(backgroundRunnable));
    }

    public static void shutdown() {
        executorService.shutdown();
        try {
            executorService.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

