/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

abstract class ListDirectory<T extends File>
implements Comparator<T> {
    private HashMap<String, T> shortcutMap = new HashMap();

    public ListDirectory() {
        for (File file : this.getRoots()) {
            this.shortcutMap.put(file.getName(), file);
        }
    }

    public abstract T newFileInstance(String var1, String var2);

    public T newFileInstance(String string) {
        return this.newFileInstance(null, string);
    }

    public ArrayList<T> getRoots() {
        ArrayList<T> arrayList = new ArrayList<T>();
        arrayList.add(this.newFileInstance("/"));
        return arrayList;
    }

    public T getDefaultRoot() {
        return (T)((File)this.getRoots().get(0));
    }

    public abstract T getParentFile(T var1);

    public abstract String getAbsolutePath(T var1);

    @Override
    public int compare(T t, T t2) {
        return this.getAbsolutePath(t).compareTo(this.getAbsolutePath(t2));
    }

    public void getShortcuts(List<T> list) {
        list.clear();
        for (File file : this.getRoots()) {
            this.shortcutMap.put(file.getName(), file);
        }
        for (File file : this.shortcutMap.values()) {
            list.add(file);
        }
        Collections.sort(list, this);
    }

    public void addShortcut(T t) {
        this.shortcutMap.put(this.getAbsolutePath(t), t);
    }

    public void addShortcut(String string) {
        this.addShortcut(this.newFileInstance(string));
    }

    public void removeShortcut(T t) {
        this.shortcutMap.remove(this.getAbsolutePath(t));
    }

    public abstract boolean open(T var1);

    public abstract void close();

    public abstract T getNext();

    public abstract boolean isRoot(T var1);

    public abstract boolean isDirectory(T var1);

    public abstract boolean isFile(T var1);

    public abstract boolean isHidden(T var1);

    public abstract boolean exists(T var1);

    public abstract void mkdir(T var1) throws IOException;

    public abstract void delete(T var1) throws IOException;
}

