/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class URIParts
implements Cloneable {
    public StorageTypes type;
    public String hostName;
    public int hostPort;
    public String loginName;
    public String loginPassword;
    public String shareName;
    public String deviceName;
    public String fileName;

    public URIParts(StorageTypes storageTypes, String string, int n, String string2, String string3, String string4, String string5, String string6) {
        this.type = storageTypes;
        this.hostName = string;
        this.hostPort = n;
        this.loginName = string2;
        this.loginPassword = string3;
        this.shareName = string4;
        this.deviceName = string5;
        this.fileName = string6;
    }

    public URIParts(String string) {
        this.type = StorageTypes.FILESYSTEM;
        this.hostName = "";
        this.hostPort = 0;
        this.loginName = "";
        this.loginPassword = "";
        this.shareName = "";
        this.deviceName = "";
        this.fileName = "";
        if (string.startsWith("ftp://")) {
            this.type = StorageTypes.FTP;
            String string2 = string.substring(6);
            Matcher matcher = Pattern.compile("^([^:]*?):(([^@]|\\@)*?)@([^@:/]*?):(\\d*?)/(.*)$").matcher(string2);
            if (matcher.matches()) {
                this.loginName = StringUtils.map(matcher.group(1), new String[]{"\\@"}, new String[]{"@"});
                this.loginPassword = matcher.group(2);
                this.hostName = matcher.group(4);
                this.hostPort = Integer.parseInt(matcher.group(5));
                this.fileName = matcher.group(6);
            } else {
                matcher = Pattern.compile("^([^:]*?):(([^@]|\\@)*?)@([^@/]*?)/(.*)$").matcher(string2);
                if (matcher.matches()) {
                    this.loginName = StringUtils.map(matcher.group(1), new String[]{"\\@"}, new String[]{"@"});
                    this.loginPassword = matcher.group(2);
                    this.hostName = matcher.group(4);
                    this.fileName = matcher.group(5);
                } else {
                    matcher = Pattern.compile("^(([^@]|\\@)*?)@([^@:/]*?):(\\d*?)/(.*)$").matcher(string2);
                    if (matcher.matches()) {
                        this.loginName = StringUtils.map(matcher.group(1), new String[]{"\\@"}, new String[]{"@"});
                        this.hostName = matcher.group(3);
                        this.hostPort = Integer.parseInt(matcher.group(4));
                        this.fileName = matcher.group(5);
                    } else {
                        matcher = Pattern.compile("^(([^@]|\\@)*?)@([^@/]*?)/(.*)$").matcher(string2);
                        if (matcher.matches()) {
                            this.loginName = StringUtils.map(matcher.group(1), new String[]{"\\@"}, new String[]{"@"});
                            this.hostName = matcher.group(3);
                            this.fileName = matcher.group(4);
                        } else {
                            matcher = Pattern.compile("^([^@:/]*?):(\\d*?)/(.*)$").matcher(string2);
                            if (matcher.matches()) {
                                this.hostName = matcher.group(1);
                                this.hostPort = Integer.parseInt(matcher.group(2));
                                this.fileName = matcher.group(3);
                            } else {
                                this.fileName = string2;
                            }
                        }
                    }
                }
            }
        } else if (string.startsWith("scp://")) {
            this.type = StorageTypes.SCP;
            String string3 = string.substring(6);
            Matcher matcher = Pattern.compile("^([^:]*?):(([^@]|\\@)*?)@([^@:/]*?):(\\d*?)/(.*)$").matcher(string3);
            if (matcher.matches()) {
                this.loginName = StringUtils.map(matcher.group(1), new String[]{"\\@"}, new String[]{"@"});
                this.loginPassword = matcher.group(2);
                this.hostName = matcher.group(4);
                this.hostPort = Integer.parseInt(matcher.group(5));
                this.fileName = matcher.group(6);
            } else {
                matcher = Pattern.compile("^([^:]*?):(([^@]|\\@)*?)@([^@/]*?)/(.*)$").matcher(string3);
                if (matcher.matches()) {
                    this.loginName = StringUtils.map(matcher.group(1), new String[]{"\\@"}, new String[]{"@"});
                    this.loginPassword = matcher.group(2);
                    this.hostName = matcher.group(4);
                    this.fileName = matcher.group(5);
                } else {
                    matcher = Pattern.compile("^(([^@]|\\@)*?)@([^@:/]*?):(\\d*?)/(.*)$").matcher(string3);
                    if (matcher.matches()) {
                        this.loginName = StringUtils.map(matcher.group(1), new String[]{"\\@"}, new String[]{"@"});
                        this.hostName = matcher.group(3);
                        this.hostPort = Integer.parseInt(matcher.group(4));
                        this.fileName = matcher.group(5);
                    } else {
                        matcher = Pattern.compile("^(([^@]|\\@)*?)@([^@/]*?)/(.*)$").matcher(string3);
                        if (matcher.matches()) {
                            this.loginName = StringUtils.map(matcher.group(1), new String[]{"\\@"}, new String[]{"@"});
                            this.hostName = matcher.group(3);
                            this.fileName = matcher.group(4);
                        } else {
                            matcher = Pattern.compile("^([^@:/]*?):(\\d*?)/(.*)$").matcher(string3);
                            if (matcher.matches()) {
                                this.hostName = matcher.group(1);
                                this.hostPort = Integer.parseInt(matcher.group(2));
                                this.fileName = matcher.group(3);
                            } else {
                                matcher = Pattern.compile("^([^@:/]*?)/(.*)$").matcher(string3);
                                if (matcher.matches()) {
                                    this.hostName = matcher.group(1);
                                    this.fileName = matcher.group(2);
                                } else {
                                    this.fileName = string3;
                                }
                            }
                        }
                    }
                }
            }
        } else if (string.startsWith("sftp://")) {
            this.type = StorageTypes.SFTP;
            String string4 = string.substring(7);
            Matcher matcher = Pattern.compile("^([^:]*?):(([^@]|\\@)*?)@([^@:/]*?):(\\d*?)/(.*)$").matcher(string4);
            if (matcher.matches()) {
                this.loginName = StringUtils.map(matcher.group(1), new String[]{"\\@"}, new String[]{"@"});
                this.loginPassword = matcher.group(2);
                this.hostName = matcher.group(4);
                this.hostPort = Integer.parseInt(matcher.group(5));
                this.fileName = matcher.group(6);
            } else {
                matcher = Pattern.compile("^([^:]*?):(([^@]|\\@)*?)@([^@/]*?)/(.*)$").matcher(string4);
                if (matcher.matches()) {
                    this.loginName = StringUtils.map(matcher.group(1), new String[]{"\\@"}, new String[]{"@"});
                    this.loginPassword = matcher.group(2);
                    this.hostName = matcher.group(4);
                    this.fileName = matcher.group(5);
                } else {
                    matcher = Pattern.compile("^(([^@]|\\@)*?)@([^@:/]*?):(\\d*?)/(.*)$").matcher(string4);
                    if (matcher.matches()) {
                        this.loginName = StringUtils.map(matcher.group(1), new String[]{"\\@"}, new String[]{"@"});
                        this.hostName = matcher.group(3);
                        this.hostPort = Integer.parseInt(matcher.group(4));
                        this.fileName = matcher.group(5);
                    } else {
                        matcher = Pattern.compile("^(([^@]|\\@)*?)@([^@/]*?)/(.*)$").matcher(string4);
                        if (matcher.matches()) {
                            this.loginName = StringUtils.map(matcher.group(1), new String[]{"\\@"}, new String[]{"@"});
                            this.hostName = matcher.group(3);
                            this.fileName = matcher.group(4);
                        } else {
                            matcher = Pattern.compile("^([^@:/]*?):(\\d*?)/(.*)$").matcher(string4);
                            if (matcher.matches()) {
                                this.hostName = matcher.group(1);
                                this.hostPort = Integer.parseInt(matcher.group(2));
                                this.fileName = matcher.group(3);
                            } else {
                                matcher = Pattern.compile("^([^@:/]*?)/(.*)$").matcher(string4);
                                if (matcher.matches()) {
                                    this.hostName = matcher.group(1);
                                    this.fileName = matcher.group(2);
                                } else {
                                    this.fileName = string4;
                                }
                            }
                        }
                    }
                }
            }
        } else if (string.startsWith("webdav://")) {
            this.type = StorageTypes.WEBDAV;
            String string5 = string.substring(9);
            Matcher matcher = Pattern.compile("^([^:]*?):(([^@]|\\@)*?)@([^@/]*?):(\\d*?)/(.*)$").matcher(string5);
            if (matcher.matches()) {
                this.loginName = StringUtils.map(matcher.group(1), new String[]{"\\@"}, new String[]{"@"});
                this.loginPassword = matcher.group(2);
                this.hostName = matcher.group(4);
                this.hostPort = Integer.parseInt(matcher.group(5));
                this.fileName = matcher.group(6);
            } else {
                matcher = Pattern.compile("^([^:]*?):(([^@]|\\@)*?)@([^@/]*?)/(.*)$").matcher(string5);
                if (matcher.matches()) {
                    this.loginName = StringUtils.map(matcher.group(1), new String[]{"\\@"}, new String[]{"@"});
                    this.loginPassword = matcher.group(2);
                    this.hostName = matcher.group(4);
                    this.fileName = matcher.group(5);
                } else {
                    matcher = Pattern.compile("^(([^@]|\\@)*?)@([^@/]*?):(\\d*?)/(.*)$").matcher(string5);
                    if (matcher.matches()) {
                        this.loginName = StringUtils.map(matcher.group(1), new String[]{"\\@"}, new String[]{"@"});
                        this.hostName = matcher.group(3);
                        this.hostPort = Integer.parseInt(matcher.group(4));
                        this.fileName = matcher.group(5);
                    } else {
                        matcher = Pattern.compile("^(([^@]|\\@)*?)@([^@/]*?)/(.*)$").matcher(string5);
                        if (matcher.matches()) {
                            this.loginName = StringUtils.map(matcher.group(1), new String[]{"\\@"}, new String[]{"@"});
                            this.hostName = matcher.group(3);
                            this.fileName = matcher.group(4);
                        } else {
                            matcher = Pattern.compile("^([^@:/]*?):(\\d*?)/(.*)$").matcher(string5);
                            if (matcher.matches()) {
                                this.hostName = matcher.group(1);
                                this.hostPort = Integer.parseInt(matcher.group(2));
                                this.fileName = matcher.group(3);
                            } else {
                                matcher = Pattern.compile("^([^@:/]*?)/(.*)$").matcher(string5);
                                if (matcher.matches()) {
                                    this.hostName = matcher.group(1);
                                    this.fileName = matcher.group(2);
                                } else {
                                    this.fileName = string5;
                                }
                            }
                        }
                    }
                }
            }
        } else if (string.startsWith("webdavs://")) {
            this.type = StorageTypes.WEBDAVS;
            String string6 = string.substring(10);
            Matcher matcher = Pattern.compile("^([^:]*?):(([^@]|\\@)*?)@([^@/]*?):(\\d*?)/(.*)$").matcher(string6);
            if (matcher.matches()) {
                this.loginName = StringUtils.map(matcher.group(1), new String[]{"\\@"}, new String[]{"@"});
                this.loginPassword = matcher.group(2);
                this.hostName = matcher.group(4);
                this.hostPort = Integer.parseInt(matcher.group(5));
                this.fileName = matcher.group(6);
            } else {
                matcher = Pattern.compile("^([^:]*?):(([^@]|\\@)*?)@([^@/]*?)/(.*)$").matcher(string6);
                if (matcher.matches()) {
                    this.loginName = StringUtils.map(matcher.group(1), new String[]{"\\@"}, new String[]{"@"});
                    this.loginPassword = matcher.group(2);
                    this.hostName = matcher.group(4);
                    this.fileName = matcher.group(5);
                } else {
                    matcher = Pattern.compile("^(([^@]|\\@)*?)@([^@/]*?):(\\d*?)/(.*)$").matcher(string6);
                    if (matcher.matches()) {
                        this.loginName = StringUtils.map(matcher.group(1), new String[]{"\\@"}, new String[]{"@"});
                        this.hostName = matcher.group(3);
                        this.hostPort = Integer.parseInt(matcher.group(4));
                        this.fileName = matcher.group(5);
                    } else {
                        matcher = Pattern.compile("^(([^@]|\\@)*?)@([^@/]*?)/(.*)$").matcher(string6);
                        if (matcher.matches()) {
                            this.loginName = StringUtils.map(matcher.group(1), new String[]{"\\@"}, new String[]{"@"});
                            this.hostName = matcher.group(3);
                            this.fileName = matcher.group(4);
                        } else {
                            matcher = Pattern.compile("^([^@:/]*?):(\\d*?)/(.*)$").matcher(string6);
                            if (matcher.matches()) {
                                this.hostName = matcher.group(1);
                                this.hostPort = Integer.parseInt(matcher.group(2));
                                this.fileName = matcher.group(3);
                            } else {
                                matcher = Pattern.compile("^([^@:/]*?)/(.*)$").matcher(string6);
                                if (matcher.matches()) {
                                    this.hostName = matcher.group(1);
                                    this.fileName = matcher.group(2);
                                } else {
                                    this.fileName = string6;
                                }
                            }
                        }
                    }
                }
            }
        } else if (string.startsWith("smb://")) {
            this.type = StorageTypes.SMB;
            String string7 = string.substring(6);
            Matcher matcher = Pattern.compile("^([^:]*?):(([^@]|\\@)*?)@([^@/]*?):([^:]*?)/(.*)$").matcher(string7);
            if (matcher.matches()) {
                this.loginName = StringUtils.map(matcher.group(1), new String[]{"\\@"}, new String[]{"@"});
                this.loginPassword = matcher.group(2);
                this.hostName = matcher.group(4);
                this.shareName = matcher.group(5);
                this.fileName = matcher.group(6);
            } else {
                matcher = Pattern.compile("^([^:]*?):(([^@]|\\@)*?)@([^@/]*?)/(.*)$").matcher(string7);
                if (matcher.matches()) {
                    this.loginName = StringUtils.map(matcher.group(1), new String[]{"\\@"}, new String[]{"@"});
                    this.loginPassword = matcher.group(2);
                    this.hostName = matcher.group(4);
                    this.fileName = matcher.group(5);
                } else {
                    matcher = Pattern.compile("^(([^@]|\\@)*?)@([^@/]*?):([^:]*?)/(.*)$").matcher(string7);
                    if (matcher.matches()) {
                        this.loginName = StringUtils.map(matcher.group(1), new String[]{"\\@"}, new String[]{"@"});
                        this.hostName = matcher.group(3);
                        this.shareName = matcher.group(4);
                        this.fileName = matcher.group(5);
                    } else {
                        matcher = Pattern.compile("^(([^@]|\\@)*?)@([^@/]*?)/(.*)$").matcher(string7);
                        if (matcher.matches()) {
                            this.loginName = StringUtils.map(matcher.group(1), new String[]{"\\@"}, new String[]{"@"});
                            this.hostName = matcher.group(3);
                            this.fileName = matcher.group(4);
                        } else {
                            matcher = Pattern.compile("^([^@:/]*?):([^:]*?)/(.*)$").matcher(string7);
                            if (matcher.matches()) {
                                this.hostName = matcher.group(1);
                                this.shareName = matcher.group(2);
                                this.fileName = matcher.group(3);
                            } else {
                                matcher = Pattern.compile("^([^@:/]*?)/(.*)$").matcher(string7);
                                if (matcher.matches()) {
                                    this.hostName = matcher.group(1);
                                    this.fileName = matcher.group(2);
                                } else {
                                    this.fileName = string7;
                                }
                            }
                        }
                    }
                }
            }
        } else if (string.startsWith("cd://")) {
            this.type = StorageTypes.CD;
            String string8 = string.substring(5);
            Object[] objectArray = new Object[2];
            Matcher matcher = Pattern.compile("^([^:]*?):(.*)$").matcher(string8);
            if (matcher.matches()) {
                this.deviceName = matcher.group(1);
                this.fileName = matcher.group(2);
            } else {
                this.fileName = string8;
            }
        } else if (string.startsWith("dvd://")) {
            this.type = StorageTypes.DVD;
            String string9 = string.substring(6);
            Matcher matcher = Pattern.compile("^([^:]*?):(.*)$").matcher(string9);
            if (matcher.matches()) {
                this.deviceName = matcher.group(1);
                this.fileName = matcher.group(2);
            } else {
                this.fileName = string9;
            }
        } else if (string.startsWith("bd://")) {
            this.type = StorageTypes.BD;
            String string10 = string.substring(5);
            Matcher matcher = Pattern.compile("^([^:]*?):(.*)$").matcher(string10);
            if (matcher.matches()) {
                this.deviceName = matcher.group(1);
                this.fileName = matcher.group(2);
            } else {
                this.fileName = string10;
            }
        } else if (string.startsWith("device://")) {
            this.type = StorageTypes.DEVICE;
            String string11 = string.substring(9);
            Matcher matcher = Pattern.compile("^([^:]*?):(.*)$").matcher(string11);
            if (matcher.matches()) {
                this.deviceName = matcher.group(1);
                this.fileName = matcher.group(2);
            } else {
                this.fileName = string11;
            }
        } else if (string.startsWith("file://")) {
            this.type = StorageTypes.FILESYSTEM;
            String string12 = string.substring(7);
            this.fileName = string12.substring(2);
        } else {
            this.type = StorageTypes.FILESYSTEM;
            this.fileName = string;
        }
    }

    public URIParts clone() {
        return new URIParts(this.type, this.hostName, this.hostPort, this.loginName, this.loginPassword, this.shareName, this.deviceName, this.fileName);
    }

    public String getURI(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.type) {
            case FILESYSTEM: {
                break;
            }
            case FTP: {
                stringBuilder.append("ftp://");
                if (this.loginName.isEmpty() && this.hostName.isEmpty()) break;
                if (!this.loginName.isEmpty() || !this.loginPassword.equals("")) {
                    if (!this.loginName.isEmpty()) {
                        stringBuilder.append(StringUtils.map(this.loginName, new String[]{"@"}, new String[]{"\\@"}));
                    }
                    if (!this.loginPassword.equals("")) {
                        stringBuilder.append(':');
                        stringBuilder.append(this.loginPassword);
                    }
                    stringBuilder.append('@');
                }
                if (this.hostName.isEmpty()) break;
                stringBuilder.append(this.hostName);
                break;
            }
            case SCP: {
                stringBuilder.append("scp://");
                if (this.loginName.isEmpty() && this.hostName.isEmpty()) break;
                if (!this.loginName.isEmpty() || !this.loginPassword.isEmpty()) {
                    if (!this.loginName.isEmpty()) {
                        stringBuilder.append(StringUtils.map(this.loginName, new String[]{"@"}, new String[]{"\\@"}));
                    }
                    if (!this.loginPassword.isEmpty()) {
                        stringBuilder.append(':');
                        stringBuilder.append(this.loginPassword);
                    }
                    stringBuilder.append('@');
                }
                if (!this.hostName.isEmpty()) {
                    stringBuilder.append(this.hostName);
                }
                if (this.hostPort <= 0) break;
                stringBuilder.append(':');
                stringBuilder.append(this.hostPort);
                break;
            }
            case SFTP: {
                stringBuilder.append("sftp://");
                if (this.loginName.isEmpty() && this.hostName.isEmpty()) break;
                if (!this.loginName.isEmpty() || !this.loginPassword.isEmpty()) {
                    if (!this.loginName.isEmpty()) {
                        stringBuilder.append(StringUtils.map(this.loginName, new String[]{"@"}, new String[]{"\\@"}));
                    }
                    if (!this.loginPassword.isEmpty()) {
                        stringBuilder.append(':');
                        stringBuilder.append(this.loginPassword);
                    }
                    stringBuilder.append('@');
                }
                if (!this.hostName.isEmpty()) {
                    stringBuilder.append(this.hostName);
                }
                if (this.hostPort <= 0) break;
                stringBuilder.append(':');
                stringBuilder.append(this.hostPort);
                break;
            }
            case WEBDAV: {
                stringBuilder.append("webdav://");
                if (this.loginName.isEmpty() && this.hostName.isEmpty()) break;
                if (!this.loginName.isEmpty() || !this.loginPassword.isEmpty()) {
                    if (!this.loginName.isEmpty()) {
                        stringBuilder.append(StringUtils.map(this.loginName, new String[]{"@"}, new String[]{"\\@"}));
                    }
                    if (!this.loginPassword.isEmpty()) {
                        stringBuilder.append(':');
                        stringBuilder.append(this.loginPassword);
                    }
                    stringBuilder.append('@');
                }
                if (!this.hostName.isEmpty()) {
                    stringBuilder.append(this.hostName);
                }
                if (this.hostPort <= 0) break;
                stringBuilder.append(':');
                stringBuilder.append(this.hostPort);
                break;
            }
            case WEBDAVS: {
                stringBuilder.append("webdavs://");
                if (this.loginName.isEmpty() && this.hostName.isEmpty()) break;
                if (!this.loginName.isEmpty() || !this.loginPassword.isEmpty()) {
                    if (!this.loginName.isEmpty()) {
                        stringBuilder.append(StringUtils.map(this.loginName, new String[]{"@"}, new String[]{"\\@"}));
                    }
                    if (!this.loginPassword.isEmpty()) {
                        stringBuilder.append(':');
                        stringBuilder.append(this.loginPassword);
                    }
                    stringBuilder.append('@');
                }
                if (!this.hostName.isEmpty()) {
                    stringBuilder.append(this.hostName);
                }
                if (this.hostPort <= 0) break;
                stringBuilder.append(':');
                stringBuilder.append(this.hostPort);
                break;
            }
            case SMB: {
                stringBuilder.append("smb://");
                if (this.loginName.isEmpty() && this.hostName.isEmpty()) break;
                if (!this.loginName.isEmpty() || !this.loginPassword.isEmpty()) {
                    if (!this.loginName.isEmpty()) {
                        stringBuilder.append(StringUtils.map(this.loginName, new String[]{"@"}, new String[]{"\\@"}));
                    }
                    if (!this.loginPassword.isEmpty()) {
                        stringBuilder.append(':');
                        stringBuilder.append(this.loginPassword);
                    }
                    stringBuilder.append('@');
                }
                if (!this.hostName.isEmpty()) {
                    stringBuilder.append(this.hostName);
                }
                if (this.shareName.isEmpty()) break;
                stringBuilder.append(':');
                stringBuilder.append(this.shareName);
                break;
            }
            case CD: {
                stringBuilder.append("cd://");
                if (this.deviceName.isEmpty()) break;
                stringBuilder.append(this.deviceName);
                stringBuilder.append(':');
                break;
            }
            case DVD: {
                stringBuilder.append("dvd://");
                if (this.deviceName.isEmpty()) break;
                stringBuilder.append(this.deviceName);
                stringBuilder.append(':');
                break;
            }
            case BD: {
                stringBuilder.append("bd://");
                if (this.deviceName.isEmpty()) break;
                stringBuilder.append(this.deviceName);
                stringBuilder.append(':');
                break;
            }
            case DEVICE: {
                stringBuilder.append("device://");
                if (this.deviceName.isEmpty()) break;
                stringBuilder.append(this.deviceName);
                stringBuilder.append(':');
            }
        }
        if (string != null) {
            if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) != '/') {
                stringBuilder.append('/');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public String getURIPath() {
        File file = new File(this.fileName);
        return this.getURI(file.getParent());
    }

    public String getURI() {
        return this.getURI(this.fileName);
    }

    public String getPrintableURI(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.type) {
            case FILESYSTEM: {
                break;
            }
            case FTP: {
                stringBuilder.append("ftp://");
                if (this.loginName.isEmpty() && this.hostName.isEmpty()) break;
                if (!this.loginName.isEmpty() || !this.loginPassword.isEmpty()) {
                    if (!this.loginName.isEmpty()) {
                        stringBuilder.append(StringUtils.map(this.loginName, new String[]{"@"}, new String[]{"\\@"}));
                    }
                    stringBuilder.append('@');
                }
                if (!this.hostName.isEmpty()) {
                    stringBuilder.append(this.hostName);
                }
                stringBuilder.append('/');
                break;
            }
            case SCP: {
                stringBuilder.append("scp://");
                if (this.loginName.isEmpty() && this.hostName.isEmpty()) break;
                if (!this.loginName.isEmpty()) {
                    stringBuilder.append(StringUtils.map(this.loginName, new String[]{"@"}, new String[]{"\\@"}));
                    stringBuilder.append('@');
                }
                if (!this.hostName.isEmpty()) {
                    stringBuilder.append(this.hostName);
                }
                if (this.hostPort > 0) {
                    stringBuilder.append(':');
                    stringBuilder.append(this.hostPort);
                }
                stringBuilder.append('/');
                break;
            }
            case SFTP: {
                stringBuilder.append("sftp://");
                if (this.loginName.isEmpty() && this.hostName.isEmpty()) break;
                if (!this.loginName.isEmpty()) {
                    stringBuilder.append(StringUtils.map(this.loginName, new String[]{"@"}, new String[]{"\\@"}));
                    stringBuilder.append('@');
                }
                if (!this.hostName.isEmpty()) {
                    stringBuilder.append(this.hostName);
                }
                if (this.hostPort > 0) {
                    stringBuilder.append(':');
                    stringBuilder.append(this.hostPort);
                }
                stringBuilder.append('/');
                break;
            }
            case WEBDAV: {
                stringBuilder.append("webdav://");
                if (this.loginName.isEmpty() && this.hostName.isEmpty()) break;
                if (!this.loginName.isEmpty()) {
                    stringBuilder.append(StringUtils.map(this.loginName, new String[]{"@"}, new String[]{"\\@"}));
                    stringBuilder.append('@');
                }
                if (!this.hostName.isEmpty()) {
                    stringBuilder.append(this.hostName);
                }
                stringBuilder.append('/');
                break;
            }
            case SMB: {
                stringBuilder.append("smb://");
                if (this.loginName.isEmpty() && this.hostName.isEmpty()) break;
                if (!this.loginName.isEmpty()) {
                    stringBuilder.append(StringUtils.map(this.loginName, new String[]{"@"}, new String[]{"\\@"}));
                    stringBuilder.append('@');
                }
                if (!this.hostName.isEmpty()) {
                    stringBuilder.append(this.hostName);
                }
                if (!this.shareName.isEmpty()) {
                    stringBuilder.append(':');
                    stringBuilder.append(this.shareName);
                }
                stringBuilder.append('/');
                break;
            }
            case CD: {
                stringBuilder.append("cd://");
                if (this.deviceName.isEmpty()) break;
                stringBuilder.append(this.deviceName);
                stringBuilder.append(':');
                break;
            }
            case DVD: {
                stringBuilder.append("dvd://");
                if (this.deviceName.isEmpty()) break;
                stringBuilder.append(this.deviceName);
                stringBuilder.append(':');
                break;
            }
            case BD: {
                stringBuilder.append("bd://");
                if (this.deviceName.isEmpty()) break;
                stringBuilder.append(this.deviceName);
                stringBuilder.append(':');
                break;
            }
            case DEVICE: {
                stringBuilder.append("device://");
                if (this.deviceName.isEmpty()) break;
                stringBuilder.append(this.deviceName);
                stringBuilder.append(':');
            }
        }
        if (string != null) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public String getPrintableURI() {
        return this.getPrintableURI(this.fileName);
    }

    public String toString() {
        return "URIParts {" + (Object)((Object)this.type) + ", " + this.loginName + ", " + this.loginPassword + ", " + this.hostName + ", " + this.hostPort + ", " + this.shareName + ", " + this.deviceName + ", " + this.fileName + "}";
    }
}

