/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

class WidgetModifyListener {
    private Widget widget;
    private WidgetVariable[] variables;
    private Widget modifyWidget;
    private String cachedText = "";

    WidgetModifyListener() {
        this.widget = null;
        this.variables = null;
        this.modifyWidget = null;
    }

    WidgetModifyListener(Widget widget, WidgetVariable ... widgetVariableArray) {
        this.widget = widget;
        this.variables = widgetVariableArray;
        this.modifyWidget = null;
    }

    WidgetModifyListener(final Control control, final Widget widget) {
        this.widget = control;
        this.variables = null;
        this.modifyWidget = widget;
        widget.addListener(24, new Listener(){

            @Override
            public void handleEvent(Event event) {
                WidgetModifyListener.this.modified(control, widget);
            }
        });
    }

    WidgetModifyListener(Widget widget, Object ... objectArray) {
        this.widget = widget;
        this.variables = new WidgetVariable[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            this.variables[i] = WidgetVariable.getInstance(objectArray[i]);
        }
        this.modifyWidget = null;
    }

    WidgetModifyListener(Widget widget) {
        this(widget, (WidgetVariable[])null);
    }

    WidgetModifyListener(WidgetVariable widgetVariable) {
        this((Widget)null, widgetVariable);
    }

    WidgetModifyListener(WidgetVariable ... widgetVariableArray) {
        this((Widget)null, widgetVariableArray);
    }

    void setControl(Widget widget) {
        this.widget = widget;
    }

    void setVariable(WidgetVariable widgetVariable) {
        this.variables = new WidgetVariable[]{widgetVariable};
    }

    public boolean watches(WidgetVariable widgetVariable) {
        if (this.variables != null) {
            for (WidgetVariable widgetVariable2 : this.variables) {
                if (widgetVariable2 != widgetVariable) continue;
                return true;
            }
        }
        return false;
    }

    public boolean watches(Object object) {
        if (this.variables != null) {
            for (WidgetVariable widgetVariable : this.variables) {
                if (widgetVariable.get() != object) continue;
                return true;
            }
        }
        return false;
    }

    public void parse(String string) {
    }

    public final void modified(final Widget widget, final WidgetVariable widgetVariable) {
        if (widget != null && !widget.isDisposed()) {
            widget.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (widget instanceof Label) {
                            Label label = (Label)widget;
                            String string = WidgetModifyListener.this.getString(widgetVariable);
                            if (string == null) {
                                if (widgetVariable.getType() == Integer.class) {
                                    string = Integer.toString(widgetVariable.getInteger());
                                } else if (widgetVariable.getType() == Long.class) {
                                    string = Long.toString(widgetVariable.getLong());
                                } else if (widgetVariable.getType() == Double.class) {
                                    string = Double.toString(widgetVariable.getDouble());
                                } else if (widgetVariable.getType() == String.class) {
                                    string = widgetVariable.getString();
                                }
                            }
                            if (string != null && !string.equals(WidgetModifyListener.this.cachedText)) {
                                Rectangle rectangle = label.getBounds();
                                label.setText(string);
                                label.pack();
                                label.setBounds(rectangle);
                                WidgetModifyListener.this.cachedText = string;
                            }
                        } else if (widget instanceof Button) {
                            Button button = (Button)widget;
                            if ((button.getStyle() & 8) == 8) {
                                String string = WidgetModifyListener.this.getString(widgetVariable);
                                if (string == null) {
                                    if (widgetVariable.getType() == Integer.class) {
                                        string = Integer.toString(widgetVariable.getInteger());
                                    } else if (widgetVariable.getType() == Long.class) {
                                        string = Long.toString(widgetVariable.getLong());
                                    } else if (widgetVariable.getType() == Double.class) {
                                        string = Double.toString(widgetVariable.getDouble());
                                    } else if (widgetVariable.getType() == String.class) {
                                        string = widgetVariable.getString();
                                    }
                                }
                                if (string != null && !string.equals(WidgetModifyListener.this.cachedText)) {
                                    Rectangle rectangle = button.getBounds();
                                    button.setText(string);
                                    button.pack();
                                    button.setBounds(rectangle);
                                    WidgetModifyListener.this.cachedText = string;
                                }
                            } else if ((button.getStyle() & 0x20) == 32) {
                                boolean bl = false;
                                if (widgetVariable.getType() == Boolean.class) {
                                    bl = widgetVariable.getBoolean();
                                } else if (widgetVariable.getType() == Integer.class) {
                                    bl = widgetVariable.getInteger() != 0;
                                } else if (widgetVariable.getType() == Long.class) {
                                    bl = widgetVariable.getLong() != 0L;
                                } else if (widgetVariable.getType() == Double.class) {
                                    bl = widgetVariable.getDouble() != 0.0;
                                }
                                button.setSelection(bl);
                            } else if ((button.getStyle() & 0x10) == 16) {
                                boolean bl = false;
                                if (widgetVariable.getType() == Boolean.class) {
                                    bl = widgetVariable.getBoolean();
                                } else if (widgetVariable.getType() == Integer.class) {
                                    bl = widgetVariable.getInteger() != 0;
                                } else if (widgetVariable.getType() == Long.class) {
                                    bl = widgetVariable.getLong() != 0L;
                                } else if (widgetVariable.getType() == Double.class) {
                                    bl = widgetVariable.getDouble() != 0.0;
                                }
                                button.setSelection(bl);
                            }
                        } else if (widget instanceof Combo) {
                            Combo combo = (Combo)widget;
                            String string = WidgetModifyListener.this.getString(widgetVariable);
                            if (string == null) {
                                if (widgetVariable.getType() == Boolean.class) {
                                    string = Boolean.toString(widgetVariable.getBoolean());
                                } else if (widgetVariable.getType() == Integer.class) {
                                    string = Integer.toString(widgetVariable.getInteger());
                                } else if (widgetVariable.getType() == Long.class) {
                                    string = Long.toString(widgetVariable.getLong());
                                } else if (widgetVariable.getType() == Double.class) {
                                    string = Double.toString(widgetVariable.getDouble());
                                } else if (widgetVariable.getType() == String.class || widgetVariable.getType().isEnum() || widgetVariable.getType() == Enum.class) {
                                    string = widgetVariable.getString();
                                }
                            }
                            if (string != null && !string.equals(WidgetModifyListener.this.cachedText)) {
                                ArrayList arrayList = (ArrayList)combo.getData();
                                int n = -1;
                                if (arrayList != null) {
                                    for (int i = 0; i < arrayList.size(); ++i) {
                                        if (!arrayList.get(i).toString().equals(string)) continue;
                                        Rectangle rectangle = combo.getBounds();
                                        combo.select(i);
                                        combo.pack();
                                        combo.setBounds(rectangle);
                                        n = i;
                                        break;
                                    }
                                }
                                if (n == -1) {
                                    Rectangle rectangle = combo.getBounds();
                                    combo.setText(string);
                                    combo.pack();
                                    combo.setBounds(rectangle);
                                }
                                WidgetModifyListener.this.cachedText = string;
                            }
                        } else if (widget instanceof Text) {
                            Text text = (Text)widget;
                            String string = WidgetModifyListener.this.getString(widgetVariable);
                            if (string == null) {
                                if (widgetVariable.getType() == Integer.class) {
                                    string = Integer.toString(widgetVariable.getInteger());
                                } else if (widgetVariable.getType() == Long.class) {
                                    string = Long.toString(widgetVariable.getLong());
                                } else if (widgetVariable.getType() == Double.class) {
                                    string = Double.toString(widgetVariable.getDouble());
                                } else if (widgetVariable.getType() == String.class) {
                                    string = widgetVariable.getString();
                                }
                            }
                            if (string != null && !string.equals(WidgetModifyListener.this.cachedText)) {
                                Rectangle rectangle = text.getBounds();
                                text.setText(string);
                                text.pack();
                                text.setBounds(rectangle);
                                WidgetModifyListener.this.cachedText = string;
                            }
                        } else if (widget instanceof StyledText) {
                            StyledText styledText = (StyledText)widget;
                            String string = WidgetModifyListener.this.getString(widgetVariable);
                            if (string == null) {
                                if (widgetVariable.getType() == Integer.class) {
                                    string = Integer.toString(widgetVariable.getInteger());
                                } else if (widgetVariable.getType() == Long.class) {
                                    string = Long.toString(widgetVariable.getLong());
                                } else if (widgetVariable.getType() == Double.class) {
                                    string = Double.toString(widgetVariable.getDouble());
                                } else if (widgetVariable.getType() == String.class) {
                                    string = widgetVariable.getString();
                                }
                            }
                            if (string != null && !string.equals(WidgetModifyListener.this.cachedText)) {
                                Rectangle rectangle = styledText.getBounds();
                                styledText.setText(string);
                                styledText.pack();
                                styledText.setBounds(rectangle);
                                WidgetModifyListener.this.cachedText = string;
                            }
                        } else if (widget instanceof Spinner) {
                            Spinner spinner = (Spinner)widget;
                            int n = 0;
                            if (widgetVariable.getType() == Integer.class) {
                                n = widgetVariable.getInteger();
                            } else if (widgetVariable.getType() == Long.class) {
                                n = (int)widgetVariable.getLong();
                            } else if (widgetVariable.getType() == Double.class) {
                                n = (int)widgetVariable.getDouble();
                            }
                            spinner.setSelection(n);
                        } else if (widget instanceof Slider) {
                            Slider slider = (Slider)widget;
                            int n = 0;
                            if (widgetVariable.getType() == Integer.class) {
                                n = widgetVariable.getInteger();
                            } else if (widgetVariable.getType() == Long.class) {
                                n = (int)widgetVariable.getLong();
                            } else if (widgetVariable.getType() == Double.class) {
                                n = (int)widgetVariable.getDouble();
                            }
                            slider.setSelection(n);
                        } else if (widget instanceof Scale) {
                            Scale scale = (Scale)widget;
                            int n = 0;
                            if (widgetVariable.getType() == Integer.class) {
                                n = widgetVariable.getInteger();
                            } else if (widgetVariable.getType() == Long.class) {
                                n = (int)widgetVariable.getLong();
                            } else if (widgetVariable.getType() == Double.class) {
                                n = (int)widgetVariable.getDouble();
                            }
                            scale.setSelection(n);
                        } else if (widget instanceof ProgressBar) {
                            ProgressBar progressBar = (ProgressBar)widget;
                            double d = 0.0;
                            if (widgetVariable.getType() == Integer.class) {
                                d = widgetVariable.getInteger();
                            } else if (widgetVariable.getType() == Long.class) {
                                d = widgetVariable.getLong();
                            } else if (widgetVariable.getType() == Double.class) {
                                d = widgetVariable.getDouble();
                            }
                            progressBar.setSelection(d);
                        } else if (!(widget instanceof MenuItem || widget instanceof List || widget instanceof Table || widget instanceof Composite)) {
                            throw new InternalError("Unhandled widget '" + widget + "' in widget listener!");
                        }
                    }
                    catch (Throwable throwable) {
                        throw new Error(throwable);
                    }
                }
            });
        }
    }

    public final void modified(Widget widget, WidgetVariable[] widgetVariableArray) {
        if (!widget.isDisposed()) {
            for (WidgetVariable widgetVariable : widgetVariableArray) {
                this.modified(widget, widgetVariable);
            }
        }
    }

    void modified(Control control, WidgetVariable widgetVariable) {
        this.modified((Widget)control, widgetVariable);
    }

    public void modified(Control control, WidgetVariable[] widgetVariableArray) {
        for (WidgetVariable widgetVariable : widgetVariableArray) {
            this.modified(control, widgetVariable);
        }
    }

    public void modified(Button button, WidgetVariable widgetVariable) {
        this.modified((Control)button, widgetVariable);
    }

    public void modified(Button button, WidgetVariable[] widgetVariableArray) {
        for (WidgetVariable widgetVariable : widgetVariableArray) {
            this.modified(button, widgetVariable);
        }
    }

    public void modified(Combo combo, WidgetVariable widgetVariable) {
        this.modified((Control)combo, widgetVariable);
    }

    public void modified(Combo combo, WidgetVariable[] widgetVariableArray) {
        for (WidgetVariable widgetVariable : widgetVariableArray) {
            this.modified(combo, widgetVariable);
        }
    }

    public void modified(Text text, WidgetVariable widgetVariable) {
        this.modified((Control)text, widgetVariable);
    }

    public void modified(Text text, WidgetVariable[] widgetVariableArray) {
        for (WidgetVariable widgetVariable : widgetVariableArray) {
            this.modified(text, widgetVariable);
        }
    }

    public void modified(StyledText styledText, WidgetVariable widgetVariable) {
        this.modified((Control)styledText, widgetVariable);
    }

    public void modified(StyledText styledText, WidgetVariable[] widgetVariableArray) {
        for (WidgetVariable widgetVariable : widgetVariableArray) {
            this.modified(styledText, widgetVariable);
        }
    }

    public void modified(Spinner spinner, WidgetVariable widgetVariable) {
        this.modified((Control)spinner, widgetVariable);
    }

    public void modified(Spinner spinner, WidgetVariable[] widgetVariableArray) {
        for (WidgetVariable widgetVariable : widgetVariableArray) {
            this.modified(spinner, widgetVariable);
        }
    }

    public void modified(MenuItem menuItem, WidgetVariable widgetVariable) {
        this.modified((Widget)menuItem, widgetVariable);
    }

    public void modified(MenuItem menuItem, WidgetVariable[] widgetVariableArray) {
        for (WidgetVariable widgetVariable : widgetVariableArray) {
            this.modified(menuItem, widgetVariable);
        }
    }

    public void modified(Table table, WidgetVariable widgetVariable) {
        this.modified((Control)table, widgetVariable);
    }

    public void modified(Table table, WidgetVariable[] widgetVariableArray) {
        for (WidgetVariable widgetVariable : widgetVariableArray) {
            this.modified(table, widgetVariable);
        }
    }

    public void modified(Tree tree, WidgetVariable widgetVariable) {
        this.modified((Control)tree, widgetVariable);
    }

    public void modified(Tree tree, WidgetVariable[] widgetVariableArray) {
        for (WidgetVariable widgetVariable : widgetVariableArray) {
            this.modified(tree, widgetVariable);
        }
    }

    public void modified(WidgetVariable widgetVariable) {
        if (this.widget instanceof Control) {
            this.modified((Control)this.widget, widgetVariable);
        } else {
            this.modified(this.widget, widgetVariable);
        }
    }

    public void modified(WidgetVariable[] widgetVariableArray) {
        for (WidgetVariable widgetVariable : widgetVariableArray) {
            this.modified(widgetVariable);
        }
    }

    public void modified(Control control, Widget widget) {
        if (!widget.isDisposed()) {
            if (widget instanceof Label) {
                this.modified(control, (Label)widget);
            } else if (widget instanceof Button) {
                this.modified(control, (Button)widget);
            } else if (widget instanceof Combo) {
                this.modified(control, (Combo)widget);
            } else if (widget instanceof Text) {
                this.modified(control, (Text)widget);
            } else if (widget instanceof StyledText) {
                this.modified(control, (StyledText)widget);
            } else if (widget instanceof MenuItem) {
                this.modified(control, (MenuItem)widget);
            } else if (widget instanceof Table) {
                this.modified(control, (Table)widget);
            } else if (widget instanceof Tree) {
                this.modified(control, (Tree)widget);
            } else if (widget instanceof Control) {
                this.modified(control, (Control)widget);
            } else {
                this.modified(control, widget);
            }
        }
    }

    public void modified(Control control, Control control2) {
        this.modified(control);
    }

    public void modified(Control control, Button button) {
        this.modified(control);
    }

    public void modified(Control control, Combo combo) {
        this.modified(control);
    }

    public void modified(Control control, Text text) {
        this.modified(control);
    }

    public void modified(Control control, StyledText styledText) {
        this.modified(control);
    }

    public void modified(Control control, Spinner spinner) {
        this.modified(control);
    }

    public void modified(Control control, MenuItem menuItem) {
        this.modified(control);
    }

    public void modified(Control control, List list) {
        this.modified(control);
    }

    public void modified(Control control, Table table) {
        this.modified(control);
    }

    public void modified(Control control, Tree tree) {
        this.modified(control);
    }

    public void modified(Control control) {
    }

    public void modified(Button button) {
    }

    public void modified(Combo combo) {
    }

    public void modified(Text text) {
    }

    public void modified(StyledText styledText) {
    }

    public void modified(Spinner spinner) {
    }

    public void modified(MenuItem menuItem) {
    }

    public void modified(List list) {
    }

    public void modified(Table table) {
    }

    public void modified(Tree tree) {
    }

    public final void modified() {
        Object object;
        if (this.variables != null) {
            if (this.widget != null) {
                if (!this.widget.isDisposed() && !((Device)(object = this.widget.getDisplay())).isDisposed()) {
                    ((Display)object).syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (!WidgetModifyListener.this.widget.isDisposed()) {
                                    if (WidgetModifyListener.this.widget instanceof Label) {
                                        WidgetModifyListener.this.modified((Control)((Label)WidgetModifyListener.this.widget), WidgetModifyListener.this.variables);
                                    } else if (WidgetModifyListener.this.widget instanceof Button) {
                                        WidgetModifyListener.this.modified((Button)WidgetModifyListener.this.widget, WidgetModifyListener.this.variables);
                                    } else if (WidgetModifyListener.this.widget instanceof Combo) {
                                        WidgetModifyListener.this.modified((Combo)WidgetModifyListener.this.widget, WidgetModifyListener.this.variables);
                                    } else if (WidgetModifyListener.this.widget instanceof Text) {
                                        WidgetModifyListener.this.modified((Text)WidgetModifyListener.this.widget, WidgetModifyListener.this.variables);
                                    } else if (WidgetModifyListener.this.widget instanceof StyledText) {
                                        WidgetModifyListener.this.modified((StyledText)WidgetModifyListener.this.widget, WidgetModifyListener.this.variables);
                                    } else if (WidgetModifyListener.this.widget instanceof MenuItem) {
                                        WidgetModifyListener.this.modified((MenuItem)WidgetModifyListener.this.widget, WidgetModifyListener.this.variables);
                                    } else if (WidgetModifyListener.this.widget instanceof Table) {
                                        WidgetModifyListener.this.modified((Table)WidgetModifyListener.this.widget, WidgetModifyListener.this.variables);
                                    } else if (WidgetModifyListener.this.widget instanceof Tree) {
                                        WidgetModifyListener.this.modified((Tree)WidgetModifyListener.this.widget, WidgetModifyListener.this.variables);
                                    } else if (WidgetModifyListener.this.widget instanceof Control) {
                                        WidgetModifyListener.this.modified((Control)WidgetModifyListener.this.widget, WidgetModifyListener.this.variables);
                                    } else {
                                        WidgetModifyListener.this.modified(WidgetModifyListener.this.widget, WidgetModifyListener.this.variables);
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                throw new Error(throwable);
                            }
                        }
                    });
                }
            } else {
                object = this.variables;
                int n = ((WidgetVariable[])object).length;
                for (int i = 0; i < n; ++i) {
                    Object object2 = object[i];
                    if (object2 == null) continue;
                    this.parse(((WidgetVariable)object2).getString());
                }
            }
        }
        if (this.modifyWidget != null && !((Device)(object = this.widget.getDisplay())).isDisposed()) {
            ((Display)object).syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!WidgetModifyListener.this.widget.isDisposed()) {
                        WidgetModifyListener.this.modified((Control)WidgetModifyListener.this.widget, WidgetModifyListener.this.modifyWidget);
                    }
                }
            });
        }
    }

    void modified(String string) {
        this.parse(string);
    }

    public String getString(WidgetVariable widgetVariable) {
        return null;
    }

    public String toString() {
        return "WidgetModifyListener {" + this.widget + ", " + this.variables + "}";
    }
}

