/*
 * Decompiled with CFR 0.152.
 */
class WidgetVariable<T> {
    private final String name;
    private final Class type;
    private final Object[] values;
    private T value;

    public static WidgetVariable getInstance(Object object, String string) {
        WidgetVariable<Object> widgetVariable = object instanceof Boolean ? new WidgetVariable<Boolean>(string, (Boolean)object) : (object instanceof Long ? new WidgetVariable<Long>(string, (Long)object) : (object instanceof Double ? new WidgetVariable<Double>(string, (Double)object) : (object instanceof String ? new WidgetVariable<String>(string, (String)object) : (object instanceof Enum ? new WidgetVariable<Enum>(string, (Enum)object) : new WidgetVariable<Object>(string, object)))));
        return widgetVariable;
    }

    public static WidgetVariable getInstance(Object object) {
        return WidgetVariable.getInstance(object, null);
    }

    WidgetVariable(String string, T[] TArray, T t) {
        this.name = string;
        this.type = t.getClass();
        this.values = TArray;
        this.value = t;
    }

    WidgetVariable(String string, T t) {
        this(string, null, t);
    }

    WidgetVariable(T[] TArray, T t) {
        this(null, TArray, t);
    }

    WidgetVariable(T t) {
        this(null, null, t);
    }

    WidgetVariable(String string, boolean bl) {
        this.name = string;
        this.type = Boolean.class;
        this.values = null;
        this.value = bl;
    }

    WidgetVariable(boolean bl) {
        this((String)null, bl);
    }

    WidgetVariable(String string, int n) {
        this.name = string;
        this.type = Integer.class;
        this.values = null;
        this.value = n;
    }

    WidgetVariable(int n) {
        this((String)null, n);
    }

    WidgetVariable(String string, long l) {
        this.name = string;
        this.type = Long.class;
        this.values = null;
        this.value = l;
    }

    WidgetVariable(long l) {
        this((String)null, l);
    }

    WidgetVariable(String string, double d) {
        this.name = string;
        this.type = Double.class;
        this.values = null;
        this.value = d;
    }

    WidgetVariable(double d) {
        this((String)null, d);
    }

    WidgetVariable() {
        this.name = null;
        this.type = String.class;
        this.values = null;
        this.value = new String();
    }

    String getName() {
        return this.name;
    }

    Class getType() {
        return this.type;
    }

    T get() {
        return this.value;
    }

    boolean set(T t) {
        boolean bl = !this.value.equals(t);
        this.value = t;
        Widgets.modified(this);
        return bl;
    }

    boolean getBoolean() {
        assert (this.type == Boolean.class) : "invalid type " + this.type.toString();
        return (Boolean)this.value;
    }

    int getInteger() {
        assert (this.type == Integer.class) : "invalid type " + this.type.toString();
        return (Integer)this.value;
    }

    long getLong() {
        assert (this.type == Long.class) : "invalid type " + this.type.toString();
        return (Long)this.value;
    }

    double getDouble() {
        assert (this.type == Double.class) : "invalid type " + this.type.toString();
        return (Double)this.value;
    }

    String getString() {
        assert (this.type == String.class || this.type.isEnum() || this.type == Enum.class) : "invalid type " + this.type.toString();
        return this.value.toString();
    }

    T getEnum() {
        assert (this.type.isEnum() || this.type == Enum.class) : "invalid type " + this.type.toString();
        return this.value;
    }

    boolean set(boolean bl) {
        assert (this.type == Boolean.class) : "invalid type " + this.type.toString();
        boolean bl2 = (Boolean)this.value != bl;
        this.value = bl;
        Widgets.modified(this);
        return bl2;
    }

    boolean set(int n) {
        assert (this.type == Integer.class) : "invalid type " + this.type.toString();
        boolean bl = (Integer)this.value != n;
        this.value = n;
        Widgets.modified(this);
        return bl;
    }

    boolean set(long l) {
        assert (this.type == Long.class) : "invalid type " + this.type.toString();
        boolean bl = (Long)this.value != l;
        this.value = l;
        Widgets.modified(this);
        return bl;
    }

    boolean set(double d) {
        assert (this.type == Double.class) : "invalid type " + this.type.toString();
        boolean bl = (Double)this.value != d;
        this.value = d;
        Widgets.modified(this);
        return bl;
    }

    boolean set(String string) {
        boolean bl = false;
        assert (this.type == String.class || this.type.isEnum() || this.type == Enum.class) : "invalid type " + this.type.toString();
        if (this.type == String.class) {
            bl = !((String)this.value).equals(string);
            this.value = new String(string);
            Widgets.modified(this);
        } else if (this.type.isEnum() || this.type == Enum.class) {
            for (Object object : this.values) {
                if (!((String)object).equals(string)) continue;
                bl = (String)this.value != string;
                this.value = new String(string);
                Widgets.modified(this);
                break;
            }
        }
        return bl;
    }

    public boolean equals(String string) {
        String string2;
        if (this.type == Boolean.class) {
            string2 = ((Boolean)this.value).toString();
        } else if (this.type == Integer.class) {
            string2 = ((Integer)this.value).toString();
        } else if (this.type == Long.class) {
            string2 = ((Long)this.value).toString();
        } else if (this.type == Double.class) {
            string2 = ((Double)this.value).toString();
        } else if (this.type == String.class) {
            string2 = (String)this.value;
        } else if (this.type.isEnum() || this.type == Enum.class) {
            string2 = (String)this.value;
        } else {
            String string3 = string2 = this.value != null ? this.value.toString() : "";
        }
        return string2 != null ? string2.equals(string) : string == null;
    }

    public boolean equals(Object object) {
        return this.value == object;
    }

    public String toString() {
        return "WidgetVariable {" + this.name + ", " + this.type.toString() + ", " + this.value + "}";
    }
}

