/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Spinner
extends Composite {
    static final int MIN_ARROW_WIDTH = 6;
    int lastEventTime = 0;
    int imContext;
    int gdkEventKey = 0;
    int fixStart = -1;
    int fixEnd = -1;
    double climbRate = 1.0;
    public static final int LIMIT = Integer.MAX_VALUE;

    public Spinner(Composite composite, int n) {
        super(composite, Spinner.checkStyle(n));
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    static int checkStyle(int n) {
        return n & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        int n3;
        Object object;
        int n4;
        Object object2;
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gtk_widget_realize(this.handle);
        int n5 = OS.gtk_entry_get_layout(this.handle);
        int n6 = OS.gtk_spin_button_get_adjustment(this.handle);
        double d = this.gtk_adjustment_get_upper(n6);
        int n7 = OS.gtk_spin_button_get_digits(this.handle);
        for (int i = 0; i < n7; ++i) {
            d *= 10.0;
        }
        String string = String.valueOf((int)d);
        if (n7 > 0) {
            object2 = new StringBuffer();
            ((StringBuffer)object2).append(string);
            ((StringBuffer)object2).append(this.getDecimalSeparator());
            for (n4 = n7 - string.length(); n4 >= 0; --n4) {
                ((StringBuffer)object2).append("0");
            }
            string = ((StringBuffer)object2).toString();
        }
        object2 = Converter.wcsToMbcs(null, string, false);
        n4 = OS.pango_layout_get_text(n5);
        int n8 = OS.strlen(n4);
        byte[] byArray = new byte[n8];
        OS.memmove(byArray, n4, n8);
        OS.pango_layout_set_text(n5, (byte[])object2, ((Object)object2).length);
        OS.pango_layout_set_text(n5, byArray, byArray.length);
        int n9 = 0;
        OS.gtk_widget_realize(this.handle);
        if (OS.GTK3) {
            OS.gtk_widget_set_size_request(this.handle, n, n2);
            object = new GtkRequisition();
            OS.gtk_widget_get_preferred_size(this.handle, (GtkRequisition)object, null);
            n3 = n == -1 ? ((GtkRequisition)object).width : n;
            n9 = n2 == -1 ? ((GtkRequisition)object).height : n2;
        } else {
            OS.pango_layout_get_pixel_size(n5, nArray, nArray2);
            n3 = n == -1 ? nArray[0] : n;
            n9 = n2 == -1 ? nArray2[0] : n2;
        }
        object = this.computeTrim(0, 0, n3, n9);
        return new Point(((Rectangle)object).width, ((Rectangle)object).height);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        int n5;
        Object object;
        this.checkWidget();
        int n6 = 0;
        int n7 = 0;
        Rectangle rectangle = super.computeTrim(n, n2, n3, n4);
        if (OS.GTK3) {
            object = new GtkBorder();
            n5 = OS.gtk_widget_get_style_context(this.handle);
            OS.gtk_style_context_get_padding(n5, 0, (GtkBorder)object);
            if ((this.style & 0x800) != 0) {
                OS.gtk_style_context_get_border(n5, 0, (GtkBorder)object);
                rectangle.x -= ((GtkBorder)object).left;
                rectangle.y -= ((GtkBorder)object).top;
                rectangle.width += ((GtkBorder)object).left + ((GtkBorder)object).right;
                rectangle.height += ((GtkBorder)object).top + ((GtkBorder)object).bottom;
            }
        } else {
            object = this.getThickness(this.handle);
            if ((this.style & 0x800) != 0) {
                n6 += ((Point)object).x;
                n7 += ((Point)object).y;
            }
            n5 = this.getFontDescription();
            int n8 = OS.pango_font_description_get_size(n5);
            int n9 = Math.max(OS.PANGO_PIXELS(n8), 6);
            n9 -= n9 % 2;
            rectangle.width += n9 + 2 * ((Point)object).x;
        }
        object = new int[1];
        OS.gtk_widget_style_get(this.handle, OS.interior_focus, (int[])object, 0);
        if (object[0] == false) {
            OS.gtk_widget_style_get(this.handle, OS.focus_line_width, (int[])object, 0);
            n6 += object[0];
            n7 += object[0];
        }
        rectangle.x -= n6;
        rectangle.y -= n7;
        rectangle.width += 2 * n6;
        rectangle.height += 2 * n7;
        GtkBorder gtkBorder = Display.getEntryInnerBorder(this.handle);
        rectangle.x -= gtkBorder.left;
        rectangle.y -= gtkBorder.top;
        rectangle.width += gtkBorder.left + gtkBorder.right;
        rectangle.height += gtkBorder.top + gtkBorder.bottom;
        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void copy() {
        this.checkWidget();
        OS.gtk_editable_copy_clipboard(this.handle);
    }

    void createHandle(int n) {
        this.state |= 0x28;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        this.gtk_widget_set_has_window(this.fixedHandle, true);
        int n2 = OS.gtk_adjustment_new(0.0, 0.0, 100.0, 1.0, 10.0, 0.0);
        if (n2 == 0) {
            this.error(2);
        }
        this.handle = OS.gtk_spin_button_new(n2, this.climbRate, 0);
        if (this.handle == 0) {
            this.error(2);
        }
        OS.gtk_container_add(this.fixedHandle, this.handle);
        OS.gtk_editable_set_editable(this.handle, (this.style & 8) == 0);
        OS.gtk_entry_set_has_frame(this.handle, (this.style & 0x800) != 0);
        OS.gtk_spin_button_set_wrap(this.handle, (this.style & 0x40) != 0);
        if (OS.GTK3) {
            this.imContext = OS.imContextLast();
        }
        if (OS.GTK3) {
            this.setFontDescription(this.defaultFont().handle);
        }
    }

    public void cut() {
        this.checkWidget();
        OS.gtk_editable_cut_clipboard(this.handle);
    }

    void deregister() {
        super.deregister();
        int n = this.imContext();
        if (n != 0) {
            this.display.removeWidget(n);
        }
    }

    int eventWindow() {
        return this.paintWindow();
    }

    int enterExitHandle() {
        return this.fixedHandle;
    }

    boolean filterKey(int n, int n2) {
        int n3 = OS.gdk_event_get_time(n2);
        if (n3 != this.lastEventTime) {
            this.lastEventTime = n3;
            int n4 = this.imContext();
            if (n4 != 0) {
                return OS.gtk_im_context_filter_keypress(n4, n2);
            }
        }
        this.gdkEventKey = n2;
        return false;
    }

    void fixIM() {
        int n;
        if (this.gdkEventKey != 0 && this.gdkEventKey != -1 && (n = this.imContext()) != 0) {
            OS.gtk_im_context_filter_keypress(n, this.gdkEventKey);
            this.gdkEventKey = -1;
            return;
        }
        this.gdkEventKey = 0;
    }

    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    public int getBorderWidth() {
        this.checkWidget();
        if ((this.style & 0x800) != 0) {
            return this.getThickness((int)this.handle).x;
        }
        return 0;
    }

    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public int getIncrement() {
        this.checkWidget();
        int n = OS.gtk_spin_button_get_adjustment(this.handle);
        int n2 = OS.gtk_spin_button_get_digits(this.handle);
        double d = this.gtk_adjustment_get_step_increment(n);
        for (int i = 0; i < n2; ++i) {
            d *= 10.0;
        }
        return (int)(d > 0.0 ? d + 0.5 : d - 0.5);
    }

    public int getMaximum() {
        this.checkWidget();
        int n = OS.gtk_spin_button_get_adjustment(this.handle);
        int n2 = OS.gtk_spin_button_get_digits(this.handle);
        double d = this.gtk_adjustment_get_upper(n);
        for (int i = 0; i < n2; ++i) {
            d *= 10.0;
        }
        return (int)(d > 0.0 ? d + 0.5 : d - 0.5);
    }

    public int getMinimum() {
        this.checkWidget();
        int n = OS.gtk_spin_button_get_adjustment(this.handle);
        int n2 = OS.gtk_spin_button_get_digits(this.handle);
        double d = this.gtk_adjustment_get_lower(n);
        for (int i = 0; i < n2; ++i) {
            d *= 10.0;
        }
        return (int)(d > 0.0 ? d + 0.5 : d - 0.5);
    }

    public int getPageIncrement() {
        this.checkWidget();
        int n = OS.gtk_spin_button_get_adjustment(this.handle);
        int n2 = OS.gtk_spin_button_get_digits(this.handle);
        double d = this.gtk_adjustment_get_page_increment(n);
        for (int i = 0; i < n2; ++i) {
            d *= 10.0;
        }
        return (int)(d > 0.0 ? d + 0.5 : d - 0.5);
    }

    public int getSelection() {
        this.checkWidget();
        int n = OS.gtk_spin_button_get_adjustment(this.handle);
        int n2 = OS.gtk_spin_button_get_digits(this.handle);
        double d = this.gtk_adjustment_get_value(n);
        for (int i = 0; i < n2; ++i) {
            d *= 10.0;
        }
        return (int)(d > 0.0 ? d + 0.5 : d - 0.5);
    }

    public String getText() {
        this.checkWidget();
        int n = OS.gtk_entry_get_text(this.handle);
        if (n == 0) {
            return "";
        }
        int n2 = OS.strlen(n);
        byte[] byArray = new byte[n2];
        OS.memmove(byArray, n, n2);
        return new String(Converter.mbcsToWcs(null, byArray));
    }

    public int getTextLimit() {
        this.checkWidget();
        int n = OS.gtk_entry_get_max_length(this.handle);
        return n == 0 ? 65535 : n;
    }

    public int getDigits() {
        this.checkWidget();
        return OS.gtk_spin_button_get_digits(this.handle);
    }

    String getDecimalSeparator() {
        int n = OS.localeconv_decimal_point();
        int n2 = OS.strlen(n);
        byte[] byArray = new byte[n2];
        OS.memmove(byArray, n, n2);
        return new String(Converter.mbcsToWcs(null, byArray));
    }

    int gtk_activate(int n) {
        this.sendSelectionEvent(14);
        return 0;
    }

    int gtk_changed(int n) {
        int n2 = OS.gtk_entry_get_text(this.handle);
        int n3 = OS.strlen(n2);
        if (n3 > 0) {
            int[] nArray = new int[1];
            double d = OS.g_strtod(n2, nArray);
            if (nArray[0] == n2 + n3) {
                int n4 = OS.gtk_spin_button_get_adjustment(this.handle);
                GtkAdjustment gtkAdjustment = new GtkAdjustment();
                this.gtk_adjustment_get(n4, gtkAdjustment);
                if (d != gtkAdjustment.value && gtkAdjustment.lower <= d && d <= gtkAdjustment.upper) {
                    OS.gtk_spin_button_update(this.handle);
                }
            }
        }
        boolean bl = false;
        int n5 = OS.gtk_get_current_event();
        if (n5 != 0) {
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, n5, GdkEventKey.sizeof);
            switch (gdkEventKey.type) {
                case 8: {
                    bl = true;
                }
            }
            OS.gdk_event_free(n5);
        }
        if (bl) {
            this.postEvent(24);
        } else {
            this.sendEvent(24);
        }
        return 0;
    }

    int gtk_commit(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        if (!OS.gtk_editable_get_editable(this.handle)) {
            return 0;
        }
        int n3 = OS.strlen(n2);
        if (n3 == 0) {
            return 0;
        }
        byte[] byArray = new byte[n3];
        OS.memmove(byArray, n2, n3);
        char[] cArray = Converter.mbcsToWcs(null, byArray);
        char[] cArray2 = this.sendIMKeyEvent(1, null, cArray);
        if (cArray2 == null) {
            return 0;
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        OS.g_signal_handlers_block_matched(n, 16, 0, 0, 0, 0, 9);
        int n4 = OS.g_signal_lookup(OS.commit, OS.gtk_im_context_get_type());
        int n5 = 17;
        OS.g_signal_handlers_unblock_matched(n, n5, n4, 0, 0, 0, this.handle);
        if (cArray2 == cArray) {
            OS.g_signal_emit_by_name(n, OS.commit, n2);
        } else {
            byArray = Converter.wcsToMbcs(null, cArray2, true);
            OS.g_signal_emit_by_name(n, OS.commit, byArray);
        }
        OS.g_signal_handlers_unblock_matched(n, 16, 0, 0, 0, 0, 9);
        OS.g_signal_handlers_block_matched(n, n5, n4, 0, 0, 0, this.handle);
        if (this.fixStart != -1 && this.fixEnd != -1) {
            OS.gtk_editable_set_position(this.handle, this.fixStart);
            OS.gtk_editable_select_region(this.handle, this.fixStart, this.fixEnd);
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        return 0;
    }

    int gtk_delete_text(int n, int n2, int n3) {
        int n4;
        int n5;
        String string;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0;
        }
        int n6 = OS.gtk_entry_get_text(this.handle);
        if (n3 == -1) {
            n3 = OS.g_utf8_strlen(n6, -1);
        }
        if ((string = this.verifyText("", n5 = OS.g_utf8_offset_to_utf16_offset(n6, n2), n4 = OS.g_utf8_offset_to_utf16_offset(n6, n3))) == null) {
            OS.g_signal_stop_emission_by_name(this.handle, OS.delete_text);
        } else if (string.length() > 0) {
            int[] nArray = new int[]{n3};
            byte[] byArray = Converter.wcsToMbcs(null, string, false);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 26);
            OS.gtk_editable_insert_text(this.handle, byArray, byArray.length, nArray);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 26);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 6);
            OS.gtk_editable_set_position(this.handle, nArray[0]);
        }
        return 0;
    }

    int gtk_event_after(int n, int n2) {
        if (this.cursor != null) {
            this.setCursor(this.cursor.handle);
        }
        return super.gtk_event_after(n, n2);
    }

    int gtk_focus_out_event(int n, int n2) {
        this.fixIM();
        return super.gtk_focus_out_event(n, n2);
    }

    int gtk_insert_text(int n, int n2, int n3, int n4) {
        int n5;
        String string;
        if (n2 == 0 || n3 == 0) {
            return 0;
        }
        byte[] byArray = new byte[n3];
        OS.memmove(byArray, n2, byArray.length);
        String string2 = new String(Converter.mbcsToWcs(null, byArray));
        int[] nArray = new int[1];
        OS.memmove(nArray, n4, 4);
        int n6 = OS.gtk_entry_get_text(this.handle);
        if (nArray[0] == -1) {
            nArray[0] = OS.g_utf8_strlen(n6, -1);
        }
        if ((string = this.verifyText(string2, n5 = OS.g_utf16_pointer_to_offset(n6, nArray[0]), n5)) != string2) {
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            OS.gtk_editable_get_selection_bounds(this.handle, nArray2, nArray3);
            if (string != null) {
                if (nArray2[0] != nArray3[0]) {
                    OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 13);
                    OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 6);
                    OS.gtk_editable_delete_selection(this.handle);
                    OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 13);
                    OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 6);
                }
                byte[] byArray2 = Converter.wcsToMbcs(null, string, false);
                OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 26);
                OS.gtk_editable_insert_text(this.handle, byArray2, byArray2.length, nArray);
                OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 26);
                nArray2[0] = nArray3[0] = nArray[0];
            }
            nArray[0] = nArray3[0];
            if (nArray2[0] != nArray3[0]) {
                this.fixStart = nArray2[0];
                this.fixEnd = nArray3[0];
            }
            OS.memmove(n4, nArray, 4);
            OS.g_signal_stop_emission_by_name(this.handle, OS.insert_text);
        }
        return 0;
    }

    int gtk_key_press_event(int n, int n2) {
        int n3 = super.gtk_key_press_event(n, n2);
        if (n3 != 0) {
            this.fixIM();
        }
        if (this.gdkEventKey == -1) {
            n3 = 1;
        }
        this.gdkEventKey = 0;
        return n3;
    }

    int gtk_populate_popup(int n, int n2) {
        if ((this.style & 0x4000000) != 0) {
            OS.gtk_widget_set_direction(n2, 2);
            OS.gtk_container_forall(n2, this.display.setDirectionProc, 2);
        }
        return 0;
    }

    int gtk_value_changed(int n) {
        this.sendSelectionEvent(13);
        return 0;
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.changed, this.display.getClosure(6), true);
        OS.g_signal_connect_closure(this.handle, OS.insert_text, this.display.getClosure(26), false);
        OS.g_signal_connect_closure(this.handle, OS.delete_text, this.display.getClosure(13), false);
        OS.g_signal_connect_closure(this.handle, OS.value_changed, this.display.getClosure(57), false);
        OS.g_signal_connect_closure(this.handle, OS.activate, this.display.getClosure(1), false);
        OS.g_signal_connect_closure(this.handle, OS.populate_popup, this.display.getClosure(37), false);
        int n = this.imContext();
        if (n != 0) {
            OS.g_signal_connect_closure(n, OS.commit, this.display.getClosure(9), false);
            int n2 = OS.g_signal_lookup(OS.commit, OS.gtk_im_context_get_type());
            int n3 = 17;
            OS.g_signal_handlers_block_matched(n, n3, n2, 0, 0, 0, this.handle);
        }
    }

    int imContext() {
        if (this.imContext != 0) {
            return this.imContext;
        }
        return OS.GTK_ENTRY_IM_CONTEXT(this.handle);
    }

    int paintWindow() {
        int n = super.paintWindow();
        int n2 = OS.gdk_window_get_children(n);
        if (n2 != 0) {
            n = OS.g_list_data(n2);
        }
        OS.g_list_free(n2);
        return n;
    }

    public void paste() {
        this.checkWidget();
        OS.gtk_editable_paste_clipboard(this.handle);
    }

    void register() {
        super.register();
        int n = this.imContext();
        if (n != 0) {
            this.display.addWidget(n, this);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.fixIM();
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    void setBackgroundColor(int n, int n2, GdkRGBA gdkRGBA) {
        this.setBackgroundColorGradient(n, n2, gdkRGBA);
    }

    void setBackgroundColor(GdkColor gdkColor) {
        super.setBackgroundColor(gdkColor);
        if (!OS.GTK3) {
            OS.gtk_widget_modify_base(this.handle, 0, gdkColor);
        }
    }

    void setCursor(int n) {
        int n2 = 0;
        if (n == 0) {
            n2 = OS.gdk_cursor_new(152);
        }
        super.setCursor(n != 0 ? n : n2);
        if (n == 0) {
            this.gdk_cursor_unref(n2);
        }
    }

    void setForegroundColor(GdkColor gdkColor) {
        this.setForegroundColor(this.handle, gdkColor, false);
    }

    public void setIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        int n2 = OS.gtk_spin_button_get_adjustment(this.handle);
        double d = this.gtk_adjustment_get_page_increment(n2);
        double d2 = n;
        int n3 = OS.gtk_spin_button_get_digits(this.handle);
        for (int i = 0; i < n3; ++i) {
            d2 /= 10.0;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 57);
        OS.gtk_spin_button_set_increments(this.handle, d2, d);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 57);
    }

    public void setMaximum(int n) {
        this.checkWidget();
        int n2 = OS.gtk_spin_button_get_adjustment(this.handle);
        double d = this.gtk_adjustment_get_lower(n2);
        double d2 = n;
        int n3 = OS.gtk_spin_button_get_digits(this.handle);
        for (int i = 0; i < n3; ++i) {
            d2 /= 10.0;
        }
        if (d2 < d) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 57);
        OS.gtk_spin_button_set_range(this.handle, d, d2);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 57);
    }

    public void setMinimum(int n) {
        this.checkWidget();
        int n2 = OS.gtk_spin_button_get_adjustment(this.handle);
        double d = this.gtk_adjustment_get_upper(n2);
        double d2 = n;
        int n3 = OS.gtk_spin_button_get_digits(this.handle);
        for (int i = 0; i < n3; ++i) {
            d2 /= 10.0;
        }
        if (d2 > d) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 57);
        OS.gtk_spin_button_set_range(this.handle, d2, d);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 57);
    }

    public void setPageIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        int n2 = OS.gtk_spin_button_get_adjustment(this.handle);
        double d = this.gtk_adjustment_get_step_increment(n2);
        double d2 = n;
        int n3 = OS.gtk_spin_button_get_digits(this.handle);
        for (int i = 0; i < n3; ++i) {
            d2 /= 10.0;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 57);
        OS.gtk_spin_button_set_increments(this.handle, d, d2);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 57);
    }

    public void setSelection(int n) {
        this.checkWidget();
        double d = n;
        int n2 = OS.gtk_spin_button_get_digits(this.handle);
        for (int i = 0; i < n2; ++i) {
            d /= 10.0;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 57);
        OS.gtk_spin_button_set_value(this.handle, d);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 57);
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            this.error(7);
        }
        OS.gtk_entry_set_max_length(this.handle, n);
    }

    public void setDigits(int n) {
        int n2;
        this.checkWidget();
        if (n < 0) {
            this.error(5);
        }
        if (n == (n2 = OS.gtk_spin_button_get_digits(this.handle))) {
            return;
        }
        int n3 = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        this.gtk_adjustment_get(n3, gtkAdjustment);
        int n4 = Math.abs(n - n2);
        int n5 = 1;
        for (int i = 0; i < n4; ++i) {
            n5 *= 10;
        }
        if (n2 > n) {
            gtkAdjustment.value *= (double)n5;
            gtkAdjustment.upper *= (double)n5;
            gtkAdjustment.lower *= (double)n5;
            gtkAdjustment.step_increment *= (double)n5;
            gtkAdjustment.page_increment *= (double)n5;
            this.climbRate *= (double)n5;
        } else {
            gtkAdjustment.value /= (double)n5;
            gtkAdjustment.upper /= (double)n5;
            gtkAdjustment.lower /= (double)n5;
            gtkAdjustment.step_increment /= (double)n5;
            gtkAdjustment.page_increment /= (double)n5;
            this.climbRate /= (double)n5;
        }
        this.gtk_adjustment_configure(n3, gtkAdjustment);
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 57);
        OS.gtk_spin_button_configure(this.handle, n3, this.climbRate, n);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 57);
    }

    public void setValues(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        this.checkWidget();
        if (n3 < n2) {
            return;
        }
        if (n4 < 0) {
            return;
        }
        if (n5 < 1) {
            return;
        }
        if (n6 < 1) {
            return;
        }
        n = Math.min(Math.max(n2, n), n3);
        double d = 1.0;
        for (n7 = 0; n7 < n4; ++n7) {
            d *= 10.0;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 57);
        OS.gtk_spin_button_set_range(this.handle, (double)n2 / d, (double)n3 / d);
        OS.gtk_spin_button_set_increments(this.handle, (double)n5 / d, (double)n6 / d);
        OS.gtk_spin_button_set_value(this.handle, (double)n / d);
        this.climbRate = 1.0 / d;
        n7 = OS.gtk_spin_button_get_adjustment(this.handle);
        OS.gtk_spin_button_configure(this.handle, n7, this.climbRate, n4);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 57);
    }

    boolean checkSubwindow() {
        return false;
    }

    boolean translateTraversal(GdkEventKey gdkEventKey) {
        int n = gdkEventKey.keyval;
        switch (n) {
            case 65293: 
            case 65421: {
                int n2 = this.imContext();
                if (n2 == 0) break;
                int[] nArray = new int[1];
                OS.gtk_im_context_get_preedit_string(n2, nArray, null, null);
                if (nArray[0] == 0) break;
                int n3 = OS.strlen(nArray[0]);
                OS.g_free(nArray[0]);
                if (n3 == 0) break;
                return false;
            }
        }
        return super.translateTraversal(gdkEventKey);
    }

    String verifyText(String string, int n, int n2) {
        int n3;
        double d;
        if (string.length() == 0 && n == n2) {
            return null;
        }
        Event event = new Event();
        event.text = string;
        event.start = n;
        event.end = n2;
        int n4 = OS.gtk_get_current_event();
        if (n4 != 0) {
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, n4, GdkEventKey.sizeof);
            switch (gdkEventKey.type) {
                case 8: {
                    this.setKeyState(event, gdkEventKey);
                }
            }
            OS.gdk_event_free(n4);
        }
        int n5 = 0;
        if (OS.gtk_spin_button_get_digits(this.handle) > 0) {
            String string2 = this.getDecimalSeparator();
            n5 = string.indexOf(string2);
            if (n5 != -1) {
                string = string.substring(0, n5) + string.substring(n5 + 1);
            }
            n5 = 0;
        }
        if (string.length() > 0 && (d = this.gtk_adjustment_get_lower(n3 = OS.gtk_spin_button_get_adjustment(this.handle))) < 0.0 && string.charAt(0) == '-') {
            ++n5;
        }
        while (n5 < string.length() && Character.isDigit(string.charAt(n5))) {
            ++n5;
        }
        event.doit = n5 == string.length();
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

