/*
 * Decompiled with CFR 0.152.
 */
import java.util.EnumSet;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class BARWidgets {
    private static final Color COLOR_MODIFIED = new Color(null, 255, 160, 160);
    private static final Image IMAGE_DIRECTORY = Widgets.loadImage(Display.getDefault(), "directory.png");

    public static Text newText(Composite composite, String string, final WidgetVariable widgetVariable, final Listener listener) {
        Text text = Widgets.newText(composite, 18432);
        text.setToolTipText(string);
        text.setText(listener != null ? listener.getString(widgetVariable) : widgetVariable.getString());
        text.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                String string;
                Text text = (Text)modifyEvent.widget;
                Color color = COLOR_MODIFIED;
                if ((listener != null ? listener.getString(widgetVariable) : widgetVariable.getString()).equals(string = text.getText())) {
                    color = null;
                }
                text.setBackground(color);
            }
        });
        text.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                Text text = (Text)selectionEvent.widget;
                String string = text.getText();
                if (listener != null) {
                    listener.setString(widgetVariable, string);
                } else {
                    widgetVariable.set(string);
                }
                text.setBackground(null);
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
            }
        });
        text.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Text text = (Text)focusEvent.widget;
                String string = text.getText();
                if (listener != null) {
                    listener.setString(widgetVariable, string);
                } else {
                    widgetVariable.set(string);
                }
                text.setBackground(null);
            }
        });
        final WidgetModifyListener widgetModifyListener = listener != null ? new WidgetModifyListener((Widget)text, new WidgetVariable[]{widgetVariable}){

            @Override
            public void modified(Text text, WidgetVariable widgetVariable2) {
                text.setText(listener.getString(widgetVariable));
            }
        } : new WidgetModifyListener((Widget)text, widgetVariable);
        Widgets.addModifyListener(widgetModifyListener);
        text.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent disposeEvent) {
                Widgets.removeModifyListener(widgetModifyListener);
            }
        });
        if (listener != null) {
            text.setText(listener.getString(widgetVariable));
        } else {
            text.setText(widgetVariable.getString());
        }
        return text;
    }

    public static Text newText(Composite composite, String string, WidgetVariable widgetVariable) {
        return BARWidgets.newText(composite, string, widgetVariable, null);
    }

    public static Spinner newNumber(Composite composite, String string, final WidgetVariable widgetVariable, final Listener listener, int n, int n2) {
        Spinner spinner = Widgets.newSpinner(composite);
        spinner.setToolTipText(string);
        spinner.setMinimum(n);
        spinner.setMaximum(n2);
        spinner.setSelection(listener != null ? listener.getInt(widgetVariable) : widgetVariable.getInteger());
        spinner.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                Spinner spinner = (Spinner)modifyEvent.widget;
                int n = spinner.getSelection();
                Color color = COLOR_MODIFIED;
                if (listener != null) {
                    if (listener.getInt(widgetVariable) == n) {
                        color = null;
                    }
                } else if (widgetVariable.getInteger() == n) {
                    color = null;
                }
                spinner.setBackground(color);
                spinner.setData("showedErrorDialog", false);
            }
        });
        spinner.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                Spinner spinner = (Spinner)selectionEvent.widget;
                int n = spinner.getSelection();
                if (listener != null) {
                    listener.setInt(widgetVariable, n);
                } else {
                    widgetVariable.set(n);
                }
                spinner.setBackground(null);
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Spinner spinner = (Spinner)selectionEvent.widget;
                int n = spinner.getSelection();
                if (listener != null) {
                    listener.setInt(widgetVariable, n);
                } else {
                    widgetVariable.set(n);
                }
                spinner.setBackground(null);
            }
        });
        spinner.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                Spinner spinner = (Spinner)focusEvent.widget;
                spinner.setData("showedErrorDialog", false);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Spinner spinner = (Spinner)focusEvent.widget;
                int n = spinner.getSelection();
                if (listener != null) {
                    listener.setInt(widgetVariable, n);
                } else {
                    widgetVariable.set(n);
                }
                spinner.setBackground(null);
            }
        });
        final WidgetModifyListener widgetModifyListener = listener != null ? new WidgetModifyListener((Widget)spinner, new WidgetVariable[]{widgetVariable}){

            @Override
            public void modified(Spinner spinner, WidgetVariable widgetVariable2) {
                spinner.setSelection(listener.getInt(widgetVariable));
            }
        } : new WidgetModifyListener((Widget)spinner, widgetVariable);
        Widgets.addModifyListener(widgetModifyListener);
        spinner.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent disposeEvent) {
                Widgets.removeModifyListener(widgetModifyListener);
            }
        });
        if (listener != null) {
            spinner.setSelection(listener.getInt(widgetVariable));
        } else {
            spinner.setSelection(widgetVariable.getInteger());
        }
        return spinner;
    }

    public static Spinner newNumber(Composite composite, String string, WidgetVariable widgetVariable, int n, int n2) {
        return BARWidgets.newNumber(composite, string, widgetVariable, null, n, n2);
    }

    public static Button newCheckbox(Composite composite, String string, final WidgetVariable widgetVariable, final Listener listener, String string2) {
        Button button = Widgets.newCheckbox(composite, string2);
        button.setToolTipText(string);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                boolean bl = button.getSelection();
                if (listener != null) {
                    listener.setChecked(widgetVariable, bl);
                } else {
                    widgetVariable.set(bl);
                }
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                boolean bl = button.getSelection();
                if (listener != null) {
                    listener.setChecked(widgetVariable, bl);
                } else {
                    widgetVariable.set(bl);
                }
            }
        });
        final WidgetModifyListener widgetModifyListener = listener != null ? new WidgetModifyListener((Widget)button, new WidgetVariable[]{widgetVariable}){

            @Override
            public void modified(Button button, WidgetVariable widgetVariable2) {
                button.setSelection(listener.getChecked(widgetVariable));
            }
        } : new WidgetModifyListener((Widget)button, widgetVariable);
        Widgets.addModifyListener(widgetModifyListener);
        button.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent disposeEvent) {
                Widgets.removeModifyListener(widgetModifyListener);
            }
        });
        if (listener != null) {
            button.setSelection(listener.getChecked(widgetVariable));
        } else {
            button.setSelection(widgetVariable.getBoolean());
        }
        return button;
    }

    public static Button newCheckbox(Composite composite, String string, WidgetVariable widgetVariable, String string2) {
        return BARWidgets.newCheckbox(composite, string, widgetVariable, null, string2);
    }

    public static Button newRadio(Composite composite, String string, final WidgetVariable widgetVariable, final Listener listener, String string2) {
        Button button = Widgets.newRadio(composite, string2);
        button.setToolTipText(string);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                boolean bl = button.getSelection();
                if (listener != null) {
                    listener.setChecked(widgetVariable, bl);
                } else {
                    widgetVariable.set(bl);
                }
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                boolean bl = button.getSelection();
                if (listener != null) {
                    listener.setChecked(widgetVariable, bl);
                } else {
                    widgetVariable.set(bl);
                }
            }
        });
        final WidgetModifyListener widgetModifyListener = listener != null ? new WidgetModifyListener((Widget)button, new WidgetVariable[]{widgetVariable}){

            @Override
            public void modified(Button button, WidgetVariable widgetVariable2) {
                button.setSelection(listener.getChecked(widgetVariable));
            }
        } : new WidgetModifyListener((Widget)button, widgetVariable);
        Widgets.addModifyListener(widgetModifyListener);
        button.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent disposeEvent) {
                Widgets.removeModifyListener(widgetModifyListener);
            }
        });
        if (listener != null) {
            button.setSelection(listener.getChecked(widgetVariable));
        } else {
            button.setSelection(widgetVariable.getBoolean());
        }
        return button;
    }

    public static Button newRadio(Composite composite, String string, WidgetVariable widgetVariable, String string2) {
        return BARWidgets.newRadio(composite, string, widgetVariable, null, string2);
    }

    private static long getSize(Object[] objectArray, String string, int n) {
        int n2;
        long l = 0L;
        assert (objectArray.length % 2 == 0);
        for (n2 = 0; n2 < objectArray.length / 2; ++n2) {
            if (!string.equals((String)objectArray[n2 * 2 + 0])) continue;
            l = (Long)objectArray[n2 * 2 + 1];
            break;
        }
        if (n2 >= objectArray.length / 2) {
            try {
                l = Units.parseByteSize(string);
            }
            catch (NumberFormatException numberFormatException) {
                if (n >= 0) {
                    l = (Long)objectArray[n * 2 + 1];
                }
                throw numberFormatException;
            }
        }
        return l;
    }

    private static long getSize(Object[] objectArray, String string) {
        return BARWidgets.getSize(objectArray, string, -1);
    }

    private static String getSizeString(Object[] objectArray, String string, int n) {
        int n2;
        assert (objectArray.length % 2 == 0);
        for (n2 = 0; n2 < objectArray.length / 2 && !string.equals(objectArray[n2 * 2 + 0]); ++n2) {
        }
        if (n2 >= objectArray.length / 2) {
            try {
                long l = Units.parseByteSize(string);
                for (n2 = 0; n2 < objectArray.length / 2; ++n2) {
                    if (l != (Long)objectArray[n2 * 2 + 1]) continue;
                    string = (String)objectArray[n2 * 2 + 0];
                    break;
                }
                if (n2 >= objectArray.length / 2) {
                    string = Units.getSize(l) + " " + Units.getUnit(l);
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (n >= 0) {
                    string = (String)objectArray[n * 2 + 0];
                }
                throw numberFormatException;
            }
        }
        return string;
    }

    private static String getSizeString(Object[] objectArray, String string) {
        return BARWidgets.getSizeString(objectArray, string, -1);
    }

    public static Combo newByteSize(Composite composite, String string, final WidgetVariable widgetVariable, final Listener listener, final Object[] objectArray) {
        final Shell shell = composite.getShell();
        assert (objectArray.length % 2 == 0);
        String[] stringArray = new String[objectArray.length / 2];
        for (int i = 0; i < objectArray.length / 2; ++i) {
            stringArray[i] = (String)objectArray[i * 2 + 0];
        }
        Combo combo = Widgets.newCombo(composite);
        combo.setToolTipText(string);
        combo.setItems(stringArray);
        combo.setData("showedErrorDialog", false);
        if (widgetVariable != null) {
            combo.addModifyListener(new ModifyListener(){

                @Override
                public void modifyText(ModifyEvent modifyEvent) {
                    Combo combo = (Combo)modifyEvent.widget;
                    Color color = COLOR_MODIFIED;
                    try {
                        long l = BARWidgets.getSize(objectArray, combo.getText());
                        long l2 = listener != null ? BARWidgets.getSize(objectArray, listener.getString(widgetVariable), 0) : BARWidgets.getSize(objectArray, widgetVariable.getString(), 0);
                        if (l == l2) {
                            color = null;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    combo.setBackground(color);
                    combo.setData("showedErrorDialog", false);
                }
            });
        }
        combo.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                long l;
                String string;
                Combo combo;
                block5: {
                    combo = (Combo)selectionEvent.widget;
                    string = combo.getText();
                    l = 0L;
                    try {
                        string = BARWidgets.getSizeString(objectArray, string);
                        l = BARWidgets.getSize(objectArray, string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (((Boolean)combo.getData("showedErrorDialog")).booleanValue()) break block5;
                        combo.setData("showedErrorDialog", true);
                        Dialogs.error(shell, BARControl.tr("''{0}'' is not a valid size!\n\nEnter a number in the format ''n'' or ''n.m''. Optional units are KB, MB, or GB.", string));
                        combo.forceFocus();
                    }
                }
                if (widgetVariable != null) {
                    if (listener != null) {
                        listener.setString(widgetVariable, Units.formatSize(l));
                    } else {
                        widgetVariable.set(Units.formatSize(l));
                    }
                }
                combo.setText(string);
                combo.setBackground(null);
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                long l;
                String string;
                Combo combo;
                block5: {
                    combo = (Combo)selectionEvent.widget;
                    string = combo.getText();
                    l = 0L;
                    try {
                        string = BARWidgets.getSizeString(objectArray, string);
                        l = BARWidgets.getSize(objectArray, string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (((Boolean)combo.getData("showedErrorDialog")).booleanValue()) break block5;
                        combo.setData("showedErrorDialog", true);
                        Dialogs.error(shell, BARControl.tr("''{0}'' is not a valid size!\n\nEnter a number in the format ''n'' or ''n.m''. Optional units are KB, MB, or GB.", string));
                        combo.forceFocus();
                    }
                }
                if (widgetVariable != null) {
                    if (listener != null) {
                        listener.setString(widgetVariable, Units.formatSize(l));
                    } else {
                        widgetVariable.set(Units.formatSize(l));
                    }
                }
                combo.setText(string);
                combo.setBackground(null);
            }
        });
        combo.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                Combo combo = (Combo)focusEvent.widget;
                combo.setData("showedErrorDialog", false);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Combo combo = (Combo)focusEvent.widget;
                String string = combo.getText();
                if (!string.isEmpty()) {
                    long l;
                    block6: {
                        l = 0L;
                        try {
                            string = BARWidgets.getSizeString(objectArray, string);
                            l = BARWidgets.getSize(objectArray, string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (((Boolean)combo.getData("showedErrorDialog")).booleanValue()) break block6;
                            combo.setData("showedErrorDialog", true);
                            Dialogs.error(shell, BARControl.tr("''{0}'' is not a valid size!\n\nEnter a number in the format ''n'' or ''n.m''. Optional units are KB, MB, or GB.", string));
                            combo.forceFocus();
                        }
                    }
                    if (widgetVariable != null) {
                        if (listener != null) {
                            listener.setString(widgetVariable, Units.formatSize(l));
                        } else {
                            widgetVariable.set(Units.formatSize(l));
                        }
                    }
                    combo.setText(string);
                    combo.setBackground(null);
                }
            }
        });
        if (widgetVariable != null) {
            final WidgetModifyListener widgetModifyListener = listener != null ? new WidgetModifyListener((Widget)combo, new WidgetVariable[]{widgetVariable}){

                @Override
                public void modified(Combo combo, WidgetVariable widgetVariable2) {
                    combo.setText(BARWidgets.getSizeString(objectArray, listener.getString(widgetVariable), 0));
                }
            } : new WidgetModifyListener((Widget)combo, new WidgetVariable[]{widgetVariable}){

                @Override
                public String getString(WidgetVariable widgetVariable) {
                    return BARWidgets.getSizeString(objectArray, widgetVariable.getString(), 0);
                }
            };
            Widgets.addModifyListener(widgetModifyListener);
            combo.addDisposeListener(new DisposeListener(){

                @Override
                public void widgetDisposed(DisposeEvent disposeEvent) {
                    Widgets.removeModifyListener(widgetModifyListener);
                }
            });
        }
        if (widgetVariable != null) {
            String string2 = listener != null ? listener.getString(widgetVariable) : widgetVariable.getString();
            combo.setText(BARWidgets.getSizeString(objectArray, string2, 0));
        }
        return combo;
    }

    public static Combo newByteSize(Composite composite, String string, WidgetVariable widgetVariable, Object[] objectArray) {
        return BARWidgets.newByteSize(composite, string, widgetVariable, null, objectArray);
    }

    public static Combo newByteSize(Composite composite, String string, Listener listener, Object[] objectArray) {
        return BARWidgets.newByteSize(composite, string, null, listener, objectArray);
    }

    public static Combo newByteSize(Composite composite, String string, Object[] objectArray) {
        return BARWidgets.newByteSize(composite, string, (Listener)null, objectArray);
    }

    public static Combo newTime(Composite composite, String string, final WidgetVariable widgetVariable, String[] stringArray, final Listener listener) {
        final Shell shell = composite.getShell();
        Combo combo = Widgets.newCombo(composite);
        combo.setToolTipText(string);
        combo.setItems(stringArray);
        combo.setData("showedErrorDialog", false);
        combo.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                Combo combo = (Combo)modifyEvent.widget;
                String string = combo.getText();
                Color color = COLOR_MODIFIED;
                try {
                    if (!string.isEmpty()) {
                        long l = Units.parseLocalizedTime(string);
                        if (listener != null) {
                            string = listener.getString(widgetVariable);
                            if (!string.isEmpty()) {
                                if (Units.parseTime(string) == l) {
                                    color = null;
                                }
                            } else {
                                color = null;
                            }
                        } else {
                            string = widgetVariable.getString();
                            if (!string.isEmpty()) {
                                if (Units.parseTime(string) == l) {
                                    color = null;
                                }
                            } else {
                                color = null;
                            }
                        }
                    } else {
                        color = null;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                combo.setBackground(color);
                combo.setData("showedErrorDialog", false);
            }
        });
        combo.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                Combo combo = (Combo)selectionEvent.widget;
                long l = 0L;
                String string = combo.getText();
                try {
                    if (!string.isEmpty()) {
                        l = Units.parseLocalizedTime(string);
                        string = Units.formatTime(l);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (!((Boolean)combo.getData("showedErrorDialog")).booleanValue()) {
                        combo.setData("showedErrorDialog", true);
                        Dialogs.error(shell, BARControl.tr("''{0}'' is not valid time!\n\nEnter a time in the format ''n<{1}|{2}|{3}|{4}|{5}>''", string, BARControl.tr("week", new Object[0]), BARControl.tr("day", new Object[0]), BARControl.tr("h", new Object[0]), BARControl.tr("min", new Object[0]), BARControl.tr("s", new Object[0])));
                    }
                    combo.forceFocus();
                    return;
                }
                if (listener != null) {
                    listener.setString(widgetVariable, string);
                } else {
                    widgetVariable.set(string);
                }
                combo.setText(Units.formatLocalizedTime(l));
                combo.setBackground(null);
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Combo combo = (Combo)selectionEvent.widget;
                long l = 0L;
                String string = combo.getText();
                try {
                    if (!string.isEmpty()) {
                        l = Units.parseLocalizedTime(string);
                        string = Units.formatTime(l);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (!((Boolean)combo.getData("showedErrorDialog")).booleanValue()) {
                        combo.setData("showedErrorDialog", true);
                        Dialogs.error(shell, BARControl.tr("''{0}'' is not valid time!\n\nEnter a time in the format ''n<{1}|{2}|{3}|{4}|{5}>''", string, BARControl.tr("weeks", new Object[0]), BARControl.tr("days", new Object[0]), BARControl.tr("h", new Object[0]), BARControl.tr("mins", new Object[0]), BARControl.tr("s", new Object[0])));
                    }
                    combo.forceFocus();
                    return;
                }
                if (listener != null) {
                    listener.setString(widgetVariable, string);
                } else {
                    widgetVariable.set(string);
                }
                combo.setText(Units.formatLocalizedTime(l));
                combo.setBackground(null);
            }
        });
        combo.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                Combo combo = (Combo)focusEvent.widget;
                combo.setData("showedErrorDialog", false);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Combo combo = (Combo)focusEvent.widget;
                long l = 0L;
                String string = combo.getText();
                try {
                    if (!string.isEmpty()) {
                        l = Units.parseLocalizedTime(string);
                        string = Units.formatTime(l);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (!((Boolean)combo.getData("showedErrorDialog")).booleanValue()) {
                        combo.setData("showedErrorDialog", true);
                        Dialogs.error(shell, BARControl.tr("''{0}'' is not valid time!\n\nEnter a time in the format ''n<{1}|{2}|{3}|{4}|{5}>''", string, BARControl.tr("weeks", new Object[0]), BARControl.tr("days", new Object[0]), BARControl.tr("h", new Object[0]), BARControl.tr("mins", new Object[0]), BARControl.tr("s", new Object[0])));
                    }
                    combo.forceFocus();
                    return;
                }
                if (listener != null) {
                    listener.setString(widgetVariable, string);
                } else {
                    widgetVariable.set(string);
                }
                combo.setText(Units.formatLocalizedTime(l));
                combo.setBackground(null);
            }
        });
        final WidgetModifyListener widgetModifyListener = listener != null ? new WidgetModifyListener((Widget)combo, new WidgetVariable[]{widgetVariable}){

            @Override
            public void modified(Combo combo, WidgetVariable widgetVariable2) {
                long l = 0L;
                try {
                    l = Units.parseLocalizedTime(listener.getString(widgetVariable));
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        l = Units.parseTime(listener.getString(widgetVariable));
                    }
                    catch (NumberFormatException numberFormatException2) {
                        // empty catch block
                    }
                }
                combo.setText(Units.formatLocalizedTime(l));
            }
        } : new WidgetModifyListener((Widget)combo, new WidgetVariable[]{widgetVariable}){

            @Override
            public String getString(WidgetVariable widgetVariable) {
                long l = 0L;
                try {
                    l = Units.parseLocalizedTime(widgetVariable.getString());
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        l = Units.parseTime(widgetVariable.getString());
                    }
                    catch (NumberFormatException numberFormatException2) {
                        // empty catch block
                    }
                }
                return Units.formatLocalizedTime(l);
            }
        };
        Widgets.addModifyListener(widgetModifyListener);
        combo.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent disposeEvent) {
                Widgets.removeModifyListener(widgetModifyListener);
            }
        });
        long l = 0L;
        if (listener != null) {
            try {
                l = Units.parseLocalizedTime(listener.getString(widgetVariable));
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    l = Units.parseTime(listener.getString(widgetVariable));
                }
                catch (NumberFormatException numberFormatException2) {}
            }
        } else {
            try {
                l = Units.parseLocalizedTime(widgetVariable.getString());
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    l = Units.parseTime(widgetVariable.getString());
                }
                catch (NumberFormatException numberFormatException3) {
                    // empty catch block
                }
            }
        }
        combo.setText(Units.formatLocalizedTime(l));
        return combo;
    }

    public static Combo newTime(Composite composite, String string, WidgetVariable widgetVariable, String[] stringArray) {
        return BARWidgets.newTime(composite, string, widgetVariable, stringArray, null);
    }

    public static Composite newDirectory(Composite composite, String string, final WidgetVariable widgetVariable, final Listener listener) {
        final Shell shell = composite.getShell();
        Composite composite2 = Widgets.newComposite(composite, 0);
        composite2.setLayout(new TableLayout(0.0, new double[]{1.0, 0.0}));
        Widgets.layout(composite2, 0, 0, 12);
        final Text text = Widgets.newText(composite2, 18432);
        text.setToolTipText(string);
        text.setText(widgetVariable.getString());
        Widgets.layout(text, 0, 0, 12);
        text.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                Text text = (Text)modifyEvent.widget;
                String string = text.getText();
                Color color = COLOR_MODIFIED;
                if ((listener != null ? listener.getString(widgetVariable) : widgetVariable.getString()).equals(string)) {
                    color = null;
                }
                text.setBackground(color);
            }
        });
        text.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                Text text = (Text)selectionEvent.widget;
                String string = text.getText();
                widgetVariable.set(string);
                text.setBackground(null);
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
            }
        });
        text.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Text text = (Text)focusEvent.widget;
                String string = text.getText();
                widgetVariable.set(string);
                text.setBackground(null);
            }
        });
        final WidgetModifyListener widgetModifyListener = new WidgetModifyListener((Widget)text, widgetVariable);
        Widgets.addModifyListener(widgetModifyListener);
        text.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent disposeEvent) {
                Widgets.removeModifyListener(widgetModifyListener);
            }
        });
        Button button = Widgets.newButton(composite2, IMAGE_DIRECTORY);
        button.setToolTipText(BARControl.tr("Select path name. Ctrl+Click to select local directory.", new Object[0]));
        Widgets.layout(button, 0, 1, 0);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = (selectionEvent.stateMask & 0x40000) == 0 ? Dialogs.file(shell, Dialogs.FileDialogTypes.DIRECTORY, BARControl.tr("Select path", new Object[0]), text.getText(), BARServer.remoteListDirectory) : Dialogs.directory(shell, BARControl.tr("Select path", new Object[0]), text.getText());
                if (string != null) {
                    text.setText(string);
                }
            }
        });
        return composite2;
    }

    public static Composite newDirectory(Composite composite, String string, WidgetVariable widgetVariable) {
        return BARWidgets.newDirectory(composite, string, widgetVariable, null);
    }

    public static Composite newFile(Composite composite, String string, final WidgetVariable widgetVariable, final Listener listener, final String[] stringArray, final String string2) {
        final Shell shell = composite.getShell();
        Composite composite2 = Widgets.newComposite(composite, 0);
        composite2.setLayout(new TableLayout(0.0, new double[]{1.0, 0.0}));
        Widgets.layout(composite2, 0, 0, 12);
        final Text text = Widgets.newText(composite2, 18432);
        text.setToolTipText(string);
        text.setText(listener != null ? listener.getString(widgetVariable) : widgetVariable.getString());
        Widgets.layout(text, 0, 0, 12);
        text.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                Text text = (Text)modifyEvent.widget;
                String string = text.getText();
                Color color = COLOR_MODIFIED;
                if ((listener != null ? listener.getString(widgetVariable) : widgetVariable.getString()).equals(string)) {
                    color = null;
                }
                text.setBackground(color);
            }
        });
        text.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                Text text = (Text)selectionEvent.widget;
                String string = text.getText();
                if (listener != null) {
                    listener.setString(widgetVariable, string);
                } else {
                    widgetVariable.set(string);
                }
                text.setBackground(null);
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
            }
        });
        text.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Text text = (Text)focusEvent.widget;
                String string = text.getText();
                if (listener != null) {
                    listener.setString(widgetVariable, string);
                } else {
                    widgetVariable.set(string);
                }
                text.setBackground(null);
            }
        });
        final WidgetModifyListener widgetModifyListener = listener != null ? new WidgetModifyListener((Widget)text, new WidgetVariable[]{widgetVariable}){

            @Override
            public void modified(Text text, WidgetVariable widgetVariable2) {
                text.setText(listener.getString(widgetVariable));
            }
        } : new WidgetModifyListener((Widget)text, widgetVariable);
        Widgets.addModifyListener(widgetModifyListener);
        text.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent disposeEvent) {
                Widgets.removeModifyListener(widgetModifyListener);
            }
        });
        Button button = Widgets.newButton(composite2, IMAGE_DIRECTORY);
        button.setToolTipText(BARControl.tr("Select file name. Ctrl+Click to select local file.", new Object[0]));
        Widgets.layout(button, 0, 1, 0);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = (selectionEvent.stateMask & 0x40000) == 0 ? Dialogs.file(shell, Dialogs.FileDialogTypes.OPEN, BARControl.tr("Select file", new Object[0]), text.getText(), stringArray, string2, 0, BARServer.remoteListDirectory) : Dialogs.fileOpen(shell, BARControl.tr("Select file", new Object[0]), text.getText(), stringArray, string2);
                if (string != null) {
                    text.setText(string);
                }
            }
        });
        return composite2;
    }

    public static Composite newFile(Composite composite, String string, WidgetVariable widgetVariable, String[] stringArray, String string2) {
        return BARWidgets.newFile(composite, string, widgetVariable, null, stringArray, string2);
    }

    public static Text newPassword(Composite composite, String string, final WidgetVariable widgetVariable, final Listener listener) {
        Text text = Widgets.newText(composite, 0x404800);
        text.setToolTipText(string);
        text.setText(listener != null ? listener.getString(widgetVariable) : widgetVariable.getString());
        text.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                String string;
                Text text = (Text)modifyEvent.widget;
                Color color = COLOR_MODIFIED;
                if ((listener != null ? listener.getString(widgetVariable) : widgetVariable.getString()).equals(string = text.getText())) {
                    color = null;
                }
                text.setBackground(color);
            }
        });
        text.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                Text text = (Text)selectionEvent.widget;
                String string = text.getText();
                if (listener != null) {
                    listener.setString(widgetVariable, string);
                } else {
                    widgetVariable.set(string);
                }
                text.setBackground(null);
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
            }
        });
        text.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Text text = (Text)focusEvent.widget;
                String string = text.getText();
                if (listener != null) {
                    listener.setString(widgetVariable, string);
                } else {
                    widgetVariable.set(string);
                }
                text.setBackground(null);
            }
        });
        final WidgetModifyListener widgetModifyListener = listener != null ? new WidgetModifyListener((Widget)text, new WidgetVariable[]{widgetVariable}){

            @Override
            public void modified(Text text, WidgetVariable widgetVariable2) {
                text.setText(listener.getString(widgetVariable));
            }
        } : new WidgetModifyListener((Widget)text, widgetVariable);
        Widgets.addModifyListener(widgetModifyListener);
        text.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent disposeEvent) {
                Widgets.removeModifyListener(widgetModifyListener);
            }
        });
        if (listener != null) {
            text.setText(listener.getString(widgetVariable));
        } else {
            text.setText(widgetVariable.getString());
        }
        return text;
    }

    public static Text newPassword(Composite composite, String string, WidgetVariable widgetVariable) {
        return BARWidgets.newPassword(composite, string, widgetVariable, null);
    }

    static class Device
    extends Composite {
        Text deviceName;
        Combo volumeSize;

        public Device(final Composite composite, EnumSet<WidgetTypes> enumSet, final WidgetVariable widgetVariable, WidgetVariable widgetVariable2) {
            super(composite, 0);
            this.setLayout(new TableLayout(0.0, new double[]{0.0, 1.0}));
            int n = 0;
            Label label = Widgets.newLabel((Composite)this, BARControl.tr("Device", new Object[0]) + ":");
            Widgets.layout(label, n, 0, 4);
            Composite composite2 = Widgets.newComposite((Composite)this, 0);
            composite2.setLayout(new TableLayout(1.0, new double[]{1.0, 0.0}));
            Widgets.layout(composite2, n, 1, 12);
            this.deviceName = Widgets.newText(composite2);
            this.deviceName.setToolTipText(BARControl.tr("Device name. Leave it empty to use system default device name.", new Object[0]));
            Widgets.layout(this.deviceName, 0, 0, 12);
            this.deviceName.addModifyListener(new ModifyListener(){

                @Override
                public void modifyText(ModifyEvent modifyEvent) {
                    Text text = (Text)modifyEvent.widget;
                    String string = text.getText();
                    if (widgetVariable != null) {
                        Color color = COLOR_MODIFIED;
                        if (widgetVariable.getString().equals(string)) {
                            color = null;
                        }
                        text.setBackground(color);
                        text.setData("showedErrorDialog", false);
                    }
                }
            });
            this.deviceName.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    Text text = (Text)selectionEvent.widget;
                    if (widgetVariable != null) {
                        widgetVariable.set(text.getText());
                        text.setBackground(null);
                    }
                }

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                }
            });
            this.deviceName.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    Text text = (Text)focusEvent.widget;
                    text.setData("showedErrorDialog", false);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    Text text = (Text)focusEvent.widget;
                    if (widgetVariable != null) {
                        widgetVariable.set(text.getText());
                        text.setBackground(null);
                    }
                }
            });
            if (widgetVariable != null) {
                Widgets.addModifyListener(new WidgetModifyListener((Widget)this.deviceName, widgetVariable));
            }
            Button button = Widgets.newButton(composite2, IMAGE_DIRECTORY);
            button.setToolTipText(BARControl.tr("Select remote device. CTRL+click to select local device.", new Object[0]));
            Widgets.layout(button, 0, 1, 0);
            button.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    String string = Dialogs.file(composite.getShell(), Dialogs.FileDialogTypes.OPEN, BARControl.tr("Select device name", new Object[0]), Device.this.deviceName.getText(), new String[]{BARControl.tr("All files", new Object[0]), BARControl.ALL_FILE_EXTENSION}, "*", 0, (selectionEvent.stateMask & 0x40000) == 0 ? BARServer.remoteListDirectory : BARControl.listDirectory);
                    if (string != null) {
                        Device.this.deviceName.setText(string);
                        if (widgetVariable != null) {
                            widgetVariable.set(string);
                        }
                    }
                }
            });
            ++n;
            if (enumSet.contains((Object)WidgetTypes.VOLUME_SIZE)) {
                label = Widgets.newLabel((Composite)this, BARControl.tr("Size", new Object[0]) + ":");
                Widgets.layout(label, n, 0, 4);
                composite2 = Widgets.newComposite((Composite)this, 0);
                Widgets.layout(composite2, n, 1, 12);
                this.volumeSize = Widgets.newCombo(composite2);
                this.volumeSize = BARWidgets.newByteSize(composite2, BARControl.tr("Size of medium. You may specify a smaller value than the real physical size to leave some free space for error-correction codes.", new Object[0]), widgetVariable2, new Object[]{Units.formatSize(425L * Units.M), 425L * Units.M, Units.formatSize(430L * Units.M), 430L * Units.M, Units.formatSize(470L * Units.M), 470L * Units.M, Units.formatSize(520L * Units.M), 520L * Units.M, Units.formatSize(560L * Units.M), 560L * Units.M, Units.formatSize(650L * Units.M), 650L * Units.M, Units.formatSize(660L * Units.M), 660L * Units.M, Units.formatSize(720L * Units.M), 720L * Units.M, Units.formatSize(850L * Units.M), 850L * Units.M, Units.formatSize(2L * Units.G), 2L * Units.G, Units.formatSize((long)(3.2 * (double)Units.G)), (long)(3.2 * (double)Units.G), Units.formatSize(4L * Units.G), 4L * Units.G, Units.formatSize((long)(6.4 * (double)Units.G)), (long)(6.4 * (double)Units.G), Units.formatSize((long)(7.2 * (double)Units.G)), (long)(7.2 * (double)Units.G), Units.formatSize(8L * Units.G), 8L * Units.G, Units.formatSize(20L * Units.G), 20L * Units.G, Units.formatSize(25L * Units.G), 25L * Units.G, Units.formatSize(40L * Units.G), 40L * Units.G, Units.formatSize(50L * Units.G), 50L * Units.G, Units.formatSize(80L * Units.G), 80L * Units.G, Units.formatSize(100L * Units.G), 100L * Units.G, Units.formatSize(1L * Units.T), 1L * Units.T, Units.formatSize(2L * Units.T), 2L * Units.T, Units.formatSize(4L * Units.T), 4L * Units.T, Units.formatSize(5L * Units.T), 8L * Units.T, Units.formatSize(16L * Units.T), 16L * Units.T, Units.formatSize(32L * Units.T), 32L * Units.T});
                this.volumeSize.setData("showedErrorDialog", false);
                Widgets.layout(this.volumeSize, 0, 0, 4, 0, 0, 0, 0, 120, -1);
                ++n;
            }
            this.setVisible(false);
        }

        public Device(Composite composite, WidgetVariable widgetVariable, WidgetVariable widgetVariable2) {
            this(composite, EnumSet.allOf(WidgetTypes.class), widgetVariable, widgetVariable2);
        }

        public Device(Composite composite, EnumSet<WidgetTypes> enumSet) {
            this(composite, enumSet, null, null);
        }

        public Device(Composite composite) {
            this(composite, EnumSet.noneOf(WidgetTypes.class));
        }

        static enum WidgetTypes {
            VOLUME_SIZE;

        }
    }

    static class Optical
    extends Composite {
        private final double MAX_VOLUME_SIZE_ECC = 0.8;
        Text deviceName;
        Combo volumeSize;
        Button ecc;
        Button blank;
        Button waitFirstVolume;

        public Optical(final Composite composite, EnumSet<WidgetTypes> enumSet, final WidgetVariable widgetVariable, WidgetVariable widgetVariable2, final WidgetVariable widgetVariable3, final WidgetVariable widgetVariable4, final WidgetVariable widgetVariable5, final WidgetVariable widgetVariable6, final WidgetVariable widgetVariable7) {
            super(composite, 0);
            this.setLayout(new TableLayout(0.0, new double[]{0.0, 1.0}));
            final String string = BARControl.tr("When writing to a CD/DVD/BD with error-correction codes enabled\nsome free space should be available on medium for error-correction\ncodes (~20%).\n\nGood settings may be:\n- part size 140M,\tsize 560M,\tmedium 700M\n- part size 800M,\tsize 3.2G,\tmedium 4.0G\n- part size 1800M,\tsize 7.2G,\tmedium 8.0G\n- part size 4G,\t\tsize 20G,\tmedium 25.0G\n- part size 10G,\t\tsize 40G,\tmedium 50.0G\n- part size 20G,\t\tsize 80G,\tmedium 100.0G", new Object[0]);
            int n = 0;
            Label label = Widgets.newLabel((Composite)this, BARControl.tr("Device", new Object[0]) + ":");
            Widgets.layout(label, n, 0, 4);
            Composite composite2 = Widgets.newComposite((Composite)this, 0);
            composite2.setLayout(new TableLayout(1.0, new double[]{1.0, 0.0}));
            Widgets.layout(composite2, n, 1, 12);
            this.deviceName = Widgets.newText(composite2);
            this.deviceName.setToolTipText(BARControl.tr("Device name. Leave it empty to use system default device name.", new Object[0]));
            Widgets.layout(this.deviceName, 0, 0, 12);
            this.deviceName.addModifyListener(new ModifyListener(){

                @Override
                public void modifyText(ModifyEvent modifyEvent) {
                    Text text = (Text)modifyEvent.widget;
                    String string = text.getText();
                    if (widgetVariable != null) {
                        Color color = COLOR_MODIFIED;
                        if (widgetVariable.getString().equals(string)) {
                            color = null;
                        }
                        text.setBackground(color);
                        text.setData("showedErrorDialog", false);
                    }
                }
            });
            this.deviceName.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    Text text = (Text)selectionEvent.widget;
                    if (widgetVariable != null) {
                        widgetVariable.set(text.getText());
                        text.setBackground(null);
                    }
                }

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                }
            });
            this.deviceName.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    Text text = (Text)focusEvent.widget;
                    text.setData("showedErrorDialog", false);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    Text text = (Text)focusEvent.widget;
                    if (widgetVariable != null) {
                        widgetVariable.set(text.getText());
                        text.setBackground(null);
                    }
                }
            });
            if (widgetVariable != null) {
                Widgets.addModifyListener(new WidgetModifyListener((Widget)this.deviceName, widgetVariable));
            }
            Button button = Widgets.newButton(composite2, IMAGE_DIRECTORY);
            button.setToolTipText(BARControl.tr("Select remote device. CTRL+click to select local device.", new Object[0]));
            Widgets.layout(button, 0, 1, 0);
            button.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    String string = Dialogs.file(composite.getShell(), Dialogs.FileDialogTypes.OPEN, BARControl.tr("Select device name", new Object[0]), Optical.this.deviceName.getText(), new String[]{BARControl.tr("All files", new Object[0]), BARControl.ALL_FILE_EXTENSION}, "*", 0, (selectionEvent.stateMask & 0x40000) == 0 ? BARServer.remoteListDirectory : BARControl.listDirectory);
                    if (string != null) {
                        Optical.this.deviceName.setText(string);
                        if (widgetVariable != null) {
                            widgetVariable.set(string);
                        }
                    }
                }
            });
            ++n;
            if (enumSet.contains((Object)WidgetTypes.VOLUME_SIZE)) {
                label = Widgets.newLabel((Composite)this, BARControl.tr("Size", new Object[0]) + ":");
                Widgets.layout(label, n, 0, 4);
                composite2 = Widgets.newComposite((Composite)this, 0);
                Widgets.layout(composite2, n, 1, 12);
                this.volumeSize = BARWidgets.newByteSize(composite2, BARControl.tr("Size of medium. You may specify a smaller value than the real physical size to leave some free space for error-correction codes.", new Object[0]), widgetVariable2, new Object[]{Units.formatSize(425L * Units.M), 425L * Units.M, Units.formatSize(430L * Units.M), 430L * Units.M, Units.formatSize(470L * Units.M), 470L * Units.M, Units.formatSize(520L * Units.M), 520L * Units.M, Units.formatSize(560L * Units.M), 560L * Units.M, Units.formatSize(650L * Units.M), 650L * Units.M, Units.formatSize(660L * Units.M), 660L * Units.M, Units.formatSize(720L * Units.M), 720L * Units.M, Units.formatSize(850L * Units.M), 850L * Units.M, Units.formatSize(2L * Units.G), 2L * Units.G, Units.formatSize((long)(3.2 * (double)Units.G)), (long)(3.2 * (double)Units.G), Units.formatSize(4L * Units.G), 4L * Units.G, Units.formatSize((long)(6.4 * (double)Units.G)), (long)(6.4 * (double)Units.G), Units.formatSize((long)(7.2 * (double)Units.G)), (long)(7.2 * (double)Units.G), Units.formatSize(8L * Units.G), 8L * Units.G, Units.formatSize(20L * Units.G), 20L * Units.G, Units.formatSize(25L * Units.G), 25L * Units.G, Units.formatSize(40L * Units.G), 40L * Units.G, Units.formatSize(50L * Units.G), 50L * Units.G, Units.formatSize(80L * Units.G), 80L * Units.G, Units.formatSize(100L * Units.G), 100L * Units.G});
                this.volumeSize.setData("showedErrorDialog", false);
                Widgets.layout(this.volumeSize, 0, 0, 4, 0, 0, 0, 0, 120, -1);
                ++n;
            }
            if (enumSet.contains((Object)WidgetTypes.ECC) || enumSet.contains((Object)WidgetTypes.BLANK) || enumSet.contains((Object)WidgetTypes.WAIT_FIRST_VOLUME)) {
                label = Widgets.newLabel((Composite)this, BARControl.tr("Options", new Object[0]) + ":");
                Widgets.layout(label, n, 0, 5);
                composite2 = Widgets.newComposite((Composite)this, 0);
                Widgets.layout(composite2, n, 1, 12);
                if (enumSet.contains((Object)WidgetTypes.ECC)) {
                    this.ecc = Widgets.newCheckbox(composite2, BARControl.tr("add error-correction codes", new Object[0]));
                    this.ecc.setToolTipText(BARControl.tr("Add error-correction codes to CD/DVD/BD image (require dvdisaster tool).", new Object[0]));
                    Widgets.layout(this.ecc, 0, 0, 4);
                    this.ecc.addSelectionListener(new SelectionListener(){

                        @Override
                        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                        }

                        @Override
                        public void widgetSelected(SelectionEvent selectionEvent) {
                            Button button = (Button)selectionEvent.widget;
                            boolean bl = button.getSelection();
                            if (widgetVariable3 != null) {
                                widgetVariable3.set(bl);
                            }
                            try {
                                long l = Units.parseByteSize(Optical.this.volumeSize.getText());
                                long l2 = (long)((double)l * 0.8);
                                if (bl && widgetVariable6.getBoolean() && widgetVariable7.getLong() > 0L && l2 % widgetVariable7.getLong() > 0L && (double)(l2 % widgetVariable7.getLong()) < (double)widgetVariable7.getLong() * 0.5) {
                                    Dialogs.warning(composite.getShell(), string);
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                    if (widgetVariable3 != null) {
                        Widgets.addModifyListener(new WidgetModifyListener((Widget)this.ecc, widgetVariable3));
                    }
                }
                if (enumSet.contains((Object)WidgetTypes.BLANK)) {
                    this.blank = Widgets.newCheckbox(composite2, BARControl.tr("blank medium", new Object[0]));
                    this.blank.setToolTipText(BARControl.tr("Blank medium before writing.", new Object[0]));
                    Widgets.layout(this.blank, 0, 1, 4);
                    this.blank.addSelectionListener(new SelectionListener(){

                        @Override
                        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                        }

                        @Override
                        public void widgetSelected(SelectionEvent selectionEvent) {
                            Button button = (Button)selectionEvent.widget;
                            boolean bl = button.getSelection();
                            if (widgetVariable4 != null) {
                                widgetVariable4.set(bl);
                            }
                        }
                    });
                    if (widgetVariable4 != null) {
                        Widgets.addModifyListener(new WidgetModifyListener((Widget)this.blank, widgetVariable4));
                    }
                }
                if (enumSet.contains((Object)WidgetTypes.WAIT_FIRST_VOLUME)) {
                    this.waitFirstVolume = Widgets.newCheckbox(composite2, BARControl.tr("wait for first volume", new Object[0]));
                    this.waitFirstVolume.setToolTipText(BARControl.tr("Wait until first volume is loaded.", new Object[0]));
                    Widgets.layout(this.waitFirstVolume, 1, 0, 4);
                    this.waitFirstVolume.addSelectionListener(new SelectionListener(){

                        @Override
                        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                        }

                        @Override
                        public void widgetSelected(SelectionEvent selectionEvent) {
                            Button button = (Button)selectionEvent.widget;
                            boolean bl = button.getSelection();
                            if (widgetVariable5 != null) {
                                widgetVariable5.set(bl);
                            }
                        }
                    });
                    if (widgetVariable5 != null) {
                        Widgets.addModifyListener(new WidgetModifyListener((Widget)this.waitFirstVolume, widgetVariable5));
                    }
                }
                ++n;
            }
            this.setVisible(false);
        }

        public Optical(Composite composite, WidgetVariable widgetVariable, WidgetVariable widgetVariable2, WidgetVariable widgetVariable3, WidgetVariable widgetVariable4, WidgetVariable widgetVariable5, WidgetVariable widgetVariable6, WidgetVariable widgetVariable7) {
            this(composite, EnumSet.allOf(WidgetTypes.class), widgetVariable, widgetVariable2, widgetVariable3, widgetVariable4, widgetVariable5, widgetVariable6, widgetVariable7);
        }

        public Optical(Composite composite, EnumSet<WidgetTypes> enumSet) {
            this(composite, enumSet, null, null, null, null, null, null, null);
        }

        public Optical(Composite composite) {
            this(composite, EnumSet.noneOf(WidgetTypes.class));
        }

        static enum WidgetTypes {
            VOLUME_SIZE,
            ECC,
            BLANK,
            WAIT_FIRST_VOLUME,
            ARCHIVE_PART_SIZE;

        }
    }

    static class WebDAV
    extends Composite {
        Text hostName;
        Spinner hostPort;
        Text loginName;
        Text loginPassword;
        Text publicKey;
        Text privateKey;
        Combo archiveFileMode;

        public WebDAV(final Composite composite, EnumSet<WidgetTypes> enumSet, final WidgetVariable widgetVariable, final WidgetVariable widgetVariable2, final WidgetVariable widgetVariable3, final WidgetVariable widgetVariable4, final WidgetVariable widgetVariable5, final WidgetVariable widgetVariable6, final WidgetVariable widgetVariable7) {
            super(composite, 0);
            Button button;
            this.setLayout(new TableLayout(0.0, new double[]{0.0, 1.0}));
            int n = 0;
            Label label = Widgets.newLabel((Composite)this, BARControl.tr("Server", new Object[0]) + ":");
            Widgets.layout(label, n, 0, 4);
            Composite composite2 = Widgets.newComposite((Composite)this, 0);
            composite2.setLayout(new TableLayout(1.0, new double[]{1.0}));
            Widgets.layout(composite2, n, 1, 12);
            this.hostName = Widgets.newText(composite2);
            this.hostName.setToolTipText(BARControl.tr("WebDAV server name.", new Object[0]));
            Widgets.layout(this.hostName, 0, 0, 12);
            this.hostName.addModifyListener(new ModifyListener(){

                @Override
                public void modifyText(ModifyEvent modifyEvent) {
                    Text text = (Text)modifyEvent.widget;
                    String string = text.getText();
                    if (widgetVariable != null) {
                        Color color = COLOR_MODIFIED;
                        if (widgetVariable.getString().equals(string)) {
                            color = null;
                        }
                        text.setBackground(color);
                        text.setData("showedErrorDialog", false);
                    }
                }
            });
            this.hostName.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    Text text = (Text)selectionEvent.widget;
                    String string = text.getText();
                    if (widgetVariable != null) {
                        widgetVariable.set(string);
                        text.setBackground(null);
                    }
                }

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                }
            });
            this.hostName.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    Text text = (Text)focusEvent.widget;
                    text.setData("showedErrorDialog", false);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    Text text = (Text)focusEvent.widget;
                    if (widgetVariable != null) {
                        widgetVariable.set(text.getText());
                        text.setBackground(null);
                    }
                }
            });
            if (widgetVariable != null) {
                Widgets.addModifyListener(new WidgetModifyListener((Widget)this.hostName, widgetVariable));
            }
            label = Widgets.newLabel(composite2, BARControl.tr("Port", new Object[0]) + ":");
            Widgets.layout(label, 0, 1, 4);
            this.hostPort = Widgets.newSpinner(composite2);
            this.hostPort.setToolTipText(BARControl.tr("WebDAV port number. Set to 0 to use default port number from configuration file.", new Object[0]));
            this.hostPort.setMinimum(0);
            this.hostPort.setMaximum(65535);
            this.hostPort.setData("showedErrorDialog", false);
            Widgets.layout(this.hostPort, 0, 2, 4, 0, 0, 0, 0, 80, -1);
            this.hostPort.addModifyListener(new ModifyListener(){

                @Override
                public void modifyText(ModifyEvent modifyEvent) {
                    Spinner spinner = (Spinner)modifyEvent.widget;
                    int n = spinner.getSelection();
                    if (widgetVariable2 != null) {
                        Color color = COLOR_MODIFIED;
                        if (widgetVariable2.getInteger() == n) {
                            color = null;
                        }
                        spinner.setBackground(color);
                        spinner.setData("showedErrorDialog", false);
                    }
                }
            });
            this.hostPort.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    Spinner spinner = (Spinner)selectionEvent.widget;
                    int n = spinner.getSelection();
                    if (widgetVariable2 != null) {
                        widgetVariable2.set(n);
                        spinner.setBackground(null);
                    }
                }

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    Spinner spinner = (Spinner)selectionEvent.widget;
                    int n = spinner.getSelection();
                    if (widgetVariable2 != null) {
                        widgetVariable2.set(n);
                        spinner.setBackground(null);
                    }
                }
            });
            this.hostPort.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    Spinner spinner = (Spinner)focusEvent.widget;
                    spinner.setData("showedErrorDialog", false);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    Spinner spinner = (Spinner)focusEvent.widget;
                    if (widgetVariable2 != null) {
                        widgetVariable2.set(spinner.getSelection());
                        spinner.setBackground(null);
                    }
                }
            });
            if (widgetVariable2 != null) {
                Widgets.addModifyListener(new WidgetModifyListener((Widget)this.hostPort, widgetVariable2));
            }
            label = Widgets.newLabel((Composite)this, BARControl.tr("Login", new Object[0]) + ":");
            Widgets.layout(label, ++n, 0, 4);
            composite2 = Widgets.newComposite((Composite)this, 0);
            composite2.setLayout(new TableLayout(0.0, new double[]{1.0, 0.0, 1.0}));
            Widgets.layout(composite2, n, 1, 12);
            this.loginName = Widgets.newText(composite2);
            this.loginName.setToolTipText(BARControl.tr("WebDAV server user login name. Leave it empty to use the default name from the configuration file.", new Object[0]));
            Widgets.layout(this.loginName, 0, 0, 12);
            this.loginName.addModifyListener(new ModifyListener(){

                @Override
                public void modifyText(ModifyEvent modifyEvent) {
                    Text text = (Text)modifyEvent.widget;
                    String string = text.getText();
                    if (widgetVariable3 != null) {
                        Color color = COLOR_MODIFIED;
                        if (widgetVariable3.getString().equals(string)) {
                            color = null;
                        }
                        text.setBackground(color);
                        text.setData("showedErrorDialog", false);
                    }
                }
            });
            this.loginName.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    Text text = (Text)selectionEvent.widget;
                    if (widgetVariable3 != null) {
                        widgetVariable3.set(text.getText());
                        text.setBackground(null);
                    }
                }

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                }
            });
            this.loginName.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    Text text = (Text)focusEvent.widget;
                    text.setData("showedErrorDialog", false);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    Text text = (Text)focusEvent.widget;
                    if (widgetVariable3 != null) {
                        widgetVariable3.set(text.getText());
                        text.setBackground(null);
                    }
                }
            });
            if (widgetVariable3 != null) {
                Widgets.addModifyListener(new WidgetModifyListener((Widget)this.loginName, widgetVariable3));
            }
            label = Widgets.newLabel(composite2, BARControl.tr("Password", new Object[0]) + ":");
            Widgets.layout(label, 0, 1, 4);
            this.loginPassword = Widgets.newPassword(composite2);
            this.loginPassword.setToolTipText(BARControl.tr("WebDAV server login password. Leave it empty to use the default password from the configuration file.", new Object[0]));
            Widgets.layout(this.loginPassword, 0, 2, 12);
            this.loginPassword.addModifyListener(new ModifyListener(){

                @Override
                public void modifyText(ModifyEvent modifyEvent) {
                    Text text = (Text)modifyEvent.widget;
                    String string = text.getText();
                    if (widgetVariable4 != null) {
                        Color color = COLOR_MODIFIED;
                        if (widgetVariable4.getString().equals(string)) {
                            color = null;
                        }
                        text.setBackground(color);
                        text.setData("showedErrorDialog", false);
                    }
                }
            });
            this.loginPassword.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    Text text = (Text)selectionEvent.widget;
                    if (widgetVariable4 != null) {
                        widgetVariable4.set(text.getText());
                        text.setBackground(null);
                    }
                }

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                }
            });
            this.loginPassword.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    Text text = (Text)focusEvent.widget;
                    text.setData("showedErrorDialog", false);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    Text text = (Text)focusEvent.widget;
                    if (widgetVariable4 != null) {
                        widgetVariable4.set(text.getText());
                        text.setBackground(null);
                    }
                }
            });
            if (widgetVariable4 != null) {
                Widgets.addModifyListener(new WidgetModifyListener((Widget)this.loginPassword, widgetVariable4));
            }
            ++n;
            if (enumSet.contains((Object)WidgetTypes.ARCHIVE_FILE_MODE)) {
                label = Widgets.newLabel((Composite)this, BARControl.tr("WebDAV public key", new Object[0]) + ":");
                Widgets.layout(label, n, 0, 4);
                composite2 = Widgets.newComposite((Composite)this, 0);
                composite2.setLayout(new TableLayout(1.0, new double[]{1.0, 0.0}));
                Widgets.layout(composite2, n, 1, 12);
                this.publicKey = Widgets.newText(composite2);
                this.publicKey.setToolTipText(BARControl.tr("WebDAV public key file name. Leave it empty to use the default key file from the configuration file.", new Object[0]));
                Widgets.layout(this.publicKey, 0, 0, 12);
                this.publicKey.addModifyListener(new ModifyListener(){

                    @Override
                    public void modifyText(ModifyEvent modifyEvent) {
                        Text text = (Text)modifyEvent.widget;
                        String string = text.getText();
                        if (widgetVariable5 != null) {
                            Color color = COLOR_MODIFIED;
                            if (widgetVariable5.getString().equals(string)) {
                                color = null;
                            }
                            text.setBackground(color);
                            text.setData("showedErrorDialog", false);
                        }
                    }
                });
                this.publicKey.addSelectionListener(new SelectionListener(){

                    @Override
                    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                        Text text = (Text)selectionEvent.widget;
                        String string = text.getText();
                        if (widgetVariable5 != null) {
                            widgetVariable5.set(text.getText());
                            text.setBackground(null);
                        }
                    }

                    @Override
                    public void widgetSelected(SelectionEvent selectionEvent) {
                    }
                });
                this.publicKey.addFocusListener(new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        Text text = (Text)focusEvent.widget;
                        text.setData("showedErrorDialog", false);
                    }

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        Text text = (Text)focusEvent.widget;
                        String string = text.getText();
                        if (widgetVariable5 != null) {
                            widgetVariable5.set(text.getText());
                            text.setBackground(null);
                        }
                    }
                });
                if (widgetVariable5 != null) {
                    Widgets.addModifyListener(new WidgetModifyListener((Widget)this.publicKey, widgetVariable5));
                }
                button = Widgets.newButton(composite2, IMAGE_DIRECTORY);
                button.setToolTipText(BARControl.tr("Select remote file. CTRL+click to select local file.", new Object[0]));
                Widgets.layout(button, 0, 1, 0);
                button.addSelectionListener(new SelectionListener(){

                    @Override
                    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    }

                    @Override
                    public void widgetSelected(SelectionEvent selectionEvent) {
                        String string = Dialogs.file(composite.getShell(), Dialogs.FileDialogTypes.OPEN, BARControl.tr("Select WebDAV public key file", new Object[0]), WebDAV.this.publicKey.getText(), new String[]{BARControl.tr("Public key files", new Object[0]), "*.pub", BARControl.tr("All files", new Object[0]), BARControl.ALL_FILE_EXTENSION}, "*", 0, (selectionEvent.stateMask & 0x40000) == 0 ? BARServer.remoteListDirectory : BARControl.listDirectory);
                        if (string != null) {
                            WebDAV.this.publicKey.setText(string);
                            if (widgetVariable5 != null) {
                                widgetVariable5.set(WebDAV.this.publicKey.getText());
                                WebDAV.this.publicKey.setBackground(null);
                            }
                        }
                    }
                });
                ++n;
            }
            if (enumSet.contains((Object)WidgetTypes.ARCHIVE_FILE_MODE)) {
                label = Widgets.newLabel((Composite)this, BARControl.tr("WebDAV private key", new Object[0]) + ":");
                Widgets.layout(label, n, 0, 4);
                composite2 = Widgets.newComposite((Composite)this, 0);
                composite2.setLayout(new TableLayout(1.0, new double[]{1.0, 0.0}));
                Widgets.layout(composite2, n, 1, 12);
                this.privateKey = Widgets.newText(composite2);
                this.privateKey.setToolTipText(BARControl.tr("WebDAV private key file name. Leave it empty to use the default key file from the configuration file.", new Object[0]));
                Widgets.layout(this.privateKey, 0, 0, 12);
                this.privateKey.addModifyListener(new ModifyListener(){

                    @Override
                    public void modifyText(ModifyEvent modifyEvent) {
                        Text text = (Text)modifyEvent.widget;
                        String string = text.getText();
                        if (widgetVariable6 != null) {
                            Color color = COLOR_MODIFIED;
                            if (widgetVariable6.getString().equals(string)) {
                                color = null;
                            }
                            text.setBackground(color);
                            text.setData("showedErrorDialog", false);
                        }
                    }
                });
                this.privateKey.addSelectionListener(new SelectionListener(){

                    @Override
                    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                        Text text = (Text)selectionEvent.widget;
                        String string = text.getText();
                        if (widgetVariable6 != null) {
                            widgetVariable6.set(text.getText());
                            text.setBackground(null);
                        }
                    }

                    @Override
                    public void widgetSelected(SelectionEvent selectionEvent) {
                    }
                });
                this.privateKey.addFocusListener(new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        Text text = (Text)focusEvent.widget;
                        text.setData("showedErrorDialog", false);
                    }

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        Text text = (Text)focusEvent.widget;
                        String string = text.getText();
                        if (widgetVariable6 != null) {
                            widgetVariable6.set(text.getText());
                            text.setBackground(null);
                        }
                    }
                });
                if (widgetVariable6 != null) {
                    Widgets.addModifyListener(new WidgetModifyListener((Widget)this.privateKey, widgetVariable6));
                }
                button = Widgets.newButton(composite2, IMAGE_DIRECTORY);
                button.setToolTipText(BARControl.tr("Select remote file. CTRL+click to select local file.", new Object[0]));
                Widgets.layout(button, 0, 1, 0);
                button.addSelectionListener(new SelectionListener(){

                    @Override
                    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    }

                    @Override
                    public void widgetSelected(SelectionEvent selectionEvent) {
                        String string = Dialogs.file(composite.getShell(), Dialogs.FileDialogTypes.OPEN, BARControl.tr("Select WebDAV private key file", new Object[0]), WebDAV.this.privateKey.getText(), new String[]{BARControl.tr("All files", new Object[0]), BARControl.ALL_FILE_EXTENSION}, "*", 0, (selectionEvent.stateMask & 0x40000) == 0 ? BARServer.remoteListDirectory : BARControl.listDirectory);
                        if (string != null) {
                            WebDAV.this.privateKey.setText(string);
                            if (widgetVariable6 != null) {
                                widgetVariable6.set(WebDAV.this.privateKey.getText());
                                WebDAV.this.privateKey.setBackground(null);
                            }
                        }
                    }
                });
                ++n;
            }
            if (enumSet.contains((Object)WidgetTypes.ARCHIVE_FILE_MODE)) {
                label = Widgets.newLabel((Composite)this, BARControl.tr("Archive file mode", new Object[0]) + ":");
                Widgets.layout(label, n, 0, 4);
                composite2 = Widgets.newComposite((Composite)this, 0);
                composite2.setLayout(new TableLayout(1.0, 0.0));
                Widgets.layout(composite2, n, 1, 12);
                this.archiveFileMode = Widgets.newOptionMenu(composite2);
                this.archiveFileMode.setToolTipText(BARControl.tr("If set to 'append' then append data to existing archive files.\nIf set to 'overwrite' then overwrite existing files.\nOtherwise stop with an error if archive file exists.", new Object[0]));
                Widgets.setComboItems(this.archiveFileMode, new Object[]{BARControl.tr("stop if exists", new Object[0]), "stop", BARControl.tr("rename", new Object[0]), "rename", BARControl.tr("append", new Object[0]), "append", BARControl.tr("overwrite", new Object[0]), "overwrite"});
                Widgets.layout(this.archiveFileMode, 0, 1, 4);
                this.archiveFileMode.addSelectionListener(new SelectionListener(){

                    @Override
                    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    }

                    @Override
                    public void widgetSelected(SelectionEvent selectionEvent) {
                        Combo combo = (Combo)selectionEvent.widget;
                        String string = Widgets.getSelectedComboItem(combo, "stop");
                        if (widgetVariable7 != null) {
                            widgetVariable7.set(string);
                        }
                    }
                });
                if (widgetVariable7 != null) {
                    Widgets.addModifyListener(new WidgetModifyListener((Widget)this.archiveFileMode, widgetVariable7));
                }
                ++n;
            }
            this.setVisible(false);
        }

        public WebDAV(Composite composite, WidgetVariable widgetVariable, WidgetVariable widgetVariable2, WidgetVariable widgetVariable3, WidgetVariable widgetVariable4, WidgetVariable widgetVariable5, WidgetVariable widgetVariable6, WidgetVariable widgetVariable7) {
            this(composite, EnumSet.allOf(WidgetTypes.class), widgetVariable, widgetVariable2, widgetVariable3, widgetVariable4, widgetVariable5, widgetVariable6, widgetVariable7);
        }

        public WebDAV(Composite composite, EnumSet<WidgetTypes> enumSet) {
            this(composite, enumSet, null, null, null, null, null, null, null);
        }

        public WebDAV(Composite composite) {
            this(composite, EnumSet.noneOf(WidgetTypes.class));
        }

        static enum WidgetTypes {
            PUBLIC_KEY,
            PRIVATE_KEY,
            ARCHIVE_FILE_MODE;

        }
    }

    static class SMB
    extends Composite {
        Text hostName;
        Text loginName;
        Text loginPassword;
        Text shareName;
        Combo archiveFileMode;

        public SMB(Composite composite, EnumSet<WidgetTypes> enumSet, final WidgetVariable widgetVariable, final WidgetVariable widgetVariable2, final WidgetVariable widgetVariable3, final WidgetVariable widgetVariable4, final WidgetVariable widgetVariable5) {
            super(composite, 0);
            this.setLayout(new TableLayout(0.0, new double[]{0.0, 1.0}));
            int n = 0;
            Label label = Widgets.newLabel((Composite)this, BARControl.tr("Server", new Object[0]) + ":");
            Widgets.layout(label, n, 0, 4);
            Composite composite2 = Widgets.newComposite((Composite)this, 0);
            composite2.setLayout(new TableLayout(1.0, new double[]{1.0, 0.0, 1.0}));
            Widgets.layout(composite2, n, 1, 12);
            this.hostName = Widgets.newText(composite2);
            this.hostName.setToolTipText(BARControl.tr("SMB/CIFS server name.", new Object[0]));
            Widgets.layout(this.hostName, 0, 0, 12);
            this.hostName.addModifyListener(new ModifyListener(){

                @Override
                public void modifyText(ModifyEvent modifyEvent) {
                    Text text = (Text)modifyEvent.widget;
                    String string = text.getText();
                    if (widgetVariable != null) {
                        Color color = COLOR_MODIFIED;
                        if (widgetVariable.getString().equals(string)) {
                            color = null;
                        }
                        text.setBackground(color);
                        text.setData("showedErrorDialog", false);
                    }
                }
            });
            this.hostName.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    Text text = (Text)selectionEvent.widget;
                    if (widgetVariable != null) {
                        widgetVariable.set(text.getText());
                        text.setBackground(null);
                    }
                }

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                }
            });
            this.hostName.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    Text text = (Text)focusEvent.widget;
                    text.setData("showedErrorDialog", false);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    Text text = (Text)focusEvent.widget;
                    if (widgetVariable != null) {
                        widgetVariable.set(text.getText());
                        text.setBackground(null);
                    }
                }
            });
            if (widgetVariable != null) {
                Widgets.addModifyListener(new WidgetModifyListener((Widget)this.hostName, widgetVariable));
            }
            label = Widgets.newLabel(composite2, BARControl.tr("Share", new Object[0]) + ":");
            Widgets.layout(label, 0, 1, 4);
            this.shareName = Widgets.newText(composite2);
            this.shareName.setToolTipText(BARControl.tr("SMB/CIFS server share name. Leave it empty to use the default share name from the configuration file.", new Object[0]));
            Widgets.layout(this.shareName, 0, 2, 12);
            this.shareName.addModifyListener(new ModifyListener(){

                @Override
                public void modifyText(ModifyEvent modifyEvent) {
                    Text text = (Text)modifyEvent.widget;
                    String string = text.getText();
                    if (widgetVariable4 != null) {
                        Color color = COLOR_MODIFIED;
                        if (widgetVariable4.getString().equals(string)) {
                            color = null;
                        }
                        text.setBackground(color);
                        text.setData("showedErrorDialog", false);
                    }
                }
            });
            this.shareName.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    Text text = (Text)selectionEvent.widget;
                    if (widgetVariable4 != null) {
                        widgetVariable4.set(text.getText());
                        text.setBackground(null);
                    }
                }

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                }
            });
            this.shareName.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    Text text = (Text)focusEvent.widget;
                    text.setData("showedErrorDialog", false);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    Text text = (Text)focusEvent.widget;
                    if (widgetVariable4 != null) {
                        widgetVariable4.set(text.getText());
                        text.setBackground(null);
                    }
                }
            });
            if (widgetVariable4 != null) {
                Widgets.addModifyListener(new WidgetModifyListener((Widget)this.shareName, widgetVariable4));
            }
            label = Widgets.newLabel((Composite)this, BARControl.tr("Login", new Object[0]) + ":");
            Widgets.layout(label, ++n, 0, 4);
            composite2 = Widgets.newComposite((Composite)this, 0);
            composite2.setLayout(new TableLayout(0.0, new double[]{1.0, 0.0, 1.0}));
            Widgets.layout(composite2, n, 1, 12);
            this.loginName = Widgets.newText(composite2);
            this.loginName.setToolTipText(BARControl.tr("SSH server user login name. Leave it empty to use the default name from the configuration file.", new Object[0]));
            Widgets.layout(this.loginName, 0, 0, 12);
            this.loginName.addModifyListener(new ModifyListener(){

                @Override
                public void modifyText(ModifyEvent modifyEvent) {
                    Text text = (Text)modifyEvent.widget;
                    String string = text.getText();
                    if (widgetVariable2 != null) {
                        Color color = COLOR_MODIFIED;
                        if (widgetVariable2.getString().equals(string)) {
                            color = null;
                        }
                        text.setBackground(color);
                        text.setData("showedErrorDialog", false);
                    }
                }
            });
            this.loginName.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    Text text = (Text)selectionEvent.widget;
                    if (widgetVariable2 != null) {
                        widgetVariable2.set(text.getText());
                        text.setBackground(null);
                    }
                }

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                }
            });
            this.loginName.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    Text text = (Text)focusEvent.widget;
                    text.setData("showedErrorDialog", false);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    Text text = (Text)focusEvent.widget;
                    if (widgetVariable2 != null) {
                        widgetVariable2.set(text.getText());
                        text.setBackground(null);
                    }
                }
            });
            if (widgetVariable2 != null) {
                Widgets.addModifyListener(new WidgetModifyListener((Widget)this.loginName, widgetVariable2));
            }
            label = Widgets.newLabel(composite2, BARControl.tr("Password", new Object[0]) + ":");
            Widgets.layout(label, 0, 1, 4);
            this.loginPassword = Widgets.newPassword(composite2);
            this.loginPassword.setToolTipText(BARControl.tr("SSH server login password. Leave it empty to use the default password from the configuration file.", new Object[0]));
            Widgets.layout(this.loginPassword, 0, 2, 12);
            this.loginPassword.addModifyListener(new ModifyListener(){

                @Override
                public void modifyText(ModifyEvent modifyEvent) {
                    Text text = (Text)modifyEvent.widget;
                    String string = text.getText();
                    if (widgetVariable3 != null) {
                        Color color = COLOR_MODIFIED;
                        if (widgetVariable3.getString().equals(string)) {
                            color = null;
                        }
                        text.setBackground(color);
                        text.setData("showedErrorDialog", false);
                    }
                }
            });
            this.loginPassword.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    Text text = (Text)selectionEvent.widget;
                    if (widgetVariable3 != null) {
                        widgetVariable3.set(text.getText());
                        text.setBackground(null);
                    }
                }

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                }
            });
            this.loginPassword.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    Text text = (Text)focusEvent.widget;
                    text.setData("showedErrorDialog", false);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    Text text = (Text)focusEvent.widget;
                    if (widgetVariable3 != null) {
                        widgetVariable3.set(text.getText());
                        text.setBackground(null);
                    }
                }
            });
            if (widgetVariable3 != null) {
                Widgets.addModifyListener(new WidgetModifyListener((Widget)this.loginPassword, widgetVariable3));
            }
            ++n;
            if (enumSet.contains((Object)WidgetTypes.ARCHIVE_FILE_MODE)) {
                label = Widgets.newLabel((Composite)this, BARControl.tr("Archive file mode", new Object[0]) + ":");
                Widgets.layout(label, n, 0, 4);
                this.archiveFileMode = Widgets.newOptionMenu(this);
                this.archiveFileMode.setToolTipText(BARControl.tr("If set to ''rename'' then the archive is renamed if it already exists.\nIf set to ''append'' then data is appended to the existing archive files.\nIf set to ''overwrite'' then existing archive files are overwritten.", new Object[0]));
                Widgets.setComboItems(this.archiveFileMode, new Object[]{BARControl.tr("stop if exists", new Object[0]), "stop", BARControl.tr("rename if exists", new Object[0]), "rename", BARControl.tr("append", new Object[0]), "append", BARControl.tr("overwrite", new Object[0]), "overwrite"});
                Widgets.layout(this.archiveFileMode, n, 1, 4);
                this.archiveFileMode.addSelectionListener(new SelectionListener(){

                    @Override
                    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    }

                    @Override
                    public void widgetSelected(SelectionEvent selectionEvent) {
                        Combo combo = (Combo)selectionEvent.widget;
                        String string = Widgets.getSelectedComboItem(combo, "stop");
                        if (widgetVariable5 != null) {
                            widgetVariable5.set(string);
                        }
                    }
                });
                if (widgetVariable5 != null) {
                    Widgets.addModifyListener(new WidgetModifyListener((Widget)this.archiveFileMode, widgetVariable5));
                }
                ++n;
            }
            this.setVisible(false);
        }

        public SMB(Composite composite, WidgetVariable widgetVariable, WidgetVariable widgetVariable2, WidgetVariable widgetVariable3, WidgetVariable widgetVariable4, WidgetVariable widgetVariable5) {
            this(composite, EnumSet.allOf(WidgetTypes.class), widgetVariable, widgetVariable2, widgetVariable3, widgetVariable4, widgetVariable5);
        }

        public SMB(Composite composite, EnumSet<WidgetTypes> enumSet) {
            this(composite, enumSet, null, null, null, null, null);
        }

        public SMB(Composite composite) {
            this(composite, EnumSet.noneOf(WidgetTypes.class));
        }

        static enum WidgetTypes {
            PUBLIC_KEY,
            PRIVATE_KEY,
            ARCHIVE_FILE_MODE;

        }
    }

    static class SFTP
    extends Composite {
        Text hostName;
        Spinner hostPort;
        Text loginName;
        Text loginPassword;
        Text publicKey;
        Text privateKey;
        Combo archiveFileMode;

        public SFTP(final Composite composite, EnumSet<WidgetTypes> enumSet, final WidgetVariable widgetVariable, final WidgetVariable widgetVariable2, final WidgetVariable widgetVariable3, final WidgetVariable widgetVariable4, final WidgetVariable widgetVariable5, final WidgetVariable widgetVariable6, final WidgetVariable widgetVariable7) {
            super(composite, 0);
            Button button;
            this.setLayout(new TableLayout(0.0, new double[]{0.0, 1.0}));
            int n = 0;
            Label label = Widgets.newLabel((Composite)this, BARControl.tr("Server", new Object[0]) + ":");
            Widgets.layout(label, n, 0, 4);
            Composite composite2 = Widgets.newComposite((Composite)this, 0);
            composite2.setLayout(new TableLayout(1.0, new double[]{1.0}));
            Widgets.layout(composite2, n, 1, 12);
            this.hostName = Widgets.newText(composite2);
            this.hostName.setToolTipText(BARControl.tr("SCP/SFTP server name.", new Object[0]));
            Widgets.layout(this.hostName, 0, 0, 12);
            this.hostName.addModifyListener(new ModifyListener(){

                @Override
                public void modifyText(ModifyEvent modifyEvent) {
                    Text text = (Text)modifyEvent.widget;
                    String string = text.getText();
                    if (widgetVariable != null) {
                        Color color = COLOR_MODIFIED;
                        if (widgetVariable.getString().equals(string)) {
                            color = null;
                        }
                        text.setBackground(color);
                        text.setData("showedErrorDialog", false);
                    }
                }
            });
            this.hostName.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    Text text = (Text)selectionEvent.widget;
                    if (widgetVariable != null) {
                        widgetVariable.set(text.getText());
                        text.setBackground(null);
                    }
                }

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                }
            });
            this.hostName.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    Text text = (Text)focusEvent.widget;
                    text.setData("showedErrorDialog", false);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    Text text = (Text)focusEvent.widget;
                    if (widgetVariable != null) {
                        widgetVariable.set(text.getText());
                        text.setBackground(null);
                    }
                }
            });
            if (widgetVariable != null) {
                Widgets.addModifyListener(new WidgetModifyListener((Widget)this.hostName, widgetVariable));
            }
            label = Widgets.newLabel(composite2, BARControl.tr("Port", new Object[0]) + ":");
            Widgets.layout(label, 0, 1, 4);
            this.hostPort = Widgets.newSpinner(composite2);
            this.hostPort.setToolTipText(BARControl.tr("SSH port number. Set to 0 to use default port number from configuration file.", new Object[0]));
            this.hostPort.setMinimum(0);
            this.hostPort.setMaximum(65535);
            this.hostPort.setData("showedErrorDialog", false);
            Widgets.layout(this.hostPort, 0, 2, 4, 0, 0, 0, 0, 80, -1);
            this.hostPort.addModifyListener(new ModifyListener(){

                @Override
                public void modifyText(ModifyEvent modifyEvent) {
                    Spinner spinner = (Spinner)modifyEvent.widget;
                    int n = spinner.getSelection();
                    if (widgetVariable2 != null) {
                        Color color = COLOR_MODIFIED;
                        if (widgetVariable2.getInteger() == n) {
                            color = null;
                        }
                        spinner.setBackground(color);
                        spinner.setData("showedErrorDialog", false);
                    }
                }
            });
            this.hostPort.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    Spinner spinner = (Spinner)selectionEvent.widget;
                    int n = spinner.getSelection();
                    if (widgetVariable2 != null) {
                        widgetVariable2.set(n);
                        spinner.setBackground(null);
                    }
                }

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    Spinner spinner = (Spinner)selectionEvent.widget;
                    int n = spinner.getSelection();
                    if (widgetVariable2 != null) {
                        widgetVariable2.set(n);
                        spinner.setBackground(null);
                    }
                }
            });
            this.hostPort.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    Spinner spinner = (Spinner)focusEvent.widget;
                    spinner.setData("showedErrorDialog", false);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    Spinner spinner = (Spinner)focusEvent.widget;
                    if (widgetVariable2 != null) {
                        widgetVariable2.set(spinner.getSelection());
                        spinner.setBackground(null);
                    }
                }
            });
            if (widgetVariable2 != null) {
                Widgets.addModifyListener(new WidgetModifyListener((Widget)this.hostPort, widgetVariable2));
            }
            label = Widgets.newLabel((Composite)this, BARControl.tr("Login", new Object[0]) + ":");
            Widgets.layout(label, ++n, 0, 4);
            composite2 = Widgets.newComposite((Composite)this, 0);
            composite2.setLayout(new TableLayout(0.0, new double[]{1.0, 0.0, 1.0}));
            Widgets.layout(composite2, n, 1, 12);
            this.loginName = Widgets.newText(composite2);
            this.loginName.setToolTipText(BARControl.tr("SSH server user login name. Leave it empty to use the default name from the configuration file.", new Object[0]));
            Widgets.layout(this.loginName, 0, 0, 12);
            this.loginName.addModifyListener(new ModifyListener(){

                @Override
                public void modifyText(ModifyEvent modifyEvent) {
                    Text text = (Text)modifyEvent.widget;
                    String string = text.getText();
                    if (widgetVariable3 != null) {
                        Color color = COLOR_MODIFIED;
                        if (widgetVariable3.getString().equals(string)) {
                            color = null;
                        }
                        text.setBackground(color);
                        text.setData("showedErrorDialog", false);
                    }
                }
            });
            this.loginName.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    Text text = (Text)selectionEvent.widget;
                    if (widgetVariable3 != null) {
                        widgetVariable3.set(text.getText());
                        text.setBackground(null);
                    }
                }

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                }
            });
            this.loginName.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    Text text = (Text)focusEvent.widget;
                    text.setData("showedErrorDialog", false);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    Text text = (Text)focusEvent.widget;
                    if (widgetVariable3 != null) {
                        widgetVariable3.set(text.getText());
                        text.setBackground(null);
                    }
                }
            });
            if (widgetVariable3 != null) {
                Widgets.addModifyListener(new WidgetModifyListener((Widget)this.loginName, widgetVariable3));
            }
            label = Widgets.newLabel(composite2, BARControl.tr("Password", new Object[0]) + ":");
            Widgets.layout(label, 0, 1, 4);
            this.loginPassword = Widgets.newPassword(composite2);
            this.loginPassword.setToolTipText(BARControl.tr("SSH server login password. Leave it empty to use the default password from the configuration file.", new Object[0]));
            Widgets.layout(this.loginPassword, 0, 2, 12);
            this.loginPassword.addModifyListener(new ModifyListener(){

                @Override
                public void modifyText(ModifyEvent modifyEvent) {
                    Text text = (Text)modifyEvent.widget;
                    String string = text.getText();
                    if (widgetVariable4 != null) {
                        Color color = COLOR_MODIFIED;
                        if (widgetVariable4.getString().equals(string)) {
                            color = null;
                        }
                        text.setBackground(color);
                        text.setData("showedErrorDialog", false);
                    }
                }
            });
            this.loginPassword.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    Text text = (Text)selectionEvent.widget;
                    if (widgetVariable4 != null) {
                        widgetVariable4.set(text.getText());
                        text.setBackground(null);
                    }
                }

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                }
            });
            this.loginPassword.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    Text text = (Text)focusEvent.widget;
                    text.setData("showedErrorDialog", false);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    Text text = (Text)focusEvent.widget;
                    if (widgetVariable4 != null) {
                        widgetVariable4.set(text.getText());
                        text.setBackground(null);
                    }
                }
            });
            if (widgetVariable4 != null) {
                Widgets.addModifyListener(new WidgetModifyListener((Widget)this.loginPassword, widgetVariable4));
            }
            ++n;
            if (enumSet.contains((Object)WidgetTypes.ARCHIVE_FILE_MODE)) {
                label = Widgets.newLabel((Composite)this, BARControl.tr("SSH public key", new Object[0]) + ":");
                Widgets.layout(label, n, 0, 4);
                composite2 = Widgets.newComposite((Composite)this, 0);
                composite2.setLayout(new TableLayout(1.0, new double[]{1.0, 0.0}));
                Widgets.layout(composite2, n, 1, 12);
                this.publicKey = Widgets.newText(composite2);
                this.publicKey.setToolTipText(BARControl.tr("SSH public key file name. Leave it empty to use the default key file from the configuration file.", new Object[0]));
                Widgets.layout(this.publicKey, 0, 0, 12);
                this.publicKey.addModifyListener(new ModifyListener(){

                    @Override
                    public void modifyText(ModifyEvent modifyEvent) {
                        Text text = (Text)modifyEvent.widget;
                        String string = text.getText();
                        if (widgetVariable5 != null) {
                            Color color = COLOR_MODIFIED;
                            if (widgetVariable5.getString().equals(string)) {
                                color = null;
                            }
                            text.setBackground(color);
                            text.setData("showedErrorDialog", false);
                        }
                    }
                });
                this.publicKey.addSelectionListener(new SelectionListener(){

                    @Override
                    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                        Text text = (Text)selectionEvent.widget;
                        String string = text.getText();
                        if (widgetVariable5 != null) {
                            widgetVariable5.set(text.getText());
                            text.setBackground(null);
                        }
                    }

                    @Override
                    public void widgetSelected(SelectionEvent selectionEvent) {
                    }
                });
                this.publicKey.addFocusListener(new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        Text text = (Text)focusEvent.widget;
                        text.setData("showedErrorDialog", false);
                    }

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        Text text = (Text)focusEvent.widget;
                        String string = text.getText();
                        if (widgetVariable5 != null) {
                            widgetVariable5.set(text.getText());
                            text.setBackground(null);
                        }
                    }
                });
                if (widgetVariable5 != null) {
                    Widgets.addModifyListener(new WidgetModifyListener((Widget)this.publicKey, widgetVariable5));
                }
                button = Widgets.newButton(composite2, IMAGE_DIRECTORY);
                button.setToolTipText(BARControl.tr("Select remote file. CTRL+click to select local file.", new Object[0]));
                Widgets.layout(button, 0, 1, 0);
                button.addSelectionListener(new SelectionListener(){

                    @Override
                    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    }

                    @Override
                    public void widgetSelected(SelectionEvent selectionEvent) {
                        String string = Dialogs.file(composite.getShell(), Dialogs.FileDialogTypes.OPEN, BARControl.tr("Select SSH public key file", new Object[0]), SFTP.this.publicKey.getText(), new String[]{BARControl.tr("Public key files", new Object[0]), "*.pub", BARControl.tr("All files", new Object[0]), BARControl.ALL_FILE_EXTENSION}, "*", 0, (selectionEvent.stateMask & 0x40000) == 0 ? BARServer.remoteListDirectory : BARControl.listDirectory);
                        if (string != null) {
                            SFTP.this.publicKey.setText(string);
                            if (widgetVariable5 != null) {
                                widgetVariable5.set(SFTP.this.publicKey.getText());
                                SFTP.this.publicKey.setBackground(null);
                            }
                        }
                    }
                });
                ++n;
            }
            if (enumSet.contains((Object)WidgetTypes.ARCHIVE_FILE_MODE)) {
                label = Widgets.newLabel((Composite)this, BARControl.tr("SSH private key", new Object[0]) + ":");
                Widgets.layout(label, n, 0, 4);
                composite2 = Widgets.newComposite((Composite)this, 0);
                composite2.setLayout(new TableLayout(1.0, new double[]{1.0, 0.0}));
                Widgets.layout(composite2, n, 1, 12);
                this.privateKey = Widgets.newText(composite2);
                this.privateKey.setToolTipText(BARControl.tr("SSH private key file name. Leave it empty to use the default key file from the configuration file.", new Object[0]));
                Widgets.layout(this.privateKey, 0, 0, 12);
                this.privateKey.addModifyListener(new ModifyListener(){

                    @Override
                    public void modifyText(ModifyEvent modifyEvent) {
                        Text text = (Text)modifyEvent.widget;
                        String string = text.getText();
                        if (widgetVariable6 != null) {
                            Color color = COLOR_MODIFIED;
                            if (widgetVariable6.getString().equals(string)) {
                                color = null;
                            }
                            text.setBackground(color);
                            text.setData("showedErrorDialog", false);
                        }
                    }
                });
                this.privateKey.addSelectionListener(new SelectionListener(){

                    @Override
                    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                        Text text = (Text)selectionEvent.widget;
                        String string = text.getText();
                        if (widgetVariable6 != null) {
                            widgetVariable6.set(text.getText());
                            text.setBackground(null);
                        }
                    }

                    @Override
                    public void widgetSelected(SelectionEvent selectionEvent) {
                    }
                });
                this.privateKey.addFocusListener(new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        Text text = (Text)focusEvent.widget;
                        text.setData("showedErrorDialog", false);
                    }

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        Text text = (Text)focusEvent.widget;
                        String string = text.getText();
                        if (widgetVariable6 != null) {
                            widgetVariable6.set(text.getText());
                            text.setBackground(null);
                        }
                    }
                });
                if (widgetVariable6 != null) {
                    Widgets.addModifyListener(new WidgetModifyListener((Widget)this.privateKey, widgetVariable6));
                }
                button = Widgets.newButton(composite2, IMAGE_DIRECTORY);
                button.setToolTipText(BARControl.tr("Select remote file. CTRL+click to select local file.", new Object[0]));
                Widgets.layout(button, 0, 1, 0);
                button.addSelectionListener(new SelectionListener(){

                    @Override
                    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    }

                    @Override
                    public void widgetSelected(SelectionEvent selectionEvent) {
                        String string = Dialogs.file(composite.getShell(), Dialogs.FileDialogTypes.OPEN, BARControl.tr("Select SSH private key file", new Object[0]), SFTP.this.privateKey.getText(), new String[]{BARControl.tr("All files", new Object[0]), BARControl.ALL_FILE_EXTENSION}, "*", 0, (selectionEvent.stateMask & 0x40000) == 0 ? BARServer.remoteListDirectory : BARControl.listDirectory);
                        if (string != null) {
                            SFTP.this.privateKey.setText(string);
                            if (widgetVariable6 != null) {
                                widgetVariable6.set(SFTP.this.privateKey.getText());
                                SFTP.this.privateKey.setBackground(null);
                            }
                        }
                    }
                });
                ++n;
            }
            if (enumSet.contains((Object)WidgetTypes.ARCHIVE_FILE_MODE)) {
                label = Widgets.newLabel((Composite)this, BARControl.tr("Archive file mode", new Object[0]) + ":");
                Widgets.layout(label, n, 0, 4);
                this.archiveFileMode = Widgets.newOptionMenu(this);
                this.archiveFileMode.setToolTipText(BARControl.tr("If set to ''rename'' then the archive is renamed if it already exists.\nIf set to ''append'' then data is appended to the existing archive files.\nIf set to ''overwrite'' then existing archive files are overwritten.", new Object[0]));
                Widgets.setComboItems(this.archiveFileMode, new Object[]{BARControl.tr("stop if exists", new Object[0]), "stop", BARControl.tr("rename if exists", new Object[0]), "rename", BARControl.tr("append", new Object[0]), "append", BARControl.tr("overwrite", new Object[0]), "overwrite"});
                Widgets.layout(this.archiveFileMode, n, 1, 4);
                this.archiveFileMode.addSelectionListener(new SelectionListener(){

                    @Override
                    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    }

                    @Override
                    public void widgetSelected(SelectionEvent selectionEvent) {
                        Combo combo = (Combo)selectionEvent.widget;
                        String string = Widgets.getSelectedComboItem(combo, "stop");
                        if (widgetVariable7 != null) {
                            widgetVariable7.set(string);
                        }
                    }
                });
                if (widgetVariable7 != null) {
                    Widgets.addModifyListener(new WidgetModifyListener((Widget)this.archiveFileMode, widgetVariable7));
                }
                ++n;
            }
            this.setVisible(false);
        }

        public SFTP(Composite composite, WidgetVariable widgetVariable, WidgetVariable widgetVariable2, WidgetVariable widgetVariable3, WidgetVariable widgetVariable4, WidgetVariable widgetVariable5, WidgetVariable widgetVariable6, WidgetVariable widgetVariable7) {
            this(composite, EnumSet.allOf(WidgetTypes.class), widgetVariable, widgetVariable2, widgetVariable3, widgetVariable4, widgetVariable5, widgetVariable6, widgetVariable7);
        }

        public SFTP(Composite composite, EnumSet<WidgetTypes> enumSet) {
            this(composite, enumSet, null, null, null, null, null, null, null);
        }

        public SFTP(Composite composite) {
            this(composite, EnumSet.noneOf(WidgetTypes.class));
        }

        static enum WidgetTypes {
            PUBLIC_KEY,
            PRIVATE_KEY,
            ARCHIVE_FILE_MODE;

        }
    }

    static class FTP
    extends Composite {
        Text hostName;
        Text loginName;
        Text loginPassword;
        Combo archiveFileMode;

        public FTP(Composite composite, EnumSet<WidgetTypes> enumSet, final WidgetVariable widgetVariable, final WidgetVariable widgetVariable2, final WidgetVariable widgetVariable3, final WidgetVariable widgetVariable4) {
            super(composite, 0);
            this.setLayout(new TableLayout(1.0, new double[]{0.0, 1.0}));
            int n = 0;
            Label label = Widgets.newLabel((Composite)this, BARControl.tr("Server", new Object[0]) + ":");
            Widgets.layout(label, n, 0, 4);
            Composite composite2 = Widgets.newComposite((Composite)this, 0);
            composite2.setLayout(new TableLayout(1.0, new double[]{1.0}));
            Widgets.layout(composite2, n, 1, 12);
            this.hostName = Widgets.newText(composite2);
            this.hostName.setToolTipText(BARControl.tr("FTP server name.", new Object[0]));
            Widgets.layout(this.hostName, 0, 0, 12);
            this.hostName.addModifyListener(new ModifyListener(){

                @Override
                public void modifyText(ModifyEvent modifyEvent) {
                    Text text = (Text)modifyEvent.widget;
                    String string = text.getText();
                    if (widgetVariable != null) {
                        Color color = COLOR_MODIFIED;
                        if (widgetVariable.getString().equals(string)) {
                            color = null;
                        }
                        text.setBackground(color);
                        text.setData("showedErrorDialog", false);
                    }
                }
            });
            this.hostName.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    Text text = (Text)selectionEvent.widget;
                    String string = text.getText();
                    if (widgetVariable != null) {
                        widgetVariable.set(string);
                        text.setBackground(null);
                    }
                }

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                }
            });
            this.hostName.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    Text text = (Text)focusEvent.widget;
                    text.setData("showedErrorDialog", false);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    Text text = (Text)focusEvent.widget;
                    if (widgetVariable != null) {
                        widgetVariable.set(text.getText());
                        text.setBackground(null);
                    }
                }
            });
            if (widgetVariable != null) {
                Widgets.addModifyListener(new WidgetModifyListener((Widget)this.hostName, widgetVariable));
            }
            label = Widgets.newLabel((Composite)this, BARControl.tr("Login", new Object[0]) + ":");
            Widgets.layout(label, ++n, 0, 4);
            composite2 = Widgets.newComposite((Composite)this, 0);
            composite2.setLayout(new TableLayout(0.0, new double[]{1.0, 0.0, 1.0}));
            Widgets.layout(composite2, n, 1, 12);
            this.loginName = Widgets.newText(composite2);
            this.loginName.setToolTipText(BARControl.tr("FTP server user login name. Leave it empty to use the default name from the configuration file.", new Object[0]));
            Widgets.layout(this.loginName, 0, 0, 12);
            this.loginName.addModifyListener(new ModifyListener(){

                @Override
                public void modifyText(ModifyEvent modifyEvent) {
                    Text text = (Text)modifyEvent.widget;
                    String string = text.getText();
                    if (widgetVariable2 != null) {
                        Color color = COLOR_MODIFIED;
                        if (widgetVariable2.getString().equals(string)) {
                            color = null;
                        }
                        text.setBackground(color);
                        text.setData("showedErrorDialog", false);
                    }
                }
            });
            this.loginName.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    Text text = (Text)selectionEvent.widget;
                    if (widgetVariable2 != null) {
                        widgetVariable2.set(text.getText());
                        text.setBackground(null);
                    }
                }

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                }
            });
            this.loginName.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    Text text = (Text)focusEvent.widget;
                    text.setData("showedErrorDialog", false);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    Text text = (Text)focusEvent.widget;
                    if (widgetVariable2 != null) {
                        widgetVariable2.set(text.getText());
                        text.setBackground(null);
                    }
                }
            });
            if (widgetVariable2 != null) {
                Widgets.addModifyListener(new WidgetModifyListener((Widget)this.loginName, widgetVariable2));
            }
            label = Widgets.newLabel(composite2, BARControl.tr("Password", new Object[0]) + ":");
            Widgets.layout(label, 0, 1, 4);
            this.loginPassword = Widgets.newPassword(composite2);
            this.loginPassword.setToolTipText(BARControl.tr("FTP server login password. Leave it empty to use the default password from the configuration file.", new Object[0]));
            Widgets.layout(this.loginPassword, 0, 2, 12);
            this.loginPassword.addModifyListener(new ModifyListener(){

                @Override
                public void modifyText(ModifyEvent modifyEvent) {
                    Text text = (Text)modifyEvent.widget;
                    String string = text.getText();
                    if (widgetVariable3 != null) {
                        Color color = COLOR_MODIFIED;
                        if (widgetVariable3.getString().equals(string)) {
                            color = null;
                        }
                        text.setBackground(color);
                        text.setData("showedErrorDialog", false);
                    }
                }
            });
            this.loginPassword.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    Text text = (Text)selectionEvent.widget;
                    if (widgetVariable3 != null) {
                        widgetVariable3.set(text.getText());
                        text.setBackground(null);
                    }
                }

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                }
            });
            this.loginPassword.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    Text text = (Text)focusEvent.widget;
                    text.setData("showedErrorDialog", false);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    Text text = (Text)focusEvent.widget;
                    if (widgetVariable3 != null) {
                        widgetVariable3.set(text.getText());
                        text.setBackground(null);
                    }
                }
            });
            if (widgetVariable3 != null) {
                Widgets.addModifyListener(new WidgetModifyListener((Widget)this.loginPassword, widgetVariable3));
            }
            ++n;
            if (enumSet.contains((Object)WidgetTypes.ARCHIVE_FILE_MODE)) {
                label = Widgets.newLabel((Composite)this, BARControl.tr("Archive file mode", new Object[0]) + ":");
                Widgets.layout(label, n, 0, 4);
                this.archiveFileMode = Widgets.newOptionMenu(this);
                this.archiveFileMode.setToolTipText(BARControl.tr("If set to ''rename'' then the archive is renamed if it already exists.\nIf set to ''append'' then data is appended to the existing archive files.\nIf set to ''overwrite'' then existing archive files are overwritten.", new Object[0]));
                Widgets.setComboItems(this.archiveFileMode, new Object[]{BARControl.tr("stop if exists", new Object[0]), "stop", BARControl.tr("rename if exists", new Object[0]), "rename", BARControl.tr("append", new Object[0]), "append", BARControl.tr("overwrite", new Object[0]), "overwrite"});
                Widgets.layout(this.archiveFileMode, n, 1, 4);
                this.archiveFileMode.addSelectionListener(new SelectionListener(){

                    @Override
                    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    }

                    @Override
                    public void widgetSelected(SelectionEvent selectionEvent) {
                        Combo combo = (Combo)selectionEvent.widget;
                        String string = Widgets.getSelectedComboItem(combo, "stop");
                        if (widgetVariable4 != null) {
                            widgetVariable4.set(string);
                        }
                    }
                });
                if (widgetVariable4 != null) {
                    Widgets.addModifyListener(new WidgetModifyListener((Widget)this.archiveFileMode, widgetVariable4));
                }
                ++n;
            }
            this.setVisible(false);
        }

        public FTP(Composite composite, WidgetVariable widgetVariable, WidgetVariable widgetVariable2, WidgetVariable widgetVariable3, WidgetVariable widgetVariable4) {
            this(composite, EnumSet.allOf(WidgetTypes.class), widgetVariable, widgetVariable2, widgetVariable3, widgetVariable4);
        }

        public FTP(Composite composite, EnumSet<WidgetTypes> enumSet) {
            this(composite, enumSet, null, null, null, null);
        }

        public FTP(Composite composite) {
            this(composite, EnumSet.noneOf(WidgetTypes.class));
        }

        static enum WidgetTypes {
            ARCHIVE_FILE_MODE;

        }
    }

    static class File
    extends Composite {
        Combo maxStorageSize;
        Combo archiveFileMode;

        public File(Composite composite, EnumSet<WidgetTypes> enumSet, WidgetVariable widgetVariable, final WidgetVariable widgetVariable2) {
            super(composite, 0);
            Label label;
            Composite composite2;
            this.setLayout(new TableLayout(0.0, 0.0));
            int n = 0;
            Composite composite3 = Widgets.newComposite((Composite)this, 0);
            composite3.setLayout(new TableLayout(1.0, 0.0));
            Widgets.layout(composite3, 0, 0, 12);
            if (enumSet.contains((Object)WidgetTypes.MAX_STORAGE_SIZE)) {
                composite2 = Widgets.newComposite(composite3, 0);
                composite2.setLayout(new TableLayout(1.0, 0.0));
                Widgets.layout(composite2, n, 0, 12);
                label = Widgets.newLabel(composite2, BARControl.tr("Max. storage size", new Object[0]) + ":");
                Widgets.layout(label, 0, 0, 4);
                this.maxStorageSize = BARWidgets.newByteSize(composite2, BARControl.tr("Storage size limit.", new Object[0]), widgetVariable, new Object[]{BARControl.tr("unlimited", new Object[0]), 0L, Units.formatSize(1L * Units.G), 1L * Units.G, Units.formatSize(2L * Units.G), 2L * Units.G, Units.formatSize(4L * Units.G), 4L * Units.G, Units.formatSize(8L * Units.G), 8L * Units.G, Units.formatSize(64L * Units.G), 64L * Units.G, Units.formatSize(128L * Units.G), 128L * Units.G, Units.formatSize(512L * Units.G), 512L * Units.G, Units.formatSize(1L * Units.T), 1L * Units.T, Units.formatSize(2L * Units.T), 2L * Units.T, Units.formatSize(4L * Units.T), 4L * Units.T, Units.formatSize(8L * Units.T), 8L * Units.T});
                this.maxStorageSize.setData("showedErrorDialog", false);
                Widgets.layout(this.maxStorageSize, 0, 1, 4, 0, 0, 0, 0, 120, -1);
                ++n;
            }
            if (enumSet.contains((Object)WidgetTypes.ARCHIVE_FILE_MODE)) {
                composite2 = Widgets.newComposite(composite3, 0);
                composite2.setLayout(new TableLayout(1.0, 0.0));
                Widgets.layout(composite2, n, 0, 12);
                label = Widgets.newLabel(composite2, BARControl.tr("Archive file mode", new Object[0]) + ":");
                Widgets.layout(label, 0, 0, 4);
                this.archiveFileMode = Widgets.newOptionMenu(composite2);
                this.archiveFileMode.setToolTipText(BARControl.tr("If set to ''rename'' then the archive is renamed if it already exists.\nIf set to ''append'' then data is appended to the existing archive files.\nIf set to ''overwrite'' then existing archive files are overwritten.\nOtherwise stop with an error.", new Object[0]));
                Widgets.setComboItems(this.archiveFileMode, new Object[]{BARControl.tr("stop if exists", new Object[0]), "stop", BARControl.tr("rename if exists", new Object[0]), "rename", BARControl.tr("append", new Object[0]), "append", BARControl.tr("overwrite", new Object[0]), "overwrite"});
                Widgets.layout(this.archiveFileMode, 0, 1, 4);
                this.archiveFileMode.addSelectionListener(new SelectionListener(){

                    @Override
                    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    }

                    @Override
                    public void widgetSelected(SelectionEvent selectionEvent) {
                        Combo combo = (Combo)selectionEvent.widget;
                        String string = Widgets.getSelectedComboItem(combo, "stop");
                        if (widgetVariable2 != null) {
                            widgetVariable2.set(string);
                        }
                    }
                });
                if (widgetVariable2 != null) {
                    Widgets.addModifyListener(new WidgetModifyListener((Widget)this.archiveFileMode, widgetVariable2));
                }
                ++n;
            }
            this.setVisible(false);
        }

        public File(Composite composite, WidgetVariable widgetVariable, WidgetVariable widgetVariable2) {
            this(composite, EnumSet.allOf(WidgetTypes.class), widgetVariable, widgetVariable2);
        }

        public File(Composite composite, EnumSet<WidgetTypes> enumSet) {
            this(composite, enumSet, null, null);
        }

        public File(Composite composite) {
            this(composite, EnumSet.noneOf(WidgetTypes.class), null, null);
        }

        static enum WidgetTypes {
            MAX_STORAGE_SIZE,
            ARCHIVE_FILE_MODE;

        }
    }

    static class Listener {
        Listener() {
        }

        public int getInt(WidgetVariable widgetVariable) {
            return 0;
        }

        public void setInt(WidgetVariable widgetVariable, int n) {
        }

        public long getLong(WidgetVariable widgetVariable) {
            return 0L;
        }

        public void setLong(WidgetVariable widgetVariable, long l) {
        }

        public String getString(WidgetVariable widgetVariable) {
            return "";
        }

        public void setString(WidgetVariable widgetVariable, String string) {
        }

        public boolean getChecked(WidgetVariable widgetVariable) {
            return false;
        }

        public void setChecked(WidgetVariable widgetVariable, boolean bl) {
        }
    }
}

