/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.win32.OS;

class Relation {
    Accessible accessible;
    COMObject objIAccessibleRelation;
    int refCount;
    int type;
    Accessible[] targets;
    static final String[] relationTypeString = new String[]{"controlledBy", "controllerFor", "describedBy", "descriptionFor", "embeddedBy", "embeds", "flowsFrom", "flowsTo", "labelFor", "labelledBy", "memberOf", "nodeChildOf", "parentWindowOf", "popupFor", "subwindowOf"};
    static final String[] localizedRelationTypeString = new String[]{SWT.getMessage("SWT_Controlled_By"), SWT.getMessage("SWT_Controller_For"), SWT.getMessage("SWT_Described_By"), SWT.getMessage("SWT_Description_For"), SWT.getMessage("SWT_Embedded_By"), SWT.getMessage("SWT_Embeds"), SWT.getMessage("SWT_Flows_From"), SWT.getMessage("SWT_Flows_To"), SWT.getMessage("SWT_Label_For"), SWT.getMessage("SWT_Labelled_By"), SWT.getMessage("SWT_Member_Of"), SWT.getMessage("SWT_Node_Child_Of"), SWT.getMessage("SWT_Parent_Window_Of"), SWT.getMessage("SWT_Popup_For"), SWT.getMessage("SWT_Subwindow_Of")};

    Relation(Accessible accessible, int n) {
        this.accessible = accessible;
        this.type = n;
        this.targets = new Accessible[0];
        this.AddRef();
    }

    long getAddress() {
        if (this.objIAccessibleRelation == null) {
            this.createIAccessibleRelation();
        }
        return this.objIAccessibleRelation.getAddress();
    }

    void createIAccessibleRelation() {
        this.objIAccessibleRelation = new COMObject(new int[]{2, 0, 0, 1, 1, 1, 2, 3}){

            public long method0(long[] lArray) {
                return Relation.this.QueryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return Relation.this.AddRef();
            }

            public long method2(long[] lArray) {
                return Relation.this.Release();
            }

            public long method3(long[] lArray) {
                return Relation.this.get_relationType(lArray[0]);
            }

            public long method4(long[] lArray) {
                return Relation.this.get_localizedRelationType(lArray[0]);
            }

            public long method5(long[] lArray) {
                return Relation.this.get_nTargets(lArray[0]);
            }

            public long method6(long[] lArray) {
                return Relation.this.get_target((int)lArray[0], lArray[1]);
            }

            public long method7(long[] lArray) {
                return Relation.this.get_targets((int)lArray[0], lArray[1], lArray[2]);
            }
        };
    }

    int QueryInterface(long l, long l2) {
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, l, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown) || COM.IsEqualGUID(gUID, COM.IIDIAccessibleRelation)) {
            COM.MoveMemory(l2, new long[]{this.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        return -2147467262;
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            if (this.objIAccessibleRelation != null) {
                this.objIAccessibleRelation.dispose();
            }
            this.objIAccessibleRelation = null;
        }
        return this.refCount;
    }

    int get_relationType(long l) {
        this.setString(l, relationTypeString[this.type]);
        return 0;
    }

    int get_localizedRelationType(long l) {
        this.setString(l, localizedRelationTypeString[this.type]);
        return 0;
    }

    int get_nTargets(long l) {
        COM.MoveMemory(l, new int[]{this.targets.length}, 4);
        return 0;
    }

    int get_target(int n, long l) {
        if (n < 0 || n >= this.targets.length) {
            return -2147024809;
        }
        Accessible accessible = this.targets[n];
        accessible.AddRef();
        COM.MoveMemory(l, new long[]{accessible.getAddress()}, OS.PTR_SIZEOF);
        return 0;
    }

    int get_targets(int n, long l, long l2) {
        int n2 = Math.min(this.targets.length, n);
        for (int i = 0; i < n2; ++i) {
            Accessible accessible = this.targets[i];
            accessible.AddRef();
            COM.MoveMemory(l + (long)(i * OS.PTR_SIZEOF), new long[]{accessible.getAddress()}, OS.PTR_SIZEOF);
        }
        COM.MoveMemory(l2, new int[]{n2}, 4);
        return 0;
    }

    void addTarget(Accessible accessible) {
        if (this.containsTarget(accessible)) {
            return;
        }
        Accessible[] accessibleArray = new Accessible[this.targets.length + 1];
        System.arraycopy(this.targets, 0, accessibleArray, 0, this.targets.length);
        accessibleArray[this.targets.length] = accessible;
        this.targets = accessibleArray;
    }

    boolean containsTarget(Accessible accessible) {
        for (int i = 0; i < this.targets.length; ++i) {
            if (this.targets[i] != accessible) continue;
            return true;
        }
        return false;
    }

    void removeTarget(Accessible accessible) {
        if (!this.containsTarget(accessible)) {
            return;
        }
        Accessible[] accessibleArray = new Accessible[this.targets.length - 1];
        int n = 0;
        for (int i = 0; i < this.targets.length; ++i) {
            if (this.targets[i] == accessible) continue;
            accessibleArray[n++] = this.targets[i];
        }
        this.targets = accessibleArray;
    }

    boolean hasTargets() {
        return this.targets.length > 0;
    }

    void setString(long l, String string) {
        char[] cArray = (string + "\u0000").toCharArray();
        long l2 = COM.SysAllocString(cArray);
        COM.MoveMemory(l, new long[]{l2}, OS.PTR_SIZEOF);
    }
}

