/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TF_DISPLAYATTRIBUTE;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public class IME
extends Widget {
    Canvas parent;
    int caretOffset;
    int startOffset;
    int commitCount;
    String text;
    int[] ranges;
    TextStyle[] styles;
    static final int WM_MSIME_MOUSE = OS.RegisterWindowMessage(new TCHAR(0, "MSIMEMouseOperation", true));
    static final byte[] IID_ITfInputProcessorProfiles = new byte[16];
    static final byte[] IID_ITfDisplayAttributeProvider = new byte[16];
    static final byte[] CLSID_TF_InputProcessorProfiles = new byte[16];
    static final byte[] GUID_TFCAT_TIP_KEYBOARD = new byte[16];
    static final int UNDERLINE_IME_DOT = 65536;
    static final int UNDERLINE_IME_DASH = 131072;
    static final int UNDERLINE_IME_THICK = 196608;

    IME() {
    }

    public IME(Canvas canvas, int n) {
        super(canvas, n);
        this.parent = canvas;
        this.createWidget();
    }

    void createWidget() {
        this.text = "";
        this.startOffset = -1;
        if (this.parent.getIME() == null) {
            this.parent.setIME(this);
        }
    }

    public int getCaretOffset() {
        this.checkWidget();
        return this.startOffset + this.caretOffset;
    }

    public int getCommitCount() {
        this.checkWidget();
        return this.commitCount;
    }

    public int getCompositionOffset() {
        this.checkWidget();
        return this.startOffset;
    }

    TF_DISPLAYATTRIBUTE getDisplayAttribute(short s, int n) {
        long[] lArray = new long[1];
        int n2 = OS.CoCreateInstance(CLSID_TF_InputProcessorProfiles, 0L, 1, IID_ITfInputProcessorProfiles, lArray);
        TF_DISPLAYATTRIBUTE tF_DISPLAYATTRIBUTE = null;
        if (n2 == 0) {
            long[] lArray2;
            byte[] byArray = new byte[16];
            byte[] byArray2 = new byte[16];
            n2 = OS.VtblCall(8, lArray[0], s, GUID_TFCAT_TIP_KEYBOARD, byArray, byArray2);
            if (n2 == 0 && (n2 = OS.CoCreateInstance(byArray, 0L, 1, IID_ITfDisplayAttributeProvider, lArray2 = new long[1])) == 0) {
                long[] lArray3 = new long[1];
                n2 = OS.VtblCall(3, lArray2[0], lArray3);
                if (n2 == 0) {
                    long[] lArray4 = new long[1];
                    TF_DISPLAYATTRIBUTE tF_DISPLAYATTRIBUTE2 = new TF_DISPLAYATTRIBUTE();
                    while ((n2 = OS.VtblCall(4, lArray3[0], 1, lArray4, (int[])null)) == 0) {
                        OS.VtblCall(5, lArray4[0], tF_DISPLAYATTRIBUTE2);
                        OS.VtblCall(2, lArray4[0]);
                        if (tF_DISPLAYATTRIBUTE2.bAttr != n) continue;
                        tF_DISPLAYATTRIBUTE = tF_DISPLAYATTRIBUTE2;
                        break;
                    }
                    n2 = OS.VtblCall(2, lArray3[0]);
                }
                n2 = OS.VtblCall(2, lArray2[0]);
            }
            n2 = OS.VtblCall(2, lArray[0]);
        }
        if (tF_DISPLAYATTRIBUTE == null) {
            tF_DISPLAYATTRIBUTE = new TF_DISPLAYATTRIBUTE();
            switch (n) {
                case 0: {
                    tF_DISPLAYATTRIBUTE.lsStyle = 4;
                    break;
                }
                case 1: 
                case 2: {
                    tF_DISPLAYATTRIBUTE.lsStyle = 1;
                    tF_DISPLAYATTRIBUTE.fBoldLine = n == 1;
                }
            }
        }
        return tF_DISPLAYATTRIBUTE;
    }

    public int[] getRanges() {
        this.checkWidget();
        if (this.ranges == null) {
            return new int[0];
        }
        int[] nArray = new int[this.ranges.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.ranges[i] + this.startOffset;
        }
        return nArray;
    }

    public TextStyle[] getStyles() {
        this.checkWidget();
        if (this.styles == null) {
            return new TextStyle[0];
        }
        TextStyle[] textStyleArray = new TextStyle[this.styles.length];
        System.arraycopy(this.styles, 0, textStyleArray, 0, this.styles.length);
        return textStyleArray;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean getWideCaret() {
        this.checkWidget();
        long l = OS.GetKeyboardLayout(0);
        short s = (short)OS.LOWORD(l);
        return OS.PRIMARYLANGID(s) == 18;
    }

    boolean isInlineEnabled() {
        if (OS.IsWinCE || OS.WIN32_VERSION < OS.VERSION(5, 1)) {
            return false;
        }
        return OS.IsDBLocale && this.hooks(43);
    }

    void releaseParent() {
        super.releaseParent();
        if (this == this.parent.getIME()) {
            this.parent.setIME(null);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.text = null;
        this.styles = null;
        this.ranges = null;
    }

    public void setCompositionOffset(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        if (this.startOffset != -1) {
            this.startOffset = n;
        }
    }

    LRESULT WM_IME_COMPOSITION(long l, long l2) {
        if (!this.isInlineEnabled()) {
            return null;
        }
        this.ranges = null;
        this.styles = null;
        this.commitCount = 0;
        this.caretOffset = 0;
        long l3 = this.parent.handle;
        long l4 = OS.ImmGetContext(l3);
        int n = this.parent.getCodePage();
        if (l4 != 0L) {
            short s;
            Object object;
            Object object2;
            int n2;
            TCHAR tCHAR = null;
            if ((l2 & 0x800L) != 0L) {
                n2 = OS.ImmGetCompositionString(l4, 2048, (TCHAR)null, 0);
                if (n2 > 0) {
                    tCHAR = new TCHAR(n, n2 / TCHAR.sizeof);
                    OS.ImmGetCompositionString(l4, 2048, tCHAR, n2);
                    if (this.startOffset == -1) {
                        object2 = new Event();
                        ((Event)object2).detail = 3;
                        this.sendEvent(43, (Event)object2);
                        this.startOffset = ((Event)object2).start;
                    }
                    object2 = new Event();
                    ((Event)object2).detail = 1;
                    ((Event)object2).start = this.startOffset;
                    ((Event)object2).end = this.startOffset + this.text.length();
                    this.text = tCHAR != null ? tCHAR.toString() : "";
                    ((Event)object2).text = this.text;
                    this.commitCount = this.text.length();
                    this.sendEvent(43, (Event)object2);
                    object = this.text;
                    this.text = "";
                    this.startOffset = -1;
                    this.commitCount = 0;
                    if (((Event)object2).doit) {
                        Display display = this.display;
                        display.lastKey = 0;
                        display.lastDead = false;
                        display.lastNull = false;
                        display.lastVirtual = false;
                        n2 = ((String)object).length();
                        for (int i = 0; i < n2; ++i) {
                            s = (short)((String)object).charAt(i);
                            display.lastAscii = s;
                            object2 = new Event();
                            ((Event)object2).character = (char)s;
                            this.parent.sendEvent(1, (Event)object2);
                        }
                    }
                }
                if ((l2 & 8L) == 0L) {
                    return LRESULT.ONE;
                }
            }
            tCHAR = null;
            if ((l2 & 8L) != 0L) {
                n2 = OS.ImmGetCompositionString(l4, 8, (TCHAR)null, 0);
                if (n2 > 0) {
                    tCHAR = new TCHAR(n, n2 / TCHAR.sizeof);
                    OS.ImmGetCompositionString(l4, 8, tCHAR, n2);
                    if ((l2 & 0x80L) != 0L) {
                        this.caretOffset = OS.ImmGetCompositionString(l4, 128, (TCHAR)null, 0);
                    }
                    object2 = null;
                    if ((l2 & 0x20L) != 0L && (n2 = OS.ImmGetCompositionString(l4, 32, (int[])null, 0)) > 0) {
                        object2 = new int[n2 / 4];
                        OS.ImmGetCompositionString(l4, 32, (int[])object2, n2);
                    }
                    if ((l2 & 0x10L) != 0L && object2 != null && (n2 = OS.ImmGetCompositionString(l4, 16, (byte[])null, 0)) > 0) {
                        object = new byte[n2];
                        OS.ImmGetCompositionString(l4, 16, (byte[])object, n2);
                        n2 = ((Object)object2).length - 1;
                        this.ranges = new int[n2 * 2];
                        this.styles = new TextStyle[n2];
                        long l5 = OS.GetKeyboardLayout(0);
                        s = (short)OS.LOWORD(l5);
                        TF_DISPLAYATTRIBUTE tF_DISPLAYATTRIBUTE = null;
                        TextStyle textStyle = null;
                        block19: for (int i = 0; i < n2; ++i) {
                            int n3;
                            this.ranges[i * 2] = (int)object2[i];
                            this.ranges[i * 2 + 1] = (int)(object2[i + 1] - true);
                            this.styles[i] = textStyle = new TextStyle();
                            tF_DISPLAYATTRIBUTE = this.getDisplayAttribute(s, (int)object[object2[i]]);
                            if (tF_DISPLAYATTRIBUTE == null) continue;
                            switch (tF_DISPLAYATTRIBUTE.crText.type) {
                                case 2: {
                                    textStyle.foreground = Color.win32_new(this.display, tF_DISPLAYATTRIBUTE.crText.cr);
                                    break;
                                }
                                case 1: {
                                    n3 = OS.GetSysColor(tF_DISPLAYATTRIBUTE.crText.cr);
                                    textStyle.foreground = Color.win32_new(this.display, n3);
                                }
                            }
                            switch (tF_DISPLAYATTRIBUTE.crBk.type) {
                                case 2: {
                                    textStyle.background = Color.win32_new(this.display, tF_DISPLAYATTRIBUTE.crBk.cr);
                                    break;
                                }
                                case 1: {
                                    n3 = OS.GetSysColor(tF_DISPLAYATTRIBUTE.crBk.cr);
                                    textStyle.background = Color.win32_new(this.display, n3);
                                }
                            }
                            switch (tF_DISPLAYATTRIBUTE.crLine.type) {
                                case 2: {
                                    textStyle.underlineColor = Color.win32_new(this.display, tF_DISPLAYATTRIBUTE.crLine.cr);
                                    break;
                                }
                                case 1: {
                                    n3 = OS.GetSysColor(tF_DISPLAYATTRIBUTE.crLine.cr);
                                    textStyle.underlineColor = Color.win32_new(this.display, n3);
                                }
                            }
                            textStyle.underline = tF_DISPLAYATTRIBUTE.lsStyle != 0;
                            switch (tF_DISPLAYATTRIBUTE.lsStyle) {
                                case 4: {
                                    textStyle.underlineStyle = 3;
                                    continue block19;
                                }
                                case 3: {
                                    textStyle.underlineStyle = 131072;
                                    continue block19;
                                }
                                case 2: {
                                    textStyle.underlineStyle = 65536;
                                    continue block19;
                                }
                                case 1: {
                                    textStyle.underlineStyle = tF_DISPLAYATTRIBUTE.fBoldLine ? 196608 : 0;
                                }
                            }
                        }
                    }
                }
                OS.ImmReleaseContext(l3, l4);
            }
            n2 = this.startOffset + this.text.length();
            if (this.startOffset == -1) {
                object2 = new Event();
                ((Event)object2).detail = 3;
                this.sendEvent(43, (Event)object2);
                this.startOffset = ((Event)object2).start;
                n2 = ((Event)object2).end;
            }
            object2 = new Event();
            ((Event)object2).detail = 1;
            ((Event)object2).start = this.startOffset;
            ((Event)object2).end = n2;
            this.text = tCHAR != null ? tCHAR.toString() : "";
            ((Event)object2).text = this.text;
            this.sendEvent(43, (Event)object2);
            if (this.text.length() == 0) {
                this.startOffset = -1;
                this.ranges = null;
                this.styles = null;
            }
        }
        return LRESULT.ONE;
    }

    LRESULT WM_IME_COMPOSITION_START(long l, long l2) {
        return this.isInlineEnabled() ? LRESULT.ONE : null;
    }

    LRESULT WM_IME_ENDCOMPOSITION(long l, long l2) {
        return this.isInlineEnabled() ? LRESULT.ONE : null;
    }

    LRESULT WM_KEYDOWN(long l, long l2) {
        long l3;
        short s;
        if (l == 25L && OS.PRIMARYLANGID(s = (short)OS.LOWORD(l3 = OS.GetKeyboardLayout(0))) == 18) {
            Event event = new Event();
            event.detail = 3;
            this.sendEvent(43, event);
            if (event.start == event.end) {
                event.text = null;
                event.end = event.start + 1;
                this.sendEvent(43, event);
            }
            if (event.text != null && event.text.length() > 0) {
                TCHAR tCHAR;
                long l4;
                long l5;
                long l6;
                int n = event.text.length();
                if (n > 1) {
                    event.end = event.start + 1;
                }
                if ((l6 = OS.ImmEscape(l3, l5 = OS.ImmGetContext(l4 = this.parent.handle), 4104, tCHAR = new TCHAR(0, event.text, true))) != 0L) {
                    this.sendEvent(43, event);
                }
            }
        }
        return null;
    }

    LRESULT WM_KILLFOCUS(long l, long l2) {
        if (!this.isInlineEnabled()) {
            return null;
        }
        long l3 = this.parent.handle;
        long l4 = OS.ImmGetContext(l3);
        if (l4 != 0L) {
            if (OS.ImmGetOpenStatus(l4)) {
                OS.ImmNotifyIME(l4, 21, 1, 0);
            }
            OS.ImmReleaseContext(l3, l4);
        }
        return null;
    }

    LRESULT WM_LBUTTONDOWN(long l, long l2) {
        if (!this.isInlineEnabled()) {
            return null;
        }
        long l3 = this.parent.handle;
        long l4 = OS.ImmGetContext(l3);
        if (l4 != 0L) {
            if (OS.ImmGetOpenStatus(l4) && OS.ImmGetCompositionString(l4, 8, (TCHAR)null, 0) > 0) {
                Event event = new Event();
                event.detail = 2;
                event.x = OS.GET_X_LPARAM(l2);
                event.y = OS.GET_Y_LPARAM(l2);
                this.sendEvent(43, event);
                int n = event.index;
                int n2 = this.text.length();
                if (n != -1 && this.startOffset != -1 && this.startOffset <= n && n < this.startOffset + n2) {
                    long l5 = OS.ImmGetDefaultIMEWnd(l3);
                    n = event.index + event.count - this.startOffset;
                    int n3 = event.count > 0 ? 1 : 2;
                    long l6 = OS.MAKEWPARAM(OS.MAKEWORD(1, n3), n);
                    OS.SendMessage(l5, WM_MSIME_MOUSE, l6, l4);
                } else {
                    OS.ImmNotifyIME(l4, 21, 1, 0);
                }
            }
            OS.ImmReleaseContext(l3, l4);
        }
        return null;
    }

    static {
        OS.IIDFromString("{1F02B6C5-7842-4EE6-8A0B-9A24183A95CA}\u0000".toCharArray(), IID_ITfInputProcessorProfiles);
        OS.IIDFromString("{fee47777-163c-4769-996a-6e9c50ad8f54}\u0000".toCharArray(), IID_ITfDisplayAttributeProvider);
        OS.IIDFromString("{33C53A50-F456-4884-B049-85FD643ECFED}\u0000".toCharArray(), CLSID_TF_InputProcessorProfiles);
        OS.IIDFromString("{34745C63-B2F0-4784-8B67-5E12C8701A31}\u0000".toCharArray(), GUID_TFCAT_TIP_KEYBOARD);
    }
}

