/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import jline.TerminalFactory;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class BARControl {
    public static ListDirectory<File> listDirectory = new ListDirectory<File>(){
        private File[] files;
        private int index;

        @Override
        public File newFileInstance(String string, String string2) {
            if (string != null) {
                return new File(string, string2);
            }
            return new File(string2);
        }

        @Override
        public File getParentFile(File file) {
            return file.getParentFile();
        }

        @Override
        public String getAbsolutePath(File file) {
            return file.getAbsolutePath();
        }

        @Override
        public void getShortcuts(List<File> list) {
            HashMap<String, File> hashMap = new HashMap<String, File>();
            for (String object : Settings.shortcuts) {
                hashMap.put(object, new File(object));
            }
            hashMap.put("/", new File("/"));
            list.clear();
            for (File file : hashMap.values()) {
                list.add(file);
            }
            Collections.sort(list, this);
        }

        @Override
        public void addShortcut(File file) {
            Settings.shortcuts.add(file.getAbsolutePath());
        }

        @Override
        public void removeShortcut(File file) {
            Settings.shortcuts.remove(file.getAbsolutePath());
        }

        @Override
        public boolean open(File file) {
            this.files = file.listFiles();
            this.index = 0;
            return this.files != null;
        }

        @Override
        public void close() {
        }

        @Override
        public File getNext() {
            File file;
            if (this.index < this.files.length) {
                file = this.files[this.index];
                ++this.index;
            } else {
                file = null;
            }
            return file;
        }

        @Override
        public boolean isRoot(File file) {
            return file.getAbsolutePath() == "/";
        }

        @Override
        public boolean isDirectory(File file) {
            return file.isDirectory();
        }

        @Override
        public boolean isFile(File file) {
            return file.isFile();
        }

        @Override
        public boolean isHidden(File file) {
            return file.isHidden();
        }

        @Override
        public boolean exists(File file) {
            return file.exists();
        }

        @Override
        public void mkdir(File file) throws IOException {
            file.mkdir();
        }

        @Override
        public void delete(File file) throws IOException {
            for (File file2 : this.getRoots()) {
                if (file2.compareTo(file) != 0) continue;
                return;
            }
            file.delete();
        }
    };
    static final int USER_EVENT_SELECT_SERVER = 65535;
    static final int USER_EVENT_NEW_JOB = 65536;
    static final int USER_EVENT_UPDATE_JOB = 65537;
    static final int USER_EVENT_DELETE_JOB = 65538;
    static final int USER_EVENT_SELECT_JOB = 65539;
    public static final String ALL_FILE_EXTENSION;
    public static final char MAIL_AT = '@';
    public static final String EMAIL_ADDRESS = "torsten.rupp@gmx.net";
    public static final String URL = "http://www.kigen.de/projects/bar";
    public static final String URL_VERSION_FILE = "http://www.kigen.de/projects/bar/version";
    private static final HostSystems hostSystem;
    private static final OptionEnumeration[] ARCHIVE_TYPE_ENUMERATION;
    private static final OptionEnumeration[] ROLE_ENUMERATION;
    private static final OptionSpecial OPTION_GEOMETRY;
    private static final Option[] OPTIONS;
    private static Image IMAGE_ERROR;
    private static Image IMAGE_LOCK;
    private static Image IMAGE_LOCK_INSECURE;
    private static I18n i18n;
    private static Display display;
    private static Shell shell;
    private static Clipboard clipboard;
    private static Cursor waitCursor;
    private static int waitCursorCount;
    private LoginData loginData;
    private Menu serverMenu;
    private MenuItem serverMenuLastSelectedItem;
    private MenuItem masterMenuItem;
    private TabFolder widgetTabFolder;
    private Shell widgetTabFolderToolTip;
    private TabStatus widgetTabStatus;
    private TabJobs widgetTabJobs;
    private TabRestore widgetTabRestore;
    private boolean quitFlag;

    static String tr(String string, Object ... objectArray) {
        return i18n.tr(string, objectArray);
    }

    static String trc(String string, String string2) {
        return i18n.trc(string, string2);
    }

    public static List<String> getStackTraceList(Throwable throwable) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = throwable.getStackTrace();
        int n = ((StackTraceElement[])object).length;
        for (int i = 0; i < n; ++i) {
            StackTraceElement stackTraceElement = object[i];
            arrayList.add("  " + stackTraceElement);
        }
        for (object = throwable.getCause(); object != null; object = ((Throwable)object).getCause()) {
            arrayList.add("Caused by:");
            for (StackTraceElement stackTraceElement : ((Throwable)object).getStackTrace()) {
                arrayList.add("  " + stackTraceElement);
            }
        }
        return arrayList;
    }

    public static void printStackTrace(PrintStream printStream, Throwable throwable) {
        Object object = throwable.getStackTrace();
        int n = ((StackTraceElement[])object).length;
        for (int i = 0; i < n; ++i) {
            StackTraceElement stackTraceElement = object[i];
            printStream.println("  " + stackTraceElement);
        }
        for (object = throwable.getCause(); object != null; object = ((Throwable)object).getCause()) {
            StackTraceElement[] stackTraceElementArray = ((Throwable)object).getStackTrace();
            printStream.println("Caused by:");
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                printStream.println("  " + stackTraceElement);
            }
        }
    }

    public static void printStackTrace(Throwable throwable) {
        BARControl.printStackTrace(System.err, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logThrowable(Throwable throwable) {
        String string = System.getProperty("user.home") + File.separator + ".bar" + File.separator + "barcontrol.log";
        if (Settings.debugLevel > 0) {
            BARControl.printError(throwable);
        }
        try (PrintStream printStream = null;){
            File file = new File(string);
            File file2 = file.getParentFile();
            if (file2 != null && !file2.exists()) {
                file2.mkdirs();
            }
            printStream = new PrintStream(new FileOutputStream(file, true));
            printStream.println("Date/Time: " + new Date().toString());
            printStream.println("Version: " + Version.STRING);
            printStream.println("Protocol version: 9.0");
            printStream.println("Java version: " + System.getProperty("java.version"));
            printStream.println("Error: " + throwable.getMessage());
            BARControl.printStackTrace(printStream, throwable);
            printStream.println("---");
            printStream.close();
            printStream = null;
        }
    }

    public static void printError(Throwable throwable) {
        System.err.println(BARControl.tr("ERROR", new Object[0]) + ": " + (throwable.getMessage() != null ? throwable.getMessage() : throwable.toString()));
    }

    public static void printError(String string, Object ... objectArray) {
        System.err.println(BARControl.tr("ERROR", new Object[0]) + ": " + String.format(string, objectArray));
    }

    public static void printWarning(String string, Object ... objectArray) {
        System.err.println(BARControl.tr("Warning", new Object[0]) + ": " + String.format(string, objectArray));
    }

    public static void printInternalError(String string, Object ... objectArray) {
        System.err.println("INTERNAL ERROR: " + String.format(string, objectArray));
        System.err.println("Version " + Version.STRING);
        System.err.println("Please report this error to torsten.rupp@gmx.net.");
    }

    public static void printInternalError(Throwable throwable) {
        System.err.println("INTERNAL ERROR: " + throwable.getMessage());
        BARControl.printStackTrace(throwable);
        BARControl.logThrowable(throwable);
        System.err.println("Version " + Version.STRING);
        System.err.println("Please report this error to torsten.rupp@gmx.net.");
    }

    public static SSLException reniceSSLException(SSLException sSLException) {
        Pattern pattern = Pattern.compile("^.*\\.CertPathValidatorException:\\s*(.*)$", 2);
        Matcher matcher = pattern.matcher(sSLException.getMessage());
        if (matcher.matches()) {
            sSLException = new SSLException(matcher.group(1), sSLException);
        }
        return sSLException;
    }

    public static IOException reniceIOException(IOException iOException) {
        Pattern pattern = Pattern.compile("^(.*?)\\s*java.io.IOException:\\s*error=\\d+,\\s*(.*)$", 2);
        Pattern pattern2 = Pattern.compile("^.*\\.SunCertPathBuilderException:\\s*(.*)$", 2);
        Matcher matcher = pattern.matcher(iOException.getMessage());
        if (matcher.matches()) {
            iOException = new IOException(matcher.group(1) + " " + matcher.group(2), iOException);
        } else {
            matcher = pattern2.matcher(iOException.getMessage());
            if (matcher.matches()) {
                iOException = new IOException(matcher.group(1), iOException);
            }
        }
        return iOException;
    }

    public static void showFatalError(final Throwable throwable) {
        boolean bl = true;
        do {
            try {
                bl = !display.readAndDispatch();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        } while (!bl);
        final String[] stringArray = new String[1];
        Throwable throwable3 = throwable;
        do {
            stringArray[0] = throwable3.toString();
        } while ((throwable3 = throwable3.getCause()) != null);
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Dialogs.error(new Shell(), BARControl.getStackTraceList(throwable), BARControl.tr("INTERNAL ERROR", new Object[0]) + ": " + stringArray[0] + "\n\nVersion " + Version.STRING + "\n\n" + BARControl.tr("Please report this error to ", new Object[0]) + BARControl.EMAIL_ADDRESS + ".");
            }
        });
    }

    public static void internalError(Throwable throwable) {
        BARControl.printInternalError(throwable);
        BARControl.showFatalError(throwable);
        BARControl.logThrowable(throwable);
        System.exit(127);
    }

    public static void waitCursor(Shell shell) {
        if (!shell.isDisposed()) {
            shell.setCursor(waitCursor);
        }
        ++waitCursorCount;
    }

    public static void resetCursor(Shell shell) {
        assert (waitCursorCount > 0);
        if (--waitCursorCount <= 0 && !shell.isDisposed()) {
            shell.setCursor(null);
        }
    }

    public static void waitCursor() {
        BARControl.waitCursor(shell);
    }

    public static void resetCursor() {
        BARControl.resetCursor(shell);
    }

    private void printUsage() {
        System.out.println("barcontrol usage: <options> [--] [<host name>[|:<port>]]");
        System.out.println("");
        System.out.println("Options: --config=<file name>                       - configuration file name (default: " + Settings.DEFAULT_BARCONTROL_CONFIG_FILE_NAME + ")");
        System.out.println("         -p|--port=<n>                              - server port (default: 38523)");
        System.out.println("         --tls-port=<n>                             - TLS server port (default: 0)");
        System.out.println("         --password=<password>                      - server password (use with care!)");
        System.out.println("         --ca-file=<file name>                      - additional trusted certificate authority file name (PEM format)");
        System.out.println("         --keystore-file=<file name>                - keystore file name (JKS format, default: ");
        System.out.println("                                                        ." + File.separator + "bar.jks" + " or ");
        System.out.println("                                                        " + System.getProperty("user.home") + File.separator + ".bar" + File.separator + "bar.jks" + " or ");
        System.out.println("                                                        /etc" + File.separator + "bar.jks");
        System.out.println("                                                      )");
        System.out.println("         --no-tls                                   - no TLS connection");
        System.out.println("         --force-tls                                - force TLS connection");
        System.out.println("         --insecure-tls                             - allow insecure TLS connections");
        System.out.println("         --login-dialog                             - force to open login dialog");
        System.out.println("         --pair-master                              - start pairing new master");
        System.out.println("");
        System.out.println("         --select-job=<name>                        - select job <name>");
        System.out.println("         -j|--job=<name>                            - start execution of job <name>");
        System.out.println("         --archive-type=<mode>                      - archive type:");
        System.out.println("                                                        normal (default)");
        System.out.println("                                                        full");
        System.out.println("                                                        incremental");
        System.out.println("                                                        differential");
        System.out.println("         --abort=<name>                             - abort execution of job <name>");
        System.out.println("         -s|--suspend                               - suspend job execution");
        System.out.println("         -c|--continue                              - continue job execution");
        System.out.println("         -t|--pause=<n>[s|m|h]                      - pause job execution for <n> seconds/minutes/hours");
        System.out.println("         -m|--maintenance=<n>[s|m|h]                - set intermediate maintenance for <n> seconds/minutes/hours");
        System.out.println("         -i|--ping                                  - check connection to server");
        System.out.println("         -l|--list-jobs                             - list jobs");
        System.out.println("         --list-schedules                           - list schedules");
        System.out.println("");
        System.out.println("         --index-database-info                      - print index info");
        System.out.println("         --index-database-add=<name|directory>      - add storage archive <name> or all .bar files to index");
        System.out.println("         --index-database-remove=<text>             - remove matching storage archives from index");
        System.out.println("         --index-database-refresh=<text>            - refresh matching storage archive in index");
        System.out.println("         -n|--index-database-entities-list=<text>   - list index entities");
        System.out.println("         -a|--index-database-storages-list=<text>   - list index storage archives");
        System.out.println("         -e|--index-database-entries-list=<text>    - list index entries");
        System.out.println("         --index-database-entries-newest            - list index newest entries only");
        System.out.println("         --index-database-history-list              - list index history");
        System.out.println("");
        System.out.println("         --restore=<name>                           - restore storage <name>");
        System.out.println("         --destination=<directory>                  - destination to restore entries");
        System.out.println("         --overwrite-entries                        - overwrite existing entries on restore");
        System.out.println("");
        System.out.println("         -L|--long-format                           - list in long format");
        System.out.println("         --no-header-footer                         - no header/footer output in list");
        System.out.println("");
        System.out.println("         --role=<role>                              - select role:");
        System.out.println("                                                        basic (default)");
        System.out.println("                                                        normal");
        System.out.println("                                                        expert");
        System.out.println("");
        System.out.println("         --geometry=<x>x<y>[+<x0>+<y0>]             - window geometry");
        System.out.println("");
        System.out.println("         --version                                  - output version");
        System.out.println("         -h|--help                                  - print this help");
        if (Settings.xhelpFlag) {
            System.out.println("");
            System.out.println("         -d|--debug                                 - enable debug mode");
            System.out.println("         --debug-ignore-protocol-version            - ignore protocol version");
            System.out.println("         --debug-fake-tls                           - fake TLS connections");
            System.out.println("         --debug-quit-server                        - send quit-command to server");
            System.out.println("         --debug-no-version-info                    - do not show version info dialog");
        }
    }

    private void printVersion() {
        System.out.println("barcontrol " + Version.STRING);
    }

    private void parseArguments(String[] stringArray) {
        int n = 0;
        boolean bl = false;
        while (n < stringArray.length) {
            if (!bl && stringArray[n].equals("--")) {
                bl = true;
                ++n;
                continue;
            }
            if (!bl && (stringArray[n].startsWith("--") || stringArray[n].startsWith("-"))) {
                int n2 = Options.parse(OPTIONS, stringArray, n, Settings.class);
                if (n2 < 0) {
                    throw new Error("Unknown option '" + stringArray[n] + "'!");
                }
                n = n2;
                continue;
            }
            Pattern pattern = Pattern.compile("^(.*):(\\d+)$");
            Matcher matcher = pattern.matcher(stringArray[n]);
            if (matcher.matches()) {
                Settings.serverName = matcher.group(1);
                Settings.serverPort = Integer.parseInt(matcher.group(2));
            } else {
                Settings.serverName = stringArray[n];
            }
            ++n;
        }
        if (Settings.helpFlag || Settings.xhelpFlag) {
            this.printUsage();
            System.exit(0);
        }
        if (Settings.versionFlag) {
            this.printVersion();
            System.exit(0);
        }
    }

    private static long getDatabaseId(long l) {
        return (l & 0xFFFFFFFFFFFFFFF0L) >> 4;
    }

    private static String getJobUUID(final String string) {
        String[] stringArray;
        block2: {
            stringArray = new String[]{null};
            try {
                BARServer.executeCommand(StringParser.format("JOB_LIST", new Object[0]), 1, new Command.ResultHandler(){

                    @Override
                    public void handle(int n, ValueMap valueMap) {
                        String string3 = valueMap.getString("jobUUID");
                        String string2 = valueMap.getString("name");
                        if (string.equalsIgnoreCase(string2)) {
                            stringArray[0] = string3;
                        }
                    }
                });
            }
            catch (Exception exception) {
                if (Settings.debugLevel <= 0) break block2;
                BARControl.printError("cannot get job list (error: %s)", exception.getMessage());
                BARControl.logThrowable(exception);
                BARServer.disconnect();
                System.exit(1);
            }
        }
        return stringArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(String string, int n, int n2, String string2, String string3, BARServer.TLSModes tLSModes, boolean bl, String string4) throws ConnectionError {
        BusyDialog busyDialog = null;
        if (display != null) {
            while (display.readAndDispatch()) {
            }
            if (shell != null) {
                busyDialog = new BusyDialog(shell, BARControl.tr("Connect", new Object[0]), 400, 60, BARControl.tr("Try to connect to ''", new Object[0]) + string + "'\u2026", 0x1000000);
            }
        }
        try {
            BARServer.connect(display, string, n, n2, string2, string3, tLSModes, bl, string4);
        }
        finally {
            if (busyDialog != null) {
                busyDialog.close();
            }
        }
    }

    private void reconnect(BARServer.TLSModes tLSModes, boolean bl) throws ConnectionError, CommunicationError {
        this.connect(this.loginData.name, this.loginData.port, this.loginData.tlsPort, Settings.serverCAFileName, Settings.serverKeystoreFileName, tLSModes, bl, this.loginData.password);
        if (!(this.loginData.tlsMode != BARServer.TLSModes.TRY || BARServer.isTLSConnection() && BARServer.isMatchCommonName())) {
            String string = BARServer.isExpiredCertificate() ? BARControl.tr("Established a none-TLS connection only. Certificate is expired.\nTransmitted data may be vulnerable!", new Object[0]) : (!BARServer.isMatchCommonName() ? BARControl.tr("Name in certificate do not match. TLS connection may be vulnerable!", new Object[0]) : BARControl.tr("Established a none-TLS connection only.\nTransmitted data may be vulnerable!", new Object[0]));
            Dialogs.warning(new Shell(), Dialogs.booleanFieldUpdater(Settings.class, "showNoneTLSWarning"), string, new Object[0]);
        }
    }

    private void initClassesWatchDog() {
        Object object;
        final HashMap<File, Long> hashMap = new HashMap<File, Long>();
        LinkedList<File> linkedList = new LinkedList<File>();
        for (String string : System.getProperty("java.class.path").split(File.pathSeparator)) {
            File file = new File(string);
            if (file.isDirectory()) {
                linkedList.add(file);
                continue;
            }
            hashMap.put(file, file.lastModified());
        }
        while (linkedList.size() > 0) {
            object = (File)linkedList.removeFirst();
            File[] fileArray = ((File)object).listFiles();
            if (fileArray == null) continue;
            for (File file : fileArray) {
                if (file.isDirectory()) {
                    linkedList.add(file);
                    continue;
                }
                hashMap.put(file, file.lastModified());
            }
        }
        object = new Thread(){
            private String homepageVersionMajor = null;
            private String homepageVersionMinor = null;
            private String homepageVersionPatch = null;
            private String homepageVersionRevision = null;
            private final ArrayList<String> homepageChangeLog = new ArrayList();

            @Override
            public void run() {
                long l = 0L;
                long l2 = 0L;
                final boolean[] blArray = new boolean[]{true};
                while (true) {
                    for (final File file : hashMap.keySet()) {
                        if (!blArray[0] || file.lastModified() <= (Long)hashMap.get(file) || System.currentTimeMillis() <= l + 300000L) continue;
                        display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!shell.isDisposed()) {
                                    switch (Dialogs.select(shell, BARControl.tr("Warning", new Object[0]), BARControl.tr("Class/JAR file ''{0}'' changed. Is is recommended to restart BARControl now.", file.getName()), new String[]{"Restart", "Remind me again in 5min", "Ignore"}, 0)) {
                                        case 0: {
                                            Widgets.notify((Widget)shell, 21, 64);
                                            break;
                                        }
                                        case 1: {
                                            break;
                                        }
                                        case 2: {
                                            blArray[0] = false;
                                        }
                                    }
                                }
                            }
                        });
                        l = System.currentTimeMillis();
                    }
                    if (Settings.showNewVersionInformation.booleanValue() && System.currentTimeMillis() > l2 + 3600000L && !Settings.debugNoVersionInfoFlag) {
                        this.getServerVersionInfo();
                        if (this.homepageVersionMajor != null && this.homepageVersionMinor != null && (this.homepageVersionMajor.compareTo("27") > 0 || this.homepageVersionMajor.compareTo("27") >= 0 && this.homepageVersionMinor.compareTo("") > 0 || this.homepageVersionPatch != null && this.homepageVersionMajor.compareTo("27") >= 0 && this.homepageVersionMinor.compareTo("") >= 0 && this.homepageVersionPatch.compareTo("") > 0)) {
                            display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    this.showNewVersionInfo(shell);
                                }
                            });
                        }
                        l2 = System.currentTimeMillis();
                    }
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void getServerVersionInfo() {
                Pattern pattern = Pattern.compile("MAJOR=(.*)");
                Pattern pattern2 = Pattern.compile("MINOR=(.*)");
                Pattern pattern3 = Pattern.compile("PATCH=(.*)");
                Pattern pattern4 = Pattern.compile("REVISION=(.*)");
                BufferedReader bufferedReader = null;
                try {
                    String string;
                    bufferedReader = new BufferedReader(new InputStreamReader(new URL(BARControl.URL_VERSION_FILE).openStream(), "UTF-8"));
                    while ((string = bufferedReader.readLine()) != null && !string.isEmpty()) {
                        Matcher matcher = pattern.matcher(string);
                        if (matcher.matches()) {
                            this.homepageVersionMajor = matcher.group(1);
                            continue;
                        }
                        matcher = pattern2.matcher(string);
                        if (matcher.matches()) {
                            this.homepageVersionMinor = matcher.group(1);
                            continue;
                        }
                        matcher = pattern3.matcher(string);
                        if (matcher.matches()) {
                            this.homepageVersionPatch = matcher.group(1);
                            continue;
                        }
                        matcher = pattern4.matcher(string);
                        if (!matcher.matches()) continue;
                        this.homepageVersionRevision = matcher.group(1);
                    }
                    this.homepageChangeLog.clear();
                    while ((string = bufferedReader.readLine()) != null) {
                        this.homepageChangeLog.add(string);
                    }
                    bufferedReader.close();
                    bufferedReader = null;
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {}
                }
            }

            private void showNewVersionInfo(final Shell shell) {
                String string = String.format("%s%s%s%s%s", this.homepageVersionMajor, !this.homepageVersionMinor.isEmpty() ? "." : "", this.homepageVersionMinor, this.homepageVersionPatch, this.homepageVersionRevision != null ? " (revision " + this.homepageVersionRevision + ")" : "");
                StringBuilder stringBuilder = new StringBuilder();
                for (String object2 : this.homepageChangeLog) {
                    stringBuilder.append(object2 + Text.DELIMITER);
                }
                final Shell shell2 = Dialogs.openModal(shell, "Confirmation", new double[]{1.0, 0.0}, 1.0);
                shell2.setLayout(new TableLayout(new double[]{1.0, 0.0}, 1.0));
                Composite composite = new Composite(shell2, 0);
                composite.setLayout(new TableLayout(null, new double[]{0.0, 1.0}, 4));
                Widgets.layout(composite, 0, 0, 15);
                Label label = Widgets.newImage(composite, Widgets.loadImage(shell.getDisplay(), "question.png"));
                Widgets.layout((Control)label, 0, 0, 4, 0, 0, 10);
                label = Widgets.newLabel(composite, String.format("A newer version %s of BARControl is available. You\ncan download it from the BAR homepage:\n\n%s\n\nChangeLog:", string, BARControl.URL), 16448);
                Widgets.layout((Control)label, 0, 1, 4, 0, 0, 4);
                Text text = Widgets.newStringView(composite, 2880);
                text.setText(stringBuilder.toString());
                Widgets.layout(text, 1, 1, 15, 0, 0, 4, 0, 300, 300);
                final Button button = Widgets.newCheckbox(composite, "show again");
                button.setSelection(true);
                Widgets.layout((Control)button, 2, 1, 4, 0, 0, 4);
                composite = new Composite(shell2, 0);
                composite.setLayout(new TableLayout(0.0, 1.0));
                Widgets.layout((Control)composite, 1, 0, 12, 0, 0, 4);
                Button button2 = Widgets.newButton(composite, "Open browser");
                button2.setFocus();
                Widgets.layout(button2, 0, 0, 4, 0, 0, 0, 0, -1, -1, 120, -1);
                button2.addSelectionListener(new SelectionListener(){

                    @Override
                    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    }

                    @Override
                    public void widgetSelected(SelectionEvent selectionEvent) {
                        Dialogs.close(shell2, true);
                    }
                });
                button2 = Widgets.newButton(composite, "Continue");
                Widgets.layout(button2, 0, 1, 8, 0, 0, 0, 0, -1, -1, 120, -1);
                button2.addSelectionListener(new SelectionListener(){

                    @Override
                    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    }

                    @Override
                    public void widgetSelected(SelectionEvent selectionEvent) {
                        Dialogs.close(shell2, false);
                    }
                });
                Dialogs.run(shell2, false, new DialogRunnable(){

                    @Override
                    public void done(Object object) {
                        if (((Boolean)object).booleanValue()) {
                            try {
                                if (Desktop.isDesktopSupported()) {
                                    Desktop.getDesktop().browse(new URI(BARControl.URL));
                                }
                            }
                            catch (URISyntaxException uRISyntaxException) {
                                Dialogs.error(shell, BARControl.tr("Cannot open default web browser:\n\n{0}", uRISyntaxException.getMessage()));
                            }
                            catch (IOException iOException) {
                                Dialogs.error(shell, BARControl.tr("Cannot open default web browser:\n\n{0}", BARControl.reniceIOException(iOException).getMessage()));
                            }
                            catch (Exception exception) {
                                Dialogs.error(shell, BARControl.tr("Cannot open default web browser:\n\n{0}", exception.getMessage()));
                            }
                        }
                        Settings.showNewVersionInformation = button.getSelection();
                    }
                });
            }
        };
        ((Thread)object).setDaemon(true);
        ((Thread)object).start();
    }

    private void showAbout(Shell shell) {
        Image image = Widgets.loadImage(shell.getDisplay(), "info.png");
        Image image2 = Widgets.loadImage(shell.getDisplay(), "clipboard.png");
        if (!shell.isDisposed()) {
            final Shell shell2 = Dialogs.openModal(shell, BARControl.tr("About", new Object[0]), 300, 70);
            shell2.setLayout(new TableLayout(new double[]{1.0, 0.0}, 1.0));
            Composite composite = new Composite(shell2, 0);
            composite.setLayout(new TableLayout(null, new double[]{0.0, 1.0}, 4));
            Widgets.layout(composite, 0, 0, 15);
            Label label = new Label(composite, 16384);
            label.setImage(image);
            Widgets.layout((Control)label, 0, 0, 4, 0, 0, 10);
            label = new Label(composite, 16448);
            label.setText("BAR control " + Version.STRING + ".\n\n" + BARControl.tr("Written by Torsten Rupp", new Object[0]) + "\n");
            Widgets.layout((Control)label, 0, 1, 7, 0, 0, 4);
            Button button = new Button(composite, 0x1000000);
            button.setToolTipText(BARControl.tr("Copy version info to clipboard.", new Object[0]));
            button.setImage(image2);
            Widgets.layout(button, 0, 2, 9);
            button.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    Widgets.setClipboard(clipboard, "BAR version " + Version.STRING);
                }

                @Override
                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }
            });
            composite = new Composite(shell2, 0);
            composite.setLayout(new TableLayout(0.0, 1.0));
            Widgets.layout((Control)composite, 1, 0, 12, 0, 0, 4);
            button = new Button(composite, 0x1000000);
            button.setText(BARControl.tr("Close", new Object[0]));
            Widgets.layout(button, 0, 0, 0, 0, 0, 0, 0, -1, -1, 120, -1);
            button.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    Dialogs.close(shell2);
                }

                @Override
                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }
            });
            Dialogs.run(shell2);
        }
    }

    private void createWindow() {
        shell = new Shell(display);
        shell.setText("BAR control");
        shell.setLayout(new TableLayout(1.0, 1.0));
        clipboard = new Clipboard(display);
        waitCursor = new Cursor(display, 1);
    }

    private void createTabs() {
        this.widgetTabFolder = Widgets.newTabFolder(shell);
        Widgets.layout(this.widgetTabFolder, 0, 0, 15);
        this.widgetTabFolder.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent paintEvent) {
                TabFolder tabFolder = (TabFolder)paintEvent.widget;
                GC gC = paintEvent.gc;
                if (BARServer.isTLSConnection()) {
                    Image image = BARServer.isInsecureTLSConnection() ? IMAGE_LOCK_INSECURE : IMAGE_LOCK;
                    Rectangle rectangle = image.getBounds();
                    gC.drawImage(image, tabFolder.getBounds().width - rectangle.width, rectangle.height / 2 - 2);
                }
            }
        });
        this.widgetTabFolder.addMouseTrackListener(new MouseTrackListener(){

            @Override
            public void mouseEnter(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExit(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseHover(MouseEvent mouseEvent) {
                TabFolder tabFolder = (TabFolder)mouseEvent.widget;
                if (BARServer.isTLSConnection()) {
                    if (BARControl.this.widgetTabFolderToolTip != null) {
                        BARControl.this.widgetTabFolderToolTip.dispose();
                        BARControl.this.widgetTabFolderToolTip = null;
                    }
                    Image image = BARServer.isInsecureTLSConnection() ? IMAGE_LOCK_INSECURE : IMAGE_LOCK;
                    Rectangle rectangle = image.getBounds();
                    rectangle.x = tabFolder.getBounds().width - rectangle.width;
                    rectangle.y = rectangle.height / 2 - 2;
                    if (rectangle.contains(mouseEvent.x, mouseEvent.y)) {
                        Color color = display.getSystemColor(28);
                        Color color2 = display.getSystemColor(29);
                        BARControl.this.widgetTabFolderToolTip = new Shell(shell, 540676);
                        BARControl.this.widgetTabFolderToolTip.setBackground(color2);
                        BARControl.this.widgetTabFolderToolTip.setLayout(new TableLayout(0.0, new double[]{0.0, 1.0}, 2));
                        Widgets.layout(BARControl.this.widgetTabFolderToolTip, 0, 0, 15);
                        Label label = Widgets.newLabel((Composite)BARControl.this.widgetTabFolderToolTip, BARControl.tr("Indicate if connection to BAR server is verified as secure (lock icon) or may be insecure (broken lock icon).", new Object[0]));
                        label.setForeground(color);
                        label.setBackground(color2);
                        Widgets.layout(label, 0, 0, 4);
                        Point point = display.getCursorLocation();
                        if (point.x > 16) {
                            point.x -= 16;
                        }
                        if (point.y > 16) {
                            point.y -= 16;
                        }
                        Widgets.showToolTip(BARControl.this.widgetTabFolderToolTip, point.x, point.y);
                    }
                }
            }
        });
        this.widgetTabStatus = new TabStatus(this.widgetTabFolder, 0x100000A);
        this.widgetTabJobs = new TabJobs(this.widgetTabFolder, 0x100000B);
        this.widgetTabRestore = new TabRestore(this.widgetTabFolder, 0x100000C);
        this.widgetTabStatus.setTabJobs(this.widgetTabJobs);
        this.widgetTabJobs.setTabStatus(this.widgetTabStatus);
        this.widgetTabRestore.setTabStatus(this.widgetTabStatus);
        this.widgetTabRestore.setTabJobs(this.widgetTabJobs);
        this.widgetTabStatus.startUpdate();
        this.widgetTabJobs.startUpdate();
        display.addFilter(1, new Listener(){

            @Override
            public void handleEvent(Event event) {
                switch (event.keyCode) {
                    case 0x100000A: {
                        Widgets.showTab(BARControl.this.widgetTabFolder, ((BARControl)BARControl.this).widgetTabStatus.widgetTab);
                        event.doit = false;
                        break;
                    }
                    case 0x100000B: {
                        Widgets.showTab(BARControl.this.widgetTabFolder, ((BARControl)BARControl.this).widgetTabStatus.widgetTab);
                        event.doit = false;
                        break;
                    }
                    case 0x100000C: {
                        Widgets.showTab(BARControl.this.widgetTabFolder, ((BARControl)BARControl.this).widgetTabRestore.widgetTab);
                        event.doit = false;
                        break;
                    }
                }
            }
        });
    }

    private void createMenu() {
        Menu menu = Widgets.newMenuBar(shell);
        Menu menu2 = Widgets.addMenu(menu, BARControl.tr("Program", new Object[0]));
        this.serverMenu = Widgets.addMenu(menu2, BARControl.tr("Connect", new Object[0]), BARServer.isMaster() && Settings.hasExpertRole());
        MenuItem menuItem = Widgets.addMenuItem(this.serverMenu, "\u2026", 262223);
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                BARControl.this.serverMenu.setEnabled(false);
                Settings.Server server = Settings.getLastServer();
                BARServer.TLSModes tLSModes = Settings.serverForceTLS ? BARServer.TLSModes.FORCE : (Settings.serverNoTLS ? BARServer.TLSModes.NONE : BARServer.TLSModes.TRY);
                BARControl.this.loginData = new LoginData(server != null ? server.port : 38523, server != null ? server.port : 0, tLSModes, Settings.role);
                if (BARControl.this.login(BARControl.this.loginData, true)) {
                    BARControl.this.updateServerMenu();
                    Widgets.notify(shell, 65535);
                } else if (BARControl.this.serverMenuLastSelectedItem != null) {
                    BARControl.this.serverMenuLastSelectedItem.setSelection(true);
                }
                BARControl.this.serverMenu.setEnabled(true);
            }
        });
        Widgets.addMenuItemSeparator(this.serverMenu);
        this.updateServerMenu();
        Widgets.addMenuItemSeparator(menu2, Settings.hasExpertRole());
        menuItem = Widgets.addMenuItem(menu2, BARControl.tr("Start", new Object[0]) + "\u2026", 262227, BARServer.isMaster());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Widgets.notify(((BARControl)BARControl.this).widgetTabStatus.widgetButtonStart);
            }
        });
        this.widgetTabStatus.addUpdateJobStateListener(new UpdateJobStateListener(menuItem){

            @Override
            public void handle(Widget widget, JobData jobData) {
                MenuItem menuItem = (MenuItem)widget;
                menuItem.setEnabled(jobData.state != JobData.States.RUNNING && jobData.state != JobData.States.DRY_RUNNING && jobData.state != JobData.States.WAITING);
            }
        });
        menuItem = Widgets.addMenuItem(menu2, BARControl.tr("Abort", new Object[0]) + "\u2026", 262209, BARServer.isMaster());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Widgets.notify(((BARControl)BARControl.this).widgetTabStatus.widgetButtonAbort);
            }
        });
        this.widgetTabStatus.addUpdateJobStateListener(new UpdateJobStateListener(menuItem){

            @Override
            public void handle(Widget widget, JobData jobData) {
                MenuItem menuItem = (MenuItem)widget;
                menuItem.setEnabled(jobData.state == JobData.States.WAITING || jobData.state == JobData.States.RUNNING || jobData.state == JobData.States.DRY_RUNNING);
            }
        });
        Menu menu3 = Widgets.addMenu(menu2, BARControl.tr("Pause", new Object[0]), BARServer.isMaster() && Settings.hasNormalRole());
        menuItem = Widgets.addMenuItem(menu3, BARControl.tr("10 min", new Object[0]));
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                BARControl.this.widgetTabStatus.jobPause(600L);
            }
        });
        menuItem = Widgets.addMenuItem(menu3, BARControl.tr("60 min", new Object[0]), 262224);
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                BARControl.this.widgetTabStatus.jobPause(3600L);
            }
        });
        menuItem = Widgets.addMenuItem(menu3, BARControl.tr("120 min", new Object[0]));
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                BARControl.this.widgetTabStatus.jobPause(7200L);
            }
        });
        Widgets.addMenuItemSeparator(menu3);
        menuItem = Widgets.addMenuItemCheckbox(menu3, BARControl.tr("Create operation", new Object[0]), Settings.pauseCreateFlag, true);
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuItem menuItem = (MenuItem)selectionEvent.widget;
                Settings.pauseCreateFlag = menuItem.getSelection();
                BARControl.this.widgetTabStatus.jobPause(3600L);
            }
        });
        menuItem = Widgets.addMenuItemCheckbox(menu3, BARControl.tr("Storage operation", new Object[0]), Settings.pauseStorageFlag, true);
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuItem menuItem = (MenuItem)selectionEvent.widget;
                Settings.pauseStorageFlag = menuItem.getSelection();
                BARControl.this.widgetTabStatus.jobPause(3600L);
            }
        });
        menuItem = Widgets.addMenuItemCheckbox(menu3, BARControl.tr("Restore operation", new Object[0]), Settings.pauseRestoreFlag, true);
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuItem menuItem = (MenuItem)selectionEvent.widget;
                Settings.pauseRestoreFlag = menuItem.getSelection();
                BARControl.this.widgetTabStatus.jobPause(3600L);
            }
        });
        menuItem = Widgets.addMenuItemCheckbox(menu3, BARControl.tr("Index update operation", new Object[0]), Settings.pauseIndexUpdateFlag, true);
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuItem menuItem = (MenuItem)selectionEvent.widget;
                Settings.pauseIndexUpdateFlag = menuItem.getSelection();
            }
        });
        menuItem = Widgets.addMenuItemCheckbox(menu3, BARControl.tr("Index maintenance operation", new Object[0]), Settings.pauseIndexMaintenanceFlag, true);
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuItem menuItem = (MenuItem)selectionEvent.widget;
                Settings.pauseIndexMaintenanceFlag = menuItem.getSelection();
            }
        });
        menuItem = Widgets.addMenuItem(menu2, BARControl.tr("Toggle suspend/continue", new Object[0]), 262228, BARServer.isMaster());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Widgets.notify(((BARControl)BARControl.this).widgetTabStatus.widgetButtonSuspendContinue);
            }
        });
        Widgets.addMenuItemSeparator(menu2, Settings.hasExpertRole());
        menuItem = Widgets.addMenuItem(menu2, BARControl.tr("Server settings", new Object[0]) + "\u2026", 262231, Settings.hasExpertRole());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                ServerSettings.serverSettings(shell);
            }
        });
        menuItem = Widgets.addMenuItem(menu2, BARControl.tr("Clear stored passwords on server", new Object[0]), 0, Settings.hasExpertRole());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    BARServer.executeCommand(StringParser.format("PASSWORDS_CLEAR", new Object[0]), 0);
                }
                catch (Exception exception) {
                    Dialogs.error(shell, BARControl.tr("Cannot clear passwords on server:\n\n{0}", exception.getMessage()));
                }
            }
        });
        this.masterMenuItem = Widgets.addMenuItemCheckbox(menu2, BARControl.tr("Pair master", new Object[0]) + "\u2026", Settings.hasExpertRole());
        this.masterMenuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuItem menuItem = (MenuItem)selectionEvent.widget;
                if (menuItem.getSelection()) {
                    BARControl.this.pairMaster();
                } else {
                    BARControl.this.clearMaster();
                }
            }
        });
        shell.addListener(65535, new Listener(){

            @Override
            public void handleEvent(Event event) {
                if (!BARControl.this.masterMenuItem.isDisposed()) {
                    switch (BARServer.getMode()) {
                        case MASTER: {
                            BARControl.this.masterMenuItem.setEnabled(false);
                            break;
                        }
                        case SLAVE: {
                            BARControl.this.masterMenuItem.setEnabled(true);
                        }
                    }
                }
            }
        });
        Widgets.addMenuItemSeparator(menu2);
        menu3 = Widgets.addMenu(menu2, BARControl.tr("Role", new Object[0]));
        menuItem = Widgets.addMenuItemRadio(menu3, BARControl.tr("Basic", new Object[0]));
        menuItem.setSelection(Settings.role == Roles.BASIC);
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuItem menuItem = (MenuItem)selectionEvent.widget;
                if (menuItem.getSelection()) {
                    Settings.role = Roles.BASIC;
                    shell.dispose();
                }
            }
        });
        menuItem = Widgets.addMenuItemRadio(menu3, BARControl.tr("Normal", new Object[0]));
        menuItem.setSelection(Settings.role == Roles.NORMAL);
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuItem menuItem = (MenuItem)selectionEvent.widget;
                if (menuItem.getSelection()) {
                    Settings.role = Roles.NORMAL;
                    shell.dispose();
                }
            }
        });
        menuItem = Widgets.addMenuItemRadio(menu3, BARControl.tr("Expert", new Object[0]));
        menuItem.setSelection(Settings.role == Roles.EXPERT);
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuItem menuItem = (MenuItem)selectionEvent.widget;
                if (menuItem.getSelection()) {
                    Settings.role = Roles.EXPERT;
                    shell.dispose();
                }
            }
        });
        menuItem = Widgets.addMenuItem(menu2, BARControl.tr("Set additional certificate authority (CA)", new Object[0]) + "\u2026", 0);
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = Dialogs.file(shell, Dialogs.FileDialogTypes.OPEN, BARControl.tr("Select certificate authority (CA) file", new Object[0]), Settings.serverCAFileName, new String[]{BARControl.tr("Certificate files PEM", new Object[0]), "*.pem", BARControl.tr("Certificate files", new Object[0]), "*.crt", BARControl.tr("All files", new Object[0]), ALL_FILE_EXTENSION}, "*.pem", 0, listDirectory);
                if (string != null) {
                    Settings.serverCAFileName = string;
                    if (Dialogs.confirm(shell, BARControl.tr("Reconnect to server with new certificate authority?", new Object[0]))) {
                        boolean bl = false;
                        String string2 = null;
                        if (!bl) {
                            try {
                                BARControl.this.reconnect(BARServer.TLSModes.FORCE, false);
                                Settings.serverNoTLS = false;
                                Settings.serverForceTLS = true;
                                Settings.serverInsecureTLS = false;
                                bl = true;
                            }
                            catch (ConnectionError connectionError) {
                                string2 = connectionError.getMessage();
                            }
                            catch (CommunicationError communicationError) {
                                string2 = communicationError.getMessage();
                            }
                        }
                        if (!bl) {
                            switch (Dialogs.select(shell, BARControl.tr("Reconnection fail", new Object[0]), IMAGE_ERROR, string2 != null ? string2 : BARControl.tr("Reconnect with new certificate authority fail", new Object[0]), new String[]{BARControl.tr("Try with insecure TLS (SSL)", new Object[0]), BARControl.tr("Cancel", new Object[0])}, 0)) {
                                case 0: {
                                    try {
                                        BARControl.this.reconnect(BARServer.TLSModes.FORCE, true);
                                        Settings.serverNoTLS = false;
                                        Settings.serverForceTLS = true;
                                        Settings.serverInsecureTLS = true;
                                        bl = true;
                                    }
                                    catch (ConnectionError connectionError) {
                                        string2 = connectionError.getMessage();
                                    }
                                    catch (CommunicationError communicationError) {
                                        string2 = communicationError.getMessage();
                                    }
                                    break;
                                }
                                case 1: {
                                    return;
                                }
                            }
                        }
                        if (!bl) {
                            Dialogs.error(shell, string2 != null ? string2 : BARControl.tr("Reconnect with new certificate authority fail", new Object[0]));
                        }
                    }
                }
            }
        });
        Widgets.addMenuItemSeparator(menu2);
        menuItem = Widgets.addMenuItem(menu2, BARControl.tr("Quit", new Object[0]), 262225);
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Widgets.notify(((BARControl)BARControl.this).widgetTabStatus.widgetButtonQuit);
            }
        });
        menu2 = Widgets.addMenu(menu, BARControl.tr("Help", new Object[0]));
        menuItem = Widgets.addMenuItem(menu2, BARControl.tr("About", new Object[0]) + "\u2026");
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                BARControl.this.showAbout(shell);
            }
        });
        if (Settings.debugLevel > 0) {
            menu2 = Widgets.addMenu(menu, "Debug");
            menuItem = Widgets.addMenuItem(menu2, "Print debug statistics");
            menuItem.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    MenuItem menuItem = (MenuItem)selectionEvent.widget;
                    try {
                        BARServer.executeCommand(StringParser.format("DEBUG_PRINT_STATISTICS", new Object[0]), 0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            menuItem = Widgets.addMenuItem(menu2, "Print debug memory info");
            menuItem.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    MenuItem menuItem = (MenuItem)selectionEvent.widget;
                    BusyDialog busyDialog = new BusyDialog(shell, BARControl.tr("Print debug memory dump", new Object[0]), 500, 100, 9);
                    Background.run(new BackgroundRunnable(new Object[]{busyDialog}){

                        public void run(final BusyDialog busyDialog) {
                            try {
                                BARServer.executeCommand(StringParser.format("DEBUG_PRINT_MEMORY_INFO", new Object[0]), 1, new Command.ResultHandler(){

                                    @Override
                                    public void handle(int n, ValueMap valueMap) throws BARException {
                                        String string = valueMap.getString("type");
                                        long l = valueMap.getLong("n");
                                        long l2 = valueMap.getLong("count");
                                        busyDialog.updateText(String.format("Printing '%s' info...", string));
                                        if (l2 > 0L) {
                                            busyDialog.updateProgressBar((double)l * 100.0 / (double)l2);
                                        }
                                        if (busyDialog.isAborted()) {
                                            this.abort();
                                        }
                                    }
                                });
                                display.syncExec(new Runnable(busyDialog){
                                    final /* synthetic */ BusyDialog val$busyDialog;
                                    {
                                        this.val$busyDialog = busyDialog;
                                    }

                                    @Override
                                    public void run() {
                                        this.val$busyDialog.close();
                                    }
                                });
                            }
                            catch (Exception exception) {
                                display.syncExec(new /* invalid duplicate definition of identical inner class */);
                            }
                            catch (Throwable throwable) {
                                display.syncExec(new /* invalid duplicate definition of identical inner class */);
                                throw throwable;
                            }
                        }
                    });
                }
            });
            menuItem = Widgets.addMenuItem(menu2, "Dump debug memory info");
            menuItem.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    MenuItem menuItem = (MenuItem)selectionEvent.widget;
                    BusyDialog busyDialog = new BusyDialog(shell, BARControl.tr("Store debug memory dump", new Object[0]), 500, 100, 137);
                    Background.run(new BackgroundRunnable(new Object[]{busyDialog}){

                        public void run(final BusyDialog busyDialog) {
                            try {
                                BARServer.executeCommand(StringParser.format("DEBUG_DUMP_MEMORY_INFO", new Object[0]), 1, new Command.ResultHandler(){

                                    @Override
                                    public void handle(int n, ValueMap valueMap) throws BARException {
                                        String string = valueMap.getString("type");
                                        long l = valueMap.getLong("n");
                                        long l2 = valueMap.getLong("count");
                                        busyDialog.updateText(String.format("Dumping '%s' info...", string));
                                        if (l2 > 0L) {
                                            busyDialog.updateProgressBar((double)l * 100.0 / (double)l2);
                                        }
                                        if (busyDialog.isAborted()) {
                                            this.abort();
                                        }
                                    }
                                });
                                display.syncExec(new Runnable(busyDialog){
                                    final /* synthetic */ BusyDialog val$busyDialog;
                                    {
                                        this.val$busyDialog = busyDialog;
                                    }

                                    @Override
                                    public void run() {
                                        this.val$busyDialog.close();
                                    }
                                });
                            }
                            catch (Exception exception) {
                                display.syncExec(new /* invalid duplicate definition of identical inner class */);
                            }
                            catch (Throwable throwable) {
                                display.syncExec(new /* invalid duplicate definition of identical inner class */);
                                throw throwable;
                            }
                        }
                    });
                }
            });
            menuItem = Widgets.addMenuItem(menu2, "Quit server");
            menuItem.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    try {
                        BARServer.executeCommand(StringParser.format("QUIT", new Object[0]), 1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        this.updateServerMenu();
    }

    private int getTerminalWidth() {
        int n = 78;
        try {
            n = TerminalFactory.get().getWidth();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return n;
    }

    private boolean tryReconnect(String string) {
        boolean bl = false;
        Object var3_3 = null;
        Object var4_4 = null;
        if (Dialogs.confirmError(new Shell(), BARControl.tr("Connection lost", new Object[0]), string, BARControl.tr("Try again", new Object[0]), BARControl.tr("Cancel", new Object[0]))) {
            bl = this.login(this.loginData, false);
        }
        if (bl) {
            int n = this.widgetTabFolder.getSelectionIndex();
            if (n == 0) {
                this.widgetTabFolder.setSelection(1);
            } else {
                this.widgetTabFolder.setSelection(0);
            }
            this.widgetTabFolder.setSelection(n);
            Widgets.notify(shell, 65535);
        } else {
            this.quitFlag = true;
        }
        return bl;
    }

    private void run() {
        JobData jobData;
        if (Settings.geometry.width < 0) {
            Settings.geometry.width = 840;
        }
        if (Settings.geometry.height < 0) {
            Settings.geometry.height = 600 + 5 * (Widgets.getTextHeight(shell) + 4);
        }
        shell.setSize(Settings.geometry.width, Settings.geometry.height);
        if (Settings.geometry.x >= 0 && Settings.geometry.y >= 0) {
            shell.setLocation(Settings.geometry.x, Settings.geometry.y);
        }
        shell.open();
        shell.setSize(Settings.geometry.width, Settings.geometry.height);
        if (Settings.geometry.x >= 0 && Settings.geometry.y >= 0) {
            shell.setLocation(Settings.geometry.x, Settings.geometry.y);
        }
        shell.setText("BAR control " + (Object)((Object)BARServer.getMode()) + ": " + BARServer.getInfo());
        shell.addListener(65535, new Listener(){

            @Override
            public void handleEvent(Event event) {
                Shell shell = (Shell)event.widget;
                if (!shell.isDisposed()) {
                    shell.setText("BAR control " + (Object)((Object)BARServer.getMode()) + ": " + BARServer.getInfo());
                    BARControl.this.updateMaster();
                }
            }
        });
        shell.addListener(21, new Listener(){

            @Override
            public void handleEvent(Event event) {
                BARControl.this.quitFlag = true;
                shell.dispose();
            }
        });
        if (Settings.selectedJobName != null && (jobData = this.widgetTabStatus.getJobByName(Settings.selectedJobName)) != null) {
            Widgets.notify((Widget)shell, 65539, jobData.uuid);
        }
        boolean bl = true;
        while (!shell.isDisposed() && bl) {
            try {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            catch (ConnectionError connectionError) {
                bl = this.tryReconnect(connectionError.getMessage());
            }
            catch (SWTException sWTException) {
                Throwable throwable;
                for (throwable = sWTException.getCause(); throwable != null && !(throwable instanceof ConnectionError); throwable = throwable.getCause()) {
                }
                if (throwable != null) {
                    bl = this.tryReconnect(sWTException.getCause().getMessage());
                    continue;
                }
                BARControl.printInternalError(sWTException);
                BARControl.showFatalError(sWTException);
                System.exit(127);
            }
            catch (AssertionError assertionError) {
                BARControl.printInternalError((Throwable)((Object)assertionError));
                BARControl.showFatalError((Throwable)((Object)assertionError));
                System.exit(127);
            }
            catch (InternalError internalError) {
                BARControl.printInternalError(internalError);
                BARControl.showFatalError(internalError);
                System.exit(127);
            }
            catch (Throwable throwable) {
                BARControl.printInternalError(throwable);
                BARControl.showFatalError(throwable);
                System.exit(127);
            }
        }
    }

    private boolean getLoginData(final LoginData loginData, final boolean bl) {
        Button button;
        Button button2;
        Button button3;
        final Shell shell = Dialogs.openModal(new Shell(), BARControl.tr("Login BAR server", new Object[0]), 250, -1);
        final Settings.Server[] serverArray = Settings.servers.toArray(new Settings.Server[Settings.servers.size()]);
        Arrays.sort(serverArray, new Comparator<Settings.Server>(){

            @Override
            public int compare(Settings.Server server, Settings.Server server2) {
                return server.getData().compareTo(server2.getData());
            }
        });
        String[] stringArray = new String[serverArray.length];
        for (int i = 0; i < serverArray.length; ++i) {
            stringArray[i] = serverArray[i].getData();
        }
        Composite composite = new Composite(shell, 0);
        composite.setLayout(new TableLayout(null, new double[]{0.0, 1.0}, 2));
        Widgets.layout(composite, 0, 0, 12);
        Label label = new Label(composite, 16384);
        label.setText(BARControl.tr("Server", new Object[0]) + ":");
        Widgets.layout(label, 0, 0, 4);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(new TableLayout(null, new double[]{1.0, 0.0, 0.0, 0.0}, 2));
        Widgets.layout(composite2, 0, 1, 12);
        final Combo combo = Widgets.newCombo(composite2, 18432);
        combo.setItems(stringArray);
        if (loginData.name != null) {
            combo.setText(loginData.name);
        }
        Widgets.layout(combo, 0, 0, 12);
        final Spinner spinner = Widgets.newSpinner(composite2, 133120);
        spinner.setMinimum(0);
        spinner.setMaximum(65535);
        spinner.setSelection(loginData.port);
        Widgets.layout(spinner, 0, 1, 4, 0, 0, 0, 0, 100, -1);
        label = new Label(composite2, 16384);
        label.setText(BARControl.tr("TLS", new Object[0]));
        Widgets.layout(label, 0, 2, 4);
        final Combo combo2 = Widgets.newOptionMenu(composite2);
        Widgets.setOptionMenuItems(combo2, new Object[]{BARControl.tr("none", new Object[0]), BARServer.TLSModes.NONE, BARControl.tr("try", new Object[0]), BARServer.TLSModes.TRY, BARControl.tr("force", new Object[0]), BARServer.TLSModes.FORCE});
        Widgets.setSelectedOptionMenuItem(combo2, loginData.tlsMode);
        Widgets.layout(combo2, 0, 3, 4);
        label = Widgets.newLabel(composite);
        label.setText(BARControl.tr("Password", new Object[0]) + ":");
        Widgets.layout(label, 1, 0, 4);
        final Text text = Widgets.newPassword(composite);
        if (loginData.password != null && !loginData.password.isEmpty()) {
            text.setText(loginData.password);
        }
        Widgets.layout(text, 1, 1, 12);
        if (bl) {
            label = Widgets.newLabel(composite);
            label.setText(BARControl.tr("Role", new Object[0]) + ":");
            Widgets.layout(label, 2, 0, 4);
            composite2 = new Composite(composite, 0);
            composite2.setLayout(new TableLayout(null, 0.0, 2));
            Widgets.layout(composite2, 2, 1, 12);
            button3 = Widgets.newRadio(composite2, BARControl.tr("Basic", new Object[0]));
            button3.setSelection(loginData.role == Roles.BASIC);
            Widgets.layout(button3, 0, 0, 4);
            button2 = Widgets.newRadio(composite2, BARControl.tr("Normal", new Object[0]));
            button2.setSelection(loginData.role == Roles.NORMAL);
            Widgets.layout(button2, 0, 1, 4);
            button = Widgets.newRadio(composite2, BARControl.tr("Expert", new Object[0]));
            button.setSelection(loginData.role == Roles.EXPERT);
            Widgets.layout(button, 0, 2, 4);
        } else {
            button3 = null;
            button2 = null;
            button = null;
        }
        composite = new Composite(shell, 0);
        composite.setLayout(new TableLayout(0.0, 1.0));
        Widgets.layout(composite, 1, 0, 12);
        final Button button4 = Widgets.newButton(composite);
        button4.setText(BARControl.tr("Login", new Object[0]));
        Widgets.layout(button4, 0, 0, 4, 0, 0, 0, 0, 80, -1);
        button4.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                loginData.name = combo.getText();
                loginData.port = spinner.getSelection();
                loginData.tlsMode = Widgets.getSelectedOptionMenuItem(combo2, BARServer.TLSModes.TRY);
                loginData.password = text.getText();
                if (bl) {
                    loginData.role = button3.getSelection() ? Roles.BASIC : (button2.getSelection() ? Roles.NORMAL : (button.getSelection() ? Roles.EXPERT : Roles.BASIC));
                }
                Dialogs.close(shell, true);
            }
        });
        Button button5 = Widgets.newButton(composite);
        button5.setText(BARControl.tr("Cancel", new Object[0]));
        Widgets.layout(button5, 0, 1, 8, 0, 0, 0, 0, 80, -1);
        button5.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                Dialogs.close(shell, false);
            }
        });
        combo.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                text.forceFocus();
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Settings.Server server = serverArray[combo.getSelectionIndex()];
                combo.setText(server.name != null ? server.name : "");
                spinner.setSelection(server.port);
                text.setText(server.password != null && !server.password.isEmpty() ? server.password : "");
            }
        });
        text.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                button4.forceFocus();
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
            }
        });
        Widgets.setNextFocus(combo, spinner, text, button4);
        if (loginData.name != null && loginData.name.length() != 0) {
            text.forceFocus();
        } else {
            combo.forceFocus();
        }
        Boolean bl2 = (Boolean)Dialogs.run(shell);
        if (bl2 != null && bl2.booleanValue() && (loginData.port != 0 || loginData.tlsPort != 0)) {
            Settings.addServer(loginData.name, loginData.port != 0 ? loginData.port : loginData.tlsPort, loginData.password);
            Settings.save();
            return true;
        }
        return false;
    }

    private void updateServerMenu() {
        while (this.serverMenu.getItemCount() > 2) {
            this.serverMenu.getItem(2).dispose();
        }
        Settings.Server[] serverArray = Settings.servers.toArray(new Settings.Server[Settings.servers.size()]);
        Arrays.sort(serverArray, new Comparator<Settings.Server>(){

            @Override
            public int compare(Settings.Server server, Settings.Server server2) {
                return server.getData().compareTo(server2.getData());
            }
        });
        for (Settings.Server server : serverArray) {
            MenuItem menuItem = Widgets.addMenuItemRadio(this.serverMenu, server.name + ":" + server.port);
            menuItem.setData(server);
            menuItem.setSelection(server.name.equals(BARServer.getName()) && server.port == BARServer.getPort());
            menuItem.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    MenuItem menuItem = (MenuItem)selectionEvent.widget;
                    Settings.Server server = (Settings.Server)menuItem.getData();
                    if (menuItem.getSelection()) {
                        BARServer.TLSModes tLSModes = Settings.serverForceTLS ? BARServer.TLSModes.FORCE : (Settings.serverNoTLS ? BARServer.TLSModes.NONE : BARServer.TLSModes.TRY);
                        BARControl.this.loginData = new LoginData(!server.name.isEmpty() ? server.name : "localhost", server.port != 0 ? server.port : 38523, server.port != 0 ? server.port : 0, tLSModes, !server.password.isEmpty() ? server.password : "", Settings.role);
                        if (BARControl.this.login(BARControl.this.loginData, false)) {
                            BARControl.this.updateServerMenu();
                            Widgets.notify(shell, 65535);
                        } else if (BARControl.this.serverMenuLastSelectedItem != null) {
                            menuItem.setSelection(false);
                            BARControl.this.serverMenuLastSelectedItem.setSelection(true);
                        }
                    } else {
                        BARControl.this.serverMenuLastSelectedItem = menuItem;
                    }
                }
            });
        }
    }

    private void updateMaster() {
        String string = "";
        try {
            ValueMap valueMap = new ValueMap();
            BARServer.executeCommand(StringParser.format("MASTER_GET", new Object[0]), 0, valueMap);
            assert (valueMap.size() > 0);
            string = valueMap.getString("name");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.masterMenuItem.isDisposed()) {
            if (!string.isEmpty()) {
                this.masterMenuItem.setText(BARControl.tr("Master", new Object[0]) + ": " + string);
                this.masterMenuItem.setSelection(true);
            } else {
                this.masterMenuItem.setText(BARControl.tr("Pair master", new Object[0]) + "\u2026");
                this.masterMenuItem.setSelection(false);
            }
        }
    }

    private boolean pairMaster() {
        class Data {
            String masterName = "";
            int restTime = 0;

            Data() {
            }
        }
        final Data data = new Data();
        final Shell shell = Dialogs.openModal(new Shell(), BARControl.tr("Pair new master", new Object[0]), 250, -1);
        final BackgroundRunnable[] backgroundRunnableArray = new BackgroundRunnable[]{null};
        Composite composite = Widgets.newComposite(shell);
        composite.setLayout(new TableLayout(null, new double[]{0.0, 1.0}, 2));
        Widgets.layout(composite, 0, 0, 12);
        Label label = Widgets.newLabel(composite);
        label.setText(BARControl.tr("Wait for pairing", new Object[0]) + ":");
        Widgets.layout(label, 0, 0, 4);
        ProgressBar progressBar = new ProgressBar(composite);
        Widgets.layout(progressBar, 0, 1, 12);
        label = Widgets.newLabel(composite);
        label.setText(BARControl.tr("Master", new Object[0]) + ":");
        label.setLayoutData(new TableLayoutData(1, 0, 4));
        Widgets.layout(label, 1, 0, 4);
        final Label label2 = Widgets.newView(composite);
        Widgets.layout(label2, 1, 1, 12);
        composite = Widgets.newComposite(shell);
        composite.setLayout(new TableLayout(0.0, 1.0));
        Widgets.layout(composite, 1, 0, 12);
        final Button button = Widgets.newButton(composite);
        button.setText(BARControl.tr("OK", new Object[0]));
        button.setEnabled(false);
        Widgets.layout(button, 0, 0, 4, 0, 0, 0, 0, 100, -1);
        button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    BARServer.executeCommand(StringParser.format("MASTER_PAIRING_STOP pair=yes", new Object[0]), 1);
                }
                catch (BARException bARException) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Dialogs.close(shell, false);
                            Dialogs.error(shell, BARControl.tr("Cannot set new master:\n\n{0}", bARException.getMessage()));
                        }
                    });
                    return;
                }
                catch (IOException iOException) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Dialogs.close(shell, false);
                            Dialogs.error(shell, BARControl.tr("Cannot set new master:\n\n{0}", iOException.getMessage()));
                        }
                    });
                    return;
                }
                Dialogs.close(shell, true);
            }
        });
        final Button button2 = Widgets.newButton(composite);
        button2.setText(BARControl.tr("Restart", new Object[0]));
        button2.setEnabled(false);
        Widgets.layout(button2, 0, 1, 0, 0, 0, 0, 0, 100, -1);
        button2.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                button.setEnabled(false);
                button2.setEnabled(false);
                try {
                    BARServer.executeCommand(StringParser.format("MASTER_PAIRING_START", new Object[0]), 1);
                }
                catch (BARException bARException) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Dialogs.close(shell, false);
                            Dialogs.error(shell, BARControl.tr("Cannot restart pairing master:\n\n{0}", bARException.getMessage()));
                        }
                    });
                    return;
                }
                catch (IOException iOException) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Dialogs.close(shell, false);
                            Dialogs.error(shell, BARControl.tr("Cannot restart pairing master:\n\n{0}", iOException.getMessage()));
                        }
                    });
                    return;
                }
                Background.run(backgroundRunnableArray[0]);
            }
        });
        Button button3 = Widgets.newButton(composite);
        button3.setText(BARControl.tr("Cancel", new Object[0]));
        Widgets.layout(button3, 0, 2, 8, 0, 0, 0, 0, 100, -1);
        button3.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                backgroundRunnableArray[0].abort();
                try {
                    BARServer.executeCommand(StringParser.format("MASTER_PAIRING_STOP pair=no", new Object[0]), 1);
                }
                catch (BARException bARException) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Dialogs.close(shell, false);
                            Dialogs.error(shell, BARControl.tr("Cannot stop pairing master:\n\n{0}", bARException.getMessage()));
                        }
                    });
                    return;
                }
                catch (IOException iOException) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Dialogs.close(shell, false);
                            Dialogs.error(shell, BARControl.tr("Cannot stop pairing master:\n\n{0}", iOException.getMessage()));
                        }
                    });
                    return;
                }
                Dialogs.close(shell, false);
            }
        });
        backgroundRunnableArray[0] = new BackgroundRunnable(new Object[]{shell, progressBar}){
            private final boolean[] abortFlag;
            {
                super(objectArray);
                this.abortFlag = new boolean[]{false};
            }

            public void run(Shell shell, final ProgressBar progressBar) {
                try {
                    final long[] lArray = new long[]{0L};
                    final long[] lArray2 = new long[]{0L};
                    do {
                        BARServer.executeCommand(StringParser.format("MASTER_PAIRING_STATUS", new Object[0]), 1, new Command.Handler(){

                            @Override
                            public void handle(int n, String string, ValueMap valueMap) {
                                data.masterName = valueMap.getString("name");
                                lArray[0] = valueMap.getInt("restTime");
                                lArray2[0] = valueMap.getInt("totalTime");
                                display.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (!progressBar.isDisposed()) {
                                            progressBar.setRange(0.0, lArray2[0]);
                                            progressBar.setSelection("%.0fs", lArray[0]);
                                            label2.setText(data.masterName);
                                            if (!data.masterName.isEmpty()) {
                                                button.setEnabled(true);
                                            }
                                        } else {
                                            this.abort();
                                        }
                                    }
                                });
                            }
                        });
                        if (!data.masterName.isEmpty() || lArray[0] <= 0L || this.abortFlag[0]) continue;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    } while (data.masterName.isEmpty() && lArray[0] > 0L && !this.abortFlag[0]);
                }
                catch (BARException bARException) {
                    BARControl.printStackTrace(bARException);
                    return;
                }
                catch (IOException iOException) {
                    BARControl.printStackTrace(iOException);
                    return;
                }
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!button2.isDisposed()) {
                            button2.setEnabled(true);
                        }
                    }
                });
            }

            @Override
            public void abort() {
                this.abortFlag[0] = true;
            }
        };
        try {
            BARServer.executeCommand(StringParser.format("MASTER_PAIRING_START", new Object[0]), 1);
        }
        catch (BARException bARException) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    Dialogs.error(shell, BARControl.tr("Cannot start pairing master:\n\n{0}", bARException.getMessage()));
                }
            });
            return false;
        }
        catch (IOException iOException) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    Dialogs.error(shell, BARControl.tr("Cannot start pairing master:\n\n{0}", iOException.getMessage()));
                }
            });
            return false;
        }
        Background.run(backgroundRunnableArray[0]);
        Boolean bl = (Boolean)Dialogs.run(shell);
        this.updateMaster();
        return bl != null ? bl : false;
    }

    private boolean clearMaster() {
        try {
            BARServer.executeCommand(StringParser.format("MASTER_CLEAR", new Object[0]), 0);
            this.updateMaster();
            return true;
        }
        catch (Exception exception) {
            Dialogs.error(shell, BARControl.tr("Cannot clear master:\n\n{0}", exception.getMessage()));
            return false;
        }
    }

    private boolean login(LoginData loginData, boolean bl) {
        boolean bl2;
        boolean bl3 = false;
        String string = null;
        String[] stringArray = null;
        if (bl && !this.getLoginData(loginData, true)) {
            return false;
        }
        do {
            bl2 = true;
            if (!bl3) {
                try {
                    this.connect(loginData.name, loginData.port, loginData.tlsPort, Settings.serverCAFileName, Settings.serverKeystoreFileName, loginData.tlsMode, Settings.serverInsecureTLS, loginData.password);
                    bl3 = true;
                }
                catch (ConnectionError connectionError) {
                    string = connectionError.getMessage();
                    stringArray = connectionError.getExtendedMessage();
                }
                catch (CommunicationError communicationError) {
                    string = communicationError.getMessage();
                    stringArray = communicationError.getExtendedMessage();
                }
            }
            if (!bl3 && loginData.tlsMode == BARServer.TLSModes.FORCE && loginData.tlsMode == BARServer.TLSModes.FORCE) {
                if (!Settings.serverInsecureTLS) {
                    switch (Dialogs.select(new Shell(), BARControl.tr("Connection fail", new Object[0]), IMAGE_ERROR, BARControl.tr("Certificate:", new Object[0]), stringArray, string != null ? string : BARControl.tr("Connection fail", new Object[0]), new String[]{BARControl.tr("Try with insecure TLS (SSL)", new Object[0]), BARControl.tr("Try without TLS (SSL)", new Object[0]), BARControl.tr("Cancel", new Object[0])}, 0)) {
                        case 0: {
                            string = null;
                            stringArray = null;
                            try {
                                BARServer.connect(loginData.name, loginData.port, loginData.tlsPort, null, null, loginData.tlsMode, true, loginData.password);
                                bl3 = true;
                            }
                            catch (ConnectionError connectionError) {
                                string = connectionError.getMessage();
                                stringArray = connectionError.getExtendedMessage();
                            }
                            catch (CommunicationError communicationError) {
                                string = communicationError.getMessage();
                                stringArray = communicationError.getExtendedMessage();
                            }
                            break;
                        }
                        case 1: {
                            string = null;
                            stringArray = null;
                            try {
                                BARServer.connect(loginData.name, loginData.port, loginData.tlsPort, null, null, BARServer.TLSModes.NONE, false, loginData.password);
                                bl3 = true;
                            }
                            catch (ConnectionError connectionError) {
                                string = connectionError.getMessage();
                            }
                            catch (CommunicationError communicationError) {
                                string = communicationError.getMessage();
                            }
                            break;
                        }
                        case 2: {
                            bl2 = false;
                        }
                    }
                } else {
                    switch (Dialogs.select(new Shell(), BARControl.tr("Connection fail", new Object[0]), IMAGE_ERROR, string != null ? string : BARControl.tr("Connection fail", new Object[0]), new String[]{BARControl.tr("Try without TLS (SSL)", new Object[0]), BARControl.tr("Cancel", new Object[0])}, 0)) {
                        case 0: {
                            string = null;
                            stringArray = null;
                            try {
                                BARServer.connect(loginData.name, loginData.port, loginData.tlsPort, null, null, BARServer.TLSModes.NONE, false, loginData.password);
                                bl3 = true;
                            }
                            catch (ConnectionError connectionError) {
                                string = connectionError.getMessage();
                            }
                            catch (CommunicationError communicationError) {
                                string = communicationError.getMessage();
                            }
                            break;
                        }
                        case 1: {
                            bl2 = false;
                        }
                    }
                }
            }
            if (bl3 || !bl2) continue;
            Dialogs.error(new Shell(), stringArray, string != null ? string : BARControl.tr("Connection fail", new Object[0]));
            if (!this.getLoginData(loginData, true)) break;
            if (loginData.port != 0 || loginData.tlsPort != 0) continue;
            throw new Error(BARControl.tr("Cannot connect to server. No server ports specified!", new Object[0]));
        } while (!bl3 && bl2);
        if (bl3) {
            if (!(loginData.tlsMode != BARServer.TLSModes.TRY || BARServer.isTLSConnection() && BARServer.isMatchCommonName())) {
                String string2 = BARServer.isExpiredCertificate() ? BARControl.tr("Established a none-TLS connection only. Certificate is expired.\nTransmitted data may be vulnerable!", new Object[0]) : (!BARServer.isMatchCommonName() ? BARControl.tr("Name in certificate do not match. TLS connection may be vulnerable!", new Object[0]) : BARControl.tr("Established a none-TLS connection only.\nTransmitted data may be vulnerable!", new Object[0]));
                Dialogs.warning(new Shell(), Dialogs.booleanFieldUpdater(Settings.class, "showNoneTLSWarning"), string2, new Object[0]);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    BARControl(String[] stringArray) {
        block136: {
            this.serverMenuLastSelectedItem = null;
            this.widgetTabFolderToolTip = null;
            this.quitFlag = false;
            final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Thread.currentThread().setName("BARControl");
            i18n = I18nFactory.getI18n(this.getClass(), "app.i18n.Messages", Locale.getDefault(), 1);
            Dialogs.init(i18n);
            BusyDialog.init(i18n);
            try {
                this.parseArguments(stringArray);
                Settings.load();
                this.parseArguments(stringArray);
                Settings.Server server = null;
                if (Settings.serverName != null) {
                    server = Settings.getLastServer().clone();
                    server.name = Settings.serverName;
                    if (Settings.serverPort != -1) {
                        server.port = Settings.serverPort;
                    }
                    Settings.addServer(server);
                } else if (Settings.serverPort != -1) {
                    server = Settings.getLastServer().clone();
                    server.port = Settings.serverPort;
                    Settings.addServer(server);
                } else {
                    server = Settings.getLastServer();
                }
                BARServer.TLSModes tLSModes = BARServer.TLSModes.TRY;
                if (Settings.serverForceTLS) {
                    tLSModes = BARServer.TLSModes.FORCE;
                }
                if (Settings.serverNoTLS) {
                    tLSModes = BARServer.TLSModes.NONE;
                }
                this.loginData = new LoginData(server != null ? server.name : "localhost", server != null ? server.port : 38523, server != null ? server.port : 0, tLSModes, server != null ? server.password : "", Settings.role);
                if (Settings.serverName != null) {
                    this.loginData.name = Settings.serverName;
                }
                if (Settings.serverPort != -1) {
                    this.loginData.port = Settings.serverPort;
                }
                if (Settings.serverTLSPort != -1) {
                    this.loginData.tlsPort = Settings.serverTLSPort;
                }
                if (Settings.serverPassword != null) {
                    this.loginData.password = Settings.serverPassword;
                }
                if (Settings.pairMasterFlag || !Settings.runJobNames.isEmpty() || Settings.abortJobName != null || Settings.pauseTime > 0 || Settings.maintenanceTime > 0 || Settings.pingFlag || Settings.suspendFlag || Settings.continueFlag || Settings.listJobsFlag || Settings.listSchedulesFlag || Settings.infoJobName != null || Settings.indexDatabaseInfo || Settings.indexDatabaseAddStorageName != null || Settings.indexDatabaseRemoveStorageName != null || Settings.indexDatabaseRefreshStorageName != null || Settings.indexDatabaseEntitiesListName != null || Settings.indexDatabaseStoragesListName != null || Settings.indexDatabaseEntriesListName != null || Settings.indexDatabaseHistoryList || Settings.restoreStorageName != null || Settings.debugQuitServerFlag) {
                    Object object;
                    Object object3;
                    try {
                        this.connect(this.loginData.name, this.loginData.port, this.loginData.tlsPort, Settings.serverCAFileName, Settings.serverKeystoreFileName, this.loginData.tlsMode, Settings.serverInsecureTLS, this.loginData.password);
                    }
                    catch (ConnectionError connectionError) {
                        BARControl.printError(BARControl.tr("cannot connect to server (error: {0})", connectionError.getMessage()), new Object[0]);
                        System.exit(1);
                    }
                    if (!(this.loginData.tlsMode != BARServer.TLSModes.TRY || BARServer.isTLSConnection() && BARServer.isMatchCommonName())) {
                        object3 = BARServer.isExpiredCertificate() ? BARControl.tr("Established a none-TLS connection only. Certificate is expired.\nTransmitted data may be vulnerable!", new Object[0]) : (!BARServer.isMatchCommonName() ? BARControl.tr("Name in certificate do not match. TLS connection may be vulnerable!", new Object[0]) : BARControl.tr("Established a none-TLS connection only.\nTransmitted data may be vulnerable!", new Object[0]));
                        BARControl.printWarning((String)object3, new Object[0]);
                    }
                    if (Settings.pairMasterFlag) {
                        System.out.print(BARControl.tr("Wait for pairing new master", new Object[0]) + "...    ");
                        try {
                            object3 = new String[]{""};
                            long[] object22 = new long[]{0L};
                            object = new long[]{0L};
                            BARServer.executeCommand(StringParser.format("MASTER_PAIRING_START", new Object[0]), 1);
                            do {
                                BARServer.executeCommand(StringParser.format("MASTER_PAIRING_STATUS", new Object[0]), 1, new Command.Handler((String[])object3, object22, (long[])object){
                                    final /* synthetic */ String[] val$masterName;
                                    final /* synthetic */ long[] val$restTime;
                                    final /* synthetic */ long[] val$totalTime;
                                    {
                                        this.val$masterName = stringArray;
                                        this.val$restTime = lArray;
                                        this.val$totalTime = lArray2;
                                    }

                                    @Override
                                    public void handle(int n, String string, ValueMap valueMap) {
                                        this.val$masterName[0] = valueMap.getString("name");
                                        this.val$restTime[0] = valueMap.getInt("restTime");
                                        this.val$totalTime[0] = valueMap.getInt("totalTime");
                                        System.out.print(String.format("\b\b\b\b%3ds", new Object[]{this.val$restTime}));
                                    }
                                });
                                if (!object3[0].isEmpty() || object22[0] <= 0L) continue;
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            } while (object3[0].isEmpty() && object22[0] > 0L);
                            System.out.print("\b\b\b\b");
                            BARServer.executeCommand(StringParser.format("MASTER_PAIRING_STOP pair=%y", !((String)object3[0]).isEmpty()), 1);
                            if (!((String)object3[0]).isEmpty()) {
                                System.out.println(String.format(BARControl.tr("''{0}'' - OK", object3[0]), new Object[0]));
                            } else {
                                System.out.println("FAIL!");
                            }
                        }
                        catch (BARException bARException) {
                            BARControl.printError(BARControl.tr("cannot set new master ({0})", bARException.getMessage()), new Object[0]);
                            BARServer.disconnect();
                            System.exit(1);
                        }
                        catch (Exception exception) {
                            BARControl.printError(BARControl.tr("cannot set new master ({0})", exception.getMessage()), new Object[0]);
                            BARServer.disconnect();
                            System.exit(1);
                        }
                    }
                    for (String exception : Settings.runJobNames) {
                        object = BARControl.getJobUUID(exception);
                        if (object == null) {
                            BARControl.printError(BARControl.tr("job ''{0}'' not found", exception), new Object[0]);
                            BARServer.disconnect();
                            System.exit(1);
                        }
                        try {
                            BARServer.executeCommand(StringParser.format("JOB_START jobUUID=%s archiveType=%s testCreatedArchives=no noStorage=no dryRun=no", object, Settings.archiveType.toString()), 1);
                        }
                        catch (Exception exception2) {
                            BARControl.printError(BARControl.tr("cannot start job ''{0}'' (error: {1})", exception, exception2.getMessage()), new Object[0]);
                            BARServer.disconnect();
                            System.exit(1);
                        }
                    }
                    if (Settings.pauseTime > 0) {
                        try {
                            BARServer.executeCommand(StringParser.format("PAUSE time=%d modeMask=%s", Settings.pauseTime, "ALL"), 1);
                        }
                        catch (Exception exception) {
                            BARControl.printError(BARControl.tr("cannot pause (error: {0})", exception.getMessage()), new Object[0]);
                            BARServer.disconnect();
                            System.exit(1);
                        }
                    }
                    if (Settings.maintenanceTime > 0) {
                        try {
                            BARServer.executeCommand(StringParser.format("MAINTENANCE time=%d", Settings.maintenanceTime), 1);
                        }
                        catch (Exception exception) {
                            BARControl.printError(BARControl.tr("cannot set maintenance (error: {0})", exception.getMessage()), new Object[0]);
                            BARServer.disconnect();
                            System.exit(1);
                        }
                    }
                    if (Settings.pingFlag) {
                        // empty if block
                    }
                    if (Settings.suspendFlag) {
                        try {
                            BARServer.executeCommand(StringParser.format("SUSPEND modeMask=CREATE", new Object[0]), 1);
                        }
                        catch (Exception exception) {
                            BARControl.printError(BARControl.tr("cannot suspend (error: {0})", exception.getMessage()), new Object[0]);
                            BARServer.disconnect();
                            System.exit(1);
                        }
                    }
                    if (Settings.continueFlag) {
                        try {
                            BARServer.executeCommand(StringParser.format("CONTINUE", new Object[0]), 1);
                        }
                        catch (Exception exception) {
                            BARControl.printError("cannot continue (error: %s)", exception.getMessage());
                            BARServer.disconnect();
                            System.exit(1);
                        }
                    }
                    if (Settings.abortJobName != null) {
                        object3 = BARControl.getJobUUID(Settings.abortJobName);
                        if (object3 == null) {
                            BARControl.printError(BARControl.tr("job ''{0}'' not found", Settings.abortJobName), new Object[0]);
                            BARServer.disconnect();
                            System.exit(1);
                        }
                        try {
                            BARServer.executeCommand(StringParser.format("JOB_ABORT jobUUID=%s", object3), 1);
                        }
                        catch (Exception exception) {
                            BARControl.printError(BARControl.tr("cannot abort job ''{0}'' (error: {1})", Settings.abortJobName, exception.getMessage()), new Object[0]);
                            BARServer.disconnect();
                            System.exit(1);
                        }
                    }
                    if (Settings.listJobsFlag) {
                        object3 = new BARServer.States[]{BARServer.States.RUNNING};
                        try {
                            ValueMap n = new ValueMap();
                            BARServer.executeCommand(StringParser.format("STATUS", new Object[0]), 1, n);
                            object3[0] = n.getEnum("state", BARServer.States.class, BARServer.States.RUNNING);
                        }
                        catch (Exception i) {
                            BARControl.printError(BARControl.tr("cannot get state (error: {0})", i.getMessage()), new Object[0]);
                            BARServer.disconnect();
                            System.exit(1);
                        }
                        final ArrayList arrayList = new ArrayList();
                        try {
                            BARServer.executeCommand(StringParser.format("JOB_LIST", new Object[0]), 1, new Command.ResultHandler(){

                                @Override
                                public void handle(int n, ValueMap valueMap) throws BARException {
                                    String string = valueMap.getString("jobUUID");
                                    String string2 = valueMap.getString("name");
                                    JobData.States states = valueMap.getEnum("state", JobData.States.class);
                                    String string3 = valueMap.getString("slaveHostName", "");
                                    JobData.SlaveStates slaveStates = valueMap.getEnum("slaveState", JobData.SlaveStates.class);
                                    String string4 = valueMap.getString("archiveType");
                                    long l = valueMap.getLong("archivePartSize");
                                    String string5 = valueMap.getString("deltaCompressAlgorithm");
                                    String string6 = valueMap.getString("byteCompressAlgorithm");
                                    String string7 = valueMap.getString("cryptAlgorithm");
                                    String string8 = valueMap.getString("cryptType");
                                    String string9 = valueMap.getString("cryptPasswordMode");
                                    long l2 = valueMap.getLong("lastExecutedDateTime");
                                    long l3 = valueMap.getLong("estimatedRestTime");
                                    arrayList.add(new JobInfo(string, string2, states, string3, slaveStates, string4, l, string5, string6, string7, string8, string9, l2, l3));
                                }
                            });
                            Collections.sort(arrayList, new Comparator<JobInfo>(){

                                @Override
                                public int compare(JobInfo jobInfo, JobInfo jobInfo2) {
                                    return jobInfo.name.compareTo(jobInfo2.name);
                                }
                            });
                            if (!Settings.noHeaderFooterFlag) {
                                System.out.println(String.format("%-32s %-18s %-20s %-12s %-14s %-25s %-15s %-10s %-8s %-19s %-13s", BARControl.tr("Name", new Object[0]), BARControl.tr("State", new Object[0]), BARControl.tr("Host name", new Object[0]), BARControl.tr("Type", new Object[0]), BARControl.tr("Part size", new Object[0]), BARControl.tr("Compress", new Object[0]), BARControl.tr("Crypt", new Object[0]), BARControl.tr("Crypt type", new Object[0]), BARControl.tr("Mode", new Object[0]), BARControl.tr("Last executed", new Object[0]), BARControl.tr("Estimated [s]", new Object[0])));
                                System.out.println(StringUtils.repeat("-", this.getTerminalWidth()));
                            }
                            for (JobInfo jobInfo : arrayList) {
                                String string = !jobInfo.deltaCompressAlgorithm.equalsIgnoreCase("none") && !jobInfo.byteCompressAlgorithm.equalsIgnoreCase("none") ? jobInfo.deltaCompressAlgorithm + "+" + jobInfo.byteCompressAlgorithm : (!jobInfo.deltaCompressAlgorithm.equalsIgnoreCase("none") ? jobInfo.deltaCompressAlgorithm : (!jobInfo.byteCompressAlgorithm.equalsIgnoreCase("none") ? jobInfo.byteCompressAlgorithm : "-"));
                                if (jobInfo.cryptAlgorithm.equalsIgnoreCase("none")) {
                                    jobInfo.cryptAlgorithm = "-";
                                    jobInfo.cryptType = "-";
                                    jobInfo.cryptPasswordMode = "-";
                                }
                                System.out.println(String.format("%-32s %-18s %-20s %-12s %14d %-25s %-15s %-10s %-8s %-19s %13d", jobInfo.name, object3[0] == BARServer.States.RUNNING ? JobData.formatStateText(jobInfo.state, jobInfo.slaveHostName, jobInfo.slaveState) : BARControl.tr("suspended", new Object[0]), jobInfo.slaveHostName, jobInfo.archiveType.toString(), jobInfo.archivePartSize, string, jobInfo.cryptAlgorithm, jobInfo.cryptType, jobInfo.cryptPasswordMode, jobInfo.lastExecutedDateTime > 0L ? simpleDateFormat.format(new Date(jobInfo.lastExecutedDateTime * 1000L)) : "", jobInfo.estimatedRestTime));
                            }
                            if (!Settings.noHeaderFooterFlag) {
                                System.out.println(StringUtils.repeat("-", this.getTerminalWidth()));
                                System.out.println(BARControl.tr("{0} {0,choice,0#jobs|1#job|1<jobs}", arrayList.size()));
                            }
                        }
                        catch (Exception exception) {
                            BARControl.printError(BARControl.tr("cannot get job list (error: {0})", exception.getMessage()), new Object[0]);
                            BARServer.disconnect();
                            System.exit(1);
                        }
                    }
                    if (Settings.listSchedulesFlag) {
                        object3 = new ArrayList();
                        try {
                            BARServer.executeCommand(StringParser.format("SCHEDULE_LIST", new Object[0]), 1, new Command.ResultHandler((ArrayList)object3){
                                final /* synthetic */ ArrayList val$nextScheduleList;
                                {
                                    this.val$nextScheduleList = arrayList;
                                }

                                @Override
                                public void handle(int n, ValueMap valueMap) throws BARException {
                                    String string = valueMap.getString("jobName");
                                    String string2 = valueMap.getString("jobUUID");
                                    String string3 = valueMap.getString("scheduleUUID");
                                    String string4 = valueMap.getString("date");
                                    String string5 = valueMap.getString("weekDays");
                                    String string6 = valueMap.getString("time");
                                    ArchiveTypes archiveTypes = valueMap.getEnum("archiveType", ArchiveTypes.class);
                                    int n2 = valueMap.getInt("interval");
                                    String string7 = valueMap.getString("customText");
                                    String string8 = valueMap.getString("beginTime");
                                    String string9 = valueMap.getString("endTime");
                                    boolean bl = valueMap.getBoolean("testCreatedArchives");
                                    boolean bl2 = valueMap.getBoolean("noStorage");
                                    boolean bl3 = valueMap.getBoolean("enabled");
                                    long l = valueMap.getLong("lastExecutedDateTime");
                                    long l2 = valueMap.getLong("nextExecutedDateTime");
                                    long l3 = valueMap.getLong("totalEntities");
                                    long l4 = valueMap.getLong("totalEntryCount");
                                    long l5 = valueMap.getLong("totalEntrySize", Long.MAX_VALUE);
                                    this.val$nextScheduleList.add(new ScheduleInfo(string, string3, string4, string5, string6, archiveTypes, n2, string8, string9, string7, bl, bl2, bl3, l, l2, l3, l4, l5));
                                }
                            });
                            Collections.sort(object3, new Comparator<ScheduleInfo>(){

                                @Override
                                public int compare(ScheduleInfo scheduleInfo, ScheduleInfo scheduleInfo2) {
                                    int n = 0;
                                    if (n == 0) {
                                        n = scheduleInfo.jobName.compareTo(scheduleInfo2.jobName);
                                    }
                                    if (n == 0) {
                                        if (scheduleInfo.lastExecutedDateTime < scheduleInfo2.lastExecutedDateTime) {
                                            n = -1;
                                        } else if (scheduleInfo.lastExecutedDateTime > scheduleInfo2.lastExecutedDateTime) {
                                            n = 1;
                                        }
                                    }
                                    return n;
                                }
                            });
                            if (!Settings.noHeaderFooterFlag) {
                                System.out.println(String.format("%-20s %-36s %-10s %-23s %-5s %-11s %-8s %-15s %-5s %-5s %-3s %-3s %-3s %-19s %-19s", BARControl.tr("Job", new Object[0]), BARControl.tr("UUID", new Object[0]), BARControl.tr("Date", new Object[0]), BARControl.tr("Week days", new Object[0]), BARControl.tr("Time", new Object[0]), BARControl.tr("Type", new Object[0]), BARControl.tr("Interval", new Object[0]), BARControl.tr("Text", new Object[0]), BARControl.tr("Begin", new Object[0]), BARControl.tr("End", new Object[0]), BARControl.tr("T", new Object[0]), BARControl.tr("S", new Object[0]), BARControl.tr("E", new Object[0]), BARControl.tr("Last", new Object[0]), BARControl.tr("Next", new Object[0])));
                                System.out.println(StringUtils.repeat("-", this.getTerminalWidth()));
                            }
                            Iterator iterator = ((ArrayList)object3).iterator();
                            while (iterator.hasNext()) {
                                object = (ScheduleInfo)iterator.next();
                                System.out.println(String.format("%-20s %-36s %-10s %-23s %-5s %-11s %8d %-15s %-5s %-5s %-3s %-3s %-3s %-19s %-19s", new Object[]{((ScheduleInfo)object).jobName, ((ScheduleInfo)object).uuid, ((ScheduleInfo)object).getDate(), ((ScheduleInfo)object).getWeekDays(), ((ScheduleInfo)object).getTime(), ((ScheduleInfo)object).getArchiveType(), ((ScheduleInfo)object).interval, ((ScheduleInfo)object).customText, ((ScheduleInfo)object).getBeginTime(), ((ScheduleInfo)object).getEndTime(), ((ScheduleInfo)object).testCreatedArchives ? "yes" : "no", ((ScheduleInfo)object).noStorage ? "yes" : "no", ((ScheduleInfo)object).enabled ? "yes" : "no", ((ScheduleInfo)object).lastExecutedDateTime > 0L ? simpleDateFormat.format(new Date(((ScheduleInfo)object).lastExecutedDateTime * 1000L)) : "-", ((ScheduleInfo)object).nextExecutedDateTime > 0L ? simpleDateFormat.format(new Date(((ScheduleInfo)object).nextExecutedDateTime * 1000L)) : "-"}));
                            }
                            if (!Settings.noHeaderFooterFlag) {
                                System.out.println(StringUtils.repeat("-", this.getTerminalWidth()));
                                System.out.println(BARControl.tr("{0} {0,choice,0#jobs|1#schedule|1<schedules}", ((ArrayList)object3).size()));
                            }
                        }
                        catch (Exception exception) {
                            BARControl.printError(BARControl.tr("cannot get schedule list (error: {0})", exception.getMessage()), new Object[0]);
                            BARServer.disconnect();
                            System.exit(1);
                        }
                    }
                    if (Settings.infoJobName != null) {
                        object3 = BARControl.getJobUUID(Settings.infoJobName);
                        if (object3 == null) {
                            BARControl.printError(BARControl.tr("job ''{0}'' not found", Settings.infoJobName), new Object[0]);
                            BARServer.disconnect();
                            System.exit(1);
                        }
                        try {
                            BARServer.executeCommand(StringParser.format("JOB_STATUS jobUUID=%s", object3, Settings.archiveType.toString()), 1, new Command.ResultHandler(){

                                @Override
                                public void handle(int n, ValueMap valueMap) {
                                    int n2 = valueMap.getInt("errorCode");
                                    String string = valueMap.getString("errorData");
                                    System.out.println(String.format("Job '%s':", Settings.infoJobName));
                                    System.out.println(String.format("  Total entries      : %d / %s", valueMap.getInt("totalEntryCount"), Units.formatByteSize(valueMap.getLong("totalEntrySize"))));
                                    System.out.println(String.format("  Skipped entries    : %d / %s", valueMap.getInt("skippedEntryCount"), Units.formatByteSize(valueMap.getLong("skippedEntrySize"))));
                                    System.out.println(String.format("  Error entries      : %d / %s", valueMap.getInt("errorEntryCount"), Units.formatByteSize(valueMap.getLong("errorEntrySize"))));
                                    System.out.println(String.format("  Compression ratio  : %.1f%%", valueMap.getDouble("compressionRatio")));
                                    System.out.println(String.format("  Entries/s          : %.1f", valueMap.getDouble("entriesPerSecond")));
                                    System.out.println(String.format("  Bytes/s            : %.1f", valueMap.getDouble("bytesPerSecond")));
                                    System.out.println(String.format("  Storage done       : %s", Units.formatByteSize(valueMap.getLong("storageTotalSize"))));
                                    System.out.println(String.format("          total      : %s", Units.formatByteSize(valueMap.getLong("storageTotalSize"))));
                                    System.out.println(String.format("          bytes/s    : %.1f", valueMap.getDouble("storageBytesPerSecond")));
                                    System.out.println(String.format("  Estimated rest time: %ds", valueMap.getLong("estimatedRestTime")));
                                    System.out.println(String.format("  Last error         : %s", n2 != 0 ? BARException.getText(n2, 0, string) : "none"));
                                }
                            });
                        }
                        catch (Exception exception) {
                            BARControl.printError(BARControl.tr("cannot get job info ''{0}'' (error: {1})", Settings.infoJobName, exception.getMessage()), new Object[0]);
                            BARServer.disconnect();
                            System.exit(1);
                        }
                    }
                    if (Settings.indexDatabaseInfo) {
                        try {
                            BARServer.executeCommand(StringParser.format("INDEX_INFO", new Object[0]), 1, new Command.ResultHandler(){

                                @Override
                                public void handle(int n, ValueMap valueMap) throws BARException {
                                    long l = valueMap.getLong("totalNormalEntityCount");
                                    long l2 = valueMap.getLong("totalFullEntityCount");
                                    long l3 = valueMap.getLong("totalIncrementalEntityCount");
                                    long l4 = valueMap.getLong("totalDifferentialEntityCount");
                                    long l5 = valueMap.getLong("totalContinuousEntityCount");
                                    long l6 = valueMap.getLong("totalLockedEntityCount");
                                    long l7 = valueMap.getLong("totalDeletedEntityCount");
                                    long l8 = valueMap.getLong("totalEntryCount");
                                    long l9 = valueMap.getLong("totalEntrySize", Long.MAX_VALUE);
                                    long l10 = valueMap.getLong("totalFileCount");
                                    long l11 = valueMap.getLong("totalFileSize", Long.MAX_VALUE);
                                    long l12 = valueMap.getLong("totalImageCount");
                                    long l13 = valueMap.getLong("totalImageSize", Long.MAX_VALUE);
                                    long l14 = valueMap.getLong("totalDirectoryCount");
                                    long l15 = valueMap.getLong("totalLinkCount");
                                    long l16 = valueMap.getLong("totalHardlinkCount");
                                    long l17 = valueMap.getLong("totalHardlinkSize", Long.MAX_VALUE);
                                    long l18 = valueMap.getLong("totalSpecialCount");
                                    long l19 = valueMap.getLong("totalEntryCountNewest");
                                    long l20 = valueMap.getLong("totalEntrySizeNewest", Long.MAX_VALUE);
                                    long l21 = valueMap.getLong("totalFileCountNewest");
                                    long l22 = valueMap.getLong("totalFileSizeNewest", Long.MAX_VALUE);
                                    long l23 = valueMap.getLong("totalImageCountNewest");
                                    long l24 = valueMap.getLong("totalImageSizeNewest", Long.MAX_VALUE);
                                    long l25 = valueMap.getLong("totalDirectoryCountNewest");
                                    long l26 = valueMap.getLong("totalLinkCountNewest");
                                    long l27 = valueMap.getLong("totalHardlinkCountNewest");
                                    long l28 = valueMap.getLong("totalHardlinkSizeNewest", Long.MAX_VALUE);
                                    long l29 = valueMap.getLong("totalSpecialCountNewest");
                                    long l30 = valueMap.getLong("totalSkippedEntryCount");
                                    long l31 = valueMap.getLong("totalStorageCount");
                                    long l32 = valueMap.getLong("totalStorageSize", Long.MAX_VALUE);
                                    long l33 = valueMap.getLong("totalOKStorageCount");
                                    long l34 = valueMap.getLong("totalUpdateRequestedStorageCount");
                                    long l35 = valueMap.getLong("totalErrorStorageCount");
                                    long l36 = valueMap.getLong("totalDeletedStorageCount");
                                    System.out.println(String.format("Entities: %d", l + l2 + l3 + l4 + l5));
                                    System.out.println(String.format("  Normal          : %d", l));
                                    System.out.println(String.format("  Full            : %d", l2));
                                    System.out.println(String.format("  Incremental     : %d", l3));
                                    System.out.println(String.format("  Differential    : %d", l4));
                                    System.out.println(String.format("  Continuous      : %d", l5));
                                    System.out.println(String.format("  Locked          : %d", l6));
                                    System.out.println(String.format("  Deleted         : %d", l7));
                                    System.out.println(String.format("Storages: %d, %s (%d bytes)", l31, Units.formatByteSize(l32), l32));
                                    System.out.println(String.format("  OK              : %d", l33));
                                    System.out.println(String.format("  Update requested: %d", l34));
                                    System.out.println(String.format("  Error           : %d", l35));
                                    System.out.println(String.format("  Deleted         : %d", l36));
                                    System.out.println(String.format("Entries: %d, %s (%d bytes)", l8, Units.formatByteSize(l9), l9));
                                    System.out.println(String.format("  Files           : %d, %s (%d bytes)", l10, Units.formatByteSize(l11), l11));
                                    System.out.println(String.format("  Images          : %d, %s (%d bytes)", l12, Units.formatByteSize(l13), l13));
                                    System.out.println(String.format("  Directories     : %d", l14));
                                    System.out.println(String.format("  Links           : %d", l15));
                                    System.out.println(String.format("  Hardlinks       : %d, %s (%d bytes)", l16, Units.formatByteSize(l17), l17));
                                    System.out.println(String.format("  Special         : %d", l18));
                                    System.out.println(String.format("Newest entries: %d, %s (%d bytes)", l19, Units.formatByteSize(l20), l20));
                                    System.out.println(String.format("  Files           : %d, %s (%d bytes)", l21, Units.formatByteSize(l22), l22));
                                    System.out.println(String.format("  Images          : %d, %s (%d bytes)", l23, Units.formatByteSize(l24), l24));
                                    System.out.println(String.format("  Directories     : %d", l25));
                                    System.out.println(String.format("  Links           : %d", l26));
                                    System.out.println(String.format("  Hardlinks       : %d, %s (%d bytes)", l27, Units.formatByteSize(l28), l28));
                                    System.out.println(String.format("  Special         : %d", l29));
                                    System.out.println(String.format("Skipped: %d", l30));
                                }
                            });
                        }
                        catch (Exception exception) {
                            BARControl.printError(BARControl.tr("cannot get index info (error: {0})", exception.getMessage()), new Object[0]);
                            BARServer.disconnect();
                            System.exit(1);
                        }
                    }
                    if (Settings.indexDatabaseAddStorageName != null) {
                        try {
                            BARServer.executeCommand(StringParser.format("INDEX_STORAGE_ADD name=%'S patternType=GLOB ProgressInfo_steps=1000", Settings.indexDatabaseAddStorageName), 1, new Command.ResultHandler(){

                                @Override
                                public void handle(int n, ValueMap valueMap) throws BARException {
                                    long l = valueMap.getLong("storageId", 0L);
                                    String string = valueMap.getString("name", "");
                                    long l2 = valueMap.getLong("doneCount", 0L);
                                    long l3 = valueMap.getLong("totalCount", 0L);
                                    if (l != 0L && !string.isEmpty()) {
                                        System.out.println(String.format("%s", string));
                                    }
                                }
                            });
                        }
                        catch (Exception exception) {
                            BARControl.printError(BARControl.tr("cannot add ''{0}'' to index (error: {1})", Settings.indexDatabaseAddStorageName, exception.getMessage()), new Object[0]);
                            BARServer.disconnect();
                            System.exit(1);
                        }
                    }
                    if (Settings.indexDatabaseRefreshStorageName != null) {
                        try {
                            BARServer.executeCommand(StringParser.format("INDEX_REFRESH name=%'S", Settings.indexDatabaseRefreshStorageName), 1);
                        }
                        catch (Exception exception) {
                            BARControl.printError("cannot refresh index for storage '%s' from index (error: %s)", Settings.indexDatabaseRefreshStorageName, exception.getMessage());
                            BARServer.disconnect();
                            System.exit(1);
                        }
                    }
                    if (Settings.indexDatabaseRemoveStorageName != null) {
                        try {
                            BARServer.executeCommand(StringParser.format("INDEX_REMOVE name=%'S", Settings.indexDatabaseRemoveStorageName), 1);
                        }
                        catch (Exception exception) {
                            BARControl.printError(BARControl.tr("cannot remove index for storage ''{0}'' from index (error: {1})", Settings.indexDatabaseRemoveStorageName, exception.getMessage()), new Object[0]);
                            BARServer.disconnect();
                            System.exit(1);
                        }
                    }
                    if (Settings.indexDatabaseEntitiesListName != null) {
                        object3 = new String[]{"\\n", "\\r", "\\\\"};
                        String[] stringArray2 = new String[]{"\n", "\r", "\\"};
                        try {
                            object = new int[]{0};
                            if (!Settings.noHeaderFooterFlag) {
                                System.out.println(String.format("%-8s %-8s %-12s %-14s %-14s %-14s %-19s %s", BARControl.tr("Entity id", new Object[0]), BARControl.tr("Job id", new Object[0]), BARControl.tr("Type", new Object[0]), BARControl.tr("Size", new Object[0]), BARControl.tr("Entry count", new Object[0]), BARControl.tr("Entry size", new Object[0]), BARControl.tr("Date/Time", new Object[0]), BARControl.tr("Job", new Object[0])));
                                System.out.println(StringUtils.repeat("-", this.getTerminalWidth()));
                            }
                            BARServer.executeCommand(StringParser.format("INDEX_ENTITY_LIST indexStateSet=* indexModeSet=* name=%'S sortMode=JOB_UUID ordering=ASCENDING", !Settings.indexDatabaseEntitiesListName.isEmpty() ? Settings.indexDatabaseEntitiesListName : ""), 0, new Command.ResultHandler((int[])object){
                                final /* synthetic */ int[] val$n;
                                {
                                    this.val$n = nArray;
                                }

                                @Override
                                public void handle(int n, ValueMap valueMap) throws BARException {
                                    long l = valueMap.getLong("uuid");
                                    String string = valueMap.getString("jobUUID");
                                    String string2 = valueMap.getString("jobName");
                                    long l2 = valueMap.getLong("entityId");
                                    ArchiveTypes archiveTypes = valueMap.getEnum("archiveType", ArchiveTypes.class);
                                    long l3 = valueMap.getLong("createdDateTime");
                                    long l4 = valueMap.getLong("totalSize");
                                    long l5 = valueMap.getLong("totalEntryCount");
                                    long l6 = valueMap.getLong("totalEntrySize");
                                    System.out.println(String.format("%8d %8d %-12s %-14s %14d %14d %-19s %s", BARControl.getDatabaseId(l2), BARControl.getDatabaseId(l), archiveTypes.toString(), l4, l5, l6, l3 > 0L ? simpleDateFormat.format(new Date(l3 * 1000L)) : "-", !string2.isEmpty() ? string2 : string));
                                    this.val$n[0] = this.val$n[0] + 1;
                                }
                            });
                            if (!Settings.noHeaderFooterFlag) {
                                System.out.println(StringUtils.repeat("-", this.getTerminalWidth()));
                                System.out.println(BARControl.tr("{0} entities", Integer.valueOf(object[0])));
                            }
                        }
                        catch (Exception exception) {
                            BARControl.printError(BARControl.tr("cannot list entities index (error: {0})", exception.getMessage()), new Object[0]);
                            BARServer.disconnect();
                            System.exit(1);
                        }
                    }
                    if (Settings.indexDatabaseStoragesListName != null) {
                        object3 = new String[]{"\\n", "\\r", "\\\\"};
                        String[] stringArray3 = new String[]{"\n", "\r", "\\"};
                        try {
                            object = new int[]{0};
                            if (!Settings.noHeaderFooterFlag) {
                                System.out.println(String.format("%-8s %-8s %-14s %-19s %-16s %-6s %s", BARControl.tr("Storage id", new Object[0]), BARControl.tr("Entity", new Object[0]), BARControl.tr("Size", new Object[0]), BARControl.tr("Date/Time", new Object[0]), BARControl.tr("State", new Object[0]), BARControl.tr("Mode", new Object[0]), BARControl.tr("Name", new Object[0])));
                                System.out.println(StringUtils.repeat("-", this.getTerminalWidth()));
                            }
                            BARServer.executeCommand(StringParser.format("INDEX_STORAGE_LIST entityId=* indexStateSet=* indexModeSet=* name=%'S sortMode=NAME ordering=ASCENDING", Settings.indexDatabaseStoragesListName), 1, new Command.ResultHandler((int[])object){
                                final /* synthetic */ int[] val$n;
                                {
                                    this.val$n = nArray;
                                }

                                @Override
                                public void handle(int n, ValueMap valueMap) throws BARException {
                                    long l = valueMap.getLong("storageId");
                                    long l2 = valueMap.getLong("entityId");
                                    String string = valueMap.getString("name");
                                    long l3 = valueMap.getLong("dateTime");
                                    long l4 = valueMap.getLong("size");
                                    IndexStates indexStates = valueMap.getEnum("indexState", IndexStates.class);
                                    IndexModes indexModes = valueMap.getEnum("indexMode", IndexModes.class);
                                    System.out.println(String.format("%8d %8d %-19s %-16s %-6s %-6s %s", new Object[]{BARControl.getDatabaseId(l), BARControl.getDatabaseId(l2), l4, simpleDateFormat.format(new Date(l3 * 1000L)), indexStates, indexModes, string}));
                                    this.val$n[0] = this.val$n[0] + 1;
                                }
                            });
                            if (!Settings.noHeaderFooterFlag) {
                                System.out.println(StringUtils.repeat("-", this.getTerminalWidth()));
                                System.out.println(BARControl.tr("{0} {0,choice,0#storages|1#storage|1<storages}", Integer.valueOf(object[0])));
                            }
                        }
                        catch (Exception exception) {
                            BARControl.printError(BARControl.tr("cannot list storages index (error: {0})", exception.getMessage()), new Object[0]);
                            BARServer.disconnect();
                            System.exit(1);
                        }
                    }
                    if (Settings.indexDatabaseEntriesListName != null) {
                        try {
                            int n;
                            BARServer.executeCommand(StringParser.format("INDEX_ENTRY_LIST_INFO entryType=* name=%'S newestOnly=%y  selectedOnly=no fragmentsCount=no", Settings.indexDatabaseEntriesListName, Settings.indexDatabaseEntriesListNewestOnly), 1, new Command.ResultHandler(){

                                @Override
                                public void handle(int n, ValueMap valueMap) throws BARException {
                                }
                            });
                            object3 = new ArrayList();
                            BARServer.executeCommand(StringParser.format("INDEX_ENTRY_LIST entryType=* name=%'S newestOnly=%y limit=1024", Settings.indexDatabaseEntriesListName, Settings.indexDatabaseEntriesListNewestOnly), 1, new Command.ResultHandler((ArrayList)object3){
                                final /* synthetic */ ArrayList val$entryInfoList;
                                {
                                    this.val$entryInfoList = arrayList;
                                }

                                @Override
                                public void handle(int n, ValueMap valueMap) throws BARException {
                                    String string = valueMap.getString("storageName");
                                    long l = valueMap.getLong("entryId", 0L);
                                    EntryTypes entryTypes = valueMap.getEnum("entryType", EntryTypes.class);
                                    switch (entryTypes) {
                                        case FILE: {
                                            String string2 = valueMap.getString("name");
                                            long l2 = valueMap.getLong("size", 0L);
                                            long l3 = valueMap.getLong("dateTime", 0L);
                                            long l4 = valueMap.getLong("fragmentCount", 0L);
                                            this.val$entryInfoList.add(EntryInfo.newFile(l, string, string2, l2, l3, l4));
                                            break;
                                        }
                                        case IMAGE: {
                                            String string3 = valueMap.getString("name");
                                            long l5 = valueMap.getLong("size", 0L);
                                            long l6 = valueMap.getLong("blockOffset", 0L);
                                            long l7 = valueMap.getLong("blockCount", 0L);
                                            this.val$entryInfoList.add(EntryInfo.newImage(l, string, string3, l5, l6, l7));
                                            break;
                                        }
                                        case DIRECTORY: {
                                            String string4 = valueMap.getString("name");
                                            long l8 = valueMap.getLong("dateTime", 0L);
                                            this.val$entryInfoList.add(EntryInfo.newDirectory(l, string, string4, l8));
                                            break;
                                        }
                                        case LINK: {
                                            String string5 = valueMap.getString("name");
                                            String string6 = valueMap.getString("destinationName");
                                            long l9 = valueMap.getLong("dateTime", 0L);
                                            this.val$entryInfoList.add(EntryInfo.newLink(l, string, string5, string6));
                                            break;
                                        }
                                        case HARDLINK: {
                                            String string7 = valueMap.getString("name");
                                            long l10 = valueMap.getLong("size", 0L);
                                            long l11 = valueMap.getLong("dateTime", 0L);
                                            long l12 = valueMap.getLong("fragmentCount", 0L);
                                            this.val$entryInfoList.add(EntryInfo.newHardLink(l, string, string7, l10, l11, l12));
                                            break;
                                        }
                                        case SPECIAL: {
                                            String string8 = valueMap.getString("name");
                                            long l13 = valueMap.getLong("dateTime", 0L);
                                            this.val$entryInfoList.add(EntryInfo.newSpecial(l, string, string8, l13));
                                        }
                                    }
                                }
                            });
                            boolean bl = false;
                            object = ((ArrayList)object3).iterator();
                            while (object.hasNext()) {
                                EntryInfo entryInfo = (EntryInfo)object.next();
                                n = Math.max(entryInfo.storageName.length(), n);
                            }
                            if (!Settings.noHeaderFooterFlag) {
                                if (Settings.longFormatFlag) {
                                    System.out.println(String.format("%-16s %-8s %-14s %-19s %-" + Integer.toString(n) + "s %s", BARControl.tr("Entry id", new Object[0]), BARControl.tr("Type", new Object[0]), BARControl.tr("Size", new Object[0]), BARControl.tr("Date/Time", new Object[0]), BARControl.tr("Storage", new Object[0]), BARControl.tr("Name", new Object[0])));
                                } else {
                                    System.out.println(String.format("%-16s %-8s %-14s %-19s %s", BARControl.tr("Entry id", new Object[0]), BARControl.tr("Type", new Object[0]), BARControl.tr("Size", new Object[0]), BARControl.tr("Date/Time", new Object[0]), BARControl.tr("Name", new Object[0])));
                                }
                                System.out.println(StringUtils.repeat("-", this.getTerminalWidth()));
                            }
                            object = ((ArrayList)object3).iterator();
                            while (object.hasNext()) {
                                EntryInfo entryInfo = (EntryInfo)object.next();
                                switch (entryInfo.entryType) {
                                    case FILE: {
                                        if (Settings.longFormatFlag) {
                                            System.out.println(String.format("%16d %-8s %14d %-19s %-" + Integer.toString(n) + "s %s", BARControl.getDatabaseId(entryInfo.entryId), "FILE", entryInfo.file.size, simpleDateFormat.format(new Date(entryInfo.file.dateTime * 1000L)), entryInfo.storageName, entryInfo.file.name));
                                            break;
                                        }
                                        System.out.println(String.format("%16d %-8s %14d %-19s %s", BARControl.getDatabaseId(entryInfo.entryId), "FILE", entryInfo.file.size, simpleDateFormat.format(new Date(entryInfo.file.dateTime * 1000L)), entryInfo.file.name));
                                        break;
                                    }
                                    case IMAGE: {
                                        if (Settings.longFormatFlag) {
                                            System.out.println(String.format("%8d %-8s %14d %-19s %-" + Integer.toString(n) + "s %s", BARControl.getDatabaseId(entryInfo.entryId), "IMAGE", entryInfo.image.size, "", entryInfo.storageName, entryInfo.image.name));
                                            break;
                                        }
                                        System.out.println(String.format("%8d %-8s %14d %-19s %s", BARControl.getDatabaseId(entryInfo.entryId), "IMAGE", entryInfo.image.size, "", entryInfo.image.name));
                                        break;
                                    }
                                    case DIRECTORY: {
                                        if (Settings.longFormatFlag) {
                                            System.out.println(String.format("%16d %-8s %14s %-19s %-" + Integer.toString(n) + "s %s", BARControl.getDatabaseId(entryInfo.entryId), "DIR", "", simpleDateFormat.format(new Date(entryInfo.directory.dateTime * 1000L)), entryInfo.storageName, entryInfo.directory.name));
                                            break;
                                        }
                                        System.out.println(String.format("%16d %-8s %14s %-19s %s", BARControl.getDatabaseId(entryInfo.entryId), "DIR", "", simpleDateFormat.format(new Date(entryInfo.directory.dateTime * 1000L)), entryInfo.directory.name));
                                        break;
                                    }
                                    case LINK: {
                                        if (Settings.longFormatFlag) {
                                            System.out.println(String.format("%16d %-8s %14s %-19s %-" + Integer.toString(n) + "s %s -> %s", BARControl.getDatabaseId(entryInfo.entryId), "LINK", "", simpleDateFormat.format(new Date(entryInfo.link.dateTime * 1000L)), entryInfo.storageName, entryInfo.link.name, entryInfo.link.destinationName));
                                            break;
                                        }
                                        System.out.println(String.format("%16d %-8s %14s %-19s %s -> %s", BARControl.getDatabaseId(entryInfo.entryId), "LINK", "", simpleDateFormat.format(new Date(entryInfo.link.dateTime * 1000L)), entryInfo.link.name, entryInfo.link.destinationName));
                                        break;
                                    }
                                    case HARDLINK: {
                                        if (Settings.longFormatFlag) {
                                            System.out.println(String.format("%16d %-8s %14d %-19s %-" + Integer.toString(n) + "s %s", BARControl.getDatabaseId(entryInfo.entryId), "HARDLINK", entryInfo.hardLink.size, simpleDateFormat.format(new Date(entryInfo.hardLink.dateTime * 1000L)), entryInfo.storageName, entryInfo.hardLink.name));
                                            break;
                                        }
                                        System.out.println(String.format("%16d %-8s %14d %-19s %s", BARControl.getDatabaseId(entryInfo.entryId), "HARDLINK", entryInfo.hardLink.size, simpleDateFormat.format(new Date(entryInfo.hardLink.dateTime * 1000L)), entryInfo.hardLink.name));
                                        break;
                                    }
                                    case SPECIAL: {
                                        if (Settings.longFormatFlag) {
                                            System.out.println(String.format("%16d %-8s %14s %-19s %-" + Integer.toString(n) + "s %s", BARControl.getDatabaseId(entryInfo.entryId), "SPECIAL", "", simpleDateFormat.format(new Date(entryInfo.special.dateTime * 1000L)), entryInfo.storageName, entryInfo.special.name));
                                            break;
                                        }
                                        System.out.println(String.format("%16d %-8s %14s %-19s %s", BARControl.getDatabaseId(entryInfo.entryId), "SPECIAL", "", simpleDateFormat.format(new Date(entryInfo.special.dateTime * 1000L)), entryInfo.special.name));
                                    }
                                }
                            }
                            if (!Settings.noHeaderFooterFlag) {
                                System.out.println(StringUtils.repeat("-", this.getTerminalWidth()));
                                System.out.println(BARControl.tr("{0} entries (max. 1024 shown)", ((ArrayList)object3).size()));
                            }
                        }
                        catch (Exception exception) {
                            BARControl.printError(BARControl.tr("cannot list entries index (error: {0})", exception.getMessage()), new Object[0]);
                            BARServer.disconnect();
                            System.exit(1);
                        }
                    }
                    if (Settings.indexDatabaseHistoryList) {
                        try {
                            object3 = new int[]{0};
                            if (!Settings.noHeaderFooterFlag) {
                                System.out.println(String.format("%-32s %-20s %-12s %-19s %-8s %-23s %-23s %-23s %s", BARControl.tr("Job", new Object[0]), BARControl.tr("Hostname", new Object[0]), BARControl.tr("Type", new Object[0]), BARControl.tr("Date/Time", new Object[0]), BARControl.tr("Duration", new Object[0]), BARControl.tr("Total           [bytes]", new Object[0]), BARControl.tr("Skipped         [bytes]", new Object[0]), BARControl.tr("With errors     [bytes]", new Object[0]), BARControl.tr("Message", new Object[0])));
                                System.out.println(StringUtils.repeat("-", this.getTerminalWidth()));
                            }
                            BARServer.executeCommand(StringParser.format("INDEX_HISTORY_LIST", new Object[0]), 1, new Command.ResultHandler((int[])object3){
                                final /* synthetic */ int[] val$n;
                                {
                                    this.val$n = nArray;
                                }

                                @Override
                                public void handle(int n, ValueMap valueMap) throws BARException {
                                    String string = valueMap.getString("jobUUID");
                                    String string2 = valueMap.getString("jobName");
                                    String string3 = valueMap.getString("scheduleUUID");
                                    String string4 = valueMap.getString("hostName", "");
                                    String string5 = valueMap.getString("archiveType");
                                    long l = valueMap.getLong("createdDateTime");
                                    String string6 = valueMap.getString("errorMessage");
                                    long l2 = valueMap.getLong("duration");
                                    long l3 = valueMap.getLong("totalEntryCount");
                                    long l4 = valueMap.getLong("totalEntrySize", Long.MAX_VALUE);
                                    long l5 = valueMap.getLong("skippedEntryCount");
                                    long l6 = valueMap.getLong("skippedEntrySize", Long.MAX_VALUE);
                                    long l7 = valueMap.getLong("errorEntryCount");
                                    long l8 = valueMap.getLong("errorEntrySize");
                                    string6 = string6.replace("\n", " ");
                                    System.out.println(String.format("%-32s %-20s %-12s %-19s %02d:%02d:%02d %8d %14d %8d %14d %8d %14d %s", !string2.isEmpty() ? string2 : string, string4, string5, simpleDateFormat.format(new Date(l * 1000L)), l2 / 3600L, l2 / 60L % 60L, l2 % 60L, l3, l4, l5, l6, l7, l8, string6));
                                    this.val$n[0] = this.val$n[0] + 1;
                                }
                            });
                            if (!Settings.noHeaderFooterFlag) {
                                System.out.println(StringUtils.repeat("-", this.getTerminalWidth()));
                                System.out.println(BARControl.tr("{0} {0,choice,0#entries|1#entry|1<entries}", (int)object3[0]));
                            }
                        }
                        catch (Exception exception) {
                            BARControl.printError(BARControl.tr("cannot list history (error: {0})", exception.getMessage()), new Object[0]);
                            BARServer.disconnect();
                            System.exit(1);
                        }
                    }
                    if (Settings.restoreStorageName != null) {
                        try {
                            void var6_50;
                            object3 = new ArrayList();
                            BARServer.executeCommand(StringParser.format("INDEX_STORAGE_LIST entityId=%s indexStateSet=%s indexModeSet=%s name=%'S offset=%ld sortMode=NAME ordering=ASCENDING", "*", "*", "*", Settings.restoreStorageName, 0L), 1, new Command.ResultHandler((ArrayList)object3){
                                final /* synthetic */ ArrayList val$storageIds;
                                {
                                    this.val$storageIds = arrayList;
                                }

                                @Override
                                public void handle(int n, ValueMap valueMap) throws BARException {
                                    long l = valueMap.getLong("storageId");
                                    String string = valueMap.getString("name");
                                    this.val$storageIds.add(l);
                                }
                            });
                            if (((ArrayList)object3).isEmpty()) {
                                throw new BARException(170, Settings.restoreStorageName);
                            }
                            BARServer.executeCommand(StringParser.format("INDEX_LIST_CLEAR", new Object[0]), 1);
                            boolean bl = false;
                            while (var6_50 < ((ArrayList)object3).size()) {
                                int n = ((ArrayList)object3).size() - var6_50;
                                if (n > 1024) {
                                    n = 1024;
                                }
                                BARServer.executeCommand(StringParser.format("INDEX_LIST_ADD storageIds=%s", StringUtils.join(object3, (int)var6_50, n, ',')), 1);
                                var6_50 += n;
                            }
                        }
                        catch (Exception exception) {
                            BARControl.printError(BARControl.tr("cannot set restore list (error: {0})", exception.getMessage()), new Object[0]);
                            BARServer.disconnect();
                            System.exit(1);
                        }
                        try {
                            BARServer.executeCommand(StringParser.format("RESTORE type=ARCHIVES destination=%'S directoryContent=%y restoreEntryMode=%s", Settings.destination, true, Settings.overwriteEntriesFlag ? "overwrite" : "stop"), 1, new Command.ResultHandler(){

                                @Override
                                public void handle(int n, ValueMap valueMap) throws BARException {
                                    block16: {
                                        try {
                                            if (valueMap.containsKey("action")) {
                                                Actions actions = valueMap.getEnum("action", Actions.class);
                                                PasswordTypes passwordTypes = valueMap.getEnum("passwordType", PasswordTypes.class, PasswordTypes.NONE);
                                                String string = valueMap.getString("passwordText", "");
                                                String string2 = valueMap.getString("volume", "");
                                                int n2 = valueMap.getInt("error", 0);
                                                String string3 = valueMap.getString("errorMessage", "");
                                                String string4 = valueMap.getString("storage", "");
                                                String string5 = valueMap.getString("entry", "");
                                                switch (actions) {
                                                    case REQUEST_PASSWORD: {
                                                        Console console = System.console();
                                                        if (passwordTypes.isLogin()) {
                                                            System.out.println(BARControl.tr("Please enter {0} login for: {1}", new Object[]{passwordTypes, string}));
                                                            String string6 = console.readLine("  " + BARControl.tr("Name", new Object[0]) + ": ", new Object[0]);
                                                            char[] cArray = console.readPassword("  " + BARControl.tr("Password", new Object[0]) + ": ", new Object[0]);
                                                            if (cArray != null && cArray.length > 0) {
                                                                BARServer.executeCommand(StringParser.format("ACTION_RESULT errorCode=%d name=%S encryptType=%s encryptedPassword=%S", 0, string6, BARServer.getPasswordEncryptType(), BARServer.encryptPassword(new String(cArray))), 1);
                                                                break;
                                                            }
                                                            BARServer.executeCommand(StringParser.format("ACTION_RESULT errorCode=%d", 13), 1);
                                                            break;
                                                        }
                                                        System.out.println(BARControl.tr("Please enter {0} password for: {1}", new Object[]{passwordTypes, string}));
                                                        char[] cArray = console.readPassword("  " + BARControl.tr("Password", new Object[0]) + ": ", new Object[0]);
                                                        if (cArray != null && cArray.length > 0) {
                                                            BARServer.executeCommand(StringParser.format("ACTION_RESULT errorCode=%d encryptType=%s encryptedPassword=%S", 0, BARServer.getPasswordEncryptType(), BARServer.encryptPassword(new String(cArray))), 1);
                                                            break;
                                                        }
                                                        BARServer.executeCommand(StringParser.format("ACTION_RESULT errorCode=%d", 13), 1);
                                                        break;
                                                    }
                                                    case REQUEST_VOLUME: {
                                                        Dprintf.dprintf("still not supported");
                                                        break;
                                                    }
                                                    case CONFIRM: {
                                                        System.err.println(BARControl.tr("Cannot restore ''{0}'': {1} - skipped", !string5.isEmpty() ? string5 : string4, string3));
                                                        BARServer.executeCommand(StringParser.format("ACTION_RESULT errorCode=%d", 0), 1);
                                                    }
                                                }
                                            } else {
                                                RestoreStates restoreStates = valueMap.getEnum("state", RestoreStates.class);
                                                long l = valueMap.getLong("entryDoneSize", 0L);
                                                long l2 = valueMap.getLong("doneSize", 0L);
                                                long l3 = valueMap.getLong("totalCount", 0L);
                                                long l4 = valueMap.getLong("totalSize", 0L);
                                                String string = valueMap.getString("entryName", "");
                                                long l5 = valueMap.getLong("entryDoneSize", 0L);
                                                long l6 = valueMap.getLong("entryTotalSize", 0L);
                                                String string7 = valueMap.getString("storageName", "");
                                                long l7 = valueMap.getLong("storageDoneSize", 0L);
                                                long l8 = valueMap.getLong("storageTotalSize", 0L);
                                                switch (restoreStates) {
                                                    case RESTORED: {
                                                        System.out.println(String.format(BARControl.tr("Restored {0} entries, {1} bytes", l, l2), new Object[0]));
                                                        break;
                                                    }
                                                    case FAILED: {
                                                        BARControl.printError(BARControl.tr("cannot restore storage ''{0}''", string7), new Object[0]);
                                                    }
                                                }
                                            }
                                        }
                                        catch (Exception exception) {
                                            if (Settings.debugLevel <= 0) break block16;
                                            BARControl.logThrowable(exception);
                                            System.exit(1);
                                        }
                                    }
                                }
                            });
                        }
                        catch (Exception exception) {
                            BARControl.printError(BARControl.tr("cannot restore storages (error: {0})", exception.getMessage()), new Object[0]);
                            BARServer.disconnect();
                            System.exit(1);
                        }
                    }
                    if (Settings.debugQuitServerFlag && !BARServer.quit()) {
                        BARControl.printError(BARControl.tr("cannot quit server", new Object[0]), new Object[0]);
                        BARServer.disconnect();
                        System.exit(1);
                    }
                    break block136;
                }
                if (Settings.debugLevel > 0) {
                    Device.DEBUG = true;
                }
                display = new Display();
                IMAGE_ERROR = Widgets.loadImage(display, "error.png");
                IMAGE_LOCK = Widgets.loadImage(display, "lock.png");
                IMAGE_LOCK_INSECURE = Widgets.loadImage(display, "lockInsecure.png");
                boolean bl = false;
                if (!this.login(this.loginData, Settings.loginDialogFlag)) {
                    System.exit(1);
                }
                Settings.serverNoTLS = this.loginData.tlsMode == BARServer.TLSModes.NONE;
                Settings.serverForceTLS = this.loginData.tlsMode == BARServer.TLSModes.FORCE;
                Settings.role = this.loginData.role;
                do {
                    this.initClassesWatchDog();
                    this.createWindow();
                    this.createTabs();
                    this.createMenu();
                    Widgets.notify(shell, 65535);
                    this.run();
                } while (!this.quitFlag);
                BARServer.disconnect();
                Settings.save();
            }
            catch (SWTException sWTException) {
                BARControl.printInternalError(sWTException.getCause());
                System.exit(127);
            }
            catch (CommunicationError communicationError) {
                try {
                    Dialogs.error(new Shell(), communicationError.getMessage());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                BARControl.printError(BARControl.tr("communication: {0}", communicationError.getMessage()), new Object[0]);
                if (Settings.debugLevel > 0) {
                    BARControl.printStackTrace(communicationError);
                }
                System.exit(1);
            }
            catch (AssertionError assertionError) {
                BARControl.internalError((Throwable)((Object)assertionError));
            }
            catch (InternalError internalError) {
                BARControl.internalError(internalError);
            }
            catch (Throwable throwable) {
                BARControl.printError(throwable);
                if (Settings.debugLevel > 0) {
                    BARControl.printStackTrace(throwable);
                }
                System.exit(1);
            }
        }
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        new BARControl(stringArray);
    }

    static {
        ARCHIVE_TYPE_ENUMERATION = new OptionEnumeration[]{new OptionEnumeration("normal", (Object)ArchiveTypes.NORMAL), new OptionEnumeration("full", (Object)ArchiveTypes.FULL), new OptionEnumeration("incremental", (Object)ArchiveTypes.INCREMENTAL), new OptionEnumeration("differential", (Object)ArchiveTypes.DIFFERENTIAL)};
        ROLE_ENUMERATION = new OptionEnumeration[]{new OptionEnumeration("basic", (Object)Roles.BASIC), new OptionEnumeration("normal", (Object)Roles.NORMAL), new OptionEnumeration("expert", (Object)Roles.EXPERT)};
        OPTION_GEOMETRY = new OptionSpecial(){

            @Override
            public void parse(String string, Object object) {
                Pattern pattern = Pattern.compile("^(\\d+)x(\\d+)$", 2);
                Pattern pattern2 = Pattern.compile("^\\+(\\d+)\\+(\\d+)$", 2);
                Pattern pattern3 = Pattern.compile("^(\\d+)x(\\d+)\\+(\\d+)\\+(\\d+)$", 2);
                Settings.Geometry geometry = (Settings.Geometry)object;
                Matcher matcher = pattern.matcher(string);
                if (matcher.matches()) {
                    geometry.width = Integer.parseInt(matcher.group(1));
                    geometry.height = Integer.parseInt(matcher.group(2));
                } else {
                    matcher = pattern2.matcher(string);
                    if (matcher.matches()) {
                        geometry.x = Integer.parseInt(matcher.group(1));
                        geometry.y = Integer.parseInt(matcher.group(2));
                    } else {
                        matcher = pattern3.matcher(string);
                        if (matcher.matches()) {
                            geometry.width = Integer.parseInt(matcher.group(1));
                            geometry.height = Integer.parseInt(matcher.group(2));
                            geometry.x = Integer.parseInt(matcher.group(3));
                            geometry.y = Integer.parseInt(matcher.group(4));
                        } else {
                            throw new Error("Invalid geometry '" + string + "'");
                        }
                    }
                }
            }
        };
        OPTIONS = new Option[]{new Option("--config", null, Options.Types.STRING, "configFileName"), new Option("--port", "-p", Options.Types.INTEGER, "serverPort"), new Option("--tls-port", null, Options.Types.INTEGER, "serverTLSPort"), new Option("--ca-file", null, Options.Types.STRING, "serverCAFileName"), new Option("--keystore-file", null, Options.Types.STRING, "serverKeystoreFileName"), new Option("--no-tls", null, Options.Types.BOOLEAN, "serverNoTLS"), new Option("--force-tls", null, Options.Types.BOOLEAN, "serverForceTLS"), new Option("--insecure-tls", null, Options.Types.BOOLEAN, "serverInsecureTLS"), new Option("--password", null, Options.Types.STRING, "serverPassword"), new Option("--login-dialog", null, Options.Types.BOOLEAN, "loginDialogFlag"), new Option("--pair-master", null, Options.Types.BOOLEAN, "pairMasterFlag"), new Option("--select-job", null, Options.Types.STRING, "selectedJobName"), new Option("--job", "-j", Options.Types.STRING, "runJobNames"), new Option("--archive-type", null, Options.Types.ENUMERATION, "archiveType", ARCHIVE_TYPE_ENUMERATION), new Option("--abort", null, Options.Types.STRING, "abortJobName"), new Option("--pause", "-t", Options.Types.INTEGER, "pauseTime", new Object[]{"s", 1, "m", 60, "h", 3600}), new Option("--maintenance", "-m", Options.Types.INTEGER, "maintenanceTime", new Object[]{"s", 1, "seconds", 1, "m", 60, "min", 60, "minutes", 60, "h", 3600, "hours", 3600}), new Option("--ping", "-i", Options.Types.BOOLEAN, "pingFlag"), new Option("--suspend", "-s", Options.Types.BOOLEAN, "suspendFlag"), new Option("--continue", "-c", Options.Types.BOOLEAN, "continueFlag"), new Option("--list", null, Options.Types.BOOLEAN, "listJobsFlag"), new Option("--list-jobs", "-l", Options.Types.BOOLEAN, "listJobsFlag"), new Option("--list-schedules", null, Options.Types.BOOLEAN, "listSchedulesFlag"), new Option("--info", null, Options.Types.STRING, "infoJobName"), new Option("--index-database-info", null, Options.Types.BOOLEAN, "indexDatabaseInfo"), new Option("--index-database-add", null, Options.Types.STRING, "indexDatabaseAddStorageName"), new Option("--index-database-remove", null, Options.Types.STRING, "indexDatabaseRemoveStorageName"), new Option("--index-database-refresh", null, Options.Types.STRING, "indexDatabaseRefreshStorageName"), new Option("--index-database-entities-list", "-n", Options.Types.STRING, "indexDatabaseEntitiesListName", ""), new Option("--index-database-storages-list", "-a", Options.Types.STRING, "indexDatabaseStoragesListName", ""), new Option("--index-database-entries-list", "-e", Options.Types.STRING, "indexDatabaseEntriesListName", ""), new Option("--index-database-entries-newest", null, Options.Types.BOOLEAN, "indexDatabaseEntriesListNewestOnly"), new Option("--index-database-history-list", null, Options.Types.BOOLEAN, "indexDatabaseHistoryList"), new Option("--restore", null, Options.Types.STRING, "restoreStorageName"), new Option("--destination", null, Options.Types.STRING, "destination"), new Option("--overwrite-entries", null, Options.Types.BOOLEAN, "overwriteEntriesFlag"), new Option("--role", null, Options.Types.ENUMERATION, "role", ROLE_ENUMERATION), new Option("--geometry", null, Options.Types.SPECIAL, "geometry", OPTION_GEOMETRY), new Option("--long-format", "-L", Options.Types.BOOLEAN, "longFormatFlag"), new Option("--no-header-footer", null, Options.Types.BOOLEAN, "noHeaderFooterFlag"), new Option("--version", null, Options.Types.BOOLEAN, "versionFlag"), new Option("--help", "-h", Options.Types.BOOLEAN, "helpFlag"), new Option("--xhelp", null, Options.Types.BOOLEAN, "xhelpFlag"), new Option("--debug", "-d", Options.Types.INCREMENT, "debugLevel"), new Option("--debug-ignore-protocol-version", null, Options.Types.BOOLEAN, "debugIgnoreProtocolVersion"), new Option("--debug-fake-tls", null, Options.Types.BOOLEAN, "debugFakeTLSFlag"), new Option("--debug-quit-server", null, Options.Types.BOOLEAN, "debugQuitServerFlag"), new Option("--debug-no-version-info", null, Options.Types.BOOLEAN, "debugNoVersionInfoFlag"), new Option("--no-ssl", null, Options.Types.BOOLEAN, "serverNoTLS"), new Option("--force-ssl", null, Options.Types.BOOLEAN, "serverForceTLS"), new Option("--swing", null, Options.Types.BOOLEAN, null)};
        waitCursorCount = 0;
        String string = System.getProperty("os.name").toLowerCase();
        hostSystem = string.indexOf("linux") >= 0 ? HostSystems.LINUX : (string.indexOf("solaris") >= 0 ? HostSystems.SOLARIS : (string.indexOf("mac") >= 0 ? HostSystems.MACOS : (string.indexOf("win") >= 0 ? HostSystems.WINDOWS : HostSystems.LINUX)));
        ALL_FILE_EXTENSION = "*";
    }

    static enum RestoreStates {
        RUNNING,
        RESTORED,
        FAILED;

    }

    static enum EntryTypes {
        FILE,
        IMAGE,
        DIRECTORY,
        LINK,
        HARDLINK,
        SPECIAL,
        DEVICE,
        SOCKET;

    }

    static enum IndexModes {
        MANUAL,
        AUTO,
        UNKNOWN;

    }

    static enum IndexStates {
        NONE,
        OK,
        CREATE,
        UPDATE_REQUESTED,
        UPDATE,
        ERROR,
        UNKNOWN;

    }

    public static enum HostSystems {
        UNKNOWN,
        LINUX,
        SOLARIS,
        WINDOWS,
        MACOS;

    }

    public static enum Roles {
        BASIC,
        NORMAL,
        EXPERT;

    }

    static class EntryInfo {
        EntryTypes entryType;
        long entryId;
        String storageName;
        File file;
        Image image;
        Directory directory;
        Link link;
        HardLink hardLink;
        Special special;

        EntryInfo() {
        }

        public static EntryInfo newFile(long l, String string, String string2, long l2, long l3, long l4) {
            EntryInfo entryInfo = new EntryInfo();
            entryInfo.entryType = EntryTypes.FILE;
            entryInfo.entryId = l;
            entryInfo.storageName = string;
            entryInfo.file = entryInfo.new File();
            entryInfo.file.name = string2;
            entryInfo.file.size = l2;
            entryInfo.file.dateTime = l3;
            entryInfo.file.fragmentCount = l4;
            return entryInfo;
        }

        public static EntryInfo newImage(long l, String string, String string2, long l2, long l3, long l4) {
            EntryInfo entryInfo = new EntryInfo();
            entryInfo.entryType = EntryTypes.IMAGE;
            entryInfo.entryId = l;
            entryInfo.storageName = string;
            entryInfo.image = entryInfo.new Image();
            entryInfo.image.name = string2;
            entryInfo.image.size = l2;
            entryInfo.image.blockOffset = l3;
            entryInfo.image.blockCount = l4;
            return entryInfo;
        }

        public static EntryInfo newDirectory(long l, String string, String string2, long l2) {
            EntryInfo entryInfo = new EntryInfo();
            entryInfo.entryType = EntryTypes.DIRECTORY;
            entryInfo.entryId = l;
            entryInfo.storageName = string;
            entryInfo.directory = entryInfo.new Directory();
            entryInfo.directory.name = string2;
            entryInfo.directory.dateTime = l2;
            return entryInfo;
        }

        public static EntryInfo newLink(long l, String string, String string2, String string3) {
            EntryInfo entryInfo = new EntryInfo();
            entryInfo.entryType = EntryTypes.LINK;
            entryInfo.entryId = l;
            entryInfo.storageName = string;
            entryInfo.link = entryInfo.new Link();
            entryInfo.link.name = string2;
            entryInfo.link.destinationName = string3;
            return entryInfo;
        }

        public static EntryInfo newHardLink(long l, String string, String string2, long l2, long l3, long l4) {
            EntryInfo entryInfo = new EntryInfo();
            entryInfo.entryType = EntryTypes.HARDLINK;
            entryInfo.entryId = l;
            entryInfo.storageName = string;
            entryInfo.hardLink = entryInfo.new HardLink();
            entryInfo.hardLink.name = string2;
            entryInfo.hardLink.size = l2;
            entryInfo.hardLink.dateTime = l3;
            entryInfo.hardLink.fragmentCount = l4;
            return entryInfo;
        }

        public static EntryInfo newSpecial(long l, String string, String string2, long l2) {
            EntryInfo entryInfo = new EntryInfo();
            entryInfo.entryType = EntryTypes.SPECIAL;
            entryInfo.entryId = l;
            entryInfo.storageName = string;
            entryInfo.special = entryInfo.new Special();
            entryInfo.special.name = string2;
            entryInfo.special.dateTime = l2;
            return entryInfo;
        }

        class Special {
            String name;
            long dateTime;

            Special() {
            }
        }

        class HardLink {
            String name;
            long size;
            long dateTime;
            long fragmentCount;

            HardLink() {
            }
        }

        class Link {
            String name;
            String destinationName;
            long dateTime;

            Link() {
            }
        }

        class Directory {
            String name;
            long dateTime;

            Directory() {
            }
        }

        class Image {
            String name;
            long size;
            long blockOffset;
            long blockCount;

            Image() {
            }
        }

        class File {
            String name;
            long size;
            long dateTime;
            long fragmentCount;

            File() {
            }
        }
    }

    class ScheduleInfo {
        static final int NONE = 0;
        static final int ANY = -1;
        static final int MON = 0;
        static final int TUE = 1;
        static final int WED = 2;
        static final int THU = 3;
        static final int FRI = 4;
        static final int SAT = 5;
        static final int SUN = 6;
        String jobName;
        String uuid;
        int year;
        int month;
        int day;
        int weekDays;
        int hour;
        int minute;
        ArchiveTypes archiveType;
        int interval;
        int beginHour;
        int beginMinute;
        int endHour;
        int endMinute;
        String customText;
        boolean testCreatedArchives;
        boolean noStorage;
        boolean enabled;
        long lastExecutedDateTime;
        long nextExecutedDateTime;
        long totalEntities;
        long totalEntryCount;
        long totalEntrySize;

        ScheduleInfo(String string, String string2, int n, int n2, int n3, int n4, int n5, int n6, ArchiveTypes archiveTypes, int n7, int n8, int n9, int n10, int n11, String string3, boolean bl, boolean bl2, boolean bl3, long l, long l2, long l3, long l4, long l5) {
            this.jobName = string;
            this.uuid = string2;
            this.year = n;
            this.month = n2;
            this.day = n3;
            this.weekDays = n4;
            this.hour = n5;
            this.minute = n6;
            this.archiveType = archiveTypes;
            this.interval = n7;
            this.beginHour = n8;
            this.beginMinute = n9;
            this.endHour = n10;
            this.endMinute = n11;
            this.customText = string3;
            this.testCreatedArchives = bl;
            this.noStorage = bl2;
            this.enabled = bl3;
            this.lastExecutedDateTime = l;
            this.nextExecutedDateTime = l2;
            this.totalEntities = l3;
            this.totalEntryCount = l4;
            this.totalEntrySize = l5;
        }

        ScheduleInfo(String string, String string2, String string3, String string4, String string5, ArchiveTypes archiveTypes, int n, String string6, String string7, String string8, boolean bl, boolean bl2, boolean bl3, long l, long l2, long l3, long l4, long l5) {
            this.jobName = string;
            this.uuid = string2;
            this.setDate(string3);
            this.setWeekDays(string4);
            this.setTime(string5);
            this.archiveType = archiveTypes;
            this.interval = n;
            this.setBeginTime(string6);
            this.setEndTime(string7);
            this.customText = string8;
            this.testCreatedArchives = bl;
            this.noStorage = bl2;
            this.enabled = bl3;
            this.lastExecutedDateTime = l;
            this.nextExecutedDateTime = l2;
            this.totalEntities = l3;
            this.totalEntryCount = l4;
            this.totalEntrySize = l5;
        }

        String getDate() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getYear());
            stringBuilder.append('-');
            stringBuilder.append(this.getMonth());
            stringBuilder.append('-');
            stringBuilder.append(this.getDay());
            return stringBuilder.toString();
        }

        private void setDate(String string, String string2, String string3) {
            this.year = !string.equals("*") ? Integer.parseInt(string) : -1;
            this.month = !string2.equals("*") ? Integer.parseInt(string2) : -1;
            int n = this.day = !string3.equals("*") ? Integer.parseInt(string3) : -1;
            assert (this.year == -1 || this.year >= 0) : this.hour;
            assert (this.month == -1 || this.month >= 1 && this.month <= 12) : this.hour;
            assert (this.day == -1 || this.day >= 1 && this.day <= 31) : this.hour;
        }

        private void setDate(String string) {
            String[] stringArray = string.split("-");
            this.setDate(stringArray[0], stringArray[1], stringArray[2]);
        }

        String getYear() {
            assert (this.year == -1 || this.year >= 1) : this.year;
            return this.year != -1 ? String.format("%04d", this.year) : "*";
        }

        String getMonth() {
            assert (this.month == -1 || this.month >= 1 && this.month <= 12) : this.month;
            return this.month != -1 ? String.format("%02d", this.month) : "*";
        }

        String getDay() {
            assert (this.day == -1 || this.day >= 1 && this.day <= 31) : this.day;
            return this.day != -1 ? String.format("%02d", this.day) : "*";
        }

        String getWeekDays() {
            assert (this.weekDays == -1 || (this.weekDays & 0xFFFFFF80) == 0) : this.weekDays;
            if (this.weekDays == -1) {
                return "*";
            }
            StringBuilder stringBuilder = new StringBuilder();
            if ((this.weekDays & 1) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(BARControl.tr("Mon", new Object[0]));
            }
            if ((this.weekDays & 2) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(BARControl.tr("Tue", new Object[0]));
            }
            if ((this.weekDays & 4) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(BARControl.tr("Wed", new Object[0]));
            }
            if ((this.weekDays & 8) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(BARControl.tr("Thu", new Object[0]));
            }
            if ((this.weekDays & 0x10) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(BARControl.tr("Fri", new Object[0]));
            }
            if ((this.weekDays & 0x20) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(BARControl.tr("Sat", new Object[0]));
            }
            if ((this.weekDays & 0x40) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(BARControl.tr("Sun", new Object[0]));
            }
            return stringBuilder.toString();
        }

        void setWeekDays(String string) {
            if (string.equals("*")) {
                this.weekDays = -1;
            } else {
                this.weekDays = 0;
                for (String string2 : string.split(",")) {
                    if (string2.toLowerCase().equals("mon")) {
                        this.weekDays |= 1;
                        continue;
                    }
                    if (string2.toLowerCase().equals("tue")) {
                        this.weekDays |= 2;
                        continue;
                    }
                    if (string2.toLowerCase().equals("wed")) {
                        this.weekDays |= 4;
                        continue;
                    }
                    if (string2.toLowerCase().equals("thu")) {
                        this.weekDays |= 8;
                        continue;
                    }
                    if (string2.toLowerCase().equals("fri")) {
                        this.weekDays |= 0x10;
                        continue;
                    }
                    if (string2.toLowerCase().equals("sat")) {
                        this.weekDays |= 0x20;
                        continue;
                    }
                    if (!string2.toLowerCase().equals("sun")) continue;
                    this.weekDays |= 0x40;
                }
            }
        }

        void setWeekDays(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
            if (bl && bl2 && bl3 && bl4 && bl5 && bl6 && bl7) {
                this.weekDays = -1;
            } else {
                this.weekDays = 0;
                if (bl) {
                    this.weekDays |= 1;
                }
                if (bl2) {
                    this.weekDays |= 2;
                }
                if (bl3) {
                    this.weekDays |= 4;
                }
                if (bl4) {
                    this.weekDays |= 8;
                }
                if (bl5) {
                    this.weekDays |= 0x10;
                }
                if (bl6) {
                    this.weekDays |= 0x20;
                }
                if (bl7) {
                    this.weekDays |= 0x40;
                }
            }
        }

        String getHour() {
            assert (this.hour == -1 || this.hour >= 0 && this.hour <= 23) : this.hour;
            return this.hour != -1 ? String.format("%02d", this.hour) : "*";
        }

        String getMinute() {
            assert (this.minute == -1 || this.minute >= 0 && this.minute <= 59) : this.minute;
            return this.minute != -1 ? String.format("%02d", this.minute) : "*";
        }

        String getTime() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getHour());
            stringBuilder.append(':');
            stringBuilder.append(this.getMinute());
            return stringBuilder.toString();
        }

        void setTime(String string, String string2) {
            this.hour = !string.equals("*") ? Integer.parseInt(string, 10) : -1;
            int n = this.minute = !string2.equals("*") ? Integer.parseInt(string2, 10) : -1;
            assert (this.hour == -1 || this.hour >= 0 && this.hour <= 23) : this.hour;
            assert (this.minute == -1 || this.minute >= 0 && this.minute <= 59) : this.minute;
        }

        void setTime(String string) {
            String[] stringArray = string.split(":");
            this.setTime(stringArray[0], stringArray[1]);
        }

        ArchiveTypes getArchiveType() {
            return this.archiveType;
        }

        String getBeginHour() {
            assert (this.beginHour == -1 || this.beginHour >= 0 && this.beginHour <= 23) : this.beginHour;
            return this.beginHour != -1 ? String.format("%02d", this.beginHour) : "*";
        }

        String getBeginMinute() {
            assert (this.endMinute == -1 || this.endMinute >= 0 && this.endMinute <= 59) : this.endMinute;
            return this.endMinute != -1 ? String.format("%02d", this.endMinute) : "*";
        }

        String getBeginTime() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getBeginHour());
            stringBuilder.append(':');
            stringBuilder.append(this.getBeginMinute());
            return stringBuilder.toString();
        }

        void setBeginTime(String string, String string2) {
            this.beginHour = !string.equals("*") ? Integer.parseInt(string, 10) : -1;
            int n = this.beginMinute = !string2.equals("*") ? Integer.parseInt(string2, 10) : -1;
            assert (this.beginHour == -1 || this.beginHour >= 0 && this.beginHour <= 23) : this.beginHour;
            assert (this.beginMinute == -1 || this.beginMinute >= 0 && this.beginMinute <= 59) : this.beginMinute;
        }

        void setBeginTime(String string) {
            String[] stringArray = string.split(":");
            this.setBeginTime(stringArray[0], stringArray[1]);
        }

        String getEndHour() {
            assert (this.endHour == -1 || this.endHour >= 0 && this.endHour <= 23) : this.endHour;
            return this.endHour != -1 ? String.format("%02d", this.endHour) : "*";
        }

        String getEndMinute() {
            assert (this.endMinute == -1 || this.endMinute >= 0 && this.endMinute <= 59) : this.endMinute;
            return this.endMinute != -1 ? String.format("%02d", this.endMinute) : "*";
        }

        String getEndTime() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getEndHour());
            stringBuilder.append(':');
            stringBuilder.append(this.getEndMinute());
            return stringBuilder.toString();
        }

        void setEndTime(String string, String string2) {
            this.endHour = !string.equals("*") ? Integer.parseInt(string, 10) : -1;
            int n = this.endMinute = !string2.equals("*") ? Integer.parseInt(string2, 10) : -1;
            assert (this.endHour == -1 || this.endHour >= 0 && this.endHour <= 23) : this.endHour;
            assert (this.endMinute == -1 || this.endMinute >= 0 && this.endMinute <= 59) : this.endMinute;
        }

        void setEndTime(String string) {
            String[] stringArray = string.split(":");
            this.setEndTime(stringArray[0], stringArray[1]);
        }

        private void setLastExecutedDateTime(String string, String string2, String string3, String string4, String string5) {
            this.year = !string.equals("*") ? Integer.parseInt(string) : -1;
            this.month = !string2.equals("*") ? Integer.parseInt(string2) : -1;
            int n = this.day = !string3.equals("*") ? Integer.parseInt(string3) : -1;
            assert (this.year == -1 || this.year >= 0) : this.hour;
            assert (this.month == -1 || this.month >= 1 && this.month <= 12) : this.hour;
            assert (this.day == -1 || this.day >= 1 && this.day <= 31) : this.hour;
            this.hour = !string4.equals("*") ? Integer.parseInt(string4, 10) : -1;
            int n2 = this.minute = !string5.equals("*") ? Integer.parseInt(string5, 10) : -1;
            assert (this.hour == -1 || this.hour >= 0 && this.hour <= 23) : this.hour;
            assert (this.minute == -1 || this.minute >= 0 && this.minute <= 59) : this.minute;
        }

        private void setNextExecutedDateTime(String string, String string2, String string3, String string4, String string5) {
            this.year = !string.equals("*") ? Integer.parseInt(string) : -1;
            this.month = !string2.equals("*") ? Integer.parseInt(string2) : -1;
            int n = this.day = !string3.equals("*") ? Integer.parseInt(string3) : -1;
            assert (this.year == -1 || this.year >= 0) : this.hour;
            assert (this.month == -1 || this.month >= 1 && this.month <= 12) : this.hour;
            assert (this.day == -1 || this.day >= 1 && this.day <= 31) : this.hour;
            this.hour = !string4.equals("*") ? Integer.parseInt(string4, 10) : -1;
            int n2 = this.minute = !string5.equals("*") ? Integer.parseInt(string5, 10) : -1;
            assert (this.hour == -1 || this.hour >= 0 && this.hour <= 23) : this.hour;
            assert (this.minute == -1 || this.minute >= 0 && this.minute <= 59) : this.minute;
        }

        public String toString() {
            return "ScheduleInfo {" + this.jobName + ", " + this.uuid + ", " + this.getDate() + ", " + this.getWeekDays() + ", " + this.getTime() + ", " + (Object)((Object)this.archiveType) + ", " + this.noStorage + ", " + this.enabled + ", " + this.lastExecutedDateTime + ", " + this.nextExecutedDateTime + "}";
        }
    }

    class JobInfo {
        String jobUUID;
        String name;
        JobData.States state;
        String slaveHostName;
        JobData.SlaveStates slaveState;
        String archiveType;
        long archivePartSize;
        String deltaCompressAlgorithm;
        String byteCompressAlgorithm;
        String cryptAlgorithm;
        String cryptType;
        String cryptPasswordMode;
        long lastExecutedDateTime;
        long estimatedRestTime;

        JobInfo(String string, String string2, JobData.States states, String string3, JobData.SlaveStates slaveStates, String string4, long l, String string5, String string6, String string7, String string8, String string9, long l2, long l3) {
            this.jobUUID = string;
            this.name = string2;
            this.state = states;
            this.slaveHostName = string3;
            this.slaveState = slaveStates;
            this.archiveType = string4;
            this.archivePartSize = l;
            this.deltaCompressAlgorithm = string5;
            this.byteCompressAlgorithm = string6;
            this.cryptAlgorithm = string7;
            this.cryptType = string8;
            this.cryptPasswordMode = string9;
            this.lastExecutedDateTime = l2;
            this.estimatedRestTime = l3;
        }
    }

    class LoginData {
        String name;
        int port;
        int tlsPort;
        BARServer.TLSModes tlsMode;
        String password;
        Roles role;

        LoginData(String string, int n, int n2, BARServer.TLSModes tLSModes, String string2, Roles roles) {
            Settings.Server server = Settings.getLastServer();
            String string3 = !string.isEmpty() ? string : (this.name = server != null ? server.name : "localhost");
            int n3 = n != 0 ? n : (this.port = server != null ? server.port : 38523);
            this.tlsPort = n != 0 ? n2 : (server != null ? server.port : 0);
            this.tlsMode = tLSModes;
            this.password = !string2.isEmpty() ? string2 : "";
            this.role = roles;
        }

        LoginData(String string, int n, int n2, BARServer.TLSModes tLSModes, Roles roles) {
            this(string, n, n2, tLSModes, "", roles);
        }

        LoginData(int n, int n2, BARServer.TLSModes tLSModes, Roles roles) {
            this("", n, n2, tLSModes, roles);
        }

        public String toString() {
            return "LoginData {" + this.name + ", " + this.port + ", " + this.tlsPort + ", " + (Object)((Object)this.tlsMode) + "}";
        }
    }
}

