/*
 * Decompiled with CFR 0.152.
 */
class BARException
extends Exception {
    public static final int NONE = 0;
    public static final int INSUFFICIENT_MEMORY = 1;
    public static final int INIT = 2;
    public static final int INVALID_ARGUMENT = 3;
    public static final int CONFIG = 4;
    public static final int NO_WRITABLE_CONFIG = 5;
    public static final int ABORTED = 6;
    public static final int INTERRUPTED = 7;
    public static final int FUNCTION_NOT_SUPPORTED = 8;
    public static final int STILL_NOT_IMPLEMENTED = 9;
    public static final int RUN_SERVICE = 10;
    public static final int IPC = 11;
    public static final int INIT_PASSWORD = 12;
    public static final int NO_PASSWORD = 13;
    public static final int INVALID_PASSWORD_ = 14;
    public static final int PROCESS = 15;
    public static final int ERROR_INVALID_ENCODING = 16;
    public static final int CONVERT_CHARS = 17;
    public static final int INVALID_PATTERN = 18;
    public static final int NO_HOST_NAME = 19;
    public static final int HOST_NOT_FOUND = 20;
    public static final int BIND_FAIL = 21;
    public static final int CONNECT_FAIL = 22;
    public static final int CONNECT_TIMEOUT = 23;
    public static final int DISCONNECTED = 24;
    public static final int TOO_MANY_CONNECTIONS = 25;
    public static final int NO_LOGIN_NAME = 26;
    public static final int NO_LOGIN_PASSWORD = 27;
    public static final int NETWORK_SEND = 28;
    public static final int NETWORK_RECEIVE = 29;
    public static final int NETWORK_EXECUTE_FAIL = 30;
    public static final int NETWORK_TIMEOUT_SEND = 31;
    public static final int NETWORK_TIMEOUT_RECEIVE = 32;
    public static final int NO_RESPONSE = 33;
    public static final int INVALID_RESPONSE = 34;
    public static final int BAD_REQUEST = 35;
    public static final int INIT_TLS = 36;
    public static final int NO_TLS_CA = 37;
    public static final int NO_TLS_CERTIFICATE = 38;
    public static final int NO_TLS_KEY = 39;
    public static final int INVALID_TLS_CA = 40;
    public static final int INVALID_TLS_CERTIFICATE = 41;
    public static final int READ_CERTIFICATE_FAIL = 42;
    public static final int CORRUPT_CERTIFICATE = 43;
    public static final int TLS_CERTIFICATE_EXPIRED = 44;
    public static final int TLS_CERTIFICATE_NOT_ACTIVE = 45;
    public static final int TLS_HANDSHAKE = 46;
    public static final int INVALID_SSH_SPECIFIER = 47;
    public static final int NO_SSH_PUBLIC_KEY = 48;
    public static final int NO_SSH_PRIVATE_KEY = 49;
    public static final int NO_SSH_PASSWORD = 50;
    public static final int INVALID_SSH_PASSWORD = 51;
    public static final int INVALID_SSH_PRIVATE_KEY = 52;
    public static final int SSH_SESSION_FAIL = 53;
    public static final int SSH_AUTHENTICATION = 54;
    public static final int SSH = 55;
    public static final int INVALID_SMB_SPECIFIER = 56;
    public static final int NO_SMB_PASSWORD = 57;
    public static final int SMB_SESSION_FAIL = 58;
    public static final int SMB_AUTHENTICATION = 59;
    public static final int INVALID_SMB_PASSWORD = 60;
    public static final int SMB = 61;
    public static final int JOB_ALREADY_EXISTS = 62;
    public static final int JOB_RUNNING = 63;
    public static final int CREATE_JOB = 64;
    public static final int DELETE_JOB = 65;
    public static final int RENAME_JOB = 66;
    public static final int INIT_STORAGE = 67;
    public static final int NO_STORAGE_NAME = 68;
    public static final int INVALID_STORAGE = 69;
    public static final int INVALID_FTP_SPECIFIER = 70;
    public static final int FTP_SESSION_FAIL = 71;
    public static final int NO_FTP_PASSWORD = 72;
    public static final int INVALID_FTP_PASSWORD = 73;
    public static final int FTP_AUTHENTICATION = 74;
    public static final int FTP_GET_SIZE = 75;
    public static final int INVALID_WEBDAV_SPECIFIER = 76;
    public static final int WEBDAV_SESSION_FAIL = 77;
    public static final int NO_WEBDAV_PASSWORD = 78;
    public static final int INVALID_WEBDAV_PASSWORD = 79;
    public static final int WEBDAV_AUTHENTICATION = 80;
    public static final int WEBDAV_GET_SIZE = 81;
    public static final int WEBDAV_UPLOAD = 82;
    public static final int WEBDAV_DOWNLOAD = 83;
    public static final int WEBDAV = 84;
    public static final int INIT_COMPRESS = 85;
    public static final int INIT_DECOMPRESS = 86;
    public static final int COMPRESS_EOF = 87;
    public static final int DELTA_SOURCE_NOT_FOUND = 88;
    public static final int INVALID_COMPRESS_ALGORITHM = 89;
    public static final int UNKNOWN_COMPRESS_ALGORITHM = 90;
    public static final int COMPRESS_ALGORITHM_NOT_SUPPORTED = 91;
    public static final int DEFLATE = 92;
    public static final int INFLATE = 93;
    public static final int UNSUPPORTED_BLOCK_LENGTH = 94;
    public static final int INIT_CRYPT = 95;
    public static final int NO_CRYPT_KEY = 96;
    public static final int NO_CRYPT_PASSWORD = 97;
    public static final int INVALID_CRYPT_PASSWORD = 98;
    public static final int CRYPT_PASSWORDS_MISMATCH = 99;
    public static final int INIT_CIPHER = 100;
    public static final int CREATE_KEY_FAIL = 101;
    public static final int INVALID_ENCODING = 102;
    public static final int INIT_KEY = 103;
    public static final int KEY_NOT_FOUND = 104;
    public static final int READ_KEY_FAIL = 105;
    public static final int INVALID_KEY = 106;
    public static final int CORRUPT_KEY = 107;
    public static final int INVALID_KEY_LENGTH = 108;
    public static final int INVALID_BLOCK_LENGTH_ = 109;
    public static final int INVALID_SALT_LENGTH = 110;
    public static final int NO_PUBLIC_CRYPT_KEY = 111;
    public static final int NO_PRIVATE_CRYPT_KEY = 112;
    public static final int NOT_A_PUBLIC_CRYPT_KEY = 113;
    public static final int NOT_A_PRIVATE_CRYPT_KEY = 114;
    public static final int NO_PUBLIC_SIGNATURE_KEY = 115;
    public static final int NO_PRIVATE_SIGNATURE_KEY = 116;
    public static final int NOT_A_PUBLIC_SIGNATURE_KEY = 117;
    public static final int NOT_A_PRIVATE_SIGNATURE_KEY = 118;
    public static final int KEY_ENCRYPT = 119;
    public static final int KEY_DECRYPT = 120;
    public static final int WRONG_PRIVATE_KEY = 121;
    public static final int INVALID_CRYPT_ALGORITHM = 122;
    public static final int UNKNOWN_CRYPT_ALGORITHM = 123;
    public static final int ENCRYPT = 124;
    public static final int DECRYPT = 125;
    public static final int INIT_HASH = 126;
    public static final int INVALID_HASH_ALGORITHM = 127;
    public static final int UNKNOWN_HASH_ALGORITHM = 128;
    public static final int INIT_MAC = 129;
    public static final int INVALID_MAC_ALGORITHM = 130;
    public static final int UNKNOWN_MAC_ALGORITHM = 131;
    public static final int DIRECTORY_NOT_FOUND_ = 132;
    public static final int NO_FILE_NAME = 133;
    public static final int CREATE_FILE = 134;
    public static final int OPEN_FILE = 135;
    public static final int CREATE_DIRECTORY = 136;
    public static final int READ_FILE = 137;
    public static final int END_OF_FILE = 138;
    public static final int WRITE_FILE = 139;
    public static final int DELETE_FILE = 140;
    public static final int OPEN_DIRECTORY = 141;
    public static final int READ_DIRECTORY = 142;
    public static final int FILE_EXISTS_ = 143;
    public static final int FILE_NOT_FOUND_ = 144;
    public static final int FILE_ACCESS_DENIED = 145;
    public static final int NOT_A_DIRECTORY = 146;
    public static final int END_OF_DIRECTORY = 147;
    public static final int INIT_FILE_NOTIFY = 148;
    public static final int INSUFFICIENT_FILE_NOTIFY = 149;
    public static final int IO = 150;
    public static final int OPTICAL_DRIVE_NOT_FOUND = 151;
    public static final int OPEN_OPTICAL_DISK = 152;
    public static final int READ_OPTICAL_DISK = 153;
    public static final int WRITE_OPTICAL_DISK = 154;
    public static final int VERIFY_OPTICAL_DISK = 155;
    public static final int OPEN_ISO9660 = 156;
    public static final int CREATE_ISO9660 = 157;
    public static final int NO_DEVICE_NAME = 158;
    public static final int NOT_A_DEVICE = 159;
    public static final int OPEN_DEVICE = 160;
    public static final int INVALID_DEVICE_BLOCK_SIZE = 161;
    public static final int READ_DEVICE = 162;
    public static final int WRITE_DEVICE = 163;
    public static final int PARSE_DEVICE_LIST = 164;
    public static final int DEVICE_NOT_FOUND = 165;
    public static final int MOUNT = 166;
    public static final int UMOUNT = 167;
    public static final int NO_ARCHIVE_FILE_NAME = 168;
    public static final int NOT_AN_ARCHIVE_FILE = 169;
    public static final int ARCHIVE_NOT_FOUND = 170;
    public static final int END_OF_ARCHIVE = 171;
    public static final int NO_META_ENTRY = 172;
    public static final int NO_FILE_ENTRY = 173;
    public static final int NO_FILE_DATA = 174;
    public static final int NO_DIRECTORY_ENTRY = 175;
    public static final int NO_LINK_ENTRY = 176;
    public static final int NO_HARDLINK_ENTRY = 177;
    public static final int NO_SPECIAL_ENTRY = 178;
    public static final int NO_IMAGE_ENTRY = 179;
    public static final int NO_IMAGE_DATA = 180;
    public static final int END_OF_DATA = 181;
    public static final int INCOMPLETE_ARCHIVE = 182;
    public static final int INSUFFICIENT_SPLIT_NUMBERS = 183;
    public static final int CRC_ = 184;
    public static final int ENTRY_NOT_FOUND = 185;
    public static final int ENTRY_INCOMPLETE = 186;
    public static final int WRONG_ENTRY_TYPE = 187;
    public static final int ENTRIES_DIFFER = 188;
    public static final int CORRUPT_DATA = 189;
    public static final int INVALID_CHUNK_SIZE = 190;
    public static final int UNKNOWN_CHUNK = 191;
    public static final int INVALID_SIGNATURE = 192;
    public static final int NOT_AN_INCREMENTAL_FILE = 193;
    public static final int WRONG_INCREMENTAL_FILE_VERSION = 194;
    public static final int CORRUPT_INCREMENTAL_FILE = 195;
    public static final int INVALID_DEVICE_SPECIFIER = 196;
    public static final int LOAD_VOLUME_FAIL = 197;
    public static final int PARSE_COMMAND = 198;
    public static final int EXPAND_TEMPLATE = 199;
    public static final int IO_REDIRECT_FAIL = 200;
    public static final int EXEC_FAIL = 201;
    public static final int EXEC_TERMINATE = 202;
    public static final int EXEC_TIMEOUT = 203;
    public static final int PARSE = 204;
    public static final int PARSE_DATE = 205;
    public static final int PARSE_TIME = 206;
    public static final int PARSE_WEEKDAYS = 207;
    public static final int PARSE_MAINTENANCE = 208;
    public static final int PARSE_SCHEDULE = 209;
    public static final int UNKNOWN_COMMAND = 210;
    public static final int EXPECTED_PARAMETER = 211;
    public static final int UNKNOWN_VALUE = 212;
    public static final int INVALID_VALUE = 213;
    public static final int DEPRECATED_OR_IGNORED_VALUE = 214;
    public static final int AUTHORIZATION = 215;
    public static final int JOB_NOT_FOUND = 216;
    public static final int SCHEDULE_NOT_FOUND = 217;
    public static final int PERSISTENCE_ID_NOT_FOUND = 218;
    public static final int MAINTENANCE_ID_NOT_FOUND = 219;
    public static final int SERVER_ID_NOT_FOUND = 220;
    public static final int ENTRY_ID_NOT_FOUND = 221;
    public static final int PATTERN_ID_NOT_FOUND = 222;
    public static final int MOUNT_ID_NOT_FOUND = 223;
    public static final int DELTA_SOURCE_ID_NOT_FOUND = 224;
    public static final int DATABASE = 225;
    public static final int DATABASE_INVALID = 226;
    public static final int DATABASE_NOT_SUPPORTED = 227;
    public static final int DATABASE_EXISTS = 228;
    public static final int DATABASE_NOT_FOUND = 229;
    public static final int DATABASE_CONNECT = 230;
    public static final int DATABASE_CONNECTION_LOST = 231;
    public static final int DATABASE_AUTHORIZATION = 232;
    public static final int DATABASE_VERSION = 233;
    public static final int DATABASE_VERSION_UNKNOWN = 234;
    public static final int DATABASE_MISSING_TABLE = 235;
    public static final int DATABASE_MISSING_COLUMN = 236;
    public static final int DATABASE_OBSOLETE_TABLE = 237;
    public static final int DATABASE_OBSOLETE_COLUMN = 238;
    public static final int DATABASE_BIND = 239;
    public static final int DATABASE_TYPE_MISMATCH = 240;
    public static final int DATABASE_CREATE_INDEX = 241;
    public static final int DATABASE_INDEX_NOT_FOUND = 242;
    public static final int DATABASE_INDEX_NOT_READY = 243;
    public static final int DATABASE_INVALID_INDEX = 244;
    public static final int DATABASE_PARSE_ID = 245;
    public static final int DATABASE_LOCKED = 246;
    public static final int DATABASE_BUSY = 247;
    public static final int DATABASE_INTERRUPTED = 248;
    public static final int DATABASE_TIMEOUT = 249;
    public static final int DATABASE_ENTRY_NOT_FOUND = 250;
    public static final int MASTER_DISCONNECTED = 251;
    public static final int SLAVE_DISCONNECTED = 252;
    public static final int NOT_PAIRED = 253;
    public static final int NOT_A_SLAVE = 254;
    public static final int PAR2 = 255;
    public static final int PAR2_INVALID_BLOCK_SIZE = 256;
    public static final int PAR2_BLOCK_SIZE_TOO_SMALL = 257;
    public static final int PAR2_TOO_MANY_BLOCKS = 258;
    public static final int TESTCODE = 259;
    public static final int UNKNOWN = 260;
    public final int code;
    public final int errno;
    public final String data;

    public static int getCode(BARException bARException) {
        return bARException.code;
    }

    public static int getErrno(BARException bARException) {
        return bARException.errno;
    }

    public static String getData(BARException bARException) {
        return bARException.data;
    }

    public static String getText(int n, int n2, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        switch (n) {
            case 260: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("unknown", new Object[0]));
                break;
            }
            case 1: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("insufficient memory", new Object[0]));
                break;
            }
            case 2: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("initialize failed", new Object[0]));
                break;
            }
            case 3: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid argument", new Object[0]));
                break;
            }
            case 4: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("configuration error", new Object[0]));
                break;
            }
            case 5: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no writable configuration file", new Object[0]));
                break;
            }
            case 6: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("aborted", new Object[0]));
                break;
            }
            case 7: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("interrupted", new Object[0]));
                break;
            }
            case 8: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("function not supported", new Object[0]));
                break;
            }
            case 9: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("function still not implemented", new Object[0]));
                break;
            }
            case 10: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("run as daemon/service failed", new Object[0]));
                break;
            }
            case 11: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("inter-process communication failed", new Object[0]));
                break;
            }
            case 12: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("initialize password failed", new Object[0]));
                break;
            }
            case 13: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no password given", new Object[0]));
                break;
            }
            case 14: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid password", new Object[0]));
                break;
            }
            case 15: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("process data failed", new Object[0]));
                break;
            }
            case 16: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid encoding", new Object[0]));
                break;
            }
            case 17: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("convert characters", new Object[0]));
                break;
            }
            case 18: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid pattern", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": '%s'", string);
                break;
            }
            case 19: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no host name given", new Object[0]));
                break;
            }
            case 20: {
                if (!BARException.stringIsEmpty(string)) {
                    BARException.stringFormat(stringBuilder, BARException.sizeof(stringBuilder), "host '%s' not found", string);
                    break;
                }
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("host not found", new Object[0]));
                break;
            }
            case 21: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("bind failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 22: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("connect failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 23: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("connect timeout", new Object[0]));
                break;
            }
            case 24: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("disconnected", new Object[0]));
                break;
            }
            case 25: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("too many concurrent connections", new Object[0]));
                break;
            }
            case 26: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no login name given", new Object[0]));
                break;
            }
            case 27: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no password given", new Object[0]));
                break;
            }
            case 28: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("sending data failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 29: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("receiving data failed", new Object[0]));
                break;
            }
            case 30: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("execute command failed", new Object[0]));
                break;
            }
            case 31: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("timeout send data", new Object[0]));
                break;
            }
            case 32: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("timeout receive data", new Object[0]));
                break;
            }
            case 33: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no response from remote", new Object[0]));
                break;
            }
            case 34: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid response from remote", new Object[0]));
                break;
            }
            case 35: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("bad request", new Object[0]));
                break;
            }
            case 36: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("initialize (TLS/SSL) failed", new Object[0]));
                break;
            }
            case 37: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no (TLS/SSL) certificate authority file", new Object[0]));
                break;
            }
            case 38: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no (TLS/SSL) certificate file", new Object[0]));
                break;
            }
            case 39: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no (TLS/SSL) key file", new Object[0]));
                break;
            }
            case 40: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid (TLS/SSL) certificate authority", new Object[0]));
                break;
            }
            case 41: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid (TLS/SSL) certificate", new Object[0]));
                break;
            }
            case 42: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("read (TLS/SSL) certificate fail", new Object[0]));
                break;
            }
            case 43: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("corrupt (TLS/SSL) certificate", new Object[0]));
                break;
            }
            case 44: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("TLS (SSL) certificate expired", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 45: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("TLS (SSL) certificate is still not active", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 46: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("TLS (SSL) handshake failedure", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 47: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid SSH specifier", new Object[0]));
                break;
            }
            case 48: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no SSH public key", new Object[0]));
                break;
            }
            case 49: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no SSH private key", new Object[0]));
                break;
            }
            case 50: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no SSH password given", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendChar(stringBuilder, BARException.sizeof(stringBuilder), ' ');
                BARException.stringAppend(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("for ''{0}''", string));
                break;
            }
            case 51: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid SSH password", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendChar(stringBuilder, BARException.sizeof(stringBuilder), ' ');
                BARException.stringAppend(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("for ''{0}''", string));
                break;
            }
            case 52: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid SSH private key", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s (code: %d)", string, n2);
                break;
            }
            case 53: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("initialize SSH session failed", new Object[0]));
                break;
            }
            case 54: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("SSH authentication failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s (code: %d)", string, n2);
                break;
            }
            case 55: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("ssh protocol error", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s (code: %d)", string, n2);
                break;
            }
            case 56: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid SMB/CIFS specifier", new Object[0]));
                break;
            }
            case 57: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no SMB/CIFS password given", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendChar(stringBuilder, BARException.sizeof(stringBuilder), ' ');
                BARException.stringAppend(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("for ''{0}''", string));
                break;
            }
            case 58: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("initialize SMB/CIFS session failed", new Object[0]));
                break;
            }
            case 59: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("SMB/CIFS authentication failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s (code: %d)", string, n2);
                break;
            }
            case 60: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid SMB/CIFS password", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendChar(stringBuilder, BARException.sizeof(stringBuilder), ' ');
                BARException.stringAppend(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("for ''{0}''", string));
                break;
            }
            case 61: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("SMB/CIFS protocol error", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s (code: %d)", string, n2);
                break;
            }
            case 62: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("job ''{0}'' already exists", string));
                break;
            }
            case 63: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("job ''{0}'' running", string));
                break;
            }
            case 64: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("create job failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 65: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("delete job failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 66: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("rename job failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 67: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("initialize storage failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 68: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no storage name given", new Object[0]));
                break;
            }
            case 69: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid storage", new Object[0]));
                break;
            }
            case 70: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid FTP specifier", new Object[0]));
                break;
            }
            case 71: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("initialize FTP session failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 72: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no FTP password given", new Object[0]));
                break;
            }
            case 73: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid FTP password", new Object[0]));
                break;
            }
            case 74: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid FTP user/password", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 75: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("get FTP file size failed", new Object[0]));
                break;
            }
            case 76: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid WebDAV specifier", new Object[0]));
                break;
            }
            case 77: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("initialize WebDAV session failed", new Object[0]));
                break;
            }
            case 78: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no WebDAV password given", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendChar(stringBuilder, BARException.sizeof(stringBuilder), ' ');
                BARException.stringAppend(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("for ''{0}''", string));
                break;
            }
            case 79: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid WebDAV password", new Object[0]));
                break;
            }
            case 80: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid WebDAV user/password", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 81: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("get WebDAV file size", new Object[0]));
                if (!BARException.stringIsEmpty(string)) {
                    BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), " %s", string);
                }
                BARException.stringAppend(stringBuilder, BARException.sizeof(stringBuilder), " ");
                BARException.stringAppend(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("failed", new Object[0]));
                break;
            }
            case 82: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("WebDAV upload failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 83: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("WebDAV download failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 84: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("WebDAV failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s (code: %d)", string, n2);
                break;
            }
            case 85: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("initialize compress failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 86: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("initialize decompress failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 87: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("end of compressed file", new Object[0]));
                break;
            }
            case 88: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("delta source not found", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": '%s'", string);
                break;
            }
            case 89: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid compress algorithm", new Object[0]));
                break;
            }
            case 90: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("unknown compress algorithm", new Object[0]));
                break;
            }
            case 91: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("compress algorithm not supported", new Object[0]));
                break;
            }
            case 92: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("compress failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s (code: %d)", string, n2);
                break;
            }
            case 93: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("decompress failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s (code: %d)", string, n2);
                break;
            }
            case 94: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("unsupported block length", new Object[0]));
                break;
            }
            case 95: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("initialize crypt failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 96: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no crypt key for cipher", new Object[0]));
                break;
            }
            case 97: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no password given for cipher", new Object[0]));
                break;
            }
            case 98: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid decryption password", new Object[0]));
                break;
            }
            case 99: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("encryption passwords mismatch", new Object[0]));
                break;
            }
            case 100: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("initialize cipher failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 101: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("create public/private key failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 102: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid encoding", new Object[0]));
                break;
            }
            case 103: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("initialize key failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 104: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("public/private key not found", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 105: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("read public/private key failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 106: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid key", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 107: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("corrupt key", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 108: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid key length", new Object[0]));
                break;
            }
            case 109: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid block length", new Object[0]));
                break;
            }
            case 110: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid salt length", new Object[0]));
                break;
            }
            case 111: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no public encryption key", new Object[0]));
                break;
            }
            case 112: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no private encryption key", new Object[0]));
                break;
            }
            case 113: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("key is not a public encryption key", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 114: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("key is not a private encryption key", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 115: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no public signature key", new Object[0]));
                break;
            }
            case 116: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no private signature key", new Object[0]));
                break;
            }
            case 117: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("key is not a public signature key", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 118: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("key is not a private signature key", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 119: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("key encryption failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 120: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("key decryption failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 121: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("wrong private decryption key", new Object[0]));
                break;
            }
            case 122: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid encryption algorithm", new Object[0]));
                break;
            }
            case 123: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("unknown encryption algorithm", new Object[0]));
                break;
            }
            case 124: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("encrypt failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s (code: %d)", string, n2);
                break;
            }
            case 125: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("decrypt failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s (code: %d)", string, n2);
                break;
            }
            case 126: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("initialize hash failed", new Object[0]));
                break;
            }
            case 127: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid hash algorithm", new Object[0]));
                break;
            }
            case 128: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("unknown hash algorithm", new Object[0]));
                break;
            }
            case 129: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("initialize message authentication code failed", new Object[0]));
                break;
            }
            case 130: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid message authentication code algorithm", new Object[0]));
                break;
            }
            case 131: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("unknown message authentication code algorithm", new Object[0]));
                break;
            }
            case 132: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("directory not found", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 133: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no file name given", new Object[0]));
                break;
            }
            case 134: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("create file failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 135: {
                if (!BARException.stringIsEmpty(string)) {
                    BARException.stringFormat(stringBuilder, BARException.sizeof(stringBuilder), "%s", string);
                    break;
                }
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("open file failed", new Object[0]));
                break;
            }
            case 136: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("create directory failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 137: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("read file failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 138: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("end of file", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 139: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("write file failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 140: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("delete file failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 141: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("open directory", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 142: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("read directory failed", new Object[0]));
                break;
            }
            case 143: {
                if (!BARException.stringIsEmpty(string)) {
                    BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("file ''{0}'' already exists", string));
                    break;
                }
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("file already exists", new Object[0]));
                break;
            }
            case 144: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("file not found", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 145: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("access denied", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 146: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("not a directory", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 147: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("end of directory list", new Object[0]));
                break;
            }
            case 148: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("init file notify failed", new Object[0]));
                if (!BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 149: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("insufficient file notify entries", new Object[0]));
                break;
            }
            case 150: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("i/o error", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s (code: %d)", string, n2);
                break;
            }
            case 151: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("CD/DVD/BD device not found", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 152: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("open CD/DVD/BD failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 153: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("read CD/DVD/BD failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 154: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("write CD/DVD/BD failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 155: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("verify CD/DVD/BD content failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 156: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("open ISO 9660 image failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 157: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("create ISO 9660 image failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 158: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no device name given", new Object[0]));
                break;
            }
            case 159: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("not a device", new Object[0]));
                break;
            }
            case 160: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("open device failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 161: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid device block size", new Object[0]));
                break;
            }
            case 162: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("read device failed", new Object[0]));
                break;
            }
            case 163: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("write device failed", new Object[0]));
                break;
            }
            case 164: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("error parsing device list", new Object[0]));
                break;
            }
            case 165: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("device not found", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 166: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("mount failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 167: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("unmount failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 168: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no archive file name given", new Object[0]));
                break;
            }
            case 169: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("not an archive file", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 170: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("archive not found", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 171: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("end of archive", new Object[0]));
                break;
            }
            case 172: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no meta entry", new Object[0]));
                break;
            }
            case 173: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no file entry", new Object[0]));
                break;
            }
            case 174: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no file data entry", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendChar(stringBuilder, BARException.sizeof(stringBuilder), ' ');
                BARException.stringAppend(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("for ''{0}''", string));
                break;
            }
            case 175: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no directory entry", new Object[0]));
                break;
            }
            case 176: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no link entry", new Object[0]));
                break;
            }
            case 177: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no hard link entry", new Object[0]));
                break;
            }
            case 178: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no special entry", new Object[0]));
                break;
            }
            case 179: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no image entry", new Object[0]));
                break;
            }
            case 180: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("no image data entry", new Object[0]));
                break;
            }
            case 181: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("end of data", new Object[0]));
                break;
            }
            case 182: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("incomplete archive", new Object[0]));
                break;
            }
            case 183: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("insufficient split number digits in name", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppend(stringBuilder, BARException.sizeof(stringBuilder), " (");
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("required at least %s digits", new Object[0]), string);
                BARException.stringAppend(stringBuilder, BARException.sizeof(stringBuilder), ")");
                break;
            }
            case 184: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("wrong CRC", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppend(stringBuilder, BARException.sizeof(stringBuilder), " ");
                BARException.stringAppend(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("at offset", new Object[0]));
                BARException.stringAppend(stringBuilder, BARException.sizeof(stringBuilder), " ");
                BARException.stringAppend(stringBuilder, BARException.sizeof(stringBuilder), string);
                break;
            }
            case 185: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), "entry not found");
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 186: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("entry is incomplete", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 187: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("wrong entry type", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 188: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("entries differ", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 189: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("corrupt data or invalid password", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 190: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid chunk size", new Object[0]));
                break;
            }
            case 191: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("unknown chunk", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 192: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid signature", new Object[0]));
                break;
            }
            case 193: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid incremental file", new Object[0]));
                break;
            }
            case 194: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("wrong incremental file version", new Object[0]));
                break;
            }
            case 195: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("corrupt incremental file", new Object[0]));
                break;
            }
            case 196: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid device specifier", new Object[0]));
                break;
            }
            case 197: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("load volume failed", new Object[0]));
                break;
            }
            case 198: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("parse command failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": '%s'", string);
                break;
            }
            case 199: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("expand command template failed", new Object[0]));
                break;
            }
            case 200: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("i/o redirect failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 201: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("execute external program failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 202: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("terminated external program", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 203: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("execute external program timeout", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 204: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("parsing data failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 205: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("parsing date failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 206: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("parsing time failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 207: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("parsing weekdays failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 208: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("parsing maintenance failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 209: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("parsing schedule failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 210: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("unknown command", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 211: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("expected parameter", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 212: {
                if (!BARException.stringIsEmpty(string)) {
                    BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), string);
                    break;
                }
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("unknown value", new Object[0]));
                break;
            }
            case 213: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid value", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 214: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("deprecated or ignored value", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 215: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("authorization failed", new Object[0]));
                break;
            }
            case 216: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("job not found", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 217: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("schedule not found", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 218: {
                if (!BARException.stringIsEmpty(string)) {
                    BARException.stringFormat(stringBuilder, BARException.sizeof(stringBuilder), "persistence with id #%s not found", string);
                    break;
                }
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("persistence not found", new Object[0]));
                break;
            }
            case 219: {
                if (!BARException.stringIsEmpty(string)) {
                    BARException.stringFormat(stringBuilder, BARException.sizeof(stringBuilder), "maintenance with id #%s not found", string);
                    break;
                }
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("maintenance not found", new Object[0]));
                break;
            }
            case 220: {
                if (!BARException.stringIsEmpty(string)) {
                    BARException.stringFormat(stringBuilder, BARException.sizeof(stringBuilder), "server with id #%s not found", string);
                    break;
                }
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("server not found", new Object[0]));
                break;
            }
            case 221: {
                if (!BARException.stringIsEmpty(string)) {
                    BARException.stringFormat(stringBuilder, BARException.sizeof(stringBuilder), "entry with id #%s not found", string);
                    break;
                }
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("entry not found", new Object[0]));
                break;
            }
            case 222: {
                if (!BARException.stringIsEmpty(string)) {
                    BARException.stringFormat(stringBuilder, BARException.sizeof(stringBuilder), "pattern with id #%s not found", string);
                    break;
                }
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("pattern not found", new Object[0]));
                break;
            }
            case 223: {
                if (!BARException.stringIsEmpty(string)) {
                    BARException.stringFormat(stringBuilder, BARException.sizeof(stringBuilder), "mount with id #%s not found", string);
                    break;
                }
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("mount not found", new Object[0]));
                break;
            }
            case 224: {
                if (!BARException.stringIsEmpty(string)) {
                    BARException.stringFormat(stringBuilder, BARException.sizeof(stringBuilder), "delta source with id #%s not found", string);
                    break;
                }
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("delta source not found", new Object[0]));
                break;
            }
            case 225: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("database", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 226: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid database URI", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 227: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("database type not supported", new Object[0]));
                break;
            }
            case 228: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("database already exists", new Object[0]));
                break;
            }
            case 229: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("database not found", new Object[0]));
                break;
            }
            case 230: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("connect to database failed", new Object[0]));
                break;
            }
            case 231: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("database connection lost", new Object[0]));
                break;
            }
            case 232: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("database authorization failed", new Object[0]));
                break;
            }
            case 233: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("insufficient database version", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 234: {
                if (!BARException.stringIsEmpty(string)) {
                    BARException.stringFormat(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("unknown version %s of index", new Object[0]), string);
                    break;
                }
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("unknown version of index", new Object[0]));
                break;
            }
            case 235: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("missing table", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), " '%s'", string);
                break;
            }
            case 236: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("missing column", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), " '%s'", string);
                break;
            }
            case 237: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("obsolete table", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), " '%s'", string);
                break;
            }
            case 238: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("obsolete column", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), " '%s'", string);
                break;
            }
            case 239: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("database bind failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 240: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("type mismatch", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), " '%s'", string);
                break;
            }
            case 241: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("error creating index", new Object[0]));
                break;
            }
            case 242: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("index not found", new Object[0]));
                break;
            }
            case 243: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("index still not initialized", new Object[0]));
                break;
            }
            case 244: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid index", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 245: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("parse index id failed", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 246: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("database is locked", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 247: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("database busy", new Object[0]));
                break;
            }
            case 248: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("database operation interrupted", new Object[0]));
                break;
            }
            case 249: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("timeout accessing index", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 250: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("database entry not found", new Object[0]));
                break;
            }
            case 251: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("master disconnected", new Object[0]));
                break;
            }
            case 252: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("slave disconnected", new Object[0]));
                break;
            }
            case 253: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("slave is not paired", new Object[0]));
                break;
            }
            case 254: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("instance is not a slave", new Object[0]));
                break;
            }
            case 255: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("create PAR2 checksums fail", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": %s", string);
                break;
            }
            case 256: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("invalid block size (multiple of 4)", new Object[0]));
                break;
            }
            case 257: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("PAR2 block size too small", new Object[0]));
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), ": at least %s bytes", string);
                break;
            }
            case 258: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), BARControl.tr("too many PAR2 blocks (max. 32768)", new Object[0]));
                break;
            }
            case 259: {
                BARException.stringSet(stringBuilder, BARException.sizeof(stringBuilder), "test code");
                if (BARException.stringIsEmpty(string)) break;
                BARException.stringAppendFormat(stringBuilder, BARException.sizeof(stringBuilder), " %s", string);
            }
        }
        return stringBuilder.toString();
    }

    public static String getText(BARException bARException) {
        return BARException.getText(BARException.getCode(bARException), BARException.getErrno(bARException), BARException.getData(bARException));
    }

    BARException(int n, int n2, String string) {
        this.code = n;
        this.errno = n2;
        this.data = string;
    }

    BARException(int n, String string) {
        this(n, 0, string);
    }

    BARException(int n) {
        this(n, (String)null);
    }

    BARException(int n, int n2, String string, Object ... objectArray) {
        this(n, n2, String.format(string, objectArray));
    }

    @Override
    public String getMessage() {
        return BARException.getText(this);
    }

    public int getCode() {
        return this.code;
    }

    public int getErrno() {
        return this.errno;
    }

    public String getData() {
        return this.data;
    }

    public String getText() {
        return BARException.getText(this);
    }

    @Override
    public String toString() {
        return BARException.getText(this);
    }

    private static int sizeof(StringBuilder stringBuilder) {
        return 0;
    }

    private static int sizeof(String string) {
        return 0;
    }

    private static String strerror(int n) {
        return "";
    }

    private static void stringSet(StringBuilder stringBuilder, int n, String string) {
        stringBuilder.setLength(0);
        stringBuilder.append(string);
    }

    private static void stringAppend(StringBuilder stringBuilder, int n, String string) {
        stringBuilder.append(string);
    }

    private static void stringAppendChar(StringBuilder stringBuilder, int n, char c) {
        stringBuilder.append(c);
    }

    private static void stringFormat(StringBuilder stringBuilder, int n, String string, Object ... objectArray) {
        stringBuilder.setLength(0);
        stringBuilder.append(String.format(string, objectArray));
    }

    private static void stringAppendFormat(StringBuilder stringBuilder, int n, String string, Object ... objectArray) {
        stringBuilder.append(String.format(string, objectArray));
    }

    private static boolean stringIsEmpty(String string) {
        return string.isEmpty();
    }
}

