/*
 * Decompiled with CFR 0.152.
 */
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.HashMap;

public class Dprintf {
    public static final Group GROUP_ANY;
    private static PrintStream outputStream;
    private static int debugLevel;
    private static HashMap<String, Group> debugGroups;
    private static boolean timeStampsEnabled;

    public static void setOutputStream(PrintStream printStream) {
        outputStream = printStream;
    }

    public static Group addGroup(String string) {
        Group group = debugGroups.get(string);
        if (group == null) {
            group = new Group(string);
            debugGroups.put(string, group);
        }
        return group;
    }

    public static void dprintf(int n, Group group, String string, Object ... objectArray) {
        Dprintf.printOutput(3, n, group, string, objectArray);
    }

    public static void dprintf(int n, String string, Object ... objectArray) {
        Dprintf.printOutput(3, n, null, string, objectArray);
    }

    public static void dprintf(int n, Object object) {
        Dprintf.printOutput(3, n, null, "%s", object);
    }

    public static void dprintf(String string, Object ... objectArray) {
        Dprintf.printOutput(3, 0, null, string, objectArray);
    }

    public static void dprintf(Object object) {
        Dprintf.printOutput(3, 0, null, "%s", object);
    }

    public static void dprintf() {
        Dprintf.printOutput(3, 0, GROUP_ANY, "", new Object[0]);
    }

    public static void dumpMemory(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(String.format("%02x", byArray[i]));
        }
        Dprintf.printOutput(3, 0, null, "%s", stringBuilder.toString());
    }

    public static void halt(String string, Object ... objectArray) {
        Dprintf.printOutput(3, 0, GROUP_ANY, "HALT: " + string, objectArray);
        Dprintf.printStackTrace();
        System.exit(1);
    }

    public static void halt(Object object) {
        Dprintf.printOutput(3, 0, GROUP_ANY, "HALT: %s", object);
        Dprintf.printStackTrace();
        System.exit(1);
    }

    public static void halt() {
        Dprintf.printOutput(3, 0, GROUP_ANY, "HALT", new Object[0]);
        Dprintf.printStackTrace();
        System.exit(1);
    }

    private static void printOutput(int n, int n2, Group group, String string, Object ... objectArray) {
        if (debugLevel >= n2) {
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            if (group == null) {
                try {
                    Class<?> clazz = Class.forName(stackTraceElementArray[n].getClassName());
                    Field field = clazz.getDeclaredField("DEBUG_GROUP");
                    group = (Group)field.get(stackTraceElementArray[n]);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    group = GROUP_ANY;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    group = GROUP_ANY;
                }
                catch (IllegalAccessException illegalAccessException) {
                    group = GROUP_ANY;
                }
            }
            if (group.enabled) {
                if (timeStampsEnabled) {
                    outputStream.print(String.format("%8d ", System.currentTimeMillis()));
                }
                outputStream.print(stackTraceElementArray[n].getFileName() + ", " + stackTraceElementArray[n].getLineNumber() + ", " + stackTraceElementArray[n].getMethodName() + ": ");
                outputStream.printf(string, objectArray);
                outputStream.println();
            }
        }
    }

    private static void printStackTrace(int n, String string) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i = n; i < stackTraceElementArray.length; ++i) {
            outputStream.println(string + stackTraceElementArray[i].getMethodName() + "(), " + stackTraceElementArray[i].getFileName() + ":" + stackTraceElementArray[i].getLineNumber() + ": ");
        }
    }

    private static void printStackTrace(int n) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i = n + 1; i < stackTraceElementArray.length; ++i) {
            outputStream.println("  " + stackTraceElementArray[i]);
        }
    }

    public static void printStackTrace(String string) {
        Dprintf.printStackTrace(3, string);
    }

    public static void printStackTrace() {
        Dprintf.printStackTrace(3, "  ");
    }

    static {
        outputStream = System.err;
        debugLevel = 0;
        debugGroups = new HashMap();
        timeStampsEnabled = true;
        String string = System.getProperty("DEBUG_LEVEL");
        if (string != null) {
            try {
                debugLevel = Math.max(0, Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                outputStream.println("Warning: cannot parse debug level '" + string + "' (error: " + numberFormatException.getMessage() + ")");
            }
        }
        GROUP_ANY = new Group("ANY", true);
        debugGroups.put("ANY", GROUP_ANY);
        string = System.getProperty("DEBUG_GROUPS");
        if (string != null) {
            for (String string2 : string.split(",")) {
                debugGroups.put(string2, new Group(string2, true));
            }
        }
    }

    static class Group {
        protected String name;
        protected boolean enabled;

        Group(String string, boolean bl) {
            this.name = string;
            this.enabled = bl;
        }

        Group(String string) {
            this(string, false);
        }

        public String toString() {
            return "{Group " + this.name + ", " + this.enabled + "}";
        }
    }
}

