/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

class SimpleBusyDialog {
    private final Data data = new Data();
    private final Display display;
    private final Shell dialog;
    private final Image image;
    private final Point imageSize;
    private final Canvas widgetImage;

    SimpleBusyDialog(Shell shell, String string, Image image, Point point, String string2, boolean bl) {
        this.image = image;
        this.imageSize = point;
        this.display = shell.getDisplay();
        this.dialog = Dialogs.openModal(shell, string, 250, 70);
        this.dialog.setLayout(new TableLayout(new double[]{1.0, 0.0}, 1.0));
        Composite composite = new Composite(this.dialog, 0);
        composite.setLayout(new TableLayout(null, new double[]{0.0, 1.0}, 4));
        composite.setLayoutData(new TableLayoutData(0, 0, 15));
        this.widgetImage = new Canvas(composite, 16384);
        this.widgetImage.setSize(point.x, point.y);
        this.widgetImage.setLayoutData(new TableLayoutData(0, 0, 4, 0, 0, 10));
        Label label = new Label(composite, 16448);
        label.setText(string2);
        label.setLayoutData(new TableLayoutData(0, 1, 13, 0, 0, 4));
        if (bl) {
            composite = new Composite(this.dialog, 0);
            composite.setLayout(new TableLayout(null, 1.0, 4));
            composite.setLayoutData(new TableLayoutData(1, 0, 12));
            Button button = new Button(composite, 0x1000000);
            button.setText(Dialogs.tr("Abort", new Object[0]));
            button.setLayoutData(new TableLayoutData(0, 0, 8, 0, 0, 0, 0, -1, -1, 120, -1));
            button.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    SimpleBusyDialog.this.close();
                }
            });
        }
        Dialogs.show(this.dialog);
        this.animate();
    }

    SimpleBusyDialog(Shell shell, String string, Image image, Point point, String string2) {
        this(shell, string, image, point, string2, false);
    }

    SimpleBusyDialog(Shell shell, String string, Image image, String string2, boolean bl) {
        this(shell, string, image, new Point(48, 48), string2, bl);
    }

    SimpleBusyDialog(Shell shell, String string, Image image, String string2) {
        this(shell, string, image, string2, false);
    }

    SimpleBusyDialog(Shell shell, String string, String string2, boolean bl) {
        this(shell, string, Widgets.loadImage(shell.getDisplay(), "working.png"), string2, bl);
    }

    SimpleBusyDialog(Shell shell, String string, String string2) {
        this(shell, string, string2, false);
    }

    public void animate() {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!SimpleBusyDialog.this.dialog.isDisposed()) {
                    int n = ((SimpleBusyDialog)SimpleBusyDialog.this).data.animationIndex % 8 * 48;
                    int n2 = ((SimpleBusyDialog)SimpleBusyDialog.this).data.animationIndex / 8 * 48;
                    if (!SimpleBusyDialog.this.widgetImage.isDisposed()) {
                        GC gC = new GC(SimpleBusyDialog.this.widgetImage);
                        SimpleBusyDialog.this.widgetImage.drawBackground(gC, 0, 0, ((SimpleBusyDialog)SimpleBusyDialog.this).imageSize.x, ((SimpleBusyDialog)SimpleBusyDialog.this).imageSize.y);
                        gC.drawImage(SimpleBusyDialog.this.image, n, n2, ((SimpleBusyDialog)SimpleBusyDialog.this).imageSize.x, ((SimpleBusyDialog)SimpleBusyDialog.this).imageSize.y, 0, 0, ((SimpleBusyDialog)SimpleBusyDialog.this).imageSize.x, ((SimpleBusyDialog)SimpleBusyDialog.this).imageSize.y);
                        gC.dispose();
                        SimpleBusyDialog.this.display.update();
                    }
                    ((SimpleBusyDialog)SimpleBusyDialog.this).data.animationIndex = 1 + ((SimpleBusyDialog)SimpleBusyDialog.this).data.animationIndex % 23;
                }
            }
        });
    }

    public void autoAnimate(final int n) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (!((SimpleBusyDialog)SimpleBusyDialog.this).data.animationQuit) {
                    SimpleBusyDialog.this.animate();
                    try {
                        Thread.sleep(n);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        thread.start();
    }

    public void autoAnimate() {
        this.autoAnimate(500);
    }

    public void close() {
        this.data.animationQuit = true;
        if (!this.dialog.isDisposed()) {
            Dialogs.close(this.dialog);
        }
    }

    public boolean isClosed() {
        return this.dialog.isDisposed();
    }

    class Data {
        int animationIndex = 0;
        boolean animationQuit = false;

        Data() {
        }
    }
}

