/*
 * Decompiled with CFR 0.152.
 */
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.swt.SWTException;

class BackgroundTask
implements Runnable {
    private BackgroundRunnable backgroundRunnable;
    private Method runMethod;

    BackgroundTask(BackgroundRunnable backgroundRunnable) {
        this.backgroundRunnable = backgroundRunnable;
        this.runMethod = null;
        for (Method method : backgroundRunnable.getClass().getDeclaredMethods()) {
            Class<?>[] classArray;
            if (!method.getName().equals("run") || (classArray = method.getParameterTypes()).length != backgroundRunnable.userData.length) continue;
            boolean bl = true;
            for (int i = 0; i < backgroundRunnable.userData.length && bl; ++i) {
                bl = backgroundRunnable.userData[i] != null ? classArray[i].isAssignableFrom(backgroundRunnable.userData[i].getClass()) : Object.class.isAssignableFrom(classArray[i]);
            }
            if (!bl) continue;
            this.runMethod = method;
            break;
        }
    }

    @Override
    public void run() {
        try {
            if (this.runMethod != null) {
                this.runMethod.invoke((Object)this.backgroundRunnable, this.backgroundRunnable.userData);
            } else {
                this.backgroundRunnable.run();
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            BARControl.printError("Unhandled background exception: %s", invocationTargetException.getCause());
            System.err.println("Stack trace:");
            BARControl.printStackTrace(invocationTargetException);
            System.exit(127);
        }
        catch (SWTException sWTException) {
            BARControl.printError("Unhandled SWT background exception: %s", sWTException);
            System.err.println("Stack trace:");
            BARControl.printStackTrace(sWTException);
            System.exit(127);
        }
        catch (Exception exception) {
            BARControl.printError("Unhandled background exception: %s", exception);
            System.err.println("Stack trace:");
            BARControl.printStackTrace(exception);
        }
        catch (Error error) {
            BARControl.printError("Unhandled background error: %s", error);
            System.err.println("Stack trace:");
            BARControl.printStackTrace(error);
        }
    }
}

