/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedWriter;
import java.util.ArrayDeque;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

class CommandThread
extends Thread {
    private Display display;
    private BufferedWriter output;
    private boolean quitFlag = false;
    private ArrayDeque<Command> commandQueue = new ArrayDeque();

    CommandThread(Display display, BufferedWriter bufferedWriter) {
        this.display = display;
        this.output = bufferedWriter;
        this.setDaemon(true);
        this.setName("BARControl Server Command");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.quitFlag) {
            Command command;
            Object object = this.commandQueue;
            synchronized (object) {
                do {
                    if ((command = this.commandQueue.pollFirst()) != null) continue;
                    try {
                        this.commandQueue.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (!this.quitFlag && command == null);
            }
            if (this.quitFlag) break;
            try {
                String string;
                Object object2;
                if (command.name.equals("CONFIRM")) {
                    object = command.valueMap.getString("type");
                    if (((String)object).equals("RESTORE")) {
                        object2 = command.valueMap.getString("storageName", "");
                        string = command.valueMap.getString("entryName", "");
                        String string2 = command.valueMap.getString("errorData", "");
                        String[] stringArray = new String[]{"ABORT"};
                        if (this.display != null) {
                            this.display.syncExec(new Runnable((String)object2, string2, stringArray){
                                final /* synthetic */ String val$storageName;
                                final /* synthetic */ String val$errorData;
                                final /* synthetic */ String[] val$action;
                                {
                                    this.val$storageName = string2;
                                    this.val$errorData = string3;
                                    this.val$action = stringArray;
                                }

                                @Override
                                public void run() {
                                    switch (Dialogs.select(new Shell(), BARControl.tr("Confirmation", new Object[0]), BARControl.tr("Cannot restore:\n\n {0}\n\nReason: {1}", !string.isEmpty() ? string : this.val$storageName, this.val$errorData), new String[]{BARControl.tr("Skip", new Object[0]), BARControl.tr("Skip all", new Object[0]), BARControl.tr("Abort", new Object[0])}, 0)) {
                                        case 0: {
                                            this.val$action[0] = "SKIP";
                                            break;
                                        }
                                        case 1: {
                                            this.val$action[0] = "SKIP_ALL";
                                            break;
                                        }
                                        case 2: {
                                            this.val$action[0] = "ABORT";
                                        }
                                    }
                                }
                            });
                            BARServer.sendResult(command.id, 1, true, 0, "action=%s", stringArray[0]);
                            continue;
                        }
                        BARServer.sendResult(command.id, 1, true, 0, "action=ABORT skipAll=no", new Object[0]);
                        continue;
                    }
                    BARServer.sendResult(command.id, 1, true, 0, "action=ABORT", new Object[0]);
                    continue;
                }
                if (command.name.equals("REQUEST_PASSWORD")) {
                    object = command.valueMap.getString("name", "");
                    object2 = command.valueMap.getEnum("passwordType", PasswordTypes.class, PasswordTypes.NONE);
                    string = command.valueMap.getString("passwordText", "");
                    if (this.display != null) {
                        long l = command.id;
                        this.display.syncExec(new Runnable((PasswordTypes)((Object)object2), string, (String)object, l){
                            final /* synthetic */ PasswordTypes val$passwordType;
                            final /* synthetic */ String val$passwordText;
                            final /* synthetic */ String val$name;
                            final /* synthetic */ long val$id;
                            {
                                this.val$passwordType = passwordTypes;
                                this.val$passwordText = string;
                                this.val$name = string2;
                                this.val$id = l;
                            }

                            @Override
                            public void run() {
                                if (this.val$passwordType.isLogin()) {
                                    String[] stringArray = Dialogs.login(new Shell(), BARControl.tr("Enter password", new Object[0]), BARControl.tr("Please enter {0} password for: {1}", this.val$passwordType.toString(), this.val$passwordText), this.val$name, BARControl.tr("Password", new Object[0]) + ":");
                                    if (stringArray != null) {
                                        BARServer.sendResult(this.val$id, 1, true, 0, StringParser.format("name=%S encryptType=%s encryptedPassword=%S", 0, stringArray[0], BARServer.getPasswordEncryptType(), BARServer.encryptPassword(stringArray[1])), new Object[0]);
                                    } else {
                                        BARServer.sendResult(this.val$id, 1, true, 13);
                                    }
                                } else {
                                    String string = Dialogs.password(new Shell(), BARControl.tr("Enter password", new Object[0]), BARControl.tr("Please enter {0} password for: {1}", this.val$passwordType.toString(), this.val$passwordText), BARControl.tr("Password", new Object[0]) + ":");
                                    if (string != null) {
                                        BARServer.sendResult(this.val$id, 1, true, 0, StringParser.format("encryptType=%s encryptedPassword=%S", BARServer.getPasswordEncryptType(), BARServer.encryptPassword(string)), new Object[0]);
                                    } else {
                                        BARServer.sendResult(this.val$id, 1, true, 13);
                                    }
                                }
                            }
                        });
                        continue;
                    }
                    BARServer.sendResult(command.id, 1, true, 13);
                    continue;
                }
                BARServer.sendResult(command.id, 1, true, 210);
            }
            catch (Throwable throwable) {
                BARServer.sendResult(command.id, 1, true, 0, "action=ABORT", new Object[0]);
                if (Settings.debugLevel <= 0) continue;
                BARControl.internalError(throwable);
            }
        }
    }

    public void quit() {
        this.quitFlag = true;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(long l, String string, ValueMap valueMap) {
        ArrayDeque<Command> arrayDeque = this.commandQueue;
        synchronized (arrayDeque) {
            this.commandQueue.add(new Command(l, string, valueMap));
            this.commandQueue.notifyAll();
        }
    }

    class Command {
        long id;
        String name;
        ValueMap valueMap;

        Command(long l, String string, ValueMap valueMap) {
            this.id = l;
            this.name = string;
            this.valueMap = valueMap;
        }
    }
}

