/*
 * Decompiled with CFR 0.152.
 */
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

class Units {
    public static long K = 1024L;
    public static long M = 1024L * K;
    public static long G = 1024L * M;
    public static long T = 1024L * G;
    public static long P = 1024L * T;
    public static long SECOND = 1L;
    public static long MINUTE = 60L * SECOND;
    public static long HOUR = 60L * MINUTE;
    public static long DAY = 24L * HOUR;
    public static long WEEK = 7L * DAY;

    Units() {
    }

    public static String getSize(double d) {
        DecimalFormat decimalFormat = new DecimalFormat(".#");
        if (d > 0.0) {
            String string = d % (double)P == 0.0 ? String.format("%d.0", (long)d / P) : (d >= (double)P ? decimalFormat.format(d / (double)P) : (d % (double)T == 0.0 ? String.format("%d.0", (long)d / T) : (d >= (double)T ? decimalFormat.format(d / (double)T) : (d % (double)G == 0.0 ? String.format("%d.0", (long)d / G) : (d >= (double)G ? decimalFormat.format(d / (double)G) : (d % (double)M == 0.0 ? String.format("%d.0", (long)d / M) : (d >= (double)M ? decimalFormat.format(d / (double)M) : (d % (double)K == 0.0 ? String.format("%d.0", (long)d / K) : (d >= (double)K ? decimalFormat.format(d / (double)K) : String.format("%d", (long)d))))))))));
            return string;
        }
        return "0";
    }

    public static String getUnit(double d) {
        String string = d >= (double)P ? "P" : (d >= (double)T ? "T" : (d >= (double)G ? "G" : (d >= (double)M ? "M" : (d >= (double)K ? "K" : ""))));
        return string;
    }

    public static String getByteUnit(double d) {
        String string = d >= (double)P ? BARControl.tr("PiBytes", new Object[0]) : (d >= (double)T ? BARControl.tr("TiBytes", new Object[0]) : (d >= (double)G ? BARControl.tr("GiBytes", new Object[0]) : (d >= (double)M ? BARControl.tr("MiBytes", new Object[0]) : (d >= (double)K ? BARControl.tr("KiBytes", new Object[0]) : BARControl.tr("bytes", new Object[0])))));
        return string;
    }

    public static Point getMaxByteUnitTextSize(Control control, String string) {
        return Widgets.getTextSize(control, new String[]{BARControl.tr("bytes", new Object[0]) + string, BARControl.tr("KiBytes", new Object[0]) + string, BARControl.tr("MiBytes", new Object[0]) + string, BARControl.tr("GiBytes", new Object[0]) + string, BARControl.tr("TiBytes", new Object[0]) + string, BARControl.tr("PiBytes", new Object[0]) + string});
    }

    public static Point getMaxByteUnitTextSize(Control control) {
        return Units.getMaxByteUnitTextSize(control, "");
    }

    public static String getByteShortUnit(double d) {
        String string = d >= (double)P ? "PiB" : (d >= (double)T ? "TiB" : (d >= (double)G ? "GiB" : (d >= (double)M ? "MiB" : (d >= (double)K ? "KiB" : "B"))));
        return string;
    }

    public static Point getMaxByteShortUnitTextSize(Control control, String string) {
        return Widgets.getTextSize(control, new String[]{BARControl.tr("B", new Object[0]) + string, BARControl.tr("KiB", new Object[0]) + string, BARControl.tr("MiB", new Object[0]) + string, BARControl.tr("GiB", new Object[0]) + string, BARControl.tr("TiB", new Object[0]) + string, BARControl.tr("PiB", new Object[0]) + string});
    }

    public static Point getMaxByteShortUnitTextSize(Control control) {
        return Units.getMaxByteShortUnitTextSize(control, "");
    }

    public static long parseByteSize(String string) throws NumberFormatException {
        string = string.toUpperCase();
        try {
            if (string.endsWith("PB") || string.endsWith("PiB")) {
                return (long)(NumberFormat.getInstance().parse(string.substring(0, string.length() - 2)).doubleValue() * (double)P);
            }
            if (string.endsWith("P") || string.endsWith("Pi")) {
                return (long)(NumberFormat.getInstance().parse(string.substring(0, string.length() - 1)).doubleValue() * (double)P);
            }
            if (string.endsWith("TB") || string.endsWith("TiB")) {
                return (long)(NumberFormat.getInstance().parse(string.substring(0, string.length() - 2)).doubleValue() * (double)T);
            }
            if (string.endsWith("T") || string.endsWith("Ti")) {
                return (long)(NumberFormat.getInstance().parse(string.substring(0, string.length() - 1)).doubleValue() * (double)T);
            }
            if (string.endsWith("GB") || string.endsWith("GiB")) {
                return (long)(NumberFormat.getInstance().parse(string.substring(0, string.length() - 2)).doubleValue() * (double)G);
            }
            if (string.endsWith("G") || string.endsWith("Gi")) {
                return (long)(NumberFormat.getInstance().parse(string.substring(0, string.length() - 1)).doubleValue() * (double)G);
            }
            if (string.endsWith("MB") || string.endsWith("MiB")) {
                return (long)(NumberFormat.getInstance().parse(string.substring(0, string.length() - 2)).doubleValue() * (double)M);
            }
            if (string.endsWith("M") || string.endsWith("Mi")) {
                return (long)(NumberFormat.getInstance().parse(string.substring(0, string.length() - 1)).doubleValue() * (double)M);
            }
            if (string.endsWith("KB") || string.endsWith("KiB")) {
                return (long)(NumberFormat.getInstance().parse(string.substring(0, string.length() - 2)).doubleValue() * (double)K);
            }
            if (string.endsWith("K") || string.endsWith("Ki")) {
                return (long)(NumberFormat.getInstance().parse(string.substring(0, string.length() - 1)).doubleValue() * (double)K);
            }
            if (string.endsWith("B")) {
                return (long)NumberFormat.getInstance().parse(string.substring(0, string.length() - 1)).doubleValue();
            }
            return (long)NumberFormat.getInstance().parse(string).doubleValue();
        }
        catch (ParseException parseException) {
            throw new NumberFormatException(parseException.getMessage());
        }
    }

    public static long parseByteSize(String string, long l) {
        long l2;
        try {
            l2 = Units.parseByteSize(string);
        }
        catch (NumberFormatException numberFormatException) {
            l2 = l;
        }
        return l2;
    }

    public static String formatSize(long l) {
        return Units.getSize(l) + " " + Units.getUnit(l);
    }

    public static String formatByteSize(long l) {
        return Units.getSize(l) + " " + Units.getByteShortUnit(l);
    }

    public static String getTime(double d) {
        if ((long)d == 0L) {
            return "";
        }
        if ((long)d % WEEK == 0L) {
            return String.format("%d", (long)(d / (double)WEEK));
        }
        if ((long)d % DAY == 0L) {
            return String.format("%d", (long)(d / (double)DAY));
        }
        if ((long)d % HOUR == 0L) {
            return String.format("%d", (long)(d / (double)HOUR));
        }
        if ((long)d % MINUTE == 0L) {
            return String.format("%d", (long)(d / (double)MINUTE));
        }
        return String.format("%d", (long)d);
    }

    public static String getTimeUnit(double d) {
        if ((long)d == 0L) {
            return "";
        }
        if ((long)d % WEEK == 0L) {
            return (long)d / WEEK != 1L ? "weeks" : "week";
        }
        if ((long)d % DAY == 0L) {
            return (long)d / DAY != 1L ? "days" : "day";
        }
        if ((long)d % HOUR == 0L) {
            return "h";
        }
        if ((long)d % MINUTE == 0L) {
            return "min";
        }
        return "s";
    }

    public static String getLocalizedTimeUnit(double d) {
        if ((long)d == 0L) {
            return "";
        }
        if ((long)d > 0L && (long)d % WEEK == 0L) {
            return (long)d / WEEK != 1L ? BARControl.tr("weeks", new Object[0]) : BARControl.tr("week", new Object[0]);
        }
        if ((long)d > 0L && (long)d % DAY == 0L) {
            return (long)d / DAY != 1L ? BARControl.tr("days", new Object[0]) : BARControl.tr("day", new Object[0]);
        }
        if ((long)d > 0L && (long)d % HOUR == 0L) {
            return BARControl.tr("h", new Object[0]);
        }
        if ((long)d > 0L && (long)d % MINUTE == 0L) {
            return BARControl.tr("min", new Object[0]);
        }
        if ((long)d > 0L) {
            return BARControl.tr("s", new Object[0]);
        }
        return "";
    }

    public static long parseTime(String string) throws NumberFormatException {
        string = string.toUpperCase();
        try {
            if (string.endsWith("WEEK")) {
                return (long)(NumberFormat.getInstance().parse(string.substring(0, string.length() - 4)).doubleValue() * (double)WEEK);
            }
            if (string.endsWith("WEEKS")) {
                return (long)(NumberFormat.getInstance().parse(string.substring(0, string.length() - 5)).doubleValue() * (double)WEEK);
            }
            if (string.endsWith("DAY")) {
                return (long)(NumberFormat.getInstance().parse(string.substring(0, string.length() - 3)).doubleValue() * (double)DAY);
            }
            if (string.endsWith("DAYS")) {
                return (long)(NumberFormat.getInstance().parse(string.substring(0, string.length() - 4)).doubleValue() * (double)DAY);
            }
            if (string.endsWith("H")) {
                return (long)(NumberFormat.getInstance().parse(string.substring(0, string.length() - 1)).doubleValue() * (double)HOUR);
            }
            if (string.endsWith("HOUR")) {
                return (long)(NumberFormat.getInstance().parse(string.substring(0, string.length() - 4)).doubleValue() * (double)HOUR);
            }
            if (string.endsWith("HOURS")) {
                return (long)(NumberFormat.getInstance().parse(string.substring(0, string.length() - 5)).doubleValue() * (double)HOUR);
            }
            if (string.endsWith("M")) {
                return (long)(NumberFormat.getInstance().parse(string.substring(0, string.length() - 1)).doubleValue() * (double)MINUTE);
            }
            if (string.endsWith("MIN")) {
                return (long)(NumberFormat.getInstance().parse(string.substring(0, string.length() - 3)).doubleValue() * (double)MINUTE);
            }
            if (string.endsWith("MINS")) {
                return (long)(NumberFormat.getInstance().parse(string.substring(0, string.length() - 4)).doubleValue() * (double)MINUTE);
            }
            if (string.endsWith("S")) {
                return (long)NumberFormat.getInstance().parse(string.substring(0, string.length() - 1)).doubleValue();
            }
            if (string.endsWith("SECOND")) {
                return (long)NumberFormat.getInstance().parse(string.substring(0, string.length() - 6)).doubleValue();
            }
            if (string.endsWith("SECONDS")) {
                return (long)NumberFormat.getInstance().parse(string.substring(0, string.length() - 7)).doubleValue();
            }
            return (long)NumberFormat.getInstance().parse(string).doubleValue();
        }
        catch (ParseException parseException) {
            throw new NumberFormatException(parseException.getMessage());
        }
    }

    public static long parseLocalizedTime(String string) throws NumberFormatException {
        String string2 = BARControl.tr("week", new Object[0]).toUpperCase();
        String string3 = BARControl.tr("weeks", new Object[0]).toUpperCase();
        String string4 = BARControl.tr("day", new Object[0]).toUpperCase();
        String string5 = BARControl.tr("days", new Object[0]).toUpperCase();
        String string6 = BARControl.tr("h", new Object[0]).toUpperCase();
        String string7 = BARControl.tr("hour", new Object[0]).toUpperCase();
        String string8 = BARControl.tr("hours", new Object[0]).toUpperCase();
        String string9 = BARControl.tr("m", new Object[0]).toUpperCase();
        String string10 = BARControl.tr("min", new Object[0]).toUpperCase();
        String string11 = BARControl.tr("mins", new Object[0]).toUpperCase();
        String string12 = BARControl.tr("s", new Object[0]).toUpperCase();
        String string13 = BARControl.tr("second", new Object[0]).toUpperCase();
        String string14 = BARControl.tr("seconds", new Object[0]).toUpperCase();
        if ((string = string.toUpperCase()).endsWith(string2)) {
            return (long)(Double.parseDouble(string.substring(0, string.length() - string2.length())) * (double)WEEK);
        }
        if (string.endsWith(string3)) {
            return (long)(Double.parseDouble(string.substring(0, string.length() - string3.length())) * (double)WEEK);
        }
        if (string.endsWith(string4)) {
            return (long)(Double.parseDouble(string.substring(0, string.length() - string4.length())) * (double)DAY);
        }
        if (string.endsWith(string5)) {
            return (long)(Double.parseDouble(string.substring(0, string.length() - string5.length())) * (double)DAY);
        }
        if (string.endsWith(string6)) {
            return (long)(Double.parseDouble(string.substring(0, string.length() - string6.length())) * (double)HOUR);
        }
        if (string.endsWith(string7)) {
            return (long)(Double.parseDouble(string.substring(0, string.length() - string7.length())) * (double)HOUR);
        }
        if (string.endsWith(string8)) {
            return (long)(Double.parseDouble(string.substring(0, string.length() - string8.length())) * (double)HOUR);
        }
        if (string.endsWith(string9)) {
            return (long)(Double.parseDouble(string.substring(0, string.length() - string9.length())) * (double)MINUTE);
        }
        if (string.endsWith(string10)) {
            return (long)(Double.parseDouble(string.substring(0, string.length() - string10.length())) * (double)MINUTE);
        }
        if (string.endsWith(string11)) {
            return (long)(Double.parseDouble(string.substring(0, string.length() - string11.length())) * (double)MINUTE);
        }
        if (string.endsWith(string12)) {
            return (long)Double.parseDouble(string.substring(0, string.length() - string12.length()));
        }
        if (string.endsWith(string13)) {
            return (long)Double.parseDouble(string.substring(0, string.length() - string13.length()));
        }
        if (string.endsWith(string14)) {
            return (long)Double.parseDouble(string.substring(0, string.length() - string14.length()));
        }
        return (long)Double.parseDouble(string);
    }

    public static long parseTime(String string, long l) {
        long l2;
        try {
            l2 = Units.parseTime(string);
        }
        catch (NumberFormatException numberFormatException) {
            l2 = l;
        }
        return l2;
    }

    public static long parseLocalizedTime(String string, long l) {
        long l2;
        try {
            l2 = Units.parseLocalizedTime(string);
        }
        catch (NumberFormatException numberFormatException) {
            l2 = l;
        }
        return l2;
    }

    public static String formatTime(long l) {
        return Units.getTime(l) + Units.getTimeUnit(l);
    }

    public static String formatLocalizedTime(long l) {
        return Units.getTime(l) + Units.getLocalizedTimeUnit(l);
    }
}

