/*
 * Decompiled with CFR 0.152.
 */
import java.text.MessageFormat;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.xnap.commons.i18n.I18n;

public class BusyDialog {
    public static final int NONE = 0;
    public static final int TEXT0 = 1;
    public static final int TEXT1 = 2;
    public static final int TEXT2 = 4;
    public static final int PROGRESS_BAR0 = 8;
    public static final int PROGRESS_BAR1 = 16;
    public static final int PROGRESS_BAR2 = 32;
    public static final int LIST = 64;
    public static final int ABORT_CLOSE = 128;
    public static final int ENABLE_ABORT_CLOSE = 256;
    public static final int AUTO_ANIMATE = 0x1000000;
    private static I18n i18n;
    private Display display;
    private int animateInterval = 100;
    private long animateTimestamp;
    private Image[] animateImages = new Image[2];
    private int animateImageIndex;
    private boolean animateQuitFlag;
    private Shell dialog;
    private Label widgetImage;
    private Label widgetMessage;
    private Label[] widgetTexts = new Label[4];
    private ProgressBar[] widgetProgressBars = new ProgressBar[3];
    private List widgetList;
    private Button widgetAbortCloseButton;
    private int maxListLength;
    private final String[] messageValue = new String[]{null};
    private final String[] textValues = new String[]{null, null, null, null};
    private final Double[] progressValues = new Double[]{0.0, 0.0, 0.0};
    private final ConcurrentLinkedQueue<String> listValues = new ConcurrentLinkedQueue();
    private boolean doneFlag;
    private boolean abortedFlag;
    private boolean resizedFlag;
    private boolean listEmptyFlag;
    private Boolean redrawRequestedFlag;

    public static void init(I18n i18n) {
        BusyDialog.i18n = i18n;
    }

    public static String tr(String string, Object ... objectArray) {
        if (i18n != null) {
            return i18n.tr(string, objectArray);
        }
        return MessageFormat.format(string, objectArray);
    }

    public BusyDialog(Shell shell, String string, int n, int n2, String string2, final int n3, int n4) {
        this.maxListLength = n4;
        this.display = shell.getDisplay();
        this.animateImages[0] = Widgets.loadImage(this.display, "busy0.png");
        this.animateImages[1] = Widgets.loadImage(this.display, "busy1.png");
        this.animateTimestamp = System.currentTimeMillis();
        this.animateImageIndex = 0;
        this.animateQuitFlag = false;
        this.dialog = new Shell(shell, 67696);
        this.dialog.setText(string);
        TableLayout tableLayout = new TableLayout(new double[]{1.0, 0.0}, 1.0);
        tableLayout.minWidth = n;
        tableLayout.maxWidth = -1;
        tableLayout.minHeight = n2;
        tableLayout.maxHeight = -1;
        this.dialog.setLayout(tableLayout);
        this.dialog.setLayoutData(new TableLayoutData(0, 0, 15));
        Composite composite = new Composite(this.dialog, 0);
        composite.setLayout(new TableLayout(1.0, new double[]{0.0, 1.0}, 4));
        composite.setLayoutData(new TableLayoutData(0, 0, 15));
        this.widgetImage = new Label(composite, 16384);
        this.widgetImage.setImage(this.animateImages[this.animateImageIndex]);
        this.widgetImage.setLayoutData(new TableLayoutData(0, 0, 5, 0, 0, 4, 4));
        Object object = new double[9];
        int n5 = 0;
        if (string2 != null) {
            object[n5] = 0.0;
            ++n5;
        }
        if ((n3 & 1) != 0) {
            object[n5] = (n3 & 0x40) == 0 ? 1.0 : 0.0;
            ++n5;
        }
        if ((n3 & 8) != 0) {
            object[n5] = 0.0;
            ++n5;
        }
        if ((n3 & 2) != 0) {
            object[n5] = (n3 & 0x40) == 0 ? 1.0 : 0.0;
            ++n5;
        }
        if ((n3 & 0x10) != 0) {
            object[n5] = 0.0;
            ++n5;
        }
        if ((n3 & 4) != 0) {
            object[n5] = (n3 & 0x40) == 0 ? 1.0 : 0.0;
            ++n5;
        }
        if ((n3 & 0x20) != 0) {
            object[n5] = 0.0;
            ++n5;
        }
        if ((n3 & 0x40) != 0) {
            object[n5] = 0.0;
            object[++n5] = 1.0;
            ++n5;
        }
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(new TableLayout((double[])object, 1.0));
        composite2.setLayoutData(new TableLayoutData(0, 1, 15));
        n5 = 0;
        if (string2 != null) {
            this.widgetMessage = new Label(composite2, 16384);
            this.widgetMessage.setText(string2);
            this.widgetMessage.setLayoutData(new TableLayoutData(n5, 0, 13));
            ++n5;
        } else {
            this.widgetMessage = null;
        }
        if ((n3 & 1) != 0) {
            this.widgetTexts[0] = new Label(composite2, 16384);
            this.widgetTexts[0].setLayoutData(new TableLayoutData(n5, 0, 12));
            ++n5;
        } else {
            this.widgetTexts[0] = null;
        }
        if ((n3 & 8) != 0) {
            this.widgetProgressBars[0] = new ProgressBar(composite2, 16384);
            this.widgetProgressBars[0].setLayoutData(new TableLayoutData(n5, 0, 12));
            ++n5;
            this.widgetProgressBars[0].setMinimum(0.0);
            this.widgetProgressBars[0].setMaximum(100.0);
        } else {
            this.widgetProgressBars[0] = null;
        }
        if ((n3 & 2) != 0) {
            this.widgetTexts[1] = new Label(composite2, 16384);
            this.widgetTexts[1].setLayoutData(new TableLayoutData(n5, 0, 12));
            ++n5;
        } else {
            this.widgetTexts[1] = null;
        }
        if ((n3 & 0x10) != 0) {
            this.widgetProgressBars[1] = new ProgressBar(composite2, 16384);
            this.widgetProgressBars[1].setLayoutData(new TableLayoutData(n5, 0, 12));
            ++n5;
            this.widgetProgressBars[1].setMinimum(0.0);
            this.widgetProgressBars[1].setMaximum(100.0);
        } else {
            this.widgetProgressBars[1] = null;
        }
        if ((n3 & 4) != 0) {
            this.widgetTexts[2] = new Label(composite2, 16384);
            this.widgetTexts[2].setLayoutData(new TableLayoutData(n5, 0, 12));
            ++n5;
        } else {
            this.widgetTexts[2] = null;
        }
        if ((n3 & 0x20) != 0) {
            this.widgetProgressBars[2] = new ProgressBar(composite2, 16384);
            this.widgetProgressBars[2].setLayoutData(new TableLayoutData(n5, 0, 12));
            ++n5;
            this.widgetProgressBars[2].setMinimum(0.0);
            this.widgetProgressBars[2].setMaximum(100.0);
        } else {
            this.widgetProgressBars[2] = null;
        }
        if ((n3 & 0x40) != 0) {
            this.widgetTexts[3] = new Label(composite2, 16384);
            this.widgetTexts[3].setLayoutData(new TableLayoutData(n5, 0, 12));
            this.widgetList = new List(composite2, 2560);
            this.widgetList.setBackground(this.display.getSystemColor(22));
            this.widgetList.setLayoutData(new TableLayoutData(++n5, 0, 15));
            ++n5;
        } else {
            this.widgetTexts[3] = null;
            this.widgetList = null;
        }
        composite = new Composite(this.dialog, 0);
        composite.setLayout(new TableLayout(0.0, 1.0));
        composite.setLayoutData(new TableLayoutData(1, 0, 12, 0, 0, 4, 4));
        if ((n3 & 0x80) != 0) {
            this.widgetAbortCloseButton = new Button(composite, 0x1000800);
            this.widgetAbortCloseButton.setText(BusyDialog.tr("Abort", new Object[0]));
            this.widgetAbortCloseButton.setEnabled((n3 & 0x100) != 0);
            this.widgetAbortCloseButton.setLayoutData(new TableLayoutData(0, 0, 0, 0, 0, 0, 0, 120, -1));
            this.widgetAbortCloseButton.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    Button button = (Button)selectionEvent.widget;
                    if (BusyDialog.this.isDone()) {
                        BusyDialog.this.close();
                    } else {
                        BusyDialog.this.abort();
                    }
                }
            });
        } else {
            this.widgetAbortCloseButton = null;
        }
        this.dialog.addListener(11, new Listener(){

            @Override
            public void handleEvent(Event event) {
                BusyDialog.this.resizedFlag = true;
            }
        });
        this.dialog.addTraverseListener(new TraverseListener(){

            @Override
            public void keyTraversed(TraverseEvent traverseEvent) {
                Shell shell = (Shell)traverseEvent.widget;
                if (traverseEvent.detail == 2) {
                    if (BusyDialog.this.isDone()) {
                        BusyDialog.this.close();
                    } else {
                        BusyDialog.this.abort();
                    }
                    traverseEvent.doit = false;
                }
            }
        });
        this.dialog.addListener(21, new Listener(){

            @Override
            public void handleEvent(Event event) {
                Shell shell = (Shell)event.widget;
                if ((n3 & 0x100) != 0) {
                    BusyDialog.this.abort();
                }
                event.doit = false;
            }
        });
        this.dialog.pack();
        object = this.display.getCursorLocation();
        Rectangle rectangle = this.display.getBounds();
        Rectangle rectangle2 = this.dialog.getBounds();
        int n6 = Math.min(Math.max(object.x - rectangle2.width / 2, 0), rectangle.width - rectangle2.width - 16);
        int n7 = Math.min(Math.max(object.y - rectangle2.height / 2, 0), rectangle.height - rectangle2.height - 64);
        this.dialog.setLocation(n6, n7);
        if ((n3 & 0x1000000) != 0) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    while (!BusyDialog.this.animateQuitFlag && !BusyDialog.this.dialog.isDisposed()) {
                        BusyDialog.this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                BusyDialog.this.animate();
                            }
                        });
                        try {
                            Thread.sleep(BusyDialog.this.animateInterval);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            };
            thread.start();
        }
        this.doneFlag = false;
        this.abortedFlag = false;
        this.resizedFlag = n != -1 || n2 != -1;
        this.listEmptyFlag = true;
        this.redrawRequestedFlag = false;
        this.dialog.open();
        if (this.widgetAbortCloseButton != null) {
            this.widgetAbortCloseButton.setFocus();
        }
        this.display.update();
        while (this.display.readAndDispatch()) {
        }
    }

    public BusyDialog(Shell shell, String string, Point point, String string2, int n, int n2) {
        this(shell, string, point.x, point.y, string2, n, n2);
    }

    public BusyDialog(Shell shell, String string, int n, int n2, String string2, int n3) {
        this(shell, string, n, n2, string2, n3, -1);
    }

    public BusyDialog(Shell shell, String string, Point point, String string2, int n) {
        this(shell, string, point.x, point.y, string2, n);
    }

    public BusyDialog(Shell shell, String string, int n, int n2, String string2) {
        this(shell, string, n, n2, string2, 384);
    }

    public BusyDialog(Shell shell, String string, Point point, String string2) {
        this(shell, string, point.x, point.y, string2);
    }

    public BusyDialog(Shell shell, String string, int n, int n2, int n3) {
        this(shell, string, n, n2, null, n3);
    }

    public BusyDialog(Shell shell, String string, Point point, int n) {
        this(shell, string, point.x, point.y, n);
    }

    public BusyDialog(Shell shell, String string, int n, int n2) {
        this(shell, string, n, n2, 384);
    }

    public BusyDialog(Shell shell, String string, Point point) {
        this(shell, string, point.x, point.y);
    }

    public BusyDialog(Shell shell, String string, String string2, int n, int n2) {
        this(shell, string, 600, 400, string2, n, n2);
    }

    public BusyDialog(Shell shell, String string, String string2, int n) {
        this(shell, string, 600, 400, string2, n, 100);
    }

    public BusyDialog(Shell shell, String string, String string2) {
        this(shell, string, string2, 0);
    }

    public BusyDialog(Shell shell, String string, int n) {
        this(shell, string, null, n, 100);
    }

    public BusyDialog(Shell shell, String string) {
        this(shell, string, 384);
    }

    public void addListener(int n, Listener listener) {
        this.dialog.addListener(n, listener);
    }

    public void close() {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!BusyDialog.this.dialog.isDisposed()) {
                    BusyDialog.this.dialog.dispose();
                }
            }
        });
    }

    public boolean isClosed() {
        return this.dialog.isDisposed();
    }

    public void done() {
        this.animateQuitFlag = true;
        this.doneFlag = true;
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (BusyDialog.this.widgetAbortCloseButton != null && !BusyDialog.this.widgetAbortCloseButton.isDisposed()) {
                    if (BusyDialog.this.widgetProgressBars[0] != null) {
                        BusyDialog.this.widgetProgressBars[0].setSelection(BusyDialog.this.widgetProgressBars[0].getMaximum());
                    }
                    if (BusyDialog.this.widgetProgressBars[1] != null) {
                        BusyDialog.this.widgetProgressBars[1].setSelection(BusyDialog.this.widgetProgressBars[1].getMaximum());
                    }
                    if (BusyDialog.this.widgetProgressBars[2] != null) {
                        BusyDialog.this.widgetProgressBars[2].setSelection(BusyDialog.this.widgetProgressBars[2].getMaximum());
                    }
                    BusyDialog.this.widgetAbortCloseButton.setText(BusyDialog.tr("Close", new Object[0]));
                    BusyDialog.this.widgetAbortCloseButton.setEnabled(true);
                }
            }
        });
    }

    public boolean isDone() {
        return this.doneFlag;
    }

    public void abort() {
        this.abortedFlag = true;
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (BusyDialog.this.widgetAbortCloseButton != null && !BusyDialog.this.widgetAbortCloseButton.isDisposed()) {
                    BusyDialog.this.widgetAbortCloseButton.setEnabled(false);
                }
            }
        });
    }

    public boolean isAborted() {
        return this.abortedFlag;
    }

    public boolean setMessage(String string, Object ... objectArray) {
        if (!this.display.isDisposed() && !this.dialog.isDisposed()) {
            this.messageValue[0] = String.format(string, objectArray);
            this.updateValues();
            return true;
        }
        return false;
    }

    public void setMinimum(int n, double d) {
        if (this.widgetProgressBars[n] != null) {
            this.widgetProgressBars[n].setMinimum(d);
        }
    }

    public void setMaximum(int n, double d) {
        if (this.widgetProgressBars[n] != null) {
            this.widgetProgressBars[n].setMaximum(d);
        }
    }

    public void setMinimum(double d) {
        this.setMinimum(0, d);
    }

    public void setMaximum(double d) {
        this.setMaximum(0, d);
    }

    public boolean updateText(int n, String string, Object ... objectArray) {
        if (!this.display.isDisposed() && !this.dialog.isDisposed()) {
            this.textValues[n] = string != null ? String.format(string, objectArray) : null;
            this.updateValues();
            return true;
        }
        return false;
    }

    public boolean updateText(int n, Long l) {
        return this.updateText(n, "%d", l);
    }

    public boolean update(int n) {
        return this.updateText(n, null, new Object[0]);
    }

    public boolean updateText(String string, Object ... objectArray) {
        return this.updateText(0, string, objectArray);
    }

    public boolean updateText(String string) {
        return this.updateText(0, "%s", string);
    }

    public boolean updateProgressBar(int n, double d) {
        if (!this.display.isDisposed() && !this.dialog.isDisposed()) {
            this.progressValues[n] = d;
            this.updateValues();
            return true;
        }
        return false;
    }

    public boolean updateProgressBar(double d) {
        return this.updateProgressBar(0, d);
    }

    public boolean updateText(Long l) {
        return this.updateText(0, "%d", l);
    }

    public boolean update() {
        return this.update(0);
    }

    public boolean updateList(String string, Object ... objectArray) {
        if (!this.display.isDisposed() && !this.dialog.isDisposed()) {
            if (string != null) {
                this.listValues.add(String.format(string, objectArray));
                this.updateValues();
            }
            return true;
        }
        return false;
    }

    public boolean updateList(String string) {
        return this.updateList("%s", string);
    }

    public boolean isListEmpty() {
        return this.listEmptyFlag;
    }

    public void setAnimateInterval(int n) {
        this.animateInterval = n;
    }

    private void animate() {
        long l;
        if (!this.dialog.isDisposed() && (l = System.currentTimeMillis()) > this.animateTimestamp + (long)this.animateInterval) {
            this.animateTimestamp = l;
            this.animateImageIndex = (this.animateImageIndex + 1) % 2;
            this.widgetImage.setImage(this.animateImages[this.animateImageIndex]);
        }
    }

    private void updateValues() {
        if (!this.redrawRequestedFlag.booleanValue()) {
            this.redrawRequestedFlag = true;
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!BusyDialog.this.dialog.isDisposed()) {
                        String string;
                        int n;
                        int n2;
                        GC gC;
                        BusyDialog.this.animate();
                        if (BusyDialog.this.messageValue[0] != null) {
                            BusyDialog.this.widgetMessage.setText(BusyDialog.this.messageValue[0]);
                            if (!BusyDialog.this.resizedFlag) {
                                gC = new GC(BusyDialog.this.widgetMessage);
                                n2 = gC.stringExtent((String)((BusyDialog)BusyDialog.this).messageValue[0]).x;
                                gC.dispose();
                                if (((BusyDialog)BusyDialog.this).widgetMessage.getSize().x < n2) {
                                    BusyDialog.this.dialog.pack();
                                }
                            }
                            ((BusyDialog)BusyDialog.this).messageValue[0] = null;
                        }
                        for (n = 0; n < 4; ++n) {
                            if (BusyDialog.this.textValues[n] == null) continue;
                            if (BusyDialog.this.widgetTexts[n] != null && !BusyDialog.this.widgetTexts[n].isDisposed() && !BusyDialog.this.textValues[n].equals(BusyDialog.this.widgetTexts[n].getText())) {
                                BusyDialog.this.widgetTexts[n].setText(BusyDialog.this.textValues[n]);
                                if (!BusyDialog.this.resizedFlag) {
                                    gC = new GC(BusyDialog.this.widgetTexts[n]);
                                    n2 = gC.stringExtent((String)((BusyDialog)BusyDialog.this).textValues[n]).x;
                                    gC.dispose();
                                    if (((BusyDialog)BusyDialog.this).widgetTexts[n].getSize().x < n2) {
                                        BusyDialog.this.dialog.pack();
                                    }
                                }
                            }
                            ((BusyDialog)BusyDialog.this).textValues[n] = null;
                        }
                        for (n = 0; n < 3; ++n) {
                            if (BusyDialog.this.progressValues[n] == null) continue;
                            if (BusyDialog.this.widgetProgressBars[n] != null && !BusyDialog.this.widgetProgressBars[n].isDisposed()) {
                                BusyDialog.this.widgetProgressBars[n].setSelection(BusyDialog.this.progressValues[n]);
                            }
                            ((BusyDialog)BusyDialog.this).progressValues[n] = null;
                        }
                        while ((string = (String)BusyDialog.this.listValues.poll()) != null) {
                            BusyDialog.this.widgetList.add(string);
                            if (BusyDialog.this.maxListLength >= 0) {
                                while (BusyDialog.this.widgetList.getItemCount() > BusyDialog.this.maxListLength) {
                                    BusyDialog.this.widgetList.remove(0);
                                }
                            }
                            BusyDialog.this.widgetList.setSelection(BusyDialog.this.widgetList.getItemCount() - 1);
                            BusyDialog.this.widgetList.showSelection();
                            BusyDialog.this.listEmptyFlag = false;
                            if (BusyDialog.this.resizedFlag) continue;
                            gC = new GC(BusyDialog.this.widgetList);
                            n2 = gC.stringExtent((String)string).x;
                            gC.dispose();
                            if (((BusyDialog)BusyDialog.this).widgetList.getSize().x >= n2) continue;
                            BusyDialog.this.dialog.pack();
                        }
                    }
                    BusyDialog.this.display.update();
                    BusyDialog.this.redrawRequestedFlag = false;
                }
            });
        }
    }
}

