/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayDeque;

class Command {
    public static final int TIMEOUT = 60000;
    public static final int WAIT_FOREVER = -1;
    private static long commandId = 0L;
    public final long id = Command.getCommandId();
    public final String string;
    public ValueMap valueMap;
    public int resultCount;
    public final ResultHandler resultHandler;
    public ArrayDeque<String> resultList;
    public final Handler handler;
    public final int debugLevel;
    private int errorCode;
    private String errorData;
    private boolean completedFlag;
    private boolean abortedFlag;
    private long timeoutTimestamp;

    Command(String string, int n, int n2, ResultHandler resultHandler, Handler handler) {
        this.string = string;
        this.errorCode = 260;
        this.errorData = "";
        this.valueMap = new ValueMap();
        this.completedFlag = false;
        this.abortedFlag = false;
        this.resultCount = 0;
        this.resultHandler = resultHandler;
        this.resultList = new ArrayDeque();
        this.handler = handler;
        this.debugLevel = n;
        this.timeoutTimestamp = n2 != 0 ? System.currentTimeMillis() + (long)n2 : 0L;
    }

    Command(String string, int n, int n2) {
        this(string, n, n2, null, null);
    }

    Command(String string, int n) {
        this(string, n, 0);
    }

    public void send(BufferedWriter bufferedWriter) throws IOException {
        String string = String.format("%d %s", this.id, this.string);
        bufferedWriter.write(string);
        bufferedWriter.write(10);
        bufferedWriter.flush();
        BARServer.logSent(this.debugLevel, "%s", string);
    }

    public synchronized boolean endOfData() {
        while (!this.completedFlag && !this.abortedFlag && this.resultList.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.completedFlag && this.resultList.isEmpty();
    }

    public boolean isCompleted() {
        return this.completedFlag;
    }

    public synchronized void setCompleted() {
        this.completedFlag = true;
        this.notifyAll();
    }

    public boolean isAborted() {
        return this.abortedFlag || this.resultHandler != null && this.resultHandler.isAborted();
    }

    public synchronized void setAborted() {
        this.abortedFlag = true;
        this.notifyAll();
    }

    public synchronized boolean waitForResult(long l) {
        boolean bl = false;
        while (!this.completedFlag && !this.abortedFlag && this.resultList.isEmpty() && l != 0L && !bl) {
            if (this.timeoutTimestamp == 0L || System.currentTimeMillis() < this.timeoutTimestamp) {
                try {
                    if (l > 0L) {
                        this.wait(l);
                        l = 0L;
                        continue;
                    }
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            bl = true;
        }
        return !bl && (this.completedFlag || !this.resultList.isEmpty());
    }

    public synchronized boolean waitForResult() {
        return this.waitForResult(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitCompleted(long l) {
        boolean bl = false;
        Command command = this;
        synchronized (command) {
            while (!(this.completedFlag || this.abortedFlag || l == 0L || bl)) {
                if (this.timeoutTimestamp == 0L || System.currentTimeMillis() < this.timeoutTimestamp) {
                    try {
                        if (l > 0L) {
                            this.wait(l);
                            l = 0L;
                            continue;
                        }
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                bl = true;
            }
        }
        if (bl) return false;
        if (this.completedFlag) return true;
        if (!this.abortedFlag) return false;
        return true;
    }

    public synchronized void setError(int n, String string) {
        this.errorCode = n;
        this.errorData = string;
    }

    public synchronized int getErrorCode() {
        return this.errorCode;
    }

    public synchronized void setErrorCode(int n) {
        this.errorCode = n;
    }

    public synchronized String getErrorData() {
        return this.errorData;
    }

    public synchronized void setErrorData(String string) {
        this.errorData = string;
    }

    public synchronized String getNextResult(long l) {
        while (!this.completedFlag && !this.abortedFlag && this.resultList.isEmpty()) {
            try {
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.resultList.pollFirst();
    }

    public synchronized String getNextResult() {
        return this.resultList.pollFirst();
    }

    public synchronized int getResult(String[] stringArray) {
        stringArray[0] = this.errorCode == 0 ? (!this.resultList.isEmpty() ? this.getNextResult() : "") : this.errorData;
        return this.errorCode;
    }

    public synchronized int getNextResult(String[] stringArray, ValueMap valueMap, int n) {
        if (this.errorCode == 0) {
            this.waitForResult(n);
            if (!this.resultList.isEmpty()) {
                String string = this.getNextResult();
                if (valueMap != null && !string.isEmpty()) {
                    valueMap.clear();
                    if (!StringParser.parse(string, valueMap)) {
                        throw new RuntimeException("parse '" + string + "' fail");
                    }
                }
            }
        }
        if (stringArray != null) {
            stringArray[0] = this.errorData;
        }
        return this.errorCode;
    }

    public synchronized int getNextResult(String[] stringArray, ValueMap valueMap) {
        return this.getNextResult(stringArray, valueMap, 0);
    }

    public synchronized int getResult(String[] stringArray, ValueMap valueMap) {
        if (stringArray != null) {
            stringArray[0] = this.errorData;
        }
        if (valueMap != null) {
            valueMap.clear();
            for (String string : this.valueMap.keySet()) {
                valueMap.put(string, this.valueMap.get(string));
            }
        }
        return this.errorCode;
    }

    public synchronized int getResult(ValueMap valueMap) {
        return this.getResult(null, valueMap);
    }

    public synchronized void purgeResults() {
        String string = this.resultList.pollLast();
        this.resultList.clear();
        if (string != null) {
            this.resultList.add(string);
        }
    }

    public void abort() {
        if (!this.abortedFlag) {
            BARServer.abortCommand(this);
        }
    }

    public void timeout() {
        if (!this.abortedFlag) {
            BARServer.timeoutCommand(this);
        }
    }

    public String toString() {
        return "Command {id=" + this.id + ", errorCode=" + this.errorCode + ", errorData=" + this.errorData + ", completedFlag=" + this.completedFlag + ", results=" + this.resultList.size() + ": " + this.string + "}";
    }

    private static synchronized long getCommandId() {
        return ++commandId;
    }

    static enum Actions {
        NONE,
        CONFIRM,
        REQUEST_PASSWORD;

    }

    static abstract class Handler {
        Handler() {
        }

        public void handle(Command command) {
            this.handle(command.errorCode, command.errorData, command.valueMap);
        }

        public void handle(int n, String string, ValueMap valueMap) {
            throw new Error("result not handled");
        }
    }

    static abstract class ResultHandler {
        private boolean abortedFlag = false;

        ResultHandler() {
        }

        public void handle(int n, ValueMap valueMap) throws BARException {
            this.handle(valueMap);
        }

        public void handle(ValueMap valueMap) throws BARException {
            throw new Error("result not handled: %s");
        }

        public boolean isAborted() {
            return this.abortedFlag;
        }

        public void abort() {
            this.abortedFlag = true;
        }
    }
}

