/*
 * Decompiled with CFR 0.152.
 */
import java.text.SimpleDateFormat;
import java.util.Date;

class JobData
implements Comparable<JobData> {
    String uuid;
    String master;
    String name;
    States state;
    String slaveHostName;
    int slaveHostPort;
    SlaveStates slaveState;
    boolean slaveTLS;
    boolean slaveInsecureTLS;
    ArchiveTypes archiveType;
    long archivePartSize;
    String deltaCompressAlgorithm;
    String byteCompressAlgorithm;
    String cryptAlgorithm;
    String cryptType;
    String cryptPasswordMode;
    long lastExecutedDateTime;
    long estimatedRestTime;
    VolumeRequests volumeRequest;
    MessageCodes messageCode;
    private final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static String formatStateText(States states, String string, SlaveStates slaveStates) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(states.getText());
        if (!string.isEmpty() && slaveStates != SlaveStates.PAIRED) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
                switch (slaveStates) {
                    case OFFLINE: {
                        stringBuilder.append("(" + BARControl.tr("offline", new Object[0]) + ")");
                        break;
                    }
                    case ONLINE: {
                        stringBuilder.append("(" + BARControl.tr("wait pairing", new Object[0]) + ")");
                        break;
                    }
                    case WRONG_MODE: {
                        stringBuilder.append("(" + BARControl.tr("wrong mode", new Object[0]) + ")");
                        break;
                    }
                    case WRONG_PROTOCOL_VERSION: {
                        stringBuilder.append("(" + BARControl.tr("wrong protocol version", new Object[0]) + ")");
                        break;
                    }
                }
            } else {
                switch (slaveStates) {
                    case OFFLINE: {
                        stringBuilder.append(BARControl.tr("offline", new Object[0]));
                        break;
                    }
                    case ONLINE: {
                        stringBuilder.append(BARControl.tr("wait pairing", new Object[0]));
                        break;
                    }
                    case WRONG_MODE: {
                        stringBuilder.append(BARControl.tr("wrong mode", new Object[0]));
                        break;
                    }
                    case WRONG_PROTOCOL_VERSION: {
                        stringBuilder.append(BARControl.tr("wrong protocol version", new Object[0]));
                        break;
                    }
                }
            }
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append("-");
        }
        return stringBuilder.toString();
    }

    JobData(String string, String string2, String string3, States states, String string4, int n, SlaveStates slaveStates, boolean bl, boolean bl2, ArchiveTypes archiveTypes, long l, String string5, String string6, String string7, String string8, String string9, long l2, long l3, VolumeRequests volumeRequests, MessageCodes messageCodes) {
        this.uuid = string;
        this.master = string2;
        this.name = string3;
        this.state = states;
        this.slaveHostName = string4;
        this.slaveHostPort = n;
        this.slaveState = slaveStates;
        this.slaveTLS = bl;
        this.slaveInsecureTLS = bl2;
        this.archiveType = archiveTypes;
        this.archivePartSize = l;
        this.deltaCompressAlgorithm = string5;
        this.byteCompressAlgorithm = string6;
        this.cryptAlgorithm = string7;
        this.cryptType = string8;
        this.cryptPasswordMode = string9;
        this.lastExecutedDateTime = l2;
        this.estimatedRestTime = l3;
        this.volumeRequest = volumeRequests;
        this.messageCode = messageCodes;
    }

    @Override
    public int compareTo(JobData jobData) {
        return this.name.compareTo(jobData.name);
    }

    public String formatCompressAlgorithm() {
        boolean bl = this.deltaCompressAlgorithm.equals("none");
        boolean bl2 = this.byteCompressAlgorithm.equals("none");
        if (!bl || !bl2) {
            StringBuilder stringBuilder = new StringBuilder();
            if (!bl) {
                stringBuilder.append(this.deltaCompressAlgorithm);
            }
            if (!bl2) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('+');
                }
                stringBuilder.append(this.byteCompressAlgorithm);
            }
            return stringBuilder.toString();
        }
        return "";
    }

    public String formatCryptAlgorithm() {
        boolean bl = this.cryptAlgorithm.equals("none");
        return !bl ? this.cryptAlgorithm + (this.cryptType.equals("ASYMMETRIC") ? "*" : "") : "";
    }

    public String formatLastExecutedDateTime() {
        if (this.lastExecutedDateTime > 0L) {
            return this.SIMPLE_DATE_FORMAT.format(new Date(this.lastExecutedDateTime * 1000L));
        }
        return "-";
    }

    public String formatEstimatedRestTime() {
        long l = this.estimatedRestTime / 86400L;
        long l2 = this.estimatedRestTime % 86400L / 3600L;
        long l3 = this.estimatedRestTime % 3600L / 60L;
        long l4 = this.estimatedRestTime % 60L;
        return String.format("%2d days %02d:%02d:%02d", l, l2, l3, l4);
    }

    public String toString() {
        return "Job {" + this.uuid + ", '" + this.master + "', '" + this.name + "', " + (Object)((Object)this.state) + ", '" + this.slaveHostName + ":" + this.slaveHostPort + "', " + this.slaveTLS + ", " + this.slaveInsecureTLS + ", " + (Object)((Object)this.archiveType) + "}";
    }

    static enum MessageCodes {
        NONE,
        WAIT_FOR_TEMPORARY_SPACE,
        BLANK_VOLUME,
        CREATE_IMAGE,
        ADD_ERROR_CORRECTION_CODES,
        WRITE_VOLUME,
        VERIFY_VOLUME;


        public String getText() {
            switch (this) {
                case NONE: {
                    return "";
                }
                case WAIT_FOR_TEMPORARY_SPACE: {
                    return BARControl.tr("Waiting for temporary space", new Object[0]);
                }
                case BLANK_VOLUME: {
                    return BARControl.tr("Blanking volume", new Object[0]) + "\u2026";
                }
                case CREATE_IMAGE: {
                    return BARControl.tr("Creating image", new Object[0]) + "\u2026";
                }
                case ADD_ERROR_CORRECTION_CODES: {
                    return BARControl.tr("Adding error correction codes", new Object[0]) + "\u2026";
                }
                case WRITE_VOLUME: {
                    return BARControl.tr("Writing volume", new Object[0]) + "\u2026";
                }
                case VERIFY_VOLUME: {
                    return BARControl.tr("Verifing volume", new Object[0]) + "\u2026";
                }
            }
            return "";
        }
    }

    static enum VolumeRequests {
        NONE,
        INITIAL,
        REPLACEMENT;

    }

    static enum SlaveStates {
        OFFLINE,
        ONLINE,
        WRONG_MODE,
        WRONG_PROTOCOL_VERSION,
        PAIRED;

    }

    static enum States {
        NONE,
        WAITING,
        RUNNING,
        NO_STORAGE,
        DRY_RUNNING,
        DONE,
        ERROR,
        ABORTED,
        DISCONNECTED;


        public String getText() {
            switch (this) {
                case NONE: {
                    return "";
                }
                case WAITING: {
                    return BARControl.tr("waiting", new Object[0]);
                }
                case RUNNING: {
                    return BARControl.tr("running", new Object[0]);
                }
                case NO_STORAGE: {
                    return BARControl.tr("running (no storage)", new Object[0]);
                }
                case DRY_RUNNING: {
                    return BARControl.tr("dry run", new Object[0]);
                }
                case DONE: {
                    return BARControl.tr("done", new Object[0]);
                }
                case ERROR: {
                    return BARControl.tr("ERROR", new Object[0]);
                }
                case ABORTED: {
                    return BARControl.tr("aborted", new Object[0]);
                }
                case DISCONNECTED: {
                    return BARControl.tr("disconnected", new Object[0]);
                }
            }
            return "";
        }
    }
}

