/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class ProgressBar
extends Canvas {
    private double minimum = 0.0;
    private double maximum = 1.0;
    private int subValueCount = 1;
    private double value = 0.0;
    private double subValue;
    private String text = "";
    private Point textSize = new Point(0, 0);
    private String currentText = "";
    private int currentBarWidth = 0;
    private Color colorBlack = this.getDisplay().getSystemColor(2);
    private Color colorWhite = this.getDisplay().getSystemColor(1);
    private Color colorNormalShadow = this.getDisplay().getSystemColor(18);
    private Color colorHighlightShadow = this.getDisplay().getSystemColor(20);
    private Color colorBar = this.getDisplay().getSystemColor(1);
    private Color colorBarSet = new Color(null, 173, 216, 230);

    ProgressBar(Composite composite, int n) {
        super(composite, n);
        this.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent disposeEvent) {
                ProgressBar.this.widgetDisposed(disposeEvent);
            }
        });
        this.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent paintEvent) {
                ProgressBar.this.paint(paintEvent);
            }
        });
        this.setSelection(0.0);
    }

    ProgressBar(Composite composite) {
        this(composite, 0);
    }

    @Override
    public Point computeSize(int n, int n2, boolean bl) {
        int n3 = 0;
        int n4 = 0;
        n3 = 2 + this.textSize.x + 2;
        n4 = 2 + this.textSize.y + 2;
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        return new Point(n3, n4);
    }

    public double getMinimum() {
        return this.minimum;
    }

    public void setMinimum(double d) {
        this.minimum = d;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public void setMaximum(double d) {
        this.maximum = d;
    }

    public void setRange(double d, double d2) {
        this.minimum = d;
        this.maximum = d2;
    }

    public void setSubValueCount(int n) {
        assert (n > 0);
        this.subValueCount = n;
    }

    public double getSelection() {
        return this.value;
    }

    public void setSelection(String string, double d) {
        String string2;
        double d2;
        if (!this.isDisposed() && this.isRedrawRequired(d2 = Math.min(Math.max(this.maximum - this.minimum > 0.0 ? (d - this.minimum) / (this.maximum - this.minimum) : 0.0, 0.0), 1.0), string2 = String.format(string, d2 * 100.0))) {
            this.value = d2;
            this.subValue = 0.0;
            this.text = string2;
            GC gC = new GC(this);
            this.textSize = gC.stringExtent(this.text);
            gC.dispose();
            this.redraw();
        }
    }

    public void setSelection(double d) {
        this.setSelection("%.1f%%", d);
    }

    public double getSubSelection() {
        return this.subValue;
    }

    public void setSubSelection(double d) {
        String string;
        double d2;
        assert (this.subValueCount > 0);
        if (!this.isDisposed() && this.isRedrawRequired(this.value + (d2 = Math.min(Math.max(this.maximum - this.minimum > 0.0 ? (this.value + d / (double)this.subValueCount - this.minimum) / (this.maximum - this.minimum) : 0.0, 0.0), 1.0)), string = String.format("%.1f%%", (this.value + d2) * 100.0))) {
            this.subValue = d2;
            this.text = string;
            GC gC = new GC(this);
            this.textSize = gC.stringExtent(this.text);
            gC.dispose();
            this.redraw();
        }
    }

    @Override
    public String toString() {
        return "ProgressBar {" + this.minimum + ", " + this.maximum + "}";
    }

    private void widgetDisposed(DisposeEvent disposeEvent) {
        this.colorBarSet.dispose();
    }

    private boolean isRedrawRequired(double d, String string) {
        Rectangle rectangle = this.getBounds();
        int n = rectangle.width;
        int n2 = (int)((double)(n - 4) * (this.value + this.subValue));
        return n2 != this.currentBarWidth || !this.currentText.equals(string);
    }

    private void paint(PaintEvent paintEvent) {
        GC gC = paintEvent.gc;
        Rectangle rectangle = this.getBounds();
        int n = 0;
        int n2 = 0;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = (int)((double)(n3 - 4) * (this.value + this.subValue));
        gC.setForeground(this.colorNormalShadow);
        gC.drawRectangle(n + 0, n2 + 0, n3 - 2, n4 - 2);
        gC.setForeground(this.colorHighlightShadow);
        gC.drawLine(n + 1, n2 + 1, n + n3 - 3, n2 + 1);
        gC.drawLine(n + 1, n2 + 2, n + 1, n2 + n4 - 3);
        gC.drawLine(n + 0, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        gC.drawLine(n + n3 - 1, n2 + 0, n + n3 - 1, n2 + n4 - 2);
        gC.setBackground(this.colorBar);
        gC.fillRectangle(n + 2, n2 + 2, n3 - 4, n4 - 4);
        gC.setBackground(this.colorBarSet);
        gC.fillRectangle(n + 2, n2 + 2, n5, n4 - 4);
        gC.setForeground(this.colorBlack);
        gC.drawString(this.text, (n3 - this.textSize.x) / 2, (n4 - this.textSize.y) / 2, true);
        this.currentText = this.text;
        this.currentBarWidth = n5;
    }
}

