/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;

public class Settings {
    static final String DEFAULT_SERVER_NAME = "localhost";
    static final int DEFAULT_SERVER_PORT = 38523;
    static final int DEFAULT_SERVER_TLS_PORT = 0;
    static final String DEFAULT_BARCONTROL_CONFIG_FILE_NAME = System.getProperty("user.home") + File.separator + ".bar" + File.separator + "barcontrol.cfg";
    static final int MAX_SERVER_HISTORY = 10;
    @SettingComment(text={"BARControl configuration", ""})
    @SettingValue(type=SettingUtils.ValueAdapterSimpleStringArray.class, name="job-table-column-order")
    public static SettingUtils.SimpleStringArray jobListColumnOrder = new SettingUtils.SimpleStringArray();
    @SettingValue(type=SettingValueAdapterWidthArray.class, name="job-table-columns")
    public static ColumnWidth jobTableColumns = new ColumnWidth(110, 130, 90, 90, 80, 80, 100, 150, 120);
    @SettingValue(type=SettingValueAdapterWidthArray.class, name="mount-table-columns")
    public static ColumnWidth mountTableColumns = new ColumnWidth(600, 100);
    @SettingValue(type=SettingValueAdapterWidthArray.class, name="schedule-table-columns")
    public static ColumnWidth scheduleTableColumns = new ColumnWidth(120, 250, 100, 100, 90);
    @SettingValue(type=SettingValueAdapterWidthArray.class, name="persistence-tree-columns")
    public static ColumnWidth persistenceTreeColumns = new ColumnWidth(100, 90, 90, 90, 140, 90, 120);
    @SettingValue(type=SettingValueAdapterSizesArray.class, name="restore-pane-sizes")
    public static PaneSizes restorePaneSizes = new PaneSizes(50.0, 50.0);
    @SettingValue(type=SettingValueAdapterWidthArray.class, name="storage-tree-columns")
    public static ColumnWidth storageTreeColumns = new ColumnWidth(330, 90, 170, 100, 80);
    @SettingValue(type=SettingValueAdapterWidthArray.class, name="storage-table-columns")
    public static ColumnWidth storageTableColumns = new ColumnWidth(420, 90, 90, 100, 80);
    @SettingComment(text={"", "Pause default settings"})
    @SettingValue(name="pause-create")
    public static boolean pauseCreateFlag = true;
    @SettingValue(name="pause-storage")
    public static boolean pauseStorageFlag = false;
    @SettingValue(name="pause-restore")
    public static boolean pauseRestoreFlag = true;
    @SettingValue(name="pause-index-update")
    public static boolean pauseIndexUpdateFlag = false;
    @SettingValue(name="pause-index-maintenance")
    public static boolean pauseIndexMaintenanceFlag = false;
    @SettingComment(text={"", "Server settings"})
    @SettingValue(name="server", type=SettingValueAdapterServer.class, migrate=SettingMigrateServer.class)
    public static LinkedHashSet<Server> servers = new LinkedHashSet();
    @SettingValue(name="server-ca-file")
    public static String serverCAFileName = null;
    @SettingValue(name="server-keystore-file")
    public static String serverKeystoreFileName = null;
    @SettingValue(name="no-tls")
    public static boolean serverNoTLS = false;
    @SettingValue(name="force-tls")
    public static boolean serverForceTLS = false;
    @SettingValue(name="tls-insecure")
    public static boolean serverInsecureTLS = false;
    @SettingValue(name="role")
    public static BARControl.Roles role = BARControl.Roles.BASIC;
    public static Geometry geometry = new Geometry();
    @SettingComment(text={"", "Shortcuts"})
    @SettingValue(name="shortcut")
    public static HashSet<String> shortcuts = new HashSet();
    public static String configFileName = DEFAULT_BARCONTROL_CONFIG_FILE_NAME;
    public static String selectedJobName = null;
    public static boolean loginDialogFlag = false;
    public static boolean pairMasterFlag = false;
    public static LinkedHashSet<String> runJobNames = new LinkedHashSet();
    public static ArchiveTypes archiveType = ArchiveTypes.NORMAL;
    public static String abortJobName = null;
    public static int pauseTime = 0;
    public static int maintenanceTime = 0;
    public static boolean pingFlag = false;
    public static boolean suspendFlag = false;
    public static boolean continueFlag = false;
    public static boolean listJobsFlag = false;
    public static boolean listSchedulesFlag = false;
    public static String infoJobName = null;
    public static boolean indexDatabaseInfo = false;
    public static String indexDatabaseAddStorageName = null;
    public static String indexDatabaseRemoveStorageName = null;
    public static String indexDatabaseRefreshStorageName = null;
    public static String indexDatabaseEntitiesListName = null;
    public static String indexDatabaseStoragesListName = null;
    public static String indexDatabaseEntriesListName = null;
    public static boolean indexDatabaseEntriesListNewestOnly = false;
    public static boolean indexDatabaseHistoryList = false;
    public static String restoreStorageName = null;
    public static String destination = "";
    public static boolean overwriteEntriesFlag = false;
    @SettingValue
    public static Boolean showNoneTLSWarning = true;
    @SettingValue
    public static Boolean showEntriesExceededInfo = true;
    @SettingValue
    public static Boolean showEntriesMarkInfo = true;
    @SettingValue
    public static Boolean showNewVersionInformation = true;
    @SettingValue
    public static Boolean showSlaveDisconnected = true;
    @SettingValue
    public static Boolean showVerboseWarning = true;
    public static boolean longFormatFlag = false;
    public static boolean noHeaderFooterFlag = false;
    public static boolean versionFlag = false;
    public static boolean helpFlag = false;
    public static boolean xhelpFlag = false;
    public static int debugLevel = 0;
    public static boolean debugIgnoreProtocolVersion = false;
    public static boolean debugFakeTLSFlag = false;
    public static boolean debugQuitServerFlag = false;
    public static boolean debugNoVersionInfoFlag = false;
    public static String serverName = null;
    public static int serverPort = -1;
    public static int serverTLSPort = -1;
    public static LinkedHashSet<String> serverNames = new LinkedHashSet();
    @SettingValue(name="server-password", deprecated=true)
    public static String serverPassword = null;

    public static void load(String string) {
        SettingUtils.load(new File(string));
    }

    public static void load() {
        Settings.load(configFileName);
    }

    public static void save(String string) {
        SettingUtils.save(new File(string));
    }

    public static void save() {
        Settings.save(configFileName);
    }

    public static boolean isModified() {
        return SettingUtils.isModified();
    }

    public static Server xxxgetServer(String string, int n) {
        Server server = Settings.getLastServer();
        if (string == null && server != null) {
            string = server.name;
        }
        if (n == -1 && server != null) {
            n = server.port;
        }
        for (Server server2 : servers) {
            if (!server2.name.equals(string) || server2.port != n) continue;
            return server2;
        }
        return null;
    }

    public static Server getLastServer() {
        if (servers.size() > 0) {
            Server[] serverArray = servers.toArray(new Server[servers.size()]);
            return serverArray[serverArray.length - 1];
        }
        return new Server(DEFAULT_SERVER_NAME, 38523);
    }

    public static void addServer(Server server) {
        servers.remove(server);
        servers.add(server);
        while (servers.size() > 10) {
            servers.remove(0);
        }
    }

    public static void addServer(String string, int n, String string2) {
        Settings.addServer(new Server(string, n, string2));
    }

    public static boolean hasBasicRole() {
        return role == BARControl.Roles.BASIC || role == BARControl.Roles.NORMAL || role == BARControl.Roles.EXPERT;
    }

    public static boolean hasNormalRole() {
        return role == BARControl.Roles.NORMAL || role == BARControl.Roles.EXPERT;
    }

    public static boolean hasExpertRole() {
        return role == BARControl.Roles.EXPERT;
    }

    static class Geometry {
        public int width = -1;
        public int height = -1;
        public int x = -1;
        public int y = -1;

        public String toString() {
            return "Geometry {" + this.x + " " + this.y + " " + this.width + " " + this.height + "}";
        }
    }

    class SettingMigrateServer
    implements SettingMigrate {
        SettingMigrateServer() {
        }

        @Override
        public Object run(Object object) {
            LinkedHashSet linkedHashSet = (LinkedHashSet)object;
            for (String string : serverNames) {
                Server server = new Server(string, serverPort, serverPassword);
                linkedHashSet.remove(server);
                linkedHashSet.add(server);
            }
            while (linkedHashSet.size() > 10) {
                linkedHashSet.remove(linkedHashSet.iterator().next());
            }
            return linkedHashSet;
        }
    }

    class SettingValueAdapterServer
    extends SettingUtils.ValueAdapter<String, Server> {
        SettingValueAdapterServer() {
        }

        @Override
        public Server toValue(String string) throws Exception {
            Server server = null;
            Object[] objectArray = new Object[3];
            if (StringParser.parse(string, "%s:%d:%'s", objectArray, "'\"")) {
                String string2 = (String)objectArray[0];
                int n = (Integer)objectArray[1];
                String string3 = (String)objectArray[2];
                server = new Server(string2, n, string3);
            } else if (StringParser.parse(string, "%s:%d", objectArray, "'\"")) {
                String string4 = (String)objectArray[0];
                int n = (Integer)objectArray[1];
                server = new Server(string4, n);
            } else if (StringParser.parse(string, "%s", objectArray, "'\"")) {
                String string5 = (String)objectArray[0];
                server = new Server(string5);
            } else {
                throw new Exception(String.format("Cannot parse server definition '%s'", string));
            }
            return server;
        }

        @Override
        public String toString(Server server) throws Exception {
            if (server.password != null && !server.password.isEmpty()) {
                return StringParser.format("%s:%d:%'s", server.name, server.port, server.password);
            }
            return StringParser.format("%s:%d", server.name, server.port);
        }

        @Override
        public boolean equals(Server server, Server server2) {
            return server.name.equals(server2.name) && server.port == server2.port;
        }
    }

    static class Server
    implements Cloneable,
    Comparable {
        public String name;
        public int port;
        public String password;

        Server(String string, int n, String string2) {
            this.name = string;
            this.port = n;
            this.password = string2;
        }

        Server(String string, int n) {
            this(string, n, "");
        }

        Server(String string) {
            this(string, 38523);
        }

        Server() {
            this("", 0);
        }

        public Server clone() {
            return new Server(this.name, this.port, this.password);
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object object) {
            Server server = (Server)object;
            return this.name.equals(server.name) && this.port == server.port;
        }

        public int compareTo(Object object) {
            Server server = (Server)object;
            int n = this.name.compareTo(server.name);
            if (n == 0) {
                if (this.port < server.port) {
                    n = -1;
                } else if (this.port > server.port) {
                    n = 1;
                }
            }
            return n;
        }

        public String getData() {
            return this.name + ":" + this.port;
        }

        public String toString() {
            return this.name + ":" + this.port;
        }
    }

    class SettingValueAdapterSizesArray
    extends SettingUtils.ValueAdapter<String, PaneSizes> {
        SettingValueAdapterSizesArray() {
        }

        @Override
        public PaneSizes toValue(String string) throws Exception {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            ArrayList<Double> arrayList = new ArrayList<Double>();
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(Double.parseDouble(stringTokenizer.nextToken()) / 100.0);
            }
            return new PaneSizes(arrayList);
        }

        @Override
        public String toString(PaneSizes paneSizes) throws Exception {
            StringBuilder stringBuilder = new StringBuilder();
            for (double d : paneSizes.sizes) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(String.format("%.1f", d * 100.0));
            }
            return stringBuilder.toString();
        }
    }

    static class PaneSizes {
        public final double[] sizes;

        PaneSizes(double ... dArray) {
            this.sizes = new double[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                this.sizes[i] = dArray[i];
            }
        }

        PaneSizes(ArrayList<Double> arrayList) {
            this.sizes = new double[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                this.sizes[i] = arrayList.get(i);
            }
        }

        public double get(int n) {
            return n < this.sizes.length ? this.sizes[n] : 0.0;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (double d : this.sizes) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(Double.toString(d));
            }
            return "PaneSizes {" + stringBuilder.toString() + "}";
        }
    }

    class SettingValueAdapterWidthArray
    extends SettingUtils.ValueAdapter<String, ColumnWidth> {
        SettingValueAdapterWidthArray() {
        }

        @Override
        public ColumnWidth toValue(String string) throws Exception {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(Integer.parseInt(stringTokenizer.nextToken()));
            }
            return new ColumnWidth(arrayList);
        }

        @Override
        public String toString(ColumnWidth columnWidth) throws Exception {
            StringBuilder stringBuilder = new StringBuilder();
            for (int n : columnWidth.width) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(Integer.toString(n));
            }
            return stringBuilder.toString();
        }
    }

    static class ColumnWidth {
        public final int[] width;

        ColumnWidth(int ... nArray) {
            int n = 0;
            this.width = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                this.width[i] = nArray[i];
                n += this.width[i];
            }
            if (n == 0) {
                nArray[0] = 10;
            }
        }

        ColumnWidth(ArrayList<Integer> arrayList) {
            int n = 0;
            this.width = new int[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                this.width[i] = arrayList.get(i);
                n += this.width[i];
            }
            if (n == 0) {
                this.width[0] = 10;
            }
        }

        public int get(int n) {
            return n < this.width.length ? this.width[n] : 0;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (int n : this.width) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(Integer.toString(n));
            }
            return "ColumnWidth {" + stringBuilder.toString() + "}";
        }
    }

    class SettingValueAdapterStringSet
    extends SettingUtils.ValueAdapter<String, LinkedHashSet<String>> {
        SettingValueAdapterStringSet() {
        }

        @Override
        public LinkedHashSet<String> toValue(String string) throws Exception {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            return new LinkedHashSet<String>(arrayList);
        }

        @Override
        public String toString(LinkedHashSet<String> linkedHashSet) throws Exception {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : linkedHashSet) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(string);
            }
            return stringBuilder.toString();
        }
    }
}

