/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

class SimpleProgressDialog {
    private final Data data = new Data();
    private final Display display;
    private final Shell dialog;
    private final ProgressBar widgetProgressBar;

    SimpleProgressDialog(Shell shell, String string, String string2) {
        this.display = shell.getDisplay();
        this.dialog = Dialogs.openModal(shell, string, 250, 70);
        this.dialog.setLayout(new TableLayout(new double[]{1.0, 0.0}, 1.0));
        Composite composite = new Composite(this.dialog, 0);
        composite.setLayout(new TableLayout(null, new double[]{0.0, 1.0}, 4));
        composite.setLayoutData(new TableLayoutData(0, 0, 15));
        Label label = new Label(composite, 16448);
        label.setText(string2);
        label.setLayoutData(new TableLayoutData(0, 0, 7, 0, 0, 4));
        this.widgetProgressBar = new ProgressBar(composite);
        this.widgetProgressBar.setLayoutData(new TableLayoutData(0, 1, 7, 0, 0, 4));
        Dialogs.show(this.dialog);
        this.animate();
    }

    public void animate() {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!SimpleProgressDialog.this.dialog.isDisposed()) {
                    int n = ((SimpleProgressDialog)SimpleProgressDialog.this).data.animationIndex % 8 * 48;
                    int n2 = ((SimpleProgressDialog)SimpleProgressDialog.this).data.animationIndex / 8 * 48;
                    ((SimpleProgressDialog)SimpleProgressDialog.this).data.animationIndex = (((SimpleProgressDialog)SimpleProgressDialog.this).data.animationIndex + 1) % 24;
                }
            }
        });
    }

    public void autoAnimate(final int n) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (!((SimpleProgressDialog)SimpleProgressDialog.this).data.animationQuit) {
                    SimpleProgressDialog.this.animate();
                    try {
                        Thread.sleep(n);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        thread.start();
    }

    public void autoAnimate() {
        this.autoAnimate(500);
    }

    public void close() {
        this.data.animationQuit = true;
        Dialogs.close(this.dialog);
    }

    class Data {
        int animationIndex = 0;
        boolean animationQuit = false;

        Data() {
        }
    }
}

