/*
 * Decompiled with CFR 0.152.
 */
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class TabStatus {
    private final Color COLOR_RUNNING;
    private final Color COLOR_REQUEST;
    private final Color COLOR_ERROR;
    private final Color COLOR_ABORTED;
    private final Image IMAGE_LOCK;
    private final Image IMAGE_LOCK_INSECURE;
    private final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private Shell shell;
    private Display display;
    private UpdateThread updateThread;
    private TabJobs tabJobs;
    private Menu menuTriggerJob;
    public Composite widgetTab;
    private Table widgetJobTable;
    private Shell widgetJobTableToolTip = null;
    private Menu widgetJobTableHeaderMenu;
    private Menu widgetJobTableBodyMenu;
    private Shell widgetMessageToolTip = null;
    private Separator widgetSelectedJob;
    public Button widgetButtonStart;
    public Button widgetButtonAbort;
    public Button widgetButtonPause;
    public Button widgetButtonSuspendContinue;
    private Button widgetButtonVolume;
    public Button widgetButtonQuit;
    private WidgetVariable doneCount = new WidgetVariable(0L);
    private WidgetVariable doneSize = new WidgetVariable(0L);
    private WidgetVariable storageTotalSize = new WidgetVariable(0L);
    private WidgetVariable skippedEntryCount = new WidgetVariable(0L);
    private WidgetVariable skippedEntrySize = new WidgetVariable(0L);
    private WidgetVariable errorEntryCount = new WidgetVariable(0L);
    private WidgetVariable errorEntrySize = new WidgetVariable(0L);
    private WidgetVariable totalEntryCount = new WidgetVariable(0L);
    private WidgetVariable totalEntrySize = new WidgetVariable(0L);
    private WidgetVariable filesPerSecond = new WidgetVariable(0.0);
    private WidgetVariable bytesPerSecond = new WidgetVariable(0.0);
    private WidgetVariable storageBytesPerSecond = new WidgetVariable(0.0);
    private WidgetVariable compressionRatio = new WidgetVariable(0.0);
    private WidgetVariable fileName = new WidgetVariable<String>("");
    private WidgetVariable fileProgress = new WidgetVariable(0.0);
    private WidgetVariable storageName = new WidgetVariable<String>("");
    private WidgetVariable storageProgress = new WidgetVariable(0.0);
    private WidgetVariable volumeNumber = new WidgetVariable(0L);
    private WidgetVariable volumeDone = new WidgetVariable(0.0);
    private WidgetVariable totalEntriesProgress = new WidgetVariable(0.0);
    private WidgetVariable totalBytesProgress = new WidgetVariable(0.0);
    private WidgetVariable collectTotalSumDone = new WidgetVariable(false);
    private WidgetVariable volumeRequestNumber = new WidgetVariable(0);
    private WidgetVariable message = new WidgetVariable<String>("");
    private HashMap<String, JobData> jobDataMap = new HashMap();
    private HashSet<UpdateJobStateListener> updateJobStateListeners = new HashSet();
    private JobData selectedJobData = null;
    private BARServer.States serverState = BARServer.States.RUNNING;
    private int updateStatusFailCount = 0;

    TabStatus(TabFolder tabFolder, int n) {
        this.shell = tabFolder.getShell();
        this.display = this.shell.getDisplay();
        this.COLOR_RUNNING = new Color(null, 160, 255, 160);
        this.COLOR_REQUEST = new Color(null, 255, 255, 160);
        this.COLOR_ERROR = new Color(null, 255, 160, 160);
        this.COLOR_ABORTED = new Color(null, 192, 192, 192);
        this.IMAGE_LOCK = Widgets.loadImage(this.display, "lock.png");
        this.IMAGE_LOCK_INSECURE = Widgets.loadImage(this.display, "lockInsecure.png");
        this.widgetTab = Widgets.addTab(tabFolder, BARControl.tr("Status", new Object[0]) + (n != 0 ? " (" + Widgets.acceleratorToText(n) + ")" : ""));
        this.widgetTab.setLayout(new TableLayout(new double[]{1.0, 0.0, 0.0, 0.0}, 1.0, 2));
        Widgets.layout(this.widgetTab, 0, 0, 15);
        this.widgetTab.addListener(22, new Listener(){

            @Override
            public void handleEvent(Event event) {
                TabStatus.this.update();
            }
        });
        final String[] stringArray = new String[]{"Name", "State", "Slave", "Type", "Part size", "Compress", "Crypt", "Last executed", "Estimated time"};
        this.widgetJobTable = Widgets.newTable(this.widgetTab, 0);
        this.widgetJobTable.setToolTipText(BARControl.tr("List with job entries.\nClick to select job, right-click to open context menu.", new Object[0]));
        this.widgetJobTable.setLayout(new TableLayout(null, null));
        Widgets.layout(this.widgetJobTable, 0, 0, 15);
        this.widgetJobTable.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                JobData jobData = (JobData)selectionEvent.item.getData();
                Widgets.notify((Widget)TabStatus.this.shell, 65539, jobData.uuid);
            }
        });
        SelectionListener selectionListener = new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TableColumn tableColumn = (TableColumn)selectionEvent.widget;
                JobDataComparator jobDataComparator = new JobDataComparator(TabStatus.this.widgetJobTable, tableColumn);
                Widgets.sortTableColumn(TabStatus.this.widgetJobTable, tableColumn, jobDataComparator);
            }
        };
        Listener listener = new Listener(){

            @Override
            public void handleEvent(Event event) {
                int[] nArray = TabStatus.this.widgetJobTable.getColumnOrder();
                String[] stringArray2 = new String[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    stringArray2[i] = stringArray[nArray[i]];
                }
                Settings.jobListColumnOrder = new SettingUtils.SimpleStringArray(stringArray2);
            }
        };
        Listener listener2 = new Listener(){

            @Override
            public void handleEvent(Event event) {
                Settings.jobTableColumns = new Settings.ColumnWidth(Widgets.getTableColumnWidth(TabStatus.this.widgetJobTable));
            }
        };
        TableColumn tableColumn = Widgets.addTableColumn(this.widgetJobTable, 0, BARControl.tr("Name", new Object[0]), 16384, 110, true);
        tableColumn.setToolTipText(BARControl.tr("Click to sort for name.", new Object[0]));
        tableColumn.addSelectionListener(selectionListener);
        tableColumn.setMoveable(true);
        tableColumn.addListener(10, listener);
        tableColumn.addListener(11, listener2);
        tableColumn = Widgets.addTableColumn(this.widgetJobTable, 1, BARControl.tr("State", new Object[0]), 16384, 90, true);
        tableColumn.setToolTipText(BARControl.tr("Click to sort for state.", new Object[0]));
        tableColumn.addSelectionListener(selectionListener);
        tableColumn.setMoveable(true);
        tableColumn.addListener(10, listener);
        tableColumn.addListener(11, listener2);
        tableColumn = Widgets.addTableColumn(this.widgetJobTable, 2, BARControl.tr("Slave", new Object[0]), 16384, 130, true);
        tableColumn.setToolTipText(BARControl.tr("Click to sort for host.", new Object[0]));
        tableColumn.addSelectionListener(selectionListener);
        tableColumn.setMoveable(true);
        tableColumn.addListener(10, listener);
        tableColumn.addListener(11, listener2);
        tableColumn = Widgets.addTableColumn(this.widgetJobTable, 3, BARControl.tr("Type", new Object[0]), 16384, 90, true);
        tableColumn.setToolTipText(BARControl.tr("Click to sort for type.", new Object[0]));
        tableColumn.addSelectionListener(selectionListener);
        tableColumn.setMoveable(true);
        tableColumn.addListener(10, listener);
        tableColumn.addListener(11, listener2);
        tableColumn = Widgets.addTableColumn(this.widgetJobTable, 4, BARControl.tr("Part size", new Object[0]), 131072, 80, true);
        tableColumn.setToolTipText(BARControl.tr("Click to sort for part size.", new Object[0]));
        tableColumn.addSelectionListener(selectionListener);
        tableColumn.setMoveable(true);
        tableColumn.addListener(10, listener);
        tableColumn.addListener(11, listener2);
        tableColumn = Widgets.addTableColumn(this.widgetJobTable, 5, BARControl.tr("Compress", new Object[0]), 16384, 80, true);
        tableColumn.setToolTipText(BARControl.tr("Click to sort for used compress algorithm.", new Object[0]));
        tableColumn.addSelectionListener(selectionListener);
        tableColumn.setMoveable(true);
        tableColumn.addListener(10, listener);
        tableColumn.addListener(11, listener2);
        tableColumn = Widgets.addTableColumn(this.widgetJobTable, 6, BARControl.tr("Crypt", new Object[0]), 16384, 100, true);
        tableColumn.setToolTipText(BARControl.tr("Click to sort for used encryption algorithm.", new Object[0]));
        tableColumn.addSelectionListener(selectionListener);
        tableColumn.setMoveable(true);
        tableColumn.addListener(10, listener);
        tableColumn.addListener(11, listener2);
        tableColumn = Widgets.addTableColumn(this.widgetJobTable, 7, BARControl.tr("Last executed", new Object[0]), 16384, 150, true);
        tableColumn.setToolTipText(BARControl.tr("Click to sort for last date/time job was executed.", new Object[0]));
        tableColumn.addSelectionListener(selectionListener);
        tableColumn.setMoveable(true);
        tableColumn.addListener(10, listener);
        tableColumn.addListener(11, listener2);
        tableColumn = Widgets.addTableColumn(this.widgetJobTable, 8, BARControl.tr("Estimated time", new Object[0]), 16384, 120, false);
        tableColumn.setToolTipText(BARControl.tr("Click to sort for estimated rest time to execute job.", new Object[0]));
        tableColumn.addSelectionListener(selectionListener);
        tableColumn.setMoveable(true);
        tableColumn.addListener(10, listener);
        tableColumn.addListener(11, listener2);
        Widgets.setTableColumnWidth(this.widgetJobTable, Settings.jobTableColumns.width);
        this.widgetJobTable.setColumnOrder(Settings.jobListColumnOrder.getMap(stringArray));
        this.widgetJobTableHeaderMenu = Widgets.newPopupMenu(this.shell);
        MenuItem menuItem = Widgets.addMenuItemCheckbox(this.widgetJobTableHeaderMenu, BARControl.tr("Name", new Object[0]));
        menuItem.setSelection(true);
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuItem menuItem = (MenuItem)selectionEvent.widget;
                Widgets.showTableColumn(TabStatus.this.widgetJobTable, 0, menuItem.getSelection());
            }
        });
        menuItem = Widgets.addMenuItemCheckbox(this.widgetJobTableHeaderMenu, BARControl.tr("State", new Object[0]));
        menuItem.setSelection(true);
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuItem menuItem = (MenuItem)selectionEvent.widget;
                Widgets.showTableColumn(TabStatus.this.widgetJobTable, 1, menuItem.getSelection());
            }
        });
        menuItem = Widgets.addMenuItemCheckbox(this.widgetJobTableHeaderMenu, BARControl.tr("Slave", new Object[0]));
        menuItem.setSelection(true);
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuItem menuItem = (MenuItem)selectionEvent.widget;
                Widgets.showTableColumn(TabStatus.this.widgetJobTable, 2, menuItem.getSelection());
            }
        });
        menuItem = Widgets.addMenuItemCheckbox(this.widgetJobTableHeaderMenu, BARControl.tr("Type", new Object[0]));
        menuItem.setSelection(true);
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuItem menuItem = (MenuItem)selectionEvent.widget;
                Widgets.showTableColumn(TabStatus.this.widgetJobTable, 3, menuItem.getSelection());
            }
        });
        menuItem = Widgets.addMenuItemCheckbox(this.widgetJobTableHeaderMenu, BARControl.tr("Part size", new Object[0]));
        menuItem.setSelection(true);
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuItem menuItem = (MenuItem)selectionEvent.widget;
                Widgets.showTableColumn(TabStatus.this.widgetJobTable, 4, menuItem.getSelection());
            }
        });
        menuItem = Widgets.addMenuItemCheckbox(this.widgetJobTableHeaderMenu, BARControl.tr("Compress", new Object[0]));
        menuItem.setSelection(true);
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuItem menuItem = (MenuItem)selectionEvent.widget;
                Widgets.showTableColumn(TabStatus.this.widgetJobTable, 5, menuItem.getSelection());
            }
        });
        menuItem = Widgets.addMenuItemCheckbox(this.widgetJobTableHeaderMenu, BARControl.tr("Crypt", new Object[0]));
        menuItem.setSelection(true);
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuItem menuItem = (MenuItem)selectionEvent.widget;
                Widgets.showTableColumn(TabStatus.this.widgetJobTable, 6, menuItem.getSelection());
            }
        });
        menuItem = Widgets.addMenuItemCheckbox(this.widgetJobTableHeaderMenu, BARControl.tr("Last executed", new Object[0]));
        menuItem.setSelection(true);
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuItem menuItem = (MenuItem)selectionEvent.widget;
                Widgets.showTableColumn(TabStatus.this.widgetJobTable, 7, menuItem.getSelection());
            }
        });
        menuItem = Widgets.addMenuItemCheckbox(this.widgetJobTableHeaderMenu, BARControl.tr("Estimated time", new Object[0]));
        menuItem.setSelection(true);
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuItem menuItem = (MenuItem)selectionEvent.widget;
                Widgets.showTableColumn(TabStatus.this.widgetJobTable, 8, menuItem.getSelection());
            }
        });
        Widgets.addMenuItemSeparator(this.widgetJobTableHeaderMenu);
        menuItem = Widgets.addMenuItem(this.widgetJobTableHeaderMenu, BARControl.tr("Set optimal column width", new Object[0]));
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Widgets.adjustTableColumnWidth(TabStatus.this.widgetJobTable);
            }
        });
        this.widgetJobTableBodyMenu = Widgets.newPopupMenu(this.shell);
        Menu menu = Widgets.addMenu(this.widgetJobTableBodyMenu, BARControl.tr("Start", new Object[0]) + "\u2026", BARServer.isMaster());
        menuItem = Widgets.addMenuItem(menu, "\u2026", BARServer.isMaster());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (TabStatus.this.selectedJobData != null) {
                    TabStatus.this.jobStart();
                }
            }
        });
        this.addUpdateJobStateListener(new UpdateJobStateListener(menuItem){

            @Override
            public void handle(Widget widget, JobData jobData) {
                MenuItem menuItem = (MenuItem)widget;
                menuItem.setEnabled(jobData.state != JobData.States.RUNNING && jobData.state != JobData.States.NO_STORAGE && jobData.state != JobData.States.DRY_RUNNING && jobData.state != JobData.States.WAITING);
            }
        });
        Widgets.addMenuItemSeparator(menu);
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("normal", new Object[0]), BARServer.isMaster());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (TabStatus.this.selectedJobData != null) {
                    TabStatus.this.jobStart(ArchiveTypes.NORMAL, false, false);
                }
            }
        });
        this.addUpdateJobStateListener(new UpdateJobStateListener(menuItem){

            @Override
            public void handle(Widget widget, JobData jobData) {
                MenuItem menuItem = (MenuItem)widget;
                menuItem.setEnabled(jobData.state != JobData.States.RUNNING && jobData.state != JobData.States.NO_STORAGE && jobData.state != JobData.States.DRY_RUNNING && jobData.state != JobData.States.WAITING);
            }
        });
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("full", new Object[0]), BARServer.isMaster());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (TabStatus.this.selectedJobData != null) {
                    TabStatus.this.jobStart(ArchiveTypes.FULL, false, false);
                }
            }
        });
        this.addUpdateJobStateListener(new UpdateJobStateListener(menuItem){

            @Override
            public void handle(Widget widget, JobData jobData) {
                MenuItem menuItem = (MenuItem)widget;
                menuItem.setEnabled(jobData.state != JobData.States.RUNNING && jobData.state != JobData.States.NO_STORAGE && jobData.state != JobData.States.DRY_RUNNING && jobData.state != JobData.States.WAITING);
            }
        });
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("incremental", new Object[0]), BARServer.isMaster());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (TabStatus.this.selectedJobData != null) {
                    TabStatus.this.jobStart(ArchiveTypes.INCREMENTAL, false, false);
                }
            }
        });
        this.addUpdateJobStateListener(new UpdateJobStateListener(menuItem){

            @Override
            public void handle(Widget widget, JobData jobData) {
                MenuItem menuItem = (MenuItem)widget;
                menuItem.setEnabled(jobData.state != JobData.States.RUNNING && jobData.state != JobData.States.NO_STORAGE && jobData.state != JobData.States.DRY_RUNNING && jobData.state != JobData.States.WAITING);
            }
        });
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("differential", new Object[0]), BARServer.isMaster());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (TabStatus.this.selectedJobData != null) {
                    TabStatus.this.jobStart(ArchiveTypes.DIFFERENTIAL, false, false);
                }
            }
        });
        this.addUpdateJobStateListener(new UpdateJobStateListener(menuItem){

            @Override
            public void handle(Widget widget, JobData jobData) {
                MenuItem menuItem = (MenuItem)widget;
                menuItem.setEnabled(jobData.state != JobData.States.RUNNING && jobData.state != JobData.States.NO_STORAGE && jobData.state != JobData.States.DRY_RUNNING && jobData.state != JobData.States.WAITING);
            }
        });
        menuItem = Widgets.addMenuItem(menu, BARControl.tr("no storage", new Object[0]), BARServer.isMaster());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (TabStatus.this.selectedJobData != null) {
                    TabStatus.this.jobStart(ArchiveTypes.FULL, true, false);
                }
            }
        });
        this.addUpdateJobStateListener(new UpdateJobStateListener(menuItem){

            @Override
            public void handle(Widget widget, JobData jobData) {
                MenuItem menuItem = (MenuItem)widget;
                menuItem.setEnabled(jobData.state != JobData.States.RUNNING && jobData.state != JobData.States.NO_STORAGE && jobData.state != JobData.States.DRY_RUNNING && jobData.state != JobData.States.WAITING);
            }
        });
        Menu menu2 = Widgets.addMenu(menu, BARControl.tr("dry-run", new Object[0]), BARServer.isMaster() && Settings.hasNormalRole());
        menuItem = Widgets.addMenuItem(menu2, BARControl.tr("normal", new Object[0]), BARServer.isMaster());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (TabStatus.this.selectedJobData != null) {
                    TabStatus.this.jobStart(ArchiveTypes.NORMAL, false, true);
                }
            }
        });
        this.addUpdateJobStateListener(new UpdateJobStateListener(menuItem){

            @Override
            public void handle(Widget widget, JobData jobData) {
                MenuItem menuItem = (MenuItem)widget;
                menuItem.setEnabled(jobData.state != JobData.States.RUNNING && jobData.state != JobData.States.NO_STORAGE && jobData.state != JobData.States.DRY_RUNNING && jobData.state != JobData.States.WAITING);
            }
        });
        menuItem = Widgets.addMenuItem(menu2, BARControl.tr("full", new Object[0]), BARServer.isMaster());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (TabStatus.this.selectedJobData != null) {
                    TabStatus.this.jobStart(ArchiveTypes.FULL, false, true);
                }
            }
        });
        this.addUpdateJobStateListener(new UpdateJobStateListener(menuItem){

            @Override
            public void handle(Widget widget, JobData jobData) {
                MenuItem menuItem = (MenuItem)widget;
                menuItem.setEnabled(jobData.state != JobData.States.RUNNING && jobData.state != JobData.States.NO_STORAGE && jobData.state != JobData.States.DRY_RUNNING && jobData.state != JobData.States.WAITING);
            }
        });
        menuItem = Widgets.addMenuItem(menu2, BARControl.tr("incremental", new Object[0]), BARServer.isMaster());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (TabStatus.this.selectedJobData != null) {
                    TabStatus.this.jobStart(ArchiveTypes.INCREMENTAL, false, true);
                }
            }
        });
        this.addUpdateJobStateListener(new UpdateJobStateListener(menuItem){

            @Override
            public void handle(Widget widget, JobData jobData) {
                MenuItem menuItem = (MenuItem)widget;
                menuItem.setEnabled(jobData.state != JobData.States.RUNNING && jobData.state != JobData.States.NO_STORAGE && jobData.state != JobData.States.DRY_RUNNING && jobData.state != JobData.States.WAITING);
            }
        });
        menuItem = Widgets.addMenuItem(menu2, BARControl.tr("differential", new Object[0]), BARServer.isMaster());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (TabStatus.this.selectedJobData != null) {
                    TabStatus.this.jobStart(ArchiveTypes.DIFFERENTIAL, false, true);
                }
            }
        });
        this.addUpdateJobStateListener(new UpdateJobStateListener(menuItem){

            @Override
            public void handle(Widget widget, JobData jobData) {
                MenuItem menuItem = (MenuItem)widget;
                menuItem.setEnabled(jobData.state != JobData.States.RUNNING && jobData.state != JobData.States.NO_STORAGE && jobData.state != JobData.States.DRY_RUNNING && jobData.state != JobData.States.WAITING);
            }
        });
        menuItem = Widgets.addMenuItem(this.widgetJobTableBodyMenu, BARControl.tr("Abort", new Object[0]) + "\u2026", BARServer.isMaster());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (TabStatus.this.selectedJobData != null) {
                    TabStatus.this.jobAbort();
                }
            }
        });
        this.addUpdateJobStateListener(new UpdateJobStateListener(menuItem){

            @Override
            public void handle(Widget widget, JobData jobData) {
                MenuItem menuItem = (MenuItem)widget;
                menuItem.setEnabled(jobData.state == JobData.States.WAITING || jobData.state == JobData.States.RUNNING || jobData.state == JobData.States.NO_STORAGE || jobData.state == JobData.States.DRY_RUNNING);
            }
        });
        menuItem = Widgets.addMenuItem(this.widgetJobTableBodyMenu, BARControl.tr("Pause", new Object[0]), BARServer.isMaster() && Settings.hasNormalRole());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabStatus.this.jobPause(3600L);
            }
        });
        menuItem = Widgets.addMenuItem(this.widgetJobTableBodyMenu, BARControl.tr("Continue", new Object[0]), BARServer.isMaster() && Settings.hasNormalRole());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabStatus.this.jobSuspendContinue();
            }
        });
        this.menuTriggerJob = Widgets.addMenu(this.widgetJobTableBodyMenu, BARControl.tr("Trigger", new Object[0]), BARServer.isMaster());
        Widgets.addMenuItemSeparator(this.widgetJobTableBodyMenu, BARServer.isMaster());
        menuItem = Widgets.addMenuItem(this.widgetJobTableBodyMenu, BARControl.tr("Volume", new Object[0]), BARServer.isMaster());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (TabStatus.this.selectedJobData != null) {
                    TabStatus.this.volume();
                }
            }
        });
        this.addUpdateJobStateListener(new UpdateJobStateListener(menuItem){

            @Override
            public void handle(Widget widget, JobData jobData) {
                MenuItem menuItem = (MenuItem)widget;
                menuItem.setEnabled(jobData.volumeRequest == JobData.VolumeRequests.INITIAL || jobData.volumeRequest == JobData.VolumeRequests.REPLACEMENT);
            }
        });
        menuItem = Widgets.addMenuItem(this.widgetJobTableBodyMenu, BARControl.tr("Reset state", new Object[0]), BARServer.isMaster());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (TabStatus.this.selectedJobData != null) {
                    TabStatus.this.jobReset();
                }
            }
        });
        Widgets.addMenuItemSeparator(this.widgetJobTableBodyMenu, BARServer.isMaster());
        menuItem = Widgets.addMenuItem(this.widgetJobTableBodyMenu, BARControl.tr("New", new Object[0]) + "\u2026", BARServer.isMaster() && Settings.hasNormalRole());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabStatus.this.jobNew();
            }
        });
        menuItem = Widgets.addMenuItem(this.widgetJobTableBodyMenu, BARControl.tr("Clone", new Object[0]) + "\u2026", BARServer.isMaster() && Settings.hasNormalRole());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (TabStatus.this.selectedJobData != null) {
                    TabStatus.this.jobClone();
                }
            }
        });
        menuItem = Widgets.addMenuItem(this.widgetJobTableBodyMenu, BARControl.tr("Rename", new Object[0]) + "\u2026", BARServer.isMaster() && Settings.hasNormalRole());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (TabStatus.this.selectedJobData != null) {
                    TabStatus.this.jobRename();
                }
            }
        });
        menuItem = Widgets.addMenuItem(this.widgetJobTableBodyMenu, BARControl.tr("Delete", new Object[0]) + "\u2026", BARServer.isMaster() && Settings.hasNormalRole());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (TabStatus.this.selectedJobData != null) {
                    TabStatus.this.jobDelete();
                }
            }
        });
        Widgets.addMenuItemSeparator(this.widgetJobTableBodyMenu, BARServer.isMaster() && Settings.hasNormalRole());
        menuItem = Widgets.addMenuItem(this.widgetJobTableBodyMenu, BARControl.tr("Info", new Object[0]) + "\u2026", BARServer.isMaster());
        menuItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem[] tableItemArray = TabStatus.this.widgetJobTable.getSelection();
                if (tableItemArray.length > 0) {
                    JobData jobData;
                    if (TabStatus.this.widgetJobTableToolTip != null) {
                        TabStatus.this.widgetJobTableToolTip.dispose();
                        TabStatus.this.widgetJobTableToolTip = null;
                    }
                    if (tableItemArray[0] != null && (jobData = (JobData)tableItemArray[0].getData()) != null) {
                        Point point = TabStatus.this.display.getCursorLocation();
                        if (point.x > 16) {
                            point.x -= 16;
                        }
                        if (point.y > 16) {
                            point.y -= 16;
                        }
                        TabStatus.this.showJobToolTip(jobData, point.x, point.y);
                    }
                }
            }
        });
        this.widgetJobTableBodyMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuShown(MenuEvent menuEvent) {
                if (TabStatus.this.widgetJobTableToolTip != null) {
                    TabStatus.this.widgetJobTableToolTip.dispose();
                    TabStatus.this.widgetJobTableToolTip = null;
                }
            }

            @Override
            public void menuHidden(MenuEvent menuEvent) {
            }
        });
        this.widgetJobTable.addListener(35, new Listener(){

            @Override
            public void handleEvent(Event event) {
                Table table = (Table)event.widget;
                Point point = TabStatus.this.display.map(null, (Control)table, new Point(event.x, event.y));
                Rectangle rectangle = table.getClientArea();
                boolean bl = rectangle.y <= point.y && point.y < rectangle.y + table.getHeaderHeight();
                table.setMenu(bl ? TabStatus.this.widgetJobTableHeaderMenu : TabStatus.this.widgetJobTableBodyMenu);
            }
        });
        this.widgetJobTable.addListener(12, new Listener(){

            @Override
            public void handleEvent(Event event) {
                TabStatus.this.widgetJobTableHeaderMenu.dispose();
                TabStatus.this.widgetJobTableBodyMenu.dispose();
            }
        });
        this.widgetSelectedJob = Widgets.newSeparator(this.widgetTab, BARControl.tr("Selected", new Object[0]) + " ''", 0);
        Widgets.layout(this.widgetSelectedJob, 1, 0, 12);
        Composite composite = Widgets.newComposite(this.widgetTab);
        composite.setLayout(new TableLayout(0.0, new double[]{0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0}, 4));
        Widgets.layout(composite, 2, 0, 12);
        Label label = Widgets.newLabel(composite, BARControl.tr("Done", new Object[0]) + ":");
        Widgets.layout(label, 0, 0, 4);
        label = Widgets.newNumberView(composite);
        Widgets.layout(label, 0, 1, 12);
        Widgets.addModifyListener(new WidgetModifyListener((Widget)label, this.doneCount));
        label = Widgets.newLabel(composite, BARControl.tr("entries", new Object[0]));
        Widgets.layout(label, 0, 2, 4);
        label = Widgets.newNumberView(composite);
        Widgets.layout(label, 0, 3, 12);
        Widgets.addModifyListener(new WidgetModifyListener((Widget)label, this.doneSize));
        label = Widgets.newLabel(composite, BARControl.tr("bytes", new Object[0]));
        Widgets.layout(label, 0, 4, 4);
        label = Widgets.newLabel(composite, "/");
        Widgets.layout(label, 0, 5, 4);
        label = Widgets.newNumberView(composite);
        Widgets.layout(label, 0, 6, 12);
        Widgets.addModifyListener(new WidgetModifyListener(label, new WidgetVariable[]{this.doneSize}){

            @Override
            public String getString(WidgetVariable widgetVariable) {
                return Units.getSize(widgetVariable.getLong());
            }
        });
        label = Widgets.newLabel(composite, BARControl.tr("bytes", new Object[0]));
        Widgets.layout(label, 0, 7, 4, 0, 0, 0, 0, Units.getMaxByteUnitTextSize(label));
        Widgets.addModifyListener(new WidgetModifyListener(label, new WidgetVariable[]{this.doneSize}){

            @Override
            public String getString(WidgetVariable widgetVariable) {
                return Units.getByteUnit(widgetVariable.getLong());
            }
        });
        Control control = Widgets.newSpacer(composite);
        Widgets.layout(control, 0, 8, 4, 0, 0, 4, 0);
        Composite composite2 = Widgets.newComposite(composite);
        composite2.setLayout(new TableLayout(0.0, new double[]{1.0, 0.0}));
        Widgets.layout(composite2, 0, 9, 12);
        label = Widgets.newNumberView(composite2);
        Widgets.layout(label, 0, 0, 12);
        Widgets.addModifyListener(new WidgetModifyListener(label, new WidgetVariable[]{this.filesPerSecond}){

            @Override
            public String getString(WidgetVariable widgetVariable) {
                return String.format("%.1f", widgetVariable.getDouble());
            }
        });
        label = Widgets.newLabel(composite2, BARControl.tr("files/s", new Object[0]));
        Widgets.layout(label, 0, 1, 4);
        composite2 = Widgets.newComposite(composite);
        composite2.setLayout(new TableLayout(0.0, new double[]{1.0, 0.0}));
        Widgets.layout(composite2, 0, 10, 12);
        label = Widgets.newNumberView(composite2);
        Widgets.layout(label, 0, 0, 12);
        Widgets.addModifyListener(new WidgetModifyListener(label, new WidgetVariable[]{this.bytesPerSecond}){

            @Override
            public String getString(WidgetVariable widgetVariable) {
                return Units.getSize(widgetVariable.getDouble());
            }
        });
        label = Widgets.newLabel(composite2, BARControl.tr("bytes/s", new Object[0]));
        Widgets.layout(label, 0, 1, 4, 0, 0, 0, 0, Units.getMaxByteUnitTextSize(label, "/s"));
        Widgets.addModifyListener(new WidgetModifyListener(label, new WidgetVariable[]{this.bytesPerSecond}){

            @Override
            public String getString(WidgetVariable widgetVariable) {
                return Units.getByteUnit(widgetVariable.getDouble()) + "/s";
            }
        });
        label = Widgets.newLabel(composite, BARControl.tr("Stored", new Object[0]) + ":");
        Widgets.layout(label, 1, 0, 4);
        label = Widgets.newNumberView(composite);
        Widgets.layout(label, 1, 3, 12);
        Widgets.addModifyListener(new WidgetModifyListener((Widget)label, this.storageTotalSize));
        label = Widgets.newLabel(composite, BARControl.tr("bytes", new Object[0]));
        Widgets.layout(label, 1, 4, 4);
        label = Widgets.newLabel(composite, "/");
        Widgets.layout(label, 1, 5, 4);
        label = Widgets.newNumberView(composite);
        Widgets.layout(label, 1, 6, 12);
        Widgets.addModifyListener(new WidgetModifyListener(label, new WidgetVariable[]{this.storageTotalSize}){

            @Override
            public String getString(WidgetVariable widgetVariable) {
                return Units.getSize(widgetVariable.getLong());
            }
        });
        label = Widgets.newLabel(composite, BARControl.tr("bytes", new Object[0]));
        Widgets.layout(label, 1, 7, 4, 0, 0, 0, 0, Units.getMaxByteUnitTextSize(label));
        Widgets.addModifyListener(new WidgetModifyListener(label, new WidgetVariable[]{this.storageTotalSize}){

            @Override
            public String getString(WidgetVariable widgetVariable) {
                return Units.getByteUnit(widgetVariable.getLong());
            }
        });
        control = Widgets.newSpacer(composite);
        Widgets.layout(control, 1, 8, 4, 0, 0, 4, 0);
        composite2 = Widgets.newComposite(composite);
        composite2.setLayout(new TableLayout(0.0, new double[]{0.0, 1.0, 0.0}));
        Widgets.layout(composite2, 1, 9, 12);
        label = Widgets.newLabel(composite2, BARControl.tr("Ratio", new Object[0]));
        Widgets.layout(label, 0, 0, 4);
        label = Widgets.newNumberView(composite2);
        Widgets.layout(label, 0, 1, 12);
        Widgets.addModifyListener(new WidgetModifyListener(label, new WidgetVariable[]{this.compressionRatio}){

            @Override
            public String getString(WidgetVariable widgetVariable) {
                return String.format("%.1f", widgetVariable.getDouble());
            }
        });
        label = Widgets.newLabel(composite2, "%");
        Widgets.layout(label, 0, 2, 4);
        composite2 = Widgets.newComposite(composite);
        composite2.setLayout(new TableLayout(0.0, new double[]{1.0, 0.0}));
        Widgets.layout(composite2, 1, 10, 12);
        label = Widgets.newNumberView(composite2);
        Widgets.layout(label, 0, 0, 12);
        Widgets.addModifyListener(new WidgetModifyListener(label, new WidgetVariable[]{this.storageBytesPerSecond}){

            @Override
            public String getString(WidgetVariable widgetVariable) {
                return Units.getSize(widgetVariable.getDouble());
            }
        });
        label = Widgets.newLabel(composite2, BARControl.tr("bytes/s", new Object[0]));
        Widgets.layout(label, 0, 1, 4, 0, 0, 0, 0, Units.getMaxByteUnitTextSize(label, "/s"));
        Widgets.addModifyListener(new WidgetModifyListener(label, new WidgetVariable[]{this.storageBytesPerSecond}){

            @Override
            public String getString(WidgetVariable widgetVariable) {
                return Units.getByteUnit(widgetVariable.getDouble()) + "/s";
            }
        });
        label = Widgets.newLabel(composite, BARControl.tr("Skipped", new Object[0]) + ":");
        Widgets.layout(label, 2, 0, 4);
        label = Widgets.newNumberView(composite);
        Widgets.layout(label, 2, 1, 12);
        Widgets.addModifyListener(new WidgetModifyListener((Widget)label, this.skippedEntryCount));
        label = Widgets.newLabel(composite, BARControl.tr("entries", new Object[0]));
        Widgets.layout(label, 2, 2, 4);
        label = Widgets.newNumberView(composite);
        Widgets.layout(label, 2, 3, 12);
        Widgets.addModifyListener(new WidgetModifyListener((Widget)label, this.skippedEntrySize));
        label = Widgets.newLabel(composite, BARControl.tr("bytes", new Object[0]));
        Widgets.layout(label, 2, 4, 4);
        label = Widgets.newLabel(composite, "/");
        Widgets.layout(label, 2, 5, 4);
        label = Widgets.newNumberView(composite);
        Widgets.layout(label, 2, 6, 12);
        Widgets.addModifyListener(new WidgetModifyListener(label, new WidgetVariable[]{this.skippedEntrySize}){

            @Override
            public String getString(WidgetVariable widgetVariable) {
                return Units.getSize(widgetVariable.getLong());
            }
        });
        label = Widgets.newLabel(composite, BARControl.tr("bytes", new Object[0]));
        Widgets.layout(label, 2, 7, 4, 0, 0, 0, 0, Units.getMaxByteUnitTextSize(label));
        Widgets.addModifyListener(new WidgetModifyListener(label, new WidgetVariable[]{this.skippedEntrySize}){

            @Override
            public String getString(WidgetVariable widgetVariable) {
                return Units.getByteUnit(widgetVariable.getLong());
            }
        });
        label = Widgets.newLabel(composite, BARControl.tr("Errors", new Object[0]) + ":");
        Widgets.layout(label, 3, 0, 4);
        label = Widgets.newNumberView(composite);
        Widgets.layout(label, 3, 1, 12);
        Widgets.addModifyListener(new WidgetModifyListener((Widget)label, this.errorEntryCount));
        label = Widgets.newLabel(composite, BARControl.tr("entries", new Object[0]));
        Widgets.layout(label, 3, 2, 4);
        label = Widgets.newNumberView(composite);
        Widgets.layout(label, 3, 3, 12);
        Widgets.addModifyListener(new WidgetModifyListener((Widget)label, this.errorEntrySize));
        label = Widgets.newLabel(composite, BARControl.tr("bytes", new Object[0]));
        Widgets.layout(label, 3, 4, 4);
        label = Widgets.newLabel(composite, "/");
        Widgets.layout(label, 3, 5, 4);
        label = Widgets.newNumberView(composite);
        Widgets.layout(label, 3, 6, 12);
        Widgets.addModifyListener(new WidgetModifyListener(label, new WidgetVariable[]{this.errorEntrySize}){

            @Override
            public String getString(WidgetVariable widgetVariable) {
                return Units.getSize(widgetVariable.getLong());
            }
        });
        label = Widgets.newLabel(composite, BARControl.tr("bytes", new Object[0]));
        Widgets.layout(label, 3, 7, 4, 0, 0, 0, 0, Units.getMaxByteUnitTextSize(label));
        Widgets.addModifyListener(new WidgetModifyListener(label, new WidgetVariable[]{this.errorEntrySize}){

            @Override
            public String getString(WidgetVariable widgetVariable) {
                return Units.getByteUnit(widgetVariable.getLong());
            }
        });
        label = Widgets.newLabel(composite, BARControl.tr("Total", new Object[0]) + ":");
        Widgets.layout(label, 4, 0, 4);
        label = Widgets.newNumberView(composite);
        Widgets.layout(label, 4, 1, 12);
        Widgets.addModifyListener(new WidgetModifyListener((Widget)label, this.totalEntryCount));
        Widgets.addModifyListener(new WidgetModifyListener(label, new WidgetVariable[]{this.collectTotalSumDone}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                Color color = TabStatus.this.display.getSystemColor(16);
                control.setForeground(widgetVariable.getBoolean() ? null : color);
            }
        });
        label = Widgets.newLabel(composite, BARControl.tr("entries", new Object[0]));
        Widgets.layout(label, 4, 2, 4);
        label = Widgets.newNumberView(composite);
        Widgets.layout(label, 4, 3, 12);
        Widgets.addModifyListener(new WidgetModifyListener((Widget)label, this.totalEntrySize));
        Widgets.addModifyListener(new WidgetModifyListener(label, new WidgetVariable[]{this.collectTotalSumDone}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                Color color = TabStatus.this.display.getSystemColor(16);
                control.setForeground(widgetVariable.getBoolean() ? null : color);
            }
        });
        label = Widgets.newLabel(composite, BARControl.tr("bytes", new Object[0]));
        Widgets.layout(label, 4, 4, 4);
        label = Widgets.newLabel(composite, "/");
        Widgets.layout(label, 4, 5, 4);
        label = Widgets.newNumberView(composite);
        Widgets.layout(label, 4, 6, 12);
        Widgets.addModifyListener(new WidgetModifyListener(label, new WidgetVariable[]{this.totalEntrySize}){

            @Override
            public String getString(WidgetVariable widgetVariable) {
                return Units.getSize(widgetVariable.getLong());
            }
        });
        Widgets.addModifyListener(new WidgetModifyListener(label, new WidgetVariable[]{this.collectTotalSumDone}){

            @Override
            public void modified(Control control, WidgetVariable widgetVariable) {
                Color color = TabStatus.this.display.getSystemColor(16);
                control.setForeground(widgetVariable.getBoolean() ? null : color);
            }
        });
        label = Widgets.newLabel(composite, BARControl.tr("bytes", new Object[0]));
        Widgets.layout(label, 4, 7, 4, 0, 0, 0, 0, Units.getMaxByteUnitTextSize(label));
        Widgets.addModifyListener(new WidgetModifyListener(label, new WidgetVariable[]{this.totalEntrySize}){

            @Override
            public String getString(WidgetVariable widgetVariable) {
                return Units.getByteUnit(widgetVariable.getLong());
            }
        });
        label = Widgets.newLabel(composite, BARControl.tr("File", new Object[0]) + ":");
        Widgets.layout(label, 5, 0, 4);
        label = Widgets.newView(composite);
        Widgets.layout(label, 5, 1, 12, 0, 10);
        Widgets.addModifyListener(new WidgetModifyListener((Widget)label, this.fileName));
        ProgressBar progressBar = Widgets.newProgressBar(composite);
        Widgets.layout(progressBar, 6, 1, 12, 0, 10);
        Widgets.addModifyListener(new WidgetModifyListener((Widget)progressBar, this.fileProgress));
        label = Widgets.newLabel(composite, BARControl.tr("Storage", new Object[0]) + ":");
        Widgets.layout(label, 7, 0, 4);
        label = Widgets.newView(composite);
        Widgets.layout(label, 7, 1, 12, 0, 10);
        Widgets.addModifyListener(new WidgetModifyListener((Widget)label, this.storageName));
        progressBar = Widgets.newProgressBar(composite);
        Widgets.layout(progressBar, 8, 1, 12, 0, 10);
        Widgets.addModifyListener(new WidgetModifyListener((Widget)progressBar, this.storageProgress));
        label = Widgets.newLabel(composite, BARControl.tr("Volume", new Object[0]) + ":");
        Widgets.layout(label, 9, 0, 4);
        progressBar = Widgets.newProgressBar(composite);
        Widgets.layout(progressBar, 9, 1, 12, 0, 10);
        Widgets.addModifyListener(new WidgetModifyListener((Widget)progressBar, this.volumeDone));
        label = Widgets.newLabel(composite, BARControl.tr("Total files", new Object[0]) + ":");
        Widgets.layout(label, 10, 0, 4);
        progressBar = Widgets.newProgressBar(composite);
        Widgets.layout(progressBar, 10, 1, 12, 0, 10);
        Widgets.addModifyListener(new WidgetModifyListener((Widget)progressBar, this.totalEntriesProgress));
        label = Widgets.newLabel(composite, BARControl.tr("Total bytes", new Object[0]) + ":");
        Widgets.layout(label, 11, 0, 4);
        progressBar = Widgets.newProgressBar(composite);
        Widgets.layout(progressBar, 11, 1, 12, 0, 10);
        Widgets.addModifyListener(new WidgetModifyListener((Widget)progressBar, this.totalBytesProgress));
        label = Widgets.newLabel(composite, BARControl.tr("Message", new Object[0]) + ":");
        Widgets.layout(label, 12, 0, 4);
        label = Widgets.newView(composite);
        Widgets.layout(label, 12, 1, 12, 0, 10);
        Widgets.addModifyListener(new WidgetModifyListener(label, new WidgetVariable[]{this.message}){

            @Override
            public String getString(WidgetVariable widgetVariable) {
                return TabStatus.this.message.getString().replaceAll("\\n+", " ");
            }
        });
        label.addMouseTrackListener(new MouseTrackListener(){

            @Override
            public void mouseEnter(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExit(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseHover(MouseEvent mouseEvent) {
                Label label = (Label)mouseEvent.widget;
                if (TabStatus.this.widgetMessageToolTip != null) {
                    TabStatus.this.widgetMessageToolTip.dispose();
                    TabStatus.this.widgetMessageToolTip = null;
                }
                if (!TabStatus.this.message.getString().isEmpty()) {
                    Color color = TabStatus.this.display.getSystemColor(28);
                    Color color2 = TabStatus.this.display.getSystemColor(29);
                    TabStatus.this.widgetMessageToolTip = new Shell(TabStatus.this.shell, 540676);
                    TabStatus.this.widgetMessageToolTip.setBackground(color2);
                    TabStatus.this.widgetMessageToolTip.setLayout(new TableLayout(0.0, new double[]{0.0, 1.0}, 2));
                    Widgets.layout(TabStatus.this.widgetMessageToolTip, 0, 0, 15);
                    Text text = Widgets.newText((Composite)TabStatus.this.widgetMessageToolTip, 16962);
                    text.setText(TabStatus.this.message.getString());
                    text.setForeground(color);
                    text.setBackground(color2);
                    Widgets.layout(text, 0, 0, 15, 0, 0, 0, 0, 300, 100);
                    Widgets.showToolTip(TabStatus.this.widgetMessageToolTip, (Control)mouseEvent.widget);
                }
            }
        });
        composite = Widgets.newComposite(this.widgetTab);
        composite.setLayout(new TableLayout(null, new double[]{0.0, 0.0, 0.0, 0.0, 1.0}));
        Widgets.layout(composite, 3, 0, 12);
        this.widgetButtonStart = Widgets.newButton(composite, null, BARControl.tr("Start", new Object[0]) + "\u2026", BARServer.isMaster());
        this.widgetButtonStart.setToolTipText(BARControl.tr("Start selected job.", new Object[0]));
        this.widgetButtonStart.setEnabled(false);
        Widgets.layout(this.widgetButtonStart, 0, 0, 4, 0, 0, 0, 0, 120, -1);
        this.widgetButtonStart.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (TabStatus.this.selectedJobData != null) {
                    TabStatus.this.jobStart();
                }
            }
        });
        this.addUpdateJobStateListener(new UpdateJobStateListener(this.widgetButtonStart){

            @Override
            public void handle(Widget widget, JobData jobData) {
                Button button = (Button)widget;
                button.setEnabled(jobData.state == JobData.States.NONE || jobData.state == JobData.States.DONE || jobData.state == JobData.States.ERROR || jobData.state == JobData.States.ABORTED);
            }
        });
        this.widgetButtonAbort = Widgets.newButton(composite, null, BARControl.tr("Abort", new Object[0]) + "\u2026", BARServer.isMaster());
        this.widgetButtonAbort.setToolTipText(BARControl.tr("Abort selected job.", new Object[0]));
        this.widgetButtonAbort.setEnabled(false);
        Widgets.layout(this.widgetButtonAbort, 0, 1, 4, 0, 0, 0, 0, 120, -1);
        this.widgetButtonAbort.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (TabStatus.this.selectedJobData != null) {
                    TabStatus.this.jobAbort();
                }
            }
        });
        this.addUpdateJobStateListener(new UpdateJobStateListener(this.widgetButtonAbort){

            @Override
            public void handle(Widget widget, JobData jobData) {
                Button button = (Button)widget;
                button.setEnabled(jobData.state == JobData.States.WAITING || jobData.state == JobData.States.RUNNING || jobData.state == JobData.States.NO_STORAGE || jobData.state == JobData.States.DRY_RUNNING);
            }
        });
        this.widgetButtonPause = Widgets.newButton(composite, null, BARControl.tr("Pause", new Object[0]), BARServer.isMaster() && Settings.hasNormalRole());
        this.widgetButtonPause.setToolTipText(BARControl.tr("Pause selected job for a specific time.", new Object[0]));
        Widgets.layout(this.widgetButtonPause, 0, 2, 4, 0, 0, 0, 0, 120, -1, -1, -1);
        this.widgetButtonPause.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabStatus.this.jobPause(3600L);
            }
        });
        this.widgetButtonSuspendContinue = Widgets.newButton(composite, null, BARControl.tr("Continue", new Object[0]), BARServer.isMaster() && Settings.hasNormalRole());
        this.widgetButtonSuspendContinue.setToolTipText(BARControl.tr("Suspend selected job for an infinite time.", new Object[0]));
        Widgets.layout(this.widgetButtonSuspendContinue, 0, 3, 4, 0, 0, 0, 0, 120, -1, -1, -1);
        this.widgetButtonSuspendContinue.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabStatus.this.jobSuspendContinue();
            }
        });
        this.widgetButtonVolume = Widgets.newButton(composite, null, BARControl.tr("Volume", new Object[0]), BARServer.isMaster());
        this.widgetButtonVolume.setToolTipText(BARControl.tr("Click when a new volume is available in drive.", new Object[0]));
        this.widgetButtonVolume.setEnabled(false);
        Widgets.layout(this.widgetButtonVolume, 0, 4, 4, 0, 0, 0, 0, 120, -1);
        this.widgetButtonVolume.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (TabStatus.this.selectedJobData != null) {
                    TabStatus.this.volume();
                    TabStatus.this.widgetButtonVolume.setEnabled(false);
                }
            }
        });
        this.addUpdateJobStateListener(new UpdateJobStateListener(this.widgetButtonVolume){

            @Override
            public void handle(Widget widget, JobData jobData) {
                Button button = (Button)widget;
                button.setEnabled(jobData.volumeRequest == JobData.VolumeRequests.INITIAL || jobData.volumeRequest == JobData.VolumeRequests.REPLACEMENT);
            }
        });
        this.widgetButtonQuit = Widgets.newButton(composite, null, BARControl.tr("Quit", new Object[0]));
        this.widgetButtonQuit.setToolTipText(BARControl.tr("Quit BARControl program.", new Object[0]));
        Widgets.layout(this.widgetButtonQuit, 0, 5, 8, 0, 0, 0, 0, 80, -1);
        this.widgetButtonQuit.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Event event = new Event();
                TabStatus.this.shell.notifyListeners(21, event);
            }
        });
        this.shell.addListener(65535, new Listener(){

            @Override
            public void handleEvent(Event event) {
                TabStatus.this.clearSelectedJob();
                TabStatus.this.updateJobList();
            }
        });
        this.shell.addListener(65536, new Listener(){

            @Override
            public void handleEvent(Event event) {
                assert (event.text != null);
                TabStatus.this.updateJobList();
                JobData jobData = (JobData)TabStatus.this.jobDataMap.get(event.text);
                Widgets.notify((Widget)TabStatus.this.shell, 65539, jobData.uuid);
            }
        });
        this.shell.addListener(65537, new Listener(){

            @Override
            public void handleEvent(Event event) {
                TabStatus.this.updateJobList();
                TabStatus.this.setSelectedJob(TabStatus.this.selectedJobData);
            }
        });
        this.shell.addListener(65538, new Listener(){

            @Override
            public void handleEvent(Event event) {
                assert (event.text != null);
                TabStatus.this.updateJobList();
                TabStatus.this.clearSelectedJob();
            }
        });
        this.shell.addListener(65539, new Listener(){

            @Override
            public void handleEvent(Event event) {
                assert (event.text != null);
                TabStatus.this.setSelectedJob((JobData)TabStatus.this.jobDataMap.get(event.text));
            }
        });
        this.updateThread = new UpdateThread();
    }

    void setTabJobs(TabJobs tabJobs) {
        this.tabJobs = tabJobs;
    }

    public void startUpdate() {
        this.updateThread.start();
    }

    public JobData getJobByName(String string) {
        for (JobData jobData : this.jobDataMap.values()) {
            if (!jobData.name.equals(string)) continue;
            return jobData;
        }
        return null;
    }

    public void addUpdateJobStateListener(UpdateJobStateListener updateJobStateListener) {
        this.updateJobStateListeners.add(updateJobStateListener);
    }

    public void removeUpdateJobStateListener(UpdateJobStateListener updateJobStateListener) {
        this.updateJobStateListeners.remove(updateJobStateListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateJobList() {
        try {
            final HashMap hashMap = new HashMap();
            BARServer.executeCommand(StringParser.format("JOB_LIST", new Object[0]), 3, new Command.ResultHandler(){

                @Override
                public void handle(int n, ValueMap valueMap) {
                    String string = valueMap.getString("jobUUID");
                    String string2 = valueMap.getString("master", "");
                    String string3 = valueMap.getString("name");
                    JobData.States states = valueMap.getEnum("state", JobData.States.class);
                    String string4 = valueMap.getString("slaveHostName", "");
                    int n2 = valueMap.getInt("slaveHostPort", 0);
                    JobData.SlaveStates slaveStates = valueMap.getEnum("slaveState", JobData.SlaveStates.class);
                    boolean bl = valueMap.getBoolean("slaveTLS", false);
                    boolean bl2 = valueMap.getBoolean("slaveInsecureTLS", true);
                    ArchiveTypes archiveTypes = valueMap.getEnum("archiveType", ArchiveTypes.class);
                    long l = valueMap.getLong("archivePartSize");
                    String string5 = valueMap.getString("deltaCompressAlgorithm");
                    String string6 = valueMap.getString("byteCompressAlgorithm");
                    String string7 = valueMap.getString("cryptAlgorithm");
                    String string8 = valueMap.getString("cryptType");
                    String string9 = valueMap.getString("cryptPasswordMode");
                    long l2 = valueMap.getLong("lastExecutedDateTime");
                    long l3 = valueMap.getLong("estimatedRestTime");
                    JobData.VolumeRequests volumeRequests = valueMap.getEnum("volumeRequest", JobData.VolumeRequests.class);
                    JobData.MessageCodes messageCodes = valueMap.getEnum("messageCode", JobData.MessageCodes.class);
                    JobData jobData = (JobData)TabStatus.this.jobDataMap.get(string);
                    if (jobData != null) {
                        jobData.name = string3;
                        jobData.master = string2;
                        jobData.state = states;
                        jobData.slaveHostName = string4;
                        jobData.slaveHostPort = n2;
                        jobData.slaveState = slaveStates;
                        jobData.slaveTLS = bl;
                        jobData.slaveInsecureTLS = bl2;
                        jobData.archiveType = archiveTypes;
                        jobData.archivePartSize = l;
                        jobData.deltaCompressAlgorithm = string5;
                        jobData.byteCompressAlgorithm = string6;
                        jobData.cryptAlgorithm = string7;
                        jobData.cryptType = string8;
                        jobData.cryptPasswordMode = string9;
                        jobData.lastExecutedDateTime = l2;
                        jobData.estimatedRestTime = l3;
                        jobData.volumeRequest = volumeRequests;
                        jobData.messageCode = messageCodes;
                    } else {
                        jobData = new JobData(string, string2, string3, states, string4, n2, slaveStates, bl, bl2, archiveTypes, l, string5, string6, string7, string8, string9, l2, l3, volumeRequests, messageCodes);
                    }
                    hashMap.put(string, jobData);
                }
            });
            HashMap<String, JobData> hashMap2 = this.jobDataMap;
            synchronized (hashMap2) {
                this.jobDataMap = hashMap;
            }
            this.display.syncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (!TabStatus.this.widgetJobTable.isDisposed()) {
                        HashSet<TableItem> hashSet = Widgets.getAllTableItems(TabStatus.this.widgetJobTable);
                        HashMap hashMap = TabStatus.this.jobDataMap;
                        synchronized (hashMap) {
                            block8: for (JobData jobData : TabStatus.this.jobDataMap.values()) {
                                TableItem tableItem = Widgets.getTableItem(TabStatus.this.widgetJobTable, jobData);
                                if (tableItem != null) {
                                    Object[] objectArray = new Object[9];
                                    objectArray[0] = jobData.name;
                                    Object object = objectArray[1] = TabStatus.this.serverState == BARServer.States.RUNNING ? JobData.formatStateText(jobData.state, jobData.slaveHostName, jobData.slaveState) : BARControl.tr("suspended", new Object[0]);
                                    objectArray[2] = !jobData.slaveHostName.isEmpty() ? jobData.slaveHostName + (jobData.slaveHostPort != 0 ? ":" + Integer.toString(jobData.slaveHostPort) : "") : "";
                                    objectArray[3] = jobData.archiveType.getText();
                                    objectArray[4] = jobData.archivePartSize > 0L ? Units.formatByteSize(jobData.archivePartSize) : BARControl.tr("unlimited", new Object[0]);
                                    objectArray[5] = jobData.formatCompressAlgorithm();
                                    objectArray[6] = jobData.formatCryptAlgorithm();
                                    objectArray[7] = jobData.formatLastExecutedDateTime();
                                    objectArray[8] = jobData.formatEstimatedRestTime();
                                    Widgets.updateTableItem(tableItem, jobData, objectArray);
                                    if (jobData.slaveTLS) {
                                        tableItem.setImage(2, jobData.slaveInsecureTLS ? TabStatus.this.IMAGE_LOCK_INSECURE : TabStatus.this.IMAGE_LOCK);
                                    } else {
                                        tableItem.setImage(2, null);
                                    }
                                    hashSet.remove(tableItem);
                                } else {
                                    Object[] objectArray = new Object[9];
                                    objectArray[0] = jobData.name;
                                    Object object = objectArray[1] = TabStatus.this.serverState == BARServer.States.RUNNING ? JobData.formatStateText(jobData.state, jobData.slaveHostName, jobData.slaveState) : BARControl.tr("suspended", new Object[0]);
                                    objectArray[2] = !jobData.slaveHostName.isEmpty() ? jobData.slaveHostName + (jobData.slaveHostPort != 0 ? ":" + Integer.toString(jobData.slaveHostPort) : "") : "";
                                    objectArray[3] = jobData.archiveType.toString();
                                    objectArray[4] = jobData.archivePartSize > 0L ? Units.formatByteSize(jobData.archivePartSize) : BARControl.tr("unlimited", new Object[0]);
                                    objectArray[5] = jobData.formatCompressAlgorithm();
                                    objectArray[6] = jobData.formatCryptAlgorithm();
                                    objectArray[7] = jobData.formatLastExecutedDateTime();
                                    objectArray[8] = jobData.formatEstimatedRestTime();
                                    tableItem = Widgets.insertTableItem(TabStatus.this.widgetJobTable, TabStatus.this.findJobTableItemIndex(jobData), (Object)jobData, objectArray);
                                    if (jobData.slaveTLS) {
                                        tableItem.setImage(2, jobData.slaveInsecureTLS ? TabStatus.this.IMAGE_LOCK_INSECURE : TabStatus.this.IMAGE_LOCK);
                                    }
                                    tableItem.setData(jobData);
                                }
                                switch (jobData.state) {
                                    case RUNNING: 
                                    case NO_STORAGE: 
                                    case DRY_RUNNING: {
                                        if (jobData.volumeRequest != JobData.VolumeRequests.NONE) {
                                            tableItem.setBackground(TabStatus.this.COLOR_REQUEST);
                                            continue block8;
                                        }
                                        tableItem.setBackground(TabStatus.this.COLOR_RUNNING);
                                        continue block8;
                                    }
                                    case ERROR: {
                                        tableItem.setBackground(TabStatus.this.COLOR_ERROR);
                                        continue block8;
                                    }
                                    case ABORTED: {
                                        tableItem.setBackground(TabStatus.this.COLOR_ABORTED);
                                        continue block8;
                                    }
                                }
                                tableItem.setBackground(null);
                            }
                        }
                        Widgets.removeTableItems(hashSet);
                    }
                }
            });
        }
        catch (Exception exception) {
        }
        catch (ConnectionError connectionError) {
            // empty catch block
        }
        this.tabJobs.updateJobList(this.jobDataMap.values());
    }

    private void updateJobTrigger() {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                MenuItem[] menuItemArray = TabStatus.this.menuTriggerJob.getItems();
                for (int i = 0; i < menuItemArray.length; ++i) {
                    menuItemArray[i].dispose();
                }
            }
        });
        if (this.selectedJobData != null) {
            final ArrayList arrayList = new ArrayList();
            try {
                BARServer.executeCommand(StringParser.format("SCHEDULE_LIST jobUUID=%s", this.selectedJobData.uuid), 0, new Command.ResultHandler(){

                    @Override
                    public void handle(int n, ValueMap valueMap) {
                        String string = valueMap.getString("scheduleUUID");
                        String string2 = valueMap.getString("date");
                        String string3 = valueMap.getString("weekDays");
                        String string4 = valueMap.getString("time");
                        ArchiveTypes archiveTypes = valueMap.getEnum("archiveType", ArchiveTypes.class);
                        arrayList.add(new ScheduleData(string, string2, string3, string4, archiveTypes));
                    }
                });
            }
            catch (Exception exception) {
            }
            catch (ConnectionError connectionError) {
                // empty catch block
            }
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    for (final ScheduleData scheduleData : arrayList) {
                        MenuItem menuItem = Widgets.addMenuItem(TabStatus.this.menuTriggerJob, String.format("%s %s %s %s", new Object[]{scheduleData.getDate(), scheduleData.getWeekDays(), scheduleData.getTime(), scheduleData.archiveType}));
                        menuItem.addSelectionListener(new SelectionListener(){

                            @Override
                            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                            }

                            @Override
                            public void widgetSelected(SelectionEvent selectionEvent) {
                                try {
                                    BARServer.executeCommand(StringParser.format("SCHEDULE_TRIGGER jobUUID=%s scheduleUUID=%s", ((TabStatus)TabStatus.this).selectedJobData.uuid, scheduleData.uuid), 0);
                                }
                                catch (Exception exception) {
                                    Dialogs.error(TabStatus.this.shell, BARControl.tr("Cannot trigger schedule of job ''{0}'':\n\n{1}", ((TabStatus)TabStatus.this).selectedJobData.name.replaceAll("&", "&&"), exception.getMessage()));
                                    BARControl.logThrowable(exception);
                                    return;
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    private void setSelectedJob(JobData jobData) {
        this.selectedJobData = jobData;
        if (this.selectedJobData != null) {
            Widgets.setSelectedTableItem(this.widgetJobTable, this.selectedJobData);
        } else {
            Widgets.clearSelectedTableItems(this.widgetJobTable);
        }
        this.updateJobTrigger();
        this.widgetSelectedJob.setText(BARControl.tr("Selected", new Object[0]) + " '" + (this.selectedJobData != null ? this.selectedJobData.name : "") + "'");
    }

    private void clearSelectedJob() {
        this.selectedJobData = null;
        Widgets.clearSelectedTableItems(this.widgetJobTable);
        this.updateJobTrigger();
        this.widgetSelectedJob.setText(BARControl.tr("Selected", new Object[0]) + " ''");
    }

    private double getProgress(long l, long l2) {
        return l2 > 0L ? (double)l * 100.0 / (double)l2 : 0.0;
    }

    private void updateStatus() throws Exception {
        block7: {
            try {
                ValueMap valueMap = new ValueMap();
                BARServer.executeCommand(StringParser.format("STATUS", new Object[0]), 3, valueMap);
                this.serverState = valueMap.getEnum("state", BARServer.States.class, BARServer.States.RUNNING);
                switch (this.serverState) {
                    case PAUSED: {
                        final long l = valueMap.getLong("time");
                        this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!TabStatus.this.widgetButtonPause.isDisposed()) {
                                    TabStatus.this.widgetButtonPause.setText(String.format(BARControl.tr("Pause [%3dmin]", new Object[0]), l > 0L ? (l + 59L) / 60L : 1L));
                                }
                                if (!TabStatus.this.widgetButtonSuspendContinue.isDisposed()) {
                                    TabStatus.this.widgetButtonSuspendContinue.setText(BARControl.tr("Continue", new Object[0]));
                                }
                            }
                        });
                        break;
                    }
                    case SUSPENDED: {
                        this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!TabStatus.this.widgetButtonPause.isDisposed()) {
                                    TabStatus.this.widgetButtonPause.setText(BARControl.tr("Pause", new Object[0]));
                                }
                                if (!TabStatus.this.widgetButtonSuspendContinue.isDisposed()) {
                                    TabStatus.this.widgetButtonSuspendContinue.setText(BARControl.tr("Continue", new Object[0]));
                                }
                            }
                        });
                        break;
                    }
                    default: {
                        this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!TabStatus.this.widgetButtonPause.isDisposed()) {
                                    TabStatus.this.widgetButtonPause.setText(BARControl.tr("Pause", new Object[0]));
                                }
                                if (!TabStatus.this.widgetButtonSuspendContinue.isDisposed()) {
                                    TabStatus.this.widgetButtonSuspendContinue.setText(BARControl.tr("Suspend", new Object[0]));
                                }
                            }
                        });
                    }
                }
                this.updateStatusFailCount = 0;
            }
            catch (ConnectionError connectionError) {
            }
            catch (Exception exception) {
                ++this.updateStatusFailCount;
                if (this.updateStatusFailCount <= 5) break block7;
                throw exception;
            }
        }
    }

    private TableItem getJobTableItemByName(String string) {
        TableItem[] tableItemArray = this.widgetJobTable.getItems();
        for (int i = 0; i < tableItemArray.length; ++i) {
            if (!((JobData)tableItemArray[i].getData()).name.equals(string)) continue;
            return tableItemArray[i];
        }
        return null;
    }

    private TableItem getJobTableItemByUUID(String string) {
        TableItem[] tableItemArray = this.widgetJobTable.getItems();
        for (int i = 0; i < tableItemArray.length; ++i) {
            if (!((JobData)tableItemArray[i].getData()).uuid.equals(string)) continue;
            return tableItemArray[i];
        }
        return null;
    }

    private int findJobTableItemIndex(JobData jobData) {
        int n;
        TableItem[] tableItemArray = this.widgetJobTable.getItems();
        JobDataComparator jobDataComparator = new JobDataComparator(this.widgetJobTable);
        for (n = 0; n < tableItemArray.length && jobDataComparator.compare(jobData, (JobData)tableItemArray[n].getData()) > 0; ++n) {
        }
        return n;
    }

    private void updateJobInfo() {
        if (this.selectedJobData != null) {
            try {
                final ValueMap valueMap = new ValueMap();
                BARServer.executeCommand(StringParser.format("JOB_STATUS jobUUID=%s", this.selectedJobData.uuid), 3, valueMap);
                this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        JobData.States states = valueMap.getEnum("state", JobData.States.class);
                        int n = valueMap.getInt("errorCode");
                        int n2 = valueMap.getInt("errorNumber");
                        String string = valueMap.getString("errorData");
                        JobData.VolumeRequests volumeRequests = valueMap.getEnum("volumeRequest", JobData.VolumeRequests.class);
                        JobData.MessageCodes messageCodes = valueMap.getEnum("messageCode", JobData.MessageCodes.class);
                        String string2 = valueMap.getString("messageText");
                        TabStatus.this.doneCount.set(valueMap.getLong("doneCount"));
                        TabStatus.this.doneSize.set(valueMap.getLong("doneSize"));
                        TabStatus.this.storageTotalSize.set(valueMap.getLong("storageTotalSize"));
                        TabStatus.this.skippedEntryCount.set(valueMap.getLong("skippedEntryCount"));
                        TabStatus.this.skippedEntrySize.set(valueMap.getLong("skippedEntrySize"));
                        TabStatus.this.errorEntryCount.set(valueMap.getLong("errorEntryCount"));
                        TabStatus.this.errorEntrySize.set(valueMap.getLong("errorEntrySize"));
                        TabStatus.this.totalEntryCount.set(valueMap.getLong("totalEntryCount"));
                        TabStatus.this.totalEntrySize.set(valueMap.getLong("totalEntrySize"));
                        TabStatus.this.collectTotalSumDone.set(valueMap.getBoolean("collectTotalSumDone"));
                        TabStatus.this.filesPerSecond.set(valueMap.getDouble("entriesPerSecond"));
                        TabStatus.this.bytesPerSecond.set(valueMap.getDouble("bytesPerSecond"));
                        TabStatus.this.storageBytesPerSecond.set(valueMap.getDouble("storageBytesPerSecond"));
                        TabStatus.this.compressionRatio.set(valueMap.getDouble("compressionRatio"));
                        TabStatus.this.fileName.set(valueMap.getString("entryName"));
                        TabStatus.this.fileProgress.set(TabStatus.this.getProgress(valueMap.getLong("entryDoneSize"), valueMap.getLong("entryTotalSize")));
                        TabStatus.this.storageName.set(valueMap.getString("storageName"));
                        TabStatus.this.storageProgress.set(TabStatus.this.getProgress(valueMap.getLong("storageDoneSize"), valueMap.getLong("storageTotalSize")));
                        TabStatus.this.volumeNumber.set(valueMap.getLong("volumeNumber"));
                        TabStatus.this.volumeDone.set(valueMap.getDouble("volumeDone"));
                        TabStatus.this.totalEntriesProgress.set(TabStatus.this.getProgress(TabStatus.this.doneCount.getLong(), TabStatus.this.totalEntryCount.getLong()));
                        TabStatus.this.totalBytesProgress.set(TabStatus.this.getProgress(TabStatus.this.doneSize.getLong(), TabStatus.this.totalEntrySize.getLong()));
                        TabStatus.this.volumeRequestNumber.set(valueMap.getInt("volumeRequestNumber"));
                        if (TabStatus.this.selectedJobData != null) {
                            for (UpdateJobStateListener updateJobStateListener : TabStatus.this.updateJobStateListeners) {
                                updateJobStateListener.modified(TabStatus.this.selectedJobData);
                            }
                        }
                        block0 : switch (states) {
                            case RUNNING: 
                            case NO_STORAGE: 
                            case DRY_RUNNING: 
                            case NONE: 
                            case WAITING: {
                                if (volumeRequests != JobData.VolumeRequests.NONE) {
                                    switch (volumeRequests) {
                                        case NONE: {
                                            break;
                                        }
                                        case INITIAL: {
                                            TabStatus.this.message.set(BARControl.tr("Please insert volume #{0}", TabStatus.this.volumeRequestNumber.getInteger()));
                                            break;
                                        }
                                        case REPLACEMENT: {
                                            TabStatus.this.message.set(BARControl.tr("Please insert replacement volume #{0}", TabStatus.this.volumeRequestNumber.getInteger()));
                                        }
                                    }
                                    break;
                                }
                                switch (messageCodes) {
                                    case NONE: {
                                        TabStatus.this.message.set("");
                                        break block0;
                                    }
                                }
                                if (!string2.isEmpty()) {
                                    TabStatus.this.message.set(messageCodes.getText() + ": " + string2);
                                    break;
                                }
                                TabStatus.this.message.set(messageCodes.getText());
                                break;
                            }
                            case ERROR: 
                            case ABORTED: 
                            case DONE: {
                                TabStatus.this.message.set(BARException.getText(n, n2, string));
                            }
                        }
                    }
                });
            }
            catch (Exception exception) {
            }
            catch (ConnectionError connectionError) {}
        } else {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    TabStatus.this.doneCount.set(0L);
                    TabStatus.this.doneSize.set(0L);
                    TabStatus.this.storageTotalSize.set(0L);
                    TabStatus.this.skippedEntryCount.set(0L);
                    TabStatus.this.skippedEntrySize.set(0L);
                    TabStatus.this.errorEntryCount.set(0L);
                    TabStatus.this.errorEntrySize.set(0L);
                    TabStatus.this.totalEntryCount.set(0L);
                    TabStatus.this.totalEntrySize.set(0L);
                    TabStatus.this.collectTotalSumDone.set(false);
                    TabStatus.this.filesPerSecond.set(0.0);
                    TabStatus.this.bytesPerSecond.set(0.0);
                    TabStatus.this.storageBytesPerSecond.set(0.0);
                    TabStatus.this.compressionRatio.set(0.0);
                    TabStatus.this.fileName.set("");
                    TabStatus.this.fileProgress.set(TabStatus.this.getProgress(0L, 0L));
                    TabStatus.this.storageName.set("");
                    TabStatus.this.storageProgress.set(TabStatus.this.getProgress(0L, 0L));
                    TabStatus.this.volumeNumber.set(0L);
                    TabStatus.this.volumeDone.set(0.0);
                    TabStatus.this.totalEntriesProgress.set(TabStatus.this.getProgress(0L, 0L));
                    TabStatus.this.totalBytesProgress.set(TabStatus.this.getProgress(0L, 0L));
                    TabStatus.this.volumeRequestNumber.set(0);
                    TabStatus.this.message.set("");
                    if (!TabStatus.this.widgetButtonStart.isDisposed()) {
                        TabStatus.this.widgetButtonStart.setEnabled(false);
                    }
                    if (!TabStatus.this.widgetButtonAbort.isDisposed()) {
                        TabStatus.this.widgetButtonAbort.setEnabled(false);
                    }
                    if (!TabStatus.this.widgetButtonVolume.isDisposed()) {
                        TabStatus.this.widgetButtonVolume.setEnabled(false);
                    }
                }
            });
        }
    }

    private void update(boolean bl) {
        block3: {
            try {
                if (bl) {
                    this.updateJobList();
                }
                this.updateStatus();
                this.updateJobInfo();
            }
            catch (Throwable throwable) {
                if (Settings.debugLevel <= 0) break block3;
                BARServer.disconnect();
                BARControl.internalError(throwable);
            }
        }
    }

    private void update() {
        this.update(true);
    }

    private void jobStart(ArchiveTypes archiveTypes, String string, boolean bl, boolean bl2) {
        if (this.selectedJobData != null) {
            if (string != null) {
                try {
                    BARServer.executeCommand(StringParser.format("CRYPT_PASSWORD jobUUID=%s encryptType=%s encryptedPassword=%S", this.selectedJobData.uuid, BARServer.getPasswordEncryptType(), BARServer.encryptPassword(string)), 0);
                }
                catch (Exception exception) {
                    Dialogs.error(this.shell, BARControl.tr("Cannot set crypt password for job ''{0}'' (error: {1})", this.selectedJobData.name.replaceAll("&", "&&"), exception.getMessage()));
                    BARControl.logThrowable(exception);
                    return;
                }
            }
            try {
                BARServer.executeCommand(StringParser.format("JOB_START jobUUID=%s archiveType=%s testCreatedArchives=no noStorage=%y dryRun=%y", this.selectedJobData.uuid, archiveTypes.toString(), bl, bl2), 0);
                this.updateJobList();
            }
            catch (Exception exception) {
                Dialogs.error(this.shell, BARControl.tr("Cannot start job ''{0}'' (error: {1})", this.selectedJobData.name.replaceAll("&", "&&"), exception.getMessage()));
                BARControl.logThrowable(exception);
                return;
            }
        }
    }

    private void jobStart(ArchiveTypes archiveTypes, boolean bl, boolean bl2) {
        if (this.selectedJobData != null) {
            String string;
            if (this.selectedJobData.cryptPasswordMode.equals("ask")) {
                string = Dialogs.password(this.shell, BARControl.tr("Crypt password", new Object[0]), null, null, BARControl.tr("Crypt password", new Object[0]) + ":", BARControl.tr("Verify", new Object[0]) + ":");
                if (string == null) {
                    return;
                }
            } else {
                string = null;
            }
            this.jobStart(archiveTypes, string, bl, bl2);
        }
    }

    private void jobStart(ArchiveTypes archiveTypes, boolean bl) {
        this.jobStart(archiveTypes, bl, false);
    }

    private void jobStart() {
        if (this.selectedJobData != null) {
            ArchiveTypes archiveTypes = ArchiveTypes.NORMAL;
            boolean bl = false;
            switch (Dialogs.select(this.shell, BARControl.tr("Confirmation", new Object[0]), BARControl.tr("Start job ''{0}''?", this.selectedJobData.name.replaceAll("&", "&&")), new String[]{Settings.hasNormalRole() ? BARControl.tr("Normal", new Object[0]) : null, BARControl.tr("Full", new Object[0]), BARControl.tr("Incremental", new Object[0]), Settings.hasExpertRole() ? BARControl.tr("Differential", new Object[0]) : null, Settings.hasExpertRole() ? BARControl.tr("No storage", new Object[0]) : null, BARControl.tr("Cancel", new Object[0])}, new String[]{BARControl.tr("Store all files.", new Object[0]), BARControl.tr("Store all files as a full backup.", new Object[0]), BARControl.tr("Store all files and create incremental data file.", new Object[0]), BARControl.tr("Store changed files since last incremental or full storage and update incremental data file.", new Object[0]), BARControl.tr("Store changed files since last full storage.", new Object[0]), null}, 4)) {
                case 0: {
                    archiveTypes = ArchiveTypes.NORMAL;
                    bl = false;
                    break;
                }
                case 1: {
                    archiveTypes = ArchiveTypes.FULL;
                    bl = false;
                    break;
                }
                case 2: {
                    archiveTypes = ArchiveTypes.INCREMENTAL;
                    bl = false;
                    break;
                }
                case 3: {
                    archiveTypes = ArchiveTypes.DIFFERENTIAL;
                    bl = false;
                    break;
                }
                case 4: {
                    archiveTypes = ArchiveTypes.FULL;
                    bl = true;
                    break;
                }
                default: {
                    return;
                }
            }
            this.jobStart(archiveTypes, bl);
        }
    }

    private void jobAbort() {
        assert (this.selectedJobData != null);
        if (this.selectedJobData.state != JobData.States.RUNNING || Dialogs.confirm(this.shell, BARControl.tr("Abort running job ''{0}''?", this.selectedJobData.name.replaceAll("&", "&&")), false)) {
            BusyDialog busyDialog = new BusyDialog(this.shell, BARControl.tr("Abort", new Object[0]), 300, 100, BARControl.tr("Abort job", new Object[0]) + " '" + this.selectedJobData.name + "'\u2026", 0x1000181);
            Background.run(new BackgroundRunnable(new Object[]{busyDialog}){

                public void run(final BusyDialog busyDialog) {
                    block5: {
                        try {
                            BARServer.executeCommand(StringParser.format("JOB_ABORT jobUUID=%s", ((TabStatus)TabStatus.this).selectedJobData.uuid), 0);
                            TabStatus.this.display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    TabStatus.this.updateJobList();
                                    busyDialog.close();
                                }
                            });
                        }
                        catch (BARException bARException) {
                            TabStatus.this.display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    busyDialog.close();
                                    Dialogs.error(TabStatus.this.shell, BARControl.tr("Cannot abort job (error: {0})", bARException.getMessage()));
                                }
                            });
                        }
                        catch (CommunicationError communicationError) {
                            TabStatus.this.display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    busyDialog.close();
                                    Dialogs.error(TabStatus.this.shell, BARControl.tr("Communication error while abort job\n\n(error: {0})", communicationError.getMessage()));
                                }
                            });
                        }
                        catch (ConnectionError connectionError) {
                            TabStatus.this.display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    busyDialog.close();
                                    Dialogs.error(TabStatus.this.shell, BARControl.tr("Connection error while abort job\n\n(error: {0})", connectionError.getMessage()));
                                }
                            });
                        }
                        catch (Exception exception) {
                            if (Settings.debugLevel <= 0) break block5;
                            BARServer.disconnect();
                            BARControl.internalError(exception);
                        }
                    }
                }
            });
        }
    }

    public void jobPause(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        if (Settings.pauseCreateFlag) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append("CREATE");
        }
        if (Settings.pauseStorageFlag) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append("STORAGE");
        }
        if (Settings.pauseRestoreFlag) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append("RESTORE");
        }
        if (Settings.pauseIndexUpdateFlag) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append("INDEX_UPDATE");
        }
        if (Settings.pauseIndexMaintenanceFlag) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append("INDEX_MAINTENANCE");
        }
        if (stringBuffer.length() > 0) {
            try {
                BARServer.executeCommand(StringParser.format("PAUSE time=%d modeMask=%s", l, stringBuffer.toString()), 0);
            }
            catch (Exception exception) {
                Dialogs.error(this.shell, BARControl.tr("Cannot pause job (error: {0})", exception.getMessage()));
                BARControl.logThrowable(exception);
            }
        }
    }

    private void jobSuspendContinue() {
        try {
            switch (this.serverState) {
                case RUNNING: {
                    BARServer.executeCommand(StringParser.format("SUSPEND", new Object[0]), 0);
                    break;
                }
                case PAUSED: 
                case SUSPENDED: {
                    BARServer.executeCommand(StringParser.format("CONTINUE", new Object[0]), 0);
                }
            }
        }
        catch (Exception exception) {
            Dialogs.error(this.shell, BARControl.tr("Cannot suspend job (error: {0})", exception.getMessage()));
            BARControl.logThrowable(exception);
        }
    }

    private void volume() {
        assert (this.selectedJobData != null);
        try {
            long l = this.volumeRequestNumber.getInteger();
            switch (Dialogs.select(this.shell, BARControl.tr("Volume request", new Object[0]), BARControl.tr("Load volume number {0}.", l), new String[]{BARControl.tr("OK", new Object[0]), BARControl.tr("Unload tray", new Object[0]), BARControl.tr("Abort", new Object[0]), BARControl.tr("Cancel", new Object[0])}, 0)) {
                case 0: {
                    BARServer.executeCommand(StringParser.format("VOLUME_LOAD jobUUID=%s volumeNumber=%d", this.selectedJobData.uuid, l), 0);
                    break;
                }
                case 1: {
                    BARServer.executeCommand(StringParser.format("VOLUME_UNLOAD jobUUID=%s", this.selectedJobData.uuid), 0);
                    break;
                }
                case 2: {
                    BARServer.executeCommand(StringParser.format("JOB_ABORT jobUUID=%s", this.selectedJobData.uuid), 0);
                    break;
                }
            }
        }
        catch (Exception exception) {
            Dialogs.error(this.shell, BARControl.tr("Cannot change volume (error: {0})", exception.getMessage()));
            BARControl.logThrowable(exception);
        }
    }

    private void jobReset() {
        try {
            BARServer.executeCommand(StringParser.format("JOB_RESET jobUUID=%s", this.selectedJobData.uuid), 0);
        }
        catch (Exception exception) {
            Dialogs.error(this.shell, BARControl.tr("Cannot reset job (error: {0})", exception.getMessage()));
            BARControl.logThrowable(exception);
        }
    }

    private void jobNew() {
        this.tabJobs.jobNew();
    }

    private void jobClone() {
        assert (this.selectedJobData != null);
        this.tabJobs.jobClone(this.selectedJobData);
    }

    private void jobRename() {
        assert (this.selectedJobData != null);
        if (this.tabJobs.jobRename(this.selectedJobData)) {
            Widgets.notify((Widget)this.shell, 65537, this.selectedJobData.uuid);
        }
    }

    private void jobDelete() {
        assert (this.selectedJobData != null);
        if (this.selectedJobData.state != JobData.States.RUNNING && this.tabJobs.jobDelete(this.selectedJobData)) {
            Widgets.notify((Widget)this.shell, 65538, this.selectedJobData.uuid);
        }
    }

    private void showJobToolTip(JobData jobData, int n, int n2) {
        Color color = this.display.getSystemColor(28);
        Color color2 = this.display.getSystemColor(29);
        if (this.widgetJobTableToolTip != null) {
            this.widgetJobTableToolTip.dispose();
        }
        try {
            ValueMap valueMap = new ValueMap();
            BARServer.executeCommand(StringParser.format("JOB_INFO jobUUID=%s", jobData.uuid), 0, valueMap);
            long l = valueMap.getLong("lastExecutedDateTime");
            long l2 = valueMap.getLong("executionCountNormal");
            long l3 = valueMap.getLong("executionCountFull");
            long l4 = valueMap.getLong("executionCountIncremental");
            long l5 = valueMap.getLong("executionCountDifferential");
            long l6 = valueMap.getLong("executionCountContinuous");
            long l7 = valueMap.getLong("averageDurationNormal");
            long l8 = valueMap.getLong("averageDurationFull");
            long l9 = valueMap.getLong("averageDurationIncremental");
            long l10 = valueMap.getLong("averageDurationDifferential");
            long l11 = valueMap.getLong("averageDurationContinuous");
            long l12 = valueMap.getLong("totalEntityCount");
            long l13 = valueMap.getLong("totalStorageCount");
            long l14 = valueMap.getLong("totalStorageSize");
            long l15 = valueMap.getLong("totalEntryCount");
            long l16 = valueMap.getLong("totalEntrySize");
            this.widgetJobTableToolTip = new Shell(this.shell, 540676);
            this.widgetJobTableToolTip.setBackground(color2);
            this.widgetJobTableToolTip.setLayout(new TableLayout(0.0, new double[]{0.0, 1.0}, 2));
            Widgets.layout(this.widgetJobTableToolTip, 0, 0, 15);
            int n3 = 0;
            Label label = Widgets.newLabel((Composite)this.widgetJobTableToolTip, BARControl.tr("Job", new Object[0]) + ":");
            label.setForeground(color);
            label.setBackground(color2);
            Widgets.layout(label, n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetJobTableToolTip, jobData.name.replaceAll("&", "&&"));
            label.setForeground(color);
            label.setBackground(color2);
            Widgets.layout(label, n3, 1, 12);
            label = Widgets.newLabel((Composite)this.widgetJobTableToolTip, BARControl.tr("Entities", new Object[0]) + ":");
            label.setForeground(color);
            label.setBackground(color2);
            Widgets.layout(label, ++n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetJobTableToolTip, BARControl.tr("{0}", l12));
            label.setForeground(color);
            label.setBackground(color2);
            Widgets.layout(label, n3, 1, 12);
            label = Widgets.newLabel((Composite)this.widgetJobTableToolTip, BARControl.tr("Storages", new Object[0]) + ":");
            label.setForeground(color);
            label.setBackground(color2);
            Widgets.layout(label, ++n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetJobTableToolTip, BARControl.tr("{0}", l13));
            label.setForeground(color);
            label.setBackground(color2);
            Widgets.layout(label, n3, 1, 12);
            label = Widgets.newLabel((Composite)this.widgetJobTableToolTip, String.format(BARControl.tr("{0} ({1} bytes)", Units.formatByteSize(l14), l14), new Object[0]));
            label.setForeground(color);
            label.setBackground(color2);
            Widgets.layout(label, ++n3, 1, 12);
            label = Widgets.newLabel((Composite)this.widgetJobTableToolTip, BARControl.tr("Entries", new Object[0]) + ":");
            label.setForeground(color);
            label.setBackground(color2);
            Widgets.layout(label, ++n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetJobTableToolTip, BARControl.tr("{0}", l15));
            label.setForeground(color);
            label.setBackground(color2);
            Widgets.layout(label, n3, 1, 12);
            label = Widgets.newLabel((Composite)this.widgetJobTableToolTip, String.format(BARControl.tr("{0} ({1} bytes)", Units.formatByteSize(l16), l16), new Object[0]));
            label.setForeground(color);
            label.setBackground(color2);
            Widgets.layout(label, ++n3, 1, 12);
            label = Widgets.newLabel((Composite)this.widgetJobTableToolTip, BARControl.tr("Last executed", new Object[0]) + ":");
            label.setForeground(color);
            label.setBackground(color2);
            Widgets.layout(label, ++n3, 0, 4);
            label = Widgets.newLabel((Composite)this.widgetJobTableToolTip, l > 0L ? this.SIMPLE_DATE_FORMAT.format(new Date(l * 1000L)) : "");
            label.setForeground(color);
            label.setBackground(color2);
            Widgets.layout(label, n3, 1, 12);
            label = Widgets.newLabel((Composite)this.widgetJobTableToolTip, BARControl.tr("Statistics", new Object[0]) + ":");
            label.setForeground(color);
            label.setBackground(color2);
            Widgets.layout(label, ++n3, 0, 5);
            Table table = Widgets.newTable(this.widgetJobTableToolTip);
            table.setForeground(color);
            table.setBackground(color2);
            table.setLayout(new TableLayout(null, 1.0));
            Widgets.layout(table, n3, 1, 4);
            Widgets.addTableColumn(table, 0, BARControl.tr("Type", new Object[0]), 16384, 100, false);
            Widgets.addTableColumn(table, 1, BARControl.tr("Count", new Object[0]), 131072, 60, false);
            Widgets.addTableColumn(table, 2, BARControl.tr("Average time", new Object[0]), 16384, 120, false);
            Widgets.addTableItem(table, null, BARControl.tr("normal", new Object[0]), l2, String.format("%02d:%02d:%02d", l7 / 3600L, l7 % 3600L / 60L, l7 % 60L));
            Widgets.addTableItem(table, null, BARControl.tr("full", new Object[0]), l3, String.format("%02d:%02d:%02d", l8 / 3600L, l8 % 3600L / 60L, l8 % 60L));
            Widgets.addTableItem(table, null, BARControl.tr("incremental", new Object[0]), l4, String.format("%02d:%02d:%02d", l9 / 3600L, l9 % 3600L / 60L, l9 % 60L));
            Widgets.addTableItem(table, null, BARControl.tr("differential", new Object[0]), l5, String.format("%02d:%02d:%02d", l10 / 3600L, l10 % 3600L / 60L, l10 % 60L));
            Widgets.addTableItem(table, null, BARControl.tr("continuous", new Object[0]), l6, String.format("%02d:%02d:%02d", l11 / 3600L, l11 % 3600L / 60L, l11 % 60L));
            ++n3;
            Widgets.showToolTip(this.widgetJobTableToolTip, n, n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class UpdateThread
    extends Thread {
        final int SLEEP_TIME = 1;

        UpdateThread() {
            this.setName("BARControl Update Status");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                int n = 0;
                while (true) {
                    block8: {
                        try {
                            TabStatus.this.update(n == 0);
                        }
                        catch (SWTException sWTException) {
                            if (Settings.debugLevel <= 2) break block8;
                            BARControl.printStackTrace(sWTException);
                            System.exit(1);
                        }
                    }
                    n = (n + 1) % 10;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (Throwable throwable) {
                if (Settings.debugLevel > 0) {
                    BARServer.disconnect();
                    BARControl.internalError(throwable);
                }
                return;
            }
        }
    }

    class ScheduleData {
        static final int NONE = 0;
        static final int ANY = -1;
        static final int MON = 0;
        static final int TUE = 1;
        static final int WED = 2;
        static final int THU = 3;
        static final int FRI = 4;
        static final int SAT = 5;
        static final int SUN = 6;
        String uuid;
        int year;
        int month;
        int day;
        int weekDays;
        int hour;
        int minute;
        ArchiveTypes archiveType;

        ScheduleData(String string, int n, int n2, int n3, int n4, int n5, int n6, ArchiveTypes archiveTypes) {
            this.uuid = string;
            this.year = n;
            this.month = n2;
            this.day = n3;
            this.weekDays = n4;
            this.hour = n5;
            this.minute = n6;
            this.archiveType = archiveTypes;
        }

        ScheduleData(String string, String string2, String string3, String string4, ArchiveTypes archiveTypes) {
            this.uuid = string;
            this.setDate(string2);
            this.setWeekDays(string3);
            this.setTime(string4);
            this.archiveType = archiveTypes;
        }

        String getYear() {
            assert (this.year == -1 || this.year >= 1) : this.year;
            return this.year != -1 ? String.format("%04d", this.year) : "*";
        }

        String getMonth() {
            assert (this.month == -1 || this.month >= 1 && this.month <= 12) : this.month;
            return this.month != -1 ? String.format("%02d", this.month) : "*";
        }

        String getDay() {
            assert (this.day == -1 || this.day >= 1 && this.day <= 31) : this.day;
            return this.day != -1 ? String.format("%02d", this.day) : "*";
        }

        String getWeekDays() {
            assert (this.weekDays == -1 || (this.weekDays & 0xFFFFFF80) == 0) : this.weekDays;
            if (this.weekDays == -1) {
                return "*";
            }
            StringBuilder stringBuilder = new StringBuilder();
            if ((this.weekDays & 1) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(BARControl.tr("Mon", new Object[0]));
            }
            if ((this.weekDays & 2) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(BARControl.tr("Tue", new Object[0]));
            }
            if ((this.weekDays & 4) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(BARControl.tr("Wed", new Object[0]));
            }
            if ((this.weekDays & 8) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(BARControl.tr("Thu", new Object[0]));
            }
            if ((this.weekDays & 0x10) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(BARControl.tr("Fri", new Object[0]));
            }
            if ((this.weekDays & 0x20) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(BARControl.tr("Sat", new Object[0]));
            }
            if ((this.weekDays & 0x40) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(BARControl.tr("Sun", new Object[0]));
            }
            return stringBuilder.toString();
        }

        void setWeekDays(String string) {
            if (string.equals("*")) {
                this.weekDays = -1;
            } else {
                this.weekDays = 0;
                for (String string2 : string.split(",")) {
                    if (string2.toLowerCase().equals("mon")) {
                        this.weekDays |= 1;
                        continue;
                    }
                    if (string2.toLowerCase().equals("tue")) {
                        this.weekDays |= 2;
                        continue;
                    }
                    if (string2.toLowerCase().equals("wed")) {
                        this.weekDays |= 4;
                        continue;
                    }
                    if (string2.toLowerCase().equals("thu")) {
                        this.weekDays |= 8;
                        continue;
                    }
                    if (string2.toLowerCase().equals("fri")) {
                        this.weekDays |= 0x10;
                        continue;
                    }
                    if (string2.toLowerCase().equals("sat")) {
                        this.weekDays |= 0x20;
                        continue;
                    }
                    if (!string2.toLowerCase().equals("sun")) continue;
                    this.weekDays |= 0x40;
                }
            }
        }

        void setWeekDays(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
            if (bl && bl2 && bl3 && bl4 && bl5 && bl6 && bl7) {
                this.weekDays = -1;
            } else {
                this.weekDays = 0;
                if (bl) {
                    this.weekDays |= 1;
                }
                if (bl2) {
                    this.weekDays |= 2;
                }
                if (bl3) {
                    this.weekDays |= 4;
                }
                if (bl4) {
                    this.weekDays |= 8;
                }
                if (bl5) {
                    this.weekDays |= 0x10;
                }
                if (bl6) {
                    this.weekDays |= 0x20;
                }
                if (bl7) {
                    this.weekDays |= 0x40;
                }
            }
        }

        String getDate() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getYear());
            stringBuilder.append('-');
            stringBuilder.append(this.getMonth());
            stringBuilder.append('-');
            stringBuilder.append(this.getDay());
            return stringBuilder.toString();
        }

        private void setDate(String string, String string2, String string3) {
            this.year = !string.equals("*") ? Integer.parseInt(string) : -1;
            this.month = !string2.equals("*") ? Integer.parseInt(string2) : -1;
            this.day = !string3.equals("*") ? Integer.parseInt(string3) : -1;
        }

        private void setDate(String string) {
            String[] stringArray = string.split("-");
            this.setDate(stringArray[0], stringArray[1], stringArray[2]);
        }

        String getHour() {
            assert (this.hour == -1 || this.hour >= 0 && this.hour <= 23) : this.hour;
            return this.hour != -1 ? String.format("%02d", this.hour) : "*";
        }

        String getMinute() {
            assert (this.minute == -1 || this.minute >= 0 && this.minute <= 59) : this.minute;
            return this.minute != -1 ? String.format("%02d", this.minute) : "*";
        }

        String getTime() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getHour());
            stringBuilder.append(':');
            stringBuilder.append(this.getMinute());
            return stringBuilder.toString();
        }

        void setTime(String string, String string2) {
            this.hour = !string.equals("*") ? Integer.parseInt(string, 10) : -1;
            int n = this.minute = !string2.equals("*") ? Integer.parseInt(string2, 10) : -1;
            assert (this.hour == -1 || this.hour >= 0 && this.hour <= 23) : this.hour;
            assert (this.minute == -1 || this.minute >= 0 && this.minute <= 59) : this.minute;
        }

        void setTime(String string) {
            String[] stringArray = string.split(":");
            this.setTime(stringArray[0], stringArray[1]);
        }

        ArchiveTypes getArchiveType() {
            return this.archiveType;
        }

        String weekDaysToString() {
            assert (this.weekDays == -1 || (this.weekDays & 0xFFFFFF80) == 0) : this.weekDays;
            if (this.weekDays == -1) {
                return "*";
            }
            StringBuilder stringBuilder = new StringBuilder();
            if ((this.weekDays & 1) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append("Mon");
            }
            if ((this.weekDays & 2) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append("Tue");
            }
            if ((this.weekDays & 4) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append("Wed");
            }
            if ((this.weekDays & 8) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append("Thu");
            }
            if ((this.weekDays & 0x10) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append("Fri");
            }
            if ((this.weekDays & 0x20) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append("Sat");
            }
            if ((this.weekDays & 0x40) != 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append("Sun");
            }
            return stringBuilder.toString();
        }

        public String toString() {
            return "ScheduleData {" + this.uuid + ", " + this.getDate() + ", " + this.getWeekDays() + ", " + this.getTime() + ", " + (Object)((Object)this.archiveType) + "}";
        }
    }
}

