/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class TableLayout
extends Layout {
    public static final int NONE = 0;
    public static final int N = 1;
    public static final int S = 2;
    public static final int W = 4;
    public static final int E = 8;
    public static final int NS = 3;
    public static final int WE = 12;
    public static final int NW = 5;
    public static final int NE = 9;
    public static final int NWE = 13;
    public static final int SW = 6;
    public static final int SE = 10;
    public static final int SWE = 14;
    public static final int NSW = 7;
    public static final int NSE = 11;
    public static final int NSWE = 15;
    public static final int DEFAULT = 0;
    public double rowWeight = 0.0;
    public double columnWeight = 0.0;
    public double[] rowWeights = null;
    public double[] columnWeights = null;
    public int marginTop = 0;
    public int marginBottom = 0;
    public int marginLeft = 0;
    public int marginRight = 0;
    public int horizontalSpacing = 2;
    public int verticalSpacing = 2;
    public int minWidth = -1;
    public int minHeight = -1;
    public int maxWidth = -1;
    public int maxHeight = -1;
    private int rows;
    private int columns;
    private int[] rowSizeHints;
    private int[] columnSizeHints;
    private int[] rowSizeMin;
    private int[] columnSizeMin;
    private boolean[] rowExpandFlags;
    private boolean[] columnExpandFlags;
    private Point[] sizes;
    private int totalWidth;
    private int totalHeight;
    private final boolean debug = false;
    private static int debugRecursion = 0;

    private String indent() {
        StringBuffer stringBuffer = new StringBuffer(debugRecursion);
        for (int i = 1; i < debugRecursion; ++i) {
            stringBuffer.append("    ");
        }
        return stringBuffer.toString();
    }

    public TableLayout() {
    }

    public TableLayout(int n) {
        this.marginTop = n;
        this.marginBottom = n;
        this.marginLeft = n;
        this.marginRight = n;
    }

    public TableLayout(double d, double d2) {
        this.rowWeight = d;
        this.columnWeight = d2;
    }

    public TableLayout(double[] dArray, double d) {
        this.rowWeights = dArray;
        this.columnWeight = d;
    }

    public TableLayout(double d, double[] dArray) {
        this.rowWeight = d;
        this.columnWeights = dArray;
    }

    public TableLayout(double[] dArray, double[] dArray2) {
        this.rowWeights = dArray;
        this.columnWeights = dArray2;
    }

    public TableLayout(double d, double d2, int n) {
        this.rowWeight = d;
        this.columnWeight = d2;
        this.marginTop = n;
        this.marginBottom = n;
        this.marginLeft = n;
        this.marginRight = n;
    }

    public TableLayout(double[] dArray, double d, int n) {
        this.rowWeights = dArray;
        this.columnWeight = d;
        this.marginTop = n;
        this.marginBottom = n;
        this.marginLeft = n;
        this.marginRight = n;
    }

    public TableLayout(double d, double[] dArray, int n) {
        this.rowWeight = d;
        this.columnWeights = dArray;
        this.marginTop = n;
        this.marginBottom = n;
        this.marginLeft = n;
        this.marginRight = n;
    }

    public TableLayout(double[] dArray, double[] dArray2, int n) {
        this.rowWeights = dArray;
        this.columnWeights = dArray2;
        this.marginTop = n;
        this.marginBottom = n;
        this.marginLeft = n;
        this.marginRight = n;
    }

    public TableLayout(double d, double d2, int n, int n2) {
        this.rowWeight = d;
        this.columnWeight = d2;
        this.marginTop = n;
        this.marginBottom = n;
        this.marginLeft = n;
        this.marginRight = n;
        this.horizontalSpacing = n2;
        this.verticalSpacing = n2;
    }

    public TableLayout(double[] dArray, double d, int n, int n2) {
        this.rowWeights = dArray;
        this.columnWeight = d;
        this.marginTop = n;
        this.marginBottom = n;
        this.marginLeft = n;
        this.marginRight = n;
        this.horizontalSpacing = n2;
        this.verticalSpacing = n2;
    }

    public TableLayout(double d, double[] dArray, int n, int n2) {
        this.rowWeight = d;
        this.columnWeights = dArray;
        this.marginTop = n;
        this.marginBottom = n;
        this.marginLeft = n;
        this.marginRight = n;
        this.horizontalSpacing = n2;
        this.verticalSpacing = n2;
    }

    public TableLayout(double[] dArray, double[] dArray2, int n, int n2) {
        this.rowWeights = dArray;
        this.columnWeights = dArray2;
        this.marginTop = n;
        this.marginBottom = n;
        this.marginLeft = n;
        this.marginRight = n;
        this.horizontalSpacing = n2;
        this.verticalSpacing = n2;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("rows=");
        if (this.rowWeights != null) {
            stringBuffer.append("{");
            for (n = 0; n < this.rowWeights.length; ++n) {
                if (n > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(this.rowWeights[n]);
            }
            stringBuffer.append("}");
        } else {
            stringBuffer.append(this.rowWeight);
        }
        stringBuffer.append(" columns=");
        if (this.columnWeights != null) {
            stringBuffer.append("{");
            for (n = 0; n < this.columnWeights.length; ++n) {
                if (n > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(this.columnWeights[n]);
            }
            stringBuffer.append("}");
        } else {
            stringBuffer.append(this.columnWeight);
        }
        stringBuffer.append(" margin=" + this.marginTop + "," + this.marginBottom + "," + this.marginLeft + "," + this.marginRight);
        stringBuffer.append(" spacing=" + this.horizontalSpacing + "," + this.verticalSpacing);
        return stringBuffer.toString();
    }

    @Override
    protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
        int n3;
        Control[] controlArray = composite.getChildren();
        if (bl || this.checkInitializeRequired(controlArray)) {
            this.initialize(composite, controlArray);
        }
        int n4 = n != -1 ? n : this.totalWidth;
        int n5 = n3 = n2 != -1 ? n2 : this.totalHeight;
        if (this.minWidth != -1) {
            n4 = Math.max(n4, this.minWidth);
        }
        if (this.minHeight != -1) {
            n3 = Math.max(n3, this.minHeight);
        }
        if (this.maxWidth != -1) {
            n4 = Math.min(n4, this.maxWidth);
        }
        if (this.maxHeight != -1) {
            n3 = Math.min(n3, this.maxHeight);
        }
        Point point = new Point(this.marginLeft + n4 + this.marginRight, this.marginTop + n3 + this.marginBottom);
        if (point.x <= 0) {
            point.x = 1;
        }
        if (point.y <= 0) {
            point.y = 1;
        }
        return point;
    }

    @Override
    protected void layout(Composite composite, boolean bl) {
        block32: {
            Tree tree;
            int n;
            int n2;
            int n3;
            Object object;
            Rectangle rectangle;
            block33: {
                int n4;
                int n5;
                Control[] controlArray = composite.getChildren();
                if (bl || this.checkInitializeRequired(controlArray)) {
                    this.initialize(composite, controlArray);
                }
                rectangle = composite.getClientArea();
                int n6 = 0;
                int n7 = 0;
                for (n5 = 0; n5 < this.columns; ++n5) {
                    if (this.columnWeights[n5] == 0.0) {
                        n6 += Math.max(this.columnSizeHints[n5], this.columnSizeMin[n5]);
                    }
                    n6 += n5 < this.columns - 1 ? this.verticalSpacing : 0;
                }
                for (n5 = 0; n5 < this.rows; ++n5) {
                    if (this.rowWeights[n5] == 0.0) {
                        n7 += Math.max(this.rowSizeHints[n5], this.rowSizeMin[n5]);
                    }
                    n7 += n5 < this.rows - 1 ? this.horizontalSpacing : 0;
                }
                boolean[] blArray = new boolean[this.rows];
                boolean[] blArray2 = new boolean[this.columns];
                for (n4 = 0; n4 < controlArray.length; ++n4) {
                    object = (TableLayoutData)controlArray[n4].getLayoutData();
                    if (object == null) {
                        throw new Error("no layout data");
                    }
                    if (!((TableLayoutData)object).isVisible) continue;
                    blArray[((TableLayoutData)object).row] = true;
                    blArray2[((TableLayoutData)object).column] = true;
                }
                int n8 = rectangle.height - this.marginTop - this.marginBottom;
                int[] nArray = new int[this.rows];
                int n9 = n8 - n7;
                int n10 = 0;
                double d = 0.0;
                for (n4 = 0; n4 < this.rows; ++n4) {
                    if (this.rowWeights[n4] > 0.0) {
                        nArray[n4] = Math.max((int)Math.round((double)n9 * (d + this.rowWeights[n4])) - n10, this.rowSizeMin[n4]);
                        n10 += nArray[n4];
                        d += this.rowWeights[n4];
                        continue;
                    }
                    nArray[n4] = Math.max(this.rowSizeHints[n4], this.rowSizeMin[n4]);
                }
                n3 = rectangle.width - this.marginLeft - this.marginRight;
                int[] nArray2 = new int[this.columns];
                n9 = n3 - n6;
                n10 = 0;
                d = 0.0;
                for (n4 = 0; n4 < this.columns; ++n4) {
                    if (this.columnWeights[n4] > 0.0) {
                        nArray2[n4] = Math.max((int)Math.round((double)n9 * (d + this.columnWeights[n4])) - n10, this.columnSizeMin[n4]);
                        n10 += nArray2[n4];
                        d += this.columnWeights[n4];
                        continue;
                    }
                    nArray2[n4] = Math.max(this.columnSizeHints[n4], this.columnSizeMin[n4]);
                }
                int[] nArray3 = new int[this.rows];
                int[] nArray4 = new int[this.columns];
                if (this.rows > 0) {
                    nArray3[0] = 0;
                    for (n4 = 1; n4 < this.rows; ++n4) {
                        nArray3[n4] = nArray3[n4 - 1] + nArray[n4 - 1] + (blArray[n4 - 1] ? this.horizontalSpacing : 0);
                    }
                }
                if (this.columns > 0) {
                    nArray4[0] = 0;
                    for (n4 = 1; n4 < this.columns; ++n4) {
                        nArray4[n4] = nArray4[n4 - 1] + nArray2[n4 - 1] + (blArray2[n4 - 1] ? this.verticalSpacing : 0);
                    }
                }
                for (n4 = 0; n4 < controlArray.length; ++n4) {
                    int n11;
                    object = (TableLayoutData)controlArray[n4].getLayoutData();
                    if (object == null) {
                        throw new Error("no layout data");
                    }
                    n3 = nArray2[((TableLayoutData)object).column] - 2 * ((TableLayoutData)object).padX;
                    n8 = nArray[((TableLayoutData)object).row] - 2 * ((TableLayoutData)object).padY;
                    for (n11 = ((TableLayoutData)object).column + 1; n11 < Math.min(((TableLayoutData)object).column + ((TableLayoutData)object).columnSpawn, this.columns); ++n11) {
                        n3 += nArray2[n11] + this.verticalSpacing;
                    }
                    for (n11 = ((TableLayoutData)object).row + 1; n11 < Math.min(((TableLayoutData)object).row + ((TableLayoutData)object).rowSpawn, this.rows); ++n11) {
                        n8 += nArray[n11] + this.horizontalSpacing;
                    }
                    n11 = rectangle.x + this.marginLeft + nArray4[((TableLayoutData)object).column] + ((TableLayoutData)object).padX;
                    n2 = rectangle.y + this.marginTop + nArray3[((TableLayoutData)object).row] + ((TableLayoutData)object).padY;
                    n = Math.min(this.sizes[n4].x, n3);
                    int n12 = Math.min(this.sizes[n4].y, n8);
                    if ((((TableLayoutData)object).style & 0xC) == 12) {
                        n = n3;
                    }
                    if ((((TableLayoutData)object).style & 3) == 3) {
                        n12 = n8;
                    }
                    if ((((TableLayoutData)object).style & 0xC) == 8) {
                        n11 += n < n3 ? n3 - n : 0;
                    } else if ((((TableLayoutData)object).style & 0xC) == 0) {
                        n11 += n < n3 ? (n3 - n) / 2 : 0;
                    }
                    if ((((TableLayoutData)object).style & 3) == 2) {
                        n2 += n12 < n8 ? n8 - n12 : 0;
                    } else if ((((TableLayoutData)object).style & 3) == 0) {
                        n2 += n12 < n8 ? (n8 - n12) / 2 : 0;
                    }
                    if (!((TableLayoutData)object).isVisible) continue;
                    controlArray[n4].setBounds(n11, n2, n, n12);
                }
                if (this.columnWeights == null) break block32;
                if (!(composite instanceof Table)) break block33;
                Table table = (Table)composite;
                object = (TableLayout)table.getLayout();
                if (object == null) break block32;
                TableColumn[] tableColumnArray = table.getColumns();
                n2 = 0;
                for (n = 0; n < Math.min(tableColumnArray.length, this.columnWeights.length); ++n) {
                    TableLayoutData tableLayoutData = (TableLayoutData)tableColumnArray[n].getData();
                    if (tableColumnArray[n].getResizable() && this.columnWeights[n] != 0.0) continue;
                    n2 += tableLayoutData.width;
                }
                for (n = 0; n < Math.min(tableColumnArray.length, this.columnWeights.length); ++n) {
                    if (!tableColumnArray[n].getResizable() || !(this.columnWeights[n] > 0.0)) continue;
                    n3 = (int)((double)(rectangle.width - n2) * this.columnWeights[n]);
                    tableColumnArray[n].setWidth(n3);
                }
                break block32;
            }
            if (composite instanceof Tree && (object = (TableLayout)(tree = (Tree)composite).getLayout()) != null) {
                TreeColumn[] treeColumnArray = tree.getColumns();
                n2 = 0;
                for (n = 0; n < Math.min(treeColumnArray.length, this.columnWeights.length); ++n) {
                    TableLayoutData tableLayoutData = (TableLayoutData)treeColumnArray[n].getData();
                    if (treeColumnArray[n].getResizable() && this.columnWeights[n] != 0.0) continue;
                    n2 += tableLayoutData.width;
                }
                for (n = 0; n < Math.min(treeColumnArray.length, this.columnWeights.length); ++n) {
                    if (!treeColumnArray[n].getResizable() || !(this.columnWeights[n] > 0.0)) continue;
                    n3 = (int)((double)(rectangle.width - n2) * this.columnWeights[n]);
                    treeColumnArray[n].setWidth(n3);
                }
            }
        }
    }

    private void initialize(Composite composite, Control[] controlArray) {
        int n;
        TableLayoutData tableLayoutData;
        int n2;
        this.sizes = new Point[controlArray.length];
        for (n2 = 0; n2 < controlArray.length; ++n2) {
            tableLayoutData = (TableLayoutData)controlArray[n2].getLayoutData();
            if (tableLayoutData == null) {
                throw new Error("no layout data for " + controlArray[n2] + ", parent " + controlArray[n2].getParent());
            }
            if (tableLayoutData.isVisible) {
                this.sizes[n2] = controlArray[n2].computeSize(-1, -1, true);
                if (tableLayoutData.width != -1) {
                    this.sizes[n2].x = tableLayoutData.width;
                }
                if (tableLayoutData.height != -1) {
                    this.sizes[n2].y = tableLayoutData.height;
                }
                if (tableLayoutData.minWidth != -1) {
                    this.sizes[n2].x = Math.max(this.sizes[n2].x, tableLayoutData.minWidth);
                }
                if (tableLayoutData.maxWidth != -1) {
                    this.sizes[n2].x = Math.min(this.sizes[n2].x, tableLayoutData.maxWidth);
                }
                if (tableLayoutData.minHeight != -1) {
                    this.sizes[n2].y = Math.max(this.sizes[n2].y, tableLayoutData.minHeight);
                }
                if (tableLayoutData.maxHeight == -1) continue;
                this.sizes[n2].y = Math.min(this.sizes[n2].y, tableLayoutData.maxHeight);
                continue;
            }
            this.sizes[n2] = new Point(0, 0);
        }
        this.rows = 0;
        this.columns = 0;
        for (n2 = 0; n2 < controlArray.length; ++n2) {
            tableLayoutData = (TableLayoutData)controlArray[n2].getLayoutData();
            assert (tableLayoutData.rowSpawn >= 1);
            assert (tableLayoutData.columnSpawn >= 1);
            this.rows = Math.max(this.rows, tableLayoutData.row + tableLayoutData.rowSpawn);
            this.columns = Math.max(this.columns, tableLayoutData.column + tableLayoutData.columnSpawn);
        }
        this.rowExpandFlags = new boolean[this.rows];
        this.columnExpandFlags = new boolean[this.columns];
        for (n2 = 0; n2 < controlArray.length; ++n2) {
            tableLayoutData = (TableLayoutData)controlArray[n2].getLayoutData();
            assert (tableLayoutData.rowSpawn >= 1);
            assert (tableLayoutData.columnSpawn >= 1);
            for (n = tableLayoutData.column; n < Math.min(tableLayoutData.column + 1, this.columns); ++n) {
                int n3 = n;
                this.columnExpandFlags[n3] = this.columnExpandFlags[n3] | (tableLayoutData.style & 8) == 8;
            }
            for (n = tableLayoutData.row; n < Math.min(tableLayoutData.row + 1, this.rows); ++n) {
                int n4 = n;
                this.rowExpandFlags[n4] = this.rowExpandFlags[n4] | (tableLayoutData.style & 2) == 2;
            }
        }
        if (composite instanceof Table) {
            this.columnWeights = this.getWeights(this.columnWeight, this.columnWeights, ((Table)composite).getColumnCount(), this.columnExpandFlags);
        } else if (controlArray.length > 0) {
            this.rowWeights = this.getWeights(this.rowWeight, this.rowWeights, this.rows, this.rowExpandFlags);
            this.columnWeights = this.getWeights(this.columnWeight, this.columnWeights, this.columns, this.columnExpandFlags);
        }
        this.normalizeWeights(this.rowWeights);
        this.normalizeWeights(this.columnWeights);
        this.rowSizeHints = new int[this.rows];
        this.columnSizeHints = new int[this.columns];
        this.rowSizeMin = new int[this.rows];
        this.columnSizeMin = new int[this.columns];
        for (n2 = 0; n2 < controlArray.length; ++n2) {
            int n5;
            int n6;
            tableLayoutData = (TableLayoutData)controlArray[n2].getLayoutData();
            assert (tableLayoutData.rowSpawn >= 1);
            assert (tableLayoutData.columnSpawn >= 1);
            n = tableLayoutData.padX + this.sizes[n2].x / tableLayoutData.columnSpawn + tableLayoutData.padX;
            int n7 = tableLayoutData.padY + this.sizes[n2].y / tableLayoutData.rowSpawn + tableLayoutData.padY;
            int n8 = 0;
            int n9 = 0;
            double d = 0.0;
            double d2 = 0.0;
            for (n6 = tableLayoutData.column; n6 < Math.min(tableLayoutData.column + tableLayoutData.columnSpawn, this.columns); ++n6) {
                n8 += this.columnSizeHints[n6];
                d += this.columnWeights[n6];
            }
            for (n6 = tableLayoutData.row; n6 < Math.min(tableLayoutData.row + tableLayoutData.rowSpawn, this.rows); ++n6) {
                n9 += this.rowSizeHints[n6];
                d2 += this.rowWeights[n6];
            }
            n6 = Math.max((int)((double)(n - n8) * d), 0);
            int n10 = Math.max((int)((double)(n7 - n9) * d2), 0);
            for (n5 = tableLayoutData.row; n5 < Math.min(tableLayoutData.row + 1, this.rows); ++n5) {
                if (n5 + 1 >= tableLayoutData.rowSpawn) {
                    this.rowSizeHints[n5] = Math.max(this.rowSizeHints[n5] + n10, n7);
                }
                this.rowSizeMin[n5] = Math.max(this.rowSizeMin[n5], tableLayoutData.minHeight);
            }
            for (n5 = tableLayoutData.column; n5 < Math.min(tableLayoutData.column + 1, this.columns); ++n5) {
                if (n5 + 1 >= tableLayoutData.columnSpawn) {
                    this.columnSizeHints[n5] = Math.max(this.columnSizeHints[n5] + n6, n);
                }
                this.columnSizeMin[n5] = Math.max(this.columnSizeMin[n5], tableLayoutData.minWidth);
            }
        }
        this.totalWidth = this.marginLeft + this.marginRight;
        this.totalHeight = this.marginTop + this.marginBottom;
        for (n2 = 0; n2 < this.rows; ++n2) {
            this.totalHeight += Math.max(this.rowSizeHints[n2], this.rowSizeMin[n2]) + (n2 < this.rows - 1 ? this.horizontalSpacing : 0);
        }
        for (n2 = 0; n2 < this.columns; ++n2) {
            this.totalWidth += Math.max(this.columnSizeHints[n2], this.columnSizeMin[n2]) + (n2 < this.columns - 1 ? this.verticalSpacing : 0);
        }
    }

    private boolean checkInitializeRequired(Control[] controlArray) {
        return this.rowWeights == null || this.rowWeights.length != controlArray.length || this.rowWeights == null || this.rowWeights.length != controlArray.length || this.sizes == null || this.sizes.length != controlArray.length;
    }

    private double[] getWeights(double d, double[] dArray, int n, boolean[] blArray) {
        if (dArray == null || dArray.length != n) {
            double[] dArray2 = new double[n];
            if (dArray != null) {
                System.arraycopy(dArray, 0, dArray2, 0, Math.min(dArray.length, n));
                if (dArray2.length > dArray.length) {
                    Arrays.fill(dArray2, dArray.length, dArray2.length, d);
                }
            } else {
                Arrays.fill(dArray2, d);
            }
            dArray = dArray2;
        }
        return dArray;
    }

    private void normalizeWeights(double[] dArray) {
        if (dArray != null) {
            int n;
            double d = 0.0;
            for (n = 0; n < dArray.length; ++n) {
                d += dArray[n];
            }
            if (d > 0.0) {
                for (n = 0; n < dArray.length; ++n) {
                    dArray[n] = dArray[n] / d;
                }
            }
        }
    }
}

